/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.model.CustomQuery;
import com.hotent.form.model.RestfulQueryParam;
import com.hotent.form.persistence.manager.CustomQueryManager;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.vo.CustomQueryControllerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/customQuery/v1"})
@Api(tags={"\u5173\u8054\u6570\u636e"})
@ApiGroup(group={"group_form"})
public class CustomQueryController
extends BaseController<CustomQueryManager, CustomQuery> {
    @Autowired
    CustomQueryManager customQueryManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ResourcePermissionCheck
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody Optional<QueryFilter<CustomQuery>> queryFilter) throws Exception {
        QueryFilter<CustomQuery> filter = queryFilter.orElse((QueryFilter<CustomQuery>)QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)));
        if (BeanUtils.isEmpty((Object)filter.getPageBean())) {
            filter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        }
        return ((CustomQueryManager)this.baseService).query(filter);
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="POST", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CustomQuery getByAlias(@ApiParam(name="alias", value="\u522b\u540d") @RequestBody String alias) {
        return ((CustomQueryManager)this.baseService).getByAlias(alias);
    }

    @RequestMapping(value={"customQueryGet"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CustomQuery get(@ApiParam(name="id", value="\u4e3b\u952e") @RequestBody String id) throws Exception {
        return (CustomQuery)((CustomQueryManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"saveDialogByQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5173\u8054\u67e5\u8be2\u6dfb\u52a0\u4e3a\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u5173\u8054\u67e5\u8be2\u6dfb\u52a0\u4e3a\u5bf9\u8bdd\u6846")
    public CommonResult saveDialogByQuery(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606fjson\u5bf9\u8c61") @RequestBody String json) throws Exception {
        CommonResult res = this.customQueryManager.saveDialogByQuery(json);
        return res;
    }

    @RequestMapping(value={"saveQueryByDialog"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bf9\u8bdd\u6846\u6dfb\u52a0\u4e3a\u5173\u8054\u67e5\u8be2", httpMethod="POST", notes="\u5bf9\u8bdd\u6846\u6dfb\u52a0\u4e3a\u5173\u8054\u67e5\u8be2")
    public CommonResult saveQueryByDialog(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606fjson\u5bf9\u8c61") @RequestBody String json) throws Exception {
        CommonResult res = this.customQueryManager.saveQueryByDialog(json);
        return res;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606fjson\u5bf9\u8c61") @RequestBody String json) throws Exception {
        CommonResult res = this.customQueryManager.saveCustomQuery(json);
        return res;
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CommonResult removes(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        ((CustomQueryManager)this.baseService).removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f\u6210\u529f", null);
    }

    @RequestMapping(value={"getByDsObjectName"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u6216\u89c6\u56fe\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u8868\u6216\u89c6\u56fe\u5217\u8868")
    public ArrayNode getByDsObjectName(@ApiParam(name="vo", value="") @RequestBody CustomQueryControllerVo vo) throws Exception {
        return ((CustomQueryManager)this.baseService).getTableOrViewByDsName(vo);
    }

    @RequestMapping(value={"getTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u8868\u5bf9\u8c61", httpMethod="POST", notes="\u83b7\u5f97\u8868\u5bf9\u8c61")
    public ObjectNode getTable(@ApiParam(name="vo", value="") @RequestBody CustomQueryControllerVo vo, @ApiParam(name="flag", value="\u8868\u4e3b\u952e\u7c7b\u578b\u957f\u5ea6\u662f\u5426\u5141\u8bb8\u5c0f\u4e8e19") @RequestParam Optional<Boolean> flag) throws Exception {
        ObjectNode res = this.customQueryManager.getTable(vo, flag);
        return res;
    }

    @RequestMapping(value={"doQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="POST", notes="")
    public PageList doQuery(@ApiParam(name="alias", value="\u522b\u540d", required=false) @RequestParam(required=false) Optional<String> alias, @ApiParam(name="queryData", value="") @RequestBody Optional<String> queryData, @ApiParam(name="page", value="", required=false) @RequestParam(required=false) Optional<Integer> page) throws Exception {
        return this.customQueryManager.doQuery(alias, queryData, page);
    }

    @RequestMapping(value={"doCustomQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="POST", notes="")
    public Object doCustomQuery(@ApiParam(name="alias", value="\u522b\u540d", required=false) @RequestParam(required=false) Optional<String> alias, @ApiParam(name="queryData", value="") @RequestBody Optional<String> queryData, @ApiParam(name="page", value="", required=false) @RequestParam(required=false) Optional<Integer> page) throws Exception {
        return this.customQueryManager.doCustomQuery(alias, queryData, page);
    }

    @RequestMapping(value={"doQueryBase64"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="GET", notes="")
    public PageList doQueryBase64(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias, @ApiParam(name="queryData", value="") @RequestParam String queryData, @ApiParam(name="page", value="") @RequestParam Integer page) throws Exception {
        return this.customQueryManager.doQueryBase64(alias, queryData, page);
    }

    @PostMapping(value={"doQueryByRest"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7REST\u63a5\u53e3\u8bf7\u6c42\u6570\u636e", httpMethod="POST", notes="\u901a\u8fc7REST\u63a5\u53e3\u8bf7\u6c42\u6570\u636e")
    public JsonNode doQueryByRest(@RequestBody @ApiParam(name="queryParam", value="\u63a5\u53e3\u8bf7\u6c42\u6570\u636e") @Validated RestfulQueryParam queryParam) throws Exception {
        return ((CustomQueryManager)this.baseService).doQueryByRest(queryParam);
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u6240\u6709\u7684\u8868\u5bf9\u8c61", httpMethod="GET", notes="\u53d6\u5f97\u6240\u6709\u7684\u8868\u5bf9\u8c61")
    public List<CustomQuery> getAll() throws Exception {
        List customQuerys = ((CustomQueryManager)this.baseService).list();
        CustomUtil.filterHasNoUseRight(customQuerys);
        return customQuerys;
    }

    @RequestMapping(value={"getQueryPage"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="GET", notes="")
    public PageList getQueryPage(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias) throws Exception {
        return this.customQueryManager.getQueryPage(alias);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "customQuery_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = ((CustomQueryManager)this.baseService).export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"customQuery.json", (String)fileName);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2")
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult<String> res = this.customQueryManager.importCustom(request, response, typeId);
        return res;
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2")
    public CommonResult<String> importData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath, @ApiParam(name="status", value="status", required=true) @RequestParam String status, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult res = this.customQueryManager.importFileData(unZipFilePath, status, typeId);
        return res;
    }

    @PostMapping(value={"exportQueryByRest"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u6570\u636e")
    public void exportQueryByRest(@RequestBody @ApiParam(name="queryParam", value="\u63a5\u53e3\u8bf7\u6c42\u6570\u636e") @Validated RestfulQueryParam queryParam, HttpServletResponse response) throws Exception {
        ((CustomQueryManager)this.baseService).exportQueryByRest(queryParam, response);
    }
}

