/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.controller.BaseController;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.manager.BaseManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.base.vo.BatchCommonParam;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormHistory;
import com.hotent.form.model.FormHistoryRecord;
import com.hotent.form.model.FormMeta;
import com.hotent.form.param.CopyFormVo;
import com.hotent.form.param.FormPreviewDataParam;
import com.hotent.form.param.GenerateExpandParam;
import com.hotent.form.persistence.manager.FormHistoryManager;
import com.hotent.form.persistence.manager.FormHistoryRecordManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.util.JsoupUtil;
import com.hotent.form.vo.BpmFormVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/form/v1"})
@Api(tags={"\u8868\u5355\u7ba1\u7406"})
@ApiGroup(group={"group_form"})
public class FormController
extends BaseController<FormManager, Form> {
    @Resource
    FormHistoryManager bpmFormHistoryManager;
    @Resource
    BpmModelFeignService bpmModelFeignService;
    @Resource
    BoDefManager bODefManager;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormHistoryRecordManager formHistoryRecordManager;
    @Autowired
    FormManager formManager;
    @Autowired
    BaseManager<Form> baseManager;

    @PostMapping(value={"exportFormSub"})
    @ApiOperation(value="\u5bfc\u51fa", httpMethod="POST", notes="\u5bfc\u51fa")
    public void exportFormSub(@ApiParam(name="subDesc", value="\u5b50\u8868\u540d\u79f0") @RequestParam String subDesc, @RequestBody List<Map<String, String>> list, HttpServletResponse response) throws Exception {
        this.formManager.exportFormSub(subDesc, response, list);
    }

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e \u4e3b\u7248\u672c", httpMethod="POST", notes="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResourcePermissionCheck
    public PageList<Form> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestParam Optional<String> formType, @ApiParam(name="status", value="\u662f\u5426\u53d1\u5e03") @RequestParam Optional<String> status, @ApiParam(name="pcFormKey", value="pc\u7aef\u8868\u5355key\uff0c\u67e5\u8be2\u624b\u673a\u8868\u5355\u65f6\u7528\u5230\uff0c\u4f1a\u67e5\u8be2\u548cpc\u8868\u5355bo\u5339\u914d\u7684\u8868\u5355") @RequestParam Optional<String> pcFormKey) throws Exception {
        PageList<Form> res = this.formManager.listJson(queryFilter, formType, status, pcFormKey);
        return res;
    }

    @RequestMapping(value={"formEdit"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u8868\u5355HTML", httpMethod="POST", notes="\u751f\u6210\u8868\u5355HTML")
    public Form edit(@ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eid") @RequestBody String defId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestBody String formType, @ApiParam(name="id", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355Id") @RequestBody String id, @ApiParam(name="tableNames", value="\u4e3b\u6a21\u677f") @RequestBody String tableNames, @ApiParam(name="templateAlias", value="\u590d\u5408\u5b57\u6bb5\u6a21\u677f") @RequestBody String templateAlias) throws Exception {
        Form res = this.formManager.edit(defId, formType, id, tableNames, templateAlias);
        return res;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9")
    public CommonResult save(@ApiParam(name="form", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 entity\u5bf9\u8c61") @RequestBody Form form) throws Exception {
        if (StringUtil.isEmpty((String)form.getId())) {
            List<Form> bpmForm = ((FormManager)this.baseService).getByFormKey(form.getFormKey());
            if (BeanUtils.isNotEmpty(bpmForm)) {
                throw new RuntimeException("KEY\u3010" + form.getFormKey() + "\u3011\u5bf9\u5e94\u7684\u8868\u5355\u5df2\u5b58\u5728");
            }
            form.setId(UniqueIdUtil.getSuid());
            ((FormManager)this.baseService).create((Model)form);
        } else {
            if ("pc".equals(form.getFormType())) {
                CustomUtil.checkEditRight(Form.class, ResourceModelType.PC_FORM, form.getFormKey());
            } else {
                CustomUtil.checkEditRight(Form.class, ResourceModelType.MOBILE_FORFM, form.getFormKey());
            }
            ((FormManager)this.baseService).update((Model)form);
        }
        FormHistory bpmFormDefHi = new FormHistory(form);
        this.bpmFormHistoryManager.create((Model)bpmFormDefHi);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", null);
    }

    @RequestMapping(value={"saveDesign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9")
    public CommonResult saveDesign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String formData = FileUtil.inputStream2String((InputStream)request.getInputStream());
        ((FormManager)this.baseService).saveDesign(formData);
        String msg = "\u4fdd\u5b58\u6210\u529f";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"saveFormDesign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9")
    public CommonResult saveFormDesign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String formData = FileUtil.inputStream2String((InputStream)request.getInputStream());
        ((FormManager)this.baseService).saveDesign(formData);
        String msg = "\u4fdd\u5b58\u6210\u529f";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"saveForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9")
    public CommonResult saveForm(@ApiParam(name="bpmFormVo", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestBody BpmFormVo bpmFormVo) throws Exception {
        ((FormManager)this.baseService).saveFormDef(bpmFormVo);
        String msg = "\u751f\u6210\u8868\u5355\u6210\u529f";
        if ("newForm".equals(bpmFormVo.getNewForm())) {
            msg = "\u53d1\u5e03\u65b0\u7248\u672c\u6210\u529f";
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("rev", bpmFormVo.getBpmFormDef().getRev());
        value.put("formData", (Object)bpmFormVo.getBpmForm());
        return new CommonResult(true, msg, value);
    }

    @RequestMapping(value={"pcForm2MobileForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="pc\u8868\u5355\u8f6c\u6362\u4e3a\u624b\u673a\u8868\u5355", httpMethod="POST", notes="pc\u8868\u5355\u8f6c\u6362\u4e3a\u624b\u673a\u8868\u5355")
    public CommonResult pcForm2MobileForm(@ApiParam(name="formId", value="\u8868\u5355\u8bbe\u8ba1Id") @RequestParam String formId) throws Exception {
        ((FormManager)this.baseService).pcForm2MobileForm(formId);
        String msg = "\u751f\u6210\u624b\u673a\u8868\u5355\u6210\u529f,\u8bf7\u5728\u624b\u673a\u8868\u5355\u4e2d\u67e5\u770b";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"pcUpdateMobileForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="pc\u8868\u5355\u66f4\u65b0\u624b\u673a\u8868\u5355", httpMethod="POST", notes="pc\u8868\u5355\u66f4\u65b0\u624b\u673a\u8868\u5355")
    public CommonResult pcUpdateMobileForm(@ApiParam(name="formId", value="\u8868\u5355\u8bbe\u8ba1Id") @RequestParam String formId) throws Exception {
        ((FormManager)this.baseService).pcUpdateMobileForm(formId);
        String msg = "\u66f4\u65b0\u624b\u673a\u8868\u5355\u6210\u529f,\u8bf7\u5728\u624b\u673a\u8868\u5355\u4e2d\u67e5\u770b";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"checkMobileForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5pc\u8868\u5355\u662f\u5426\u6709\u624b\u673a\u8868\u5355", httpMethod="POST", notes="\u68c0\u67e5pc\u8868\u5355\u662f\u5426\u6709\u624b\u673a\u8868\u5355")
    public CommonResult checkMobileForm(@ApiParam(name="formId", value="\u8868\u5355\u8bbe\u8ba1Id") @RequestParam String formId) throws Exception {
        return ((FormManager)this.baseService).checkMobileForm(formId);
    }

    @RequestMapping(value={"generateFrom"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cd\u65b0\u751f\u6210\u8868\u5355", httpMethod="POST", notes="\u91cd\u65b0\u751f\u6210\u8868\u5355")
    public CommonResult generateFrom(@ApiParam(name="bpmFormVo", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestBody BpmFormVo bpmFormVo) throws Exception {
        ((FormManager)this.baseService).generateFrom(bpmFormVo);
        String msg = "\u4fdd\u5b58\u6210\u529f";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"getBpmFormById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u83b7\u53d6form\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u83b7\u53d6form\u6570\u636e")
    public BpmFormVo generateFrom(@ApiParam(name="bpmForm", value="\u8868\u5355\u6570\u636e") @RequestParam String id, @ApiParam(name="bpmFormDef", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestParam String defId) throws Exception {
        Form bpmForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)id));
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
        BpmFormVo bpmFormVo = new BpmFormVo();
        bpmFormVo.setBpmForm(bpmForm);
        bpmFormVo.setBpmFormDef(bpmFormDef);
        return bpmFormVo;
    }

    @RequestMapping(value={"saveFormJs"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355\u7684\u81ea\u5b9a\u4e49\u811a\u672c", httpMethod="POST", notes="\u66f4\u65b0\u8868\u5355\u7684\u81ea\u5b9a\u4e49\u811a\u672c")
    public CommonResult<String> saveFormJs(@ApiParam(name="map", value="\u66f4\u65b0\u6570\u636e") @RequestBody Map<String, Object> map) throws Exception {
        return this.formManager.saveFormJs(map);
    }

    @RequestMapping(value={"saveCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u8868\u5355\u4fe1\u606f", httpMethod="POST", notes="\u590d\u5236\u8868\u5355\u4fe1\u606f")
    public CommonResult saveCopy(@ApiParam(name="form", value="\u8868\u5355\u5143\u6570\u636e\u5bf9\u8c61") @RequestBody Form form) throws Exception {
        CommonResult res = this.formManager.saveCopy(form);
        return res;
    }

    @RequestMapping(value={"savePrintTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u8868\u5355\u6253\u5370\u6a21\u677f", httpMethod="POST", notes="\u6dfb\u52a0\u8868\u5355\u6253\u5370\u6a21\u677f")
    public CommonResult<String> savePrintTemplate(@ApiParam(name="form", value="\u8868\u5355\u5143\u6570\u636e\u5bf9\u8c61") @RequestBody Form form) throws Exception {
        return ((FormManager)this.baseService).savePrintTemplate(form);
    }

    @RequestMapping(value={"checkKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) throws Exception {
        List<Form> bpmForm = ((FormManager)this.baseService).getByFormKey(key);
        return bpmForm.size() > 0;
    }

    @RequestMapping(value={"getDefaultKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5efa\u6a21\u83b7\u53d6\u9ed8\u8ba4\u522b\u540d", httpMethod="GET", notes="\u6839\u636e\u5efa\u6a21\u83b7\u53d6\u9ed8\u8ba4\u522b\u540d")
    public CommonResult<String> getDefaultKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) {
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)((FormManager)this.baseService).getDefaultKeyByFormKey(key));
    }

    @RequestMapping(value={"checkPrintKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u8868\u5355\u6253\u5370\u6a21\u677f\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkPrintKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) throws Exception {
        List<Form> bpmForm = ((FormManager)this.baseService).getPrintByFormKey(key);
        return bpmForm.size() > 0;
    }

    @GetMapping(value={"getFormHistoryRecord"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9", httpMethod="GET", notes="\u6839\u636e\u4e3b\u952eID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9")
    public FormHistoryRecord getFormHistoryRecord(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (FormHistoryRecord)this.formHistoryRecordManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"updateFormHistoryRecord"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6062\u590d\u5230\u8868\u5355\u5386\u53f2\u6570\u636e", httpMethod="GET", notes="\u6062\u590d\u5230\u8868\u5355\u5386\u53f2\u6570\u636e")
    public CommonResult<String> updateFormHistoryRecord(@ApiParam(name="id", value="\u4e3b\u952eID") @RequestParam String id) throws Exception {
        FormHistoryRecord formHistoryRecord = (FormHistoryRecord)this.formHistoryRecordManager.get((Serializable)((Object)id));
        CommonResult<String> stringCommonResult = ((FormManager)this.baseService).updateFormHistoryRecord(formHistoryRecord);
        return stringCommonResult;
    }

    @RequestMapping(value={"getFormHtmlByFormId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\uff08\u8868\u5355HTML\u6570\u636e\u5386\u53f2\u8bb0\u5f55\uff09", httpMethod="GET", notes="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\uff08\u8868\u5355HTML\u6570\u636e\u5386\u53f2\u8bb0\u5f55\uff09")
    public FormHistoryRecord getFormHtmlByFormId(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        List<FormHistoryRecord> formHistoryRecord = this.formHistoryRecordManager.getFormHtmlByFormId(formId);
        return formHistoryRecord.get(0);
    }

    @RequestMapping(value={"formHistoryRecordlistJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<FormHistoryRecord> formHistoryRecordlistJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        FieldSort fieldSort = new FieldSort("createTime", Direction.DESC);
        queryFilter.withSorter(fieldSort);
        return this.formHistoryRecordManager.query(queryFilter);
    }

    @DeleteMapping(value={"delFormHistoryRecord"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\u5220\u9664\u8bb0\u5f55", httpMethod="DELETE", notes="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\u5220\u9664\u8bb0\u5f55")
    public CommonResult<String> delFormHistoryRecord(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e") @RequestParam String id) throws Exception {
        this.formHistoryRecordManager.remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"delFormHistoryRecordByIds"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\u5220\u9664\u8bb0\u5f55\uff08\u6279\u91cf\u5220\u9664\uff09", httpMethod="DELETE", notes="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\u5220\u9664\u8bb0\u5f55\uff08\u6279\u91cf\u5220\u9664\uff09")
    public CommonResult<String> delFormHistoryRecordByIds(@ApiParam(name="ids", value="\u4e1a\u52a1\u4e3b\u952e") @RequestParam String ids) throws Exception {
        Assert.notNull((Object)ids, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e.");
        this.formHistoryRecordManager.removeByIds(ids.split(","));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"previewDesignVue"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="Vue\u8868\u5355\u9884\u89c8", httpMethod="GET", notes="\u8868\u5355\u9884\u89c8")
    public Object previewDesignVue(@ApiParam(name="formId", value="\u8868\u5355id") @RequestParam String formId) throws Exception {
        return ((FormManager)this.baseService).getPreviewDesignVueData(formId, null);
    }

    @RequestMapping(value={"previewTemplate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u6a21\u7248\u9884\u89c8", httpMethod="GET", notes="\u6839\u636e\u8868\u5355\u6a21\u7248\u9884\u89c8")
    public Object previewTemplate(@ApiParam(name="formId", value="\u8868\u5355\u6a21\u7248id") @RequestParam String formId, @ApiParam(name="formKeyRelation", value="\u8868\u5355\u6a21\u7248\u76f8\u5173\u8054\u7684\u8868\u5355key") @RequestParam String formKeyRelation) throws Exception {
        return ((FormManager)this.baseService).getPreviewDesignVueData(formId, formKeyRelation);
    }

    @RequestMapping(value={"previewDesign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u9884\u89c8", httpMethod="POST", notes="\u8868\u5355\u9884\u89c8")
    public Object previewDesign(@ApiParam(name="param", value="\u8868\u5355\u9884\u89c8") @RequestBody FormPreviewDataParam param) throws Exception {
        return ((FormManager)this.baseService).getPreviewDesignData(param);
    }

    @RequestMapping(value={"previewDesignTemp"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="Vue\u8868\u5355\u9884\u89c8\uff08\u672a\u4fdd\u5b58\uff09", httpMethod="GET", notes="\u8868\u5355\u9884\u89c8\uff08\u672a\u4fdd\u5b58\uff09")
    public Object previewDesignTemp(@ApiParam(name="cacheId", value="\u7f13\u5b58\u6807\u8bc6") @RequestParam String cacheId) throws Exception {
        String content = ((FormManager)this.baseService).getFormFromCache(cacheId);
        if (StringUtil.isNotEmpty((String)content)) {
            BpmFormVo bpmFormVo = (BpmFormVo)JsonUtil.toBean((String)content, BpmFormVo.class);
            return ((FormManager)this.baseService).getPreviewDesignVueData(bpmFormVo);
        }
        throw new RuntimeException("\u8868\u5355\u9884\u89c8\u7f13\u5b58\u6807\u8bc6\u5df2\u8fc7\u671f\uff01");
    }

    @RequestMapping(value={"saveFormOnCache"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5230\u7f13\u5b58\u4e2d", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5230\u7f13\u5b58\u4e2d")
    public CommonResult saveFormOnCache(@ApiParam(name="bpmFormVo", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestBody BpmFormVo bpmFormVo) throws Exception {
        String cacheId = ContextUtil.getCurrentUserId() + "_" + TimeUtil.getCurrentTimeMillis() + String.valueOf(new Random().nextInt(90000) + 10000);
        ((FormManager)this.baseService).saveFormOnCache(cacheId, JsonUtil.toJsonString((Object)bpmFormVo));
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)cacheId);
    }

    @RequestMapping(value={"listVersions"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u7684\u6240\u6709\u7248\u672c", httpMethod="POST", notes="\u67e5\u8be2\u8868\u5355\u7684\u6240\u6709\u7248\u672c")
    public PageList<Form> listVersions(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((FormManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"getFormById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u83b7\u53d6\u8868\u5355\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636e\u8868\u5355ID\u83b7\u53d6\u8868\u5355\u660e\u7ec6")
    public Form getFormById(@ApiParam(name="id", value="\u8868\u5355ID") @RequestParam String id) throws Exception {
        Form bpmForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)id));
        return bpmForm;
    }

    @RequestMapping(value={"getMainByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355Key\u83b7\u53d6\u4e3b\u7248\u672c", httpMethod="GET", notes="\u6839\u636e\u8868\u5355Key\u83b7\u53d6\u4e3b\u7248\u672c")
    public Form getMainByAlias(@ApiParam(name="alias", value="\u8868\u5355ID") @RequestParam String alias) throws Exception {
        return ((FormManager)this.baseService).getMainByFormKey(alias);
    }

    @RequestMapping(value={"preview"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u4fe1\u606f\u660e\u7ec6", httpMethod="POST", notes="\u8868\u5355\u4fe1\u606f\u660e\u7ec6")
    public Form preview(@ApiParam(name="id", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 ID") @RequestBody String id, @ApiParam(name="formKey", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 KEY") @RequestBody String formKey, @ApiParam(name="formType", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u7c7b\u578b") @RequestBody String formType, @ApiParam(name="formHtml", value=" \u8868\u5355\u8bbe\u8ba1\uff08HTML\u4ee3\u7801\uff09") @RequestBody String formHtml) throws Exception {
        Form form = this.formManager.preView(id, formKey, formType, formHtml);
        return form;
    }

    @RequestMapping(value={"getRight"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public JsonNode getRight(@ApiParam(name="id", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 ID") @RequestBody String id, @ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eId") @RequestBody String defId, @ApiParam(name="formType", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u7c7b\u578b") @RequestBody String formType) throws Exception {
        return ((FormManager)this.baseService).getRightData(id, defId, formType);
    }

    @RequestMapping(value={"getBoData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5143\u6570\u636eID\u83b7\u53d6bo\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u8868\u5355\u5143\u6570\u636eID\u83b7\u53d6bo\u6570\u636e")
    public ArrayNode getBoData(@ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eId") @RequestBody String defId) throws Exception {
        List<BoData> boDatas = this.formMetaManager.getBoDataByFormDefId(defId);
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty(boDatas)) {
            arrayNode = JsonUtil.listToArrayNode(boDatas);
        }
        return arrayNode;
    }

    @RequestMapping(value={"getBoJsonByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6boJosn\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6boJosn\u6570\u636e")
    public ArrayNode getBoJsonByFormKey(@ApiParam(name="formkey", value="\u8868\u5355key", required=true) @RequestParam String formkey) throws Exception {
        FormMeta formDef = this.formMetaManager.getByKey(formkey);
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)((Object)formDef))) {
            List<String> boDefCodes = this.formMetaManager.getBOCodeByFormId(formDef.getId());
            for (String defCode : boDefCodes) {
                ObjectNode boJson = this.bODefManager.getBOJsonByBoDefCode(defCode);
                arrayNode.add((JsonNode)boJson);
            }
        }
        return arrayNode;
    }

    @RequestMapping(value={"getBOCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", httpMethod="GET", notes="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801")
    public List<String> getBOCodes(@ApiParam(name="formId", value="\u8868\u5355\u5143\u6570\u636eId") @RequestParam String formId) throws Exception {
        return this.formMetaManager.getBOCodeByFormId(formId);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8868\u5355\u8bb0\u5f55")
    public CommonResult remove(@ApiParam(name="ids", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355ID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestParam(required=true) String ids) throws Exception {
        String bpmNames;
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        if (StringUtil.isEmpty((String)(bpmNames = this.checkBpmForm(aryIds)))) {
            ((FormManager)this.baseService).remove(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u6210\u529f", null);
        }
        String msg = "\u5220\u9664\u5931\u8d25\uff1a" + bpmNames;
        return new CommonResult(false, msg, null);
    }

    @RequestMapping(value={"removeVersions"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u975e\u4e3b\u7248\u672c\u7684\u8868\u5355\u7248\u672c", httpMethod="DELETE", notes="\u5220\u9664\u975e\u4e3b\u7248\u672c\u7684\u8868\u5355\u7248\u672c")
    public CommonResult removeVersions(@ApiParam(name="ids", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355ID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestParam(required=true) String ids) throws Exception {
        try {
            String[] aryIds = null;
            if (!StringUtil.isEmpty((String)ids)) {
                aryIds = ids.split(",");
            }
            ((FormManager)this.baseService).removeVersions(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25", null);
        }
    }

    public String checkBpmForm(String[] aryIds) {
        String msgs = "";
        for (String formId : aryIds) {
            Form bpmForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)formId));
            List<String> boDefs = this.formMetaManager.getBODefIdByFormId(bpmForm.getDefId());
            for (String boDefId : boDefs) {
                CommonResult result;
                BoDef boDef = (BoDef)this.bODefManager.get((Serializable)((Object)boDefId));
                if (boDef == null || !((Boolean)(result = this.bpmModelFeignService.isBoBindFlowCheck(boDef.getAlias(), bpmForm.getFormKey())).getValue()).booleanValue()) continue;
                msgs = msgs + "\u300e\u8868\u5355\u3010" + bpmForm.getName() + "\u3011" + result.getMessage() + "\u300f";
            }
        }
        return msgs;
    }

    @RequestMapping(value={"chooseDesignTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u8f7d\u7f16\u8f91\u5668\u8bbe\u8ba1\u6a21\u5f0f\u7684\u6a21\u677f\u5217\u8868", httpMethod="POST", notes="\u52a0\u8f7d\u7f16\u8f91\u5668\u8bbe\u8ba1\u6a21\u5f0f\u7684\u6a21\u677f\u5217\u8868")
    public Map chooseDesignTemplate(@ApiParam(name="subject", value="\u6807\u9898") @RequestBody String subject, @ApiParam(name="categoryId", value="") @RequestBody String categoryId, @ApiParam(name="formDesc", value="\u8868\u5355\u63cf\u8ff0") @RequestBody String formDesc, @ApiParam(name="isSimple", value="true\u5c06\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u884c") @RequestBody Boolean isSimple) throws Exception {
        return ((FormManager)this.baseService).getChooseDesignTemplate(subject, categoryId, formDesc, isSimple);
    }

    @RequestMapping(value={"genByTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u4ea7\u751fhtml\u3002", httpMethod="POST", notes="\u6839\u636e\u6a21\u677f\u4ea7\u751fhtml\u3002")
    public void genByTemplate(@ApiParam(name="formId", value="\u4e3b\u952e") @RequestBody String formId, @ApiParam(name="tableNames", value="\u4e3b\u6a21\u677f") @RequestBody String tableNames, @ApiParam(name="templateAlias", value="\u590d\u5408\u5b57\u6bb5\u6a21\u677f") @RequestBody String templateAlias, @ApiParam(name="formDefId", value="\u8868\u5355\u5143\u6570\u636eID") @RequestBody String formDefId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestBody String formType, HttpServletResponse response) throws Exception {
        ((FormManager)this.baseService).getGenByTemplate(formId, tableNames, templateAlias, formDefId, formType, response);
    }

    @RequestMapping(value={"newVersion"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5b9a\u4e49id\u521b\u5efa\u65b0\u7684\u8868\u5355\u7248\u672c", httpMethod="POST", notes="\u6839\u636e\u8868\u5355\u5b9a\u4e49id\u521b\u5efa\u65b0\u7684\u8868\u5355\u7248\u672c")
    public CommonResult newVersion(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestBody String formId) throws Exception {
        ((FormManager)this.baseService).newVersion(formId);
        return new CommonResult(true, "\u65b0\u5efa\u8868\u5355\u7248\u672c\u6210\u529f!", null);
    }

    @RequestMapping(value={"setDefaultVersion"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c", httpMethod="POST", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c")
    public CommonResult setDefaultVersion(@ApiParam(name="id", value="\u8868\u5355ID") @RequestParam String id, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey) throws Exception {
        ((FormManager)this.baseService).setDefaultVersion(id, formKey);
        ((FormManager)this.baseService).updatePermissionByKey(formKey);
        return new CommonResult(true, "\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c\u6210\u529f", null);
    }

    @RequestMapping(value={"publish"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03\u8868\u5355", httpMethod="POST", notes="\u53d1\u5e03\u8868\u5355")
    public CommonResult publish(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        ((FormManager)this.baseService).publish(formId);
        return new CommonResult(true, "\u53d1\u5e03\u7248\u672c\u6210\u529f", null);
    }

    @RequestMapping(value={"genByField"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u5b57\u6bb5\u7684html", httpMethod="POST", notes="\u751f\u6210\u5b57\u6bb5\u7684html")
    public void genByField(@ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eID") @RequestBody String defId, @ApiParam(name="attrId", value="BO\u5c5e\u6027ID") @RequestBody String attrId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestBody String formType, HttpServletResponse response) throws Exception {
        String html = ((FormManager)this.baseService).genByField(defId, attrId, formType);
        html = JsoupUtil.prettyHtml(html);
        PrintWriter out = response.getWriter();
        out.println(html);
    }

    @RequestMapping(value={"exportForm"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355xml", httpMethod="GET", notes="\u5bfc\u51fa\u8868\u5355xml")
    public void exportForm(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="formIds", value="\u8868\u5355id", required=true) @RequestParam String formIds) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)formIds)) {
            String[] ids = formIds.split(",");
            List<String> idList = Arrays.asList(ids);
            Map<String, String> map = ((FormManager)this.baseService).exportForms(idList, true, true);
            String fileName = "";
            String fullname = ContextUtil.getCurrentUser().getFullname();
            if (idList.size() == 1) {
                Form form = (Form)this.baseManager.get((Serializable)((Object)idList.get(0)));
                fileName = String.format("\u8868\u5355\u5bfc\u51fa_%s(%s)_%s%s", form.getName(), form.getFormKey(), fullname, DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
                if (fileName.length() > 123) {
                    fileName = fileName.substring(0, 120) + "...";
                }
            } else {
                fileName = String.format("\u6279\u91cf\u8868\u5355\u5bfc\u51fa\u6587\u4ef6_%s%s", fullname, DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
            }
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, map, (String)fileName);
        }
    }

    @RequestMapping(value={"exportData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355xml", httpMethod="GET", notes="\u5bfc\u51fa\u8868\u5355xml")
    public Map<String, String> exportData(String ... ids) throws Exception {
        return ((FormManager)this.baseService).exportForms(Arrays.asList(ids), true, true);
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u8868\u5355xml", httpMethod="GET", notes="\u5bfc\u51fa\u8868\u5355xml")
    public CommonResult<Map<String, String>> importData(@RequestBody Map<String, Object> obj, @RequestParam(value="status") String status, @RequestParam(value="typeId", required=false) String typeId) throws Exception {
        Map<String, String> map = ((FormManager)this.baseService).importData(obj, status, typeId);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f", map);
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165", required=false) @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id", required=false) @RequestParam Optional<String> cacheFileId) throws Exception {
        Object res = this.formManager.importSave(confirmImport, typeId, cacheFileId);
        return res;
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u5bfc\u5165\u524d\u6821\u9a8c", httpMethod="POST", notes="\u8868\u5355\u5bfc\u5165\u524d\u6821\u9a8c")
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId) throws Exception {
        CommonResult<String> res = this.formManager.importCheck(request, response, typeId);
        return res;
    }

    @RequestMapping(value={"importCheck1"}, method={RequestMethod.POST})
    public List<ImportCheckResult> importFormCheck(@RequestBody Map<String, Object> obj) throws JAXBException, UnsupportedEncodingException {
        try {
            return this.formManager.importFormCheck(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"formDesign"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f")
    public Object formDesign(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        return ((FormManager)this.baseService).getFormDesign(formId);
    }

    @RequestMapping(value={"getSubEntsByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002", httpMethod="GET", notes="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002")
    public List<BoEnt> getSubEntsByFormKey(@ApiParam(name="formKey", value="\u7ec4\u4ef6key") @RequestParam String formKey) throws Exception {
        List<BoEnt> list = null;
        if (StringUtil.isNotEmpty((String)formKey)) {
            list = this.formMetaManager.getChildrenByFormKey(formKey);
            list.forEach(boEnt -> boEnt.setShowChildEntList(boEnt.getChildEntList()));
        }
        return list;
    }

    @RequestMapping(value={"getBindRelation"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u7ed1\u5b9a\u5173\u7cfb\u3002", httpMethod="GET", notes="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002")
    public Map<String, Object> getBindRelation(@ApiParam(name="defId", value="\u8868\u5355defId") @RequestParam String defId, @ApiParam(name="formKey", value="\u8868\u5355formKey") @RequestParam String formKey, @ApiParam(name="formId", value="\u8868\u5355id") @RequestParam(required=false) String formId) throws Exception {
        return ((FormManager)this.baseService).getBindRelation(defId, formKey, formId);
    }

    @RequestMapping(value={"getFormData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u83b7\u53d6\u8868\u5355\u4fe1\u606f", httpMethod="GET", notes="\u53d6\u5f97\u6240\u6709\u7684\u8868\u5bf9\u8c61")
    public Map<String, Object> getFormData(@ApiParam(name="pcAlias", value="pc\u522b\u540d") @RequestParam(required=false) String pcAlias, @ApiParam(name="mobileAlias", value="mobile\u522b\u540d") @RequestParam(required=false) String mobileAlias) throws Exception {
        return ((FormManager)this.baseService).getFormData(pcAlias, mobileAlias);
    }

    @RequestMapping(value={"generateExpand"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u8868\u5355\u6a21\u677f\u6570\u636e", httpMethod="POST", notes="\u751f\u6210\u8868\u5355\u6a21\u677f\u6570\u636e")
    public CommonResult<String> generateExpand(@ApiParam(name="generateExpandParam", value="\u8868\u5355ID") @RequestBody GenerateExpandParam params) throws Exception {
        return ((FormManager)this.baseService).generateExpand(params);
    }

    @RequestMapping(value={"generateBoTreeData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u8868\u5355bo\u6811\u7ed3\u6784\u6570\u636e", httpMethod="GET", notes="\u751f\u6210\u8868\u5355bo\u6811\u7ed3\u6784\u6570\u636e")
    public CommonResult<String> generateBoTreeData(@ApiParam(name="boDefIds", value="bo\u5b9a\u4e49id\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u5206\u9694") @RequestParam Optional<String> boDefIds, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam Optional<String> formKey) throws Exception {
        String boIds = "";
        if (StringUtil.isNotEmpty((String)boDefIds.orElse(""))) {
            boIds = boDefIds.get();
        }
        if (StringUtil.isEmpty((String)boIds) && StringUtil.isNotEmpty((String)formKey.orElse(""))) {
            Form bpmForm = ((FormManager)this.baseService).getMainByFormKey(formKey.get());
            Assert.notNull((Object)((Object)bpmForm), (String)String.format("\u6839\u636eformKey:%s\u672a\u67e5\u8be2\u5230\u8868\u5355", formKey.get()));
            List<String> boDefs = this.formMetaManager.getBODefIdByFormId(bpmForm.getDefId());
            boIds = StringUtil.join(boDefs);
        }
        return ((FormManager)this.baseService).generateBoTreeData(boIds);
    }

    @RequestMapping(value={"getRelationList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u5feb\u901f\u590d\u7528\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e \u4e3b\u7248\u672c", httpMethod="POST", notes="\u8868\u5355\u5feb\u901f\u590d\u7528\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<CopyFormVo> getRelationList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="boDefIds", value="\u5173\u8054bo\u5b9a\u4e49\uff08\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694\uff09") @RequestParam String boDefIds, @ApiParam(name="id", value="\u8868\u5355id") @RequestParam Optional<String> id, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestParam Optional<String> formType, @ApiParam(name="status", value="\u662f\u5426\u53d1\u5e03") @RequestParam Optional<String> status) throws Exception {
        PageList<CopyFormVo> res = this.formManager.getRelationList(queryFilter, boDefIds, id, formType, status);
        return res;
    }

    @RequestMapping(value={"getFormDefByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u8868\u5355\u5b9a\u4e49", httpMethod="GET", notes="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u8868\u5355\u5b9a\u4e49")
    @ResponseBody
    public Form getFormDefinitionByKey(@ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"form_key_", (Object)formKey);
        queryWrapper.eq((Object)"is_main_", (Object)"Y");
        return (Form)((Object)((FormManager)this.baseService).getOne((Wrapper)queryWrapper, false));
    }

    @PostMapping(value={"batchSave"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58", httpMethod="POST", notes="\u6279\u91cf\u4fdd\u5b58")
    public CommonResult<?> batchSave(@Validated @RequestBody BatchCommonParam batchCommonParam) {
        List<Map<String, String>> resultList = ((FormManager)this.baseService).batchSave(batchCommonParam.getIds());
        return CommonResult.ok().value(BeanUtils.isNotEmpty(resultList) ? resultList : "\u6279\u91cf\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"getMobileFormByPc"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ePC\u8868\u5355key,\u83b7\u53d6\u624b\u673a\u8868\u5355\u7684\u8bbe\u7f6e\u4fe1\u606f,\u4e0d\u5b58\u5728\u5219\u751f\u6210,\u6709\u5219\u83b7\u53d6", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f")
    public Object getMobileFormByPc(@ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey) throws Exception {
        Form mainByFormKey = ((FormManager)this.baseService).getMainByFormKey(formKey + "mobile");
        if (BeanUtils.isEmpty((Object)((Object)mainByFormKey))) {
            Form mainByFormKey2 = ((FormManager)this.baseService).getMainByFormKey(formKey);
            ((FormManager)this.baseService).pcForm2MobileForm(mainByFormKey2.getId());
        }
        return ((FormManager)this.baseService).getFormDesignByKey(formKey + "mobile");
    }

    @RequestMapping(value={"formDesignByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f")
    public Object formDesignByKey(@ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey) throws Exception {
        return ((FormManager)this.baseService).getFormDesignByKey(formKey);
    }
}

