/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.query.SelectColumn;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.vo.BatchCommonParam;
import com.hotent.bo.bodef.BoDefService;
import com.hotent.bo.model.BoResult;
import com.hotent.form.dto.FormDataCopyDto;
import com.hotent.form.dto.FormDataVo;
import com.hotent.form.enums.FormType;
import com.hotent.form.model.FormDataTemplate;
import com.hotent.form.model.FormDataTemplateDraft;
import com.hotent.form.model.FormDataTemplateImportLog;
import com.hotent.form.model.FormDataTemplateXmlList;
import com.hotent.form.model.FormMeta;
import com.hotent.form.param.BatchSaveParam;
import com.hotent.form.param.BatchWordPrintVo;
import com.hotent.form.param.BpmDataTemplateInfoVo;
import com.hotent.form.param.DataTemplateImportResult;
import com.hotent.form.param.DataTemplateQueryVo;
import com.hotent.form.param.UpdateBatchParam;
import com.hotent.form.persistence.manager.DataTemplateWorkBookService;
import com.hotent.form.persistence.manager.FormDataTemplateDraftManager;
import com.hotent.form.persistence.manager.FormDataTemplateImportLogManager;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.vo.ComputeVo;
import com.hotent.form.vo.ExportSubVo;
import com.hotent.form.vo.FormDataTemplateVO;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.impl.util.PermissionCalc;
import com.hotent.uc.api.impl.var.IContextVar;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.xml.bind.JAXBException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/dataTemplate/v1"})
@Api(tags={"\u6570\u636e\u89c6\u56fe\u63a5\u53e3(\u4e1a\u52a1\u6570\u636e\u6a21\u677f)"})
@ApiGroup(group={"group_form"})
public class FormDataTemplateController
extends BaseController<FormDataTemplateManager, FormDataTemplate> {
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormDataTemplateDraftManager dataTemplateDraftManager;
    @Autowired
    FormDataTemplateManager formDataTemplateManager;
    @Resource
    BoDefService boDefService;
    @Resource
    DataTemplateWorkBookService dataTemplateWorkBookService;
    @Resource
    FormDataTemplateImportLogManager formDataTemplateImportLogManager;
    @Resource(name="formPermissionCalc")
    PermissionCalc permssionCalc;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public FormDataVo listJson(@ApiParam(name="queryFilter", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u67e5\u8be2\u5bf9\u8c61") @RequestBody DataTemplateQueryVo dataTemplateQueryVo) throws Exception {
        FormDataTemplate template = (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)dataTemplateQueryVo.getTemplateId()));
        return ((FormDataTemplateManager)this.baseService).getList(template, dataTemplateQueryVo, dataTemplateQueryVo.isSummary()).get();
    }

    @RequestMapping(value={"listToJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ResourcePermissionCheck
    @ApiOperation(value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<FormDataTemplate> listToJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="filterField", value="\u8fc7\u6ee4\u5b57\u6bb5(\u591a\u4e2a\u7528\uff0c\u9694\u5f00)") @RequestParam(required=false) String filterField) throws Exception {
        queryFilter.setDefaultSort("CREATE_TIME_", Direction.DESC);
        if (StringUtil.isNotEmpty((String)filterField)) {
            queryFilter.setSelectColumn(new SelectColumn(null, Arrays.asList(filterField.split(","))));
        }
        PageList bpmDataTemplates = ((FormDataTemplateManager)this.baseService).query(queryFilter);
        return bpmDataTemplates;
    }

    @RequestMapping(value={"dataList_{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5217\u8868  \u7b2c\u4e8c\u6b21\u89e3\u6790\u6a21\u677f", httpMethod="POST", notes="\u6570\u636e\u5217\u8868  \u7b2c\u4e8c\u6b21\u89e3\u6790\u6a21\u677f")
    public CommonResult<String> dataList(HttpServletRequest request, @PathVariable(value="alias") String alias, @ApiParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef") @RequestBody QueryFilter queryFilter, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestParam(value="isMobile") Optional<Boolean> isMobile) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("__ctx", "");
        params.put("__tic", "bpmDataTemplate");
        params.put("alias", alias);
        FormType formType = isMobile.orElse(false) != false ? FormType.MOBILE : FormType.PC;
        String html = ((FormDataTemplateManager)this.baseService).getDisplay(alias, params, queryFilter.getParams(), formType);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)html);
    }

    @RequestMapping(value={"getBpmDataTemplate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6")
    public ObjectNode getBpmDataTemplate(@ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="formKey", value="\u8868\u5355key", required=false) @RequestParam String boId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getByFormKey(formKey, boId);
    }

    @GetMapping(value={"getBODefByFormId"}, produces={"application/json; charset=utf-8"})
    public List<FormMeta> getBODefByFormId(@ApiParam(name="formId", value="\u8868\u5355Id", required=true) @RequestParam String formId) throws Exception {
        return this.formMetaManager.getBODefByFormId(formId);
    }

    @RequestMapping(value={"getByTemplateId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6")
    public ObjectNode getByTemplateId(@ApiParam(name="id", value="\u4e1a\u52a1\u6570\u636eid", required=true) @RequestParam String id, @ApiParam(name="boId", value="boId", required=false) @RequestParam String boId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getByTemplateId(id, boId);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4fe1\u606f")
    public CommonResult<FormDataTemplate> save(@RequestBody String json) throws Exception {
        CommonResult<FormDataTemplate> res = this.formDataTemplateManager.saveFormDataTemplate(json);
        return res;
    }

    @RequestMapping(value={"saveCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4fe1\u606f\u3002", httpMethod="POST", notes="\u590d\u5236\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4fe1\u606f")
    public CommonResult<String> saveCopy(@ApiParam(name="\u8868\u5355\u590d\u5236\u53c2\u6570", value="\u8868\u5355\u590d\u5236\u53c2\u6570") @RequestBody Map<String, String> map) throws Exception {
        return this.formDataTemplateManager.saveCopy(map);
    }

    @RequestMapping(value={"checkKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) {
        return ((FormDataTemplateManager)this.baseService).getCountByAlias(key) > 0;
    }

    @RequestMapping(value={"boBatchUpdate/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> boBatchUpdate(@ApiParam(name="params", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody List<ObjectNode> params, @PathVariable(value="boAlias") String boAlias) throws Exception {
        String resultMsg = "\u6279\u91cf\u66f4\u65b0\u6570\u636e\u6210\u529f";
        try {
            ((FormDataTemplateManager)this.baseService).boBatchUpdate(params, boAlias, null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5931\u8d25:" + e.getMessage());
        }
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u6d41\u7a0b\u5b9a\u4e49id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = ids.split(",");
        List formDataTemplates = ((FormDataTemplateManager)this.baseService).listByIds(Arrays.asList(aryIds));
        ((FormDataTemplateManager)this.baseService).removeByIds(aryIds);
        ((FormDataTemplateManager)this.baseService).batchDelCacheByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"getForm/{formKey}/{boAlias}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355Key, boAlias \u83b7\u53d6\u8868\u5355html\uff0c \u6743\u9650\uff0c bo\u6570\u636e\u7ed3\u6784", httpMethod="GET", notes="\u83b7\u53d6bo\u6570\u636e\u7ed3\u6784")
    public Map<String, Object> getForm(@PathVariable(value="formKey") String formKey, @PathVariable(value="boAlias") String boAlias, @ApiParam(name="id", value="id", required=true) @RequestParam String id, @ApiParam(name="action", value="\u64cd\u4f5c\u7c7b\u578b") @RequestParam String action, @ApiParam(name="buttonId", value="\u6309\u94aeid") @RequestParam(required=false) String buttonId, @ApiParam(name="recordId", value="\u8868\u5355\u4fee\u6539\u8bb0\u5f55id", required=false) @RequestParam(required=false) String recordId, @ApiParam(name="dataKey", value="\u6570\u636e\u62a5\u8868KEY", required=false) @RequestParam(required=false) String dataKey) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getFormData(formKey, boAlias, id, action, buttonId, recordId, dataKey);
    }

    @RequestMapping(value={"getTempDraftData/{draftId}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868\u8349\u7a3f", httpMethod="GET", notes="\u83b7\u53d6bo\u6570\u636e\u7ed3\u6784")
    public Map<String, Object> getTempDraftData(@PathVariable(value="draftId") String draftId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getTempDraftData(draftId);
    }

    @RequestMapping(value={"boSave/{templateKey}/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> boSave(@ApiParam(name="params", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody ObjectNode params, @PathVariable(value="templateKey") String templateKey, @PathVariable(value="boAlias") String boAlias, @RequestParam(value="delDraftId") String delDraftId, @RequestParam(value="editButtonId", required=false) String editButtonId) throws Exception {
        String resultMsg = "\u4fdd\u5b58\u6210\u529f";
        List<BoResult> result = ((FormDataTemplateManager)this.baseService).boSave(params, templateKey, boAlias, delDraftId, editButtonId);
        return new CommonResult(true, resultMsg, (Object)JsonUtil.toJsonString(result));
    }

    @RequestMapping(value={"boCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> boCopy(@RequestBody @Valid FormDataCopyDto formDataCopyDto) throws Exception {
        CommonResult<String> commonResult = ((FormDataTemplateManager)this.baseService).boCopy(formDataCopyDto);
        return commonResult;
    }

    @RequestMapping(value={"copyOne"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u590d\u5236\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> copyOne(@ApiParam(name="Id", value="Id", required=true) @RequestParam(value="pkField") String pkField) throws Exception {
        String resultMsg = "\u4fdd\u5b58\u6210\u529f";
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"boSaveDraft"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6a21\u677f\u8349\u7a3f", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6a21\u677f\u8349\u7a3f")
    public CommonResult<String> boSaveDraft(@ApiParam(name="dataTemplateDraft", value="\u6570\u636e\u62a5\u8868\u8349\u7a3f", required=true) @RequestBody FormDataTemplateDraft dataTemplateDraft) throws Exception {
        String resultMsg = "\u4fdd\u5b58\u8349\u7a3f\u6210\u529f";
        ((FormDataTemplateManager)this.baseService).boSaveDraft(dataTemplateDraft);
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"boDel/{boAlias}"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u8bb0\u5f55")
    public CommonResult<String> boDel(@PathVariable(value="boAlias") String boAlias, @ApiParam(name="ids", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestParam String ids, @ApiParam(name="formKey", value="\u8868\u5355key", required=false) @RequestParam Optional<String> formKey) throws IOException {
        String resultMsg = "\u5220\u9664\u6210\u529f";
        String[] idArray = ids.split(",");
        ((FormDataTemplateManager)this.baseService).boDel(idArray, boAlias, formKey.orElse(""));
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"editTemplate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f", httpMethod="GET", notes="\u83b7\u53d6\u6a21\u677f")
    public FormDataTemplate templateHtmlEdit(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id) throws Exception {
        return (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"saveTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f")
    public CommonResult<String> saveTemplate(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id, @ApiParam(name="formDataTemplateVO", value="\u6a21\u677fhtml", required=true) @RequestBody FormDataTemplateVO formDataTemplateVO) throws IOException {
        String resultMsg = "\u4fdd\u5b58\u6210\u529f";
        FormDataTemplate template = (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)id));
        if (StringUtil.isNotEmpty((String)formDataTemplateVO.getTemplateHtml())) {
            template.setTemplateHtml(formDataTemplateVO.getTemplateHtml());
        }
        if (StringUtil.isNotEmpty((String)formDataTemplateVO.getMobileTemplateHtml())) {
            template.setMobileTemplateHtml(formDataTemplateVO.getMobileTemplateHtml());
        }
        ((FormDataTemplateManager)this.baseService).update((Model)template);
        ((FormDataTemplateManager)this.baseService).batchDelCacheByIds(template.getId());
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6570\u636e")
    public FormDataTemplate getJsonData(@ApiParam(name="id", value="\u6a21\u677fid", required=false) @RequestParam Optional<String> id, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey) throws Exception {
        FormDataTemplate bpmDataTemplate = null;
        String templateId = id.orElse("");
        if (StringUtil.isNotEmpty((String)id.orElse(""))) {
            bpmDataTemplate = (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)templateId));
        } else if (StringUtil.isNotEmpty((String)formKey)) {
            bpmDataTemplate = ((FormDataTemplateManager)this.baseService).getExportDisplay(formKey);
        }
        return bpmDataTemplate;
    }

    @RequestMapping(value={"export"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="getType", value="getType", required=false) @RequestParam String getType, @ApiParam(name="filterKey", value="filterKey", required=false) @RequestParam String filterKey, @ApiParam(name="expField", value="expField", required=true) @RequestParam String expField, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        ((FormDataTemplateManager)this.baseService).exportData(response, formKey, getType, filterKey, expField, queryFilter);
    }

    @RequestMapping(value={"downloadMainTempFile/{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempFile(HttpServletResponse response, @ApiParam(name="alias", value="\u6a21\u677f\u522b\u540d", required=true) @PathVariable String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).downloadMainTempFile(response, alias);
    }

    @RequestMapping(value={"getVarList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u53d8\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u76f8\u5173\u53d8\u91cf")
    public List<IContextVar> getVarList() throws Exception {
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        return comVarList;
    }

    @RequestMapping(value={"getSubData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e")
    public List<Map<String, Object>> getSubData(@ApiParam(name="alias", value="\u5b9e\u4f53\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="refId", value="\u5916\u952eid", required=true) @RequestParam String refId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getSubData(alias, refId);
    }

    @PostMapping(value={"getSubDataPagination"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e(\u5206\u9875)", httpMethod="GET", notes="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e\uff08\u5206\u9875\uff09")
    public PageList<Map<String, Object>> getSubDataPagination(@ApiParam(name="queryFilter") @RequestBody QueryFilter queryFilter, @ApiParam(name="alias", value="\u5b9e\u4f53\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="refId", value="\u5916\u952eid", required=true) @RequestParam String refId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getSubDataPagination(queryFilter, alias, refId);
    }

    @PostMapping(value={"importSub"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5b50\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u5b50\u8868\u6570\u636e")
    public CommonResult<String> importSub(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="refId", value="refId") @RequestParam String refId, @ApiParam(name="alias", value="\u5225\u540d") @RequestParam String alias, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam Optional<String> formKey) throws Exception {
        ((FormDataTemplateManager)this.baseService).importData(file, refId, alias, formKey.orElse(null));
        return new CommonResult("\u5bfc\u5165\u5b50\u8868\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"importMain"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u4e3b\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u4e3b\u8868\u6570\u636e")
    public CommonResult<String> importMain(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="alias", value="\u6570\u636e\u6a21\u677f\u5225\u540d") @RequestParam String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).importMain(file, alias);
        return new CommonResult("\u5bfc\u5165\u4e3b\u8868\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"exportSub"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5b50\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u5b50\u8868\u6570\u636e")
    public void exportSub(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody ExportSubVo exportSubVo) throws Exception {
        ((FormDataTemplateManager)this.baseService).exportSub(response, exportSubVo);
    }

    @RequestMapping(value={"getBpmDataTemplateInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u76f8\u5173\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u76f8\u5173\u4fe1\u606f")
    public CommonResult<BpmDataTemplateInfoVo> getBpmDataTemplateInfo(@ApiParam(name="alias", value="\u6570\u636e\u62a5\u8868\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="needDisplayFileds", value="\u662f\u5426\u9700\u8981\u663e\u793a\u5b57\u6bb5") @RequestParam Optional<Boolean> needDisplayFileds) throws Exception {
        CommonResult<BpmDataTemplateInfoVo> res = this.formDataTemplateManager.getBpmDataTemplateInfo(alias, needDisplayFileds);
        return res;
    }

    @RequestMapping(value={"getMyDraftList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u62a5\u8868\u8349\u7a3f\u6570\u636e(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u6211\u7684\u62a5\u8868\u8349\u7a3f\u6570\u636e(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<FormDataTemplateDraft> getMyDraftListy(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        queryFilter.addFilter("CREATE_BY_", (Object)currentUser.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        FieldSort sort = new FieldSort("create_time_", Direction.DESC);
        queryFilter.getSorter().add(sort);
        PageList query = this.dataTemplateDraftManager.query(queryFilter);
        return query;
    }

    @RequestMapping(value={"removeTempDraft"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8349\u7a3f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8349\u7a3f\u8bb0\u5f55")
    public CommonResult<String> removeTempDraft(@ApiParam(name="ids", value="\u8349\u7a3fid", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = ids.split(",");
        this.dataTemplateDraftManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u62a5\u8868xml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u6570\u636e\u62a5\u8868id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_formDataTemplate_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = ((FormDataTemplateManager)this.baseService).exportDef(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"exportData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u62a5\u8868\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e\u62a5\u8868\u6570\u636e")
    public Map<String, String> exportData(String ... ids) throws Exception {
        return ((FormDataTemplateManager)this.baseService).exportDef(Arrays.asList(ids));
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST})
    public CommonResult<Map<String, String>> importData(@RequestBody String xml, @RequestParam(value="typeId", required=false) String typeId, @RequestParam(value="isCover") Boolean isCover) throws Exception {
        ThreadMsgUtil.addMapMsg((String)"notNeedTransaction", (String)"true");
        FormDataTemplateXmlList list = (FormDataTemplateXmlList)JAXBUtil.unmarshall((String)xml, FormDataTemplateXmlList.class);
        return ((FormDataTemplateManager)this.baseService).importDef(list, typeId, isCover);
    }

    @RequestMapping(value={"importCheckFormList"}, method={RequestMethod.POST})
    public List<ImportCheckResult> importCheckFormList(@RequestBody String xml) throws JAXBException, UnsupportedEncodingException {
        FormDataTemplateXmlList list = (FormDataTemplateXmlList)JAXBUtil.unmarshall((String)xml, FormDataTemplateXmlList.class);
        return ((FormDataTemplateManager)this.baseService).importCheck(list);
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u62a5\u8868\u5bfc\u5165\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165", required=false) @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6570\u636e\u62a5\u8868\u6587\u4ef6id", required=false) @RequestParam Optional<String> cacheFileId) throws Exception {
        Object res = this.formDataTemplateManager.importSave(confirmImport, typeId, cacheFileId);
        return res;
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c,\u901a\u8fc7\u6821\u9a8c\u5219\u76f4\u63a5\u5bfc\u5165\uff0c\u5982\u6709\u91cd\u590d\u6d41\u7a0b\uff0c\u5219\u8fd4\u56de\u6d41\u7a0bxml\u7684\u7f13\u5b58key\uff0c\u5f85\u7528\u6237\u786e\u8ba4\u8986\u76d6\u540e\u518d\u6b21\u5bfc\u5165", httpMethod="POST", notes="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c")
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId) throws Exception {
        Object res = this.formDataTemplateManager.importCheck(request, response, typeId);
        return res;
    }

    @PostMapping(value={"newImport"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5bfc\u5165\u6309\u94ae\u8bbe\u7f6e\uff0c\u5bfc\u5165\u4e3b\u5b50\u5b59\u8868\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u5bfc\u5165\u6309\u94ae\u8bbe\u7f6e\uff0c\u5bfc\u5165\u4e3b\u5b50\u5b59\u8868\u6570\u636e")
    public CommonResult<String> newImport(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="alias", value="\u6570\u636e\u6a21\u677f\u5225\u540d") @RequestParam String alias, @ApiParam(name="bindFilld", value="\u586b\u5145\u7684\u5b57\u6bb5\u540d") @RequestParam Optional<String> bindFilld, @ApiParam(name="fillValue", value="\u586b\u5145\u7684\u5b57\u6bb5\u503c") @RequestParam Optional<String> fillValue, @ApiParam(name="refIdValue", value="\u5916\u952e\u7684\u503c") @RequestParam Optional<String> refIdValue) throws Exception {
        String cacheKey = this.dataTemplateWorkBookService.importWorkBook(file, alias);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f", (Object)cacheKey);
    }

    @RequestMapping(value={"downloadTempFile/{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadTempFile(HttpServletResponse response, @ApiParam(name="alias", value="\u6a21\u677f\u522b\u540d", required=true) @PathVariable String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).downloadTempFile(response, alias);
    }

    @RequestMapping(value={"downloadTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    public void downloadTemplate(@ApiParam(name="templateKey", value="\u8868\u5355\u5217\u8868\u522b\u540d") String templateKey, @ApiParam(name="config", value="\u5bfc\u5165\u6a21\u677f\u914d\u7f6e") @RequestBody ObjectNode config, HttpServletResponse response) throws Exception {
        this.dataTemplateWorkBookService.downloadTemplate(templateKey, config, response);
    }

    @RequestMapping(value={"downloadMainTempByFormKey/{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempByFormKey(HttpServletResponse response, @ApiParam(name="alias", value="\u8868\u5355\u522b\u540d", required=true) @PathVariable String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).downloadMainTempByFormKey(response, alias);
    }

    @RequestMapping(value={"getExistsByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u5b58\u5728\u7684\u8868\u5355\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5df2\u5b58\u5728\u7684\u8868\u5355\u5217\u8868")
    public List<FormDataTemplate> getExistsByFormKey(@ApiParam(name="formKey", value="\u8868\u5355Key", required=true) @RequestParam String formKey) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getExistsByFormKey(formKey);
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f", httpMethod="GET", notes="\u901a\u8fc7id\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f")
    public FormDataTemplate getFormDataTemplateById(@ApiParam(name="id", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677fid", required=true) @RequestParam String id) throws Exception {
        return (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f", httpMethod="GET", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f")
    public FormDataTemplate getFormDataTemplateByAlias(@ApiParam(name="alias", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"alias_", (Object)alias);
        return (FormDataTemplate)((Object)((FormDataTemplateManager)this.baseService).getOne((Wrapper)queryWrapper, false));
    }

    @PostMapping(value={"batchSave"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58", httpMethod="POST", notes="\u6279\u91cf\u4fdd\u5b58")
    public CommonResult<?> batchSave(@Validated @RequestBody BatchCommonParam batchCommonParam) {
        List<Map<String, String>> resultList = ((FormDataTemplateManager)this.baseService).batchSave(batchCommonParam.getIds());
        return CommonResult.ok().value(BeanUtils.isNotEmpty(resultList) ? resultList : "\u6279\u91cf\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"exportByBtnSetting"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5217\u8868\u5bfc\u51fa\u6309\u94ae\u7684\u914d\u7f6e\u5bfc\u51fa\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u8868\u5355\u5217\u8868\u5bfc\u51fa\u6309\u94ae\u7684\u914d\u7f6e\u5bfc\u51fa\u6570\u636e")
    public void exportByBtnSetting(HttpServletResponse response, @ApiParam(name="id", value="\u8868\u5355\u5217\u8868id", required=true) @RequestParam String id, @ApiParam(name="queryFilter", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u67e5\u8be2\u5bf9\u8c61") @RequestBody DataTemplateQueryVo dataTemplateQueryVo) throws Exception {
        ((FormDataTemplateManager)this.baseService).exportByBtnSetting(response, id, dataTemplateQueryVo);
    }

    @RequestMapping(value={"bindRelation"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5217\u8868\u7684\u7ed1\u5b9a\u5173\u7cfb", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355\u5217\u8868\u7684\u7ed1\u5b9a\u5173\u7cfb")
    public CommonResult<Map<String, Object>> bindRelation(@ApiParam(name="templateKey", value="\u5217\u8868key") @RequestParam String templateKey) {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", ((FormDataTemplateManager)this.baseService).bindRelation(templateKey));
    }

    @RequestMapping(value={"getImportCache"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u5165\u7684\u7f13\u5b58\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u5bfc\u5165\u7684\u7f13\u5b58\u6570\u636e")
    public List<DataTemplateImportResult> getImportCache(@ApiParam(name="cacheKey", value="\u7f13\u5b58key") @RequestParam String cacheKey, @ApiParam(name="pageBean", value="\u5206\u9875\u4fe1\u606f") @RequestBody PageBean pageBean) {
        List<DataTemplateImportResult> importCache = this.dataTemplateWorkBookService.getImportCache(cacheKey);
        if (null == importCache) {
            throw new BaseException("\u5bfc\u5165\u6570\u636e\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165");
        }
        for (DataTemplateImportResult dataTemplateImportResult : importCache) {
            int total;
            List<Object> result = new ArrayList();
            if (pageBean.getOffset() > dataTemplateImportResult.getResult().size()) {
                total = 0;
            } else {
                result = dataTemplateImportResult.getResult();
                total = result.size();
                int size = result.size();
                int offset = pageBean.getOffset();
                result = pageBean.getLimit() + offset > size ? result.subList(offset, size) : result.subList(offset, offset + pageBean.getLimit());
            }
            PageList pageList = new PageList(result);
            pageList.setTotal((long)total);
            pageList.setPage((long)pageBean.getPage().intValue());
            pageList.setPageSize((long)pageBean.getPageSize().intValue());
            dataTemplateImportResult.setPageList(pageList);
        }
        return importCache;
    }

    @RequestMapping(value={"saveImportResult"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5bfc\u5165\u7ed3\u679c", httpMethod="POST", notes="\u4fdd\u5b58\u5bfc\u5165\u7ed3\u679c")
    public CommonResult<String> saveImportResult(@ApiParam(name="cacheKey", value="\u7f13\u5b58key") @RequestBody String cacheKey, @ApiParam(name="templateAlias", value="\u5217\u8868key") @RequestParam String templateAlias) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        FormDataTemplateImportLog formDataTemplateImportLog = new FormDataTemplateImportLog(currentUser.getAccount(), currentUser.getFullname(), LocalDateTime.now(), templateAlias);
        try {
            this.dataTemplateWorkBookService.saveImportResult(cacheKey, templateAlias);
            this.dataTemplateWorkBookService.clearCache(cacheKey);
        }
        catch (Exception e) {
            formDataTemplateImportLog.setStatus("0");
            if (BeanUtils.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > 5000) {
                formDataTemplateImportLog.setReason(e.getMessage().substring(0, 5000) + "....");
            } else {
                formDataTemplateImportLog.setReason(e.getMessage());
            }
            this.formDataTemplateImportLogManager.create((Model)formDataTemplateImportLog);
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7");
        }
        formDataTemplateImportLog.setStatus("1");
        this.formDataTemplateImportLogManager.create((Model)formDataTemplateImportLog);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"downloadDefaultExportTempByFormKey/{dataTemplateId}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u9ed8\u8ba4\u5bfc\u51fa\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u9ed8\u8ba4\u5bfc\u51fa\u6a21\u677f")
    public void downloadDefaultExportTempByFormKey(HttpServletResponse response, @ApiParam(name="dataTemplateId", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677fid", required=true) @PathVariable String dataTemplateId) throws Exception {
        ((FormDataTemplateManager)this.baseService).downloadDefaultExportTempByFormKey(response, dataTemplateId);
    }

    @RequestMapping(value={"getAuthDetailPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6570\u636e\u6743\u9650\u548c\u6309\u94ae\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6570\u636e\u6743\u9650\u548c\u6309\u94ae\u6743\u9650")
    public PageList<Map<String, Object>> getAuthDetailPage(@ApiParam(name="queryFilter", value="\u7528\u6237id") @RequestBody QueryFilter<FormDataTemplate> queryFilter) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getAuthDetailPage(queryFilter);
    }

    @RequestMapping(value={"exportAuthDetail"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355\u6570\u636e\u6743\u9650\u548c\u6309\u94ae\u6743\u9650", httpMethod="POST", notes="\u5bfc\u51fa\u8868\u5355\u6570\u636e\u6743\u9650\u548c\u6309\u94ae\u6743\u9650")
    public void exportAuthDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter<FormDataTemplate> queryFilter, HttpServletResponse httpServletResponse) throws Exception {
        ((FormDataTemplateManager)this.baseService).exportAuthDetail(queryFilter, httpServletResponse);
    }

    @RequestMapping(value={"copeOrTransferAuth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fc1\u79fb\u6216\u590d\u5236\u8868\u5355\u6570\u636e\u6743\u9650\u548c\u6309\u94ae\u6743\u9650", httpMethod="POST", notes="\u8fc1\u79fb\u6216\u590d\u5236\u8868\u5355\u6570\u636e\u6743\u9650\u548c\u6309\u94ae\u6743\u9650")
    public CommonResult<String> copeOrTransferAuth(@ApiParam(name="map", value="\u6743\u9650\u4fee\u6539\u4fe1\u606f") @RequestBody List<Map<String, String>> list) throws Exception {
        return ((FormDataTemplateManager)this.baseService).copeOrTransferAuth(list);
    }

    @RequestMapping(value={"joinCheckSql"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1sql", httpMethod="POST", notes="\u9a8c\u8bc1sql")
    public CommonResult<Object> joinCheckSql(@ApiParam(name="sql", value="\u5f85\u9a8c\u8bc1\u7684sql") @RequestBody ObjectNode obj) throws Exception {
        return ((FormDataTemplateManager)this.baseService).joinCheckSql(obj);
    }

    @RequestMapping(value={"batchSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u6279\u91cf\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> saveBatch(@ApiParam(name="params", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody BatchSaveParam params) throws Exception {
        String resultMsg = "\u6279\u91cf\u4fdd\u5b58\u6570\u636e\u6210\u529f";
        ((FormDataTemplateManager)this.baseService).batchSave(params);
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"newBoBatchUpdate2"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<List<ComputeVo>> newBoBatchUpdate2(@RequestBody UpdateBatchParam updateBatchParam) throws Exception {
        String resultMsg = "\u4efb\u52a1\u63d0\u4ea4\u6210\u529f";
        List<ComputeVo> computeVos = ((FormDataTemplateManager)this.baseService).newBoBatchUpdate2(updateBatchParam);
        CommonResult result = new CommonResult();
        result.setValue(computeVos);
        result.setMessage(resultMsg);
        return result;
    }

    @RequestMapping(value={"computeListBatchUpdate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> computeListBatchUpdate(@RequestBody List<ComputeVo> list) throws Exception {
        String resultMsg = "\u6279\u91cf\u66f4\u65b0\u6570\u636e\u6210\u529f";
        ArrayList<ObjectNode> nodes = new ArrayList<ObjectNode>();
        if (BeanUtils.isNotEmpty(list)) {
            FormDataTemplate dataTemplate = ((FormDataTemplateManager)this.baseService).getByAlias(list.get(0).getAlias());
            String tableName = this.boDefService.getByAlias(dataTemplate.getBoDefAlias()).getBoEnt().getTableName().replace("_", "").toLowerCase();
            for (ComputeVo computeVo : list) {
                Iterator iterator = computeVo.getData().fieldNames();
                ObjectNode data = JsonUtil.getMapper().createObjectNode();
                String preName = tableName + "f";
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    String dataName = new String(name);
                    name = name.replace(preName, "");
                    if (!BeanUtils.isNotEmpty((Object)computeVo.getData().get(dataName))) continue;
                    data.set(name, computeVo.getData().get(dataName));
                }
                nodes.add(data);
            }
            try {
                ((FormDataTemplateManager)this.baseService).boBatchUpdate(nodes, dataTemplate.getBoDefAlias(), list.get(0).getFilterMap());
            }
            catch (IllegalArgumentException argumentException) {
                BaseException baseException = new BaseException((Throwable)argumentException);
                baseException.setMessage("\u66f4\u65b0\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e0e\u7ed1\u5b9a\u5b57\u6bb5\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u914d\u7f6e");
                throw baseException;
            }
        }
        return new CommonResult(true, resultMsg);
    }

    @GetMapping(value={"getManagePermissions"})
    @ApiOperation(value="\u83b7\u53d6\u6309\u94ae\u6570\u636e\u6743\u9650", httpMethod="GET", notes="\u83b7\u53d6\u6309\u94ae\u6570\u636e\u6743\u9650")
    public Map<String, Boolean> getManagerPermissions(@RequestParam String id) throws Exception {
        FormDataTemplate dataTemplate = (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)id));
        return ((FormDataTemplateManager)this.baseService).getManagePermission(dataTemplate.getManageField(), this.permssionCalc.getCurrentProfiles());
    }

    @RequestMapping(value={"batchWordPrint"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u6253\u5370word\u6a21\u677f", httpMethod="POST", notes="\u6279\u91cf\u6253\u5370word\u6a21\u677f")
    public void batchWordPrint(@ApiParam(name="formPrintParamList", value="\u6253\u5370\u53c2\u6570\u6570\u7ec4") @RequestBody BatchWordPrintVo batchWordPrintVo, HttpServletResponse response) throws Exception {
        ((FormDataTemplateManager)this.baseService).batchWordPrint(batchWordPrintVo, response);
    }
}

