/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormDefinitionTemplate;
import com.hotent.form.model.FormHistoryRecord;
import com.hotent.form.persistence.manager.FormDefinitionTemplateManager;
import com.hotent.form.persistence.manager.FormHistoryRecordManager;
import com.hotent.form.vo.BpmFormVo;
import com.hotent.form.vo.FormDefinitionTemplateVO;
import com.hotent.form.vo.FormTemplateCopyVO;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/definitionTemplate/v1/"})
public class FormDefinitionTemplateController
extends BaseController<FormDefinitionTemplateManager, FormDefinitionTemplate> {
    @Resource
    FormHistoryRecordManager formHistoryRecordManager;

    @PostMapping(value={"/queryByFilter"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u8868\u5355\u6a21\u7248\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u8868\u5355\u6a21\u7248\u6570\u636e")
    public PageList<FormDefinitionTemplate> queryByFilter(@ApiParam(name="FormDefinitionTemplate", value="\u8868\u5355\u6a21\u7248\u5bf9\u8c61", required=true) @RequestBody QueryFilter<FormDefinitionTemplate> queryFilter) throws Exception {
        return ((FormDefinitionTemplateManager)this.baseService).queryByFilter(queryFilter);
    }

    @PostMapping(value={"saveForm"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9")
    public CommonResult<Map<String, Object>> saveForm(@ApiParam(name="bpmFormVo", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestBody BpmFormVo bpmFormVo) throws Exception {
        Form bpmForm = bpmFormVo.getBpmForm();
        FormDefinitionTemplate formDefinitionTemplate = (FormDefinitionTemplate)((Object)BeanUtil.copyProperties((Object)((Object)bpmForm), FormDefinitionTemplate.class, (String[])new String[0]));
        ((FormDefinitionTemplateManager)this.baseService).saveFormDef(formDefinitionTemplate, bpmFormVo.getBpmFormDef(), bpmFormVo.getNewForm());
        String msg = "\u751f\u6210\u8868\u5355\u6210\u529f";
        if ("newForm".equals(bpmFormVo.getNewForm())) {
            msg = "\u53d1\u5e03\u65b0\u7248\u672c\u6210\u529f";
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("rev", bpmFormVo.getBpmFormDef().getRev());
        value.put("formData", (Object)formDefinitionTemplate);
        return new CommonResult(true, msg, value);
    }

    @GetMapping(value={"formDesign"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f")
    public Object formDesign(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        return ((FormDefinitionTemplateManager)this.baseService).getFormDesign(formId);
    }

    @PostMapping(value={"/copy"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u590d\u5236\u4e00\u6761\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u8868\u5355id\u590d\u5236\u4e00\u6761\u6570\u636e")
    public CommonResult<String> copy(@ApiParam(name="id", value="\u8868\u5355\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestBody FormTemplateCopyVO formTemplateCopyVO) throws Exception {
        ((FormDefinitionTemplateManager)this.baseService).copyByFormId(formTemplateCopyVO);
        return CommonResult.ok().message("\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"checkExternalEnt"})
    @ApiOperation(value="\u68c0\u67e5\u662f\u5426\u5916\u90e8\u6570\u636e\u6e90\u8868", httpMethod="GET", notes="\u68c0\u67e5\u662f\u5426\u5916\u90e8\u6570\u636e\u6e90\u8868")
    public CommonResult<Boolean> checkExternalEnt(@ApiParam(name="id", value="\u8868\u5355\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String defId) {
        return CommonResult.ok().value((Object)((FormDefinitionTemplateManager)this.baseService).checkExternalEnt(defId));
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u590d\u5236\u4e00\u6761\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u8868\u5355id\u590d\u5236\u4e00\u6761\u6570\u636e")
    public CommonResult<String> remove(String ... ids) throws Exception {
        ((FormDefinitionTemplateManager)this.baseService).removeAll(Arrays.asList(ids));
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"exportData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355xml", httpMethod="GET", notes="\u5bfc\u51fa\u8868\u5355xml")
    public void exportData(HttpServletRequest request, HttpServletResponse response, String ... ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            List<String> idList = Arrays.asList(ids);
            Map<String, String> map = ((FormDefinitionTemplateManager)this.baseService).exportData(idList, true);
            String fileName = "";
            String fullname = ContextUtil.getCurrentUser().getFullname();
            if (idList.size() == 1) {
                FormDefinitionTemplate form = (FormDefinitionTemplate)((FormDefinitionTemplateManager)this.baseService).get((Serializable)((Object)idList.get(0)));
                fileName = String.format("\u6a21\u677f\u5bfc\u51fa_%s(%s)_%s%s", form.getName(), form.getFormKey(), fullname, DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
                if (fileName.length() > 123) {
                    fileName = fileName.substring(0, 120) + "...";
                }
            } else {
                fileName = String.format("\u6279\u91cf\u6a21\u677f\u5bfc\u51fa\u6587\u4ef6_%s%s", fullname, DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
            }
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, map, (String)fileName);
        }
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165") @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6") @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id") @RequestParam Optional<String> cacheFileId) throws Exception {
        return ((FormDefinitionTemplateManager)this.baseService).importSave(confirmImport, typeId, cacheFileId);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u5bfc\u5165\u524d\u6821\u9a8c", httpMethod="POST", notes="\u8868\u5355\u5bfc\u5165\u524d\u6821\u9a8c")
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6") @RequestParam Optional<String> typeId) throws Exception {
        return ((FormDefinitionTemplateManager)this.baseService).importCheck(request, response, typeId);
    }

    @RequestMapping(value={"checkMobileForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5pc\u8868\u5355\u662f\u5426\u6709\u624b\u673a\u8868\u5355", httpMethod="POST", notes="\u68c0\u67e5pc\u8868\u5355\u662f\u5426\u6709\u624b\u673a\u8868\u5355")
    public CommonResult<String> checkMobileForm(@ApiParam(name="formId", value="\u8868\u5355\u8bbe\u8ba1Id") @RequestParam String formKey) throws Exception {
        return ((FormDefinitionTemplateManager)this.baseService).checkMobileForm(formKey);
    }

    @RequestMapping(value={"pcForm2MobileForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="pc\u8868\u5355\u8f6c\u6362\u4e3a\u624b\u673a\u8868\u5355", httpMethod="POST", notes="pc\u8868\u5355\u8f6c\u6362\u4e3a\u624b\u673a\u8868\u5355")
    public CommonResult<String> pcForm2MobileForm(@ApiParam(name="formId", value="\u8868\u5355\u8bbe\u8ba1Id") @RequestParam String formId) throws Exception {
        ((FormDefinitionTemplateManager)this.baseService).pcForm2MobileForm(formId);
        String msg = "\u751f\u6210\u624b\u673a\u8868\u5355\u6210\u529f,\u8bf7\u5728\u624b\u673a\u8868\u5355\u4e2d\u67e5\u770b";
        return new CommonResult(true, msg);
    }

    @RequestMapping(value={"pcUpdateMobileForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="pc\u8868\u5355\u66f4\u65b0\u624b\u673a\u8868\u5355", httpMethod="POST", notes="pc\u8868\u5355\u66f4\u65b0\u624b\u673a\u8868\u5355")
    public CommonResult<String> pcUpdateMobileForm(@ApiParam(name="formId", value="\u8868\u5355\u8bbe\u8ba1Id") @RequestParam String formId) throws Exception {
        ((FormDefinitionTemplateManager)this.baseService).pcUpdateMobileForm(formId);
        String msg = "\u66f4\u65b0\u624b\u673a\u8868\u5355\u6210\u529f,\u8bf7\u5728\u624b\u673a\u8868\u5355\u4e2d\u67e5\u770b";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"updateFormHistoryRecord"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6062\u590d\u5230\u8868\u5355\u5386\u53f2\u6570\u636e", httpMethod="GET", notes="\u6062\u590d\u5230\u8868\u5355\u5386\u53f2\u6570\u636e")
    public CommonResult<String> updateFormHistoryRecord(@ApiParam(name="id", value="\u4e3b\u952eID") @RequestParam String id) throws Exception {
        FormHistoryRecord formHistoryRecord = (FormHistoryRecord)this.formHistoryRecordManager.get((Serializable)((Object)id));
        return ((FormDefinitionTemplateManager)this.baseService).updateFormHistoryRecord(formHistoryRecord);
    }

    @RequestMapping(value={"previewDesignVue"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="Vue\u8868\u5355\u9884\u89c8", httpMethod="GET", notes="\u8868\u5355\u9884\u89c8")
    public Object previewDesignVue(@ApiParam(name="formId", value="\u8868\u5355id") @RequestParam String formId) throws Exception {
        return ((FormDefinitionTemplateManager)this.baseService).getPreviewDesignVueData(formId);
    }

    @RequestMapping(value={"previewDesignTemp"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="Vue\u8868\u5355\u9884\u89c8\uff08\u672a\u4fdd\u5b58\uff09", httpMethod="GET", notes="\u8868\u5355\u9884\u89c8\uff08\u672a\u4fdd\u5b58\uff09")
    public Object previewDesignTemp(@ApiParam(name="cacheId", value="\u7f13\u5b58\u6807\u8bc6") @RequestParam String cacheId) throws Exception {
        String content = ((FormDefinitionTemplateManager)this.baseService).getFormFromCache(cacheId);
        if (StringUtil.isNotEmpty((String)content)) {
            FormDefinitionTemplateVO bpmFormVo = (FormDefinitionTemplateVO)JsonUtil.toBean((String)content, FormDefinitionTemplateVO.class);
            return ((FormDefinitionTemplateManager)this.baseService).getPreviewDesignVueData(bpmFormVo);
        }
        throw new RuntimeException("\u8868\u5355\u9884\u89c8\u7f13\u5b58\u6807\u8bc6\u5df2\u8fc7\u671f\uff01");
    }

    @RequestMapping(value={"checkKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) throws Exception {
        List bpmForm = ((FormDefinitionTemplateManager)this.baseService).list((Wrapper)Wrappers.lambdaQuery().eq(FormDefinitionTemplate::getFormKey, (Object)key));
        return bpmForm.size() > 0;
    }

    @RequestMapping(value={"publish"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03\u8868\u5355", httpMethod="POST", notes="\u53d1\u5e03\u8868\u5355")
    public CommonResult<String> publish(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        ((FormDefinitionTemplateManager)this.baseService).publish(formId);
        return new CommonResult(true, "\u53d1\u5e03\u7248\u672c\u6210\u529f", null);
    }

    @RequestMapping(value={"setDefaultVersion"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c", httpMethod="POST", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c")
    public CommonResult<String> setDefaultVersion(@ApiParam(name="id", value="\u8868\u5355ID") @RequestParam String id, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey) throws Exception {
        ((FormDefinitionTemplateManager)this.baseService).setDefaultVersion(id, formKey);
        return new CommonResult(true, "\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c\u6210\u529f", null);
    }
}

