/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.StringUtil;
import com.hotent.form.model.FormRight;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormRightManager;
import com.hotent.form.vo.FormRigthParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/rights/v1"})
@Api(tags={"\u8868\u5355\u6743\u9650"})
@ApiGroup(group={"group_form"})
public class FormRightsController
extends BaseController<FormRightManager, FormRight> {
    @Resource
    private FormRightManager bpmFormRightManager;
    @Resource
    private FormMetaManager bpmFormDefManager;

    @RequestMapping(value={"getPermission"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public Map<String, Object> getPermission(@ApiParam(name="param", value="\u8868\u5355\u6743\u9650\u53c2\u6570\u5bf9\u8c61") @RequestBody FormRigthParam param) throws IOException {
        Map<String, Object> res = this.bpmFormRightManager.getPermission(param);
        return res;
    }

    @RequestMapping(value={"setting/permissions"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u914d\u7f6e\u9875\u9762\u83b7\u53d6\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u914d\u7f6e\u9875\u9762\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public Map<String, Object> getPermissionSetting(@ApiParam(name="param", value="\u8868\u5355\u6743\u9650\u53c2\u6570\u5bf9\u8c61") @RequestBody FormRigthParam param) throws IOException {
        return this.bpmFormRightManager.getPermissionUpdateDesc(param);
    }

    @RequestMapping(value={"getFormPermission"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6743\u9650\uff0c\u4e0d\u5b58\u5728\u65f6\u4e0d\u9ed8\u8ba4\u8d4b\u503c", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650\uff0c\u4e0d\u5b58\u5728\u65f6\u4e0d\u9ed8\u8ba4\u8d4b\u503c")
    public JsonNode getFormPermission(@ApiParam(name="param", value="\u8868\u5355\u6743\u9650\u53c2\u6570\u5bf9\u8c61") @RequestBody FormRigthParam param) throws IOException {
        return this.bpmFormRightManager.getPermissionNoDefault(param);
    }

    @RequestMapping(value={"bathSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e", httpMethod="POST", notes="\u6279\u91cf\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e")
    public CommonResult<String> bathSave(@ApiParam(name="param", value="\u8868\u5355\u6743\u9650\u53c2\u6570\u5bf9\u8c61") @RequestBody List<FormRigthParam> param) {
        this.bpmFormRightManager.newSaveBath(param);
        return new CommonResult(true, "\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e\u6210\u529f", null);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public CommonResult<String> save(@ApiParam(name="param", value="\u8868\u5355\u6743\u9650\u53c2\u6570\u5bf9\u8c61") @RequestBody FormRigthParam param) {
        String id = this.bpmFormRightManager.save(param);
        return new CommonResult(true, "\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e\u6210\u529f", (Object)id);
    }

    @RequestMapping(value={"getDefaultByFormKey"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public Map<String, Object> getDefaultByFormKey(@ApiParam(name="formKey", value="\u8868\u5355KEY") @RequestParam String formKey, @ApiParam(name="type", value="\u6743\u9650\u7c7b\u578b ") @RequestParam String type) throws IOException {
        boolean isInstance = !"1".equals(type);
        String formMetaKey = this.bpmFormDefManager.getMetaKeyByFormKey(formKey);
        JsonNode json = this.bpmFormRightManager.getDefaultByFormDefKey(formMetaKey, isInstance);
        HashMap<String, Object> jo = new HashMap<String, Object>();
        jo.put("json", json);
        List<Map<String, String>> tableSn = this.bpmFormRightManager.getTableOrderBySn(formKey);
        int maxSn = tableSn.size();
        Iterator iterator = json.get("table").fields();
        while (iterator.hasNext()) {
            HashMap snMap;
            Map.Entry next = (Map.Entry)iterator.next();
            JsonNode tab = (JsonNode)next.getValue();
            if (tab.hasNonNull("ctrlType") && "formTable".equals(tab.get("ctrlType").asText())) {
                snMap = new HashMap();
                snMap.put("desc_", tab.get("description").asText());
                snMap.put("name_", next.getKey());
                snMap.put("type_", "onetoone");
                snMap.put("ctrlType", "formTable");
                snMap.put("sn_", String.valueOf(maxSn));
                ++maxSn;
                tableSn.add(snMap);
            }
            if (!tab.hasNonNull("ctrlType") || !"dataView".equals(tab.get("ctrlType").asText())) continue;
            snMap = new HashMap();
            snMap.put("desc_", tab.get("description").asText());
            snMap.put("name_", next.getKey());
            snMap.put("type_", "onetoone");
            snMap.put("ctrlType", "dataView");
            snMap.put("sn_", String.valueOf(maxSn));
            ++maxSn;
            tableSn.add(snMap);
        }
        jo.put("tableSn", tableSn);
        return jo;
    }

    @RequestMapping(value={"emptyAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6e05\u7a7a\u6d41\u7a0b\u7ed1\u5b9a\u7684\u6240\u6709\u8868\u5355\u6743\u9650", httpMethod="GET", notes="\u6e05\u7a7a\u6d41\u7a0b\u7ed1\u5b9a\u7684\u6240\u6709\u8868\u5355\u6743\u9650")
    public CommonResult<String> emptyAll(@ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey, @ApiParam(name="flowKey", value="\u6d41\u7a0bKEY") @RequestParam Optional<String> flowKey) throws Exception {
        this.bpmFormRightManager.emptyAll(formKey, flowKey.orElse(null));
        return new CommonResult(true, "\u6e05\u7a7a\u8868\u5355\u6743\u9650\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"removeByFlowKeys"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6e05\u7a7a\u6d41\u7a0b\u7ed1\u5b9a\u7684\u6240\u6709\u8868\u5355\u6743\u9650", httpMethod="GET", notes="\u6e05\u7a7a\u6d41\u7a0b\u7ed1\u5b9a\u7684\u6240\u6709\u8868\u5355\u6743\u9650")
    public CommonResult<String> removeByFlowKeys(String ... flowKeys) throws Exception {
        this.bpmFormRightManager.removeByFlowKeys(flowKeys);
        return new CommonResult(true, "\u5220\u9664\u8868\u5355\u6743\u9650\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"saveSub"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public void saveSub(@ApiParam(name="nodeId", value="\u8282\u70b9ID") @RequestBody String nodeId, @ApiParam(name="defId", value="\u6743\u9650\u7c7b\u578b ") @RequestBody String defId, @ApiParam(name="parentDefKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49") @RequestBody String parentDefKey) throws Exception {
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u8868\u5355\u6743\u9650\u914d\u7f6e", httpMethod="GET", notes="\u5220\u9664\u8868\u5355\u6743\u9650")
    public CommonResult<String> remove(@ApiParam(name="flowKey", value="\u6d41\u7a0bkey") @RequestParam String flowKey, @ApiParam(name="nodeId", value="\u8282\u70b9ID") @RequestParam String nodeId, @ApiParam(name="parentFlowKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49KEY") @RequestParam String parentFlowKey) throws Exception {
        this.bpmFormRightManager.remove(flowKey, nodeId, parentFlowKey);
        return new CommonResult(true, "\u8868\u5355\u8bbe\u7f6e\u5df2\u6e05\u9664\uff01", null);
    }

    @RequestMapping(value={"getByTeam"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49KEY\u3001\u8282\u70b9ID\u5224\u65ad\u5f53\u524d\u8282\u70b9\u5ba1\u6279\u8bb0\u5f55\u662f\u5426\u663e\u793a", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49KEY\u3001\u8282\u70b9ID\u5224\u65ad\u5f53\u524d\u8282\u70b9\u5ba1\u6279\u8bb0\u5f55\u662f\u5426\u663e\u793a")
    public String getByTeam(@ApiParam(name="flowKey", value="\u6d41\u7a0bkey") @RequestParam String flowKey, @ApiParam(name="nodeId", value="\u8282\u70b9ID") @RequestParam String nodeId) throws Exception {
        String isCheckOpinion = "";
        isCheckOpinion = this.bpmFormRightManager.getByTeam(flowKey, nodeId);
        if (StringUtil.isEmpty((String)isCheckOpinion)) {
            isCheckOpinion = "false";
        }
        return isCheckOpinion;
    }

    @RequestMapping(value={"updateFormRightNodeById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355\u6743\u9650\u8282key", httpMethod="GET", notes="\u66f4\u65b0\u8868\u5355\u6743\u9650\u8282key")
    public void updateFormRightNodeById(@ApiParam(name="formRightId", value="\u6743\u9650\u8868ID") @RequestParam String formRightId, @ApiParam(name="nodeKey", value="\u8282\u70b9ID") @RequestParam String nodeKey) throws Exception {
        this.bpmFormRightManager.updateFormRightNodeById(formRightId, nodeKey);
    }
}

