/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.model.FormUrlForm;
import com.hotent.form.persistence.manager.FormUrlFormManager;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/formUrlForm/v1/"})
public class FormUrlFormController
extends BaseController<FormUrlFormManager, FormUrlForm> {
    @Resource
    FormUrlFormManager formUrlFormManager;

    @PostMapping(value={"querList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2")
    public PageList<FormUrlForm> querList(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestParam Optional<String> formType, @ApiParam(name="status", value="\u662f\u5426\u53d1\u5e03") @RequestParam Optional<String> status, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam Optional<String> formKey) throws Exception {
        return this.formUrlFormManager.querList(queryFilter, formType, status, formKey);
    }

    @GetMapping(value={"getDetail"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6URL\u8868\u5355\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6URL\u8868\u5355\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public CommonResult<FormUrlForm> getDetail(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam(required=true) String id) throws Exception {
        return CommonResult.ok().value((Object)((FormUrlFormManager)this.baseService).getDetail(id));
    }

    @GetMapping(value={"getByFormId"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u53d6\u5f97\u8868\u5355\u5bf9\u8c61\u3002", httpMethod="GET", notes="\u6839\u636e\u8868\u5355ID\u53d6\u5f97\u8868\u5355\u5bf9\u8c61\u3002")
    public FormUrlForm getByFormId(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) {
        return ((FormUrlFormManager)this.baseService).getDetail(formId);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0URL\u8868\u5355\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0URL\u8868\u5355\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="FormUrlForm", value="URL\u8868\u5355\u7ba1\u7406\u5bf9\u8c61", required=true) @RequestBody FormUrlForm formUrlForm) throws Exception {
        String msg = StringUtil.isEmpty((String)formUrlForm.getId()) ? "\u6dfb\u52a0URL\u8868\u5355\u7ba1\u7406\u6210\u529f" : "\u66f4\u65b0URL\u8868\u5355\u7ba1\u7406\u6210\u529f";
        ((FormUrlFormManager)this.baseService).createOrUpdate(formUrlForm);
        return CommonResult.ok().message(msg);
    }

    @PostMapping(value={"saveData"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0URL\u8868\u5355\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0URL\u8868\u5355\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> saveData(@ApiParam(name="FormUrlForm", value="URL\u8868\u5355\u7ba1\u7406\u5bf9\u8c61", required=true) @RequestBody FormUrlForm formUrlForm) throws Exception {
        String msg;
        String string = msg = StringUtil.isEmpty((String)formUrlForm.getId()) ? "\u6dfb\u52a0URL\u8868\u5355\u7ba1\u7406\u6210\u529f" : "\u66f4\u65b0URL\u8868\u5355\u7ba1\u7406\u6210\u529f";
        if (StringUtil.isEmpty((String)formUrlForm.getId())) {
            ((FormUrlFormManager)this.baseService).create((Model)formUrlForm);
        } else {
            ((FormUrlFormManager)this.baseService).update((Model)formUrlForm);
        }
        return new CommonResult(true, msg, (Object)formUrlForm.getId());
    }

    @PostMapping(value={"publishData"})
    @ApiOperation(value="\u53d1\u5e03\u8868\u5355", httpMethod="POST", notes="\u53d1\u5e03\u8868\u5355")
    public CommonResult<String> publishData(@ApiParam(name="FormUrlForm", value="URL\u8868\u5355\u7ba1\u7406\u5bf9\u8c61", required=true) @RequestBody FormUrlForm formUrlForm) throws Exception {
        ((FormUrlFormManager)this.baseService).publishData(formUrlForm);
        return new CommonResult(true, "\u53d1\u5e03\u6210\u529f");
    }

    @PostMapping(value={"newVersion"})
    @ApiOperation(value="\u53d1\u5e03\u65b0\u7248", httpMethod="POST", notes="\u53d1\u5e03\u65b0\u7248")
    public CommonResult<String> newVersion(@ApiParam(name="FormUrlForm", value="URL\u8868\u5355\u7ba1\u7406\u5bf9\u8c61", required=true) @RequestBody FormUrlForm formUrlForm) throws Exception {
        this.formUrlFormManager.newVersion(formUrlForm);
        return CommonResult.ok().message("\u53d1\u5e03\u65b0\u7248\u6210\u529f");
    }

    @GetMapping(value={"newVersionById"})
    @ApiOperation(value="\u53d1\u5e03\u65b0\u7248", httpMethod="GET", notes="\u53d1\u5e03\u65b0\u7248")
    public CommonResult<String> newVersionById(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam(required=true) String id) throws Exception {
        this.formUrlFormManager.newVersion(id);
        return CommonResult.ok().message("\u53d1\u5e03\u65b0\u7248\u6210\u529f");
    }

    @GetMapping(value={"publish"})
    @ApiOperation(value="\u53d1\u5e03", httpMethod="GET", notes="\u53d1\u5e03")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam(required=true) String id) throws Exception {
        this.formUrlFormManager.publish(id);
        return CommonResult.ok().message("\u53d1\u5e03\u6210\u529f");
    }

    @GetMapping(value={"setDefaultVersion"})
    @ApiOperation(value="\u8bbe\u7f6e\u4e3b\u7248\u672c", httpMethod="GET", notes="\u8bbe\u7f6e\u4e3b\u7248\u672c")
    public CommonResult<String> setDefaultVersion(@ApiParam(name="id", value="ID") @RequestParam String id, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey) throws Exception {
        this.formUrlFormManager.setDefaultVersion(id, formKey);
        return CommonResult.ok().message("\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c\u6210\u529f");
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u4e3b\u7248\u672c\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8868\u5355\u4e3b\u7248\u672c\u8bb0\u5f55")
    public CommonResult<String> remove(String ... ids) throws Exception {
        ((FormUrlFormManager)this.baseService).removeMainVersion(ids);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"removeVersions"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u975e\u4e3b\u7248\u672c\u7684\u8868\u5355\u7248\u672c", httpMethod="DELETE", notes="\u5220\u9664\u975e\u4e3b\u7248\u672c\u7684\u8868\u5355\u7248\u672c")
    public CommonResult<String> removeVersions(@ApiParam(name="ids", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355ID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestParam(required=true) String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        ((FormUrlFormManager)this.baseService).removeVersions(aryIds);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"getMainByFormKey"})
    @ApiOperation(value="\u83b7\u53d6\u4e3b\u7248\u672c\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u4e3b\u7248\u672c\u4fe1\u606f")
    public FormUrlForm getMainByFormKey(@ApiParam(name="formKey", value="key") @RequestParam String formKey) throws Exception {
        return ((FormUrlFormManager)this.baseService).getMainByFormKey(formKey);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "formUrlForm_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = JsonUtil.toJson(this.formUrlFormManager.getExportDataMapByIds(idList));
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"formUrlForm.json", (String)fileName);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165url\u8868\u5355", httpMethod="POST", notes="\u5bfc\u5165url\u8868\u5355")
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult<String> res = this.formUrlFormManager.importCheck(request, response, typeId);
        return res;
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165url\u8868\u5355", httpMethod="POST", notes="\u5bfc\u5165url\u8868\u5355")
    public CommonResult<String> importSave(@ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id", required=false) @RequestParam String cacheFileId, @ApiParam(name="confirmImport", value="\u786e\u8ba4\u66f4\u65b0", required=true) @RequestParam Boolean confirmImport, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult<String> res = this.formUrlFormManager.importSave(cacheFileId, confirmImport, typeId);
        return res;
    }
}

