/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.controller.BaseController;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExpressionUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.enums.ViewType;
import com.hotent.form.model.QueryMetafield;
import com.hotent.form.model.QuerySqldef;
import com.hotent.form.model.QuerySqldefXmlList;
import com.hotent.form.model.QueryView;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.form.persistence.manager.QueryMetafieldManager;
import com.hotent.form.persistence.manager.QuerySqldefManager;
import com.hotent.form.persistence.manager.QueryViewManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"\u81ea\u5b9a\u4e49SQL"})
@ApiGroup(group={"group_form"})
@RequestMapping(value={"/form/query/querySqldef"})
public class QuerySqldefController
extends BaseController<QuerySqldefManager, QuerySqldef> {
    @Resource
    QuerySqldefManager querySqldefManager;
    @Resource
    QueryMetafieldManager queryMetafieldManager;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    QueryViewManager queryViewManager;
    @Resource
    CustomDialogManager customDialogManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResourcePermissionCheck
    @ResponseBody
    public PageList<QuerySqldef> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<QuerySqldef> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.querySqldefManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u660e\u7ec6", httpMethod="GET", notes="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u660e\u7ec6")
    public QuerySqldef getJson(@ApiParam(name="id", value="id") @RequestParam Optional<String> id, @ApiParam(name="alias", value="alias") @RequestParam Optional<String> alias) throws Exception {
        String id_ = id.orElse("");
        String alias_ = alias.orElse("");
        QuerySqldef querySqldef = null;
        if (StringUtil.isNotEmpty((String)id_)) {
            querySqldef = (QuerySqldef)this.querySqldefManager.get((Serializable)((Object)id_));
        } else if (StringUtil.isNotEmpty((String)alias_)) {
            querySqldef = this.querySqldefManager.getByAlias(alias_);
        }
        if (querySqldef != null) {
            querySqldef.setMetafields(this.queryMetafieldManager.getBySqlId(querySqldef.getId()));
            if (ViewType.customDialog.equals((Object)querySqldef.getViewType())) {
                querySqldef.setCustomDialog(this.customDialogManager.getByAlias(querySqldef.getCustomDialogAlias()));
            }
        }
        return querySqldef;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49", httpMethod="POST", notes="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49")
    public CommonResult<String> save(@ApiParam(name="queryView", value="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u4fe1\u606f", required=true) @RequestBody QuerySqldef querySqldef) throws Exception {
        return this.querySqldefManager.saveSql(querySqldef);
    }

    @RequestMapping(value={"refreshFields"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5237\u65b0\u5b57\u6bb5", httpMethod="GET", notes="\u5237\u65b0\u5b57\u6bb5")
    public List<QueryMetafield> refreshFields(@ApiParam(name="refreshFields", value="\u5237\u65b0\u5b57\u6bb5", required=true) @RequestParam String id) throws Exception {
        return this.querySqldefManager.refreshFields(id);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5220\u9664\u6570\u636e\u5217\u8868\u914d\u7f6e", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5220\u9664\u6570\u636e\u5217\u8868\u914d\u7f6e")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49ID!\u591a\u4e2aID\u7528,\u5206\u5272", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.querySqldefManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6570\u636e\u5217\u8868\u914d\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"checkSql"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1sql", httpMethod="POST", notes="\u9a8c\u8bc1sql")
    public CommonResult<String> checkSql(@ApiParam(name="sql", value="\u5f85\u9a8c\u8bc1\u7684sql") @RequestBody ObjectNode obj) throws Exception {
        return (CommonResult)this.databaseContext.switchDS(obj.get("dsName").asText(), () -> {
            try {
                if (JsonUtil.getBoolean((ObjectNode)obj, (String)"isBatch")) {
                    JsonNode sqlNode = obj.get("sql");
                    for (int i = 0; i < sqlNode.size(); ++i) {
                        String sql = ExpressionUtil.format((String)sqlNode.get(i).asText(), (Map)JsonUtil.toMap((String)JsonUtil.toJsonString((Object)obj.get("vars"))));
                        this.querySqldefManager.checkSqlAll(sql);
                    }
                    return new CommonResult("\u9a8c\u8bc1\u901a\u8fc7");
                }
                String sql = ExpressionUtil.format((String)obj.get("sql").asText(), (Map)JsonUtil.toMap((String)JsonUtil.toJsonString((Object)obj.get("vars"))));
                this.querySqldefManager.checkSqlAll(sql);
                return new CommonResult("\u9a8c\u8bc1\u901a\u8fc7");
            }
            catch (Exception e) {
                return new CommonResult(false, "SQL\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage());
            }
        });
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        if (BeanUtils.isEmpty((Object)ids)) {
            return;
        }
        String[] idList = ids.split(",");
        String xml = this.querySqldefManager.export(idList);
        String fileName = "sqldef_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)xml, (String)"sqldef.xml", (String)fileName);
    }

    @RequestMapping(value={"exportData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public Map<String, Object> exportData(String ... ids) throws Exception {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        List<QueryView> views = this.queryViewManager.getByIds(ids);
        List sqlAlias = views.stream().map(QueryView::getSqlAlias).collect(Collectors.toList());
        Assert.notEmpty(sqlAlias, (String)"\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u5217\u8868");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(QuerySqldef::getAlias, sqlAlias);
        String data = this.querySqldefManager.export((String[])this.querySqldefManager.list((Wrapper)wrapper).stream().map(QuerySqldef::getId).toArray(String[]::new));
        rtn.put("sqldef", data);
        return rtn;
    }

    @RequestMapping(value={"importData1"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u6570\u636e")
    public CommonResult<Map<String, String>> importData1(@ApiParam(name="ids", value="ids", required=true) @RequestBody String xml, @RequestParam(value="isCover") boolean isCover) throws Exception {
        QuerySqldefXmlList list = (QuerySqldefXmlList)JAXBUtil.unmarshall((String)xml, QuerySqldefXmlList.class);
        return this.querySqldefManager.importData(list, isCover);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public List<ImportCheckResult> importCheck(@RequestBody String xml) throws Exception {
        QuerySqldefXmlList list = (QuerySqldefXmlList)JAXBUtil.unmarshall((String)xml, QuerySqldefXmlList.class);
        return this.querySqldefManager.importCheck(list);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165BO\u5bf9\u8c61", httpMethod="POST", notes="\u5bfc\u5165BO\u5bf9\u8c61")
    public CommonResult<String> importBo(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonResult<String> res = this.querySqldefManager.importBo(request, response);
        return res;
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e\u89c6\u56fe\u8df3\u8fc7", httpMethod="POST", notes="\u5bfc\u5165\u6570\u636e\u89c6\u56fe\u8df3\u8fc7")
    public CommonResult<String> importData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath) throws Exception {
        CommonResult<String> res = this.querySqldefManager.importFileData(unZipFilePath);
        return res;
    }
}

