/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.generator.generate;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.form.generator.GeneratorModel;
import com.hotent.form.generator.dbQuery.SqlServer2005Query;
import com.hotent.form.generator.impl.DynamicDataSourceConfig;
import com.hotent.form.model.FormDataTemplate;
import com.hotent.form.model.QuerySqldef;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.QuerySqldefManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.util.Assert;

public class DataSourceConfigGenerator {
    public static DataSourceConfig generate(GeneratorModel generatorModel) throws SQLException {
        String type = generatorModel.getType();
        String dataSourceAlias = generatorModel.getDataSourceAlias();
        String[] tableName = generatorModel.getTableName();
        if (BeanUtils.isEmpty((Object)tableName)) {
            tableName = new String[]{};
        }
        String formkey = generatorModel.getFormkey();
        ArrayList<BoEnt> boEntList = new ArrayList<BoEnt>();
        if ("table".equals(type)) {
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)tableName), (String)"\u5fc5\u987b\u4f20\u5165\u7269\u7406\u8868\u540d");
        } else if ("form".equals(type) || "dataTemplate".equals(type)) {
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)formkey), (String)"\u5fc5\u987b\u4f20\u5165\u8868\u5355Key\u6216\u8868\u5355\u5217\u8868\u522b\u540d");
            if ("dataTemplate".equals(type)) {
                FormDataTemplateManager formDataTemplateManager = (FormDataTemplateManager)AppUtil.getBean(FormDataTemplateManager.class);
                FormDataTemplate dataTemplate = formDataTemplateManager.getByAlias(formkey);
                Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)dataTemplate)), (String)String.format("\u67e5\u65e0\u522b\u540d[%s]\u5bf9\u5e94\u7684\u8868\u5355\u5217\u8868", formkey));
                generatorModel.setDataTemplate(dataTemplate);
                formkey = dataTemplate.getFormKey();
            }
            BoDefManager boDefManager = (BoDefManager)AppUtil.getBean(BoDefManager.class);
            List boDefList = boDefManager.getByFormKey(formkey);
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)boDefList), (String)String.format("\u672a\u83b7\u53d6\u5230formkey:%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61", formkey));
            HashSet tableNameSet = new HashSet();
            HashSet boDataSourceAlias = new HashSet();
            boDefList.forEach(bd -> {
                BoDef boDef = boDefManager.getByAlias(bd.getAlias());
                BoEnt boEnt = boDef.getBoEnt();
                boEntList.add(boEnt);
                tableNameSet.add(boEnt.getTableName());
                if (boEnt.isExternal()) {
                    boDataSourceAlias.add(boEnt.getDsName());
                }
                List childEntList = boEnt.getChildEntList();
                childEntList.forEach(cbe -> {
                    tableNameSet.add(cbe.getTableName());
                    List sunEntList = cbe.getChildEntList();
                    if (BeanUtils.isNotEmpty((Object)sunEntList)) {
                        sunEntList.forEach(sun -> tableNameSet.add(sun.getTableName()));
                    }
                });
            });
            Assert.isTrue((boDataSourceAlias.size() < 2 ? 1 : 0) != 0, (String)String.format("\u8868\u5355formkey\uff1a%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u4e8e\u4e0d\u540c\u7684\u6570\u636e\u6e90", formkey));
            if (boDataSourceAlias.size() == 1) {
                dataSourceAlias = boDataSourceAlias.parallelStream().findFirst().orElse("");
            }
            tableName = tableNameSet.toArray(new String[0]);
        } else if ("querySqldef".equals(type)) {
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)generatorModel.getSqlAlias()), (String)"\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5217\u8868\u7684\u522b\u540d");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)formkey), (String)"\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5217\u8868\u7684\u89c6\u56fe\u522b\u540d");
            QuerySqldefManager querySqldefManager = (QuerySqldefManager)AppUtil.getBean(QuerySqldefManager.class);
            QuerySqldef querySqldef = querySqldefManager.getByAlias(generatorModel.getSqlAlias());
            generatorModel.setQuerySqldef(querySqldef);
            dataSourceAlias = querySqldef.getDsName();
        }
        generatorModel.setBoEntList(boEntList);
        if (StringUtil.isEmpty((String)dataSourceAlias)) {
            dataSourceAlias = "LOCAL";
        }
        generatorModel.setDataSourceAlias(dataSourceAlias);
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        DataSource dataSourceByAlias = databaseContext.getDataSourceByAlias(dataSourceAlias);
        String dbTypeByAlias = databaseContext.getDbTypeByAlias(dataSourceAlias);
        if ("oracle".equals(dbTypeByAlias)) {
            for (int i = 0; i < tableName.length; ++i) {
                tableName[i] = tableName[i].toUpperCase();
            }
        }
        if ("postgresql".equals(dbTypeByAlias) || "kingbasees".equals(dbTypeByAlias)) {
            for (int i = 0; i < tableName.length; ++i) {
                tableName[i] = tableName[i].toLowerCase();
            }
        }
        generatorModel.setTableName(tableName);
        DynamicDataSourceConfig dynamicDataSourceConfig = new DynamicDataSourceConfig(dbTypeByAlias, dataSourceByAlias);
        if (BeanUtils.isEmpty((Object)dynamicDataSourceConfig.getUsername())) {
            dynamicDataSourceConfig.setUsername(dataSourceByAlias.getConnection().getMetaData().getUserName());
        }
        if ("kingbasees".equals(dbTypeByAlias)) {
            dynamicDataSourceConfig.setSchemaName("public");
        }
        if (DbType.SQL_SERVER2005.equals((Object)dynamicDataSourceConfig.getDbType())) {
            dynamicDataSourceConfig.setDbQuery((IDbQuery)new SqlServer2005Query());
        }
        return dynamicDataSourceConfig;
    }
}

