/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.generator.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.WebUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.form.enums.FormType;
import com.hotent.form.generator.GeneratorModel;
import com.hotent.form.generator.GeneratorService;
import com.hotent.form.generator.conf.RegistryConfig;
import com.hotent.form.generator.enums.GeneratorEnum;
import com.hotent.form.generator.generate.DataSourceConfigGenerator;
import com.hotent.form.generator.generate.FileOutConfigGenerator;
import com.hotent.form.generator.generate.GlobalConfigGenerator;
import com.hotent.form.generator.generate.PackageConfigGenerator;
import com.hotent.form.generator.generate.StrategyConfigGenerator;
import com.hotent.form.generator.generate.TemplateConfigGenerator;
import com.hotent.form.generator.impl.DynamicDataSourceConfig;
import com.hotent.form.generator.util.CodeGeneratorUtil;
import com.hotent.form.manager.FormCodegenLogManager;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormCodegenLog;
import com.hotent.form.model.FormDataTemplate;
import com.hotent.form.model.QueryView;
import com.hotent.form.param.BpmDataTemplateInfoVo;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.QueryViewManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootVersion;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MybatisPlusGeneratorService
implements GeneratorService {
    @Resource
    FormCodegenLogManager formCodegenLogManager;
    @Resource
    FormManager formManager;
    @Resource
    FormDataTemplateManager formDataTemplateManager;
    @Resource
    QueryViewManager queryViewManager;
    @Resource
    DynamicDataSourceProperties dataSourceProperties;
    @Value(value="${spring.profiles.version}")
    String parentVersion;
    @Value(value="${spring.profiles.groupId:com.hotent}")
    String baseGroupId;
    @Value(value="${spring.profiles.artifactId:base}")
    String baseArtifactId;

    private InjectionConfig getInjectionConfig(String baseProjectPath, final GeneratorModel generatorModel, final AutoGenerator gen) throws FileNotFoundException {
        final String type = generatorModel.getType();
        InjectionConfig injectionConfig = new InjectionConfig(){

            public void initMap() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("system", generatorModel.getSystem());
                String authorEmail = generatorModel.getAuthorEmail();
                String companyName = generatorModel.getCompanyName();
                if (StringUtil.isNotEmpty((String)authorEmail)) {
                    map.put("authorEmail", authorEmail);
                }
                if (StringUtil.isNotEmpty((String)companyName)) {
                    map.put("companyName", companyName);
                }
                map.put("cgUtil", new CodeGeneratorUtil());
                map.put("jsonUtil", new JsonUtil());
                map.put("type", type);
                if ("form".equals(type)) {
                    MybatisPlusGeneratorService.this.setOnlineFormInfo(generatorModel.getFormkey(), map, null);
                    map.put("boEntList", generatorModel.getBoEntList());
                }
                if ("dataTemplate".equals(type)) {
                    MybatisPlusGeneratorService.this.setDataTemplateInfo(generatorModel.getDataTemplate(), map);
                    map.put("boEntList", generatorModel.getBoEntList());
                }
                if ("querySqldef".equals(type)) {
                    MybatisPlusGeneratorService.this.setQueryViewInfo(generatorModel, map);
                }
                if (GeneratorEnum.GenType.FAST.getValue().equals(generatorModel.getGenType())) {
                    map.put("groupId", generatorModel.getGroupId());
                    map.put("artifactId", generatorModel.getArtifactId());
                    map.put("backendServerPort", generatorModel.getBackendServerPort());
                    map.put("parentVersion", MybatisPlusGeneratorService.this.parentVersion);
                    map.put("baseGroupId", MybatisPlusGeneratorService.this.baseGroupId);
                    map.put("baseArtifactId", MybatisPlusGeneratorService.this.baseArtifactId);
                    map.put("basePackage", generatorModel.getBasePackage());
                    map.put("moduleName", generatorModel.getModuleName());
                    if (!generatorModel.getBasePackage().startsWith("com.hotent.")) {
                        map.put("scanPackage", generatorModel.getBasePackage());
                    }
                    if (StringUtil.isNotEmpty((String)generatorModel.getDataSourceAlias())) {
                        DynamicDataSourceConfig dynamicDataSourceConfig = (DynamicDataSourceConfig)gen.getDataSource();
                        if (dynamicDataSourceConfig.getDataSource() instanceof DruidDataSource) {
                            DruidDataSource dataSource = (DruidDataSource)dynamicDataSourceConfig.getDataSource();
                            map.put("username", dataSource.getUsername());
                            map.put("password", dataSource.getPassword());
                            map.put("driverClassName", dataSource.getDriverClassName());
                            map.put("url", dataSource.getUrl());
                        }
                    } else {
                        DataSourceProperty dataSourceProperty = (DataSourceProperty)MybatisPlusGeneratorService.this.dataSourceProperties.getDatasource().get(MybatisPlusGeneratorService.this.dataSourceProperties.getPrimary());
                        map.put("username", dataSourceProperty.getUsername());
                        map.put("password", dataSourceProperty.getPassword());
                        map.put("driverClassName", dataSourceProperty.getDriverClassName());
                        map.put("url", dataSourceProperty.getUrl());
                        if (dataSourceProperty.getDruid() != null && StringUtil.isNotEmpty((String)dataSourceProperty.getDruid().getPublicKey())) {
                            map.put("publicKey", dataSourceProperty.getDruid().getPublicKey());
                        }
                    }
                    RegistryConfig registryConfig = (RegistryConfig)AppUtil.getBean(RegistryConfig.class);
                    if (registryConfig != null) {
                        if (StringUtil.isNotEmpty((String)registryConfig.getRegistryServerName())) {
                            map.put("registryServerName", registryConfig.getRegistryServerName());
                        }
                        if (StringUtil.isNotEmpty((String)registryConfig.getRegistryServerAddr())) {
                            map.put("registryServerAddr", registryConfig.getRegistryServerAddr());
                        }
                        if (StringUtil.isNotEmpty((String)registryConfig.getRegistryUsername())) {
                            map.put("registryUsername", registryConfig.getRegistryUsername());
                        }
                        if (StringUtil.isNotEmpty((String)registryConfig.getRegistryPassword())) {
                            map.put("registryPassword", registryConfig.getRegistryPassword());
                        }
                        if (StringUtil.isNotEmpty((String)registryConfig.getRegistryNamespace())) {
                            map.put("registryNamespace", registryConfig.getRegistryNamespace());
                        }
                        if (StringUtil.isNotEmpty((String)registryConfig.getRegistryGroup())) {
                            map.put("registryGroup", registryConfig.getRegistryGroup());
                        }
                    }
                }
                map.put("springbootVersion", SpringBootVersion.getVersion());
                map.put("isFlow", BeanUtils.isNotEmpty((Object)generatorModel.getFlowKey()));
                map.put("instIdProp", generatorModel.getInstIdProp());
                map.put("flowStatusProp", generatorModel.getFlowStatusProp());
                this.setMap(map);
                this.setFileCreate((configBuilder, fileType, filePath) -> CodeGeneratorUtil.createFile(configBuilder, filePath));
            }
        };
        List<FileOutConfig> fileOutConfigs = FileOutConfigGenerator.generate(baseProjectPath, generatorModel);
        injectionConfig.setFileOutConfigList(fileOutConfigs);
        return injectionConfig;
    }

    private void setOnlineFormInfo(String formkey, Map<String, Object> map, String type) {
        try {
            Map<String, Object> previewDesignVueData = this.formManager.getPreviewDesignVueDataByFormKey(formkey);
            Form mainByFormKey = (Form)((Object)previewDesignVueData.get("bpmForm"));
            String formHtml = mainByFormKey.getFormHtml();
            ObjectNode permission = (ObjectNode)previewDesignVueData.get("permission");
            ObjectNode permissionFields = (ObjectNode)permission.get("fields");
            ObjectNode data = (ObjectNode)previewDesignVueData.get("data");
            ObjectNode camelObj = JsonUtil.createObjectNode();
            ObjectNode camelPermissionFields = JsonUtil.createObjectNode();
            formHtml = this.transToCamel(permissionFields, camelPermissionFields, formHtml, "permission.fields.");
            Iterator iterator = data.fields();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                String entityName = (String)next.getKey();
                if (!StringUtil.isNotEmpty((String)entityName)) continue;
                String camelEntityName = StringUtil.underlineToHump((String)entityName);
                JsonNode value = (JsonNode)next.getValue();
                if (value instanceof TextNode) {
                    camelObj.put(camelEntityName, StringUtil.underlineToHump((String)value.asText()));
                    continue;
                }
                if (!(value instanceof ObjectNode)) continue;
                ObjectNode objValue = (ObjectNode)value;
                ObjectNode camelObj1 = JsonUtil.createObjectNode();
                Iterator iterator1 = objValue.fields();
                while (iterator1.hasNext()) {
                    Map.Entry next1 = (Map.Entry)iterator1.next();
                    String fieldName = (String)next1.getKey();
                    if (!StringUtil.isNotEmpty((String)fieldName)) continue;
                    if (fieldName.equals("initData")) {
                        ObjectNode initDataObj = JsonUtil.createObjectNode();
                        formHtml = this.transToCamel((ObjectNode)next1.getValue(), initDataObj, formHtml, "item.");
                        next1.setValue(initDataObj);
                    }
                    String camelFieldName = StringUtil.underlineToHump((String)fieldName);
                    JsonNode value1 = (JsonNode)next1.getValue();
                    if (value1 instanceof TextNode) {
                        camelObj1.put(camelFieldName, StringUtil.underlineToHump((String)value1.asText()));
                    } else if (value1 instanceof ObjectNode || value1 instanceof ArrayNode) {
                        camelObj1.set(camelFieldName, value1);
                    }
                    String fieldPath = entityName + "." + fieldName;
                    String camelFieldPath = camelEntityName + "." + camelFieldName;
                    String halfCamelFieldPath = camelEntityName + "." + fieldName;
                    formHtml = formHtml.replaceAll(fieldPath, camelFieldPath).replaceAll(halfCamelFieldPath, camelFieldPath).replaceAll("item." + entityName, "item." + camelEntityName).replaceAll("data." + entityName, "data." + camelEntityName);
                }
                camelObj.set(camelEntityName, (JsonNode)camelObj1);
            }
            permission.set("fields", (JsonNode)camelPermissionFields);
            mainByFormKey.setFormHtml(formHtml);
            if ("mobile".equals(type)) {
                map.put("mobileForm", (Object)mainByFormKey);
                map.put("mobilePermission", permission);
            } else {
                map.put("form", (Object)mainByFormKey);
                map.put("permission", permission);
            }
            map.put("data", camelObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String transToCamel(ObjectNode oldObj, ObjectNode newObj, String html, String changeMark) {
        String newHtml = html;
        Iterator iterator = oldObj.fields();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            String entityName = (String)next.getKey();
            if (!StringUtil.isNotEmpty((String)entityName)) continue;
            String camelEntityName = StringUtil.underlineToHump((String)entityName);
            JsonNode value = (JsonNode)next.getValue();
            if (value instanceof TextNode) {
                newObj.put(camelEntityName, StringUtil.underlineToHump((String)value.asText()));
                continue;
            }
            if (!(value instanceof ObjectNode)) continue;
            ObjectNode objValue = (ObjectNode)value;
            ObjectNode camelObj1 = JsonUtil.createObjectNode();
            Iterator iterator1 = objValue.fields();
            while (iterator1.hasNext()) {
                Map.Entry next1 = (Map.Entry)iterator1.next();
                String fieldName = (String)next1.getKey();
                if (!StringUtil.isNotEmpty((String)fieldName)) continue;
                String camelFieldName = StringUtil.underlineToHump((String)fieldName);
                JsonNode value1 = (JsonNode)next1.getValue();
                if (value1 instanceof TextNode) {
                    camelObj1.put(camelFieldName, StringUtil.underlineToHump((String)value1.asText()));
                } else if (value1 instanceof ObjectNode) {
                    camelObj1.set(camelFieldName, value1);
                }
                String fieldPath = entityName + "." + fieldName;
                String camelFieldPath = camelEntityName + "." + camelFieldName;
                if ("item.".equals(changeMark)) {
                    newHtml = newHtml.replaceAll(changeMark + fieldName, changeMark + camelFieldName);
                    continue;
                }
                newHtml = newHtml.replaceAll(changeMark + fieldPath, changeMark + camelFieldPath);
            }
            newObj.set(camelEntityName, (JsonNode)camelObj1);
        }
        return newHtml;
    }

    private void setDataTemplateInfo(FormDataTemplate dataTemplate, Map<String, Object> map) {
        try {
            String dataTemplateHtml = this.formDataTemplateManager.generatorTemplateHtmlCode(dataTemplate.getAlias(), new HashMap<String, Object>(), new HashMap<String, Object>(), FormType.PC);
            map.put("dataTemplateHtml", dataTemplateHtml);
            CommonResult<BpmDataTemplateInfoVo> bpmDataTemplateInfo = this.formDataTemplateManager.getBpmDataTemplateInfo(dataTemplate.getAlias(), Optional.of(false));
            ((BpmDataTemplateInfoVo)((Object)bpmDataTemplateInfo.getValue())).setTemplateHtml("");
            map.put("dataTemplateInfo", JsonUtil.toJsonString((Object)bpmDataTemplateInfo.getValue()));
            this.setOnlineFormInfo(dataTemplate.getFormKey(), map, null);
            if (BeanUtils.isNotEmpty((Object)dataTemplate.getMobileFormAlias())) {
                String mobileDataTemplateHtml = this.formDataTemplateManager.generatorTemplateHtmlCode(dataTemplate.getAlias(), new HashMap<String, Object>(), new HashMap<String, Object>(), FormType.MOBILE);
                map.put("mobileDataTemplateHtml", mobileDataTemplateHtml);
                this.setOnlineFormInfo(dataTemplate.getMobileFormAlias(), map, "mobile");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setQueryViewInfo(GeneratorModel generatorModel, Map<String, Object> map) {
        QueryView queryView = this.queryViewManager.getJson(Optional.of(""), Optional.of(generatorModel.getSqlAlias()), Optional.of(generatorModel.getFormkey()));
        map.put("queryViewTemplate", queryView.getTemplate());
        queryView.setTemplate("");
        map.put("queryViewInfo", JsonUtil.toJsonString((Object)((Object)queryView)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generate(GeneratorModel generatorModel) throws IOException, SQLException {
        AutoGenerator gen = new AutoGenerator();
        gen.setDataSource(DataSourceConfigGenerator.generate(generatorModel));
        String tmpdir = FileUtil.getIoTmpdir();
        String codeFolder = String.format("eipcode-%s", LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        String baseProjectPath = String.format("%s%s", tmpdir.endsWith(File.separator) ? tmpdir : tmpdir + File.separator, codeFolder);
        gen.setGlobalConfig(GlobalConfigGenerator.generate(String.format("%s%s", CodeGeneratorUtil.getBackendProjectPath(baseProjectPath, generatorModel), "/src/main/java".replace("/", File.separator)), generatorModel.getAuthorName()));
        gen.setStrategy(StrategyConfigGenerator.generate(generatorModel.getTableName()));
        gen.setPackageInfo(PackageConfigGenerator.generate(generatorModel.getBasePackage(), generatorModel.getModuleName()));
        gen.setCfg(this.getInjectionConfig(baseProjectPath, generatorModel, gen));
        gen.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        gen.setTemplate(TemplateConfigGenerator.generate());
        this.tempFileInit(baseProjectPath, generatorModel);
        if ("querySqldef".equals(generatorModel.getType())) {
            this.executeGenerateQuerySqlsef(gen, generatorModel);
        } else {
            gen.execute();
        }
        this.saveCodegenLog(generatorModel);
        return codeFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tempFileInit(String baseProjectPath, GeneratorModel generatorModel) {
        if (GeneratorEnum.GenType.FAST.getValue().equals(generatorModel.getGenType())) {
            String tempFilePath = baseProjectPath + "/temp.zip";
            File tempFile = new File(tempFilePath);
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/template/codegen/fast/front-template.zip");
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                ZipUtil.unZipFile((String)tempFilePath, (String)baseProjectPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (tempFile.exists() && tempFile.isFile()) {
                    tempFile.delete();
                }
            }
        }
    }

    private void executeGenerateQuerySqlsef(AutoGenerator autoGenerator, GeneratorModel generatorModel) {
        try {
            boolean exist;
            File file;
            InjectionConfig cfg = autoGenerator.getCfg();
            cfg.initMap();
            TableInfo tableInfo = this.processTable(autoGenerator, generatorModel);
            if (autoGenerator.getStrategy() != null) {
                TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
                Statement statement = CCJSqlParserUtil.parse((String)generatorModel.getQuerySqldef().getSql());
                List tableNameList = tablesNamesFinder.getTableList(statement);
                if (BeanUtils.isNotEmpty((Object)tableNameList)) {
                    autoGenerator.getStrategy().setInclude(tableNameList.toArray(new String[tableNameList.size()]));
                } else {
                    autoGenerator.getStrategy().setInclude(new String[]{"default_table"});
                }
            }
            AbstractTemplateEngine templateEngine = autoGenerator.getTemplateEngine();
            ConfigBuilder configBuilder = new ConfigBuilder(autoGenerator.getPackageInfo(), autoGenerator.getDataSource(), autoGenerator.getStrategy(), autoGenerator.getTemplate(), autoGenerator.getGlobalConfig());
            templateEngine.init(configBuilder);
            Map objectMap = templateEngine.getObjectMap(tableInfo);
            objectMap.put("cfg", cfg.getMap());
            List fileOutConfigList = cfg.getFileOutConfigList();
            templateEngine.mkdirs();
            for (FileOutConfig foc : fileOutConfigList) {
                File file2 = new File(foc.outputFile(tableInfo));
                boolean exist2 = file2.exists();
                if (!exist2) {
                    file2.getParentFile().mkdirs();
                }
                templateEngine.writer(objectMap, foc.getTemplatePath(), foc.outputFile(tableInfo));
            }
            Map pathInfo = configBuilder.getPathInfo();
            TemplateConfig template = configBuilder.getTemplate();
            String entityName = tableInfo.getEntityName();
            if (null != entityName && null != pathInfo.get("entity_path")) {
                String entityFile = String.format((String)pathInfo.get("entity_path") + File.separator + "%s" + ".java", entityName);
                file = new File(entityFile);
                exist = file.exists();
                if (!exist) {
                    file.getParentFile().mkdirs();
                }
                templateEngine.writer(objectMap, templateEngine.templateFilePath(template.getEntity(configBuilder.getGlobalConfig().isKotlin())), entityFile);
            }
            if (null != tableInfo.getMapperName() && null != pathInfo.get("mapper_path")) {
                String mapperFile = String.format((String)pathInfo.get("mapper_path") + File.separator + tableInfo.getMapperName() + ".java", entityName);
                file = new File(mapperFile);
                exist = file.exists();
                if (!exist) {
                    file.getParentFile().mkdirs();
                }
                templateEngine.writer(objectMap, templateEngine.templateFilePath(template.getMapper()), mapperFile);
            }
            if (null != tableInfo.getServiceName() && null != pathInfo.get("service_path")) {
                String serviceFile = String.format((String)pathInfo.get("service_path") + File.separator + tableInfo.getServiceName() + ".java", entityName);
                file = new File(serviceFile);
                exist = file.exists();
                if (!exist) {
                    file.getParentFile().mkdirs();
                }
                templateEngine.writer(objectMap, templateEngine.templateFilePath(template.getService()), serviceFile);
            }
            if (null != tableInfo.getServiceImplName() && null != pathInfo.get("service_impl_path")) {
                String implFile = String.format((String)pathInfo.get("service_impl_path") + File.separator + tableInfo.getServiceImplName() + ".java", entityName);
                file = new File(implFile);
                exist = file.exists();
                if (!exist) {
                    file.getParentFile().mkdirs();
                }
                templateEngine.writer(objectMap, templateEngine.templateFilePath(template.getServiceImpl()), implFile);
            }
            if (null != tableInfo.getControllerName() && null != pathInfo.get("controller_path")) {
                String controllerFile = String.format((String)pathInfo.get("controller_path") + File.separator + tableInfo.getControllerName() + ".java", entityName);
                file = new File(controllerFile);
                exist = file.exists();
                if (!exist) {
                    file.getParentFile().mkdirs();
                }
                templateEngine.writer(objectMap, templateEngine.templateFilePath(template.getController()), controllerFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TableInfo processTable(AutoGenerator autoGenerator, GeneratorModel generatorModel) throws IOException {
        QueryView queryView = this.queryViewManager.getJson(Optional.of(""), Optional.of(generatorModel.getSqlAlias()), Optional.of(generatorModel.getFormkey()));
        TableInfo tableInfo = new TableInfo();
        tableInfo.setComment(queryView.getName());
        String entityName = NamingStrategy.capitalFirst((String)NamingStrategy.underlineToCamel((String)queryView.getAlias()));
        tableInfo.setEntityName(entityName);
        tableInfo.setMapperName(entityName + "Mapper");
        tableInfo.setXmlName(entityName + "Mapper");
        tableInfo.setServiceName(entityName + "Service");
        tableInfo.setServiceImplName(entityName + "ServiceImpl");
        tableInfo.setControllerName(entityName + "Controller");
        tableInfo.getImportPackages().add(autoGenerator.getStrategy().getSuperEntityClass());
        tableInfo.getImportPackages().add(IdType.class.getCanonicalName());
        tableInfo.getImportPackages().add(TableId.class.getCanonicalName());
        tableInfo.getImportPackages().add(com.baomidou.mybatisplus.annotation.TableField.class.getCanonicalName());
        tableInfo.getImportPackages().add("java.io.Serializable");
        this.convertTableFields(autoGenerator, generatorModel, queryView, tableInfo);
        return tableInfo;
    }

    private void convertTableFields(AutoGenerator autoGenerator, GeneratorModel generatorModel, QueryView queryView, TableInfo tableInfo) throws IOException {
        DataSourceConfig dataSourceConfig = autoGenerator.getDataSource();
        String showSql = "";
        if (StringUtil.isNotEmpty((String)queryView.getShows())) {
            ArrayNode shows = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
            this.recurField(showSql, shows);
        }
        String sql = generatorModel.getQuerySqldef().getSql();
        if (StringUtil.isNotEmpty((String)showSql)) {
            int indexOf;
            if (sql.split("from").length > 1) {
                indexOf = sql.indexOf("from");
                if (indexOf != -1) {
                    sql = "select " + showSql.replaceAll("\"", "") + " " + sql.substring(indexOf);
                }
            } else {
                indexOf = sql.indexOf("FROM");
                if (indexOf != -1) {
                    sql = "SELECT " + showSql.replaceAll("\"", "") + " " + sql.substring(indexOf);
                }
            }
        }
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        Connection connection = dataSourceConfig.getConn();
        GlobalConfig globalConfig = autoGenerator.getGlobalConfig();
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet results = preparedStatement.executeQuery();){
            ResultSetMetaData metaData = results.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                TableField field = new TableField();
                String columnName = metaData.getColumnName(i);
                String columnTypeName = metaData.getColumnTypeName(i);
                field.setName(columnName.toUpperCase());
                field.setType(columnTypeName);
                field.setPropertyName(columnName.toUpperCase());
                field.setColumnType(dataSourceConfig.getTypeConvert().processTypeConvert(globalConfig, field));
                fieldList.add(field);
            }
        }
        catch (SQLException e) {
            System.err.println("SQL Exception\uff1a" + e.getMessage());
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(new ArrayList());
        autoGenerator.getCfg().getMap().put("querySql", sql);
    }

    private void recurField(String showSql, ArrayNode shows) {
        if (BeanUtils.isNotEmpty((Object)shows)) {
            for (JsonNode show : shows) {
                if (BeanUtils.isEmpty((Object)show.get("name"))) {
                    JsonNode node = show.get("children");
                    if (!(node instanceof ArrayNode)) continue;
                    this.recurField(showSql, (ArrayNode)node);
                    continue;
                }
                if (show.get("name").toString().contains(".")) {
                    showSql = showSql + show.get("name") + " as " + show.get("fieldName") + ",";
                    continue;
                }
                showSql = showSql + show.get("name") + ",";
            }
        }
    }

    private void saveCodegenLog(GeneratorModel generatorModel) throws IOException {
        FormCodegenLog formCodegenLog = new FormCodegenLog();
        HttpServletRequest request = HttpUtil.getRequest();
        if (BeanUtils.isNotEmpty((Object)request)) {
            String ipAddr = WebUtil.getIpAddr((HttpServletRequest)request);
            formCodegenLog.setIp(ipAddr);
        }
        String type = generatorModel.getType();
        formCodegenLog.setType(type);
        if ("form".equals(type) || "dataTemplate".equals(type)) {
            formCodegenLog.setTableOrForm(generatorModel.getFormkey());
        }
        if ("querySqldef".equals(type)) {
            formCodegenLog.setTableOrForm(generatorModel.getSqlAlias() + "[" + generatorModel.getFormkey() + "]");
        } else if ("table".equals(type)) {
            formCodegenLog.setTableOrForm(StringUtil.join((String[])generatorModel.getTableName()));
        }
        String json = JsonUtil.toJson((Object)generatorModel);
        formCodegenLog.setOpeContent(json);
        this.formCodegenLogManager.create((Model)formCodegenLog);
    }

    @Override
    public void download(HttpServletResponse response, String codeFolder) throws IOException {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)codeFolder), (String)"\u4e0b\u8f7d\u4ee3\u7801\u7684\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        String tmpdir = FileUtil.getIoTmpdir();
        String baseProjectPath = String.format("%s%s", tmpdir.endsWith(File.separator) ? tmpdir : tmpdir + File.separator, codeFolder);
        ZipUtil.zip((String)baseProjectPath, (Boolean)true);
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)(baseProjectPath + ".zip"), (String)(codeFolder + ".zip"));
        FileUtil.deleteFile((String)(baseProjectPath + ".zip"));
    }
}

