/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.Tree;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.sqlbuilder.ISqlBuilder;
import com.hotent.base.sqlbuilder.SqlBuilderModel;
import com.hotent.base.sqlbuilder.service.ISqlBuilderService;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.form.model.CombinateDialog;
import com.hotent.form.model.CustomDialog;
import com.hotent.form.param.Conditionfield;
import com.hotent.form.persistence.dao.CustomDialogDao;
import com.hotent.form.persistence.manager.CombinateDialogManager;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.vo.MapTree;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="customDialogManager")
public class CustomDialogManagerImpl
extends BaseManagerImpl<CustomDialogDao, CustomDialog>
implements CustomDialogManager {
    @Resource
    CombinateDialogManager combinateDialogManager;
    @Resource
    ISqlBuilderService sqlBuilderService;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CommonManager commonManager;
    @Resource
    BpmRuntimeFeignService runtimeFeignService;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public CustomDialog getByAlias(String alias) {
        List<CustomDialog> customDialogs = this.getByAlias(Arrays.asList(alias));
        return customDialogs.isEmpty() ? null : customDialogs.get(0);
    }

    @Override
    public List<CustomDialog> getByAlias(List<String> alias) {
        List<CustomDialog> customDialogs = ((CustomDialogDao)this.baseMapper).getByAlias(alias);
        for (CustomDialog byAlias : customDialogs) {
            if (byAlias == null || byAlias.getStyle() == 1) continue;
            String displayfield = byAlias.getDisplayfield();
            String resultfield = byAlias.getResultfield();
            String conditionfield = byAlias.getConditionfield();
            String tips = byAlias.getTips();
            String dsType = byAlias.getDsType();
            boolean isDatasource = CustomDialog.DS_TYPE_DATASOURCE.equals(dsType);
            try {
                if (!"[]".equals(displayfield)) {
                    JsonNode jsonNode = JsonUtil.toJsonNode((String)displayfield);
                    String disPlay = this.getNewField(jsonNode, displayfield, isDatasource);
                    byAlias.setDisplayfield(disPlay);
                }
                if (!"[]".equals(resultfield)) {
                    JsonNode jsonNode1 = JsonUtil.toJsonNode((String)resultfield);
                    String resultField = this.getNewField(jsonNode1, resultfield, isDatasource);
                    byAlias.setResultfield(resultField);
                }
                if ("[]".equals(conditionfield)) continue;
                JsonNode jsonNode2 = JsonUtil.toJsonNode((String)conditionfield);
                String condition = this.getNewField(jsonNode2, conditionfield, isDatasource);
                byAlias.setConditionfield(condition);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return customDialogs;
    }

    private String getNewField(JsonNode jsonNode, String str, boolean isDatasource) {
        String resultStr = null;
        String dbType = SQLUtil.getDbType();
        for (int i = 0; i < jsonNode.size(); ++i) {
            String field = jsonNode.get(i).get("field").asText();
            if (isDatasource && !"postgresql".equals(dbType)) {
                field = field.toLowerCase();
            }
            if (str.indexOf(jsonNode.get(i).get("field").asText()) == -1) continue;
            String rfield = ":\"" + jsonNode.get(i).get("field").asText() + "\"";
            String brfield = ":\"" + field + "\"";
            resultStr = resultStr != null ? resultStr.replace(rfield, brfield) : str.replace(rfield, brfield);
        }
        return resultStr;
    }

    @Override
    public PageList getListData(CustomDialog customDialog, Map<String, Object> param, PageBean pageBean) throws Exception {
        String sql = "";
        List boEntList = null;
        List attr = null;
        HashMap<String, String> attrMap = new HashMap<String, String>();
        if (customDialog.getSqlBuildType() == 1) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("map", param);
            params.putAll(param);
            sql = this.groovyScriptEngine.executeString(customDialog.getDiySql(), params);
        } else {
            String dbType = this.databaseContext.getDbTypeByAlias(customDialog.getDsalias());
            SqlBuilderModel model = this.constructSqlBuilderModel(customDialog, param, dbType, "");
            String fromName = model.getFromName();
            HashMap<String, String> dataFormatMap = new HashMap<String, String>();
            if (StringUtil.isNotEmpty((String)fromName) && (boEntList = this.boEntManager.getByTableName(fromName)).size() > 0) {
                for (BoEnt boEnt : boEntList) {
                    attr = this.boAttributeManager.getByBoEnt(boEnt);
                    for (BoAttribute attribute : attr) {
                        if ("yyyy-MM-dd".equals(attribute.getFormat())) {
                            String fieldName = attribute.getFieldName();
                            attrMap.put(fieldName.toUpperCase(), fieldName.toUpperCase());
                        }
                        if (!StringUtil.isNotEmpty((String)attribute.getFormat())) continue;
                        dataFormatMap.put(attribute.getFieldName().toUpperCase(), attribute.getFormat());
                        dataFormatMap.put(attribute.getFieldName().toLowerCase(), attribute.getFormat());
                    }
                }
            }
            if (dataFormatMap.size() > 0) {
                for (int i = 0; i < model.getConditionField().size(); ++i) {
                    ObjectNode obj = (ObjectNode)model.getConditionField().get(i);
                    String key = obj.get("field").asText();
                    if (!"date".equals(obj.get("dbType").asText()) || !dataFormatMap.containsKey(key)) continue;
                    obj.put("format", (String)dataFormatMap.get(key));
                }
            }
            ISqlBuilder sqlBuilder = this.sqlBuilderService.getSqlBuilder(model);
            sql = sqlBuilder.getSql();
        }
        String finalSql = sql;
        PageList pageList = (PageList)this.databaseContext.switchDS(customDialog.getDsalias(), () -> {
            if (Short.valueOf("0").equals(customDialog.getIsTable())) {
                MultiTenantHandler.setThreadLocalIgnore();
            }
            if (customDialog.getNeedPage().booleanValue()) {
                PageBean page = pageBean == null ? new PageBean() : pageBean;
                return this.commonManager.query(finalSql, page);
            }
            return new PageList(this.commonManager.query(finalSql));
        });
        List list = pageList.getRows();
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            HashMap<String, Object> tm = new HashMap<String, Object>();
            for (String k : m.keySet()) {
                try {
                    if (BeanUtils.isNotEmpty(m.get(k)) && "java.sql.Timestamp".equals(m.get(k).getClass().getCanonicalName())) {
                        Date date = (Date)m.get(k);
                        if (date.getYear() == 70 && date.getMonth() == 0 && date.getDate() == 1) {
                            tm.put(k.toLowerCase(), DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"HH:mm:ss"));
                        } else if (date.getMinutes() == 0 && date.getHours() == 0 && date.getSeconds() == 0 && k.toLowerCase().equals(attrMap.get(k.toLowerCase()))) {
                            tm.put(k.toLowerCase(), DateFormatUtil.parse((Date)date).toLocalDate());
                        } else {
                            tm.put(k.toLowerCase(), DateFormatUtil.parse((Date)date));
                        }
                    } else {
                        tm.put(k.toLowerCase(), m.get(k));
                    }
                }
                catch (Exception e) {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                list.set(i, tm);
            }
        }
        if (!customDialog.getNeedPage().booleanValue()) {
            pageList = new PageList(list);
            pageList.setPageSize((long)list.size());
            pageList.setPage(1L);
        }
        return pageList;
    }

    @Override
    public PageList getCustomDialogData(String alias, QueryFilter filter, String mapParam) throws Exception {
        PageBean pageBean;
        PageList list;
        List querys;
        CustomDialog customDialog = null;
        if (StringUtil.isNotEmpty((String)alias)) {
            customDialog = this.getByAlias(alias);
        }
        if (customDialog == null) {
            return new PageList();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)mapParam)) {
            mapParam = "{" + mapParam + "}";
            Map map = JsonUtil.toMap((String)mapParam);
            for (Object key : map.keySet()) {
                param.put(key + "", map.get(key));
            }
        }
        if (BeanUtils.isNotEmpty((Object)filter.getParams()) && filter.getParams().containsKey("scripts")) {
            List list2 = (List)filter.getParams().get("scripts");
            for (int i = 0; i < list2.size(); ++i) {
                CommonResult result;
                Map map = (Map)list2.get(i);
                String scriptStr = (String)map.get("value");
                String property = (String)map.get("property");
                String group = (String)map.get("group");
                String operation = (String)map.get("operation");
                String string = (String)map.get("relation");
                if (!StringUtil.isNotEmpty((String)scriptStr) || !(result = this.runtimeFeignService.executeScript(scriptStr)).getState().booleanValue()) continue;
                filter.addFilter(property, result.getValue(), QueryOP.getByVal((String)operation), FieldRelation.valueOf((String)string), group);
            }
        }
        if (BeanUtils.isNotEmpty((Object)customDialog.getConditionfield())) {
            try {
                String conditionfield = customDialog.getConditionfield();
                ArrayNode confArray = (ArrayNode)JsonUtil.toJsonNode((String)conditionfield);
                for (JsonNode jsonNode : confArray) {
                    CommonResult result;
                    if (!BeanUtils.isNotEmpty((Object)jsonNode.get("defaultType")) || !"5".equals(jsonNode.get("defaultType").asText())) continue;
                    String field = jsonNode.get("field").asText();
                    String scriptStr = jsonNode.get("defaultValue").asText();
                    if (!StringUtil.isNotEmpty((String)scriptStr) || !(result = this.runtimeFeignService.executeScript(scriptStr)).getState().booleanValue()) continue;
                    param.put(field, result.getValue());
                }
            }
            catch (Exception e) {
                throw new WorkFlowException("\u6267\u884c\u53c2\u6570\u811a\u672c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getSorter())) {
            List filterSorter = filter.getSorter();
            ArrayList sorterNodes = new ArrayList();
            for (FieldSort fieldSort : filterSorter) {
                HashMap sorter = Maps.newHashMap();
                sorter.put("field", fieldSort.getProperty());
                sorter.put("sortType", fieldSort.getDirection().toString());
                sorterNodes.add(sorter);
            }
            customDialog.setSortfield(JsonUtil.toJson((Object)sorterNodes));
        }
        if ((querys = filter.getQuerys()).size() > 0) {
            for (QueryField queryField : querys) {
                param.put(queryField.getProperty(), queryField.getValue());
            }
            if (querys.size() > 1) {
                param.put("relation", ((QueryField)querys.get(1)).getRelation().value());
            }
        }
        if (BeanUtils.isNotEmpty((Object)(list = this.getListData(customDialog, param, pageBean = filter.getPageBean())))) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < list.getRows().size(); ++i) {
                HashMap map = (HashMap)list.getRows().get(i);
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof Timestamp) {
                        Timestamp times = (Timestamp)entry.getValue();
                        entry.setValue(dateFormat.format(times));
                        continue;
                    }
                    if (!(entry.getValue() instanceof Date)) continue;
                    entry.setValue(dateFormat.format(entry.getValue()));
                }
            }
        }
        return list;
    }

    private void addQuery2Condition(List<QueryField> querys, CustomDialog customDialog) throws Exception {
        ArrayNode confArray = (ArrayNode)JsonUtil.toJsonNode((String)customDialog.getConditionfield());
        querys.forEach(item -> {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("field", item.getProperty());
            node.put("defaultType", "1");
            node.put("defaultValue", item.getValue().toString());
            node.put("dbType", "varchar");
            node.put("condition", item.getOperation().value());
            confArray.add((JsonNode)node);
        });
        customDialog.setConditionfield(JsonUtil.toJsonString((Object)confArray));
    }

    @Override
    public Map getMobileCustomDialogData(Boolean isCombine, String alias) throws Exception {
        HashMap<String, Object> mv = new HashMap<String, Object>();
        CustomDialog customDialog = null;
        CustomDialog treeDialog = null;
        if (isCombine.booleanValue()) {
            CombinateDialog combine = this.combinateDialogManager.getByAlias(alias);
            treeDialog = combine.getTreeDialog();
            customDialog = combine.getListDialog();
            mv.put("combineField", combine.getField());
            mv.put("returnField", combine.getListDialog().getResultfield());
            mv.put("isSingle", combine.getListDialog().getSelectNum() == 1);
        } else {
            CustomDialog dialog = this.getByAlias(alias);
            Boolean isTree = dialog.getStyle() == 1;
            if (isTree.booleanValue()) {
                treeDialog = dialog;
                String disPlayName = JsonUtil.toJsonNode((String)dialog.getDisplayfield()).get("displayName") + "";
                mv.put("displayName", disPlayName.toUpperCase());
            } else {
                customDialog = dialog;
                mv.put("returnField", dialog.getResultfield());
                mv.put("isSingle", dialog.getSelectNum() == 1);
            }
        }
        if (customDialog != null) {
            JsonNode customDialogNode = JsonUtil.toJsonNode((Object)((Object)customDialog));
            Map custDialog = JsonUtil.toMap((String)(customDialogNode + ""));
            custDialog.put("conditionfield", JsonUtil.toJsonNode((String)customDialog.getConditionfield()));
            custDialog.put("displayfield", JsonUtil.toJsonNode((String)customDialog.getDisplayfield()));
            mv.put("listDialog", JsonUtil.toJsonNode((Object)custDialog));
        }
        if (treeDialog != null) {
            mv.put("treeDialog", (Object)treeDialog);
        }
        mv.put("isCombine", isCombine);
        return mv;
    }

    @Override
    public List geTreetData(CustomDialog customDialog, Map<String, Object> param, String dbType, String parentId) throws IOException {
        String pidKey = this.getPidKey(customDialog.getDisplayfield());
        if (customDialog.getTreeDataMode() != null && customDialog.getTreeDataMode() == 1) {
            if (StringUtil.isEmpty((String)parentId) && BeanUtils.isEmpty(param)) {
                String pid = this.getPid(customDialog, param);
                param.put(pidKey, pid);
            } else if (StringUtil.isNotEmpty((String)parentId)) {
                parentId = this.groovyScriptEngine.executeString(parentId, null);
                param.put(pidKey, parentId);
            }
            ArrayNode conditionfield = (ArrayNode)JsonUtil.toJsonNode((String)customDialog.getConditionfield());
            conditionfield.add(JsonUtil.toJsonNode((Object)this.buildParentIdConditionField(customDialog, pidKey, parentId)));
            customDialog.setConditionfield(JsonUtil.toJson((Object)conditionfield));
            String sql = this.getTreeSql(customDialog, param, dbType, "");
            if (Short.valueOf("0").equals(customDialog.getIsTable())) {
                MultiTenantHandler.setThreadLocalIgnore();
            }
            List pageList = (List)this.databaseContext.switchDS(customDialog.getDsalias(), () -> this.commonManager.query(sql), e -> {
                if (ExceptionUtil.getRootCause((Throwable)e) instanceof SQLSyntaxErrorException) {
                    this.log.error(ExceptionUtil.getRootCauseMessage((Throwable)e));
                    throw new BaseException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002");
                }
                throw new BaseException(e.getMessage());
            });
            return pageList;
        }
        String sql = this.getTreeSql(customDialog, param, dbType, pidKey);
        String pid = this.getPid(customDialog, param);
        if (Short.valueOf("0").equals(customDialog.getIsTable())) {
            MultiTenantHandler.setThreadLocalIgnore();
        }
        List pageList = (List)this.databaseContext.switchDS(customDialog.getDsalias(), () -> this.commonManager.query(sql), e -> {
            throw new BaseException(e.getMessage());
        });
        List<MapTree> tree = this.convertToMapTree(customDialog, pageList);
        List listToTree = BeanUtils.listToTree(tree);
        List<MapTree> filterTree = this.filterTree(listToTree, pidKey, pid);
        return BeanUtils.treeToList(filterTree);
    }

    private Conditionfield buildParentIdConditionField(CustomDialog customDialog, String pidKey, String parentId) {
        Conditionfield conditionfield = new Conditionfield();
        conditionfield.setField(pidKey);
        conditionfield.setComment(pidKey);
        conditionfield.setCondition(QueryOP.EQUAL.value());
        conditionfield.setDbType("varchar");
        conditionfield.setDefaultValue(parentId);
        return conditionfield;
    }

    public String getPidKey(String displayField) throws IOException {
        if (StringUtil.isEmpty((String)displayField)) {
            return "";
        }
        JsonNode djo = JsonUtil.toJsonNode((String)displayField);
        return JsonUtil.getString((JsonNode)djo, (String)"pid", (String)"");
    }

    public List<MapTree> filterTree(List<MapTree> listToTree, String pidKey, String pid) {
        if (StringUtil.isEmpty((String)pid)) {
            return listToTree;
        }
        ArrayList<MapTree> resultTree = new ArrayList<MapTree>();
        for (MapTree mapTree : listToTree) {
            List<MapTree> recursion;
            if (String.valueOf(mapTree.get(pidKey)).equals(pid)) {
                resultTree.add(mapTree);
            }
            if (!BeanUtils.isNotEmpty(mapTree.get("children")) || !BeanUtils.isNotEmpty(recursion = this.recursionTree(mapTree, pidKey, pid))) continue;
            resultTree.addAll(recursion);
        }
        return resultTree;
    }

    public List<MapTree> recursionTree(MapTree mapTree, String pidKey, String pid) {
        ArrayList<MapTree> resultTree = new ArrayList<MapTree>();
        Object children = mapTree.get("children");
        if (BeanUtils.isNotEmpty(children)) {
            List childrenList = (List)children;
            for (MapTree child : childrenList) {
                if (String.valueOf(child.get(pidKey)).equals(pid)) {
                    resultTree.add(child);
                }
                if (!BeanUtils.isEmpty(resultTree) || !BeanUtils.isNotEmpty(child.get("children"))) continue;
                return this.recursionTree(child, pidKey, pid);
            }
        }
        return resultTree;
    }

    public List<MapTree> convertToMapTree(CustomDialog customDialog, List<Map<String, Object>> list) throws IOException {
        JsonNode djo = JsonUtil.toJsonNode((String)customDialog.getDisplayfield());
        final String id = JsonUtil.getString((JsonNode)djo, (String)"id");
        final String pid = JsonUtil.getString((JsonNode)djo, (String)"pid");
        final String children = "children";
        final String text = JsonUtil.getString((JsonNode)djo, (String)"displayName");
        ArrayList<MapTree> tree = new ArrayList<MapTree>();
        for (Map<String, Object> map : list) {
            MapTree treeItem = new MapTree(){
                private static final long serialVersionUID = 1L;

                public void setIsParent(String isParent) {
                }

                public void setChildren(List<Tree> list) {
                    this.put(children, list);
                }

                public String getText() {
                    return this.get(text) == null ? "" : String.valueOf(this.get(text));
                }

                public String getParentId() {
                    return this.get(pid) == null ? "" : String.valueOf(this.get(pid));
                }

                public String getId() {
                    return this.get(id) == null ? "" : String.valueOf(this.get(id));
                }

                public List<Tree> getChildren() {
                    return this.get(children) == null ? null : (List)this.get(children);
                }
            };
            if ("kingbasees".equals(this.databaseContext.getDbType())) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    treeItem.put(entry.getKey().toLowerCase(), entry.getValue());
                }
            } else {
                treeItem.putAll(map);
            }
            tree.add(treeItem);
        }
        return tree;
    }

    private Map<String, Object> getFromParam(Map<String, Object> param, String fieldName) {
        try {
            Pattern regex = Pattern.compile("Q\\^(.*)\\^(.*)");
            String name = "";
            for (String k : param.keySet()) {
                Matcher regexMatcher = regex.matcher(k);
                if (!regexMatcher.matches() || !fieldName.equals(name = regexMatcher.group(1))) continue;
                Object object = param.get(k);
                if (BeanUtils.isEmpty((Object)object)) {
                    return null;
                }
                Map returnMap = MapUtil.buildMap((String)"value", (Object)object);
                returnMap.put("condition", regexMatcher.group(2));
                return returnMap;
            }
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
        return null;
    }

    private SqlBuilderModel constructSqlBuilderModel(CustomDialog customDialog, Map<String, Object> param, String dbType, String ... exclusion) throws IOException {
        ArrayList exclusionList = BeanUtils.isNotEmpty((Object)exclusion) ? Arrays.asList(exclusion) : new ArrayList();
        ArrayNode conditionField = JsonUtil.getMapper().createArrayNode();
        ArrayNode conJA = (ArrayNode)JsonUtil.toJsonNode((String)customDialog.getConditionfield());
        for (int i = 0; i < conJA.size(); ++i) {
            HashMap<String, Object> jsonObject;
            Map map;
            Map params;
            JsonNode jo = conJA.get(i);
            String fieldName = jo.get("field").asText();
            boolean anyMatch = exclusionList.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
            if (anyMatch) continue;
            String defaultType = JsonUtil.getString((JsonNode)jo, (String)"defaultType");
            String defaultValue = JsonUtil.getString((JsonNode)jo, (String)"defaultValue");
            String fdbType = JsonUtil.getString((JsonNode)jo, (String)"dbType");
            String condition = JsonUtil.getString((JsonNode)jo, (String)"condition");
            JsonNode nodeConfig = jo.get("config");
            if (BeanUtils.isNotEmpty((Object)nodeConfig) && BeanUtils.isNotEmpty((Object)nodeConfig.asText()) && BeanUtils.isNotEmpty((Object)(params = (Map)(map = JsonUtil.toMap((String)nodeConfig.asText())).get("parameter")))) {
                Set keySet = params.keySet();
                HashSet fieldSet = new HashSet();
                keySet.forEach(key -> fieldSet.add(((String)params.get(key)).toLowerCase()));
                boolean flag = false;
                for (String s : param.keySet()) {
                    if (!fieldSet.contains(s) || !BeanUtils.isNotEmpty((Object)param.get(s))) continue;
                    flag = true;
                    HashMap<String, Object> jsonObject2 = new HashMap<String, Object>();
                    jsonObject2.put("field", s);
                    jsonObject2.put("op", condition);
                    jsonObject2.put("dbType", fdbType);
                    jsonObject2.put("value", param.get(s));
                    jsonObject2.put("relation", param.get("relation"));
                    conditionField.add(JsonUtil.toJsonNode(jsonObject2));
                }
                if (flag) continue;
            }
            if (QueryOP.IS_NULL.value().equals(condition) || QueryOP.NOTNULL.value().equals(condition)) {
                HashMap<String, String> jsonObject3 = new HashMap<String, String>();
                jsonObject3.put("field", fieldName);
                jsonObject3.put("op", condition);
                jsonObject3.put("dbType", fdbType);
                conditionField.add(JsonUtil.toJsonNode(jsonObject3));
                continue;
            }
            Object value = null;
            if ("1".equals(defaultType)) {
                value = MapUtil.getIgnoreCase(param, (String)fieldName);
            } else if ("2".equals(defaultType)) {
                value = defaultValue;
            } else if ("5".equals(defaultType)) {
                value = this.groovyScriptEngine.executeObject(defaultValue, param);
            } else if ("7".equals(defaultType)) {
                Map<String, Object> fromParam = this.getFromParam(param, fieldName);
                if (BeanUtils.isEmpty(fromParam)) continue;
                condition = MapUtil.getString(fromParam, (String)"condition");
                value = fromParam.get("value");
            } else if ("3".equals(defaultType)) {
                value = MapUtil.getIgnoreCase(param, (String)fieldName);
                if (BeanUtils.isEmpty((Object)value) && "1".equals(JsonUtil.getString((JsonNode)jo, (String)"isSkipNull"))) {
                    jsonObject = new HashMap();
                    jsonObject.put("field", fieldName);
                    jsonObject.put("op", QueryOP.IS_NULL.value());
                    jsonObject.put("dbType", fdbType);
                    conditionField.add(JsonUtil.toJsonNode(jsonObject));
                    continue;
                }
            } else {
                value = MapUtil.getIgnoreCase(param, (String)fieldName);
            }
            if (BeanUtils.isEmpty((Object)value)) continue;
            jsonObject = new HashMap<String, Object>();
            jsonObject.put("field", fieldName);
            jsonObject.put("op", condition);
            jsonObject.put("dbType", fdbType);
            jsonObject.put("value", value);
            jsonObject.put("relation", param.get("relation"));
            conditionField.add(JsonUtil.toJsonNode(jsonObject));
        }
        ArrayNode sortField = (ArrayNode)JsonUtil.toJsonNode((String)customDialog.getSortfield());
        ObjectNode sortFieldJO = JsonUtil.arrayToObject((ArrayNode)sortField, (String)"field");
        String sortFieldStr = MapUtil.getIgnoreCase(param, (String)"sortField", (Object)"").toString();
        String orderSeq = MapUtil.getIgnoreCase(param, (String)"orderSeq", (Object)"").toString();
        if (StringUtil.isNotEmpty((String)sortFieldStr) && StringUtil.isNotEmpty((String)orderSeq)) {
            ObjectNode jo = JsonUtil.getMapper().createObjectNode();
            jo.put("field", sortFieldStr);
            jo.put("sortType", orderSeq);
            sortFieldJO.put(sortFieldStr, (JsonNode)jo);
        }
        SqlBuilderModel model = new SqlBuilderModel();
        model.setFromName(customDialog.getObjName());
        model.setDbType(dbType);
        model.setConditionField(conditionField);
        model.setSortField(JsonUtil.objectToArray((JsonNode)sortFieldJO));
        return model;
    }

    private String getTreeSql(CustomDialog customDialog, Map<String, Object> param, String dbType, String pidKey) throws IOException {
        String sql = "";
        if (customDialog.getSqlBuildType() == 1) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtil.isNotEmpty((String)pidKey)) {
                String pid = this.getPid(customDialog, param);
                param.put(pidKey, pid);
            }
            params.put("map", param);
            params.putAll(param);
            sql = this.groovyScriptEngine.executeString(customDialog.getDiySql(), params);
        } else {
            SqlBuilderModel model = this.constructSqlBuilderModel(customDialog, param, dbType, pidKey);
            sql = this.sqlBuilderService.getSql(model);
        }
        return sql;
    }

    private String getPid(CustomDialog customDialog, Map<String, Object> param) throws IOException {
        String str = customDialog.getDisplayfield();
        ObjectNode jo = (ObjectNode)JsonUtil.toJsonNode((String)str);
        String pid = JsonUtil.getString((JsonNode)jo, (String)"pid", (String)"");
        String isScript = JsonUtil.getString((JsonNode)jo, (String)"isScript", (String)"false");
        String pvalue = JsonUtil.getString((JsonNode)jo, (String)"pvalue", (String)"");
        String pidVal = MapUtil.getIgnoreCase(param, (String)pid, (Object)"").toString();
        if (StringUtil.isEmpty((String)pidVal)) {
            pidVal = isScript != null && "true".equals(isScript) ? this.groovyScriptEngine.executeString(pvalue, null).toString() : pvalue;
        }
        return pidVal;
    }

    @Override
    public String export(String[] idList) throws IOException {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (String id : idList) {
            list.add(this.get((Serializable)((Object)id)));
        }
        if (BeanUtils.isNotEmpty(list)) {
            return JsonUtil.toJson(list);
        }
        return "";
    }

    @Override
    @Transactional
    public boolean importFile(String unZipFilePath, String typeId) throws Exception {
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "customDialog.json"));
            List customDialogs = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomDialog>>(){});
            ArrayList byAliases = new ArrayList();
            this.importCheck(customDialogs, byAliases::add);
            if (byAliases.size() > 0) {
                return false;
            }
            ObjectNode sysTypeNode = this.portalFeignService.getSysTypeById(typeId);
            String typeName = sysTypeNode.get("name").asText("");
            for (CustomDialog customDialog : customDialogs) {
                customDialog.setTypeId(typeId);
                customDialog.setTypeName(typeName);
                customDialog.setId(UniqueIdUtil.getSuid());
                ((CustomDialogDao)this.baseMapper).insert((Object)customDialog);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return true;
    }

    @Override
    public void importCheck(List<CustomDialog> customDialogs, Consumer<CustomDialog> existConsumer) {
        for (CustomDialog customDialog : customDialogs) {
            CustomDialog byAlias = this.getByAlias(customDialog.getAlias());
            if (byAlias == null) continue;
            existConsumer.accept(byAlias);
        }
    }

    @Override
    public List<String> importData(List<CustomDialog> customDialogs, String status, String typeId, boolean ignoreRight) throws IOException {
        HashMap<String, Boolean> rightMap = new HashMap();
        ArrayList<String> noRightNames = new ArrayList<String>();
        if ("cover".equals(status)) {
            rightMap = CustomUtil.getRightMapByModel(this.getCurrentModelClass(), ResourceModelType.CUSTOM_DIALOG, ResourcesRightType.EDIT);
        }
        ObjectNode sysTypeNode = this.portalFeignService.getSysTypeById(typeId);
        String typeName = sysTypeNode.get("name").asText("");
        for (CustomDialog customDialog : customDialogs) {
            customDialog.setTypeId(typeId);
            customDialog.setTypeName(typeName);
            CustomDialog byAlias = this.getByAlias(customDialog.getAlias());
            if (BeanUtils.isEmpty((Object)((Object)byAlias))) {
                customDialog.setId(UniqueIdUtil.getSuid());
                ((CustomDialogDao)this.baseMapper).insert((Object)customDialog);
                continue;
            }
            if (!"cover".equals(status)) continue;
            if (CustomUtil.checkRight(rightMap, customDialog.getAlias()) || ignoreRight) {
                customDialog.setId(byAlias.getId());
                ((CustomDialogDao)this.baseMapper).updateById((Object)customDialog);
                continue;
            }
            noRightNames.add(customDialog.getName());
        }
        return noRightNames;
    }

    @Override
    public void saveWithCombineDialog(CustomDialog customDialog) {
        if (StringUtil.isEmpty((String)customDialog.getId())) {
            if (BeanUtils.isNotEmpty((Object)((Object)this.getByAlias(customDialog.getAlias())))) {
                throw new BaseException("\u522b\u540d" + customDialog.getAlias() + "\uff0c\u5df2\u5b58\u5728");
            }
            customDialog.setId(UniqueIdUtil.getSuid());
            customDialog.setUpdateTime(DateUtil.getCurrentDate());
            this.create((Model)customDialog);
        } else {
            this.update((Model)customDialog);
        }
    }

    @Override
    public CommonResult<String> saveCustomDialog(String json) throws Exception {
        String resultMsg;
        CustomDialog customDialog = null;
        if (!StringUtil.isEmpty((String)json)) {
            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
            String displayfield = JsonUtil.getString((JsonNode)node, (String)"displayfield");
            String conditionfield = JsonUtil.getString((JsonNode)node, (String)"conditionfield");
            String resultfield = JsonUtil.getString((JsonNode)node, (String)"resultfield");
            String sortfield = JsonUtil.getString((JsonNode)node, (String)"sortfield");
            String combinationRule = JsonUtil.getString((JsonNode)node, (String)"combinationRule");
            String tips = JsonUtil.getString((JsonNode)node, (String)"tips");
            node.remove("displayfield");
            node.remove("conditionfield");
            node.remove("resultfield");
            node.remove("sortfield");
            node.remove("combinationRule");
            node.remove("tips");
            customDialog = (CustomDialog)((Object)JsonUtil.toBean((JsonNode)node, CustomDialog.class));
            customDialog.setConditionfield(conditionfield);
            customDialog.setResultfield(resultfield);
            customDialog.setSortfield(sortfield);
            customDialog.setTips(tips);
            customDialog.setDisplayfield(displayfield);
            if ("selectedApi".equalsIgnoreCase(customDialog.getDsType()) && StringUtil.isEmpty((String)customDialog.getDisplayfield())) {
                customDialog.setDisplayfield(customDialog.getResultfield());
            }
            if (BeanUtils.isNotEmpty((Object)combinationRule)) {
                customDialog.setCombinationRule(combinationRule);
            }
            if (2 == customDialog.getStyle()) {
                String listDialogAlias = JsonUtil.toJsonNode((String)combinationRule).get("rightDialog").asText();
                CustomDialog listDialog = this.getByAlias(listDialogAlias);
                if (BeanUtils.isEmpty((Object)((Object)listDialog))) {
                    throw new BaseException("\u5217\u8868\u5bf9\u8bdd\u6846\u3010" + listDialogAlias + "\u3011\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8be5\u5bf9\u8bdd\u6846\u662f\u5426\u5b58\u5728");
                }
                customDialog.setObjName(listDialog.getObjName());
                customDialog.setNeedPage(listDialog.getNeedPage());
                customDialog.setPageSize(listDialog.getPageSize());
                customDialog.setDisplayfield(listDialog.getDisplayfield());
                customDialog.setConditionfield(listDialog.getConditionfield());
                customDialog.setResultfield(listDialog.getResultfield());
                customDialog.setSortfield(listDialog.getSortfield());
                customDialog.setDsalias(listDialog.getDsalias());
                customDialog.setIsTable(listDialog.getIsTable());
                customDialog.setDiySql(listDialog.getDiySql());
                customDialog.setSqlBuildType(listDialog.getSqlBuildType());
                customDialog.setSelectNum(listDialog.getSelectNum());
                customDialog.setSystem(listDialog.getSystem());
                customDialog.setDsType(listDialog.getDsType());
                customDialog.setUrl(listDialog.getUrl());
                customDialog.setRequestType(listDialog.getRequestType());
                customDialog.setDataParam(listDialog.getDataParam());
                customDialog.setPageKey(listDialog.getPageKey());
                customDialog.setPageSizeKey(listDialog.getPageSizeKey());
                customDialog.setTotalKey(listDialog.getTotalKey());
                customDialog.setListKey(listDialog.getListKey());
                customDialog.setHeader(listDialog.getHeader());
                customDialog.setCombinationRule(combinationRule);
            }
        }
        if (StringUtil.isEmpty((String)customDialog.getId())) {
            if (this.getByAlias(customDialog.getAlias()) != null) {
                return new CommonResult(false, "\u522b\u540d" + customDialog.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customDialog.setId(UniqueIdUtil.getSuid());
            customDialog.setUpdateTime(DateUtil.getCurrentDate());
            this.create((Model)customDialog);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            this.update((Model)customDialog);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg);
    }

    @Override
    public List getTreeData(String alias, String mapParam, String parentId) throws Exception {
        CustomDialog customDialog = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)mapParam)) {
            mapParam = "{" + mapParam + "}";
            Map map = JsonUtil.toMap((String)mapParam);
            for (Object key : map.keySet()) {
                param.put(key + "", map.get(key));
            }
        }
        if ((customDialog = this.getByAlias(alias)) == null) {
            return null;
        }
        return this.geTreetData(customDialog, param, this.databaseContext.getDbTypeByAlias(customDialog.getDsalias()), parentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response, String typeId) {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        boolean isRepeat = true;
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            unZipFilePath = ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            isRepeat = this.importFile(unZipFilePath, typeId);
            if (!isRepeat) {
                CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)unZipFilePath));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && isRepeat && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public CommonResult<String> importFileData(String unZipFilePath, String status, String typeId) {
        List<String> noRightNames;
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "customDialog.json"));
            List customDialogs = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomDialog>>(){});
            noRightNames = this.importData(customDialogs, status, typeId, false);
        }
        catch (Exception e) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                File formDir;
                String unZipFilePathStr = Base64.getFromBase64((String)unZipFilePath);
                if (StringUtil.isNotEmpty((String)unZipFilePathStr) && (formDir = new File(unZipFilePathStr)).exists()) {
                    FileUtil.deleteDir((File)formDir);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
            }
        }
        CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
        if (BeanUtils.isNotEmpty(noRightNames)) {
            commonResult.setMessage(String.format("\u5bfc\u5165\u6210\u529f\uff0c\u4ee5\u4e0b\u6570\u636e\u65e0\u6743\u9650\u5bfc\u5165\uff0c\u5df2\u8df3\u8fc7\uff1a[%s]", StringUtil.join(noRightNames)));
        }
        return commonResult;
    }
}

