/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hotent.base.annotation.AsyncThreadClean;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.constants.TenantConstant;
import com.hotent.base.context.BaseContext;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.exception.NotFoundException;
import com.hotent.base.exception.SystemException;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.FilterJsonStructUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bo.bodef.BoDefService;
import com.hotent.bo.context.FormContextThreadUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.bo.instance.BoDataHandler;
import com.hotent.bo.instance.BoDataImportHandler;
import com.hotent.bo.instance.BoInstanceFactory;
import com.hotent.bo.model.BatchBoResult;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.model.BoResult;
import com.hotent.bo.model.ValidateResult;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.bo.util.BoUtil;
import com.hotent.file.model.FileInfo;
import com.hotent.file.service.FileService;
import com.hotent.form.dto.FormDataCopyDto;
import com.hotent.form.dto.FormDataTemplateHtmlDto;
import com.hotent.form.dto.FormDataVo;
import com.hotent.form.dto.TreeListConfigDTO;
import com.hotent.form.enums.DataTemplateDisplayMode;
import com.hotent.form.enums.DataTemplateTreeDataMode;
import com.hotent.form.enums.FormType;
import com.hotent.form.manager.FormDataTemplateExtendManager;
import com.hotent.form.manager.FormRemindDataManager;
import com.hotent.form.model.DisplayField;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormDataImportLog;
import com.hotent.form.model.FormDataTemplate;
import com.hotent.form.model.FormDataTemplateDraft;
import com.hotent.form.model.FormDataTemplateExtend;
import com.hotent.form.model.FormDataTemplateXml;
import com.hotent.form.model.FormDataTemplateXmlList;
import com.hotent.form.model.FormField;
import com.hotent.form.model.FormMeta;
import com.hotent.form.model.FormRemindData;
import com.hotent.form.model.FormRight;
import com.hotent.form.model.FormRightButton;
import com.hotent.form.model.FormTemplate;
import com.hotent.form.model.setting.CopySetting;
import com.hotent.form.param.BatchSaveParam;
import com.hotent.form.param.BatchWordPrintVo;
import com.hotent.form.param.BpmDataTemplateInfoVo;
import com.hotent.form.param.Conditionfield;
import com.hotent.form.param.DataTemplateQueryVo;
import com.hotent.form.param.FormPrintParam;
import com.hotent.form.param.RelationParam;
import com.hotent.form.param.Resultfield;
import com.hotent.form.param.SelectParam;
import com.hotent.form.param.UpdateBatchParam;
import com.hotent.form.persistence.dao.FormDataTemplateDao;
import com.hotent.form.persistence.manager.CustomQueryManager;
import com.hotent.form.persistence.manager.DataTemplateWorkBookService;
import com.hotent.form.persistence.manager.FormDataImportLogManager;
import com.hotent.form.persistence.manager.FormDataTemplateDraftManager;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.FormFieldManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormPrintTemplateManager;
import com.hotent.form.persistence.manager.FormRightButtonManager;
import com.hotent.form.persistence.manager.FormRightManager;
import com.hotent.form.persistence.manager.FormTemplateManager;
import com.hotent.form.service.DataTemplateSettingService;
import com.hotent.form.service.FormService;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.util.DataTemplateUtil;
import com.hotent.form.util.FormHtmlUtil;
import com.hotent.form.util.FormUtil;
import com.hotent.form.util.FreeMakerUtil;
import com.hotent.form.vo.ComputeVo;
import com.hotent.form.vo.CustomQueryControllerVo;
import com.hotent.form.vo.ExportSubVo;
import com.hotent.form.vo.FormRigthParam;
import com.hotent.form.vo.Formal;
import com.hotent.form.vo.TemplateField;
import com.hotent.table.datasource.DataSourceUtil;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.util.MetaDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.impl.util.PermissionCalc;
import com.hotent.uc.api.impl.util.PermissionUtil;
import com.hotent.uc.api.impl.var.IContextVar;
import com.hotent.uc.api.model.IUser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.Clob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import poi.easypoi.util.ExcelUtils;
import poi.util.ExcelUtil;

@Service(value="bpmDataTemplateManager")
public class FormDataTemplateManagerImpl
extends BaseManagerImpl<FormDataTemplateDao, FormDataTemplate>
implements FormDataTemplateManager {
    private static final String LOGIN_USER = "loginUser";
    private static final String LOGIN_USER_ORGS = "loginUserOrgs";
    private static final String LOGIN_USER_SUB_ORGS = "loginUserSubOrgs";
    private static final String CUSTOM_ORGS = "customOrgs";
    private static final String[] FLOW_FIELD = new String[]{"F_bpm_proc_inst_id_", "F_bpm_subject_", "F_bpm_proc_def_name_", "F_bpm_status_", "F_bpm_create_time_", "F_bpm_end_time_", "F_bpm_is_forbidden_", "F_bpm_creator_", "F_bpm_is_dele_"};
    private static final HashSet SUB_CTRL_TYPE = new HashSet<String>(Arrays.asList("subDiv", "subtable"));
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    FormManager formManager;
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    BoDataHandler boDataHandler;
    @Resource
    BoInstanceFactory boInstanceFactory;
    @Resource
    BoDefService boDefService;
    @Resource(name="formPermissionCalc")
    PermissionCalc permssionCalc;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    FormRightButtonManager formRightButtonManager;
    @Resource
    FormService formService;
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;
    @Resource
    CommonManager commonManager;
    @Resource
    FormDataTemplateDraftManager dataTemplateDraftManager;
    @Resource
    FormDataImportLogManager formDataImportLogManager;
    @Resource
    FormDataTemplateExtendManager formDataTemplateExtendManager;
    @Resource
    FormRemindDataManager formRemindDataManager;
    @Resource
    CustomQueryManager customQueryManager;
    @Resource
    BoDefManager boDefManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    DataTemplateSettingService dataTemplateSettingService;
    @Resource
    FileService fileService;
    Logger logger = LoggerFactory.getLogger(FormDataTemplateManagerImpl.class);

    @Override
    public ObjectNode getByFormKey(String formKey, String boId) throws IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("status", 1);
        jsonObject.put("msg", "\u652f\u6301\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
        FormDataTemplate bpmDataTemplate = new FormDataTemplate();
        ArrayList<TemplateField> fields = new ArrayList<TemplateField>();
        ArrayList<TemplateField> formField = new ArrayList<TemplateField>();
        ArrayNode groupFields = JsonUtil.getMapper().createArrayNode();
        BoDef baseBoDef = null;
        String boDefId = "";
        String colPrefix = "";
        String displaySettingFields = "";
        boolean flag = true;
        List subEnt = new ArrayList();
        Form bpmForm = this.formManager.getMainByFormKey(formKey);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = this.formMetaManager.getBODefIdByFormId(formId);
        if (BeanUtils.isEmpty(boDefIds)) {
            ThreadMsgUtil.addMsg((String)"\u8be5\u4e1a\u52a1\u8868\u5355BO\u4e3a\u7a7a");
            jsonObject.put("status", 0);
            jsonObject.put("msg", ThreadMsgUtil.getMessage().trim());
            flag = false;
        }
        if (flag) {
            boDefId = boDefIds.get(0);
            if (StringUtil.isNotEmpty((String)boId)) {
                for (int i = 0; i < boDefIds.size(); ++i) {
                    if (!boDefIds.get(i).equals(boId)) continue;
                    boDefId = boDefIds.get(i);
                }
            }
            String string = colPrefix = (baseBoDef = this.boDefService.getByDefId(boDefId)).getBoEnt().isExternal() ? "" : "F_";
            if (!baseBoDef.isSupportDb()) {
                jsonObject.put("status", 0);
                jsonObject.put("msg", "\u8be5\u8868\u5355\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff0c\u4e0d\u80fd\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
                flag = false;
            }
        }
        if (flag) {
            BoDef boDef = this.boDefService.getByAlias(baseBoDef.getAlias());
            BoEnt boEnt = boDef.getBoEnt();
            Map attrFieldMap = boEnt.getAttrFieldMap();
            this.getFormField(StringUtil.isNotEmpty((String)boEnt.getDsName()) ? boEnt.getDsName() : "LOCAL", fields, boEnt.getTableName());
            for (TemplateField field : fields) {
                for (String s : attrFieldMap.keySet()) {
                    if (!s.equalsIgnoreCase(field.getName())) continue;
                    field.setFormat(((BoAttribute)attrFieldMap.get(s)).getFormat());
                    field.setIsEncode(((BoAttribute)attrFieldMap.get(s)).getIsEncode());
                }
            }
            fields.forEach(templateField -> templateField.setName(templateField.getName().toLowerCase().replace("f_", "")));
            formField.addAll(fields);
            ObjectNode groupField = JsonUtil.getMapper().createObjectNode();
            groupField.put("name", boEnt.getTableName());
            groupField.put("desc", boEnt.getComment());
            groupField.set("fields", JsonUtil.toJsonNode(fields));
            groupFields.add((JsonNode)groupField);
            displaySettingFields = this.getDisplayField(fields, "");
            bpmDataTemplate = new FormDataTemplate();
            bpmDataTemplate.setFormKey(formKey);
            bpmDataTemplate.setDisplayField(displaySettingFields);
            bpmDataTemplate.setBoDefId(boDefId);
            bpmDataTemplate.setBoDefAlias(baseBoDef.getAlias());
            bpmDataTemplate.setName(bpmForm.getName());
            bpmDataTemplate.setTypeId(bpmForm.getTypeId());
            bpmDataTemplate.setTypeName(bpmForm.getTypeName());
            bpmDataTemplate.setFormName(bpmForm.getName());
            bpmDataTemplate.setDsName(BeanUtils.isNotEmpty((Object)boEnt.getDsName()) ? boEnt.getDsName() : "LOCAL");
            if (StringUtil.isNotEmpty((String)bpmDataTemplate.getDefId())) {
                this.addFieldList(fields);
            }
            subEnt = boEnt.getChildEntList();
        }
        List<FormTemplate> templates = this.formTemplateManager.getTemplateType("dataTemplate");
        List<FormTemplate> mobileTemplates = this.formTemplateManager.getTemplateType("mobileDataTemplate");
        jsonObject.set("templates", JsonUtil.toJsonNode(templates));
        jsonObject.set("mobileTemplates", JsonUtil.toJsonNode(mobileTemplates));
        jsonObject.set("bpmDataTemplate", JsonUtil.toJsonNode((Object)((Object)bpmDataTemplate)));
        jsonObject.set("fields", (JsonNode)groupFields);
        jsonObject.put("displaySettingFields", displaySettingFields);
        jsonObject.set("data", (JsonNode)this.tidyJson(bpmDataTemplate));
        jsonObject.put("colPrefix", colPrefix);
        jsonObject.put("formId", formId);
        jsonObject.set("formField", JsonUtil.toJsonNode(formField));
        jsonObject.set("subFormField", JsonUtil.toJsonNode(subEnt));
        jsonObject.set("permissionList", PermissionUtil.getPermissionList((String)"formPermissionCalcList"));
        return jsonObject;
    }

    private String parseFilterField(String oldFilter) throws Exception {
        JsonNode node = JsonUtil.toJsonNode((String)oldFilter);
        if (!(node instanceof ArrayNode)) {
            return oldFilter;
        }
        ArrayNode arrFilter = (ArrayNode)node;
        arrFilter.forEach(filter -> {
            ObjectNode item = (ObjectNode)filter;
            if (item.has("appendSql")) {
                return;
            }
            if (!item.has("condition")) {
                this.updateOneFilter(item, null, null, null, null);
                return;
            }
            int type = JsonUtil.getInt((JsonNode)item, (String)"type", (int)0);
            boolean showAll = JsonUtil.getBoolean((ObjectNode)item, (String)"showAll", (boolean)false);
            JsonNode nodeConditionOld = item.get("condition");
            String conditionOld = JsonUtil.getString((JsonNode)item, (String)"condition");
            switch (type) {
                case 1: {
                    if (!(nodeConditionOld instanceof ArrayNode)) break;
                    ObjectNode nodeFirst = JsonUtil.createObjectNode();
                    nodeFirst.set("condition", nodeConditionOld);
                    nodeFirst.put("showAll", showAll);
                    this.updateOneFilter(item, nodeFirst, null, null, null);
                    break;
                }
                case 3: {
                    this.updateOneFilter(item, null, conditionOld, null, null);
                    break;
                }
                case 4: {
                    this.updateOneFilter(item, null, null, conditionOld, null);
                    break;
                }
                case 5: {
                    this.updateOneFilter(item, null, null, null, conditionOld);
                }
            }
        });
        return JsonUtil.toJsonString((Object)arrFilter);
    }

    private void updateOneFilter(ObjectNode item, ObjectNode nodeCondition, String appendSql, String dataPermission, String flowAuth) {
        if (nodeCondition == null) {
            nodeCondition = JsonUtil.createObjectNode();
            nodeCondition.set("condition", (JsonNode)JsonUtil.createArrayNode());
            nodeCondition.put("showAll", false);
        }
        if (StringUtil.isEmpty((String)appendSql)) {
            appendSql = "";
        }
        if (StringUtil.isEmpty((String)dataPermission)) {
            dataPermission = "[]";
        }
        if (StringUtil.isEmpty((String)flowAuth)) {
            flowAuth = "{\"todo\":false,\"done\":false,\"request\":false,\"read\":false}";
        }
        item.set("condition", (JsonNode)nodeCondition);
        item.put("appendSql", appendSql);
        item.put("dataPermission", dataPermission);
        item.put("flowAuth", flowAuth);
    }

    @Override
    public ObjectNode getByTemplateId(String id, String boId) throws Exception {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("status", 1);
        jsonObject.put("msg", "\u652f\u6301\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
        List<Object> templates = new ArrayList();
        List<Object> mobileTemplates = new ArrayList();
        FormDataTemplate bpmDataTemplate = (FormDataTemplate)((Object)((FormDataTemplateDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (BeanUtils.isEmpty((Object)((Object)bpmDataTemplate))) {
            jsonObject.put("msg", "\u8868\u5355\u5217\u8868\u4e0d\u5b58\u5728\u3002");
            jsonObject.put("status", 0);
            return jsonObject;
        }
        bpmDataTemplate.setFilterField(this.parseFilterField(bpmDataTemplate.getFilterField()));
        bpmDataTemplate.setRemindSettingList(this.formDataTemplateExtendManager.getJsonByFormDataTemplateId(id));
        ArrayNode groupFields = JsonUtil.getMapper().createArrayNode();
        ArrayList<TemplateField> fields = new ArrayList<TemplateField>();
        ArrayList<TemplateField> formField = new ArrayList<TemplateField>();
        BoDef baseBoDef = null;
        String boDefId = "";
        String colPrefix = "";
        String displaySettingFields = "";
        String tableName = "";
        Boolean flag = true;
        String formKey = bpmDataTemplate.getFormKey();
        List subEnt = new ArrayList();
        Form bpmForm = this.formManager.getMainByFormKey(formKey);
        Assert.notNull((Object)((Object)bpmForm), (String)String.format("\u672a\u627e\u5230\u8868\u5355%s", formKey));
        String formId = bpmForm.getDefId();
        List<String> boDefIds = this.formMetaManager.getBODefIdByFormId(formId);
        if (BeanUtils.isEmpty(boDefIds)) {
            ThreadMsgUtil.addMsg((String)"\u8be5\u4e1a\u52a1\u8868\u5355BO\u4e3a\u7a7a");
            jsonObject.put("status", 0);
            jsonObject.put("msg", ThreadMsgUtil.getMessage().trim());
            flag = false;
        }
        if (flag.booleanValue()) {
            boDefId = boDefIds.get(0);
            if (StringUtil.isNotEmpty((String)boId)) {
                for (int i = 0; i < boDefIds.size(); ++i) {
                    if (!boDefIds.get(i).equals(boId)) continue;
                    boDefId = boDefIds.get(i);
                }
            }
            String string = colPrefix = (baseBoDef = this.boDefService.getByDefId(boDefId)).getBoEnt().isExternal() ? "" : "F_";
            if (!baseBoDef.isSupportDb()) {
                jsonObject.put("status", 0);
                jsonObject.put("msg", "\u8be5\u8868\u5355\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff0c\u4e0d\u80fd\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
                flag = false;
            }
        }
        if (flag.booleanValue()) {
            BoDef boDef = this.boDefService.getByAlias(baseBoDef.getAlias());
            BoEnt boEnt = boDef.getBoEnt();
            Map attrFieldMap = boEnt.getAttrFieldMap();
            tableName = boEnt.getTableName();
            if (BeanUtils.isEmpty((Object)bpmDataTemplate.getDsName())) {
                bpmDataTemplate.setDsName(BeanUtils.isNotEmpty((Object)boEnt.getDsName()) ? boEnt.getDsName() : "LOCAL");
            }
            this.getFormField(StringUtil.isNotEmpty((String)boEnt.getDsName()) ? boEnt.getDsName() : "LOCAL", fields, tableName);
            for (TemplateField field : fields) {
                for (String s : attrFieldMap.keySet()) {
                    if (!s.equalsIgnoreCase(field.getName())) continue;
                    field.setFormat(((BoAttribute)attrFieldMap.get(s)).getFormat());
                }
            }
            for (TemplateField field : fields) {
                String s = field.getName().toLowerCase();
                if (!s.equals("ref_id_")) {
                    field.setName(s.replace("f_", ""));
                    continue;
                }
                field.setName(s);
            }
            formField.addAll(fields);
            if (StringUtil.isNotEmpty((String)bpmDataTemplate.getDefId())) {
                this.addFieldList(fields);
            }
            displaySettingFields = this.getDisplayField(fields, "");
            bpmDataTemplate.setDisplayField(bpmDataTemplate.getDisplayField());
            subEnt = boEnt.getChildEntList();
            ObjectNode groupField = JsonUtil.getMapper().createObjectNode();
            groupField.put("name", tableName);
            groupField.put("desc", boEnt.getComment());
            groupField.set("fields", JsonUtil.toJsonNode(fields));
            groupFields.add((JsonNode)groupField);
        }
        try {
            this.getJoinTableFields(bpmDataTemplate.getJoinTables(), bpmDataTemplate.getDsName(), groupFields);
        }
        catch (MessagePassingException e) {
            jsonObject.put("status", 0);
            jsonObject.put("msg", e.getMessage());
        }
        this.rectifyMobileDataTemplate(bpmDataTemplate);
        templates = this.formTemplateManager.getTemplateType("dataTemplate");
        mobileTemplates = this.formTemplateManager.getTemplateType("mobileDataTemplate");
        jsonObject.set("templates", JsonUtil.toJsonNode(templates));
        jsonObject.set("mobileTemplates", JsonUtil.toJsonNode(mobileTemplates));
        jsonObject.set("bpmDataTemplate", JsonUtil.toJsonNode((Object)((Object)bpmDataTemplate)));
        jsonObject.set("fields", (JsonNode)groupFields);
        jsonObject.put("displaySettingFields", displaySettingFields);
        jsonObject.set("data", (JsonNode)this.tidyJson(bpmDataTemplate));
        jsonObject.put("colPrefix", colPrefix);
        jsonObject.put("formId", formId);
        jsonObject.set("formField", JsonUtil.toJsonNode(formField));
        jsonObject.set("subFormField", JsonUtil.toJsonNode(subEnt));
        jsonObject.set("permissionList", PermissionUtil.getPermissionList((String)"formPermissionCalcList"));
        jsonObject.put("tableName", tableName);
        if (StringUtil.isNotEmpty((String)bpmDataTemplate.getJoinQueryConfig())) {
            jsonObject.set("joinQueryConfig", JsonUtil.toJsonNode((String)bpmDataTemplate.getJoinQueryConfig()));
        }
        return jsonObject;
    }

    private void rectifyMobileDataTemplate(FormDataTemplate formDataTemplate) throws Exception {
        List<FormTemplate> mobileTemplates;
        if (BeanUtils.isNotEmpty((Object)((Object)formDataTemplate)) && StringUtil.isNotEmpty((String)formDataTemplate.getMobileFormAlias()) && StringUtil.isEmpty((String)formDataTemplate.getMobileTemplateAlias()) && BeanUtils.isNotEmpty(mobileTemplates = this.formTemplateManager.getTemplateType("mobileDataTemplate"))) {
            formDataTemplate.setMobileTemplateAlias(mobileTemplates.get(0).getAlias());
            FormDataTemplateHtmlDto dataTemplateHtmlDto = this.generateTemplate(formDataTemplate, FormType.MOBILE);
            formDataTemplate.setMobileTemplateHtml(dataTemplateHtmlDto.getMoblieDataTemplateHtml());
            ((FormDataTemplateDao)this.baseMapper).updateById((Object)formDataTemplate);
        }
    }

    private void getJoinTableFields(String joinTables, String dsName, ArrayNode groupFields) throws Exception {
        if (BeanUtils.isNotEmpty((Object)joinTables)) {
            JsonNode joinTable = JsonUtil.toJsonNode((String)joinTables);
            this.databaseContext.switchDS(dsName, dResult -> {
                try {
                    joinTable.forEach(item -> {
                        BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                        com.hotent.table.model.Table table = null;
                        try {
                            table = baseTableMeta.getTableByName(JsonUtil.getString((JsonNode)item, (String)"join"));
                        }
                        catch (EmptyResultDataAccessException ex) {
                            throw new MessagePassingException(String.format("\u65e0\u6cd5\u627e\u5230\u5173\u8054\u8868%s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8be5\u8868\u662f\u5426\u5b58\u5728", JsonUtil.getString((JsonNode)item, (String)"join")));
                        }
                        ObjectNode groupField = JsonUtil.getMapper().createObjectNode();
                        groupField.put("name", table.getTableName());
                        groupField.put("desc", table.getComment());
                        try {
                            groupField.set("fields", JsonUtil.toJsonNode(this.convertColumn2Field(table.getColumnList())));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        groupFields.add((JsonNode)groupField);
                    });
                }
                catch (MessagePassingException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new BaseException(ex.getMessage(), (Throwable)ex);
                }
                return null;
            });
        }
    }

    private void getJoinTableFields(String joinTables, String dsName, List<TemplateField> fields) throws Exception {
        ArrayNode groupFields = JsonUtil.createArrayNode();
        this.getJoinTableFields(joinTables, dsName, groupFields);
        groupFields.forEach(groupField -> {
            try {
                List fieldList = (List)JsonUtil.toBean((JsonNode)groupField.get("fields"), (TypeReference)new TypeReference<List<TemplateField>>(){});
                fields.addAll(fieldList);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void getFormField(String dsName, List<TemplateField> fields, String tableName) {
        try {
            this.databaseContext.switchDS(dsName, dResult -> {
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                com.hotent.table.model.Table table = baseTableMeta.getTableByName(tableName);
                fields.addAll(this.convertColumn2Field(table.getColumnList()));
                return null;
            });
        }
        catch (Exception ex) {
            throw new BaseException(ex.getMessage(), (Throwable)ex);
        }
    }

    private List<TemplateField> convertColumn2Field(List<Column> list) {
        return list.stream().map(TemplateField::new).collect(Collectors.toList());
    }

    private ObjectNode tidyJson(FormDataTemplate template) throws IOException {
        template.setTemplateHtml("");
        ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)template));
        jsonObject.remove("pageBean");
        jsonObject.remove("createBy");
        jsonObject.remove("createtime");
        jsonObject.remove("updateBy");
        jsonObject.remove("updatetime");
        return jsonObject;
    }

    private String getDisplayField(List<TemplateField> fields, String displayField) throws IOException {
        Map<String, String> map = this.getDisplayFieldRight(displayField);
        Map<String, String> descMap = this.getDisplayFieldDesc(displayField);
        if (BeanUtils.isNotEmpty(fields)) {
            ArrayNode jsonAry = JsonUtil.getMapper().createArrayNode();
            for (TemplateField bpmFormField : fields) {
                String name;
                ObjectNode json = JsonUtil.getMapper().createObjectNode();
                if (StringUtil.isNotEmpty((String)bpmFormField.getTableName())) {
                    String filedName = FormUtil.replaceUnderline(bpmFormField.getOldTableField().toLowerCase());
                    name = bpmFormField.getTableName().toLowerCase().replace("_", "") + filedName;
                } else {
                    name = bpmFormField.getName();
                }
                json.put("name", name);
                String desc = bpmFormField.getDesc();
                if (BeanUtils.isNotEmpty(map) && map.containsKey(bpmFormField.getName())) {
                    desc = descMap.get(bpmFormField.getName());
                }
                json.put("desc", desc);
                json.put("type", bpmFormField.getType());
                json.put("status", bpmFormField.getStatus());
                json.put("isEncode", bpmFormField.getIsEncode());
                String right = "";
                if (BeanUtils.isNotEmpty(map)) {
                    right = map.get(bpmFormField.getName());
                }
                if (StringUtil.isEmpty((String)right)) {
                    right = this.getDefaultDisplayFieldRight();
                }
                json.put("right", right);
                if (bpmFormField.isShowFlowField()) {
                    json.put("showFlowField", true);
                }
                json.put("isFlowField", bpmFormField.isFlowField());
                json.put("colPrefix", bpmFormField.getColPrefix());
                json.put("tableName", bpmFormField.getTableName());
                json.put("oldTableField", bpmFormField.getOldTableField());
                json.put("format", bpmFormField.getFormat());
                jsonAry.add((JsonNode)json);
            }
            displayField = jsonAry.toString();
        }
        return displayField;
    }

    private Map<String, String> getDisplayFieldDesc(String displayField) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)displayField)) {
            return map;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode)obj;
            String name = json.get("name").asText();
            String desc = json.get("desc").asText();
            map.put(name, desc);
        }
        return map;
    }

    private Map<String, String> getDisplayFieldRight(String displayField) throws IOException {
        if (StringUtil.isEmpty((String)displayField)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode)obj;
            String name = json.get("name").asText();
            ArrayNode right = (ArrayNode)json.get("right");
            map.put(name, right.toString());
        }
        return map;
    }

    private String getDefaultDisplayFieldRight() {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("type", "everyone");
        json.put("id", "");
        json.put("name", "");
        json.put("script", "");
        array.add((JsonNode)json);
        return array.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(FormDataTemplate bpmDataTemplate, boolean resetTemp) throws Exception {
        boolean existTemplate = this.getCountByAlias(bpmDataTemplate.getAlias()) > 0;
        boolean hasId = StringUtil.isEmpty((String)bpmDataTemplate.getId());
        this.refreshFormatterData(bpmDataTemplate);
        FormDataTemplateHtmlDto dataTemplateHtmlDto = this.generateTemplate(bpmDataTemplate, null);
        if (!existTemplate && hasId) {
            bpmDataTemplate.setId(UniqueIdUtil.getSuid());
            bpmDataTemplate.setTemplateHtml(dataTemplateHtmlDto.getDataTemplateHtml());
            bpmDataTemplate.setMobileTemplateHtml(dataTemplateHtmlDto.getMoblieDataTemplateHtml());
            bpmDataTemplate.setCreateTime(LocalDateTime.now());
            this.create((Model)bpmDataTemplate);
        } else {
            FormDataTemplate temp = this.getByAlias(bpmDataTemplate.getAlias());
            if (temp != null && !bpmDataTemplate.getId().equals(temp.getId())) {
                throw new BaseException("\u62a5\u8868\u522b\u540d\uff1a" + bpmDataTemplate.getAlias() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u522b\u540d\uff01");
            }
            if (resetTemp) {
                bpmDataTemplate.setTemplateHtml(dataTemplateHtmlDto.getDataTemplateHtml());
                bpmDataTemplate.setMobileTemplateHtml(dataTemplateHtmlDto.getMoblieDataTemplateHtml());
            } else {
                FormDataTemplate old = ((FormDataTemplateDao)this.baseMapper).getByAlias(bpmDataTemplate.getAlias());
                bpmDataTemplate.setTemplateHtml(old.getTemplateHtml());
                bpmDataTemplate.setMobileTemplateHtml(old.getMobileTemplateHtml());
            }
            bpmDataTemplate.setUpdateTime(LocalDateTime.now());
            LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(FormDataTemplate::getId, (Object)bpmDataTemplate.getId());
            this.update((Object)bpmDataTemplate, (Wrapper)wrapper);
        }
        if (StringUtil.isNotEmpty((String)bpmDataTemplate.getRemindSettingList())) {
            this.formDataTemplateExtendManager.save(bpmDataTemplate.getRemindSettingList(), bpmDataTemplate.getId());
        }
    }

    private void handleEditButtonId(FormDataTemplate template) throws Exception {
        FormRightButtonManager formRightButtonManager = (FormRightButtonManager)AppUtil.getBean(FormRightButtonManager.class);
        List formRightButtons = formRightButtonManager.list((Wrapper)Wrappers.lambdaQuery().eq(FormRightButton::getDataKey, (Object)template.getAlias()));
        Set formRightIds = formRightButtons.stream().map(FormRightButton::getFormRightId).collect(Collectors.toSet());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormRight::getDataKey, (Object)template.getAlias())).eq(FormRight::getPermissionType, (Object)4)).notIn(BeanUtils.isNotEmpty(formRightIds), FormRight::getId, formRightIds);
        List list = this.bpmFormRightManager.list((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            ArrayNode editButtons = this.dataTemplateSettingService.getManagerFieldsByName(template, "edit");
            Set buttonIds = formRightButtons.stream().map(FormRightButton::getButtonId).collect(Collectors.toSet());
            for (JsonNode manage : editButtons) {
                String buttonId = JsonUtil.getString((JsonNode)manage, (String)"buttonId", (String)"");
                if (buttonIds.contains(buttonId)) continue;
                FormRightButton formRightButton = new FormRightButton();
                formRightButton.setDataKey(template.getAlias());
                formRightButton.setButtonId(buttonId);
                formRightButton.setFormRightId(((FormRight)((Object)list.get(0))).getId());
                formRightButtonManager.save((Object)formRightButton);
            }
        }
    }

    private FormDataTemplateHtmlDto generateTemplate(FormDataTemplate bpmDataTemplate, FormType formType) throws Exception {
        FormTemplate bpmFormTemplate = null;
        FormTemplate mobileFormTemplate = null;
        if (formType == FormType.PC) {
            bpmFormTemplate = this.formTemplateManager.getByTemplateAlias(bpmDataTemplate.getTemplateAlias());
        } else if (formType == FormType.MOBILE) {
            mobileFormTemplate = this.formTemplateManager.getByTemplateAlias(bpmDataTemplate.getMobileTemplateAlias());
        } else {
            if (StringUtil.isNotEmpty((String)bpmDataTemplate.getTemplateAlias())) {
                bpmFormTemplate = this.formTemplateManager.getByTemplateAlias(bpmDataTemplate.getTemplateAlias());
            }
            if (StringUtil.isNotEmpty((String)bpmDataTemplate.getMobileTemplateAlias())) {
                mobileFormTemplate = this.formTemplateManager.getByTemplateAlias(bpmDataTemplate.getMobileTemplateAlias());
            }
        }
        return this.generateTemplateByFormTemplate(bpmDataTemplate, bpmFormTemplate, mobileFormTemplate);
    }

    private String initInnerBtnConfig() throws UnsupportedEncodingException {
        String btnConfig = "[{\"init\":1,\"name\":\"\u4fdd\u5b58\",\"alias\":\"save\",\"show\":true,\"type\":\"primary\"},{\"init\":1,\"name\":\"\u6253\u5370\",\"alias\":\"print\",\"show\":true},{\"init\":1,\"name\":\"\u8fd4\u56de\",\"alias\":\"back\",\"show\":true}]";
        return Base64.getBase64((String)btnConfig);
    }

    void haldleTemplateSpecial(FormDataTemplate formDataTemplate) {
        String conditionField = formDataTemplate.getConditionField();
        if (StringUtil.isNotEmpty((String)conditionField)) {
            Matcher matcher = Pattern.compile("backendValidate:\\$\\{([a-z]+)\\}").matcher(conditionField);
            HashSet specialSet = Sets.newHashSet();
            while (matcher.find()) {
                specialSet.add(matcher.group());
            }
            for (String special : specialSet) {
                conditionField = conditionField.replace(special, "${r\\\"${r'" + special + "'}\\\"}");
            }
            formDataTemplate.setConditionField(conditionField);
        }
    }

    @Override
    public Integer getCountByAlias(String alias) {
        return ((FormDataTemplateDao)this.baseMapper).getCountByAlias(alias);
    }

    @Override
    public String getDisplay(String alias, Map<String, Object> params, Map<String, Object> queryParams, FormType formType) throws Exception {
        Map<String, Boolean> mobilePermission;
        List list;
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        HashMap<String, Object> model = new HashMap<String, Object>();
        boolean managePermissionState = false;
        FormDataTemplate bpmDataTemplate = ((FormDataTemplateDao)this.baseMapper).getByAlias(alias);
        params.put("boAlias", bpmDataTemplate.getBoDefAlias());
        params.put("formKey", bpmDataTemplate.getFormKey());
        params.put("defId", BeanUtils.isEmpty((Object)bpmDataTemplate.getDefId()) ? "" : bpmDataTemplate.getDefId());
        Map<String, Boolean> managePermission = this.getManagePermission(bpmDataTemplate.getManageField(), curProfiles);
        Boolean hasSubStatus = StringUtil.isNotEmpty((String)this.getSubEntIds(bpmDataTemplate.getFormKey()));
        if (BeanUtils.isNotEmpty(managePermission) && BeanUtils.isNotEmpty(list = managePermission.keySet().stream().filter(key -> !"sun".equals(key) && (!"sub".equals(key) || hasSubStatus != false) && (Boolean)managePermission.get(key) != false).collect(Collectors.toList()))) {
            managePermissionState = true;
        }
        if (StringUtil.isEmpty((String)bpmDataTemplate.getDefId())) {
            managePermission.put("startFlow", false);
        }
        List<Map<String, String>> filters = this.getFilterPermission(bpmDataTemplate.getFilterField(), curProfiles);
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        model.put("util", freeMakerUtil);
        model.put("ctx", params.get("__ctx"));
        model.put("bpmDataTemplate", (Object)bpmDataTemplate);
        Map<String, Boolean> permission = this.getPermission(bpmDataTemplate.getDisplayField(), curProfiles);
        model.put("permission", permission);
        Map<String, Boolean> destMap = mobilePermission = this.getMobilePermission(bpmDataTemplate.getMobileDisplayField(), curProfiles);
        destMap.put("mobile_sort", (Boolean)((Object)freeMakerUtil.toJsonStr(mobilePermission)));
        model.put("mobilePermission", destMap);
        model.put("isShowMobileStatus", this.getMobileStatus(bpmDataTemplate.getDisplayField(), permission));
        model.put("managePermission", managePermission);
        model.put("managePermissionState", managePermissionState);
        model.put("hasSub", hasSubStatus);
        BoDef boDef = this.boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        model.put("pkField", boEnt.getPkKey());
        model.put("colPrefix", boEnt.isExternal() ? "" : "F_");
        model.put("filters", filters);
        JsonUtil jsonUtil = new JsonUtil();
        model.put("JsonUtil", jsonUtil);
        Base64 base64 = new Base64();
        model.put("base64", base64);
        String templateHtml = FormType.PC == formType ? bpmDataTemplate.getTemplateHtml() : bpmDataTemplate.getMobileTemplateHtml();
        UserAgent ua = UserAgentUtil.parse((String)HttpUtil.getRequest().getHeader(Header.USER_AGENT.toString()));
        if (BeanUtils.isNotEmpty((Object)ua) && ua.isMobile()) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start("\u79fb\u52a8\u7aef\u591a\u8868\u5934\u8f6c\u6210\u5e76\u5217\u663e\u793a");
            if (this.tileDisplayFields(bpmDataTemplate)) {
                FormDataTemplateHtmlDto dataTemplateHtmlDto = this.generateTemplate(bpmDataTemplate, formType);
                templateHtml = FormType.PC == formType ? dataTemplateHtmlDto.getDataTemplateHtml() : dataTemplateHtmlDto.getMoblieDataTemplateHtml();
            }
            stopWatch.stop();
            this.logger.info(stopWatch.prettyPrint());
        }
        if (null == bpmDataTemplate.getTableConfigure() || "[]".equals(bpmDataTemplate.getTableConfigure())) {
            bpmDataTemplate.setTableConfigure("{}");
        }
        return this.freemarkEngine.parseByStringTemplate(templateHtml, model);
    }

    private boolean getMobileStatus(String displayField, Map<String, Boolean> permission) throws Exception {
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        return this.recursionGetStatus(jsonAry, permission);
    }

    private boolean recursionGetStatus(ArrayNode jsonAry, Map<String, Boolean> permission) {
        for (JsonNode jsonNode : jsonAry) {
            if (jsonNode.has("isStatus") && jsonNode.get("isStatus").asBoolean() && permission.get(JsonUtil.getString((JsonNode)jsonNode, (String)"name")).booleanValue()) {
                return true;
            }
            if (!jsonNode.has("children") || !this.recursionGetStatus((ArrayNode)jsonNode.get("children"), permission)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Boolean> getMobilePermission(String mobiledisplayField, Map<String, Set<String>> curProfiles) throws Exception {
        Map<String, Boolean> mobilePermission = this.getPermission(mobiledisplayField, curProfiles);
        if (BeanUtils.isNotEmpty(mobilePermission)) {
            HashMap<String, Boolean> filterMobilePermission = new HashMap<String, Boolean>();
            ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)mobiledisplayField);
            for (JsonNode jsonNode : jsonAry) {
                String name = JsonUtil.getString((JsonNode)jsonNode, (String)"name");
                if (mobilePermission.containsKey(name) && mobilePermission.get(name).booleanValue()) {
                    filterMobilePermission.put(name, true);
                }
                if (filterMobilePermission.size() != 3) continue;
                break;
            }
            return filterMobilePermission;
        }
        return mobilePermission;
    }

    private boolean tileDisplayFields(FormDataTemplate bpmDataTemplate) throws IOException {
        String displayField = bpmDataTemplate.getDisplayField();
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        ArrayNode collectDisplayFields = JsonUtil.createArrayNode();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.collectTileDisplayFields(collectDisplayFields, arrayNode, atomicBoolean);
        return atomicBoolean.get();
    }

    private void collectTileDisplayFields(ArrayNode collectDisplayFields, ArrayNode arrayNode, AtomicBoolean atomicBoolean) {
        arrayNode.forEach(action -> {
            if (action.has("children")) {
                atomicBoolean.set(true);
                this.collectTileDisplayFields(collectDisplayFields, (ArrayNode)action.get("children"), atomicBoolean);
            } else {
                collectDisplayFields.add(action);
            }
        });
    }

    private String getSubEntIds(String formKey) {
        try {
            List<BoEnt> list = this.formMetaManager.getChildrenByFormKey(formKey);
            return list.stream().map(BoEnt::getId).collect(Collectors.joining(","));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private List<Map<String, String>> getFilterPermission(String filterField, Map<String, Set<String>> curProfiles) throws IOException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (StringUtil.isEmpty((String)filterField)) {
            return list;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        for (Object obj : jsonAry) {
            JsonNode permission;
            ObjectNode json = (ObjectNode)obj;
            ArrayNode rights = json.get("right").isArray() ? (ArrayNode)json.get("right") : (ArrayNode)JsonUtil.toJsonNode((String)json.get("right").asText());
            boolean hasRight = false;
            Iterator iterator = rights.iterator();
            while (iterator.hasNext() && !(hasRight = this.permssionCalc.hasRight((permission = (JsonNode)iterator.next()).toString(), curProfiles))) {
            }
            if (!hasRight) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", JsonUtil.getString((JsonNode)json, (String)"name", (String)""));
            map.put("filterKey", JsonUtil.getString((JsonNode)json, (String)"key", (String)""));
            list.add(map);
        }
        return list;
    }

    @Override
    public Map<String, Boolean> getManagePermission(String manageField, Map<String, Set<String>> currentMap) throws Exception {
        if (StringUtil.isEmpty((String)manageField)) {
            return new HashMap<String, Boolean>();
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)manageField);
        return this.getPermissionMap(jsonAry, currentMap);
    }

    @Override
    public void batchWordPrint(BatchWordPrintVo batchWordPrintVo, HttpServletResponse response) throws Exception {
        ArrayList<FormPrintParam> formPrintParamList = new ArrayList<FormPrintParam>();
        for (String id : batchWordPrintVo.getIds().split(",")) {
            ArrayList<BoData> boDataList = new ArrayList<BoData>();
            BoData boData = this.boDataHandler.getById((Object)id, batchWordPrintVo.getBoAlias());
            if (StringUtil.isEmpty((String)boData.getBoDefAlias())) {
                boData.setBoDefAlias(boData.getBoDef().getAlias());
            }
            boDataList.add(boData);
            List boDefs = this.boDefManager.getByFormKey(batchWordPrintVo.getFormKey()).stream().filter(def -> !batchWordPrintVo.getBoAlias().equals(def.getAlias())).collect(Collectors.toList());
            for (BoDef boDef : boDefs) {
                BoData otherData = this.boDataHandler.getDataTemplateById((Object)id, boDef.getAlias());
                otherData.setBoDefAlias(boDef.getAlias());
                boDataList.add(otherData);
            }
            ObjectNode boDataJson = BoUtil.hanlerData(boDataList);
            FormPrintParam formPrintParam = new FormPrintParam();
            formPrintParam.setBoData(JsonUtil.toJson((Object)boDataJson));
            formPrintParam.setPrintType(batchWordPrintVo.getPrintType());
            formPrintParam.setId(batchWordPrintVo.getFormWordPrintId());
            formPrintParamList.add(formPrintParam);
        }
        HashMap<String, ByteArrayInputStream> map = new HashMap<String, ByteArrayInputStream>();
        for (FormPrintParam formPrintParam : formPrintParamList) {
            String printId = (String)((FormPrintTemplateManager)AppUtil.getBean(FormPrintTemplateManager.class)).formWordPrint(formPrintParam).getValue();
            FileInfo file = this.fileService.get(printId);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.fileService.downloadFile(file.getId(), outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            map.put(file.getId() + "." + file.getExtensionName(), inputStream);
        }
        String fileName = "formDataTemplatePrint_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MM_dd_HHmm");
        HttpUtil.downLoadFile((HttpServletResponse)response, map, (String)fileName);
    }

    private Map<String, Boolean> getPermissionMap(ArrayNode jsonAry, Map<String, Set<String>> currentMap) throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (BeanUtils.isEmpty((Object)jsonAry) || jsonAry.size() < 1) {
            return map;
        }
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode)JsonUtil.toJsonNode(obj);
            if (json.has("children") && json.get("children").size() > 0) {
                this.recursion(json, map, currentMap);
                continue;
            }
            this.putFieldRight(json, map, currentMap);
        }
        return map;
    }

    private void putFieldRight(ObjectNode json, Map<String, Boolean> map, Map<String, Set<String>> currentMap) throws Exception {
        if (!json.has("name")) {
            return;
        }
        String name = json.get("name").asText();
        String rightStr = json.get("right").textValue();
        ArrayNode rights = StringUtil.isEmpty((String)rightStr) ? (ArrayNode)json.get("right") : (ArrayNode)JsonUtil.toJsonNode((String)rightStr);
        boolean hasRight = false;
        for (JsonNode permission : rights) {
            hasRight = this.permssionCalc.hasRight(permission.toString(), currentMap);
            if (!hasRight) continue;
            map.put(name, hasRight);
            break;
        }
        map.put(name, hasRight);
        this.handleSpecialFieldRight(name, hasRight, json, map);
    }

    private void handleSpecialFieldRight(String name, boolean hasRight, ObjectNode json, Map<String, Boolean> map) throws Exception {
        String buttonId;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("batchSave", "addData", "addFlow", "searchData", "edit"));
        if (list.contains(name) && BeanUtils.isNotEmpty((Object)(buttonId = JsonUtil.getString((JsonNode)json, (String)"buttonId")))) {
            map.put(String.format("%s_%s", name, buttonId), hasRight);
            return;
        }
        String desc = JsonUtil.getString((JsonNode)json, (String)"desc", (String)"");
        switch (name) {
            case "js": {
                String jsValue = JsonUtil.getString((JsonNode)json, (String)"jsValue", (String)"");
                if (!StringUtil.isNotEmpty((String)jsValue)) break;
                String finalStr = String.format("%s_%s", desc, jsValue);
                String jsValMd5 = EncryptUtil.md5Hex((String)finalStr);
                map.put(String.format("js_%s", jsValMd5), hasRight);
                break;
            }
            case "url": {
                String url = JsonUtil.getString((JsonNode)json, (String)"url", (String)"");
                String urlParams = JsonUtil.getString((JsonNode)json, (String)"urlParams", (String)"");
                String fullUrl = String.format("%s_%s", url, urlParams);
                if (!StringUtil.isNotEmpty((String)fullUrl)) break;
                String finalStr = String.format("%s_%s", desc, fullUrl);
                String fullMd5 = EncryptUtil.md5Hex((String)finalStr);
                map.put(String.format("url_%s", fullMd5), hasRight);
                break;
            }
            case "switch": {
                String switchOn = JsonUtil.getString((JsonNode)json, (String)"switchOn", (String)"");
                String switchOff = JsonUtil.getString((JsonNode)json, (String)"switchOff", (String)"");
                String switchVal = String.format("%s_%s", switchOn, switchOff);
                if (!StringUtil.isNotEmpty((String)switchVal)) break;
                String finalStr = String.format("%s_%s", desc, switchVal);
                String fullMd5 = EncryptUtil.md5Hex((String)finalStr);
                map.put(String.format("switch_%s", fullMd5), hasRight);
                break;
            }
            case "batchUpdate": {
                String batchUpdateData = JsonUtil.getString((JsonNode)json, (String)"batchUpdateData", (String)"");
                if (BeanUtils.isEmpty((Object)batchUpdateData)) {
                    batchUpdateData = JsonUtil.getString((JsonNode)json, (String)"relationConfig", (String)"");
                }
                if (!StringUtil.isNotEmpty((String)batchUpdateData)) break;
                String finalStr = String.format("%s_%s", desc, batchUpdateData);
                String jsValMd5 = EncryptUtil.md5Hex((String)finalStr);
                map.put(String.format("batchUpdate_%s", jsValMd5), hasRight);
                break;
            }
        }
    }

    private void recursion(ObjectNode json, Map<String, Boolean> map, Map<String, Set<String>> currentMap) throws Exception {
        ArrayNode arrayNode = (ArrayNode)json.get("children");
        for (JsonNode jsonNode : arrayNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.has("children") && objectNode.get("children").size() > 0) {
                this.recursion(objectNode, map, currentMap);
                continue;
            }
            this.putFieldRight(objectNode, map, currentMap);
        }
    }

    private Map<String, Boolean> getPermission(String displayField, Map<String, Set<String>> rightMap) throws Exception {
        if (StringUtils.isEmpty((String)displayField)) {
            return new HashMap<String, Boolean>();
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        return this.getPermissionMap(jsonAry, rightMap);
    }

    @Override
    public Map<String, Object> getFormByFormKey(String formKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Form formModel = this.formManager.getMainByFormKey(formKey);
        if (formModel == null || StringUtil.isEmpty((String)formModel.getFormHtml())) {
            map.put("result", "formEmpty");
            return map;
        }
        map.put("form", (Object)formModel);
        map.put("result", true);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> boCopy(FormDataCopyDto formDataCopyDto) throws Exception {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty(formDataCopyDto.getIds()), (String)"id\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)formDataCopyDto.getBoAlias()), (String)"\u6570\u636e\u5efa\u6a21\u522b\u540d\u4e0d\u53ef\u4e3a\u7a7a");
        FormDataTemplate dataTemplate = this.getByAlias(formDataCopyDto.getTemplateAlias());
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)dataTemplate)), (String)"\u4e0d\u5b58\u5728\u8be5\u522b\u540d\u7684\u6570\u636e\u5217\u8868");
        Map<String, CopySetting> copySetting = this.getCopySetting(JsonUtil.toJsonNode((String)dataTemplate.getManageField()));
        for (String id : formDataCopyDto.getIds()) {
            ObjectNode data = this.getCopyFormData(id, formDataCopyDto.getBoAlias(), copySetting);
            if (!BeanUtils.isNotEmpty((Object)data)) continue;
            this.boSave(data, null, formDataCopyDto.getBoAlias(), "", "");
        }
        return CommonResult.ok();
    }

    private Map<String, CopySetting> getCopySetting(JsonNode fieldOptions) throws IOException {
        ArrayNode optionsArray = (ArrayNode)fieldOptions;
        for (JsonNode jsonNode : optionsArray) {
            String optionName = JsonUtil.getString((JsonNode)jsonNode, (String)"name");
            if (!"copy".equalsIgnoreCase(optionName)) continue;
            JsonNode copySetting = jsonNode.get("copySetting");
            if (BeanUtils.isEmpty((Object)copySetting)) {
                return new HashMap<String, CopySetting>();
            }
            List copySettings = (List)JsonUtil.toBean((JsonNode)copySetting, (TypeReference)new TypeReference<List<CopySetting>>(){});
            return copySettings.stream().collect(Collectors.toMap(CopySetting::getName, item -> item));
        }
        return new HashMap<String, CopySetting>();
    }

    public ObjectNode getCopyFormData(String id, String boAlias, Map<String, CopySetting> copySettingMap) throws Exception {
        BoData boData = this.boDataHandler.getById((Object)id, boAlias);
        if (StringUtil.isEmpty((String)boData.getBoDefAlias())) {
            boData.setBoDefAlias(boData.getBoDef().getAlias());
        }
        List<BoData> boDatas = Collections.singletonList(boData);
        HashMap<String, BoEnt> entMap = new HashMap<String, BoEnt>();
        this.handleCopyBoData(boData.getBoEnt().getName(), boDatas, entMap, copySettingMap);
        if (BeanUtils.isEmpty(boDatas)) {
            return null;
        }
        ObjectNode formData = (ObjectNode)BoUtil.hanlerData(boDatas).get(boAlias);
        ObjectNode newNode = JsonUtil.getMapper().createObjectNode();
        newNode.set(boAlias, (JsonNode)formData);
        return newNode;
    }

    private void handleCopyBoData(String entName, List<BoData> boDatas, Map<String, BoEnt> entMap, Map<String, CopySetting> copySettingMap) {
        if (copySettingMap.containsKey(entName) && !copySettingMap.get(entName).isEnable()) {
            boDatas.clear();
            return;
        }
        for (BoData boData : boDatas) {
            BoEnt boEnt = entMap.get(entName);
            if (null == boEnt) {
                boEnt = null != boData.getBoEnt() ? boData.getBoEnt() : this.boEntManager.getByName(entName);
                entMap.put(entName, boEnt);
            }
            boData.getData().remove(boEnt.getFk());
            boData.getData().remove(boEnt.getPkKey());
            CopySetting copySetting = copySettingMap.get(entName);
            if (BeanUtils.isNotEmpty((Object)copySetting)) {
                if ("w".equals(copySetting.getModel())) {
                    HashMap data = new HashMap();
                    copySetting.getValue().forEach(value -> data.put(value, boData.getData().get(value)));
                    boData.setData(data);
                } else {
                    copySetting.getValue().forEach(value -> boData.getData().remove(value));
                }
            }
            if (!BeanUtils.isNotEmpty((Object)boData.getSubMap())) continue;
            for (String subEntName : boData.getSubMap().keySet()) {
                List subDatas = (List)boData.getSubMap().get(subEntName);
                if (!BeanUtils.isNotEmpty((Object)subDatas)) continue;
                this.handleCopyBoData(subEntName, subDatas, entMap, copySettingMap);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<BoResult> boSave(ObjectNode jsonObject, String templateKey, String boAlias, String delDraftId, String editButtonId) throws Exception {
        String pk;
        List otherDefs;
        List resultList;
        String idVal;
        JsonNode permission;
        String formKey;
        FormMeta meta;
        String updateRefId = JsonUtil.getString((JsonNode)jsonObject, (String)"updateRefId");
        JsonNode jsonData = JsonUtil.toJsonNode((String)jsonObject.get(boAlias).toString());
        jsonData = BoUtil.transJsonNode((JsonNode)jsonData);
        BoData boData = BoUtil.transJSON((JsonNode)jsonData);
        BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
        BoDef boDef = this.boDefService.getByAlias(boAlias);
        BoEnt boEnt = boDef.getBoEnt();
        boData.setBoEnt(boEnt);
        boData.setBoDef(boDef);
        if (BeanUtils.isNotEmpty((Object)jsonData.get("subMap"))) {
            BoUtil.handlerSubMap((BoData)boData, (ObjectNode)((ObjectNode)jsonData));
        }
        if (jsonObject.hasNonNull("formKey") && BeanUtils.isNotEmpty((Object)(meta = this.formMetaManager.getByKey(formKey = jsonObject.get("formKey").asText())).getIdentityConfig())) {
            FormUtil.handleIdentity(boData, meta.getIdentityConfig());
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("boData", boData);
        param.put("bpmRuntimeFeignService", this.bpmRuntimeFeignService);
        if (StringUtil.isNotEmpty((String)updateRefId)) {
            String updateRefIdScript = "boData.set(\"" + boEnt.getFk() + "\",\"" + updateRefId + "\")";
            this.groovyScriptEngine.execute(updateRefIdScript, param);
        }
        String formKey2 = null;
        FormDataTemplate template = null;
        if (StringUtil.isNotEmpty((String)templateKey)) {
            template = this.getByAlias(templateKey);
            formKey2 = template.getFormKey();
            if (BeanUtils.isNotEmpty((Object)template.getBeforeScript())) {
                this.groovyScriptEngine.execute(template.getBeforeScript(), param);
            }
        }
        if (StringUtil.isNotEmpty((String)editButtonId) && (permission = this.bpmFormRightManager.getPermission(formKey2, templateKey, 3, editButtonId)).hasNonNull("subRowAuth")) {
            FormContextThreadUtil.putCommonVars((String)"subRowAuthJosn", (Object)JsonUtil.toJson((Object)permission.get("subRowAuth")));
        }
        String string = idVal = BeanUtils.isEmpty((Object)(resultList = handler.save("", "", boData))) ? "" : ((BoResult)resultList.get(0)).getPk();
        if (StringUtil.isNotEmpty((String)formKey2) && BeanUtils.isNotEmpty(otherDefs = this.boDefManager.getByFormKey(formKey2).stream().filter(def -> !boAlias.equals(def.getAlias())).collect(Collectors.toList()))) {
            for (BoDef otherDef : otherDefs) {
                String alias = otherDef.getAlias();
                if (!jsonObject.hasNonNull(alias)) continue;
                BoDef defByAlias = this.boDefService.getByAlias(alias);
                JsonNode otherNode = BoUtil.transJsonNode((JsonNode)jsonObject.get(alias));
                BoData otherData = BoUtil.transJSON((JsonNode)otherNode);
                if (BeanUtils.isNotEmpty((Object)otherNode.get("subMap"))) {
                    BoUtil.handlerSubMap((BoData)otherData, (ObjectNode)((ObjectNode)otherNode));
                }
                otherData.setBoDef(defByAlias);
                BoEnt otherEnt = defByAlias.getBoEnt();
                otherData.setBoEnt(otherEnt);
                Object pk2 = otherData.getData().get(otherEnt.getPkKey());
                if (BeanUtils.isEmpty(pk2)) {
                    ThreadMsgUtil.addMapMsg((String)"boSaveCreateSave", (String)"true");
                    otherData.getData().put(otherEnt.getPkKey(), idVal);
                }
                List saveResult = handler.save("", "", otherData);
                ThreadMsgUtil.deleteMapMsg((String)"boSaveCreateSave");
                resultList.addAll(saveResult);
            }
        }
        if (BeanUtils.isNotEmpty((Object)resultList)) {
            this.bpmRuntimeFeignService.handleBoDateModify(this.handleBoResult(resultList, jsonObject));
        }
        String string2 = pk = StringUtil.isEmpty((String)boEnt.getPk()) ? "id_" : boEnt.getPk();
        if (StringUtil.isNotEmpty((String)formKey2)) {
            String boDataId = "";
            if (jsonData.has(pk)) {
                boDataId = jsonData.get(pk).asText();
            } else {
                BoResult a = resultList.stream().filter(b -> "add".equals(b.getAction())).findAny().orElse(null);
                if (a != null) {
                    boDataId = a.getPk();
                }
            }
            List<FormDataTemplateExtend> list = this.formDataTemplateExtendManager.getDataTemplateExtendByFormKey(formKey2);
            this.formRemindDataManager.deleteFormRemindDataByBoDataId((QueryWrapper)new QueryWrapper().eq((Object)"OPEM_ID", (Object)boDataId));
            ArrayList<FormRemindData> insertList = new ArrayList<FormRemindData>();
            for (int i = 0; i < list.size(); ++i) {
                JsonNode node;
                String script;
                boolean res;
                FormDataTemplateExtend formDataTemplateExtend = list.get(i);
                String scriptJson = formDataTemplateExtend.getRule();
                if (StringUtil.isEmpty((String)scriptJson) || !(res = this.groovyScriptEngine.executeBoolean(Base64.getFromBase64((String)(script = (node = JsonUtil.toJsonNode((String)scriptJson)).get("scriptStr").asText())), boData.getData()))) continue;
                String typeObj = formDataTemplateExtend.getTypeObj();
                String objId = formDataTemplateExtend.getObjId();
                String content = formDataTemplateExtend.getContent();
                String count = formDataTemplateExtend.getCount();
                String refId = formDataTemplateExtend.getId();
                if (typeObj.equals("script")) {
                    objId = boData.getData().get(objId) + "";
                    FormRemindData formRemindData = new FormRemindData();
                    formRemindData.setContent(content);
                    formRemindData.setCount(count);
                    formRemindData.setObjId(objId);
                    formRemindData.setTypeObj("user");
                    formRemindData.setOpemId(boDataId);
                    formRemindData.setSubject(formDataTemplateExtend.getSubject());
                    formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                    formRemindData.setRefId(refId);
                    insertList.add(formRemindData);
                    continue;
                }
                String[] objIds = objId.split(",");
                for (int j = 0; j < objIds.length; ++j) {
                    FormRemindData formRemindData = new FormRemindData();
                    formRemindData.setContent(content);
                    formRemindData.setCount(count);
                    formRemindData.setObjId(objIds[j]);
                    formRemindData.setSubject(formDataTemplateExtend.getSubject());
                    formRemindData.setTypeObj(typeObj);
                    formRemindData.setOpemId(boDataId);
                    formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                    formRemindData.setRefId(refId);
                    insertList.add(formRemindData);
                }
            }
            this.formRemindDataManager.saveBatch(insertList);
        }
        if (BeanUtils.isNotEmpty((Object)delDraftId)) {
            this.dataTemplateDraftManager.remove((Serializable)((Object)delDraftId));
        }
        if (BeanUtils.isNotEmpty((Object)((Object)template)) && BeanUtils.isNotEmpty((Object)template.getAfterScript())) {
            this.groovyScriptEngine.execute(template.getAfterScript(), param);
        }
        return resultList;
    }

    @Override
    public void boSaveDraft(FormDataTemplateDraft dataTemplateDraft) {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)dataTemplateDraft.getId())) {
            FormDataTemplate dataTemplate = this.getByAlias(dataTemplateDraft.getTempAlias());
            String currentTime = com.hotent.base.util.time.DateUtil.getCurrentTime();
            dataTemplateDraft.setTitle(dataTemplate.getName() + "_" + currentTime);
            dataTemplateDraft.setId(UniqueIdUtil.getSuid());
            dataTemplateDraft.setCreateBy(currentUser.getUserId());
            dataTemplateDraft.setCreateTime(LocalDateTime.now());
            this.dataTemplateDraftManager.create((Model)dataTemplateDraft);
        } else {
            this.dataTemplateDraftManager.update((Model)dataTemplateDraft);
        }
    }

    private Map<String, Object> handleBoResult(List<BoResult> resultList, ObjectNode data) throws Exception {
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (BoResult result : resultList) {
            list.add((ObjectNode)JsonUtil.toJsonNode((Object)result));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayNode boResult = JsonUtil.listToArrayNode(list);
        params.put("boResult", boResult);
        params.put("data", data);
        return params;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void boDel(String[] ids, String boAlias, String formKey) {
        BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
        handler.removeBoData(boAlias, ids);
        if (StringUtil.isNotEmpty((String)formKey)) {
            this.boDefManager.getByFormKey(formKey).stream().filter(def -> !boAlias.equals(def.getAlias())).forEach(def -> handler.removeBoData(def.getAlias(), ids));
        }
    }

    @Override
    public FormDataTemplate getExportDisplay(String alias) throws IOException {
        FormDataTemplate bpmDataTemplate = ((FormDataTemplateDao)this.baseMapper).getByAlias(alias);
        if (BeanUtils.isNotEmpty((Object)((Object)bpmDataTemplate))) {
            ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)bpmDataTemplate.getDisplayField());
            Map curProfiles = this.permssionCalc.getCurrentProfiles();
            if (BeanUtils.isNotEmpty((Object)jsonAry) && jsonAry.size() > 0) {
                ArrayNode newjsonAry = JsonUtil.getMapper().createArrayNode();
                for (Object obj : jsonAry) {
                    ObjectNode json = (ObjectNode)obj;
                    ArrayNode rights = (ArrayNode)JsonUtil.toJsonNode((String)json.get("right").asText());
                    boolean hasRight = false;
                    Iterator iterator = rights.iterator();
                    if (iterator.hasNext()) {
                        JsonNode permission = (JsonNode)iterator.next();
                        hasRight = this.permssionCalc.hasRight(permission.toString(), curProfiles);
                    }
                    json.put("permission", hasRight);
                    newjsonAry.add((JsonNode)json);
                }
                bpmDataTemplate.setDisplayField(newjsonAry.toString());
            }
        }
        return bpmDataTemplate;
    }

    @Override
    public String getFilterSql(String filterField, String dsName, Map<String, Object> param) throws IOException {
        StringBuffer sb = new StringBuffer();
        String sql = "";
        List<Map<String, String>> filters = null;
        if (StringUtil.isNotEmpty((String)filterField) && !filterField.equals("[]")) {
            Map curProfiles = this.permssionCalc.getCurrentProfiles();
            filters = this.getFilterPermission(filterField, curProfiles);
        }
        ArrayNode jsonArray = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        ObjectNode json = JsonUtil.arrayToObject((ArrayNode)jsonArray, (String)"key");
        if (BeanUtils.isEmpty(filters)) {
            return sb.toString();
        }
        for (Map<String, String> map : filters) {
            ObjectNode jsonObject = (ObjectNode)json.get(map.get("filterKey"));
            int type = JsonUtil.getInt((JsonNode)jsonObject, (String)"type", (int)0);
            switch (type) {
                case 1: {
                    String dbType = this.databaseContext.getDbTypeByAlias(dsName);
                    sql = FilterJsonStructUtil.getSql((String)JsonUtil.getString((JsonNode)jsonObject, (String)"condition"), (String)dbType);
                    break;
                }
                case 3: {
                    String filterSql = jsonObject.get("condition").asText();
                    filterSql = filterSql.replaceAll("\\n", "");
                    sql = this.executeScript(filterSql, param);
                    break;
                }
                case 4: {
                    sql = this.getDataPermissionSql(jsonObject.get("condition").asText(), "");
                    break;
                }
            }
            if (!StringUtil.isNotEmpty((String)sql)) continue;
            if (4 != type && !sql.trim().toUpperCase().startsWith("AND")) {
                sb.append(" AND ");
            }
            sb.append(sql);
        }
        return sb.toString();
    }

    @Override
    public String getFilterSql(String filterField, String dsName, Map<String, Object> param, BoEnt boEnt, FormDataTemplate template) throws Exception {
        StringBuffer sb = new StringBuffer();
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        List<Map<String, String>> filters = this.getFilterPermission(filterField, curProfiles);
        ArrayNode jsonArray = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        ObjectNode json = JsonUtil.arrayToObject((ArrayNode)jsonArray, (String)"key");
        if (BeanUtils.isEmpty(filters)) {
            return sb.toString();
        }
        String relation = StringUtil.isEmpty((String)template.getFilterRelation()) ? "or" : template.getFilterRelation();
        for (Map<String, String> map : filters) {
            String flowAuth;
            String dataPermission;
            String filterSql;
            String sqlTemp;
            ObjectNode jsonObject = (ObjectNode)json.get(map.get("filterKey"));
            String sql = "";
            JsonNode jsonCond = jsonObject.get("condition");
            if (jsonCond != null) {
                if (jsonCond instanceof ArrayNode || jsonCond instanceof TextNode) {
                    throw new BaseException("\u6570\u636e\u8fc7\u6ee4\u914d\u7f6e\u7ed3\u6784\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u6570\u636e\u8fc7\u6ee4\uff01");
                }
                sqlTemp = this.getConditionSql((ObjectNode)jsonCond, dsName, boEnt);
                sql = this.joinSql(sql, sqlTemp);
            }
            if (StringUtil.isNotEmpty((String)(filterSql = JsonUtil.getString((JsonNode)jsonObject, (String)"appendSql")))) {
                filterSql = filterSql.replaceAll("\\n", "  ");
                sqlTemp = this.executeScript(filterSql, param);
                sql = this.joinSql(sql, sqlTemp);
            }
            if (StringUtil.isNotEmpty((String)(dataPermission = JsonUtil.getString((JsonNode)jsonObject, (String)"dataPermission"))) && !"[]".equals(dataPermission)) {
                sqlTemp = this.getDataPermissionSql(dataPermission, "");
                sql = this.joinSql(sql, sqlTemp);
            }
            if (StringUtil.isNotEmpty((String)(flowAuth = JsonUtil.getString((JsonNode)jsonObject, (String)"flowAuth")))) {
                sqlTemp = this.getFlowPermissionSql(flowAuth, boEnt, template.getDefId());
                sql = this.joinSql(sql, sqlTemp);
            }
            if (!StringUtil.isNotEmpty((String)sql)) continue;
            if (sb.length() == 0) {
                sb.append(" AND (( ");
            } else {
                sb.append(" ").append(relation.toUpperCase()).append(" (");
            }
            sb.append(sql);
            sb.append(" ) ");
        }
        if (sb.length() > 0) {
            sb.append(" ) ");
        }
        return sb.toString();
    }

    private String joinSql(String src, String dest) {
        if (StringUtil.isEmpty((String)dest)) {
            return src;
        }
        dest = "(" + dest + ")";
        if (StringUtil.isEmpty((String)src)) {
            return dest;
        }
        return src + " AND " + dest;
    }

    private String getConditionSql(ObjectNode jsonCond, String dsName, BoEnt boEnt) throws Exception {
        String sql = "";
        boolean showAll = JsonUtil.getBoolean((ObjectNode)jsonCond, (String)"showAll", (boolean)false);
        if (showAll) {
            return " 1=1 ";
        }
        String dbType = this.databaseContext.getDbTypeByAlias(dsName);
        String condition = JsonUtil.getString((JsonNode)jsonCond, (String)"condition");
        if (StringUtil.isEmpty((String)condition)) {
            return sql;
        }
        if ("oracle".equals(dbType)) {
            ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)condition);
            for (int i = 0; i < array.size(); ++i) {
                String flowvarKey = JsonUtil.getString((JsonNode)array.get(i), (String)"flowvarKey");
                for (BoAttribute attribute : boEnt.getBoAttrList()) {
                    ObjectNode objectNode;
                    String fieldName = flowvarKey.replace(BoEnt.FIELD_PREFIX, "");
                    if (fieldName.contains(".")) {
                        fieldName = fieldName.split("\\.")[1];
                    }
                    if (!attribute.getName().equals(fieldName)) continue;
                    if ("clob".equals(attribute.getDataType())) {
                        objectNode = (ObjectNode)array.get(i);
                        objectNode.put("flowvarKey", "TO_CHAR(" + flowvarKey + ")");
                        array.set(i, (JsonNode)objectNode);
                        continue;
                    }
                    if (!"date".equals(attribute.getDataType())) continue;
                    objectNode = (ObjectNode)array.get(i);
                    if (!StringUtil.isNotEmpty((String)attribute.getFormat())) continue;
                    objectNode.put("datefmt", attribute.getFormat());
                    array.set(i, (JsonNode)objectNode);
                }
            }
            sql = FilterJsonStructUtil.getSql((String)JsonUtil.toJson((Object)array), (String)dbType);
        } else {
            sql = FilterJsonStructUtil.getSql((String)condition, (String)dbType);
        }
        return sql;
    }

    @Override
    public String getFlowPermissionSql(String flowPermission, BoEnt boEnt, String defKey) throws Exception {
        ArrayList filterTyeps = new ArrayList();
        JsonNode types = JsonUtil.toJsonNode((String)flowPermission);
        types.fields().forEachRemaining(node -> {
            if (((JsonNode)node.getValue()).asBoolean()) {
                filterTyeps.add(node.getKey());
            }
        });
        if (filterTyeps.isEmpty()) {
            return "";
        }
        Set flowFilterBusinessKeys = this.bpmRuntimeFeignService.getFlowFilterBusinessKeys(filterTyeps, boEnt.getName(), boEnt.isPkNumber(), defKey);
        if (BeanUtils.isEmpty((Object)flowFilterBusinessKeys)) {
            return "1!=1";
        }
        StringBuilder sb = new StringBuilder(String.format(" t.%s in (", boEnt.getPkKey()));
        Iterator iterator = flowFilterBusinessKeys.iterator();
        while (iterator.hasNext()) {
            sb.append("'" + (String)iterator.next() + "'");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append(") ");
        return sb.toString();
    }

    @Override
    public String getDataPermissionSql(String dataPermission, String fieldPre) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotEmpty((String)dataPermission)) {
            ArrayNode permissionArrayJson = (ArrayNode)JsonUtil.toJsonNode((String)dataPermission);
            HashSet<String> orgIds = new HashSet<String>();
            IUser currentUser = ContextUtil.getCurrentUser();
            for (JsonNode node : permissionArrayJson) {
                if (!BeanUtils.isNotEmpty((Object)node.get("field"))) continue;
                if (LOGIN_USER.equals(node.get("type").asText())) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                    }
                    sb.append(fieldPre + node.get("field").asText() + "='" + currentUser.getUserId() + "'");
                    continue;
                }
                if (LOGIN_USER_ORGS.equals(node.get("type").asText())) {
                    String currentUserOrgIds = currentUser.getAttrbuite("CURRENT_USER_ORGIDS");
                    if (!StringUtil.isNotEmpty((String)currentUserOrgIds)) continue;
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                    }
                    String[] oids = currentUserOrgIds.split(",");
                    HashSet<String> oidSet = new HashSet<String>(Arrays.asList(oids));
                    String inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (LOGIN_USER_SUB_ORGS.equals(node.get("type").asText())) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                    }
                    String currentUserSubOrgIds = StringUtil.isNotEmpty((String)AuthenticationUtil.getCurrentUserSubOrgIds()) ? AuthenticationUtil.getCurrentUserSubOrgIds() : "";
                    String currentUserOrgIds = StringUtil.isNotEmpty((String)AuthenticationUtil.getCurrentUserOrgIds()) ? AuthenticationUtil.getCurrentUserOrgIds() : "";
                    currentUserSubOrgIds = currentUserSubOrgIds + "," + (String)currentUserOrgIds;
                    String[] oids = new String[]{};
                    if (StringUtil.isNotEmpty((String)currentUserSubOrgIds)) {
                        oids = currentUserSubOrgIds.split(",");
                    }
                    if (oids.length == 0) {
                        oids = new String[]{"-1"};
                    }
                    HashSet<String> oidSet = new HashSet<String>(Arrays.asList(oids));
                    String inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (!CUSTOM_ORGS.equals(node.get("type").asText())) continue;
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                ArrayNode tmpArray = (ArrayNode)node.get("orgs");
                for (JsonNode tmpJsonNode : tmpArray) {
                    orgIds.add(tmpJsonNode.get("id").asText());
                }
                String inSql = StringUtil.convertListToSingleQuotesString(orgIds);
                sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
            }
        }
        return sb.toString();
    }

    private String executeScript(String script, Map<String, Object> param) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("param", param);
        vars.putAll(param);
        return this.groovyScriptEngine.executeString(this.replaceVar(script), vars);
    }

    private String replaceVar(String str) {
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        for (IContextVar c : comVarList) {
            str = str.replace("[" + c.getAlias() + "]", c.getValue());
        }
        return "return \"" + str + "\" ;";
    }

    @Override
    public Set<String> getAllFormKeys() {
        HashSet<String> formSets = new HashSet<String>();
        List<String> formKeys = ((FormDataTemplateDao)this.baseMapper).getAllFormKeys();
        if (BeanUtils.isNotEmpty(formKeys)) {
            formSets = new HashSet<String>(formKeys);
        }
        return formSets;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importData(List<MultipartFile> files, String refId, String alias, String formKey) throws Exception {
        for (MultipartFile file : files) {
            int dataCount;
            int subMaxLength;
            boolean isOracle;
            List rows = new ArrayList();
            try {
                rows = ExcelUtil.ImportDate((MultipartFile)file);
            }
            catch (Exception e) {
                throw new BaseException("\u5bfc\u5165\u5b50\u8868\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5bfc\u5165\u6a21\u677f\u3001\u6570\u636e\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002");
            }
            BoEnt boEnt = this.boEntManager.getByName(alias);
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)(boEnt.getDsName() == null ? "LOCAL" : boEnt.getDsName()));
            String dbType = this.databaseContext.getDbType();
            boolean isPgSql = "postgresql".equals(dbType);
            boolean bl = isOracle = "oracle".equals(dbType) || "dm".equals(dbType);
            if (!rows.isEmpty() && (subMaxLength = this.getFormMaxAddLength(formKey, alias)) > 0 && (dataCount = this.getSubDataCount(boEnt, refId, template)) + rows.size() > subMaxLength) {
                int allowImportCount = subMaxLength - dataCount;
                if (allowImportCount > 0) {
                    throw new BaseException(String.format("\u5bfc\u5165\u6570\u636e\u8d85\u51fa\u5b50\u8868\u8bbe\u7f6e\u6700\u5927\u884c\u6570\uff0c\u6700\u5927%d\u884c\uff0c\u8fd8\u80fd\u5bfc\u5165%d\u884c", subMaxLength, allowImportCount));
                }
                throw new BaseException("\u5bfc\u5165\u5b50\u8868\u7684\u884c\u6570\u8d85\u51fa\u9650\u5236");
            }
            for (Map row : rows) {
                int i = 0;
                boolean isExterna = boEnt.isExternal();
                StringBuilder excuteSql = this.preSql(boEnt, row, isExterna);
                excuteSql.append(UniqueIdUtil.getSuid()).append(",");
                excuteSql.append(refId);
                if (boEnt.getColumnList().size() != row.size()) {
                    throw new RuntimeException("\u6570\u636e\u6a21\u677f\u4e0d\u4e00\u81f4\uff01");
                }
                for (Map.Entry map : row.entrySet()) {
                    String dataType = ((BoAttribute)boEnt.getColumnList().get(i++)).getDataType();
                    if ("varchar".equals(dataType) || isOracle && "clob".equals(dataType)) {
                        excuteSql.append(",'").append((String)map.getValue()).append("'");
                        continue;
                    }
                    if (isPgSql && "date".equals(dataType)) {
                        if (StringUtil.isNotEmpty((String)((String)map.getValue()))) {
                            excuteSql.append(",'").append((String)map.getValue()).append("'");
                            continue;
                        }
                        excuteSql.append(",null");
                        continue;
                    }
                    if (isOracle && "date".equals(dataType)) {
                        excuteSql.append(",TO_DATE('").append((String)map.getValue()).append("','yyyy-MM-dd HH24:mi:ss')");
                        continue;
                    }
                    if ("number".equals(dataType) || "int".equals(dataType)) {
                        String numberVal = (String)map.getValue();
                        if (StringUtil.isEmpty((String)numberVal)) {
                            excuteSql.append(",null");
                            continue;
                        }
                        excuteSql.append(",").append(numberVal);
                        continue;
                    }
                    if (StringUtil.isNotEmpty((String)((String)map.getValue()))) {
                        excuteSql.append(",'").append((String)map.getValue()).append("'");
                        continue;
                    }
                    excuteSql.append(",null");
                }
                if (isExterna) {
                    excuteSql.append(",0)");
                } else {
                    excuteSql.append(")");
                }
                template.execute(excuteSql.toString());
            }
        }
    }

    private int getSubDataCount(BoEnt subEnt, String refId, JdbcTemplate template) {
        StringBuilder sb = new StringBuilder("select count(1) as SUB_COUNT from ");
        sb.append(subEnt.getTableName()).append(" where ").append(subEnt.getFk()).append(" = ").append(refId);
        Map result = template.queryForMap(sb.toString());
        Object subCount = result.get("SUB_COUNT");
        if (null != subCount) {
            if (subCount instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)subCount;
                return bigDecimal.intValue();
            }
            if (subCount instanceof Double) {
                Double d = (Double)subCount;
                return d.intValue();
            }
            if (subCount instanceof Integer) {
                return (Integer)subCount;
            }
        }
        return 0;
    }

    private int getFormMaxAddLength(String formKey, String boSubEntity) throws Exception {
        int length = 0;
        if (StringUtil.isEmpty((String)formKey)) {
            return length;
        }
        Form form = this.formManager.getMainByFormKey(formKey);
        String expandStr = form.getExpand();
        JsonNode expand = JsonUtil.toJsonNode((String)expandStr);
        try {
            ObjectNode subObj = this.getSubDataCtrl((ArrayNode)expand.get("list"), boSubEntity);
            if (null != subObj) {
                ObjectNode options = (ObjectNode)subObj.get("options");
                return JsonUtil.getInt((JsonNode)options, (String)"maxRow", (int)0);
            }
        }
        catch (Exception e) {
            return 0;
        }
        return length;
    }

    private ObjectNode getSubDataCtrl(ArrayNode arrayNode, String subEntName) {
        if (null == arrayNode || arrayNode.isEmpty()) {
            return null;
        }
        for (JsonNode node : arrayNode) {
            if (node instanceof ArrayNode) {
                ObjectNode deep = this.getSubDataCtrl((ArrayNode)node, subEntName);
                if (null == deep) continue;
                return deep;
            }
            if (!(node instanceof ObjectNode)) continue;
            String ctrlType = JsonUtil.getString((JsonNode)node, (String)"ctrlType");
            if (SUB_CTRL_TYPE.contains(ctrlType) && node.hasNonNull("options") && subEntName.equals(JsonUtil.getString((JsonNode)node.get("options"), (String)"boSubEntity"))) {
                return (ObjectNode)node;
            }
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                ObjectNode deep;
                Map.Entry entry = (Map.Entry)fields.next();
                if (!(entry.getValue() instanceof ArrayNode) || (deep = this.getSubDataCtrl((ArrayNode)entry.getValue(), subEntName)) == null) continue;
                return deep;
            }
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importMain(List<MultipartFile> files, String alias) throws Exception {
        FormDataTemplate template = this.getByAlias(alias);
        BoDef boDef = this.boDefService.getByDefId(template.getBoDefId());
        BoEnt boEnt = boDef.getBoEnt();
        Iterator<MultipartFile> it = files.iterator();
        ArrayNode displays = (ArrayNode)JsonUtil.toJsonNode((String)template.getDisplayField());
        HashMap<String, String> nameFieldMap = new HashMap<String, String>();
        for (JsonNode field : displays) {
            nameFieldMap.put(field.get("desc").asText(), field.get("name").asText());
        }
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List rows = ExcelUtil.ImportDate((MultipartFile)file);
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)(boEnt.getDsName() == null ? "LOCAL" : boEnt.getDsName()));
            for (Map row : rows) {
                StringBuffer sql = new StringBuffer("insert into ");
                ArrayList<String> fields = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (Map.Entry map : row.entrySet()) {
                    if ("\u4e3b\u952e".equals(map.getKey())) {
                        fields.add(boEnt.getPkKey());
                        if (BeanUtils.isNotEmpty(row.get("\u4e3b\u952e"))) {
                            values.add("'" + (String)row.get("\u4e3b\u952e") + "'");
                            continue;
                        }
                        values.add(UniqueIdUtil.getSuid());
                        continue;
                    }
                    if (!BeanUtils.isNotEmpty(map.getValue())) continue;
                    String key = (String)map.getKey();
                    String field = this.getFieldName(key, boEnt.getColumnList(), (String)nameFieldMap.get(key));
                    fields.add(field);
                    String dataType = this.getDataType(key, boEnt.getColumnList(), (String)nameFieldMap.get(key));
                    if ("number".equals(dataType)) {
                        values.add((String)map.getValue());
                        continue;
                    }
                    values.add("'" + (String)map.getValue() + "'");
                }
                if (!fields.contains(boEnt.getPkKey())) {
                    fields.add(boEnt.getPkKey());
                    values.add(UniqueIdUtil.getSuid());
                }
                fields.add(BoEnt.FK_NAME);
                values.add("0");
                fields.add("F_form_data_rev_");
                values.add("0");
                sql.append(boEnt.getTableName());
                sql.append("(" + String.join((CharSequence)",", fields) + ")");
                sql.append(" values ");
                sql.append("(" + String.join((CharSequence)",", values) + ")");
                jdbcTemplate.execute(sql.toString());
            }
        }
    }

    private String getFieldName(String key, List<BoAttribute> columnList, String fieldName) {
        for (BoAttribute boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getFieldName();
        }
        return "";
    }

    private String getDataType(String key, List<BoAttribute> columnList, String fieldName) {
        for (BoAttribute boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getDataType();
        }
        return "";
    }

    @Override
    public Map<String, Object> getFormData(String formKey, String boAlias, String id, String action, String buttonId, String recordId, String dataKey) throws Exception {
        int type = this.convert2Type(action);
        Map<String, Object> map = this.getFormByFormKey(formKey);
        if ("formEmpty".equals(map.get("result"))) {
            return map;
        }
        JsonNode permission = this.bpmFormRightManager.getPermission(formKey, dataKey, type, buttonId);
        map.put("permission", permission);
        ArrayList<BoData> boDatas = new ArrayList<BoData>();
        if (StringUtil.isNotEmpty((String)id)) {
            BoData boData;
            Object data;
            ObjectNode record;
            if (StringUtil.isNotEmpty((String)recordId) && BeanUtils.isNotEmpty((Object)(record = this.bpmRuntimeFeignService.getModifyById(recordId))) && BeanUtils.isNotEmpty((Object)record.get("data")) && StringUtil.isNotEmpty((String)(data = record.get("data").asText()))) {
                JsonNode formData = JsonUtil.toJsonNode((String)data);
                map.put("permission", permission);
                map.put("data", formData);
                return map;
            }
            if (permission.hasNonNull("subRowAuth")) {
                FormContextThreadUtil.putCommonVars((String)"subRowAuthJosn", (Object)JsonUtil.toJson((Object)permission.get("subRowAuth")));
            }
            if (StringUtil.isEmpty((String)(boData = this.boDataHandler.getById((Object)id, boAlias)).getBoDefAlias())) {
                boData.setBoDefAlias(boData.getBoDef().getAlias());
            }
            boDatas.add(boData);
            this.boDefManager.getByFormKey(formKey).stream().filter(def -> !boAlias.equals(def.getAlias())).forEach(def -> {
                try {
                    BoData otherData = this.boDataHandler.getDataTemplateById((Object)id, def.getAlias());
                    otherData.setBoDefAlias(def.getAlias());
                    boDatas.add(otherData);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        } else {
            List boDefs = this.boDefManager.getByFormKey(formKey);
            for (BoDef boDef : boDefs) {
                String code = boDef.getAlias();
                BoData boData = this.formService.getBodataByDefCode("database", code);
                if (StringUtil.isEmpty((String)boData.getBoDefAlias())) {
                    boData.setBoDefAlias(boData.getBoDef().getAlias());
                }
                if (!BeanUtils.isNotEmpty((Object)boData)) continue;
                boDatas.add(boData);
            }
        }
        HashSet set = new HashSet();
        boDatas.forEach(item -> {
            for (String subKey : item.getSubMap().keySet()) {
                set.add(subKey);
                Map sunInitData = (Map)item.getInitDataMap().get(subKey);
                Object initData = sunInitData.get("initData");
                if (!BeanUtils.isNotEmpty(initData) || !(initData instanceof HashMap)) continue;
                for (String o : ((HashMap)initData).keySet()) {
                    set.add(o);
                }
            }
        });
        ObjectNode object = BoUtil.hanlerData(boDatas);
        map.put("data", object);
        ObjectNode table = (ObjectNode)permission.get("table");
        if (BeanUtils.isNotEmpty((Object)table)) {
            Iterator keyIterator = table.fieldNames();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                JsonNode node = table.get(key);
                boolean isFormTable = StringUtil.isNotEmpty((String)key) && key.contains("[formTable]");
                if (isFormTable) continue;
                if (node instanceof ObjectNode && ((ObjectNode)node).has("isDataView") && JsonUtil.getBoolean((ObjectNode)((ObjectNode)node), (String)"isDataView")) {
                    ((ObjectNode)node).remove("isDataView");
                    continue;
                }
                if (set.contains(key)) continue;
                ((ObjectNode)table.get(key)).put("hidden", true);
            }
        }
        map.put("permission", permission);
        return map;
    }

    public Integer convert2Type(String action) {
        if ("add".equals(action)) {
            return 3;
        }
        if ("edit".equals(action)) {
            return 4;
        }
        if ("get".equals(action)) {
            return 5;
        }
        return 0;
    }

    @Override
    public Map<String, Object> getTempDraftData(String draftId) throws IOException {
        FormDataTemplateDraft formDataTemplateDraft = (FormDataTemplateDraft)this.dataTemplateDraftManager.get((Serializable)((Object)draftId));
        FormDataTemplate formDataTemplate = this.getByAlias(formDataTemplateDraft.getTempAlias());
        Map<String, Object> map = this.getFormByFormKey(formDataTemplate.getFormKey());
        if ("formEmpty".equals(map.get("result"))) {
            return map;
        }
        int type = this.convert2Type("add");
        String dataKey = formDataTemplate.getAlias();
        JsonNode permission = this.bpmFormRightManager.getPermission(formDataTemplate.getFormKey(), dataKey, type, "");
        map.put("permission", permission);
        JsonNode object = JsonUtil.toJsonNode((String)formDataTemplateDraft.getDataJson());
        map.put("data", object);
        map.put("draft", (Object)formDataTemplateDraft);
        return map;
    }

    @Override
    public void exportData(HttpServletResponse response, String formKey, String getType, String filterKey, String expField, QueryFilter queryFilter) throws Exception {
        FormDataTemplate template = this.getByAlias(formKey);
        getType = StringUtil.isEmpty((String)getType) ? "getType" : getType;
        PageBean page = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        if ("page".equals(getType) && BeanUtils.isNotEmpty((Object)queryFilter.getPageBean())) {
            page.setPage(queryFilter.getPageBean().getPage().intValue());
            page.setPageSize(queryFilter.getPageBean().getPageSize().intValue());
        }
        expField = Base64.getFromBase64((String)expField);
        queryFilter.setPageBean(page);
        filterKey = StringUtil.isNotEmpty((String)filterKey) ? filterKey : "";
        DataTemplateQueryVo vo = new DataTemplateQueryVo();
        vo.setTemplateId(template.getId());
        vo.setQueryFilter(queryFilter);
        PageList pageList = this.getList(template, vo, false).get();
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        ArrayNode formField = (ArrayNode)JsonUtil.toJsonNode((String)template.getFormField());
        ObjectNode showJO = JsonUtil.getMapper().createObjectNode();
        ArrayNode displayField = (ArrayNode)JsonUtil.toJsonNode((String)template.getDisplayField());
        displayField.forEach(obj -> showJO.put(obj.get("name").asText(), obj.get("desc").asText()));
        formField.forEach(obj -> showJO.put(obj.get("name").asText(), obj.get("desc").asText()));
        for (String str : expField.split(",")) {
            exportMaps.put(str, showJO.get(str).asText());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)template.getName(), (int)24, exportMaps, (List)pageList.getRows());
        ExcelUtil.downloadExcel((Workbook)book, (String)template.getName(), (HttpServletResponse)response);
    }

    @Override
    public void downloadMainTempFile(HttpServletResponse response, String alias) throws Exception {
        FormDataTemplate template = this.getByAlias(alias);
        BoDef boDef = this.boDefService.getByAlias(template.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        List boAttrList = boEnt.getColumnList();
        for (BoAttribute boAttr : boAttrList) {
            exportMaps.put(boAttr.getName(), boAttr.getDesc());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)template.getName(), (int)24, exportMaps, new ArrayList());
        ExcelUtil.downloadExcel((Workbook)book, (String)(template.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
    }

    @Override
    public void downloadTempFile(HttpServletResponse response, String alias) throws Exception {
        FormDataTemplate template = this.getByAlias(alias);
        String manageField = template.getManageField();
        if (StringUtil.isEmpty((String)manageField)) {
            throw new BaseException("\u5c1a\u672a\u914d\u7f6e\u6309\u94ae\uff0c\u65e0\u6cd5\u4e0b\u8f7d");
        }
        ArrayNode btns = (ArrayNode)JsonUtil.toJsonNode((String)manageField);
        Object importBoList = null;
        for (JsonNode btn : btns) {
            ArrayNode fileArr;
            String fileStr;
            JsonNode fileNode;
            if (!"import".equals(btn.get("name").asText())) continue;
            if (!btn.has("config")) {
                BoDef boDef = this.boDefService.getByAlias(template.getBoDefAlias());
                ObjectNode configObj = JsonUtil.getMapper().createObjectNode();
                configObj.put("bindPk", boDef.getBoEnt().getPkKey());
                configObj.put("desc", boDef.getBoEnt().getDesc());
                configObj.put("name", boDef.getBoEnt().getName());
                configObj.set("children", (JsonNode)JsonUtil.getMapper().createArrayNode());
                ArrayNode config = JsonUtil.getMapper().createArrayNode();
                config.add((JsonNode)configObj);
                ((ObjectNode)btn).set("config", (JsonNode)config);
            }
            String fileId = "";
            String fileName = "";
            if (btn.has("file") && (fileNode = JsonUtil.toJsonNode((String)(fileStr = JsonUtil.getString((JsonNode)btn, (String)"file")))) instanceof ArrayNode && !(fileArr = (ArrayNode)fileNode).isEmpty()) {
                fileId = JsonUtil.getString((JsonNode)fileArr.get(0).get("response"), (String)"fileId", (String)"");
                fileName = JsonUtil.getString((JsonNode)fileArr.get(0), (String)"name", (String)"\u5bfc\u5165\u6a21\u677f");
            }
            if (StringUtil.isEmpty((String)fileId)) {
                DataTemplateWorkBookService bookService = (DataTemplateWorkBookService)AppUtil.getBean(DataTemplateWorkBookService.class);
                bookService.downloadTemplate(template, (ObjectNode)btn, response);
            } else {
                PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
                byte[] bytes = portalFeignService.getFileBytesById(fileId);
                this.handleResponse(fileName, response);
                response.getOutputStream().write(bytes);
            }
            return;
        }
        throw new BaseException("\u5c1a\u672a\u914d\u7f6e\u5bfc\u5165\u6309\u94ae\uff0c\u65e0\u6cd5\u4e0b\u8f7d");
    }

    private void handleResponse(String fileName, HttpServletResponse response) throws Exception {
        String fileDisplay = URLEncoder.encode(fileName, "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileDisplay);
    }

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<FormDataVo> getList(FormDataTemplate template, DataTemplateQueryVo dataTemplateQueryVo, boolean isSummary) throws Exception {
        PageList<Map<String, Object>> pageList;
        FormDataVo returnData = new FormDataVo();
        BoDef boDef = this.boDefService.getByAlias(template.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        String dbType = StringUtil.isNotEmpty((String)boEnt.getDsName()) ? this.databaseContext.getDbTypeByAlias(boEnt.getDsName()) : SQLUtil.getDbType();
        this.handleQueryFilter(template, dataTemplateQueryVo, returnData, boEnt);
        QueryFilter<?> queryFilter = dataTemplateQueryVo.getQueryFilter();
        Map params = queryFilter.getParams();
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        boolean hasTenantId = boEnt.getAttrFieldMap().keySet().contains("tenant_id_");
        BaseContext context = (BaseContext)AppUtil.getBean(BaseContext.class);
        String currentTenantId = context.getCurrentTenantId();
        if (!TenantConstant.IGNORE_TABLES.contains(boEnt.getTableName()) && hasTenantId && StringUtil.isNotEmpty((String)currentTenantId)) {
            QueryField queryField = new QueryField("t.tenant_id_", (Object)currentTenantId);
            queryFilter.getQuerys().add(queryField);
        }
        List<TemplateField> fields = this.getAllFields(boEnt, template);
        String mainPkKey = StringUtil.isEmpty((String)boEnt.getPk()) ? "id_" : boEnt.getPk();
        HashMap<String, Object> formatMap = new HashMap<String, Object>();
        String sql = this.buildSql(this.mergeField(template.getDisplayField(), fields), boEnt.getTableName(), mainPkKey, template.getJoinTables(), dbType, dsName, formatMap);
        queryFilter = this.getTemplateQueryFilter(queryFilter, template);
        String filterSql = this.getFilterSql(template.getFilterField(), dsName, params, boEnt, template);
        boolean isTreeList = DataTemplateDisplayMode.TREE_LIST.ordinal() == template.getDisplayMode().shortValue();
        TreeListConfigDTO treeListConfigDTO = null;
        String pIdValue = dataTemplateQueryVo.getParentIdValue();
        if (StringUtil.isEmpty((String)template.getTreeListConfig())) {
            isTreeList = false;
        } else {
            treeListConfigDTO = (TreeListConfigDTO)JsonUtil.toBean((String)template.getTreeListConfig(), TreeListConfigDTO.class);
            if (StringUtil.isEmpty((String)pIdValue)) {
                String string = pIdValue = treeListConfigDTO.getScript() != null && treeListConfigDTO.getScript() != false ? this.groovyScriptEngine.executeString(pIdValue, null) : treeListConfigDTO.getpValue();
            }
        }
        if (StrUtil.isEmpty((CharSequence)pIdValue)) {
            pIdValue = "0";
        }
        if (BeanUtils.isNotEmpty(pageList = this.getData(boEnt.getTableName(), sql, queryFilter, dsName, filterSql, isTreeList, treeListConfigDTO, pIdValue))) {
            List list = pageList.getRows();
            this.formatListData(list, template.getDisplayField());
            List displayFields = (List)JsonUtil.toBean((String)template.getDisplayField(), (TypeReference)new TypeReference<List<DisplayField>>(){});
            this.decryptResult(displayFields, list, DisplayField::getName);
            returnData.setPage(pageList.getPage());
            returnData.setPageSize(pageList.getPageSize());
            Map<String, DisplayField> displayFieldMap = displayFields.stream().filter(map -> StringUtil.isNotEmpty((String)map.getName())).collect(Collectors.toMap(map -> map.getName().toLowerCase(), v -> v));
            for (Map rowMap : list) {
                Map<String, Object> rtnMap = this.convertDbToData(boEnt, rowMap, displayFieldMap, formatMap);
                rtnMap.put("isStartFlow", false);
                for (DisplayField displayField : displayFields) {
                    if (displayField.getCustomColumn() == null || !displayField.getCustomColumn().booleanValue() || !StringUtil.isNotEmpty((String)displayField.getName())) continue;
                    rtnMap.put(displayField.getName(), MapUtil.getIgnoreCase((Map)rowMap, (String)displayField.getName()));
                }
                returnData.getRows().add(rtnMap);
                returnData.setTotal(pageList.getTotal());
            }
        }
        this.haldleSummary(template, dsName, sql, boEnt, isSummary, queryFilter, returnData, filterSql);
        return CompletableFuture.completedFuture(returnData);
    }

    private PageList<Map<String, Object>> getData(String tableName, String sql, QueryFilter<?> queryFilter, String dsName, String filterSql, boolean isTreeList, TreeListConfigDTO treeListConfigDTO, String pIdValue) {
        if (isTreeList && StringUtil.isEmpty((String)pIdValue)) {
            return null;
        }
        QueryFilter queryFilterTemp = (QueryFilter)SerializationUtils.clone(queryFilter);
        if (isTreeList) {
            QueryField queryField = new QueryField("t." + treeListConfigDTO.getpId(), (Object)pIdValue);
            queryFilterTemp.getQuerys().add(queryField);
        }
        PageList pageList = (PageList)this.databaseContext.switchDS(dsName, () -> this.query(sql, queryFilterTemp, filterSql), e -> {
            BaseException baseException = new BaseException((Throwable)e);
            baseException.setMessage("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01");
            throw baseException;
        });
        if (isTreeList && pageList != null && CollUtil.isNotEmpty((Collection)pageList.getRows())) {
            boolean isLazy = DataTemplateTreeDataMode.LAZY.ordinal() == treeListConfigDTO.getTreeDataMode().intValue();
            for (Map item : pageList.getRows()) {
                String fieldNameId;
                String id = MapUtil.getStringIgnoreKey((Map)item, (String)(fieldNameId = this.joinDisplayField(tableName, treeListConfigDTO.getId())), (String)"");
                if (StringUtil.isEmpty((String)id)) {
                    if (!isLazy) continue;
                    item.put("hasChildren", false);
                    continue;
                }
                List<Map<String, Object>> listChildren = this.getDataChildren(tableName, sql, queryFilter, dsName, filterSql, treeListConfigDTO, id);
                if (isLazy) {
                    item.put("hasChildren", CollUtil.isNotEmpty(listChildren));
                    continue;
                }
                if (!CollUtil.isNotEmpty(listChildren)) continue;
                item.put("children", listChildren);
            }
        }
        return pageList;
    }

    private String joinDisplayField(String tableName, String fieldName) {
        String result = tableName + fieldName;
        return result.replaceAll("_", "").toLowerCase();
    }

    private List<Map<String, Object>> getDataChildren(String tableName, String sql, QueryFilter<?> queryFilter, String dsName, String filterSql, TreeListConfigDTO treeListConfigDTO, String pIdValue) {
        if (StringUtil.isEmpty((String)pIdValue)) {
            return null;
        }
        QueryFilter queryFilterTemp = (QueryFilter)SerializationUtils.clone(queryFilter);
        QueryField queryField = new QueryField("t." + treeListConfigDTO.getpId(), (Object)pIdValue);
        queryFilterTemp.getQuerys().add(queryField);
        List list = (List)this.databaseContext.switchDS(dsName, () -> this.list(sql, queryFilterTemp, filterSql), e -> {
            BaseException baseException = new BaseException((Throwable)e);
            baseException.setMessage("\u67e5\u8be2\u5217\u8868\u5b50\u6570\u636e\u65f6\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01");
            throw baseException;
        });
        if (DataTemplateTreeDataMode.LAZY.ordinal() == treeListConfigDTO.getTreeDataMode().intValue()) {
            return list;
        }
        if (CollUtil.isNotEmpty((Collection)list)) {
            for (Map item : list) {
                String fieldNameId = this.joinDisplayField(tableName, treeListConfigDTO.getId());
                String fieldNameParentId = this.joinDisplayField(tableName, treeListConfigDTO.getpId());
                String id = MapUtil.getStringIgnoreKey((Map)item, (String)fieldNameId, (String)"");
                String parentId = MapUtil.getStringIgnoreKey((Map)item, (String)fieldNameParentId, (String)"");
                if (StringUtil.isEmpty((String)id) || id.equals(parentId)) continue;
                List<Map<String, Object>> listChildren = null;
                if (StringUtil.isNotEmpty((String)id)) {
                    listChildren = this.getDataChildren(tableName, sql, queryFilter, dsName, filterSql, treeListConfigDTO, id);
                }
                if (!CollUtil.isNotEmpty(listChildren)) continue;
                item.put("children", listChildren);
            }
        }
        return list;
    }

    private void decryptResult(List<DisplayField> displayFields, List<Map<String, Object>> list, Function<DisplayField, String> keyRule) {
        for (Map<String, Object> data : list) {
            for (String key : data.keySet()) {
                for (DisplayField field : displayFields) {
                    if (!key.equalsIgnoreCase(keyRule.apply(field)) || field.getIsEncode() != 1) continue;
                    try {
                        Object val = data.get(key);
                        data.put(key, EncryptUtil.decrypt((String)((String)val), (String)"@$ATPW*%"));
                    }
                    catch (Exception e) {
                        this.logger.error("\u5efa\u6a21\u5b57\u6bb5\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
    }

    private List<TemplateField> getAllFields(BoEnt boEnt, FormDataTemplate template) throws Exception {
        ArrayList<TemplateField> fields = new ArrayList<TemplateField>();
        this.getFormField(StringUtil.isNotEmpty((String)boEnt.getDsName()) ? boEnt.getDsName() : "LOCAL", fields, boEnt.getTableName());
        this.getJoinTableFields(template.getJoinTables(), template.getDsName(), fields);
        return fields;
    }

    private void haldleSummary(FormDataTemplate template, String dsName, String sql, BoEnt boEnt, boolean isSummary, QueryFilter queryFilter, FormDataVo returnData, String filterSql) throws IOException {
        JsonNode summaryFieldNode = JsonUtil.toJsonNode((String)template.getSummaryField());
        if (isSummary && summaryFieldNode.size() > 0) {
            ArrayList counterList = Lists.newArrayList();
            ArrayList otherList = Lists.newArrayList();
            for (JsonNode item : summaryFieldNode) {
                if (item.get("whetherSummarize") == null || !item.get("whetherSummarize").asBoolean()) continue;
                String method = JsonUtil.getStringIgnoreKey((JsonNode)item, (String)"method", (String)"");
                Assert.isTrue((boolean)StringUtil.isNotEmpty((String)method), (String)"\u6c47\u603b\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
                if ("count".equals(method)) {
                    counterList.add(item);
                    continue;
                }
                otherList.add(item);
            }
            if (BeanUtils.isNotEmpty((Object)counterList) || BeanUtils.isNotEmpty((Object)otherList)) {
                String replace = sql.replace("\r\n", " ").replace("\r", " ").replace("\n", " ");
                int i = replace.toLowerCase().indexOf(String.format(" from %s ", boEnt.getTableName().toLowerCase()));
                String summaryotherSql = this.buildSummarySql(otherList, boEnt.getTableName(), template.getDisplayField()) + replace.substring(i);
                this.databaseContext.switchDS(dsName, dResult -> {
                    try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                        Map queryMap;
                        HashMap queryResult = Maps.newHashMap();
                        QueryFilter build = QueryFilter.build();
                        BeanUtils.copyNotNullProperties((Object)build, (Object)queryFilter);
                        build.setSorter((List)Lists.newArrayList());
                        if (StringUtil.isNotEmpty((String)filterSql)) {
                            build.addParams(filterSql, null);
                        }
                        build.withParam("filterSql", (Object)filterSql);
                        Map<String, String> column = this.getColumn(JsonUtil.toJsonNode((String)template.getDisplayField()), Maps.newHashMap());
                        for (JsonNode item : counterList) {
                            Object queryField;
                            String oldField;
                            String tableName = JsonUtil.getStringIgnoreKey((JsonNode)item, (String)"tableName", (String)"");
                            if (tableName.equalsIgnoreCase(boEnt.getTableName())) {
                                tableName = "t";
                            }
                            if (StringUtil.isEmpty((String)(oldField = column.get(JsonUtil.getStringIgnoreKey((JsonNode)item, (String)"tableName", (String)"") + "." + JsonUtil.getStringIgnoreKey((JsonNode)item, (String)"field", (String)""))))) continue;
                            QueryFilter buildCounter = QueryFilter.build();
                            BeanUtils.copyNotNullProperties((Object)buildCounter, (Object)queryFilter);
                            ArrayList<Object> querys = new ArrayList<Object>();
                            if ("oracle".equals(dResult.getDbType()) || "kingbasees".equals(dResult.getDbType()) || "dm".equals(dResult.getDbType())) {
                                queryField = new QueryField();
                                queryField.setProperty("length(" + tableName + "." + oldField + ")");
                                queryField.setValue((Object)0);
                                queryField.setOperation(QueryOP.GREAT);
                                querys.add(queryField);
                            } else {
                                queryField = new QueryField();
                                queryField.setProperty(tableName + "." + oldField);
                                queryField.setValue((Object)"");
                                queryField.setOperation(QueryOP.NOT_EQUAL);
                                querys.add(queryField);
                            }
                            for (Object query : queryFilter.getQuerys()) {
                                querys.add(query);
                            }
                            buildCounter.setQuerys(querys);
                            String summaryCounterSql = this.buildSummarySql(ListUtil.of((Object[])new JsonNode[]{item}), boEnt.getTableName(), template.getDisplayField()) + replace.substring(i);
                            try {
                                Map queryMap2 = (Map)this.commonManager.queryByCustomSqlNoPage(summaryCounterSql, buildCounter).get(0);
                                if (!BeanUtils.isNotEmpty((Object)queryMap2)) continue;
                                queryResult.putAll(queryMap2);
                            }
                            catch (Exception e) {
                                Map queryMap3 = (Map)this.commonManager.queryByCustomSqlNoPage(summaryCounterSql, build).get(0);
                                if (!BeanUtils.isNotEmpty((Object)queryMap3)) continue;
                                queryResult.putAll(queryMap3);
                            }
                        }
                        if (BeanUtils.isNotEmpty((Object)otherList) && BeanUtils.isNotEmpty((Object)(queryMap = (Map)this.commonManager.queryByCustomSqlNoPage(summaryotherSql, build).get(0)))) {
                            queryResult.putAll(queryMap);
                        }
                        ArrayList summary = Lists.newArrayList();
                        summaryFieldNode.forEach(node -> {
                            if (node.get("whetherSummarize") == null || !node.get("whetherSummarize").asBoolean()) {
                                return;
                            }
                            HashMap summaryResult = Maps.newHashMap();
                            String field = JsonUtil.getStringIgnoreKey((JsonNode)node, (String)"field", (String)"");
                            String method = JsonUtil.getStringIgnoreKey((JsonNode)node, (String)"method", (String)"");
                            summaryResult.put("field", field);
                            summaryResult.put("method", method);
                            summaryResult.put("val", "-");
                            if (queryResult != null) {
                                Object value = MapUtil.getIgnoreCase((Map)queryResult, (String)(method + "_" + field), (Object)0);
                                if (value == null) {
                                    value = 0;
                                }
                                if (node.get("decimal") != null && BeanUtils.isNotEmpty((Object)value)) {
                                    int decimal = node.get("decimal").asInt(0);
                                    value = new BigDecimal(value.toString()).setScale(decimal, RoundingMode.HALF_UP).toString();
                                }
                                summaryResult.put("val", value);
                            }
                            summary.add(summaryResult);
                        });
                        if (BeanUtils.isNotEmpty((Object)summary)) {
                            returnData.setSummary(summary);
                        }
                        Object var19_21 = null;
                        return var19_21;
                    }
                    catch (Exception e) {
                        throw new BaseException("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01", (Throwable)e);
                    }
                }, e -> {
                    throw new BaseException("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01", (Throwable)e);
                });
            }
        }
    }

    private String mergeField(String displayFieldStr, List<TemplateField> fields) {
        ArrayList<DisplayField> merge = new ArrayList<DisplayField>();
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        try {
            JsonNode displayFieldNode = JsonUtil.toJsonNode((String)displayFieldStr);
            if (BeanUtils.isNotEmpty((Object)displayFieldNode) && displayFieldNode instanceof ArrayNode) {
                for (JsonNode node : displayFieldNode) {
                    DisplayField displayField = (DisplayField)JsonUtil.toBean((JsonNode)node, DisplayField.class);
                    this.handleDisplayField(merge, map, displayField, false);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
        try {
            if (!CollectionUtils.isEmpty(fields)) {
                for (TemplateField templateField : fields) {
                    DisplayField displayField = new DisplayField();
                    BeanUtil.copyProperties((Object)templateField, (Object)displayField, (String[])new String[0]);
                    this.handleDisplayField(merge, map, displayField, true);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        return JsonUtil.toJsonString(merge);
    }

    private void handleDisplayField(List<DisplayField> merge, Map<String, Set<String>> map, DisplayField displayField, Boolean isResetDisplayField) throws IOException {
        Set<String> set;
        if (isResetDisplayField.booleanValue()) {
            String displayFieldName = String.format("%s%s", displayField.getTableName(), displayField.getOldTableField());
            displayFieldName = FormUtil.replaceUnderline(displayFieldName.toLowerCase());
            displayField.setName(displayFieldName);
        }
        if (BeanUtils.isNotEmpty((Object)displayField.getChildren())) {
            ArrayNode children = (ArrayNode)displayField.getChildren();
            for (JsonNode child : children) {
                this.handleDisplayField(merge, map, (DisplayField)JsonUtil.toBean((JsonNode)child, DisplayField.class), isResetDisplayField);
            }
        } else if (map.containsKey(displayField.getTableName())) {
            set = map.get(displayField.getTableName());
            if (!set.contains(displayField.getOldTableField())) {
                set.add(displayField.getOldTableField());
                merge.add(displayField);
            }
        } else {
            if (StringUtil.isNotEmpty((String)displayField.getTableName())) {
                set = new HashSet<String>();
                map.put(displayField.getTableName(), set);
                ((HashSet)set).add(displayField.getOldTableField());
            }
            merge.add(displayField);
        }
    }

    private void formatListData(List<Map<String, Object>> data, String displayFieldStr) {
        try {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)displayFieldStr);
            HashMap displayFieldMap = Maps.newHashMap();
            HashMap tableFormat = Maps.newHashMap();
            for (JsonNode node : jsonNode) {
                String tableName;
                DisplayField displayField = (DisplayField)JsonUtil.toBean((JsonNode)node, DisplayField.class);
                ArrayNode children = null;
                if (displayField.getChildren() instanceof ArrayNode) {
                    children = (ArrayNode)displayField.getChildren();
                }
                if (children != null && children.size() > 0) {
                    children.forEach(item -> {
                        try {
                            DisplayField displayFieldTemp = (DisplayField)JsonUtil.toBean((JsonNode)item, DisplayField.class);
                            displayFieldMap.put(displayFieldTemp.getName(), displayFieldTemp);
                        }
                        catch (Exception e) {
                            this.logger.error("\u5b50\u8868\u5934\u6570\u636e\u7ed3\u6784\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                        }
                    });
                } else {
                    displayFieldMap.put(displayField.getName(), displayField);
                }
                if (tableFormat.containsKey(tableName = displayField.getTableName())) continue;
                HashMap cloumnFormat = Maps.newHashMap();
                List boEntByTableName = this.boEntManager.getByTableName(tableName);
                if (BeanUtils.isNotEmpty((Object)boEntByTableName)) {
                    List boAttributeList = this.boAttributeManager.getByBoEnt((BoEnt)boEntByTableName.get(0));
                    boAttributeList.forEach(item -> {
                        if ("date".equals(item.getDataType())) {
                            cloumnFormat.put(item.getFieldName(), item.getFormat());
                        }
                    });
                }
                tableFormat.put(tableName, cloumnFormat);
            }
            this.handleFormatSloop(displayFieldMap, tableFormat, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleFormatSloop(Map<String, DisplayField> displayFieldMap, Map<String, Map<String, String>> tableFormat, List<Map<String, Object>> data) {
        if (CollUtil.isEmpty(data)) {
            return;
        }
        data.forEach(item -> {
            for (Map.Entry entry : item.entrySet()) {
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                if (BeanUtils.isEmpty(v)) continue;
                if ("children".equals(k)) {
                    List listChildren = (List)v;
                    if (!CollUtil.isNotEmpty((Collection)listChildren)) continue;
                    this.handleFormatSloop(displayFieldMap, tableFormat, listChildren);
                    entry.setValue(listChildren);
                    continue;
                }
                entry.setValue(this.formatDisplayFieldValue(displayFieldMap, tableFormat, k, v));
            }
        });
    }

    private Object formatDisplayFieldValue(Map<String, DisplayField> displayFieldMap, Map<String, Map<String, String>> tableFormat, String k, Object v) {
        Object result;
        if (BeanUtils.isEmpty((Object)v) || !displayFieldMap.containsKey(k)) {
            return v;
        }
        DisplayField displayField = displayFieldMap.get(k);
        if (!tableFormat.containsKey(displayField.getTableName())) {
            return v;
        }
        Map<String, String> map = tableFormat.get(displayField.getTableName());
        if (!map.containsKey(displayField.getOldTableField())) {
            return v;
        }
        String format = map.get(displayField.getOldTableField());
        if (v instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)v;
            result = localDateTime.format(DateTimeFormatter.ofPattern(format));
        } else {
            try {
                result = new SimpleDateFormat(format).format(v);
            }
            catch (Exception ignore) {
                result = v;
            }
        }
        return result;
    }

    private void handleSubDate(QueryFilter queryFilter, String tableJsons, String dsName) {
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && StringUtil.isNotEmpty((String)tableJsons) && !"[]".equals(tableJsons)) {
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode((String)tableJsons);
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> oracleClobSet = new HashSet<String>();
                for (JsonNode node : jsonNode) {
                    String tableName = node.get("join").asText("");
                    if (StringUtil.isEmpty((String)tableName)) continue;
                    CustomQueryControllerVo vo = new CustomQueryControllerVo();
                    vo.setIsTable("1");
                    if (StringUtil.isEmpty((String)dsName)) {
                        dsName = "LOCAL";
                    }
                    vo.setDsalias(dsName);
                    vo.setObjName(tableName);
                    ObjectNode table = this.customQueryManager.getTable(vo, Optional.empty());
                    JsonNode nodes = table.get("table").get("columnList");
                    for (JsonNode column : nodes) {
                        if ("date".equalsIgnoreCase(column.get("columnType").asText())) {
                            hashSet.add(column.get("fieldName").asText("").toLowerCase());
                        }
                        if (!"clob".equalsIgnoreCase(JsonUtil.getString((JsonNode)column, (String)"columnType"))) continue;
                        oracleClobSet.add(JsonUtil.getString((JsonNode)column, (String)"tableName").toLowerCase() + "." + JsonUtil.getString((JsonNode)column, (String)"fieldName"));
                    }
                    for (QueryField query : querys) {
                        if (hashSet.contains(query.getProperty().toLowerCase())) {
                            this.setQueryTimeProperty(query, "yyyy-MM-dd");
                        }
                        if (!oracleClobSet.contains(query.getProperty().toLowerCase())) continue;
                        query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void setQueryTimeProperty(QueryField query, String format) throws Exception {
        if (QueryOP.BETWEEN.equals((Object)query.getOperation())) {
            List<Object> value = new ArrayList();
            if (query.getValue() instanceof ArrayList) {
                value = (List)query.getValue();
            }
            if (query.getValue() instanceof String && query.getValue().toString().contains(",")) {
                value = Arrays.asList(query.getValue().toString().split(","));
            }
            if (BeanUtils.isNotEmpty(value)) {
                ArrayList<Date> newVal = new ArrayList<Date>();
                for (String s : value) {
                    if (StringUtil.isNotEmpty((String)s)) {
                        if ("yyyy-MM-dd HH:mm:ss".equals(format) && com.hotent.base.util.time.DateUtil.isRqFormat((String)s)) {
                            s = s + " 00:00:00";
                        }
                        newVal.add(DateFormatUtil.parseDate((String)s, (String)format));
                        continue;
                    }
                    newVal.add(null);
                }
                query.setValue(newVal);
                return;
            }
        }
        if (query.getValue() instanceof String) {
            if (!com.hotent.base.util.time.DateUtil.isRqFormat((String)query.getValue().toString()) && !com.hotent.base.util.time.DateUtil.isRqSjFormat((String)query.getValue().toString())) {
                query.setProperty("1");
                query.setOperation(QueryOP.EQUAL);
                query.setValue((Object)"-1");
            } else {
                query.setValue((Object)DateFormatUtil.parseDate((String)((String)query.getValue()), (String)format));
            }
        }
    }

    private String buildSql(String mergeField, String mainTable, String mainPkKey, String joinTables, String dbType, String dsName, Map<String, Object> formatMap) throws Exception {
        StringBuilder sql = new StringBuilder("select ");
        StringBuilder formatSql = new StringBuilder();
        StringBuilder displayFieldSql = new StringBuilder();
        boolean isOldVersion = false;
        isOldVersion = this.getCustomColumn(JsonUtil.toJsonNode((String)mergeField), isOldVersion, mainTable, new HashMap<String, String>(), formatSql, displayFieldSql, formatMap);
        if (isOldVersion) {
            sql.append("t.*").append((CharSequence)displayFieldSql);
        } else {
            if (StringUtil.isNotEmpty((String)formatSql.toString())) {
                sql.append("t.").append(mainPkKey).append(" as ").append(mainPkKey.toLowerCase());
            }
            sql.append((CharSequence)formatSql).append((CharSequence)displayFieldSql);
        }
        StringBuffer joinStatement = new StringBuffer();
        if (BeanUtils.isNotEmpty((Object)joinTables)) {
            JsonNode joinTable = JsonUtil.toJsonNode((String)joinTables);
            joinTable.forEach(item -> {
                String join = JsonUtil.getString((JsonNode)item, (String)"join");
                joinStatement.append(" left join ").append(join).append(" ");
            });
            sql.append(" from ").append(mainTable).append(" t ");
            sql.append(joinStatement);
            return this.handleOnQueryStatement((ArrayNode)joinTable, sql.toString(), dbType, mainTable);
        }
        sql.append(" from ").append(mainTable).append(" t ");
        sql.append(joinStatement);
        return sql.toString();
    }

    private String buildSummarySql(List<JsonNode> summaryFieldNodes, String mainTable, String displayField) throws IOException {
        StringBuilder sqlBuider = new StringBuilder("select ");
        HashSet selectColumnSet = Sets.newHashSet();
        JsonNode displayFieldNode = JsonUtil.toJsonNode((String)displayField);
        Map<String, String> column = this.getColumn(displayFieldNode, Maps.newHashMap());
        for (JsonNode summaryFieldNode : summaryFieldNodes) {
            if (summaryFieldNode.get("whetherSummarize") == null || !summaryFieldNode.get("whetherSummarize").asBoolean()) continue;
            String tableAliasName = JsonUtil.getStringIgnoreKey((JsonNode)summaryFieldNode, (String)"tableName", (String)"");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)tableAliasName), (String)"\u6c47\u603b\u5b57\u6bb5\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            if (mainTable.equalsIgnoreCase(tableAliasName)) {
                tableAliasName = "t";
            }
            String field = JsonUtil.getStringIgnoreKey((JsonNode)summaryFieldNode, (String)"field", (String)"");
            String method = JsonUtil.getStringIgnoreKey((JsonNode)summaryFieldNode, (String)"method", (String)"");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)field), (String)"\u6c47\u603b\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)method), (String)"\u6c47\u603b\u5b57\u6bb5\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
            String tableField = column.get(JsonUtil.getStringIgnoreKey((JsonNode)summaryFieldNode, (String)"tableName", (String)"") + "." + field);
            if (StringUtil.isEmpty((String)tableField)) continue;
            selectColumnSet.add(method + "(" + tableAliasName + "." + column.get(JsonUtil.getStringIgnoreKey((JsonNode)summaryFieldNode, (String)"tableName", (String)"") + "." + field) + ") as " + method + "_" + field + ",");
        }
        selectColumnSet.forEach(item -> sqlBuider.append(item));
        sqlBuider.deleteCharAt(sqlBuider.length() - 1);
        return sqlBuider.toString();
    }

    private Map<String, String> getColumn(JsonNode displayFieldNode, HashMap<String, String> column) {
        for (JsonNode jsonNode : displayFieldNode) {
            JsonNode children = jsonNode.get("children");
            if (BeanUtils.isNotEmpty((Object)children) && children.isArray()) {
                this.getColumn(children, column);
                continue;
            }
            if (!BeanUtils.isNotEmpty((Object)jsonNode.get("tableName"))) continue;
            column.put(jsonNode.get("tableName").asText() + "." + jsonNode.get("name").asText(), jsonNode.get("oldTableField").asText());
        }
        return column;
    }

    private boolean getCustomColumn(JsonNode jsonNode, boolean isOldVersion, String mainTable, Map<String, String> isExistsMap, StringBuilder formatSql, StringBuilder displayFieldSql, Map<String, Object> formatMap) throws Exception {
        for (JsonNode node : jsonNode) {
            DisplayField displayField = (DisplayField)JsonUtil.toBean((JsonNode)node, DisplayField.class);
            if (StringUtil.isNotEmpty((String)displayField.getFormat())) {
                formatMap.put(displayField.getName(), displayField.getFormat());
            }
            if (StringUtil.isNotEmpty((String)displayField.getOldTableField())) {
                if (!isExistsMap.containsKey(displayField.getName())) {
                    isExistsMap.put(displayField.getName(), displayField.getName());
                    if (displayField.getTableName().equalsIgnoreCase(mainTable)) {
                        formatSql.append(",").append(String.format("t.%s as %s", displayField.getOldTableField(), displayField.getName()));
                    } else {
                        formatSql.append(",").append(String.format("%s.%s as %s", displayField.getTableName(), displayField.getOldTableField(), displayField.getName()));
                    }
                }
            } else {
                if (displayField.getName().startsWith("customquery")) continue;
                if (!BooleanUtil.isTrue((Boolean)displayField.getCustomColumn()) && !BooleanUtil.isTrue((Boolean)displayField.getShowFlowField())) {
                    isOldVersion = true;
                }
            }
            if (displayField.getCustomColumn() != null && displayField.getCustomColumn().booleanValue()) {
                if (StringUtil.isEmpty((String)displayField.getSql())) {
                    throw new BaseException(String.format("\u865a\u62df\u5b57\u6bb5[%s]\u672a\u914d\u7f6eSQL\uff0c\u8bf7\u5148\u914d\u7f6e\u5b8c\u6574", displayField.getDesc()));
                }
                displayFieldSql.append(displayField.getSql());
            }
            if (!BeanUtils.isNotEmpty((Object)displayField.getChildren())) continue;
            this.getCustomColumn(displayField.getChildren(), isOldVersion, mainTable, isExistsMap, formatSql, displayFieldSql, formatMap);
        }
        return isOldVersion;
    }

    private String handleOnQueryStatement(ArrayNode condition, String sql, String dbType, String mainTable) {
        HashMap<String, ObjectNode> conditionMap = new HashMap<String, ObjectNode>();
        for (JsonNode node : condition) {
            String tableName = JsonUtil.getString((JsonNode)node, (String)"join");
            conditionMap.put(tableName, (ObjectNode)node);
        }
        SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)SQLUtils.parseSingleStatement((String)sql, (String)dbType, (SQLParserFeature[])new SQLParserFeature[0]);
        SQLSelect select = sqlSelectStatement.getSelect();
        SQLSelectQueryBlock queryBlock = select.getQueryBlock();
        SQLTableSource from = queryBlock.getFrom();
        if (!(from instanceof SQLJoinTableSource)) {
            return sql;
        }
        this.handleTableSource(conditionMap, (SQLJoinTableSource)from, dbType, mainTable);
        return sqlSelectStatement.toString();
    }

    private void handleTableSource(Map<String, ObjectNode> conditionMap, SQLJoinTableSource tableSource, String dbType, String mainTable) {
        SQLTableSource left;
        SQLExprTableSource rightTable;
        String tableName;
        ObjectNode condition;
        SQLTableSource right = tableSource.getRight();
        if (right instanceof SQLExprTableSource && BeanUtils.isNotEmpty((Object)(condition = (ObjectNode)MapUtil.getIgnoreCase(conditionMap, (String)(tableName = (rightTable = (SQLExprTableSource)right).getTableName()))))) {
            this.setOpExpr(tableSource, condition, dbType, mainTable);
        }
        if ((left = tableSource.getLeft()) instanceof SQLJoinTableSource) {
            this.handleTableSource(conditionMap, (SQLJoinTableSource)left, dbType, mainTable);
        }
    }

    private void setOpExpr(SQLJoinTableSource tableSource, ObjectNode node, String dbType, String mainTable) {
        String tableName = JsonUtil.getString((JsonNode)node, (String)"join");
        String junction = JsonUtil.getString((JsonNode)node, (String)"junction");
        ArrayNode arrayNode = (ArrayNode)node.get("condition");
        tableSource.setCondition(this.getMergeExpr(arrayNode, junction, dbType, tableName, mainTable));
    }

    private SQLExpr getMergeExpr(ArrayNode condition, String junction, String dbType, String tableName, String mainTable) {
        SQLExpr expr = null;
        boolean isAnd = "and".equals(junction);
        for (JsonNode node : condition) {
            SQLExpr subExpr;
            ObjectNode objNode = (ObjectNode)node;
            if (this.isCondition(objNode)) {
                subExpr = this.getMergeExpr((ArrayNode)node.get("condition"), JsonUtil.getString((JsonNode)node, (String)"junction"), dbType, tableName, mainTable);
            } else {
                String mainCondition = JsonUtil.getString((JsonNode)node, (String)"main");
                String[] conditionTableName = mainCondition.split("\\.");
                if (BeanUtils.isNotEmpty((Object)conditionTableName) && conditionTableName[0].equalsIgnoreCase(mainTable)) {
                    mainCondition = mainCondition.toLowerCase().replaceFirst(mainTable.toLowerCase(), "t");
                }
                String exprStr = String.format("%s = %s.%s ", mainCondition, tableName, JsonUtil.getString((JsonNode)node, (String)"ref"));
                subExpr = SQLUtils.toSQLExpr((String)exprStr, (DbType)DbType.of((String)dbType));
            }
            if (expr == null) {
                expr = subExpr;
                continue;
            }
            if (isAnd) {
                expr = SQLBinaryOpExpr.and((SQLExpr)expr, (SQLExpr)subExpr);
                continue;
            }
            expr = SQLBinaryOpExpr.or((SQLExpr)expr, (SQLExpr)subExpr);
        }
        return expr;
    }

    private boolean isCondition(ObjectNode objectNode) {
        return objectNode.has("junction") && objectNode.has("condition");
    }

    public void buildJoinSql(StringBuffer showSql, String tableName, String joinTables) throws IOException {
        if (BeanUtils.isNotEmpty((Object)joinTables)) {
            JsonNode joinTable = JsonUtil.toJsonNode((String)joinTables);
            joinTable.forEach(item -> {
                String join = JsonUtil.getString((JsonNode)item, (String)"join");
                JsonNode jsonNode = item.get("on");
                ArrayList onSql = new ArrayList();
                jsonNode.forEach(on -> {
                    String stat = "t." + JsonUtil.getString((JsonNode)on, (String)"main") + "=" + join + "." + JsonUtil.getString((JsonNode)on, (String)"ref");
                    onSql.add(stat);
                });
                showSql.append(" left join " + join + " on " + String.join((CharSequence)" and ", onSql));
            });
        }
    }

    @Override
    public PageList<Map<String, Object>> getSubDataPagination(QueryFilter queryFilter, String alias, String refId) throws Exception {
        if (StringUtil.isNotEmpty((String)refId) && StringUtil.isNotEmpty((String)alias)) {
            return this.getSubList(queryFilter, alias, refId);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getSubData(String alias, String refId) throws Exception {
        if (StringUtil.isNotEmpty((String)refId) && StringUtil.isNotEmpty((String)alias)) {
            return this.getSubList(alias, refId);
        }
        return null;
    }

    @Override
    public void exportSub(HttpServletResponse response, ExportSubVo exportVo) throws Exception {
        String getType = StringUtil.isEmpty((String)exportVo.getType()) ? "getType" : exportVo.getType();
        PageBean page = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        if ("page".equals(getType)) {
            page.setPageSize(10);
        }
        QueryFilter queryFilter = exportVo.getQueryFilter();
        queryFilter.setPageBean(page);
        PageList<Map<String, Object>> pageList = this.getSubList(queryFilter, exportVo.getAlias(), exportVo.getRefId());
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        for (JsonNode str : JsonUtil.toJsonNode((String)exportVo.getExpField())) {
            exportMaps.put(str.get("key").asText(), str.get("value").asText());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)exportVo.getAlias(), (int)24, exportMaps, (List)pageList.getRows());
        ExcelUtil.downloadExcel((Workbook)book, (String)exportVo.getAlias(), (HttpServletResponse)response);
    }

    private StringBuilder preSql(BoEnt boEnt, Map<String, String> row, Boolean isExternal) {
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(boEnt.getTableName());
        if (isExternal.booleanValue()) {
            sql.append(" (id_,ref_id_");
        } else {
            sql.append(" (").append(boEnt.getPkKey()).append(",").append(boEnt.getFk());
        }
        List columnList = boEnt.getColumnList();
        if (columnList != null && row.size() > 0) {
            row.forEach((k, v) -> {
                AtomicBoolean match = new AtomicBoolean(false);
                columnList.forEach(i -> {
                    if (k.equals(i.getDesc())) {
                        sql.append(",").append(i.getFieldName());
                        match.set(true);
                    }
                });
                if (!match.get()) {
                    throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u6863\u5185\u5bb9\u548c\u5b50\u8868\u5b57\u6bb5\u4e0d\u5339\u914d");
                }
            });
        }
        if (isExternal.booleanValue()) {
            sql.append(",F_form_data_rev_");
        }
        sql.append(") values (");
        return sql;
    }

    private void addFieldList(List<TemplateField> fields) {
        String[] fileArr = new String[]{"\u6d41\u7a0b\u7f16\u53f7", "\u6807\u9898", "\u6d41\u7a0b\u540d\u79f0", "\u5b9e\u4f8b\u72b6\u6001", "\u521b\u5efa\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4", "\u662f\u5426\u6302\u8d77", "\u53d1\u8d77\u4eba", "\u662f\u5426\u5220\u9664"};
        String[] nameArr = new String[]{"bpm_proc_inst_id_", "bpm_subject_", "bpm_proc_def_name_", "bpm_status_", "bpm_create_time_", "bpm_end_time_", "bpm_is_forbidden_", "bpm_creator_", "bpm_is_dele_"};
        String[] typeArr = new String[]{"varchar", "varchar", "varchar", "varchar", "date", "date", "varchar", "varchar", "varchar"};
        for (int i = 0; i < fileArr.length; ++i) {
            TemplateField field = new TemplateField();
            field.setFlowField(true);
            field.setName(nameArr[i]);
            field.setOriginName(nameArr[i]);
            field.setDesc(fileArr[i]);
            field.setType(typeArr[i]);
            field.setShowFlowField(true);
            fields.add(field);
        }
    }

    @Override
    public void batchDelCacheByIds(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            FormDataTemplateManager formDataTemplateManager = (FormDataTemplateManager)AppUtil.getBean(FormDataTemplateManager.class);
            for (String id : ids.split(",")) {
                formDataTemplateManager.delFormDataTemplateFromCacheById(id);
            }
        }
    }

    public FormDataTemplate getById(Serializable id) {
        FormDataTemplateManager templateManager = (FormDataTemplateManager)AppUtil.getBean(FormDataTemplateManager.class);
        return templateManager.getFormDataTemplateCacheById(id);
    }

    @Override
    @Cacheable(value={"eip:form:formDataTemplate"}, key="#id")
    public FormDataTemplate getFormDataTemplateCacheById(Serializable id) {
        return (FormDataTemplate)((Object)((FormDataTemplateDao)this.baseMapper).selectById(id));
    }

    @Override
    @CacheEvict(value={"eip:form:formDataTemplate"}, key="#id")
    public void delFormDataTemplateFromCacheById(String id) {
    }

    @Override
    public FormDataTemplate getByAlias(String alias) {
        return ((FormDataTemplateDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    public void removeByFormKey(String formKey) {
        ((FormDataTemplateDao)this.baseMapper).removeByFormKey(formKey);
    }

    private Map<String, Object> convertDbToData(BoEnt boEnt, Map<String, Object> map, Map<String, DisplayField> displayFieldMap, Map<String, Object> formatMap) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> ent : map.entrySet()) {
            Object val;
            String field = ent.getKey().toLowerCase();
            BoAttribute attribute = boEnt.getBoAttributeByField(field);
            if (BeanUtils.isNotEmpty((Object)attribute)) {
                val = this.handValue(attribute, ent.getValue(), "");
                if (boEnt.isExternal()) {
                    rtnMap.put(attribute.getName(), val);
                    continue;
                }
                rtnMap.put(attribute.getFieldPrefix() + attribute.getName(), val);
                continue;
            }
            if (displayFieldMap.containsKey(ent.getKey().toLowerCase())) {
                DisplayField displayField = displayFieldMap.get(ent.getKey().toLowerCase());
                Object val2 = this.handValue(null, ent.getValue(), MapUtil.getStringIgnoreKey(formatMap, (String)ent.getKey(), (String)""));
                rtnMap.put(displayField.getName(), val2);
                continue;
            }
            val = this.handValue(null, ent.getValue(), MapUtil.getStringIgnoreKey(formatMap, (String)ent.getKey(), (String)""));
            rtnMap.put(ent.getKey(), val);
        }
        if (rtnMap.get("children") instanceof List) {
            ArrayList mapList = (ArrayList)rtnMap.get("children");
            for (int i = 0; i < mapList.size(); ++i) {
                Map item = (Map)mapList.get(i);
                mapList.set(i, this.convertDbToData(boEnt, item, displayFieldMap, formatMap));
            }
            rtnMap.put("children", mapList);
        }
        return rtnMap;
    }

    private Object handValue(BoAttribute attr, Object val, String format) {
        if (BeanUtils.isEmpty((Object)val)) {
            return val;
        }
        if (StringUtil.isEmpty((String)format)) {
            format = "yyyy-MM-dd";
        }
        if (BeanUtils.isNotEmpty((Object)attr)) {
            format = attr.getFormat();
        }
        if (val instanceof Date) {
            return TimeUtil.getDateTimeString((LocalDateTime)DateFormatUtil.parse((Date)((Date)val)), (String)format);
        }
        if (val instanceof Timestamp) {
            Timestamp times = (Timestamp)val;
            return TimeUtil.getDateTimeString((LocalDateTime)times.toLocalDateTime(), (String)format);
        }
        return val;
    }

    private QueryFilter<?> getTemplateQueryFilter(QueryFilter<?> queryFilter, FormDataTemplate bpmDataTemplate) throws Exception {
        if (BeanUtils.isEmpty((Object)((Object)bpmDataTemplate))) {
            return queryFilter;
        }
        PageBean page = queryFilter.getPageBean();
        if (2 == bpmDataTemplate.getNeedPage()) {
            page.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        } else {
            page.setPageSize(queryFilter.getPageBean().getPageSize().intValue());
        }
        queryFilter.setPageBean(page);
        String displayFieldJson = bpmDataTemplate.getDisplayField();
        List displayFields = (List)JsonUtil.toBean((String)displayFieldJson, (TypeReference)new TypeReference<List<DisplayField>>(){});
        queryFilter.getQuerys().forEach(query -> displayFields.forEach(displayField -> {
            if (displayField.getIsEncode() == 1 && ("t." + displayField.getOldTableField()).equalsIgnoreCase(query.getProperty())) {
                query.setProperty(String.format("CAST(AES_DECRYPT(UNHEX(%s) ,'%s') as char)", query.getProperty(), "@$ATPW*%"));
            }
        }));
        return queryFilter;
    }

    private PageList<?> query(String sql, QueryFilter queryFilter, String filterSql) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull((Object)queryFilter, (String)"queryFilter can not be empty.");
        if (StringUtil.isNotEmpty((String)filterSql)) {
            queryFilter.addParams(filterSql, null);
        }
        queryFilter.withParam("filterSql", (Object)filterSql);
        return this.commonManager.queryByCustomSql(sql, queryFilter);
    }

    private List<?> list(String sql, QueryFilter queryFilter, String filterSql) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull((Object)queryFilter, (String)"queryFilter can not be empty.");
        if (StringUtil.isNotEmpty((String)filterSql)) {
            queryFilter.addParams(filterSql, null);
        }
        queryFilter.withParam("filterSql", (Object)filterSql);
        return this.commonManager.queryByCustomSqlNoPage(sql, queryFilter);
    }

    private PageList<Map<String, Object>> getSubList(QueryFilter queryFilter, String alias, String refId) throws Exception {
        PageList pageList;
        BoEnt boEnt = this.boEntManager.getByName(alias);
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        String showSql = "select * from " + boEnt.getTableName();
        if (StringUtil.isNotEmpty((String)refId)) {
            queryFilter.addFilter(boEnt.getFk(), (Object)refId, QueryOP.EQUAL);
        }
        try {
            pageList = (PageList)this.databaseContext.switchDS(dsName, dResult -> {
                block5: {
                    block4: {
                        if (!"postgresql".equals(dResult.getDbType())) break block4;
                        List queryFields = queryFilter.getQuerys();
                        List boAttrList = boEnt.getBoAttrList();
                        block0: for (QueryField queryField : queryFields) {
                            for (BoAttribute boAttribute : boAttrList) {
                                if (!boAttribute.getFieldName().toUpperCase().equals(queryField.getProperty().toUpperCase())) continue;
                                if (!"number".equals(boAttribute.getDataType()) && !"date".equals(boAttribute.getDataType())) continue block0;
                                queryField.setProperty(queryField.getProperty() + "||''");
                            }
                        }
                        break block5;
                    }
                    if (!"oracle".equals(dResult.getDbType())) break block5;
                    List queryFields = queryFilter.getQuerys();
                    List boAttrList = boEnt.getBoAttrList();
                    block2: for (QueryField queryField : queryFields) {
                        for (BoAttribute boAttribute : boAttrList) {
                            if (!boAttribute.getFieldName().toUpperCase().equals(queryField.getProperty().toUpperCase())) continue;
                            if (!"date".equals(boAttribute.getDataType())) continue block2;
                            queryField.setProperty(" TO_CHAR(" + queryField.getProperty() + ",'yyyy-MM-dd') ");
                        }
                    }
                }
                return this.query(showSql, queryFilter, "");
            });
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        List list = pageList.getRows();
        this.convertToDateTime(list, boEnt.getColumnList());
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            HashMap tm = new HashMap();
            for (String k : m.keySet()) {
                try {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                catch (Exception e) {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                list.set(i, tm);
            }
        }
        pageList.setRows(list);
        if (BeanUtils.isNotEmpty((Object)pageList)) {
            return pageList;
        }
        return pageList;
    }

    private void convertToDateTime(List<Map<String, Object>> list, List<BoAttribute> columnList) {
        for (Map<String, Object> map : list) {
            for (BoAttribute column : columnList) {
                String key = "";
                for (String k : map.keySet()) {
                    if (!column.getFieldName().equalsIgnoreCase(k)) continue;
                    key = k;
                }
                String format = column.getFormat();
                Object dateValue = map.get(key);
                if ("date".equals(column.getDataType())) {
                    LocalDateTime dateTime;
                    ZoneId defaultZoneId;
                    Comparable<Date> res;
                    Timestamp times;
                    if (!BeanUtils.isNotEmpty((Object)map.get(key))) continue;
                    if ("yyyy-MM-dd".equals(format)) {
                        if (dateValue instanceof Timestamp) {
                            times = (Timestamp)dateValue;
                            map.put(key, times.toLocalDateTime().toLocalDate());
                            continue;
                        }
                        if (dateValue instanceof Date) {
                            res = (Date)dateValue;
                            defaultZoneId = ZoneId.systemDefault();
                            dateTime = LocalDateTime.ofInstant(((Date)res).toInstant(), defaultZoneId);
                            map.put(key, dateTime.toLocalDate());
                            continue;
                        }
                        if (!(dateValue instanceof LocalDateTime)) continue;
                        res = (LocalDateTime)dateValue;
                        map.put(key, ((LocalDateTime)res).toLocalDate());
                        continue;
                    }
                    if (dateValue instanceof Timestamp) {
                        times = (Timestamp)dateValue;
                        map.put(key, times.toLocalDateTime());
                        continue;
                    }
                    if (dateValue instanceof Date) {
                        res = (Date)dateValue;
                        defaultZoneId = ZoneId.systemDefault();
                        dateTime = LocalDateTime.ofInstant(((Date)res).toInstant(), defaultZoneId);
                        map.put(key, dateTime);
                        continue;
                    }
                    res = (LocalDateTime)dateValue;
                    map.put(key, res);
                    continue;
                }
                if ("number".equals(column.getDataType())) {
                    if (!(dateValue instanceof String)) continue;
                    map.put(key, Double.valueOf((String)dateValue));
                    continue;
                }
                if (!"int".equals(column.getDataType()) || !(dateValue instanceof String)) continue;
                map.put(key, Integer.valueOf((String)dateValue));
            }
        }
    }

    private List<Map<String, Object>> getSubList(String alias, String refId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        PageList<Map<String, Object>> pageList = this.getSubList(queryFilter, alias, refId);
        return pageList.getRows();
    }

    @Override
    public Map<String, String> exportDef(List<String> list) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        FormDataTemplateXmlList formDataTemplateXmlList = new FormDataTemplateXmlList();
        for (String id : list) {
            ArrayNode buttonJsonAryMobile;
            List<String> listUserKeyMobile;
            ArrayNode buttonJsonAry;
            List<String> listUserKey;
            FormDataTemplateXml formDataTemplateXml = this.getByTemplateId(id);
            FormDataTemplate formDataTemplate = formDataTemplateXml.getFormDataTemplate();
            if (formDataTemplate != null && StringUtil.isNotEmpty((String)formDataTemplate.getManageField()) && CollUtil.isNotEmpty(listUserKey = this.getUserKey4Right(buttonJsonAry = (ArrayNode)JsonUtil.toJsonNode((String)formDataTemplate.getManageField()), "id"))) {
                this.putAccountById4Right(buttonJsonAry, listUserKey);
                formDataTemplate.setManageField(JsonUtil.toJson((Object)buttonJsonAry));
            }
            if (formDataTemplate != null && StringUtil.isNotEmpty((String)formDataTemplate.getMobileManageField()) && CollUtil.isNotEmpty(listUserKeyMobile = this.getUserKey4Right(buttonJsonAryMobile = (ArrayNode)JsonUtil.toJsonNode((String)formDataTemplate.getMobileManageField()), "id"))) {
                this.putAccountById4Right(buttonJsonAryMobile, listUserKeyMobile);
                formDataTemplate.setMobileManageField(JsonUtil.toJson((Object)buttonJsonAryMobile));
            }
            formDataTemplateXml.setFormDataTemplate(formDataTemplate);
            formDataTemplateXmlList.addFormDataTemplateXml(formDataTemplateXml);
        }
        try {
            String xml = JAXBUtil.marshall((Object)formDataTemplateXmlList, FormDataTemplateXmlList.class);
            map.put("formDataTemplates.form.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @CachePut(value={"eip:form:datatemplateImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:form:datatemplateImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:form:datatemplateImportFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public CommonResult<String> importDef(ObjectNode objectNode, String typeId) {
        try {
            String formDataTemplatesXml = objectNode.get("formDataTemplatesXml").asText();
            FormDataTemplateXmlList formDataTemplateXmlList = (FormDataTemplateXmlList)JAXBUtil.unmarshall((String)formDataTemplatesXml, FormDataTemplateXmlList.class);
            List<FormDataTemplateXml> list = formDataTemplateXmlList.getFormDataTemplateXmlList();
            Map<String, Boolean> rightMap = CustomUtil.getRightMapByModel(this.getCurrentModelClass(), ResourceModelType.FORM_TEMPLATE, ResourcesRightType.EDIT);
            ArrayList<String> noRightNames = new ArrayList<String>();
            for (FormDataTemplateXml formDataTemplateXml : list) {
                if (CustomUtil.checkRight(rightMap, formDataTemplateXml.getFormDataTemplate().getAlias())) {
                    this.importDef(formDataTemplateXml, typeId);
                    continue;
                }
                noRightNames.add(formDataTemplateXml.getFormDataTemplate().getName());
            }
            if (BeanUtils.isNotEmpty(noRightNames)) {
                return new CommonResult(String.format("\u5bfc\u5165\u6210\u529f\uff0c\u4ee5\u4e0b\u6570\u636e\u65e0\u6743\u9650\u5bfc\u5165\uff0c\u5df2\u8df3\u8fc7\uff1a[%s]", StringUtil.join(noRightNames)));
            }
            return new CommonResult("\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            throw new RuntimeException("XML\u8f6c\u6362\u4e3aPOJO\u7c7b\u578b\u9519\u8bef" + e.getMessage(), e);
        }
    }

    @Override
    public CommonResult<Map<String, String>> importDef(FormDataTemplateXmlList list, String typeId) throws IOException {
        return this.importDef(list, typeId, true);
    }

    @Override
    public CommonResult<Map<String, String>> importDef(FormDataTemplateXmlList list, String typeId, boolean isCover) throws IOException {
        typeId = Optional.ofNullable(typeId).orElse("7");
        Map<String, Boolean> rightMap = CustomUtil.getRightMapByModel(this.getCurrentModelClass(), ResourceModelType.FORM_TEMPLATE, ResourcesRightType.EDIT);
        ArrayList<String> noRightNames = new ArrayList<String>();
        for (FormDataTemplateXml formDataTemplateXml : list.getFormDataTemplateXmlList()) {
            if (CustomUtil.checkRight(rightMap, formDataTemplateXml.getFormDataTemplate().getAlias())) {
                FormDataTemplate oformDataTemplate = this.getByAlias(formDataTemplateXml.getFormDataTemplate().getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)oformDataTemplate))) {
                    if (!isCover) continue;
                    this.importDef(formDataTemplateXml, typeId);
                    continue;
                }
                this.importDef(formDataTemplateXml, typeId);
                continue;
            }
            noRightNames.add(formDataTemplateXml.getFormDataTemplate().getName());
        }
        if (BeanUtils.isNotEmpty(noRightNames)) {
            return new CommonResult(String.format("\u5bfc\u5165\u6210\u529f\uff0c\u4ee5\u4e0b\u6570\u636e\u65e0\u6743\u9650\u5bfc\u5165\uff0c\u5df2\u8df3\u8fc7\uff1a[%s]", StringUtil.join(noRightNames)));
        }
        List alias = list.getFormDataTemplateXmlList().stream().map(item -> item.getFormDataTemplate().getAlias()).collect(Collectors.toList());
        Map<String, String> dataTemplates = this.list((Wrapper)Wrappers.lambdaQuery().in(FormDataTemplate::getAlias, alias)).stream().collect(Collectors.toMap(FormDataTemplate::getAlias, FormDataTemplate::getId, (k1, k2) -> k1));
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f", dataTemplates);
    }

    private void importDef(FormDataTemplateXml formDataTemplateXml, String typeId) {
        FormDataTemplate formDataTemplate = this.importDefinition(formDataTemplateXml, typeId);
        Map<String, String> idMap = this.getButtonIdMap(formDataTemplateXml.getFormButtonRight());
        this.importFormRight(formDataTemplateXml.getPermission(), formDataTemplate, idMap);
    }

    private void importFormRight(String permission, FormDataTemplate formDataTemplate, Map<String, String> idMap) {
        if (StringUtil.isEmpty((String)permission)) {
            return;
        }
        if (StringUtil.isNotEmpty((String)permission)) {
            ArrayNode arrayNode = null;
            try {
                arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)permission);
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u5165\u6570\u636e\u62a5\u8868\u5f02\u5e38\uff01", (Throwable)e);
            }
            if (arrayNode == null) {
                return;
            }
            for (JsonNode formRight : arrayNode) {
                if (formRight.get("permission") == null || formRight.get("permissionType") == null) continue;
                FormRigthParam formRigthParam = new FormRigthParam();
                formRigthParam.setDataKey(formDataTemplate.getAlias());
                formRigthParam.setFormKey(formDataTemplate.getFormKey());
                formRigthParam.setType(formRight.get("permissionType").asInt(1));
                formRigthParam.setPermission(formRight.get("permission").asText());
                formRigthParam.setButtonId(idMap.get(JsonUtil.getString((JsonNode)formRight, (String)"id")));
                this.bpmFormRightManager.save(formRigthParam);
            }
            FormRigthParam formRigthParam = new FormRigthParam();
            formRigthParam.setDataKey(formDataTemplate.getAlias());
            formRigthParam.setPermission(permission);
            this.bpmFormRightManager.save(formRigthParam);
        }
    }

    private Map<String, String> getButtonIdMap(String formRightButtonStr) {
        HashMap<String, String> buttonIdMap = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)formRightButtonStr)) {
            return buttonIdMap;
        }
        try {
            List formRightButtons = (List)JsonUtil.toBean((String)formRightButtonStr, (TypeReference)new TypeReference<List<FormRightButton>>(){});
            for (FormRightButton button : formRightButtons) {
                buttonIdMap.put(button.getFormRightId(), button.getButtonId());
            }
            return buttonIdMap;
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u8868\u5355\u5217\u8868\u5931\u8d25");
        }
    }

    private List<String> getUserKey4Right(ArrayNode buttonJsonAry, String key) throws Exception {
        ArrayList<String> listUserKey = new ArrayList<String>();
        for (JsonNode nodeButton : buttonJsonAry) {
            JsonNode nodeRight = JsonUtil.toJsonNode((String)JsonUtil.getString((JsonNode)nodeButton, (String)"right", (String)""));
            if (!(nodeRight instanceof ArrayNode)) continue;
            ArrayNode arrayNodeRight = (ArrayNode)nodeRight;
            for (JsonNode nodeOneRight : arrayNodeRight) {
                String type = JsonUtil.getString((JsonNode)nodeOneRight, (String)"type", (String)"");
                String userKey = JsonUtil.getString((JsonNode)nodeOneRight, (String)key, (String)"");
                if (!"user".equals(type) || !StringUtil.isNotEmpty((String)userKey)) continue;
                listUserKey.add(userKey);
            }
        }
        return listUserKey;
    }

    private void updateIdByAccount4Right(ArrayNode buttonJsonAry, List<String> listUserKey) throws Exception {
        ArrayNode users = this.ucFeignService.getUserByAccounts(StringUtil.join(listUserKey));
        for (JsonNode jsonNodeBtn : buttonJsonAry) {
            ObjectNode nodeButton = (ObjectNode)jsonNodeBtn;
            JsonNode nodeRight = JsonUtil.toJsonNode((String)JsonUtil.getString((JsonNode)nodeButton, (String)"right", (String)""));
            ArrayNode arrayNodeRightNew = JsonUtil.createArrayNode();
            if (nodeRight instanceof ArrayNode) {
                ArrayNode arrayNodeRight = (ArrayNode)nodeRight;
                for (JsonNode jsonNode : arrayNodeRight) {
                    ObjectNode nodeOneRight = (ObjectNode)jsonNode;
                    String type = JsonUtil.getString((JsonNode)nodeOneRight, (String)"type", (String)"");
                    String userKey = JsonUtil.getString((JsonNode)nodeOneRight, (String)"account", (String)"");
                    if ("user".equals(type) && StringUtil.isNotEmpty((String)userKey)) {
                        ArrayList accountList = CollUtil.toList((Object[])userKey.split(","));
                        ArrayList<String> idsMatch = new ArrayList<String>();
                        ArrayList<String> accountMatch = new ArrayList<String>();
                        ArrayList<String> nameMatch = new ArrayList<String>();
                        block2: for (String accountFromFile : accountList) {
                            for (JsonNode userNode : users) {
                                String idFromDb = JsonUtil.getString((JsonNode)userNode, (String)"id", (String)"");
                                String account = JsonUtil.getString((JsonNode)userNode, (String)"account", (String)"");
                                String name = JsonUtil.getString((JsonNode)userNode, (String)"fullname", (String)"");
                                if (!StringUtil.isNotEmpty((String)accountFromFile) || !accountFromFile.equals(account)) continue;
                                idsMatch.add(idFromDb);
                                accountMatch.add(account);
                                nameMatch.add(name);
                                continue block2;
                            }
                        }
                        if (!CollUtil.isNotEmpty(idsMatch)) continue;
                        nodeOneRight.put("id", StringUtil.join(idsMatch));
                        nodeOneRight.put("account", StringUtil.join(accountMatch));
                        nodeOneRight.put("name", StringUtil.join(nameMatch));
                        arrayNodeRightNew.add((JsonNode)nodeOneRight);
                        continue;
                    }
                    arrayNodeRightNew.add((JsonNode)nodeOneRight);
                }
            }
            nodeButton.set("right", (JsonNode)new TextNode(JsonUtil.toJsonString((Object)arrayNodeRightNew)));
        }
    }

    private void putAccountById4Right(ArrayNode buttonJsonAry, List<String> listUserKey) throws Exception {
        ArrayNode userByIds = this.ucFeignService.getUserByIds(StringUtil.join(listUserKey));
        for (JsonNode jsonNodeBtn : buttonJsonAry) {
            ObjectNode nodeButton = (ObjectNode)jsonNodeBtn;
            JsonNode nodeRight = JsonUtil.toJsonNode((String)JsonUtil.getString((JsonNode)nodeButton, (String)"right", (String)""));
            ArrayNode arrayNodeRightNew = JsonUtil.createArrayNode();
            if (nodeRight instanceof ArrayNode) {
                ArrayNode arrayNodeRight = (ArrayNode)nodeRight;
                for (JsonNode jsonNode : arrayNodeRight) {
                    ObjectNode nodeOneRight = (ObjectNode)jsonNode;
                    String type = JsonUtil.getString((JsonNode)nodeOneRight, (String)"type", (String)"");
                    String userId = JsonUtil.getString((JsonNode)nodeOneRight, (String)"id", (String)"");
                    if ("user".equals(type) && StringUtil.isNotEmpty((String)userId)) {
                        ArrayList userIdList = CollUtil.toList((Object[])userId.split(","));
                        ArrayList<String> accountMatch = new ArrayList<String>();
                        block2: for (String id : userIdList) {
                            for (JsonNode userNode : userByIds) {
                                String idFromDb = JsonUtil.getString((JsonNode)userNode, (String)"id", (String)"");
                                String account = JsonUtil.getString((JsonNode)userNode, (String)"account", (String)"");
                                if (!StringUtil.isNotEmpty((String)id) || !id.equals(idFromDb)) continue;
                                accountMatch.add(account);
                                continue block2;
                            }
                        }
                        if (!CollUtil.isNotEmpty(accountMatch)) continue;
                        nodeOneRight.put("account", StringUtil.join(accountMatch));
                        arrayNodeRightNew.add((JsonNode)nodeOneRight);
                        continue;
                    }
                    arrayNodeRightNew.add((JsonNode)nodeOneRight);
                }
            }
            nodeButton.set("right", (JsonNode)new TextNode(JsonUtil.toJsonString((Object)arrayNodeRightNew)));
        }
    }

    private FormDataTemplate importDefinition(FormDataTemplateXml formDataTemplateXml, String typeId) {
        IUser user;
        List<String> listUserKey;
        ArrayNode buttonJsonAry;
        FormDataTemplate formDataTemplate = formDataTemplateXml.getFormDataTemplate();
        if (formDataTemplate != null && StringUtil.isNotEmpty((String)formDataTemplate.getManageField())) {
            try {
                buttonJsonAry = (ArrayNode)JsonUtil.toJsonNode((String)formDataTemplate.getManageField());
                listUserKey = this.getUserKey4Right(buttonJsonAry, "account");
                if (CollUtil.isNotEmpty(listUserKey)) {
                    this.updateIdByAccount4Right(buttonJsonAry, listUserKey);
                    formDataTemplate.setManageField(JsonUtil.toJsonString((Object)buttonJsonAry));
                }
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u5165\u6216\u5bfc\u51fa\u8868\u5355\u5217\u8868\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        if (formDataTemplate != null && StringUtil.isNotEmpty((String)formDataTemplate.getMobileManageField())) {
            try {
                buttonJsonAry = (ArrayNode)JsonUtil.toJsonNode((String)formDataTemplate.getMobileManageField());
                listUserKey = this.getUserKey4Right(buttonJsonAry, "account");
                if (CollUtil.isNotEmpty(listUserKey)) {
                    this.updateIdByAccount4Right(buttonJsonAry, listUserKey);
                    formDataTemplate.setMobileManageField(JsonUtil.toJsonString((Object)buttonJsonAry));
                }
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u5165\u6216\u5bfc\u51fa\u79fb\u52a8\u7aef\u8868\u5355\u5217\u8868\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        ObjectNode sysType = portalFeignService.getSysTypeById(typeId);
        String typeName = "";
        if (BeanUtils.isNotEmpty((Object)sysType)) {
            typeName = sysType.get("name").asText();
        }
        if (StringUtil.isNotEmpty((String)typeId)) {
            formDataTemplate.setTypeId(typeId);
            formDataTemplate.setTypeName(typeName);
        }
        if (BeanUtils.isNotEmpty((Object)(user = ContextUtil.getCurrentUser()))) {
            formDataTemplate.setCreateBy(user.getUserId());
        }
        formDataTemplate.setCreateTime(LocalDateTime.now());
        FormDataTemplate entity = ((FormDataTemplateDao)this.baseMapper).getByAlias(formDataTemplate.getAlias());
        if (BeanUtils.isNotEmpty((Object)((Object)entity))) {
            formDataTemplate.setId(entity.getId());
            if (BeanUtils.isNotEmpty((Object)user)) {
                formDataTemplate.setUpdateBy(user.getUserId());
                formDataTemplate.setUpdateTime(LocalDateTime.now());
            }
            ((FormDataTemplateDao)this.baseMapper).updateById((Object)formDataTemplate);
        } else {
            formDataTemplate.setCreateBy(ContextUtil.getCurrentUserId());
            formDataTemplate.setId(UniqueIdUtil.getSuid());
            ((FormDataTemplateDao)this.baseMapper).insert((Object)formDataTemplate);
        }
        return formDataTemplate;
    }

    private FormDataTemplateXml getByTemplateId(String id) {
        FormDataTemplate formDataTemplate = (FormDataTemplate)((Object)((FormDataTemplateDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)formDataTemplate), (String)("\u4e0d\u5b58\u5728id\u4e3a[" + id + "]\u8be5\u8868\u5355\u5217\u8868"));
        String permission = "";
        try {
            ArrayNode json = this.bpmFormRightManager.getByDataKey(formDataTemplate.getAlias());
            permission = json == null ? "" : json.toString();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6743\u9650\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
        }
        String formRightButtonsStr = "";
        try {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormRightButton::getDataKey, (Object)formDataTemplate.getAlias());
            List formRightButtons = this.formRightButtonManager.list((Wrapper)wrapper);
            formRightButtonsStr = JsonUtil.toJson((Object)formRightButtons);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6743\u9650\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
        }
        FormDataTemplateXml formDataTemplateXml = new FormDataTemplateXml();
        formDataTemplateXml.setFormDataTemplate(formDataTemplate);
        formDataTemplateXml.setPermission(permission);
        formDataTemplateXml.setFormButtonRight(formRightButtonsStr);
        return formDataTemplateXml;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void checkAndImportData(List<Map<String, Object>> rows, BoEnt boEnt, Map<String, BoAttribute> columnMap, String bindFilld, String fillValue, String refIdValue, FormDataTemplate template, BoDataImportHandler boDataImportHandler, Map<String, String> nameFieldMap) throws Exception {
        String refValue = "undefined".equals(refIdValue) ? "0" : refIdValue;
        FormMeta formDef = this.formMetaManager.getByKey(template.getFormKey());
        HashMap<String, Map<String, JsonNode>> filedValidateMap = new HashMap<String, Map<String, JsonNode>>();
        ArrayNode filedsArray = FormUtil.resolutionFieldsByFormMeta(formDef);
        if (BeanUtils.isNotEmpty((Object)filedsArray)) {
            for (JsonNode filed : filedsArray) {
                if (BeanUtils.isEmpty((Object)filed.get("options")) || BeanUtils.isEmpty((Object)filed.get("options").get("validateList"))) continue;
                HashMap<String, JsonNode> validateMap = new HashMap<String, JsonNode>();
                for (JsonNode validat : filed.get("options").get("validateList")) {
                    validateMap.put(validat.get("key").asText(), validat);
                }
                filedValidateMap.put(filed.get("name").asText(), validateMap);
            }
        }
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)(boEnt.getDsName() == null ? "LOCAL" : boEnt.getDsName()));
        HashMap<String, List<FormDataImportLog>> hashMap = new HashMap<String, List<FormDataImportLog>>();
        HashMap threadVarMap = new HashMap();
        HashMap<String, Set<Object>> uniqueValeMap = new HashMap<String, Set<Object>>();
        for (int i = 0; i < rows.size(); ++i) {
            List<ValidateResult> validateData;
            StringBuffer sql = new StringBuffer("insert into ");
            Map row = rows.get(i);
            if (BeanUtils.isEmpty(row)) continue;
            if (BeanUtils.isNotEmpty((Object)row.get("\u5916\u952e"))) {
                refValue = row.get("\u5916\u952e").toString();
            }
            List<FormDataImportLog> validateList = new ArrayList();
            if (hashMap.containsKey(refValue)) {
                validateList = (List)hashMap.get(refValue);
            }
            if (BeanUtils.isNotEmpty(validateData = this.validateData(row, filedValidateMap, columnMap, uniqueValeMap))) {
                for (ValidateResult validateResult : validateData) {
                    FormDataImportLog log = new FormDataImportLog(validateResult);
                    log.setId(UniqueIdUtil.getSuid());
                    log.setRowNumber(i + 3);
                    log.setPId(refValue);
                    log.setBoAlias(template.getBoDefAlias());
                    validateList.add(log);
                }
                continue;
            }
            if (boDataImportHandler != null) {
                List validateRes = boDataImportHandler.validateData(rows.get(i), boEnt, threadVarMap);
                if (BeanUtils.isNotEmpty((Object)validateRes)) {
                    for (ValidateResult validateResult2 : validateRes) {
                        FormDataImportLog log = new FormDataImportLog(validateResult2);
                        log.setId(UniqueIdUtil.getSuid());
                        log.setRowNumber(i + 3);
                        log.setPId(refValue);
                        log.setBoAlias(template.getBoDefAlias());
                        validateList.add(log);
                    }
                    continue;
                }
                row = boDataImportHandler.transData(rows.get(i), boEnt, threadVarMap);
            }
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            StringBuffer params = new StringBuffer();
            String dbType = SQLUtil.getDbType();
            for (Map.Entry<String, Object> map : row.entrySet()) {
                BoAttribute field;
                if ("\u4e3b\u952e".equals(map.getKey())) {
                    fields.add(boEnt.getPkKey());
                    if (BeanUtils.isNotEmpty(row.get("\u4e3b\u952e"))) {
                        arrayList.add(row.get("\u4e3b\u952e").toString());
                    } else {
                        arrayList.add(UniqueIdUtil.getSuid());
                    }
                    params.append("?,");
                    continue;
                }
                if ("\u5916\u952e".equals(map.getKey())) {
                    if (!StringUtil.isNotEmpty((String)boEnt.getFk())) continue;
                    fields.add(boEnt.getFk());
                    if (BeanUtils.isNotEmpty(row.get("\u5916\u952e"))) {
                        arrayList.add(row.get("\u5916\u952e").toString());
                    } else {
                        arrayList.add("0");
                    }
                    params.append("?,");
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)map.getValue())) continue;
                String key = map.getKey();
                if (nameFieldMap.containsKey(key)) {
                    key = nameFieldMap.get(key);
                }
                if (BeanUtils.isEmpty((Object)(field = columnMap.get(key))) || field.getName().equals(bindFilld)) continue;
                fields.add(field.getFieldName());
                if (map.getValue() instanceof String) {
                    if (com.hotent.base.util.time.DateUtil.isRqSjFormat((String)map.getValue().toString()) && (dbType.equals("postgresql") || dbType.equals("oracle"))) {
                        arrayList.add(Timestamp.valueOf(map.getValue().toString()));
                    } else if (com.hotent.base.util.time.DateUtil.isRqFormat((String)map.getValue().toString()) && (dbType.equals("postgresql") || dbType.equals("oracle"))) {
                        arrayList.add(Timestamp.valueOf(map.getValue().toString() + " 00:00:00"));
                    } else if (map.getValue().toString().matches("\\d+(.\\d+)?") && dbType.equals("postgresql")) {
                        arrayList.add(Float.valueOf(Float.parseFloat(map.getValue().toString())));
                    } else {
                        arrayList.add(map.getValue());
                    }
                } else {
                    arrayList.add(map.getValue());
                }
                params.append("?,");
            }
            if (!fields.contains(boEnt.getPkKey())) {
                fields.add(boEnt.getPkKey());
                arrayList.add(UniqueIdUtil.getSuid());
                params.append("?,");
            }
            if (StringUtil.isNotEmpty((String)bindFilld) && StringUtil.isNotEmpty((String)fillValue)) {
                fields.add(BoEnt.FIELD_PREFIX + bindFilld);
                arrayList.add(fillValue);
                params.append("?,");
            }
            if (StringUtil.isNotEmpty((String)boEnt.getFk()) && !fields.contains(boEnt.getFk())) {
                fields.add(boEnt.getFk());
                arrayList.add(refValue);
                params.append("?,");
            }
            if (!boEnt.isExternal()) {
                fields.add("F_form_data_rev_");
                if (dbType.equals("postgresql")) {
                    arrayList.add(0);
                } else {
                    arrayList.add("0");
                }
                params.append("?,");
            }
            sql.append(boEnt.getTableName());
            sql.append("(" + String.join((CharSequence)",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + params.substring(0, params.length() - 1) + ")");
            try {
                jdbcTemplate.update(sql.toString(), arrayList.toArray());
            }
            catch (Exception e) {
                FormDataImportLog log = new FormDataImportLog();
                log.setId(UniqueIdUtil.getSuid());
                log.setRowNumber(i + 3);
                log.setPId(refValue);
                log.setBoAlias(template.getBoDefAlias());
                log.setErrorMsg(e.getMessage());
                validateList.add(log);
            }
            hashMap.put(refValue, validateList);
        }
        for (String item : hashMap.keySet()) {
            List importLogList = (List)hashMap.get(item);
            if (importLogList.size() > 0) {
                try {
                    this.formDataImportLogManager.deleteByPid(item, template.getBoDefAlias());
                    this.formDataImportLogManager.saveBatch(importLogList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7");
            }
            this.formDataImportLogManager.deleteByPid(item, template.getBoDefAlias());
        }
        if (StringUtil.isNotEmpty((String)bindFilld)) {
            String cleanSql = "delete from " + boEnt.getTableName() + " where " + BoEnt.FK_NAME + " < " + String.valueOf(System.currentTimeMillis() - 86400000L) + " and " + BoEnt.FIELD_PREFIX + bindFilld + " > " + String.valueOf(TimeUtil.getMillsByDateString((String)"2020-01-01"));
            jdbcTemplate.execute(cleanSql);
        }
    }

    public void newCheckAndImportData(List<Map<String, Object>> rows, BoEnt boEnt, Map<String, BoAttribute> columnMap, String bindFilld, String fillValue, FormDataTemplate template, Map<String, String> nameFieldMap) throws Exception {
        String refValue = "0";
        FormMeta formDef = this.formMetaManager.getByKey(template.getFormKey());
        HashMap<String, Map<String, JsonNode>> filedValidateMap = new HashMap<String, Map<String, JsonNode>>();
        ArrayNode filedsArray = FormUtil.resolutionFieldsByFormMeta(formDef);
        if (BeanUtils.isNotEmpty((Object)filedsArray)) {
            for (JsonNode filed : filedsArray) {
                if (BeanUtils.isEmpty((Object)filed.get("options")) || BeanUtils.isEmpty((Object)filed.get("options").get("validateList"))) continue;
                HashMap<String, JsonNode> validateMap = new HashMap<String, JsonNode>();
                for (JsonNode validat : filed.get("options").get("validateList")) {
                    validateMap.put(validat.get("key").asText(), validat);
                }
                filedValidateMap.put(filed.get("name").asText(), validateMap);
            }
        }
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)(boEnt.getDsName() == null ? "LOCAL" : boEnt.getDsName()));
        HashMap threadVarMap = new HashMap();
        HashMap<String, Set<Object>> uniqueValeMap = new HashMap<String, Set<Object>>();
        for (int i = 0; i < rows.size(); ++i) {
            StringBuffer sql = new StringBuffer("insert into ");
            Map<String, Object> row = rows.get(i);
            if (BeanUtils.isEmpty(row)) continue;
            if (BeanUtils.isNotEmpty((Object)row.get("\u5916\u952e"))) {
                refValue = row.get("\u5916\u952e").toString();
            }
            this.validateData(row, filedValidateMap, columnMap, uniqueValeMap);
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            StringBuffer params = new StringBuffer();
            String dbType = SQLUtil.getDbType();
            for (Map.Entry<String, Object> map : row.entrySet()) {
                BoAttribute field;
                if ("\u4e3b\u952e".equals(map.getKey())) {
                    fields.add(boEnt.getPkKey());
                    if (BeanUtils.isNotEmpty((Object)row.get("\u4e3b\u952e"))) {
                        values.add(row.get("\u4e3b\u952e").toString());
                    } else {
                        values.add(UniqueIdUtil.getSuid());
                    }
                    params.append("?,");
                    continue;
                }
                if ("\u5916\u952e".equals(map.getKey())) {
                    if (!StringUtil.isNotEmpty((String)boEnt.getFk())) continue;
                    fields.add(boEnt.getFk());
                    if (BeanUtils.isNotEmpty((Object)row.get("\u5916\u952e"))) {
                        values.add(row.get("\u5916\u952e").toString());
                    } else {
                        values.add("0");
                    }
                    params.append("?,");
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)map.getValue())) continue;
                String key = map.getKey();
                if (nameFieldMap.containsKey(key)) {
                    key = nameFieldMap.get(key);
                }
                if (BeanUtils.isEmpty((Object)(field = columnMap.get(key))) || field.getName().equals(bindFilld)) continue;
                fields.add(field.getFieldName());
                if (map.getValue() instanceof String) {
                    if (com.hotent.base.util.time.DateUtil.isRqSjFormat((String)map.getValue().toString()) && (dbType.equals("postgresql") || dbType.equals("oracle"))) {
                        values.add(Timestamp.valueOf(map.getValue().toString()));
                    } else if (com.hotent.base.util.time.DateUtil.isRqFormat((String)map.getValue().toString()) && (dbType.equals("postgresql") || dbType.equals("oracle"))) {
                        values.add(Timestamp.valueOf(map.getValue().toString() + " 00:00:00"));
                    } else if (map.getValue().toString().matches("\\d+(.\\d+)?") && dbType.equals("postgresql")) {
                        values.add(Float.valueOf(Float.parseFloat(map.getValue().toString())));
                    } else {
                        values.add(map.getValue());
                    }
                } else {
                    values.add(map.getValue());
                }
                params.append("?,");
            }
            if (!fields.contains(boEnt.getPkKey())) {
                fields.add(boEnt.getPkKey());
                values.add(UniqueIdUtil.getSuid());
                params.append("?,");
            }
            if (StringUtil.isNotEmpty((String)bindFilld) && StringUtil.isNotEmpty((String)fillValue)) {
                fields.add(BoEnt.FIELD_PREFIX + bindFilld);
                values.add(fillValue);
                params.append("?,");
            }
            if (StringUtil.isNotEmpty((String)boEnt.getFk()) && !fields.contains(boEnt.getFk())) {
                fields.add(boEnt.getFk());
                values.add(refValue);
                params.append("?,");
            }
            if (!boEnt.isExternal()) {
                fields.add("F_form_data_rev_");
                if (dbType.equals("postgresql")) {
                    values.add(0);
                } else {
                    values.add("0");
                }
                params.append("?,");
            }
            sql.append(boEnt.getTableName());
            sql.append("(" + String.join((CharSequence)",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + params.substring(0, params.length() - 1) + ")");
            try {
                jdbcTemplate.update(sql.toString(), values.toArray());
                continue;
            }
            catch (Exception e) {
                int rowNumber = i + 2;
                String msg = "\u5bfc\u5165\u5931\u8d25\uff0c\u9519\u8bef\u53d1\u751f\u5728sheet\u540d\u79f0\u4e3a\uff1a" + boEnt.getDesc() + "\u4e0b\u7684\u7b2c" + rowNumber + "\u884c\u7684\u6570\u636e\u3002\u6570\u636e\u4fe1\u606f\u4e3a:" + row.toString() + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                throw new BaseException(msg);
            }
        }
        if (StringUtil.isNotEmpty((String)bindFilld)) {
            String cleanSql = "delete from " + boEnt.getTableName() + " where " + BoEnt.FK_NAME + " < " + String.valueOf(System.currentTimeMillis() - 86400000L) + " and " + BoEnt.FIELD_PREFIX + bindFilld + " > " + String.valueOf(TimeUtil.getMillsByDateString((String)"2020-01-01"));
            jdbcTemplate.execute(cleanSql);
        }
    }

    private List<ValidateResult> validateData(Map<String, Object> data, Map<String, Map<String, JsonNode>> filedValidateMap, Map<String, BoAttribute> columnMap, Map<String, Set<Object>> uniqueValeMap) {
        ArrayList<ValidateResult> list = new ArrayList<ValidateResult>();
        HashMap<String, BoAttribute> filedNameMap = new HashMap<String, BoAttribute>();
        for (BoAttribute attr : columnMap.values()) {
            String dateTime;
            filedNameMap.put(attr.getName(), attr);
            if (!"date".equals(attr.getDataType()) || !StringUtil.isNotEmpty((String)(dateTime = data.get(attr.getDesc()).toString()))) continue;
            Date date = DateUtil.getJavaDate((double)Double.valueOf(dateTime));
            if (!BeanUtils.isNotEmpty(data)) continue;
            data.put(attr.getDesc(), date);
        }
        for (Map.Entry<String, Map<String, JsonNode>> next : filedValidateMap.entrySet()) {
            if (!filedNameMap.containsKey(next.getKey())) continue;
            BoAttribute attribute = (BoAttribute)filedNameMap.get(next.getKey());
            Object value = data.get(attribute.getDesc());
            for (Map.Entry<String, JsonNode> entity : next.getValue().entrySet()) {
                ValidateResult validateRes = this.validate(attribute, value, entity.getKey(), entity.getValue(), filedNameMap, data, uniqueValeMap);
                if (!BeanUtils.isNotEmpty((Object)validateRes)) continue;
                throw new BaseException("\u6570\u636e\u6821\u9a8c\u9519\u8bef\uff0c\u53d1\u751f\u9519\u8bef\u7684\u5217\u4e3a\uff1a" + validateRes.getColumnName() + "\u3002\u9519\u8bef\u539f\u56e0\uff1a" + validateRes.getErrorMsg() + "\u3002");
            }
        }
        return list;
    }

    private ValidateResult validate(BoAttribute attribute, Object value, String validateName, JsonNode validate, Map<String, BoAttribute> filedNameMap, Map<String, Object> data, Map<String, Set<Object>> uniqueValeMap) {
        String errorMsg = "";
        switch (validateName) {
            case "required": {
                if (!BeanUtils.isEmpty((Object)value)) break;
                errorMsg = "\u4e0d\u80fd\u4e3a\u7a7a";
                break;
            }
            case "max": {
                int maxLen = JsonUtil.getInt((JsonNode)((ObjectNode)validate), (String)"value");
                if (BeanUtils.ObjectToString((Object)value).length() <= maxLen) break;
                errorMsg = "\u957f\u5ea6\u8d85\u51fa" + maxLen;
                break;
            }
            case "min": {
                int minLen = JsonUtil.getInt((JsonNode)((ObjectNode)validate), (String)"value");
                if (BeanUtils.ObjectToString((Object)value).length() >= minLen) break;
                errorMsg = "\u957f\u5ea6\u4e0d\u591f" + minLen;
                break;
            }
            case "is": {
                HashSet<String> values;
                String valueScope = JsonUtil.getString((JsonNode)((ObjectNode)validate), (String)"value");
                if (!StringUtil.isNotEmpty((String)valueScope) || (values = new HashSet<String>(Arrays.asList(valueScope.split(",")))).contains(value)) break;
                errorMsg = "\u8f93\u5165\u503c\u4e0d\u5728\u3010" + StringUtil.join(values) + "\u3011\u8303\u56f4\u4e4b\u5185";
                break;
            }
            case "regex": {
                String regex = JsonUtil.getString((JsonNode)((ObjectNode)validate), (String)"value");
                if (!StringUtil.isNotEmpty((String)regex) || Pattern.matches(regex, BeanUtils.ObjectToString((Object)value))) break;
                errorMsg = "\u6b63\u5219\u4e0d\u5339\u914d";
                break;
            }
            case "row_unique": {
                Set<Object> valueSet;
                ArrayList<String> uniqueKeyList = new ArrayList<String>(Arrays.asList(JsonUtil.getString((JsonNode)((ObjectNode)validate), (String)"value").split(",")));
                if (!uniqueKeyList.contains(attribute.getName())) {
                    uniqueKeyList.add(attribute.getName());
                }
                ArrayList<String> uniqueValList = new ArrayList<String>();
                ArrayList<String> uniqueDescList = new ArrayList<String>();
                for (String key : uniqueKeyList) {
                    if (key.split("\\.").length == 3) {
                        key = key.split("\\.")[2];
                    }
                    if (!filedNameMap.containsKey(key)) continue;
                    uniqueValList.add(BeanUtils.ObjectToString((Object)data.get(filedNameMap.get(key).getDesc())));
                    uniqueDescList.add(filedNameMap.get(key).getDesc());
                }
                String uniqueKey = StringUtil.join(uniqueKeyList, (String)"");
                Set<Object> set = valueSet = BeanUtils.isNotEmpty(uniqueValeMap.get(uniqueKey)) ? uniqueValeMap.get(uniqueKey) : new HashSet();
                if (valueSet.contains(StringUtil.join(uniqueValList, (String)""))) {
                    errorMsg = "\u8fdd\u53cd\u3010" + StringUtil.join(uniqueDescList, (String)"+") + "\u3011\u552f\u4e00\u7ea6\u675f";
                } else {
                    valueSet.add(StringUtil.join(uniqueValList, (String)""));
                }
                uniqueValeMap.put(uniqueKey, valueSet);
                break;
            }
        }
        if (StringUtil.isEmpty((String)errorMsg)) {
            return null;
        }
        return new ValidateResult(attribute.getDesc(), errorMsg);
    }

    @Override
    public List<Map<String, Object>> resolutionExcel(MultipartFile firstFile, Map<String, BoAttribute> columnMap, String bindFilld) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Workbook wb = ExcelUtil.readExcel((MultipartFile)firstFile);
        if (wb == null) {
            return list;
        }
        List<Map> listMap = ExcelUtil.ImportDate((MultipartFile)firstFile, (int)0).stream().filter(item -> !this.isEmptyRow((Map<String, String>)item)).collect(Collectors.toList());
        listMap.forEach(map -> {
            LinkedHashMap boData = new LinkedHashMap();
            map.forEach((key, value) -> {
                if (columnMap.containsKey(key)) {
                    BoAttribute boAttribute = (BoAttribute)columnMap.get(key);
                    boData.put(boAttribute.getDesc(), value);
                }
            });
            if (boData.size() > 0) {
                list.add(boData);
            }
        });
        return list;
    }

    public List<Map<String, Object>> newResolutionExcel(MultipartFile firstFile, Map<String, BoAttribute> columnMap, String bindFilld, String sheetName) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Workbook wb = ExcelUtil.readExcel((MultipartFile)firstFile);
        if (wb == null) {
            return list;
        }
        List<Map> listMap = ExcelUtil.ImportDate((MultipartFile)firstFile, (int)1, (String)sheetName).stream().filter(item -> !this.isEmptyRow((Map<String, String>)item)).collect(Collectors.toList());
        listMap.forEach(map -> {
            LinkedHashMap boData = new LinkedHashMap();
            map.forEach((key, value) -> {
                if (columnMap.containsKey(key)) {
                    BoAttribute boAttribute = (BoAttribute)columnMap.get(key);
                    boData.put(boAttribute.getDesc(), value);
                }
                if ("\u4e3b\u952e".equals(key)) {
                    boData.put("\u4e3b\u952e", value);
                }
                if ("\u5916\u952e".equals(key)) {
                    boData.put("\u5916\u952e", value);
                }
            });
            if (boData.size() > 0) {
                list.add(boData);
            }
        });
        return list;
    }

    private boolean isEmptyRow(Map<String, String> param) {
        boolean isEmpty = true;
        for (String key : param.keySet()) {
            if (!BeanUtils.isNotEmpty((Object)param.get(key))) continue;
            isEmpty = false;
        }
        return isEmpty;
    }

    @Override
    public void downloadMainTempByFormKey(HttpServletResponse response, String alias) throws Exception {
        Form bpmForm = this.formManager.getMainByFormKey(alias);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = this.formMetaManager.getBODefIdByFormId(formId);
        BoDef boDef = this.boDefService.getByDefId(boDefIds.get(0));
        BoEnt boEnt = boDef.getBoEnt();
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        List boAttrList = boEnt.getColumnList();
        for (BoAttribute boAttr : boAttrList) {
            exportMaps.put(boAttr.getName(), boAttr.getDesc());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)bpmForm.getName(), (int)24, exportMaps, new ArrayList());
        ExcelUtil.downloadExcel((Workbook)book, (String)(bpmForm.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
    }

    @Override
    public int updateTempRefId(ObjectNode objectNode) throws Exception {
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)"LOCAL");
        String tableName = objectNode.get("tabName").asText();
        String refFiled = BoEnt.FK_NAME;
        String oldValue = objectNode.get("oldValue").asText();
        String newValue = objectNode.get("newValue").asText();
        ArrayList<String> values = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tableName).append(" set ").append(refFiled).append("= ? ");
        values.add(newValue);
        sql.append(" where ");
        sql.append(refFiled);
        sql.append("=?");
        values.add(oldValue);
        int update = jdbcTemplate.update(sql.toString(), values.toArray());
        StringBuffer logUpdateSql = new StringBuffer();
        logUpdateSql.append(" update form_data_import_log  set  P_ID_").append("= ? ");
        logUpdateSql.append(" where P_ID_ =?");
        jdbcTemplate.update(logUpdateSql.toString(), values.toArray());
        return update;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void boBatchUpdate(List<ObjectNode> listJson, String boAlias, Map<String, String> filterMap) throws Exception {
        BoDef boDef = this.boDefService.getByAlias(boAlias);
        BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
        ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
        BoEnt boEnt = boDef.getBoEnt();
        String pk = boEnt.getPk();
        ArrayList<FormRemindData> insertList = new ArrayList<FormRemindData>();
        ArrayList<BoData> curData = new ArrayList<BoData>();
        HashMap<String, List<FormDataTemplateExtend>> formDataTemplateExtendMap = new HashMap<String, List<FormDataTemplateExtend>>();
        if (StringUtil.isEmpty((String)pk)) {
            pk = BoEnt.PK_NAME;
        }
        for (ObjectNode objectNode : listJson) {
            if (!objectNode.has(pk)) {
                if (objectNode.has(pk.toUpperCase())) {
                    pk = pk.toUpperCase();
                } else {
                    if (!objectNode.has(pk.toLowerCase())) continue;
                    pk = pk.toLowerCase();
                }
            }
            String id = objectNode.get(pk).asText();
            BoData boData = handler.getResById((Object)id, boAlias);
            Map map = boData.getData();
            map.forEach((key, value) -> {
                String pathPrefix;
                String valuePath;
                String keyExternal;
                String valueKey = "";
                String lowerCase = key.replaceAll("_", "").toLowerCase();
                if (objectNode.has(key.toLowerCase())) {
                    valueKey = key.toLowerCase();
                } else if (objectNode.has(lowerCase)) {
                    valueKey = lowerCase;
                }
                if (StringUtil.isEmpty((String)valueKey) && boDef.getBoEnt().isExternal() && objectNode.has(keyExternal = key.toLowerCase().replaceAll("f_", "").replaceAll("_", ""))) {
                    valueKey = keyExternal;
                }
                if ((!objectNode.has(valueKey) || StringUtil.isEmpty((String)valueKey)) && objectNode.has(valuePath = ((pathPrefix = boDef.getBoEnt().getTableName() + (boDef.getBoEnt().isExternal() ? "" : BoEnt.FIELD_PREFIX)) + lowerCase).replaceAll("_", "").toLowerCase())) {
                    valueKey = valuePath;
                }
                if (StringUtil.isNotEmpty((String)valueKey)) {
                    if (value instanceof BigDecimal) {
                        map.put(key, new BigDecimal(objectNode.get(valueKey.toLowerCase()).asText()));
                    } else if (value instanceof Integer) {
                        map.put(key, Integer.parseInt(objectNode.get(valueKey.toLowerCase()).asText()));
                    } else {
                        map.put(key, objectNode.get(valueKey.toLowerCase()).asText());
                    }
                    if (BeanUtils.isNotEmpty((Object)filterMap) && filterMap.containsKey(valueKey) && "2".equals(filterMap.get(valueKey)) && BeanUtils.isNotEmpty((Object)value)) {
                        map.put(key, value);
                    }
                }
            });
            if (BeanUtils.isEmpty((Object)boData.getBoEnt())) {
                boData.setBoEnt(boEnt);
            }
            if (BeanUtils.isEmpty((Object)boData.getBoDefAlias())) {
                boData.setBoDefAlias(boAlias);
            }
            curData.add(boData);
            if (!objectNode.has("formKey")) continue;
            String formKey = objectNode.get("formKey").asText();
            this.saveBo(boData, id, formKey, insertList, formDataTemplateExtendMap);
        }
        List resultList = handler.batchSave("", "", curData);
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        for (BatchBoResult boDataListMap : resultList) {
            BoData boData = boDataListMap.getCurData();
            List modifyResultList = boDataListMap.getModifyResultList();
            if (!BeanUtils.isNotEmpty((Object)modifyResultList)) continue;
            params.add(this.handleBoResult(modifyResultList, BoUtil.toJSON((BoData)boData, (boolean)true)));
        }
        if (BeanUtils.isNotEmpty(params)) {
            this.bpmRuntimeFeignService.batchHandleBoDateModify(params);
        }
        if (BeanUtils.isNotEmpty(insertList)) {
            this.formRemindDataManager.saveBatch(insertList);
        }
        ThreadMsgUtil.clean();
    }

    private void saveBo(BoData boData, String boDataId, String formKey, List<FormRemindData> insertList, Map<String, List<FormDataTemplateExtend>> formDataTemplateExtendMap) throws Exception {
        List<FormDataTemplateExtend> list;
        if (formDataTemplateExtendMap.containsKey(formKey)) {
            list = formDataTemplateExtendMap.get(formKey);
        } else {
            list = this.formDataTemplateExtendManager.getDataTemplateExtendByFormKey(formKey);
            formDataTemplateExtendMap.put(formKey, list);
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"ID_", (Object)boDataId);
        this.formRemindDataManager.deleteFormRemindDataByBoDataId(qw);
        for (int i = 0; i < list.size(); ++i) {
            JsonNode node;
            String script;
            boolean res;
            FormDataTemplateExtend formDataTemplateExtend = list.get(i);
            String scriptJson = formDataTemplateExtend.getRule();
            if (StringUtil.isEmpty((String)scriptJson) || !(res = this.groovyScriptEngine.executeBoolean(Base64.getFromBase64((String)(script = (node = JsonUtil.toJsonNode((String)scriptJson)).get("scriptStr").asText())), boData.getData()))) continue;
            String typeObj = formDataTemplateExtend.getTypeObj();
            String objId = formDataTemplateExtend.getObjId();
            String content = formDataTemplateExtend.getContent();
            String count = formDataTemplateExtend.getCount();
            if (typeObj.equals("script")) {
                objId = boData.getData().get(objId) + "";
                FormRemindData formRemindData = new FormRemindData();
                formRemindData.setSubject(formDataTemplateExtend.getSubject());
                formRemindData.setContent(content);
                formRemindData.setCount(count);
                formRemindData.setObjId(objId);
                formRemindData.setTypeObj("user");
                formRemindData.setOpemId(boDataId);
                formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                insertList.add(formRemindData);
                continue;
            }
            String[] objIds = objId.split(",");
            for (int j = 0; j < objIds.length; ++j) {
                FormRemindData formRemindData = new FormRemindData();
                formRemindData.setSubject(formDataTemplateExtend.getSubject());
                formRemindData.setContent(content);
                formRemindData.setCount(count);
                formRemindData.setObjId(objIds[j]);
                formRemindData.setTypeObj(typeObj);
                formRemindData.setOpemId(boDataId);
                formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                insertList.add(formRemindData);
            }
        }
    }

    @Override
    public List<FormDataTemplate> getExistsByFormKey(String formKey) {
        QueryFilter filter = QueryFilter.build();
        filter.addFilter("FORM_KEY_", (Object)formKey, QueryOP.EQUAL, FieldRelation.AND);
        PageList query = this.query(filter);
        if (BeanUtils.isEmpty((Object)query.getRows())) {
            return null;
        }
        return query.getRows();
    }

    @Override
    public String importCheckFormAndBo(FormDataTemplate formDataTemplate) {
        String name = formDataTemplate.getName();
        String alias = formDataTemplate.getAlias();
        String formKey = formDataTemplate.getFormKey();
        String boDefAlias = formDataTemplate.getBoDefAlias();
        String boDefId = formDataTemplate.getBoDefId();
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)formKey), (String)"\u8868\u5355\u5217\u8868\u4e2d\u7684formKey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)boDefAlias), (String)"\u8868\u5355\u5217\u8868\u4e2d\u7684boDefAlias\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)boDefId), (String)"\u8868\u5355\u5217\u8868\u4e2d\u7684boDefId\u4e0d\u80fd\u4e3a\u7a7a");
        Form form = this.formManager.getMainByFormKey(formKey);
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)form)), (String)String.format("\u8868\u5355\u5217\u8868\uff1a%s\uff08%s\uff09\u6240\u4f9d\u8d56\u7684formKey\u4e3a\uff1a%s \u7684\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u7ecf\u5bfc\u5165\u8be5\u8868\u5355\u3002", name, alias, formKey));
        List<Map<String, Object>> boEnts = this.formManager.getBoEnt(form.getDefId());
        Assert.isTrue((boolean)BeanUtils.isNotEmpty(boEnts), (String)String.format("\u8868\u5355\u5217\u8868\uff1a%s\uff08%s\uff09\u6240\u4f9d\u8d56\u7684formKey\u4e3a\uff1a%s \u7684\u8868\u5355\u672a\u627e\u5230\u5bf9\u5e94BO\u5bf9\u8c61", name, alias, formKey));
        String curBoDefId = null;
        for (Map<String, Object> boEnt : boEnts) {
            String boEntAlias = MapUtils.getString(boEnt, (Object)"alias_");
            if (!boDefAlias.equals(boEntAlias)) continue;
            curBoDefId = MapUtils.getString(boEnt, (Object)"id_");
        }
        Assert.isTrue((boolean)StringUtil.isNotEmpty(curBoDefId), (String)String.format("\u8868\u5355\u5217\u8868\uff1a%s\uff08%s\uff09\u6240\u4f9d\u8d56\u7684formKey\u4e3a\uff1a%s \u7684\u8868\u5355 \u4e0e \u4f9d\u8d56\u7684boDefKey\u4e3a\uff1a%s \u7684BO\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u8868\u5355\u5217\u8868\u4f9d\u8d56\u7684\u8868\u5355\u662f\u5426\u6709\u8bef\u3002", name, alias, formKey, boDefAlias));
        return curBoDefId;
    }

    @Override
    public CommonResult<FormDataTemplate> saveFormDataTemplate(String json) throws Exception {
        FormDataTemplate temp;
        boolean flag;
        String str;
        ObjectNode obj;
        String resultMsg = null;
        FormDataTemplate bpmDataTemplate = this.getFormObject(json);
        if (BeanUtils.isNotEmpty((Object)bpmDataTemplate.getJoinTables())) {
            JsonNode joinTable = JsonUtil.toJsonNode((String)bpmDataTemplate.getJoinTables());
            joinTable.forEach(item -> {
                String tableName = JsonUtil.getString((JsonNode)item, (String)"join");
                String condition = JsonUtil.getString((JsonNode)item, (String)"condition");
                if (StringUtil.isNotEmpty((String)tableName) && (StringUtil.isEmpty((String)condition) || JsonUtil.isEmptyJsonArr((String)condition))) {
                    throw new BaseException(String.format("\u8bf7\u914d\u7f6e\u5173\u8054\u8868%s\u7684\u5173\u8054\u5173\u7cfb", tableName));
                }
            });
        }
        boolean resetTemp = false;
        if (!StringUtil.isEmpty((String)json) && BeanUtils.isNotEmpty((Object)(obj = (ObjectNode)JsonUtil.toJsonNode((String)json)).get("resetTemp")) && (str = obj.get("resetTemp").asText()).equals("1")) {
            resetTemp = true;
        }
        if (StringUtil.isEmpty((String)bpmDataTemplate.getFormName())) {
            if (StringUtil.isNotEmpty((String)bpmDataTemplate.getFormKey())) {
                Form bpmForm = this.formManager.getMainByFormKey(bpmDataTemplate.getFormKey());
                bpmDataTemplate.setFormName(bpmForm.getName());
            } else {
                throw new BaseException("\u8bf7\u9009\u62e9\u8868\u5355");
            }
        }
        boolean bl = flag = StringUtil.isEmpty((String)bpmDataTemplate.getId());
        if (flag && BeanUtils.isNotEmpty((Object)((Object)(temp = this.getByAlias(bpmDataTemplate.getAlias()))))) {
            return new CommonResult(false, "\u62a5\u8868\u522b\u540d\uff1a" + bpmDataTemplate.getAlias() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u522b\u540d\uff01");
        }
        this.save(bpmDataTemplate, resetTemp);
        resultMsg = flag ? "\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6210\u529f" : "\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6210\u529f";
        this.batchDelCacheByIds(bpmDataTemplate.getId());
        return new CommonResult(true, resultMsg, (Object)bpmDataTemplate);
    }

    @Override
    public CommonResult<String> saveCopy(Map<String, String> map) throws Exception {
        String id = map.get("id");
        String newAlias = map.get("newAlias");
        String newName = map.get("newName");
        String newTypeId = map.get("newTypeId");
        String newTypeName = map.get("newTypeName");
        FormDataTemplate dataTemplate = this.getById((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)((Object)dataTemplate))) {
            return new CommonResult(false, "\u539f\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u590d\u5236\u5931\u8d25!");
        }
        FormDataTemplate temp = this.getByAlias(newAlias);
        if (BeanUtils.isNotEmpty((Object)((Object)temp))) {
            return new CommonResult(false, "\u62a5\u8868\u522b\u540d\uff1a" + newAlias + "\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u522b\u540d\uff01");
        }
        dataTemplate.setId(null);
        dataTemplate.setName(newName);
        dataTemplate.setAlias(newAlias);
        dataTemplate.setTypeId(newTypeId);
        dataTemplate.setTypeName(newTypeName);
        this.save(dataTemplate, true);
        this.batchDelCacheByIds(id);
        return new CommonResult(true, "\u590d\u5236\u6570\u636e\u6a21\u677f\u6210\u529f");
    }

    private void refreshFormatterData(FormDataTemplate bpmDataTemplate) throws IOException {
        ArrayNode jsonAry;
        String displayField = bpmDataTemplate.getDisplayField();
        if (StringUtil.isNotEmpty((String)displayField) && (jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField)) != null && jsonAry.size() > 0) {
            ArrayList<String> dictKeyList = new ArrayList<String>();
            for (JsonNode jsonNode : jsonAry) {
                String formatterType = JsonUtil.getString((JsonNode)jsonNode, (String)"formatterType");
                String dictKey = JsonUtil.getString((JsonNode)jsonNode, (String)"dataDictionaryKey");
                if (!"4".equals(formatterType) || !StringUtil.isNotEmpty((String)dictKey) || dictKeyList.contains(dictKey)) continue;
                dictKeyList.add(dictKey);
            }
            List listDict = new ArrayList();
            if (CollUtil.isNotEmpty(dictKeyList)) {
                PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
                listDict = portalFeignService.getDictionariesByAlias(dictKeyList.toArray(new String[0]));
            }
            boolean isDictChanged = false;
            for (JsonNode jsonNode : jsonAry) {
                ObjectNode nodeDict;
                String formatterType = JsonUtil.getString((JsonNode)jsonNode, (String)"formatterType");
                String dictKey = JsonUtil.getString((JsonNode)jsonNode, (String)"dataDictionaryKey");
                if (!"4".equals(formatterType) || !StringUtil.isNotEmpty((String)dictKey) || !CollUtil.isNotEmpty(listDict) || (nodeDict = (ObjectNode)listDict.stream().filter(item -> dictKey.equals(JsonUtil.getString((JsonNode)item, (String)"key"))).findFirst().orElse(null)) == null) continue;
                isDictChanged = true;
                ArrayNode formatterArray = JsonUtil.createArrayNode();
                if (nodeDict.get("children") != null && nodeDict.get("children") instanceof ArrayNode) {
                    ArrayNode dictArray = (ArrayNode)nodeDict.get("children");
                    for (JsonNode dict : dictArray) {
                        ObjectNode formatterNode = JsonUtil.createObjectNode();
                        formatterNode.put("key_", JsonUtil.getString((JsonNode)dict, (String)"key"));
                        formatterNode.put("value_", JsonUtil.getString((JsonNode)dict, (String)"name"));
                        formatterArray.add((JsonNode)formatterNode);
                    }
                }
                ((ObjectNode)jsonNode).set("formatterData", (JsonNode)formatterArray);
            }
            if (isDictChanged) {
                bpmDataTemplate.setDisplayField(JsonUtil.toJsonString((Object)jsonAry));
            }
        }
    }

    @Override
    public CommonResult<BpmDataTemplateInfoVo> getBpmDataTemplateInfo(String alias, Optional<Boolean> needDisplayFileds) throws Exception {
        FormDataTemplate bpmDataTemplate = null;
        bpmDataTemplate = needDisplayFileds.orElse(false) != false ? this.getExportDisplay(alias) : this.getByAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)bpmDataTemplate))) {
            return new CommonResult(false, "\u6839\u636e\u62a5\u8868\u522b\u540d\u3010" + alias + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u62a5\u8868\u6570\u636e\uff01");
        }
        Form bpmForm = this.formManager.getMainByFormKey(bpmDataTemplate.getFormKey());
        if (BeanUtils.isEmpty((Object)((Object)bpmForm))) {
            return new CommonResult(false, "\u6839\u636e\u8868\u5355key\u3010" + bpmDataTemplate.getFormKey() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u8868\u5355\uff01");
        }
        bpmDataTemplate.setFormName(bpmForm.getName());
        BpmDataTemplateInfoVo vo = (BpmDataTemplateInfoVo)((Object)JsonUtil.toBean((String)JsonUtil.toJson((Object)((Object)bpmDataTemplate)), BpmDataTemplateInfoVo.class));
        vo.setFormId(bpmForm.getId());
        BoDef boDef = this.boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        vo.setPkField(boEnt.getPkKey().toLowerCase());
        vo.setIsExternal(boEnt.getIsExternal());
        if (StringUtil.isNotEmpty((String)vo.getJoinTablesSql())) {
            try {
                Select select = (Select)CCJSqlParserUtil.parse((String)vo.getJoinTablesSql());
                SelectBody selectBody = select.getSelectBody();
                PlainSelect plainSelect = (PlainSelect)selectBody;
                Table table = (Table)plainSelect.getFromItem();
                vo.setMainTalbeName(table.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public Object importSave(Optional<Boolean> confirmImport, Optional<String> typeId, Optional<String> cacheFileId) {
        CommonResult<String> message = null;
        try {
            if (confirmImport.orElse(false).booleanValue()) {
                String byKey = ((FormDataTemplateManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFileId.get());
                if (StringUtil.isEmpty((String)byKey)) {
                    return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:\u4e0a\u4f20\u7684\u6587\u4ef6\u5df2\u4ece\u7f13\u5b58\u4e2d\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
                }
                ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
                message = this.importDef(objectNode, typeId.orElse(""));
            }
            ((FormDataTemplateManagerImpl)AppUtil.getBean(this.getClass())).delImportFileFromCache(cacheFileId.orElse(""));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u5931\u8d25:", (Throwable)e);
            message = new CommonResult<String>(false, "\u5bfc\u5165\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, Optional<String> typeId) {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String formDataTemplatesXml = FileUtil.readFile((String)(unZipFilePath + "/formDataTemplates.form.xml"));
            if (StringUtils.isEmpty((String)formDataTemplatesXml)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            FormDataTemplateManagerImpl.checkXmlFormat(formDataTemplatesXml);
            FormDataTemplateXmlList formDataTemplateXmlList = (FormDataTemplateXmlList)JAXBUtil.unmarshall((String)formDataTemplatesXml, FormDataTemplateXmlList.class);
            List<FormDataTemplateXml> list = formDataTemplateXmlList.getFormDataTemplateXmlList();
            ArrayList<String> names = new ArrayList<String>();
            for (FormDataTemplateXml formDataTemplateXml : list) {
                FormDataTemplate oformDataTemplate;
                FormDataTemplate formDataTemplate = formDataTemplateXml.getFormDataTemplate();
                if (!BeanUtils.isNotEmpty((Object)((Object)formDataTemplate)) || (oformDataTemplate = this.getByAlias(formDataTemplate.getAlias())) == null) continue;
                names.add(formDataTemplate.getName() + "\uff08" + formDataTemplate.getAlias() + "\uff09");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formDataTemplatesXml", formDataTemplatesXml);
            if (BeanUtils.isEmpty(names)) {
                message = this.importDef(obj, typeId.orElse(""));
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((FormDataTemplateManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\u62a5\u8868\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f", (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    @Override
    public List<ImportCheckResult> importCheck(FormDataTemplateXmlList list) {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        for (FormDataTemplateXml formDataTemplateXml : list.getFormDataTemplateXmlList()) {
            FormDataTemplate oformDataTemplate;
            FormDataTemplate formDataTemplate = formDataTemplateXml.getFormDataTemplate();
            if (!BeanUtils.isNotEmpty((Object)((Object)formDataTemplate)) || (oformDataTemplate = this.getByAlias(formDataTemplate.getAlias())) == null) continue;
            results.add(new ImportCheckResult(true, "\u8868\u5355\u5217\u8868", formDataTemplateXml.getFormDataTemplate().getName()));
        }
        return results;
    }

    protected FormDataTemplate getFormObject(String json) throws Exception {
        if (StringUtil.isEmpty((String)json)) {
            return null;
        }
        ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String displayField = obj.get("displayField").asText();
        String conditionField = obj.get("conditionField").asText();
        String sortField = obj.get("sortField").asText();
        String filterField = obj.get("filterField").asText();
        String manageField = obj.get("manageField").asText();
        String exportField = obj.get("exportField").asText();
        String treeField = obj.get("treeField").asText();
        String summaryField = obj.get("summaryField").asText();
        String remindSettingList = obj.get("remindSettingList").asText();
        String joinTables = JsonUtil.getString((JsonNode)obj, (String)"joinTables", (String)"");
        String summaryRegionHtml = obj.get("summaryRegionHtml").asText("");
        String joinQueryConfig = obj.get("joinQueryConfig").asText("");
        obj.remove("displayField");
        obj.remove("conditionField");
        obj.remove("sortField");
        obj.remove("filterField");
        obj.remove("manageField");
        obj.remove("treeField");
        obj.remove("summaryField");
        obj.remove("remindSettingList");
        obj.remove("joinTables");
        obj.remove("summaryRegionHtml");
        FormDataTemplate bpmDataTemplate = (FormDataTemplate)((Object)JsonUtil.toBean((JsonNode)obj, FormDataTemplate.class));
        bpmDataTemplate.setJoinQueryConfig(joinQueryConfig);
        bpmDataTemplate.setDisplayField(displayField);
        bpmDataTemplate.setConditionField(conditionField);
        bpmDataTemplate.setSortField(sortField);
        bpmDataTemplate.setFilterField(filterField);
        bpmDataTemplate.setManageField(manageField);
        bpmDataTemplate.setExportField(exportField);
        bpmDataTemplate.setTreeField(treeField);
        bpmDataTemplate.setSummaryField(summaryField);
        bpmDataTemplate.setRemindSettingList(remindSettingList);
        bpmDataTemplate.setJoinTables(joinTables);
        bpmDataTemplate.setSummaryRegionHtml(summaryRegionHtml);
        return bpmDataTemplate;
    }

    public static void checkXmlFormat(String xml) throws Exception {
        String firstName = "formDataTemplateXmlList";
        String nextName = "formDataTemplateXml";
        Document doc = Dom4jUtil.loadXml((String)xml);
        Element root = doc.getRootElement();
        String msg = "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9";
        if (!root.getName().equals(firstName)) {
            throw new Exception(msg);
        }
        List itemLists = root.elements();
        for (Element elm : itemLists) {
            if (elm.getName().equals(nextName)) continue;
            throw new Exception(msg);
        }
    }

    @Override
    public List<Map<String, String>> batchSave(List<String> ids) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List<FormDataTemplate> allList = this.getResetListByIds(ids);
        for (FormDataTemplate formDataTemplate : allList) {
            try {
                if (null == formDataTemplate.getTableConfigure() || "[]".equalsIgnoreCase(formDataTemplate.getTableConfigure())) {
                    formDataTemplate.setTableConfigure("{}");
                }
                this.handleEditButtonId(formDataTemplate);
                FormDataTemplateHtmlDto dataTemplateHtmlDto = this.generateTemplate(formDataTemplate, null);
                this.updateTemplateHtml(dataTemplateHtmlDto, formDataTemplate);
            }
            catch (Exception e) {
                e.printStackTrace();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", formDataTemplate.getName());
                map.put("alias", formDataTemplate.getAlias());
                map.put("error", "\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage());
                result.add(map);
            }
        }
        return result;
    }

    @Override
    public void updateTemplateHtml(FormDataTemplateHtmlDto dataTemplateHtmlDto, FormDataTemplate formDataTemplate) {
        formDataTemplate.setTemplateHtml(dataTemplateHtmlDto.getDataTemplateHtml());
        formDataTemplate.setMobileTemplateHtml(dataTemplateHtmlDto.getMoblieDataTemplateHtml());
        this.update((Model)formDataTemplate);
    }

    @Override
    public List<FormDataTemplate> getResetListByIds(List<String> ids) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        qw.in(FormDataTemplate::getId, ids);
        qw.eq(FormDataTemplate::getResetTemp, (Object)1);
        return this.list((Wrapper)qw);
    }

    @Override
    public void exportByBtnSetting(HttpServletResponse response, String id, DataTemplateQueryVo dataTemplateQueryVo) throws Exception {
        SXSSFWorkbook workbook;
        FormDataTemplate template = this.getById((Serializable)((Object)id));
        Assert.notNull((Object)((Object)template), (String)String.format("\u6839\u636e\u4e3b\u952e\u3010%s\u3011\u672a\u627e\u5230\u8868\u5355\u5217\u8868", id));
        Assert.hasText((String)template.getManageField(), (String)"\u5c1a\u672a\u914d\u7f6e\u5bfc\u51fa\u6309\u94ae\uff0c\u65e0\u6cd5\u5bfc\u51fa");
        ObjectNode exportBtn = (ObjectNode)this.dataTemplateSettingService.getManageFieldByButtonId(template, "export", null);
        Assert.notNull((Object)exportBtn, (String)"\u5c1a\u672a\u914d\u7f6e\u5bfc\u51fa\u6309\u94ae\uff0c\u65e0\u6cd5\u5bfc\u51fa");
        BoDef boDef = this.boDefService.getByAlias(template.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        boolean isReturn = this.handleQueryFilter(template, dataTemplateQueryVo, (PageList<Map<String, Object>>)new PageList(), boEnt);
        dataTemplateQueryVo.getQueryFilter().setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        ArrayList<Map<String, Object>> selectSqlMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> sheetList = new ArrayList<Map<String, Object>>();
        this.getExportFieldsAndSql(template, exportBtn, selectSqlMap, sheetList, dataTemplateQueryVo.getQueryFilter());
        if (BeanUtils.isEmpty(sheetList)) {
            throw new BaseException("\u8bf7\u914d\u7f6e\u5bfc\u51fa\u5b57\u6bb5");
        }
        XSSFWorkbook xSSFWorkbook = null;
        JsonNode exportTemplate = exportBtn.get("exportTemplate");
        String isFormatterData = JsonUtil.getString((JsonNode)exportBtn, (String)"formatterData", (String)"0");
        if (BeanUtils.isNotEmpty((Object)exportTemplate) && exportTemplate.size() > 0) {
            PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
            byte[] byArray = portalFeignService.getFileBytesById(exportTemplate.get(0).get("id").asText());
            xSSFWorkbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(byArray));
            workbook = new SXSSFWorkbook(xSSFWorkbook);
        } else {
            workbook = new SXSSFWorkbook();
            for (Map map : sheetList) {
                ExcelUtil.createSheetForMap((SXSSFWorkbook)workbook, (String)((String)map.get("title")), (int)20, (Map)((Map)map.get("rows")), null);
            }
        }
        if (!isReturn) {
            HashMap filedFormat = new HashMap();
            if (StringUtil.isNotEmpty((String)template.getDisplayField())) {
                ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)template.getDisplayField());
                for (JsonNode field : arrayNode) {
                    String displayFieldId;
                    if (!isFormatterData.equals("1")) continue;
                    HashMap<String, String> formatMap = new HashMap<String, String>();
                    if (BeanUtils.isNotEmpty((Object)field.get("formatterData"))) {
                        ArrayNode formatterData = (ArrayNode)field.get("formatterData");
                        for (JsonNode format : formatterData) {
                            formatMap.put(format.get("key_").asText(), format.get("value_").asText());
                        }
                    }
                    if (!BeanUtils.isNotEmpty(formatMap)) continue;
                    StringBuilder filedPath = new StringBuilder("t");
                    if (!boEnt.isExternal()) {
                        filedPath.append(boEnt.getFieldPrefix());
                    }
                    filedFormat.put(StringUtil.isNotEmpty((String)(displayFieldId = JsonUtil.getString((JsonNode)field, (String)"id"))) ? displayFieldId : filedPath + field.get("name").asText(), formatMap);
                }
            }
            String string = JsonUtil.getString((JsonNode)exportBtn, (String)"exportType", (String)"2");
            HashMap<String, List<Object>> entFkMap = new HashMap<String, List<Object>>();
            for (int i = 0; i < selectSqlMap.size(); ++i) {
                SXSSFRow row;
                String entName;
                BoEnt entByName;
                Map sqlMap = (Map)selectSqlMap.get(i);
                String title = sqlMap.get("title").toString();
                JsonNode[] boEnts = (JsonNode[])sqlMap.get("ents");
                JsonNode curEnt = boEnts[boEnts.length - 1];
                ArrayNode childEnts = JsonUtil.getArray((JsonNode)boEnts[boEnts.length - 1], (String)"childEnts");
                if (StringUtils.isNotEmpty((String)JsonUtil.getString((JsonNode)curEnt, (String)"id")) && BeanUtils.isNotEmpty((Object)(entByName = this.boDefService.getEntByName(entName = JsonUtil.getString((JsonNode)curEnt, (String)"name"))))) {
                    curEnt = JsonUtil.toJsonNode((Object)entByName);
                }
                String querySql = sqlMap.get("sql").toString();
                SXSSFSheet sXSSFSheet = workbook.getSheet(title);
                if (xSSFWorkbook != null) {
                    XSSFSheet sheet = xSSFWorkbook.getSheet(title);
                    if (sheet == null) {
                        throw new BaseException(String.format("\u5bfc\u51fa\u6a21\u677f\u4e2d\u672a\u627e\u5230\u540d\u4e3a\u3010%s\u3011\u7684sheet\u9875\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u4e0a\u4f20\u6a21\u677f", title));
                    }
                    row = sheet.getRow(1);
                } else {
                    row = sXSSFSheet.getRow(1);
                }
                HashMap<String, Map<String, String>> exportFiledFormat = new HashMap<String, Map<String, String>>();
                Map exportFormatterMaps = (Map)((Map)sheetList.get(i)).get("formatterMaps");
                if (BeanUtils.isNotEmpty((Object)exportFormatterMaps)) {
                    for (String s2 : exportFormatterMaps.keySet()) {
                        if (!filedFormat.containsKey(s2)) continue;
                        exportFiledFormat.put((String)exportFormatterMaps.get(s2), (Map<String, String>)filedFormat.get(s2));
                    }
                }
                if (BeanUtils.isEmpty(exportFiledFormat)) {
                    exportFiledFormat = filedFormat;
                }
                List<DisplayField> displayFields = this.dataTemplateSettingService.getDisplayFields(template);
                QueryFilter filter = (QueryFilter)sqlMap.get("filter");
                Map exportFileds = (Map)((Map)sheetList.get(i)).get("rows");
                if ("2".equals(string) && boEnts.length > 1) {
                    List fkList = (List)entFkMap.get(boEnts[boEnts.length - 2].get("desc").asText());
                    if (BeanUtils.isEmpty((Object)fkList)) continue;
                    int size = 0;
                    AtomicInteger subTotalCount = new AtomicInteger(0);
                    while (size < fkList.size()) {
                        int preIndex = size;
                        size = fkList.size() - preIndex < 20000 ? fkList.size() : (size += 20000);
                        this.repeatSelectSubDataByRefId(sXSSFSheet, (Row)row, querySql, filter, exportFileds, entFkMap, curEnt, exportFiledFormat, fkList.subList(preIndex, size), subTotalCount, dsName, displayFields);
                    }
                    continue;
                }
                HashMap<String, Object> nameAttributeMap = new HashMap<String, Object>();
                if (!childEnts.isEmpty()) {
                    List joinTableNames = (List)((Map)sheetList.get(i)).get("joinTableNames");
                    for (JsonNode childEnt : childEnts) {
                        String tableName = JsonUtil.getString((JsonNode)childEnt, (String)"tableName");
                        boolean anyMatch = joinTableNames.stream().anyMatch(s -> s.equalsIgnoreCase(tableName));
                        if (!anyMatch) continue;
                        ArrayNode attributeList = (ArrayNode)childEnt.get("attributeList");
                        try {
                            for (JsonNode jsonNode : attributeList) {
                                BoAttribute boAttribute = (BoAttribute)JsonUtil.toBean((JsonNode)jsonNode, BoAttribute.class);
                                nameAttributeMap.put(tableName + boAttribute.getName(), boAttribute);
                                nameAttributeMap.put(tableName + boAttribute.getFieldName(), boAttribute);
                            }
                        }
                        catch (Exception e) {
                            this.logger.error("\u8f6c\u6362BoAttribute\u5931\u8d25");
                        }
                    }
                }
                int page = 1;
                for (int limit = JsonUtil.getInt((JsonNode)exportBtn, (String)"limit", (int)10000); limit > 0; limit -= 50000) {
                    filter.getPageBean().setPage(page);
                    filter.getPageBean().setPageSize(Math.min(limit, 50000));
                    long totalCount = this.repeatSelect(sXSSFSheet, (Row)row, string, querySql, filter, exportFileds, entFkMap, curEnt, exportFiledFormat, null, dsName, displayFields, nameAttributeMap);
                    if (totalCount == -1L) {
                        limit = -1;
                    }
                    this.logger.info("\u5faa\u73af\u5bfc\u51fa\u7b2c{}\u6b21", (Object)page);
                    ++page;
                }
            }
        }
        ExcelUtil.downloadExcel((Workbook)workbook, (String)(template.getName() + "_\u5bfc\u51fa\u6570\u636e"), (HttpServletResponse)response);
    }

    private boolean handleQueryFilter(FormDataTemplate template, DataTemplateQueryVo dataTemplateQueryVo, PageList<Map<String, Object>> returnData, BoEnt boEnt) throws Exception {
        QueryFilter<?> queryFilter = dataTemplateQueryVo.getQueryFilter();
        if (queryFilter == null) {
            queryFilter = QueryFilter.build();
            dataTemplateQueryVo.setQueryFilter((QueryFilter)queryFilter);
        }
        String dbType = StringUtil.isNotEmpty((String)boEnt.getDsName()) ? this.databaseContext.getDbTypeByAlias(boEnt.getDsName()) : SQLUtil.getDbType();
        if (template.getNeedPage() == 1 && BeanUtils.isEmpty((Object)queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(30), Boolean.valueOf(true)));
        }
        returnData.setRows(new ArrayList());
        if (BeanUtils.isNotEmpty((Object)AuthenticationUtil.getUserThreadLocal())) {
            AuthenticationUtil.setAuthentication((Authentication)SecurityContextHolder.getContext().getAuthentication());
        }
        if (BeanUtils.isNotEmpty(dataTemplateQueryVo.getSelectList())) {
            List<SelectParam> selectList = dataTemplateQueryVo.getSelectList();
            Iterator conditionsMap = Maps.newHashMap();
            for (SelectParam ignored : selectList) {
                JsonNode jsonNode;
                String conditions = template.getConditionField();
                if (!StringUtil.isNotEmpty((String)conditions) || !BeanUtils.isNotEmpty((Object)(jsonNode = JsonUtil.toJsonNode((String)conditions)))) continue;
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                arrayNode.forEach(item -> {
                    if (item.get("name") != null) {
                        conditionsMap.put(JsonUtil.getString((JsonNode)item, (String)"queryPre", (String)"") + item.get("name").asText(), item);
                    }
                });
            }
            for (SelectParam selectParam : selectList) {
                if (StringUtil.isEmpty((String)selectParam.getSelectValue()) || !conditionsMap.containsKey(selectParam.getBindSelectd())) continue;
                JsonNode conditionNode = (JsonNode)conditionsMap.get(selectParam.getBindSelectd());
                String operate = JsonUtil.getString((JsonNode)conditionNode, (String)"qt", (String)"");
                if (!StringUtil.isNotEmpty((String)selectParam.getBindSelectd()) || !StringUtil.isNotEmpty((String)operate)) continue;
                queryFilter.addFilter(selectParam.getBindSelectd(), (Object)selectParam.getSelectValue(), QueryOP.valueOf((String)operate));
            }
        }
        if ("postgresql".equals(dbType)) {
            List boAttrList = boEnt.getBoAttrList();
            for (Object query : queryFilter.getQuerys()) {
                if (!query.getClass().isAssignableFrom(QueryField.class)) continue;
                QueryField queryField = (QueryField)query;
                String property = queryField.getProperty();
                for (BoAttribute boAttribute : boAttrList) {
                    if ((boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) && "date".equals(boAttribute.getDataType()) && QueryOP.BETWEEN.equals((Object)queryField.getOperation()) && queryField.getValue().getClass() == ArrayList.class) {
                        ArrayList value = (ArrayList)queryField.getValue();
                        ArrayList<Date> newVal = new ArrayList<Date>();
                        for (int i2 = 0; i2 < value.size(); ++i2) {
                            if (StringUtil.isNotEmpty((String)((String)value.get(i2)))) {
                                newVal.add(DateFormatUtil.parseDate((String)((String)value.get(i2)), (String)"yyyy-MM-dd HH:mm:ss"));
                                continue;
                            }
                            newVal.add(null);
                        }
                        queryField.setValue(newVal);
                        continue;
                    }
                    if (!(boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) || !"date".equals(boAttribute.getDataType()) || queryField.getValue().getClass() == ArrayList.class || !StringUtil.isNotEmpty((String)((String)queryField.getValue()))) continue;
                    queryField.setValue((Object)DateFormatUtil.parseDate((String)((String)queryField.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
        }
        if ("oracle".equals(dbType) || "dm".equals(dbType)) {
            List queryFields = queryFilter.getQuerys();
            for (Object query : queryFields) {
                BoAttribute boAttribute = boEnt.getBoAttributeByName(query.getProperty().replace("t.", ""));
                if (!BeanUtils.isNotEmpty((Object)boAttribute)) continue;
                if ("clob".equals(boAttribute.getDataType()) && StringUtil.isNotEmpty((String)boAttribute.getName())) {
                    query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                    continue;
                }
                if (!"date".equals(boAttribute.getDataType()) || !StringUtil.isNotEmpty((String)boAttribute.getName())) continue;
                try {
                    String format = boAttribute.getFormat();
                    String value = query.getValue().toString();
                    if ("yyyy-MM-dd HH:mm:ss".equals(format) && com.hotent.base.util.time.DateUtil.isRqFormat((String)value)) {
                        query.setValue((Object)(value + " 00:00:00"));
                    }
                    this.setQueryTimeProperty((QueryField)query, format);
                }
                catch (Exception e) {
                    query.setProperty("1");
                    query.setOperation(QueryOP.EQUAL);
                    query.setValue((Object)"-1");
                }
            }
        }
        String dsName = boEnt.getDsName();
        this.handleSubDate((QueryFilter)queryFilter, template.getJoinTables(), dsName);
        Iterator it = queryFilter.getQuerys().iterator();
        while (it.hasNext()) {
            String property;
            QueryField flowObj = (QueryField)it.next();
            if (ArrayUtils.contains((Object[])FLOW_FIELD, (Object)flowObj.getProperty())) {
                if (flowObj.getValue() != null) {
                    it.remove();
                } else {
                    it.remove();
                }
            }
            if (!(property = flowObj.getProperty()).startsWith("$TREE$")) continue;
            String newproperty = property;
            newproperty = boEnt.getIsExternal() == 0 ? property.replaceFirst("\\$TREE\\$", "F_") : property.replaceFirst("\\$TREE\\$", "");
            flowObj.setProperty(newproperty);
        }
        if (dataTemplateQueryVo.isJoinFlow()) {
            String pk = "id_";
            if (StringUtil.isNotEmpty((String)boEnt.getPk())) {
                pk = boEnt.getPk();
            }
            ObjectNode nodes = JsonUtil.getMapper().createObjectNode();
            nodes.put("defKey", dataTemplateQueryVo.getDefKey());
            nodes.put("taskType", dataTemplateQueryVo.getTaskType());
            List listIds = this.bpmRuntimeFeignService.getBusLink(nodes);
            if (!listIds.isEmpty()) {
                queryFilter.addFilter(pk, (Object)listIds, QueryOP.IN);
            } else {
                return true;
            }
        }
        if (BeanUtils.isNotEmpty((Object)queryFilter.getSorter())) {
            String colPrefix = boEnt.isExternal() ? "" : "F_";
            List sorter = queryFilter.getSorter();
            if (sorter != null) {
                sorter.forEach(i -> {
                    if (!(i.getProperty().equalsIgnoreCase(BoEnt.PK_NAME) || i.getProperty().equalsIgnoreCase(BoEnt.FK_NAME) || i.getProperty().contains("."))) {
                        i.setProperty(colPrefix + i.getProperty());
                    }
                });
            }
        }
        queryFilter = this.getTemplateQueryFilter(queryFilter, template);
        return false;
    }

    private void repeatSelectSubDataByRefId(SXSSFSheet sXSSFSheet, Row row, String querySql, QueryFilter filter, Map<String, String> exportFileds, Map<String, List<Object>> entFkMap, JsonNode curEnt, Map<String, Map<String, String>> filedFormat, List<Object> fkList, AtomicInteger subTotalCount, String dsName, List<DisplayField> displayFields) {
        StringBuilder fkBuffer = new StringBuilder(" where ");
        fkBuffer.append(curEnt.get("fk").asText()).append(" in (");
        boolean isCharFk = false;
        if (fkList.get(0) instanceof String) {
            isCharFk = true;
        }
        for (int j = 0; j < fkList.size(); ++j) {
            Object object = fkList.get(j);
            if (j > 0) {
                fkBuffer.append(",");
            }
            if (isCharFk) {
                fkBuffer.append("'").append(object).append("'");
                continue;
            }
            fkBuffer.append(object);
        }
        fkBuffer.append(")");
        int limit = 1;
        int page = 1;
        while (limit > 0) {
            filter.getPageBean().setPage(page);
            filter.getPageBean().setPageSize(50000);
            long totalCount = this.repeatSelect(sXSSFSheet, row, "2", querySql + fkBuffer, filter, exportFileds, entFkMap, curEnt, filedFormat, subTotalCount, dsName, displayFields, new HashMap<String, Object>());
            if (totalCount == -1L) {
                limit = -1;
            }
            System.err.println("\u5faa\u73af\u5bfc\u51fa\u7b2c\uff1a" + page + "\u6b21");
            ++page;
        }
    }

    private long repeatSelect(SXSSFSheet sXSSFSheet, Row row, String exportType, String querySql, QueryFilter filter, Map<String, String> exportFileds, Map<String, List<Object>> entFkMap, JsonNode curEnt, Map<String, Map<String, String>> filedFormat, AtomicInteger subTotalCount, String dsName, List<DisplayField> displayFields, Map<String, Object> nameAttributeMap) {
        PageList query = (PageList)this.databaseContext.switchDS(dsName, () -> this.commonManager.queryByCustomSql(querySql, filter), e -> {
            throw new BaseException((Throwable)e);
        });
        if (curEnt.has("attributeList")) {
            ArrayNode attributeList = (ArrayNode)curEnt.get("attributeList");
            String tableName = curEnt.get("tableName").asText();
            try {
                for (JsonNode jsonNode : attributeList) {
                    BoAttribute boAttribute = (BoAttribute)JsonUtil.toBean((JsonNode)jsonNode, BoAttribute.class);
                    nameAttributeMap.put("t" + boAttribute.getName(), boAttribute);
                    nameAttributeMap.put(tableName + boAttribute.getName(), boAttribute);
                    nameAttributeMap.put("t" + boAttribute.getFieldName(), boAttribute);
                    nameAttributeMap.put(tableName + boAttribute.getFieldName(), boAttribute);
                }
            }
            catch (Exception e2) {
                this.logger.error("\u8f6c\u6362BoAttribute\u5931\u8d25");
            }
        }
        if (BeanUtils.isEmpty((Object)query) || BeanUtils.isEmpty((Object)query.getRows())) {
            return -1L;
        }
        int excelWriteStartIndex = 1 + (filter.getPageBean().getPage() - 1) * 50000;
        if ("2".equals(exportType)) {
            List<Object> fkList = entFkMap.get(curEnt.get("desc").asText());
            if (BeanUtils.isEmpty(fkList)) {
                fkList = new ArrayList<Object>();
            }
            for (Map map : query.getRows()) {
                fkList.add(MapUtil.getStringIgnoreKey((Map)map, (String)("t" + curEnt.get("pkKey").asText()), (String)""));
            }
            entFkMap.put(curEnt.get("desc").asText(), fkList);
            if (exportFileds.keySet().size() <= 0) {
                return query.getTotal();
            }
            if (subTotalCount != null) {
                excelWriteStartIndex = 1 + subTotalCount.get();
            }
        }
        this.formatData(query.getRows(), nameAttributeMap);
        this.decryptResult(displayFields, query.getRows(), field -> "t" + field.getOldTableField());
        if (sXSSFSheet != null) {
            ExcelUtil.appendRow((List)query.getRows(), filedFormat, (SXSSFSheet)sXSSFSheet, (Row)row, exportFileds, (int)excelWriteStartIndex);
            if (subTotalCount != null) {
                subTotalCount.getAndAdd(query.getRows().size());
            }
        }
        if (query.getRows().size() < filter.getPageBean().getPageSize()) {
            return -1L;
        }
        return query.getTotal();
    }

    private void formatData(List<Map<String, Object>> data, Map<String, Object> nameAttributeMap) {
        for (Map<String, Object> map : data) {
            for (String s : map.keySet()) {
                if (!MapUtil.containsIgnoreKey(nameAttributeMap, (String)s)) continue;
                BoAttribute attr = (BoAttribute)MapUtil.getIgnoreCase(nameAttributeMap, (String)s);
                Object val = map.get(s);
                if ("date".equals(attr.getDataType())) {
                    LocalDateTime dateTime;
                    ZoneId defaultZoneId;
                    Comparable<Date> res;
                    LocalDate localDate;
                    java.sql.Date sqlDate;
                    Timestamp times;
                    String format = attr.getFormat();
                    if ("yyyy-MM-dd".equals(format)) {
                        if (val instanceof Timestamp) {
                            times = (Timestamp)val;
                            map.put(s, times.toLocalDateTime().toLocalDate());
                            continue;
                        }
                        if (val instanceof java.sql.Date) {
                            sqlDate = (java.sql.Date)val;
                            localDate = sqlDate.toLocalDate();
                            map.put(s, localDate);
                            continue;
                        }
                        if (val instanceof Date) {
                            res = (Date)val;
                            defaultZoneId = ZoneId.systemDefault();
                            dateTime = LocalDateTime.ofInstant(((Date)res).toInstant(), defaultZoneId);
                            map.put(s, dateTime.toLocalDate());
                            continue;
                        }
                        if (!(val instanceof LocalDateTime)) continue;
                        res = (LocalDateTime)val;
                        map.put(s, ((LocalDateTime)res).toLocalDate());
                        continue;
                    }
                    if (val instanceof Timestamp) {
                        times = (Timestamp)val;
                        map.put(s, times.toLocalDateTime());
                        continue;
                    }
                    if (val instanceof java.sql.Date) {
                        sqlDate = (java.sql.Date)val;
                        localDate = sqlDate.toLocalDate();
                        map.put(s, localDate);
                        continue;
                    }
                    if (val instanceof Date) {
                        res = (Date)val;
                        defaultZoneId = ZoneId.systemDefault();
                        dateTime = LocalDateTime.ofInstant(((Date)res).toInstant(), defaultZoneId);
                        map.put(s, dateTime);
                        continue;
                    }
                    res = (LocalDateTime)val;
                    map.put(s, res);
                    continue;
                }
                if ("number".equals(attr.getDataType())) {
                    if (!(val instanceof String)) continue;
                    map.put(s, Double.valueOf((String)val));
                    continue;
                }
                if (!"int".equals(attr.getDataType()) || !(val instanceof String)) continue;
                map.put(s, Integer.valueOf((String)val));
            }
        }
    }

    private void pushExportSettingFields(ArrayNode exportSettingFields, JsonNode display, String mainFiledPath) {
        if (display.has("children") && BeanUtils.isNotEmpty((Object)display.get("children"))) {
            ArrayNode childrens = (ArrayNode)display.get("children");
            for (JsonNode cnode : childrens) {
                this.pushExportSettingFields(exportSettingFields, cnode, mainFiledPath);
            }
        } else if (!JsonUtil.getBoolean((ObjectNode)((ObjectNode)display), (String)"isFlowField", (boolean)true)) {
            ObjectNode node = JsonUtil.createObjectNode();
            node.put("name", display.get("name").asText());
            if (StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)display, (String)"oldTableField"))) {
                String oldTableField = JsonUtil.getString((JsonNode)display, (String)"oldTableField");
                String tableName = JsonUtil.getString((JsonNode)display, (String)"tableName");
                node.put("path", "t." + oldTableField);
                node.put("displayId", (tableName + oldTableField).toLowerCase().replaceAll("_", ""));
            } else {
                node.put("path", mainFiledPath + display.get("name").asText());
                node.put("displayId", display.get("name").asText());
            }
            node.put("desc", display.get("desc").asText());
            node.put("type", display.get("type").asText());
            node.put("defaultSort", "0");
            node.put("isExport", "1");
            exportSettingFields.add((JsonNode)node);
        }
    }

    private void getExportFieldsAndSql(FormDataTemplate dataTemplate, ObjectNode exportBtn, List<Map<String, Object>> selectSql, List<Map<String, Object>> sheetList, QueryFilter filter) throws Exception {
        String dsName;
        BoDef byAlias = this.boDefService.getByAlias(dataTemplate.getBoDefAlias());
        ObjectNode mainBoEnt = (ObjectNode)JsonUtil.toJsonNode((Object)byAlias.getBoEnt());
        String exportType = JsonUtil.getString((JsonNode)exportBtn, (String)"exportType", (String)"2");
        ArrayNode exportSettingFields = JsonUtil.createArrayNode();
        if (BeanUtils.isNotEmpty((Object)exportBtn.get("exportSettingFields"))) {
            exportSettingFields = (ArrayNode)JsonUtil.toJsonNode((String)Base64.getFromBase64((String)exportBtn.get("exportSettingFields").asText()));
        } else {
            ArrayNode displayField = (ArrayNode)JsonUtil.toJsonNode((String)dataTemplate.getDisplayField());
            String mainFiledPath = "t.";
            if (!byAlias.getBoEnt().isExternal()) {
                mainFiledPath = mainFiledPath + BoEnt.FIELD_PREFIX;
            }
            for (JsonNode display : displayField) {
                if (display.has("children") && BeanUtils.isNotEmpty((Object)display.get("children"))) {
                    ArrayNode childrens = (ArrayNode)display.get("children");
                    for (JsonNode cnode : childrens) {
                        this.pushExportSettingFields(exportSettingFields, cnode, mainFiledPath);
                    }
                    continue;
                }
                this.pushExportSettingFields(exportSettingFields, display, mainFiledPath);
            }
        }
        ArrayNode exportSubFields = null;
        if (BeanUtils.isNotEmpty((Object)exportBtn.get("exportSubFields")) && "1".equals(JsonUtil.getString((JsonNode)exportBtn, (String)"exportSub", (String)"2"))) {
            exportSubFields = (ArrayNode)JsonUtil.toJsonNode((String)Base64.getFromBase64((String)exportBtn.get("exportSubFields").asText()));
        }
        if (StringUtil.isEmpty((String)(dsName = byAlias.getBoEnt().getDsName()))) {
            dsName = "LOCAL";
        }
        String filterSql = this.getFilterSql(dataTemplate.getFilterField(), dsName, new HashMap<String, Object>(), byAlias.getBoEnt(), dataTemplate);
        if (exportSubFields != null) {
            if ("2".equals(exportType)) {
                this.putExportHeaderToList(sheetList, exportSettingFields, selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt});
                for (JsonNode subNode : exportSubFields) {
                    this.putExportHeaderToList(sheetList, (ArrayNode)subNode.get("attributeList"), selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt, subNode});
                    if (!BeanUtils.isNotEmpty((Object)subNode.get("childEnts"))) continue;
                    for (JsonNode sunNode : subNode.get("childEnts")) {
                        this.putExportHeaderToList(sheetList, (ArrayNode)sunNode.get("attributeList"), selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt, subNode, sunNode});
                    }
                }
            } else {
                for (JsonNode subNode : exportSubFields) {
                    int isExternal = JsonUtil.getInt((JsonNode)subNode, (String)"isExternal");
                    if (isExternal == 1) {
                        throw new BaseException("\u5916\u90e8\u5b50\u8868\u4e0d\u652f\u6301\u8054\u5408\u5bfc\u51fa");
                    }
                    ArrayNode subFileds = (ArrayNode)subNode.get("attributeList");
                    if (BeanUtils.isNotEmpty((Object)subNode.get("childEnts"))) {
                        boolean isSunTableHasExport = false;
                        for (JsonNode sunNode : subNode.get("childEnts")) {
                            ArrayNode sunFileds = (ArrayNode)sunNode.get("attributeList");
                            if (!BeanUtils.isNotEmpty((Object)this.getExportFileds(sunFileds))) continue;
                            ArrayNode tempNode = JsonUtil.createArrayNode();
                            tempNode.addAll(exportSettingFields).addAll(subFileds).addAll(sunFileds);
                            this.putExportHeaderToList(sheetList, tempNode, selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt, subNode, sunNode});
                            isSunTableHasExport = true;
                        }
                        if (isSunTableHasExport || !BeanUtils.isNotEmpty((Object)this.getExportFileds(subFileds))) continue;
                        ArrayNode tempNode = JsonUtil.createArrayNode();
                        tempNode.addAll(exportSettingFields).addAll(subFileds);
                        this.putExportHeaderToList(sheetList, tempNode, selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt, subNode});
                        continue;
                    }
                    if (!BeanUtils.isNotEmpty((Object)this.getExportFileds(subFileds))) continue;
                    ArrayNode tempNode = JsonUtil.createArrayNode();
                    tempNode.addAll(exportSettingFields).addAll(subFileds);
                    this.putExportHeaderToList(sheetList, tempNode, selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt, subNode});
                }
                if (BeanUtils.isEmpty(sheetList)) {
                    this.putExportHeaderToList(sheetList, exportSettingFields, selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt});
                }
            }
        } else {
            this.putExportHeaderToList(sheetList, exportSettingFields, selectSql, filterSql, filter, exportType, dataTemplate.getJoinTables(), new JsonNode[]{mainBoEnt});
        }
    }

    private ArrayNode getExportFileds(ArrayNode fields) {
        ArrayNode arrayNode = JsonUtil.createArrayNode();
        for (JsonNode field : fields) {
            if (!"1".equals(JsonUtil.getString((JsonNode)field, (String)"isExport", (String)""))) continue;
            arrayNode.add(field);
        }
        return arrayNode;
    }

    private void putExportHeaderToList(List<Map<String, Object>> sheetList, ArrayNode fileds, List<Map<String, Object>> selectSql, String filterSql, QueryFilter filter, String exportType, String joinTables, JsonNode ... boEnts) throws Exception {
        String currentName;
        String currentTableName;
        QueryFilter cloneFilter = (QueryFilter)JsonUtil.toBean((String)JsonUtil.toJson((Object)filter), QueryFilter.class);
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> exportFormatterMaps = new LinkedHashMap<String, String>();
        HashSet<String> descSet = new HashSet<String>();
        JsonNode jsonNode = boEnts[boEnts.length - 1];
        String sheetName = jsonNode.get("desc").asText();
        ObjectNode beforeEnt = (ObjectNode)JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)boEnts[0]));
        String mainTableName = beforeEnt.get("tableName").asText();
        StringBuffer sqlSb = new StringBuffer("select ");
        ArrayList<FieldSort> sorts = new ArrayList<FieldSort>();
        boolean hasPk = false;
        String pkKey = JsonUtil.getString((JsonNode)jsonNode, (String)"pkKey", (String)"");
        String pkKeyPath = "";
        for (JsonNode field : fileds) {
            String path;
            String oldTableField = JsonUtil.getString((JsonNode)field, (String)"oldTableField");
            String tableName = JsonUtil.getString((JsonNode)field, (String)"tableName");
            if (StringUtil.isNotEmpty((String)oldTableField)) {
                if (tableName.equalsIgnoreCase(mainTableName)) {
                    tableName = "t";
                }
                path = tableName + "." + oldTableField;
                pkKeyPath = tableName + "." + pkKey;
            } else {
                path = JsonUtil.getString((JsonNode)field, (String)"path", (String)JsonUtil.getString((JsonNode)field, (String)"name"));
                if ("2".equals(exportType)) {
                    int index = path.indexOf(".");
                    path = "t" + (index == -1 ? "." + path : path.substring(path.indexOf(".")));
                    pkKeyPath = "t." + pkKey;
                }
            }
            if ("1".equals(JsonUtil.getString((JsonNode)field, (String)"isExport"))) {
                String desc = field.get("desc").asText();
                if (descSet.contains(desc)) {
                    desc = desc + "(" + sheetName + ")";
                } else {
                    descSet.add(desc);
                }
                sqlSb.append(path).append(" As \"").append(path.replaceAll("\\.", "")).append("\",");
                exportMaps.put(path, desc);
                if (StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)field, (String)"displayId"))) {
                    exportFormatterMaps.put(JsonUtil.getString((JsonNode)field, (String)"displayId"), path.replaceAll("\\.", ""));
                } else {
                    String name = StringUtil.isNotEmpty((String)oldTableField) ? (tableName + oldTableField).toLowerCase().replaceAll("_", "") : field.get("name").asText();
                    exportFormatterMaps.put(name, path.replaceAll("\\.", ""));
                }
            } else if (StringUtil.isNotEmpty((String)pkKey) && pkKey.equalsIgnoreCase(JsonUtil.getString((JsonNode)field, (String)"oldTableField", (String)""))) {
                String desc = field.get("desc").asText();
                if (descSet.contains(desc)) {
                    desc = desc + "(" + sheetName + ")";
                } else {
                    descSet.add(desc);
                }
                sqlSb.append(path).append(" As \"").append(path.replaceAll("\\.", "")).append("\",");
            }
            if ("1".equals(JsonUtil.getString((JsonNode)field, (String)"defaultSort"))) {
                sorts.add(new FieldSort(path, Direction.fromString((String)field.get("sortSeq").asText().toUpperCase())));
            }
            if (!pkKey.equalsIgnoreCase(path.substring(path.indexOf(".") + 1))) continue;
            hasPk = true;
        }
        if (!hasPk) {
            sqlSb.append(pkKeyPath).append(" As \"").append(pkKeyPath.replaceAll("\\.", "")).append("\"");
        } else {
            sqlSb = new StringBuffer(sqlSb.subSequence(0, sqlSb.length() - 1));
        }
        sqlSb.append(" from ");
        if ("2".equals(exportType)) {
            sqlSb.append(jsonNode.get("tableName").asText() + " t");
            currentTableName = jsonNode.get("tableName").asText();
            currentName = jsonNode.get("name").asText();
        } else {
            sqlSb.append(beforeEnt.get("tableName").asText() + " t");
            currentTableName = beforeEnt.get("tableName").asText();
            currentName = beforeEnt.get("name").asText();
        }
        HashMap existMap = Maps.newHashMap();
        beforeEnt.put("tableName", " t");
        if (!"2".equals(exportType)) {
            for (int i = 1; i < boEnts.length; ++i) {
                JsonNode ent = boEnts[i];
                sqlSb.append(" left join ").append(ent.get("tableName").asText()).append(" on ");
                sqlSb.append(beforeEnt.get("tableName").asText()).append(".").append(beforeEnt.get("pkKey").asText()).append(" = ");
                sqlSb.append(ent.get("tableName").asText()).append(".").append(ent.get("fk").asText());
                beforeEnt = (ObjectNode)ent;
                existMap.put(ent.get("tableName").asText(), null);
            }
        }
        if (BeanUtils.isEmpty(exportMaps)) {
            return;
        }
        String sql = sqlSb.toString();
        ArrayList joinTableNames = new ArrayList();
        if (StringUtil.isNotEmpty((String)joinTables) && currentTableName.equalsIgnoreCase(mainTableName)) {
            StringBuffer joinStatement = new StringBuffer();
            JsonNode joinTable = JsonUtil.toJsonNode((String)joinTables);
            joinTable.forEach(item -> {
                String join = JsonUtil.getString((JsonNode)item, (String)"join");
                joinTableNames.add(join);
                if (MapUtil.containsIgnoreKey((Map)existMap, (String)join)) {
                    return;
                }
                joinStatement.append(" left join ").append(join).append(" ");
            });
            sqlSb.append(joinStatement);
            sql = this.handleOnQueryStatement((ArrayNode)joinTable, sqlSb.toString(), this.databaseContext.getDbType(), mainTableName);
        }
        if (!currentTableName.equalsIgnoreCase(mainTableName)) {
            cloneFilter.setQuerys(new ArrayList());
        }
        if (StringUtil.isNotEmpty((String)filterSql) && (!"2".equals(exportType) || boEnts.length == 1)) {
            cloneFilter.withParam("filterSql", (Object)filterSql);
        }
        cloneFilter.setSorter(sorts);
        LinkedHashMap<String, Object> sqlMap = new LinkedHashMap<String, Object>();
        sqlMap.put("title", sheetName + "(" + currentName + ")");
        sqlMap.put("sql", sql);
        sqlMap.put("filter", cloneFilter);
        sqlMap.put("ents", boEnts);
        selectSql.add(sqlMap);
        HashMap<String, Object> sheet = new HashMap<String, Object>();
        sheet.put("title", sheetName + "(" + currentName + ")");
        sheet.put("rows", exportMaps);
        sheet.put("formatterMaps", exportFormatterMaps);
        sheet.put("joinTableNames", joinTableNames);
        sheetList.add(sheet);
    }

    @Override
    public Map<String, Object> bindRelation(String templateKey) {
        FormDataTemplate template = this.getByAlias(templateKey);
        if (BeanUtils.isEmpty((Object)((Object)template))) {
            throw new BaseException("\u62a5\u8868\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String flowKey = template.getDefId();
        if (StringUtil.isNotEmpty((String)flowKey)) {
            BpmModelFeignService feignService = (BpmModelFeignService)AppUtil.getBean(BpmModelFeignService.class);
            ObjectNode procDefByDefKey = feignService.getProcDefByDefKey(flowKey);
            result.put("flow", procDefByDefKey);
        }
        String boDefAlias = template.getBoDefAlias();
        BoDef boDef = this.boDefService.getByAlias(boDefAlias);
        result.put("boDef", boDef);
        Form form = this.formManager.getMainByFormKey(template.getFormKey());
        result.put("form", (Object)form);
        if (StringUtil.isNotEmpty((String)template.getMobileFormAlias())) {
            Form mobileForm = this.formManager.getMainByFormKey(template.getMobileFormAlias());
            result.put("mobileForm", (Object)mobileForm);
        }
        return result;
    }

    @Override
    public void downloadDefaultExportTempByFormKey(HttpServletResponse response, String id) throws Exception {
        FormDataTemplate dataTemplate = this.getById((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)((Object)dataTemplate))) {
            throw new NotFoundException(String.format("\u6839\u636e\u4e3b\u952e\u3010%s\u3011\u672a\u627e\u5230\u8868\u5355\u5217\u8868", id));
        }
        Assert.hasText((String)dataTemplate.getManageField(), (String)"\u65e0\u6cd5\u4e0b\u8f7d\u5bfc\u51fa\u6a21\u677f\uff0c\u8bf7\u5148\u4fdd\u5b58\u5bfc\u51fa\u914d\u7f6e\u548c\u8868\u5355\u6570\u636e");
        ObjectNode exportBtn = (ObjectNode)this.dataTemplateSettingService.getManageFieldByButtonId(dataTemplate, "export", null);
        Assert.notNull((Object)exportBtn, (String)"\u65e0\u6cd5\u4e0b\u8f7d\u5bfc\u51fa\u6a21\u677f\uff0c\u8bf7\u5148\u4fdd\u5b58\u5bfc\u51fa\u914d\u7f6e\u548c\u8868\u5355\u6570\u636e");
        SXSSFWorkbook workbook = this.getDefaultExportWorkbook(dataTemplate, exportBtn);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)(dataTemplate.getName() + "_\u5bfc\u51fa\u6a21\u677f"), (HttpServletResponse)response);
    }

    private SXSSFWorkbook getDefaultExportWorkbook(FormDataTemplate dataTemplate, ObjectNode exportBtn) throws Exception {
        ArrayList<Map<String, Object>> selectSql = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> sheetList = new ArrayList<Map<String, Object>>();
        this.getExportFieldsAndSql(dataTemplate, exportBtn, selectSql, sheetList, QueryFilter.build());
        if (BeanUtils.isEmpty(sheetList)) {
            throw new BaseException("\u8bf7\u914d\u7f6e\u5bfc\u51fa\u5b57\u6bb5");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        int rowHeight = 20;
        for (Map map : sheetList) {
            Map exportFields = (Map)map.get("rows");
            ExcelUtil.createSheetForMap((SXSSFWorkbook)workbook, (String)((String)map.get("title")), (int)rowHeight, (Map)exportFields, null);
        }
        return workbook;
    }

    @Override
    public PageList<Map<String, Object>> getAuthDetailPage(QueryFilter<FormDataTemplate> queryFilter) {
        String id = queryFilter.getParams().get("id").toString();
        PageBean pageBean = queryFilter.getPageBean();
        String finalId = id;
        JsonNode user = (JsonNode)((UCFeignService)AppUtil.getBean(UCFeignService.class)).getUserById(id).getValue();
        String account = JsonUtil.getString((JsonNode)user, (String)"account");
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if ("admin".equals(account)) {
            id = JsonUtil.getString((JsonNode)user, (String)"fullname");
        }
        FieldSort fieldSort = new FieldSort("NAME_");
        queryFilter.setSorter(Collections.singletonList(fieldSort));
        IPage<Map<String, Object>> authDetailPage = ((FormDataTemplateDao)this.baseMapper).getAuthDetailPage(id, (IPage<FormDataTemplate>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FormDataTemplate>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        PageList pageList = new PageList(authDetailPage);
        List rows = pageList.getRows();
        pageList.setPageSize((long)pageBean.getPageSize().intValue());
        pageList.setPage((long)pageBean.getPage().intValue());
        if (pageList.getTotal() < (long)pageBean.getOffset()) {
            pageList.setRows(new ArrayList());
            return pageList;
        }
        ArrayList<Map> results = new ArrayList<Map>();
        for (int i = pageBean.getOffset(); (i < pageBean.getOffset() + pageBean.getPageSize() || pageBean.getPageSize() == -1) && i < rows.size(); ++i) {
            Map map = (Map)rows.get(i);
            if (!BeanUtils.isNotEmpty(this.getAuthMap(map, finalId))) continue;
            results.add(map);
        }
        pageList.setRows(results);
        return pageList;
    }

    private Map<String, Object> getAuthMap(Map<String, Object> map, String id) {
        try {
            if (SQLUtil.getDbType().equals("oracle")) {
                map.put("MANAGE_FIELD_", SQLUtil.ClobToString((Clob)((Clob)map.get("MANAGE_FIELD_"))));
                map.put("FILTER_FIELD_", SQLUtil.ClobToString((Clob)((Clob)map.get("FILTER_FIELD_"))));
            }
            String manageField = MapUtil.getString(map, (String)"MANAGE_FIELD_");
            JsonNode manageFieldsNode = JsonUtil.toJsonNode((String)manageField);
            for (JsonNode node : manageFieldsNode) {
                JsonNode right = JsonUtil.toJsonNode((String)JsonUtil.getString((JsonNode)node, (String)"right"));
                for (JsonNode jsonNode : right) {
                    String ids = JsonUtil.getString((JsonNode)jsonNode, (String)"id");
                    if (!Arrays.asList(ids.split(",")).contains(id)) continue;
                    return map;
                }
            }
            String filterFields = MapUtil.getString(map, (String)"FILTER_FIELD_");
            JsonNode filterFieldsNode = JsonUtil.toJsonNode((String)filterFields);
            for (JsonNode node : filterFieldsNode) {
                JsonNode right = JsonUtil.toJsonNode((String)JsonUtil.getString((JsonNode)node, (String)"right"));
                for (JsonNode jsonNode : right) {
                    String ids = JsonUtil.getString((JsonNode)jsonNode, (String)"id");
                    if (!Arrays.asList(ids.split(",")).contains(id)) continue;
                    return map;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> copeOrTransferAuth(List<Map<String, String>> list) {
        List aliasList = list.stream().map(map -> (String)map.get("ALIAS_")).collect(Collectors.toList());
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ALIAS_", aliasList, QueryOP.IN);
        List formDataTemplateList = this.queryNoPage(queryFilter);
        ArrayList<FormDataTemplate> updateList = new ArrayList<FormDataTemplate>();
        for (Map<String, String> map2 : list) {
            String alias = map2.get("ALIAS_");
            List formDataTemplates = formDataTemplateList.stream().filter(formDataTemplate -> formDataTemplate.getAlias().equals(alias)).collect(Collectors.toList());
            if (!BeanUtils.isNotEmpty(formDataTemplates)) continue;
            FormDataTemplate formDataTemplate2 = (FormDataTemplate)((Object)formDataTemplates.get(0));
            if (map2.containsKey("MANAGE_FIELD_")) {
                formDataTemplate2.setManageField(map2.get("MANAGE_FIELD_"));
            }
            if (map2.containsKey("FILTER_FIELD_")) {
                formDataTemplate2.setFilterField(map2.get("FILTER_FIELD_"));
            }
            updateList.add(formDataTemplate2);
        }
        boolean result = this.updateBatchById(updateList);
        this.batchDelCacheByIds(updateList.stream().map(FormDataTemplate::getId).collect(Collectors.joining(",")));
        return new CommonResult(result, result ? "\u4fee\u6539\u6210\u529f" : "\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public CommonResult<Object> joinCheckSql(ObjectNode obj) throws Exception {
        CommonResult result = null;
        String sql = "";
        if (obj.has("sql")) {
            sql = obj.get("sql").asText();
        } else if (obj.has("text") && StringUtil.isNotEmpty((String)(sql = obj.get("text").asText()))) {
            sql = Base64.getFromBase64((String)sql);
        }
        String dsName = obj.get("dsName").asText();
        AtomicReference<String> message = new AtomicReference<String>("");
        String formKey = obj.get("formKey").asText();
        List boDefIds = this.boDefManager.getByFormKey(formKey);
        String boDefId = ((BoDef)boDefIds.get(0)).getId();
        BoDef baseBoDef = this.boDefService.getByDefId(boDefId);
        BoDef boDef = this.boDefService.getByAlias(baseBoDef.getAlias());
        BoEnt boEnt = boDef.getBoEnt();
        Map attrFieldMap = boEnt.getAttrFieldMap();
        HashSet subTableSet = new HashSet();
        HashSet sunTableSet = new HashSet();
        if (BeanUtils.isNotEmpty((Object)boEnt.getChildEntList())) {
            boEnt.getChildEntList().forEach(sub -> {
                subTableSet.add(sub.getTableName().toLowerCase());
                if (BeanUtils.isNotEmpty((Object)sub.getChildEntList())) {
                    sub.getChildEntList().forEach(sun -> sunTableSet.add(sun.getTableName().toLowerCase()));
                }
            });
        }
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = BeanUtils.isEmpty((Object)boDefIds) ? "LOCAL" : boEnt.getDsName();
        }
        if (SQLUtil.containsSqlInjection((String)sql)) {
            result = new CommonResult(false, "sql\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
            return result;
        }
        ArrayList<String> tableList = new ArrayList<String>();
        if (sql.split("from").length == 2) {
            try {
                Select select = (Select)CCJSqlParserUtil.parse((String)sql);
                SelectBody selectBody = select.getSelectBody();
                PlainSelect plainSelect = (PlainSelect)selectBody;
                message.set(this.ruleCheck(plainSelect, message.get(), tableList));
            }
            catch (Exception e2) {
                result = new CommonResult(false, "SQL\u9a8c\u8bc1\u5931\u8d25:" + e2.getMessage());
            }
        }
        String finalDsName = dsName;
        if (StringUtil.isNotEmpty((String)sql)) {
            String finalSql = sql;
            this.databaseContext.switchDS(finalDsName, () -> this.commonManager.execute(finalSql), e -> {
                message.set("SQL\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage());
                this.logger.error("SQL\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            });
        }
        if (StringUtil.isEmpty((String)message.get())) {
            ArrayNode groupFields = JsonUtil.createArrayNode();
            boolean sign = obj.has("instKey") && obj.get("instKey").asBoolean();
            boolean one = true;
            for (String tableName : tableList) {
                ObjectNode groupField = JsonUtil.getMapper().createObjectNode();
                if (boEnt.getTableName().equalsIgnoreCase(tableName)) {
                    groupField.put("type", "main");
                } else if (subTableSet.contains(tableName.toLowerCase())) {
                    groupField.put("type", "sub");
                } else if (sunTableSet.contains(tableName.toLowerCase())) {
                    groupField.put("type", "sun");
                } else {
                    groupField.put("type", "join");
                }
                com.hotent.table.model.Table table = (com.hotent.table.model.Table)this.databaseContext.switchDS(finalDsName, () -> {
                    BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)this.databaseContext.getDbType());
                    return baseTableMeta.getTableByName(tableName);
                }, e -> {
                    throw new BaseException("\u627e\u4e0d\u5230\u540d\u4e3a" + tableName + "\u7684\u7269\u7406\u8868\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
                });
                groupField.put("name", table.getTableName());
                groupField.put("desc", table.getComment());
                try {
                    List<TemplateField> templateFields = this.convertColumn2Field(table.getColumnList());
                    if (sign) {
                        this.addFieldList(templateFields);
                        sign = false;
                    }
                    if (one) {
                        templateFields.stream().filter(templateField -> templateField.getName().toLowerCase().startsWith("f_")).forEach(templateField -> templateField.setName(templateField.getName().toLowerCase().substring(2, templateField.getName().length())));
                        templateFields.stream().filter(templateField -> templateField.getOriginName().toLowerCase().startsWith("f_") && !boEnt.isExternal()).forEach(templateField -> templateField.setOriginName(templateField.getOriginName().toLowerCase().substring(2, templateField.getOriginName().length())));
                        one = false;
                    }
                    for (TemplateField field : templateFields) {
                        for (String s : attrFieldMap.keySet()) {
                            if (!s.equalsIgnoreCase(field.getOldTableField())) continue;
                            field.setFormat(((BoAttribute)attrFieldMap.get(s)).getFormat());
                            field.setName(((BoAttribute)attrFieldMap.get(s)).getName());
                        }
                    }
                    groupField.set("fields", JsonUtil.toJsonNode(templateFields));
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                groupFields.add((JsonNode)groupField);
                result = new CommonResult(true, "\u9a8c\u8bc1\u901a\u8fc7", (Object)groupFields);
            }
        } else {
            result = new CommonResult(false, "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c" + message);
        }
        return result;
    }

    private String ruleCheck(PlainSelect plainSelect, String message, List<String> tableList) {
        if (BeanUtils.isNotEmpty((Object)plainSelect.getGroupBy())) {
            message = "\u4e0d\u80fd\u5305\u542bgroup by\u5206\u7ec4\u8bed\u53e5";
        }
        if (BeanUtils.isNotEmpty((Object)plainSelect.getWhere())) {
            message = "sql\u8bed\u53e5\u4e2d\u4e0d\u80fd\u5305\u542b where";
        }
        if (BeanUtils.isNotEmpty((Object)plainSelect.getHaving())) {
            message = "sql\u8bed\u53e5\u4e2d\u4e0d\u80fd\u5305\u542b having";
        }
        if (BeanUtils.isNotEmpty((Object)plainSelect.getOrderByElements())) {
            message = "\u4e0d\u80fd\u5305\u542bgroup by\u5206\u7ec4\u8bed\u53e5";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Table table = (Table)plainSelect.getFromItem();
        tableList.add(table.getName());
        if (table.getAlias() != null) {
            map.put(table.getAlias().getName(), table.getName());
        }
        if (BeanUtils.isNotEmpty((Object)plainSelect.getJoins())) {
            for (Join join : plainSelect.getJoins()) {
                Table table1 = (Table)join.getRightItem();
                tableList.add(table1.getName());
                if (table1.getAlias() == null) continue;
                map.put(table1.getAlias().getName(), table1.getName());
            }
        }
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            if (value.equals(key)) continue;
            message = "SQL\u8bed\u53e5\u8868\u522b\u540d\u5fc5\u987b\u548c\u8868\u540d\u76f8\u540c";
            break;
        }
        return message;
    }

    @Override
    public List<ObjectNode> getAllList(String templateId, QueryFilter queryFilter) throws Exception {
        BoDef boDef;
        BoEnt boEnt;
        String dbType;
        FormDataTemplate template = this.getById((Serializable)((Object)templateId));
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
        if (BeanUtils.isNotEmpty((Object)AuthenticationUtil.getUserThreadLocal())) {
            AuthenticationUtil.setAuthentication((Authentication)SecurityContextHolder.getContext().getAuthentication());
        }
        if ("postgresql".equals(dbType = StringUtil.isNotEmpty((String)(boEnt = (boDef = this.boDefService.getByAlias(template.getBoDefAlias())).getBoEnt()).getDsName()) ? this.databaseContext.getDbTypeByAlias(boEnt.getDsName()) : SQLUtil.getDbType())) {
            List boAttrList = boEnt.getBoAttrList();
            for (Object query : queryFilter.getQuerys()) {
                if (!query.getClass().isAssignableFrom(QueryField.class)) continue;
                QueryField queryField = (QueryField)query;
                String property = queryField.getProperty();
                for (BoAttribute boAttribute : boAttrList) {
                    if ((boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) && "date".equals(boAttribute.getDataType()) && QueryOP.BETWEEN.equals((Object)queryField.getOperation()) && queryField.getValue().getClass() == ArrayList.class) {
                        ArrayList value = (ArrayList)queryField.getValue();
                        ArrayList<Date> newVal = new ArrayList<Date>();
                        for (int i = 0; i < value.size(); ++i) {
                            if (StringUtil.isNotEmpty((String)((String)value.get(i)))) {
                                newVal.add(DateFormatUtil.parseDate((String)((String)value.get(i)), (String)"yyyy-MM-dd HH:mm:ss"));
                                continue;
                            }
                            newVal.add(null);
                        }
                        queryField.setValue(newVal);
                        continue;
                    }
                    if (!(boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) || !"date".equals(boAttribute.getDataType()) || queryField.getValue().getClass() == ArrayList.class || !StringUtil.isNotEmpty((String)((String)queryField.getValue()))) continue;
                    queryField.setValue((Object)DateFormatUtil.parseDate((String)((String)queryField.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
        }
        if ("oracle".equals(dbType) || "dm".equals(dbType)) {
            List queryFields = queryFilter.getQuerys();
            for (Object query : queryFields) {
                BoAttribute boAttribute = boEnt.getBoAttributeByName(query.getProperty().replace("t.", ""));
                if (!BeanUtils.isNotEmpty((Object)boAttribute)) continue;
                if ("clob".equals(boAttribute.getDataType()) && StringUtil.isNotEmpty((String)boAttribute.getName())) {
                    query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                    continue;
                }
                if (!"date".equals(boAttribute.getDataType()) || !StringUtil.isNotEmpty((String)boAttribute.getName())) continue;
                try {
                    String format = boAttribute.getFormat();
                    String value = query.getValue().toString();
                    if ("yyyy-MM-dd HH:mm:ss".equals(format) && com.hotent.base.util.time.DateUtil.isRqFormat((String)value)) {
                        query.setValue((Object)(value + " 00:00:00"));
                    }
                    this.setQueryTimeProperty((QueryField)query, format);
                }
                catch (Exception e2) {
                    query.setProperty("1");
                    query.setOperation(QueryOP.EQUAL);
                    query.setValue((Object)"-1");
                }
            }
        }
        String dsName = boEnt.getDsName();
        this.handleSubDate(queryFilter, template.getJoinTables(), dsName);
        for (QueryField flowObj : queryFilter.getQuerys()) {
            String property = flowObj.getProperty();
            if (!property.startsWith("$TREE$")) continue;
            String newproperty = property;
            newproperty = property.replaceFirst("\\$TREE\\$", "");
            flowObj.setProperty(newproperty);
        }
        Map params = queryFilter.getParams();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        boolean hasTenantId = boEnt.getAttrFieldMap().keySet().contains("tenant_id_");
        BaseContext context = (BaseContext)AppUtil.getBean(BaseContext.class);
        String currentTenantId = context.getCurrentTenantId();
        if (!TenantConstant.IGNORE_TABLES.contains(boEnt.getTableName()) && hasTenantId && StringUtil.isNotEmpty((String)currentTenantId)) {
            QueryField queryField = new QueryField("t.tenant_id_", (Object)currentTenantId);
            queryFilter.getQuerys().add(queryField);
        }
        List<TemplateField> fields = this.getAllFields(boEnt, template);
        String mainPkKey = StringUtil.isEmpty((String)boEnt.getPk()) ? "id_" : boEnt.getPk();
        HashMap<String, Object> formatMap = new HashMap<String, Object>();
        String sql = this.buildSql(this.mergeField(template.getDisplayField(), fields), boEnt.getTableName(), mainPkKey, template.getJoinTables(), dbType, dsName, formatMap);
        String filterSql = this.getFilterSql(template.getFilterField(), dsName, params, boEnt, template);
        if (StringUtil.isNotEmpty((String)filterSql)) {
            queryFilter.addParams(filterSql, null);
        }
        queryFilter.withParam("filterSql", (Object)filterSql);
        QueryFilter finalQueryFilter1 = queryFilter;
        List list = (List)this.databaseContext.switchDS(dsName, () -> this.commonManager.queryByCustomSqlNoPage(sql, finalQueryFilter1), e -> {
            throw new BaseException("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01", (Throwable)e);
        });
        List<DisplayField> displayFields = this.dataTemplateSettingService.getDisplayFields(template);
        this.decryptResult(displayFields, list, DisplayField::getName);
        if (BeanUtils.isNotEmpty((Object)list)) {
            this.formatListData(list, template.getDisplayField());
            Map<String, DisplayField> displayFieldMap = displayFields.stream().filter(map -> StringUtil.isNotEmpty((String)map.getName())).collect(Collectors.toMap(map -> map.getName().toLowerCase(), v -> v));
            for (Map rowMap : list) {
                Map<String, Object> rtnMap = this.convertDbToData(boEnt, rowMap, displayFieldMap, formatMap);
                rtnMap.put("isStartFlow", false);
                for (DisplayField displayField : displayFields) {
                    if (displayField.getCustomColumn() == null || !displayField.getCustomColumn().booleanValue() || !StringUtil.isNotEmpty((String)displayField.getName())) continue;
                    rtnMap.put(displayField.getName(), MapUtil.getIgnoreCase((Map)rowMap, (String)displayField.getName()));
                }
                ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
                for (Map.Entry<String, Object> entry : rtnMap.entrySet()) {
                    Object value = entry.getValue();
                    if (BeanUtils.isNotEmpty((Object)value)) {
                        objectNode.set(entry.getKey(), BeanUtils.isNotEmpty((Object)value) ? JsonUtil.toJsonNode((Object)value) : null);
                        continue;
                    }
                    objectNode.put(entry.getKey(), "");
                }
                result.add(objectNode);
            }
        }
        return result;
    }

    @Override
    public List<ComputeVo> newBoBatchUpdate2(UpdateBatchParam updateBatchParam) throws Exception {
        FormDataTemplate template = (FormDataTemplate)this.get((Serializable)((Object)updateBatchParam.getTemplateId()));
        JsonNode button = this.dataTemplateSettingService.getManageFieldByButtonId(template, "batchUpdate", updateBatchParam.getButtonId());
        List<RelationParam> relationParamsList = DataTemplateUtil.getRelationParams(button);
        ArrayNode batchUpdateData = DataTemplateUtil.getBatchUpdateData(button);
        List computeNode = JsonUtil.arrayToList((ArrayNode)batchUpdateData).stream().filter(item -> item.get("valueType").asInt() == 2).collect(Collectors.toList());
        Map<String, String> filterMap = DataTemplateUtil.getFilterMap(batchUpdateData);
        QueryFilter queryFilter = Optional.ofNullable(updateBatchParam.getQueryFilter()).orElse(QueryFilter.build());
        if (BeanUtils.isNotEmpty(updateBatchParam.getIds())) {
            BoDef boDef = this.boDefService.getByDefId(template.getBoDefId());
            String mainPk = "t." + Optional.ofNullable(boDef).map(BoDef::getBoEnt).map(BoEnt::getPkKey).orElse("id_");
            queryFilter.addFilter(mainPk, updateBatchParam.getIds(), QueryOP.IN);
        }
        List<ObjectNode> allList = this.getAllList(updateBatchParam.getTemplateId(), queryFilter);
        if (BeanUtils.isNotEmpty(updateBatchParam.getParams())) {
            for (ObjectNode objectNode : allList) {
                for (Map map : updateBatchParam.getParams()) {
                    String key = map.get("key").toString().toLowerCase();
                    Object value = map.get("value");
                    if (BeanUtils.isEmpty(value)) continue;
                    objectNode.set(key, JsonUtil.toJsonNode(value));
                }
            }
        }
        for (ObjectNode objectNode : allList) {
            for (RelationParam relationParam : relationParamsList) {
                String alias = relationParam.getAlias();
                List<Conditionfield> conditions = relationParam.getConditionfield();
                List<Resultfield> resultField = relationParam.getResultfield();
                ArrayList conditionParams = new ArrayList();
                for (Conditionfield conditionfield : conditions) {
                    Object text;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String field = conditionfield.getField();
                    String node = conditionfield.getFieldPath();
                    if (StringUtil.isEmpty((String)node)) continue;
                    String paramKey = node.toLowerCase();
                    try {
                        text = objectNode.get(paramKey).asText();
                    }
                    catch (Exception e) {
                        try {
                            text = objectNode.get(paramKey).asDouble();
                        }
                        catch (Exception a) {
                            text = objectNode.get(paramKey).asInt();
                        }
                    }
                    String emptyValue = conditionfield.getEmptyValue();
                    if (BeanUtils.isNotEmpty((Object)text)) {
                        map.put("key", field);
                        map.put("value", text);
                        conditionParams.add(map);
                        continue;
                    }
                    if (BeanUtils.isNotEmpty((Object)emptyValue)) {
                        map.put("key", field);
                        map.put("value", emptyValue);
                        conditionParams.add(map);
                        continue;
                    }
                    map.put("key", field);
                    map.put("value", "aaaaaaaa");
                    conditionParams.add(map);
                }
                String s = JsonUtil.toJsonString(conditionParams);
                PageList pageLis = this.customQueryManager.doQuery(Optional.of(alias), Optional.of(s), Optional.of(1));
                List rows = pageLis.getRows();
                for (Resultfield resultfield : resultField) {
                    String field = resultfield.getField();
                    String node = resultfield.getFieldPath();
                    String emptyResultValue = "";
                    if (StringUtil.isNotEmpty((String)resultfield.getEmptyResultValue())) {
                        emptyResultValue = resultfield.getEmptyResultValue();
                    }
                    if (!BeanUtils.isNotEmpty((Object)node) || !BeanUtils.isNotEmpty((Object)rows)) continue;
                    JsonNode jsonNode = null;
                    StringBuilder result = new StringBuilder();
                    if (rows.size() > 1) {
                        for (Map row : rows) {
                            if (!MapUtil.containsIgnoreKey((Map)row, (String)field) || !StringUtil.isNotEmpty((String)MapUtil.getString((Map)row, (String)field))) continue;
                            result.append(row.get(field)).append(",");
                        }
                        if (StringUtil.isNotEmpty((String)result.toString())) {
                            result = new StringBuilder(result.substring(0, result.length() - 1));
                        }
                    } else {
                        Map map = (Map)rows.get(0);
                        if (MapUtil.containsIgnoreKey((Map)map, (String)field) && StringUtil.isNotEmpty((String)MapUtil.getString((Map)map, (String)field))) {
                            result = new StringBuilder(MapUtil.getString((Map)map, (String)field, (String)""));
                        }
                    }
                    if (StringUtil.isEmpty((String)result.toString())) {
                        result = new StringBuilder(emptyResultValue);
                    }
                    jsonNode = JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)result.toString()));
                    String paramKey = node.toLowerCase();
                    objectNode.set(paramKey, jsonNode);
                }
            }
        }
        ArrayList<ComputeVo> computeList = new ArrayList<ComputeVo>();
        for (ObjectNode objectNode : allList) {
            ComputeVo computeVo = new ComputeVo();
            computeVo.setData(objectNode);
            computeVo.setAlias(updateBatchParam.getBoAlias());
            computeVo.setFilterMap(filterMap);
            computeList.add(computeVo);
        }
        computeNode.sort(Comparator.comparingInt(o -> o.get("sort").asInt()));
        ArrayList<Formal> arrayList = new ArrayList<Formal>();
        BoEnt boEnt = this.boDefService.getByAlias(template.getBoDefAlias()).getBoEnt();
        String string = boEnt.getTableName();
        HashMap<String, Object> mapFields = new HashMap<String, Object>();
        for (BoAttribute boAttribute : boEnt.getBoAttrList()) {
            String name = boAttribute.getName().toLowerCase();
            if (name.startsWith("f_") && !boEnt.isExternal()) {
                name = name.substring(2);
            }
            String key = "data." + template.getAlias() + "." + name;
            Object value = "data." + string + boAttribute.getFieldName();
            value = FormUtil.replaceUnderline(((String)value).toLowerCase());
            mapFields.put(key, value);
        }
        for (JsonNode i : computeNode) {
            String computeConfig = i.get("computeConfig").asText().replaceAll("\\$Formulas", "this.\\$Formulas");
            Formal formal = new Formal();
            if (mapFields.size() > 0) {
                for (Map.Entry entry : mapFields.entrySet()) {
                    if (!StrUtil.containsIgnoreCase((CharSequence)computeConfig, (CharSequence)((CharSequence)entry.getKey()))) continue;
                    computeConfig = StrUtil.replaceIgnoreCase((CharSequence)computeConfig, (CharSequence)((CharSequence)entry.getKey()), (CharSequence)((CharSequence)entry.getValue()));
                }
            }
            formal.setValue(computeConfig);
            String fieldName = i.get("name").asText().toLowerCase();
            String name = fieldName.startsWith(string.replaceAll("_", "").toLowerCase()) ? fieldName : (BoEnt.PK_NAME.equalsIgnoreCase(fieldName) || BoEnt.FK_NAME.equalsIgnoreCase(fieldName) ? string + fieldName : string + "f" + fieldName);
            formal.setField(name.replaceAll("_", "").toLowerCase());
            arrayList.add(formal);
        }
        for (ComputeVo computeVo : computeList) {
            computeVo.setFormals(arrayList);
        }
        return computeList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(BatchSaveParam batchSaveParam) throws Exception {
        String data;
        FormDataTemplate template = this.getById((Serializable)((Object)batchSaveParam.getTemplateId()));
        JsonNode batchSave = this.dataTemplateSettingService.getManageFieldByButtonId(template, "batchSave", batchSaveParam.getButtonId());
        JsonNode node = null;
        if (BeanUtils.isNotEmpty((Object)batchSave) && BeanUtils.isNotEmpty((Object)batchSave.get("customDialogjson")) && BeanUtils.isNotEmpty((Object)(data = batchSave.get("customDialogjson").asText()))) {
            node = JsonUtil.toJsonNode((String)Base64.getFromBase64((String)data));
        }
        if (BeanUtils.isNotEmpty(node)) {
            JsonNode custDialog = node.get("custDialog");
            ArrayNode mappingConf = (ArrayNode)custDialog.get("mappingConf");
            HashMap<String, String> mapping = new HashMap<String, String>();
            for (JsonNode jsonNode : mappingConf) {
                String from = jsonNode.get("from").asText().toLowerCase(Locale.ROOT);
                JsonNode target = jsonNode.get("target");
                if (!BeanUtils.isNotEmpty((Object)target) || !StringUtil.isNotEmpty((String)target.asText())) continue;
                mapping.put(target.asText(), from);
            }
            BoDef boDef = this.boDefService.getByAlias(template.getBoDefAlias());
            BoEnt boEnt = boDef.getBoEnt();
            List<ObjectNode> selectList = batchSaveParam.getBindList();
            HashMap bindMap = new HashMap();
            if (BeanUtils.isNotEmpty(selectList)) {
                selectList.forEach(i -> bindMap.put(i.get("bindFilld").asText(), i.get("fillValue")));
            }
            ArrayList<ObjectNode> nodes = new ArrayList<ObjectNode>();
            for (ObjectNode param : batchSaveParam.getData()) {
                ObjectNode objectNode = JsonUtil.createObjectNode();
                for (BoAttribute attribute : boEnt.getBoAttrList()) {
                    JsonNode tempBindNode;
                    String tempKey;
                    String attr = attribute.getName();
                    String key = (String)MapUtil.getIgnoreCase(mapping, (String)attr);
                    if (boEnt.isExternal() && StringUtil.isEmpty((String)key) && StringUtil.isNotEmpty((String)(tempKey = (String)MapUtil.getIgnoreCase(mapping, (String)attr.toLowerCase().replace("f_", ""))))) {
                        key = tempKey;
                    }
                    JsonNode bindNode = (JsonNode)bindMap.get(attr);
                    if (boEnt.isExternal() && BeanUtils.isEmpty((Object)bindNode) && BeanUtils.isNotEmpty((Object)(tempBindNode = (JsonNode)MapUtil.getIgnoreCase(bindMap, (String)attr.toLowerCase().replace("f_", ""))))) {
                        bindNode = tempBindNode;
                    }
                    if (StringUtil.isEmpty((String)key) && BeanUtils.isEmpty((Object)bindNode)) continue;
                    JsonNode jsonNode = null;
                    jsonNode = param.get(key);
                    if (BeanUtils.isNotEmpty((Object)bindNode)) {
                        jsonNode = bindNode;
                    }
                    objectNode.set(attr, jsonNode);
                }
                if (mapping.containsKey("ref_id_") || bindMap.containsKey("ref_id_")) {
                    String key = (String)mapping.get("ref_id_");
                    JsonNode bindNode = (JsonNode)bindMap.get("ref_id_");
                    JsonNode jsonNode = null;
                    jsonNode = param.get(key);
                    if (BeanUtils.isNotEmpty((Object)bindNode)) {
                        jsonNode = bindNode;
                    }
                    if (BeanUtils.isNotEmpty((Object)jsonNode)) {
                        objectNode.set("ref_id_", jsonNode);
                    }
                }
                nodes.add(objectNode);
            }
            BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
            ArrayList<BoData> data2 = new ArrayList<BoData>();
            for (ObjectNode jsonNode : nodes) {
                JsonNode jsonData = JsonUtil.toJsonNode((Object)jsonNode);
                jsonData = BoUtil.transJsonNode((JsonNode)jsonData);
                BoData boData = BoUtil.transJSON((JsonNode)jsonData);
                boData.setBoEnt(boEnt);
                boData.setBoDef(boDef);
                data2.add(boData);
            }
            this.executeScript(data2, template.getBeforeScript());
            handler.batchSave("", "", data2);
            this.executeScript(data2, template.getAfterScript());
        }
    }

    private void executeScript(List<BoData> data, String script) {
        if (StringUtil.isEmpty((String)script)) {
            return;
        }
        for (BoData datum : data) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("boData", datum);
            param.put("bpmRuntimeFeignService", this.bpmRuntimeFeignService);
            this.groovyScriptEngine.execute(script, param);
        }
    }

    @Override
    public void exportAuthDetail(QueryFilter<FormDataTemplate> queryFilter, HttpServletResponse httpServletResponse) throws Exception {
        String filename = "";
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if (BeanUtils.isNotEmpty((Object)queryFilter.getParams())) {
            if (queryFilter.getParams().containsKey("ids") && BeanUtils.isNotEmpty(queryFilter.getParams().get("ids"))) {
                queryFilter.setQuerys(new ArrayList());
                queryFilter.withQuery(new QueryField("id_", queryFilter.getParams().get("ids"), QueryOP.IN));
            }
            if (queryFilter.getParams().containsKey("titlePre") && queryFilter.getParams().get("titlePre") != null) {
                filename = filename + String.valueOf(queryFilter.getParams().get("titlePre"));
            }
        }
        filename = filename + "_\u8868\u5355\u5217\u8868_" + System.currentTimeMillis();
        PageList<Map<String, Object>> authDetailPage = this.getAuthDetailPage(queryFilter);
        for (Map row : authDetailPage.getRows()) {
            ArrayNode arrayNode;
            String field;
            if ("1".equals(row.get("AUTH_TYPE_"))) {
                row.put("AUTH_TYPE_DESC_", "\u6570\u636e\u6743\u9650");
                field = String.valueOf(row.get("FILTER_FIELD_"));
                arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)field);
                if (!BeanUtils.isNotEmpty((Object)arrayNode)) continue;
                row.put("AUTH_DETAIL_", JsonUtil.getString((JsonNode)arrayNode.get(arrayNode.size() - 1), (String)"name", (String)""));
                continue;
            }
            row.put("AUTH_TYPE_DESC_", "\u6309\u94ae\u6743\u9650");
            field = String.valueOf(row.get("MANAGE_FIELD_"));
            arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)field);
            if (!BeanUtils.isNotEmpty((Object)arrayNode)) continue;
            row.put("AUTH_DETAIL_", JsonUtil.getString((JsonNode)arrayNode.get(arrayNode.size() - 1), (String)"desc", (String)""));
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("NAME_", "\u5217\u8868\u540d\u79f0");
        map.put("ALIAS_", "\u5217\u8868\u522b\u540d");
        map.put("AUTH_TYPE_DESC_", "\u6388\u6743\u7c7b\u578b");
        map.put("AUTH_DETAIL_", "\u6388\u6743\u660e\u7ec6");
        Workbook sheets = ExcelUtils.exportExcel((String)filename, map, (List)authDetailPage.getRows());
        ExcelUtil.downloadExcel((Workbook)sheets, (String)filename, (HttpServletResponse)httpServletResponse);
    }

    @Override
    public String generatorTemplateHtmlCode(String alias, Map<String, Object> params, Map<String, Object> queryParams, FormType formType) throws Exception {
        Map<String, Boolean> mobilePermission;
        List list;
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        HashMap<String, Object> model = new HashMap<String, Object>();
        boolean managePermissionState = false;
        FormDataTemplate bpmDataTemplate = ((FormDataTemplateDao)this.baseMapper).getByAlias(alias);
        FormTemplate bpmFormTemplate = null;
        FormTemplate mobileFormTemplate = null;
        String templateAlias = "dataTemplateList_vue";
        String mobileTemplateAlias = "code_mobileDataTemplateList";
        if (formType == FormType.PC) {
            bpmFormTemplate = this.formTemplateManager.getByTemplateAlias(templateAlias);
        } else if (formType == FormType.MOBILE) {
            mobileFormTemplate = this.formTemplateManager.getByTemplateAlias(mobileTemplateAlias);
        } else {
            if (StringUtil.isNotEmpty((String)templateAlias)) {
                bpmFormTemplate = this.formTemplateManager.getByTemplateAlias(templateAlias);
            }
            if (StringUtil.isNotEmpty((String)mobileTemplateAlias)) {
                mobileFormTemplate = this.formTemplateManager.getByTemplateAlias(mobileTemplateAlias);
            }
        }
        FormDataTemplateHtmlDto dataTemplateHtmlDto = this.generateTemplateByFormTemplate(bpmDataTemplate, bpmFormTemplate, mobileFormTemplate);
        params.put("boAlias", bpmDataTemplate.getBoDefAlias());
        params.put("formKey", bpmDataTemplate.getFormKey());
        params.put("defId", BeanUtils.isEmpty((Object)bpmDataTemplate.getDefId()) ? "" : bpmDataTemplate.getDefId());
        Map<String, Boolean> managePermission = this.getManagePermission(bpmDataTemplate.getManageField(), curProfiles);
        Boolean hasSubStatus = StringUtil.isNotEmpty((String)this.getSubEntIds(bpmDataTemplate.getFormKey()));
        if (BeanUtils.isNotEmpty(managePermission) && BeanUtils.isNotEmpty(list = managePermission.keySet().stream().filter(key -> !"sun".equals(key) && (!"sub".equals(key) || hasSubStatus != false) && (Boolean)managePermission.get(key) != false).collect(Collectors.toList()))) {
            managePermissionState = true;
        }
        if (StringUtil.isEmpty((String)bpmDataTemplate.getDefId())) {
            managePermission.put("startFlow", false);
        }
        List<Map<String, String>> filters = this.getFilterPermission(bpmDataTemplate.getFilterField(), curProfiles);
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        model.put("util", freeMakerUtil);
        model.put("ctx", params.get("__ctx"));
        model.put("bpmDataTemplate", (Object)bpmDataTemplate);
        System.out.println(JsonUtil.toJsonString((Object)((Object)bpmDataTemplate)));
        Map<String, Boolean> permission = this.getPermission(bpmDataTemplate.getDisplayField(), curProfiles);
        model.put("permission", permission);
        Map<String, Boolean> destMap = mobilePermission = this.getMobilePermission(bpmDataTemplate.getMobileDisplayField(), curProfiles);
        destMap.put("mobile_sort", (Boolean)((Object)freeMakerUtil.toJsonStr(mobilePermission)));
        model.put("mobilePermission", destMap);
        model.put("isShowMobileStatus", this.getMobileStatus(bpmDataTemplate.getDisplayField(), permission));
        model.put("managePermission", managePermission);
        model.put("managePermissionState", managePermissionState);
        model.put("hasSub", hasSubStatus);
        BoDef boDef = this.boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        model.put("pkField", "id_");
        model.put("colPrefix", boEnt.isExternal() ? "" : "F_");
        model.put("filters", filters);
        model.put("JsonUtil", new JsonUtil());
        model.put("base64", new Base64());
        String templateHtml = FormType.PC == formType ? dataTemplateHtmlDto.getDataTemplateHtml() : dataTemplateHtmlDto.getMoblieDataTemplateHtml();
        UserAgent ua = UserAgentUtil.parse((String)HttpUtil.getRequest().getHeader(Header.USER_AGENT.toString()));
        if (BeanUtils.isNotEmpty((Object)ua) && ua.isMobile()) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start("\u79fb\u52a8\u7aef\u591a\u8868\u5934\u8f6c\u6210\u5e76\u5217\u663e\u793a");
            if (this.tileDisplayFields(bpmDataTemplate)) {
                FormDataTemplateHtmlDto dataTemplateHtmlDto1 = this.generateTemplate(bpmDataTemplate, formType);
                templateHtml = FormType.PC == formType ? dataTemplateHtmlDto1.getDataTemplateHtml() : dataTemplateHtmlDto1.getMoblieDataTemplateHtml();
            }
            stopWatch.stop();
            this.logger.info(stopWatch.prettyPrint());
        }
        if (null == bpmDataTemplate.getTableConfigure() || "[]".equals(bpmDataTemplate.getTableConfigure())) {
            bpmDataTemplate.setTableConfigure("{}");
        }
        return this.freemarkEngine.parseByStringTemplate(templateHtml, model);
    }

    private FormDataTemplateHtmlDto generateTemplateByFormTemplate(FormDataTemplate bpmDataTemplate, FormTemplate pcFormTemplate, FormTemplate mobileFormTemplate) throws Exception {
        List<FormField> fileds = this.formFieldManager.getByboDefId(bpmDataTemplate.getBoDefId());
        boolean hasCondition = !JsonUtil.isEmptyJsonArr((String)bpmDataTemplate.getConditionField());
        boolean hasManage = !JsonUtil.isEmptyJsonArr((String)bpmDataTemplate.getManageField());
        ArrayList<String> mergeFields = new ArrayList<String>();
        ArrayList<String> mergeFieldNames = new ArrayList<String>();
        BoDef boDef = this.boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        Assert.notNull((Object)boDef, (String)String.format("\u6839\u636e\u5efa\u6a21\u522b\u540d\u3010%s\u3011\u627e\u4e0d\u5230\u5efa\u6a21\u3002", bpmDataTemplate.getBoDefAlias()));
        BoEnt boEnt = boDef.getBoEnt();
        if (hasCondition) {
            ArrayNode conditions = (ArrayNode)JsonUtil.toJsonNode((String)bpmDataTemplate.getConditionField());
            for (JsonNode jsonNode : conditions) {
                ObjectNode condition = (ObjectNode)jsonNode;
                if (condition.has("mg") && condition.get("mg").asBoolean()) {
                    mergeFields.add(condition.get("na").asText());
                    mergeFieldNames.add(condition.get("cm").asText());
                }
                String[] qt = condition.get("qt").asText();
                String type = "";
                if (condition.hasNonNull("ty") && "date".equals(condition.get("ty").asText())) {
                    String field = ((boEnt.isExternal() ? "" : BoEnt.FIELD_PREFIX) + condition.get("name").asText()).toLowerCase();
                    BoAttribute attribute = boEnt.getAttrByField(field);
                    if (BeanUtils.isNotEmpty((Object)attribute)) {
                        type = "between".equals(qt) ? ("yyyy-MM-dd HH:mm:ss".equals(attribute.getFormat()) ? "datetimerange" : "daterange") : ("yyyy-MM-dd HH:mm:ss".equals(attribute.getFormat()) ? "datetime" : "date");
                    }
                } else if (condition.hasNonNull("ct") && "date".equals(condition.get("ct").asText())) {
                    type = "between".equals(qt) ? "datetimerange" : "datetime";
                }
                condition.put("ctrlType", type);
            }
            bpmDataTemplate.setConditionField(JsonUtil.toJson((Object)conditions));
        }
        if (hasManage) {
            ArrayNode manageFields = this.dataTemplateSettingService.getManageFields(bpmDataTemplate);
            for (JsonNode manageField : manageFields) {
                if (manageField.has("buttonId")) continue;
                ObjectNode objectNodeManageField = (ObjectNode)manageField;
                objectNodeManageField.put("buttonId", UniqueIdUtil.getSuid());
            }
            bpmDataTemplate.setManageField(JsonUtil.toJson((Object)manageFields));
        }
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormDataTemplate dataTemplate = (FormDataTemplate)((Object)BeanUtils.cloneBean((Object)((Object)bpmDataTemplate)));
        this.haldleTemplateSpecial(dataTemplate);
        if (StringUtil.isEmpty((String)dataTemplate.getShowType())) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff1a\u5c55\u793a\u6548\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList showViews = new ArrayList();
        for (String type : dataTemplate.getShowType().split(",")) {
            HashMap<String, String> view = new HashMap<String, String>();
            view.put("type", type);
            view.put("desc", FormDataTemplate.VIEW_MAP.get(type));
            showViews.add(view);
        }
        map.put("showViews", showViews);
        if (BeanUtils.isEmpty((Object)dataTemplate.getMobileDisplayField())) {
            dataTemplate.setMobileDisplayField("{}");
        }
        if (BeanUtils.isEmpty((Object)dataTemplate.getMobileManageField())) {
            dataTemplate.setMobileManageField("{}");
        }
        if (BeanUtils.isEmpty((Object)dataTemplate.getMobileOtherJson())) {
            dataTemplate.setMobileOtherJson("{}");
        }
        map.put("bpmDataTemplate", (Object)dataTemplate);
        map.put("hasCondition", hasCondition);
        map.put("hasManage", hasManage);
        map.put("pkField", boEnt.getPkKey().toLowerCase());
        map.put("colPrefix", boEnt.isExternal() ? "" : "F_");
        ArrayList<FormField> list = new ArrayList<FormField>();
        for (FormField filed : fileds) {
            if ("textFixed".equals(filed.getCtrlType())) {
                filed.setDesc(filed.getDesc().replaceAll("\"", "'"));
            }
            list.add(filed);
        }
        map.put("formatData", list);
        map.put("util", freeMakerUtil);
        map.put("conditionAllName", String.join((CharSequence)",", mergeFields));
        map.put("conditionAllDesc", "\u8bf7\u8f93\u5165\u5173\u952e\u5b57  " + String.join((CharSequence)"/", mergeFieldNames));
        HashMap<String, JsonNode> filteringFieldMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> filteringDefaultValue = new HashMap<String, JsonNode>();
        if (StringUtil.isNotEmpty((String)bpmDataTemplate.getFilteringField())) {
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)bpmDataTemplate.getFilteringField());
            for (Object jsonNode : arrayNode) {
                String oldTableField = JsonUtil.getString((JsonNode)jsonNode, (String)"oldTableField").replace("_", "").toLowerCase();
                String tableName = JsonUtil.getString((JsonNode)jsonNode, (String)"tableName").replace("_", "").toLowerCase();
                String name = StringUtil.isNotEmpty((String)oldTableField) ? tableName + oldTableField : jsonNode.get("name").asText().toLowerCase();
                filteringFieldMap.put(name, jsonNode.get("formatterData"));
                filteringDefaultValue.put(name, jsonNode.get("defaultValue"));
            }
        } else {
            bpmDataTemplate.setFilteringField("[]");
        }
        map.put("filteringFieldMap", filteringFieldMap);
        map.put("filteringDefaultValue", filteringDefaultValue);
        HashMap<String, String> sortFieldMap = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)bpmDataTemplate.getSortField())) {
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)bpmDataTemplate.getSortField());
            for (JsonNode jsonNode : arrayNode) {
                if (StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)jsonNode, (String)"oldTableField"))) {
                    String oldTableField = JsonUtil.getString((JsonNode)jsonNode, (String)"oldTableField").replace("_", "").toLowerCase();
                    String tableName = JsonUtil.getString((JsonNode)jsonNode, (String)"tableName").replace("_", "").toLowerCase();
                    sortFieldMap.put(tableName + oldTableField, jsonNode.get("sort").asText());
                    continue;
                }
                sortFieldMap.put(jsonNode.get("name").asText(), jsonNode.get("sort").asText());
            }
        }
        if (StringUtil.isEmpty((String)bpmDataTemplate.getInnerBtnConfig())) {
            bpmDataTemplate.setInnerBtnConfig(this.initInnerBtnConfig());
        }
        map.put("sortFieldMap", sortFieldMap);
        if (BeanUtils.isEmpty(sortFieldMap)) {
            map.put("defaultAllSort", true);
        }
        FormDataTemplateHtmlDto formDataTemplateHtmlDto = new FormDataTemplateHtmlDto();
        if (pcFormTemplate != null) {
            String templateHtml = this.freemarkEngine.parseByStringTemplate(pcFormTemplate.getHtml(), map);
            templateHtml = FormHtmlUtil.htmlCompressor(templateHtml);
            formDataTemplateHtmlDto.setDataTemplateHtml(templateHtml);
        }
        if (mobileFormTemplate != null) {
            String mobileTemplateHtml = this.freemarkEngine.parseByStringTemplate(mobileFormTemplate.getHtml(), map);
            mobileTemplateHtml = FormHtmlUtil.htmlCompressor(mobileTemplateHtml);
            formDataTemplateHtmlDto.setMoblieDataTemplateHtml(mobileTemplateHtml);
        }
        return formDataTemplateHtmlDto;
    }
}

