/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.SystemException;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BaseContextThreadUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.bo.bodef.BoDefService;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoBpmShipGroup;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoDefXml;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.bo.persistence.manager.BoEntRelManager;
import com.hotent.bo.util.BoUtil;
import com.hotent.form.enums.ComponentType;
import com.hotent.form.enums.FormType;
import com.hotent.form.enums.LayoutType;
import com.hotent.form.mobile.service.Pc2MobileConvertFactory;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormField;
import com.hotent.form.model.FormHistory;
import com.hotent.form.model.FormHistoryRecord;
import com.hotent.form.model.FormImportData;
import com.hotent.form.model.FormImportXml;
import com.hotent.form.model.FormMeta;
import com.hotent.form.model.FormPrintTemplate;
import com.hotent.form.model.FormRight;
import com.hotent.form.model.FormRightXml;
import com.hotent.form.model.FormTemplate;
import com.hotent.form.model.FormXml;
import com.hotent.form.param.CopyFormVo;
import com.hotent.form.param.FormPreviewDataParam;
import com.hotent.form.param.GenerateExpandParam;
import com.hotent.form.persistence.dao.FormDao;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.FormFieldManager;
import com.hotent.form.persistence.manager.FormHistoryManager;
import com.hotent.form.persistence.manager.FormHistoryRecordManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormPrintTemplateManager;
import com.hotent.form.persistence.manager.FormRightManager;
import com.hotent.form.persistence.manager.FormTemplateManager;
import com.hotent.form.service.FormComponentIOService;
import com.hotent.form.service.FormService;
import com.hotent.form.service.factory.FormComponentIOServiceFactory;
import com.hotent.form.service.impl.DefaultFormComponentIOService;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.util.FormHtmlUtil;
import com.hotent.form.util.FormUtil;
import com.hotent.form.util.FreeMakerUtil;
import com.hotent.form.util.GenerateExpandUtil;
import com.hotent.form.util.JsoupUtil;
import com.hotent.form.vo.BpmFormVo;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import poi.util.ExcelUtil;

@Service(value="bpmFormManager")
public class FormManagerImpl
extends BaseManagerImpl<FormDao, Form>
implements FormManager {
    Logger logger = LoggerFactory.getLogger(FormManagerImpl.class);
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    @Lazy
    FormDataTemplateManager dataTemplateManager;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    BoDefService boDefService;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormHistoryManager formHistoryManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormHistoryRecordManager formHistoryRecordManager;
    @Resource
    BoDefManager bODefManager;
    @Resource
    FormService formService;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    FormPrintTemplateManager formPrintTemplateManager;
    @Resource
    BpmModelFeignService bpmModelFeignService;
    @Resource
    BoEntManager boEntManager;
    @Resource
    Pc2MobileConvertFactory pc2MobileConvertFactory;
    @Resource
    FormComponentIOServiceFactory formComponentIOServiceFactory;
    @Resource
    BoEntRelManager boEntRelManager;
    private final List<String> LIST_INVISIBLE_ADVANCE_MOBILE = Arrays.asList("dataView", LayoutType.HOT_TABLE.getValue());
    private final List<String> LAYOUT_TYPES = FormUtil.getLayoutTypes();
    private final List<String> SUB_LAYOUT_TYPE = Arrays.asList(LayoutType.SUB_DIV_LAYOUT.getValue(), LayoutType.SUB_TABLE_LAYOUT.getValue(), LayoutType.SUN_DIV_LAYOUT.getValue(), LayoutType.SUN_TABLE_LAYOUT.getValue());
    private final List<String> EXPORT_COMPONENT_TYPES = Arrays.asList(ComponentType.TAG.getValue(), ComponentType.DIC.getValue(), ComponentType.DIALOG.getValue(), ComponentType.CUSTOM_COMPONENT.getValue());

    @Override
    public IPage<Form> getFormQueryList(QueryFilter<Form> queryFilter) throws Exception {
        return ((FormDao)this.baseMapper).getFormQueryList((IPage<Form>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Form>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    public Form get(Serializable entityId) {
        Form bpmForm = (Form)super.get(entityId);
        Assert.notNull((Object)((Object)bpmForm), (String)String.format("ID\u4e3a:%s\u7684\u8868\u5355\u4e0d\u5b58\u5728", entityId));
        String html = bpmForm.getFormHtml();
        String formHtml = I18nUtil.replaceTemp((String)html, (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        bpmForm.setFormHtml(formHtml);
        return bpmForm;
    }

    @Override
    public String getHtml(String formId, String mainFieldTemplate, String subFieldListTemplate) throws Exception {
        String[] tableNameArray = mainFieldTemplate.split(",");
        String[] templateAliasArray = subFieldListTemplate.split(",");
        FormMeta bpmFormdef = (FormMeta)this.formMetaManager.get((Serializable)((Object)formId));
        String html = "";
        if (bpmFormdef != null) {
            JsonNode fieldList = bpmFormdef.getFieldList();
            for (int i = 0; i < tableNameArray.length; ++i) {
                String tableName = tableNameArray[i];
                JsonNode tableField = null;
                for (int j = 0; j < fieldList.size(); ++j) {
                    JsonNode table = fieldList.get(j);
                    if (!tableName.equals(table.get("name"))) continue;
                    tableField = table;
                    break;
                }
                FormTemplate template = this.formTemplateManager.getByTemplateAlias(templateAliasArray[i]);
                String macroTemplate = this.formTemplateManager.getByTemplateAlias(template.getMacrotemplateAlias()).getHtml();
                if (tableField == null || template == null) continue;
                boolean isSub = "sub".equals(tableField.get("type"));
                ArrayNode fieldLists = null;
                if (isSub) {
                    fieldLists = (ArrayNode)tableField.get("children");
                } else {
                    JsonNode expand = JsonUtil.toJsonNode((String)bpmFormdef.getExpand());
                    JsonNode separators = null;
                    if (BeanUtils.isNotEmpty((Object)expand)) {
                        separators = expand.get("separators");
                    }
                    this.getFieldList(fieldLists, tableField.get("children"), separators);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("table", tableField);
                map.put("isSub", isSub);
                map.put("mainGroup", "\u57fa\u672c\u4fe1\u606f");
                map.put("formDesc", tableField.get("desc"));
                map.put("fieldList", fieldLists);
                map.put("ganged", bpmFormdef.getGanged());
                html = html + this.freemarkEngine.parseByTempName(macroTemplate + template.getHtml(), map);
            }
        }
        return html;
    }

    private void getFieldList(ArrayNode fieldLists, JsonNode fields, JsonNode separators) {
        if (BeanUtils.isNotEmpty((Object)fields)) {
            int i;
            ArrayNode basefields = JsonUtil.getMapper().createObjectNode().arrayNode();
            ObjectNode mainSep = JsonUtil.getMapper().createObjectNode();
            if (BeanUtils.isNotEmpty((Object)separators)) {
                for (i = 0; i < separators.size(); ++i) {
                    ObjectNode oj = (ObjectNode)separators.get(i);
                    oj.put("fields", (JsonNode)JsonUtil.getMapper().createObjectNode());
                    if (separators.get(i).get("key") == null) continue;
                    mainSep = (ObjectNode)separators.get(i);
                }
            }
            for (i = 0; i < fields.size(); ++i) {
                JsonNode obj = fields.get(i);
                String separator = obj.get("separator").asText();
                if (StringUtil.isZeroEmpty((String)separator)) {
                    basefields.arrayNode();
                    continue;
                }
                for (int m = 0; m < separators.size(); ++m) {
                    ArrayNode sepObj = (ArrayNode)separators.get(m);
                    if (!separator.equals(sepObj.get("key"))) continue;
                    ((ArrayNode)sepObj.get("fields")).add(obj);
                }
            }
            mainSep.set("fields", (JsonNode)basefields);
            fieldLists.add((JsonNode)mainSep);
            for (int m = 0; m < separators.size(); ++m) {
                ArrayNode sepObj = (ArrayNode)separators.get(m);
                if (!BeanUtils.isNotEmpty((Object)sepObj.get("fields")) || "0".equals(sepObj.get("key"))) continue;
                fieldLists.add((JsonNode)sepObj);
            }
        }
    }

    @Override
    @Cacheable(value={"eip:form:bpmForm"}, key="#formKey", ignoreException=false, firstCache=@FirstCache(expireTime=600, timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=600, preloadTime=360, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public Form getMainByFormKey(String formKey) {
        Form bpmForm = ((FormDao)this.baseMapper).getMainByFormKey(formKey);
        if (Objects.isNull((Object)bpmForm)) {
            return null;
        }
        String html = bpmForm.getFormHtml();
        String formHtml = I18nUtil.replaceTemp((String)html, (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        bpmForm.setFormHtml(formHtml);
        return bpmForm;
    }

    @Override
    public List<Map<String, Object>> getBoEnt(String defId) {
        return ((FormDao)this.baseMapper).getBoEnt(defId);
    }

    @Override
    public List<Form> getByFormKey(String formKey) {
        return ((FormDao)this.baseMapper).getByFormKey(formKey);
    }

    @Override
    public String getDefaultKeyByFormKey(String formKey) {
        String testFormKey;
        if (this.getByFormKey(formKey).size() == 0) {
            return formKey;
        }
        boolean isValid = false;
        Random random = new Random();
        do {
            if (this.getByFormKey(testFormKey = formKey + String.format("%04d", random.nextInt(9999) + 1)).size() != 0) continue;
            isValid = true;
        } while (!isValid);
        return testFormKey;
    }

    @Override
    public List<Form> getPrintByFormKey(String formKey) {
        return ((FormDao)this.baseMapper).getPrintByFormKey(formKey);
    }

    @Override
    public List<Form> getByBoCodes(List<String> codes, String formType, QueryFilter<Form> filter) {
        List<Form> list = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("codes", codes);
            map.put("formType", formType);
            map.put("formKey", filter.getParams().get("formKey"));
            map.put("name", filter.getParams().get("name"));
            list = ((FormDao)this.baseMapper).getByBoCodes(map);
        }
        catch (SystemException e) {
            e.printStackTrace();
            list = new ArrayList<Form>();
        }
        return list;
    }

    @Override
    public Integer getBpmFormCountsByFormKey(String formKey) {
        return ((FormDao)this.baseMapper).getBpmFormCountsByFormKey(formKey);
    }

    @Override
    @Transactional
    public void newVersion(String formId) throws Exception {
        Form bpmform = this.get((Serializable)((Object)formId));
        this.createNewVersionForm(bpmform);
    }

    private void createNewVersionForm(Form bpmform) {
        if (bpmform != null) {
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(bpmform.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            Form newBpmForm = bpmform;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('N');
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            newBpmForm.setUpdateTime(LocalDateTime.now());
            this.create((Model)newBpmForm);
            this.publish(newFormId);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        }
    }

    private void createNewDraftForm(Form bpmFormDraft) {
        if (bpmFormDraft != null) {
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(bpmFormDraft.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            Form newBpmForm = bpmFormDraft;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('N');
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            this.create((Model)newBpmForm);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        }
    }

    @Override
    @Transactional
    public void setDefaultVersion(String formId, String formKey) {
        ((FormDao)this.baseMapper).updNotDefaultByFormKey(formKey);
        ((FormDao)this.baseMapper).updDefaultByFormId(formId);
        Form form = (Form)super.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            FormMeta byKey = this.formMetaManager.getByKey(formKey);
            byKey.setExpand(form.getExpand());
            this.formMetaManager.update((Model)byKey);
        }
        this.removeFromCache(formKey);
    }

    private void removeFromCache(String formKey) {
        FormManagerImpl bean = (FormManagerImpl)AppUtil.getBean(this.getClass());
        bean.delFromCache(formKey);
    }

    @CacheEvict(value={"eip:form:bpmForm"}, key="#formKey")
    protected void delFromCache(String formKey) {
    }

    @Override
    @Transactional
    public void publish(String formId) {
        Form formDef = this.get((Serializable)((Object)formId));
        if (formDef != null) {
            formDef.setStatus("deploy");
            this.update(formDef);
        }
    }

    @Override
    public List<Form> getByDefId(String defId) {
        return ((FormDao)this.baseMapper).getByDefId(defId);
    }

    @Override
    @Transactional
    public CommonResult<String> importForms(ObjectNode obj, String typeId) throws Exception {
        return this.formService.importFormAndBo(obj, typeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importForms(ObjectNode obj, String status, String typeId) throws Exception {
        return this.formService.importFormAndBo(obj, status, typeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importByFormXml(String xml, String typeId, List<BoDef> importBoDef, Map<String, String> nameMap, List<String> hasRightImportForms) throws Exception {
        FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)xml, FormImportXml.class);
        List<FormXml> formXmlList = formImportXml.getFormXmlList();
        Map entIdMap = this.boDefManager.getEntIdMap(importBoDef, nameMap);
        for (FormXml formXml : formXmlList) {
            JsonNode boDefJson;
            ObjectNode sysType;
            HashSet<String> boCodesSet = new HashSet<String>();
            if (BeanUtils.isNotEmpty(formXml.getBoCodes())) {
                for (String boCode : formXml.getBoCodes()) {
                    boCodesSet.add(boCode);
                }
            }
            FormMeta formDef = formXml.getBpmFormDef();
            Form form = formXml.getBpmForm();
            if (hasRightImportForms != null && !hasRightImportForms.contains(form.getFormKey())) {
                ThreadMsgUtil.addMapMsg2((String)"formHasNoRight", (String)String.format("<div  style='margin-left:12px; margin-top:6px;color: red;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                continue;
            }
            String html = this.genFromHtml(form.getFormSetting(), formDef.getExpand(), "mobile".equals(form.getFormType()));
            form.setFormHtml(html);
            if (StringUtil.isNotEmpty((String)typeId) && BeanUtils.isNotEmpty((Object)(sysType = this.portalFeignService.getSysTypeById(typeId)))) {
                form.setTypeId(sysType.get("id").asText());
                form.setTypeName(sysType.get("name").asText());
            }
            FormMeta oldFormDef = this.formMetaManager.getByKey(formDef.getKey());
            HashMap<String, BoDef> boDefMap = new HashMap<String, BoDef>();
            ObjectNode expand = (ObjectNode)JsonUtil.toJsonNode((String)formDef.getExpand());
            ArrayNode boDefList = JsonUtil.getMapper().createArrayNode();
            for (BoDef boDef : importBoDef) {
                if (!boCodesSet.contains(boDef.getAlias())) continue;
                boDef.setChildren(Collections.singletonList(boDef.getBoEnt()));
                boDefMap.put(boDef.getAlias(), boDef);
                boDefJson = JsonUtil.toJsonNode((Object)boDef);
                boDefList.add(boDefJson);
            }
            expand.set("boDefList", (JsonNode)boDefList);
            if (BeanUtils.isNotEmpty(importBoDef)) {
                this.boDefManager.updateEntId(importBoDef, expand);
            }
            formDef.setExpand(expand.toString());
            if (oldFormDef != null) {
                formDef.setId(oldFormDef.getId());
                this.formMetaManager.updateByImport(formDef, entIdMap);
                ThreadMsgUtil.addMapMsg2((String)"formDefsUpdated", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", formDef.getName() + "", formDef.getKey() + ""));
            } else {
                formDef.setId(UniqueIdUtil.getSuid());
                this.formMetaManager.createByImport(formDef, entIdMap);
                ThreadMsgUtil.addMapMsg2((String)"formDefsAdded", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", formDef.getName() + "", formDef.getKey() + ""));
            }
            this.formMetaManager.deleteBpmFormBo(formDef.getId());
            Iterator iterator = boDefList.iterator();
            while (iterator.hasNext()) {
                JsonNode obj;
                boDefJson = obj = (JsonNode)iterator.next();
                this.formMetaManager.createBpmFormBo(UniqueIdUtil.getSuid(), boDefJson.get("id").asText() + "", formDef.getId());
            }
            Form oldForm = this.getMainByFormKey(form.getFormKey());
            form.setDefId(formDef.getId());
            form.setStatus("deploy");
            form.setExpand(formDef.getExpand());
            if (oldForm != null) {
                form.setId(oldForm.getId());
                if ("deploy".equals(oldForm.getStatus())) {
                    this.createNewVersionForm(form);
                    ThreadMsgUtil.addMapMsg2((String)"formsUpdatedReleased", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                } else if ("draft".equals(oldForm.getStatus())) {
                    this.createNewDraftForm(form);
                    ThreadMsgUtil.addMapMsg2((String)"formsUpdated", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                }
            } else {
                form.setId(UniqueIdUtil.getSuid());
                if (StringUtil.isEmpty((String)typeId)) {
                    ObjectNode sysType2 = this.portalFeignService.getSysTypeById(formDef.getTypeId());
                    if (BeanUtils.isEmpty((Object)sysType2)) {
                        sysType2 = this.portalFeignService.getSysTypeByType("FORM_TYPE", "default");
                    }
                    if (BeanUtils.isNotEmpty((Object)sysType2)) {
                        form.setTypeId(sysType2.get("id").asText());
                        form.setTypeName(sysType2.get("name").asText());
                    }
                }
                form.setVersion(1);
                form.setIsMain('Y');
                form.setUpdateTime(LocalDateTime.now());
                form.setCreateTime(LocalDateTime.now());
                form.setCreateBy(ContextUtil.getCurrentUserId());
                this.create((Model)form);
                ThreadMsgUtil.addMapMsg2((String)"formsAddedPublished", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
            }
            List<FormField> fields = this.formFieldManager.getByFormId(formDef.getId());
            if (BeanUtils.isEmpty(fields)) {
                this.formMetaManager.createFields(formDef, entIdMap);
            }
            this.updatePermissionm(form.getFormKey());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importByFormXml(FormImportData formImportData) throws Exception {
        this.importByFormXml(formImportData.getXml(), formImportData.getTypeId(), formImportData.getImportBoDefs(), formImportData.getNameMap(), formImportData.getHasRightImportForms());
    }

    @Override
    public Map<String, String> exportForms(List<String> idList, boolean containBo, boolean containRight) {
        FormImportXml formImport = new FormImportXml();
        HashSet<String> listFormKey = new HashSet<String>();
        int formType = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> boDefIds = new HashSet<String>();
        ArrayList<Form> forms = new ArrayList<Form>();
        for (String formId : idList) {
            FormXml formXml = new FormXml();
            Form form = this.get((Serializable)((Object)formId));
            Assert.notNull((Object)((Object)form), (String)("\u4e0d\u5b58\u5728id\u4e3a[" + formId + "]\u8be5\u8868\u5355"));
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
            Assert.notNull((Object)((Object)form), (String)("\u4e0d\u5b58\u5728id\u4e3a[" + form.getDefId() + "]\u8868\u5355\u5143\u6570\u636e\u5bf9\u8c61"));
            List<String> boCodes = this.formMetaManager.getBOCodeByFormId(form.getDefId());
            formXml.setBpmForm(form);
            formXml.setBpmFormDef(formDef);
            formXml.setBoCodes(boCodes);
            formImport.addFormXml(formXml);
            forms.add(form);
            boDefIds.add(form.getDefId());
            listFormKey.add(form.getFormKey());
            formType = this.getFormType(form);
        }
        try {
            map.put("form.xml", JAXBUtil.marshall((Object)formImport, FormImportXml.class));
            if (containBo) {
                Map<String, String> exportBo = this.exportBo(boDefIds);
                map.putAll(exportBo);
            }
            if (containRight) {
                Map<String, String> exportRight = this.exportRight(new ArrayList<String>(listFormKey), formType);
                map.putAll(exportRight);
            }
            Map<String, String> exportFormComponentRelation = this.exportFormComponentRelation(forms);
            map.putAll(exportFormComponentRelation);
        }
        catch (JAXBException e) {
            throw new RuntimeException("\u5bfc\u51fa\u8868\u5355\u5931\u8d25" + e.getMessage(), e);
        }
        return map;
    }

    private Map<String, String> exportFormComponentRelation(List<Form> forms) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, List> componentsAliasMap = new HashMap<String, List>();
        forms.forEach(form -> {
            try {
                JsonNode expand = JsonUtil.toJsonNode((String)form.getExpand());
                ArrayNode list = JsonUtil.getArray((JsonNode)expand, (String)"list");
                this.handleComponents(list, componentsAliasMap);
            }
            catch (IOException e) {
                throw new BaseException((Throwable)e);
            }
        });
        componentsAliasMap.forEach((key, value) -> {
            try {
                if (BeanUtils.isNotEmpty((Object)value)) {
                    FormComponentIOService service = this.formComponentIOServiceFactory.getBean((String)key);
                    Map<String, String> exportContent = service.getExportContent(value.toArray(new String[0]));
                    result.putAll(exportContent);
                }
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
        });
        return result;
    }

    private void handleComponents(ArrayNode list, Map<String, List<String>> map) {
        list.forEach(item -> {
            String ctrlType = JsonUtil.getString((JsonNode)item, (String)"ctrlType");
            if (this.LAYOUT_TYPES.contains(ctrlType)) {
                if (this.SUB_LAYOUT_TYPE.contains(ctrlType)) {
                    this.handleComponents(JsonUtil.getArray((JsonNode)item, (String)"list"), map);
                } else {
                    ArrayNode columns = JsonUtil.getArray((JsonNode)item, (String)"columns");
                    columns.forEach(column -> this.handleComponents(JsonUtil.getArray((JsonNode)column, (String)"list"), map));
                }
            } else {
                this.handleComponent((JsonNode)item, map);
            }
        });
    }

    private void handleComponent(JsonNode component, Map<String, List<String>> map) {
        String ctrlType;
        JsonNode options = component.get("options");
        if (options.has("bindIdentityjson")) {
            this.setAlias(ComponentType.IDENTITY_NUMBER, options, map);
        }
        if (options.has("customQuery")) {
            this.setAlias(ComponentType.CUSTOM_QUERY, options, map);
        }
        if (this.EXPORT_COMPONENT_TYPES.contains(ctrlType = JsonUtil.getString((JsonNode)component, (String)"ctrlType"))) {
            if (!map.containsKey(ctrlType)) {
                map.put(ctrlType, new ArrayList());
            }
            String alias = this.formComponentIOServiceFactory.getBean(ctrlType).getAlias((ObjectNode)component.get("options"));
            map.get(ctrlType).add(alias);
        }
    }

    private void setAlias(ComponentType componentType, JsonNode options, Map<String, List<String>> map) {
        String alias;
        String key = componentType.getValue();
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        if (StringUtil.isNotEmpty((String)(alias = this.formComponentIOServiceFactory.getBean(componentType.getValue()).getAlias((ObjectNode)options)))) {
            map.get(key).add(alias);
        }
    }

    private int getFormType(Form form) {
        if (FormType.PC.value().equals(form.getFormType())) {
            return 0;
        }
        if (FormType.MOBILE.value().equals(form.getFormType())) {
            return 1;
        }
        return 0;
    }

    private Map<String, String> exportRight(List<String> listFormKey, int formType) throws JAXBException {
        HashMap<String, String> result = new HashMap<String, String>();
        List<FormRight> formRightList = this.bpmFormRightManager.getByFormKeys(listFormKey, formType);
        if (CollUtil.isNotEmpty(formRightList)) {
            FormRightXml formRightXml = new FormRightXml();
            formRightXml.addBpmFormRight(formRightList);
            result.put("formrights.xml", JAXBUtil.marshall((Object)formRightXml, FormRightXml.class));
        }
        return result;
    }

    private Map<String, String> exportBo(Set<String> boDefIds) throws JAXBException {
        HashMap<String, String> result = new HashMap<String, String>();
        BoDefXml bodefXml = new BoDefXml();
        boDefIds.forEach(boDefId -> {
            List<String> boIds = this.formMetaManager.getBODefIdByFormId((String)boDefId);
            HashSet<String> boIdSet = new HashSet<String>(boIds);
            for (String boId : boIdSet) {
                BoDef bodef = this.boDefService.getByDefId(boId);
                bodefXml.addBodef(bodef);
            }
        });
        result.put("bo.xml", JAXBUtil.marshall((Object)bodefXml, BoDefXml.class));
        return result;
    }

    @Override
    public String genByField(String defId, String attrId, String formType) {
        FormMeta def = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
        String html = "";
        if (def != null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            if (def.getExpand() != null) {
                try {
                    JsonNode expand = JsonUtil.toJsonNode((String)def.getExpand());
                    JsonNode tables = expand.get("fields");
                    ObjectNode field = JsonUtil.getMapper().createObjectNode();
                    Boolean isSub = false;
                    for (JsonNode table : tables) {
                        JsonNode fields = table.get("children");
                        for (int i = 0; i < fields.size(); ++i) {
                            JsonNode f = fields.get(i);
                            if (!f.get("boAttrId").equals((Object)attrId)) continue;
                            field = f;
                            isSub = !"main".equals(table.get("type"));
                        }
                    }
                    map.put("isSub", isSub);
                    map.put("field", (Boolean)field);
                }
                catch (IOException e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            String macroTemplate = this.formTemplateManager.getByTemplateAlias("mobile".equals(formType) ? "mobileFieldMacro" : "fieldControl").getHtml();
            String template = "<@input field=field isSub=isSub/>" + macroTemplate;
            try {
                html = this.freemarkEngine.parseByTempName(template, map);
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        return html;
    }

    @Transactional
    public void update(Form bpmForm) {
        super.update((Model)bpmForm);
        this.removeFromCache(bpmForm.getFormKey());
    }

    @Transactional
    public void remove(Serializable id) {
        Form bpmForm = this.get(id);
        this.removeFromCache(bpmForm.getFormKey());
        super.remove(id);
    }

    @Override
    @Transactional
    public void remove(String[] aryIds) {
        for (String id : aryIds) {
            Form bpmForm = this.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)((Object)bpmForm))) continue;
            String formKey = bpmForm.getFormKey();
            if ("Y".equals(String.valueOf(bpmForm.getIsMain()))) {
                List<Form> list = ((FormDao)this.baseMapper).getByFormKey(formKey);
                for (Form bpmform : list) {
                    this.remove((Serializable)((Object)bpmform.getId()));
                }
                this.dataTemplateManager.removeByFormKey(formKey);
                QueryWrapper pWrapper = new QueryWrapper();
                pWrapper.eq((Object)"FORM_KEY_", (Object)bpmForm.getFormKey());
                List templateList = this.formPrintTemplateManager.list((Wrapper)pWrapper);
                if (BeanUtils.isNotEmpty((Object)templateList)) {
                    ArrayList<String> printFormIds = new ArrayList<String>();
                    ArrayList<String> printIds = new ArrayList<String>();
                    for (FormPrintTemplate formPrintTemplate : templateList) {
                        if ("form".equals(formPrintTemplate.getPrintType())) {
                            printFormIds.add(formPrintTemplate.getFormId());
                        }
                        printIds.add(formPrintTemplate.getId());
                    }
                    if (BeanUtils.isNotEmpty(printFormIds)) {
                        this.remove(printFormIds.toArray(new String[printFormIds.size()]));
                    }
                    this.formPrintTemplateManager.removeByIds(printIds);
                }
            } else {
                this.remove((Serializable)((Object)id));
            }
            String fromDefId = bpmForm.getDefId();
            this.formMetaManager.remove((Serializable)((Object)fromDefId));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("FORM_ID_", fromDefId);
            this.formFieldManager.removeByMap(map);
            this.formMetaManager.deleteBpmFormBo(fromDefId);
            this.removeFromCache(bpmForm.getFormKey());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> saveFormJs(String formId, String divJs, String formHtml, String formExpand, String formCss) {
        Form form = this.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            formHtml = FormHtmlUtil.htmlCompressor(formHtml);
            form.setDiyJs(divJs);
            form.setFormHtml(formHtml);
            form.setFormCss(formCss);
            this.update(form);
            FormHistoryRecord entity = new FormHistoryRecord();
            entity.setId(UniqueIdUtil.getSuid());
            entity.setFormId(formId);
            entity.setFormHtml(formHtml);
            entity.setFormExpand(formExpand);
            entity.setDiyJs(divJs);
            entity.setFormCss(formCss);
            entity.setVersion(form.getVersion());
            this.formHistoryRecordManager.create((Model)entity);
            this.removeFromCache(form.getFormKey());
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        return new CommonResult(false, "\u8bf7\u5148\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u518d\u6dfb\u52a0\u81ea\u5b9a\u4e49\u811a\u672c");
    }

    @Override
    @Transactional
    public CommonResult<String> updateFormHistoryRecord(FormHistoryRecord formHistoryRecord) {
        String formId = formHistoryRecord.getFormId();
        String formHtml = formHistoryRecord.getFormHtml();
        String formExpand = formHistoryRecord.getFormExpand();
        String diyJs = formHistoryRecord.getDiyJs();
        Form form = this.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            form.setFormHtml(formHtml);
            form.setExpand(formExpand);
            form.setDiyJs(diyJs);
            this.update(form);
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
            formDef.setExpand(formExpand);
            this.formMetaManager.update((Model)formDef);
            this.removeFromCache(form.getFormKey());
            return new CommonResult(true, "\u6062\u590d\u6210\u529f");
        }
        return new CommonResult(false, "\u8bf7\u5148\u4fdd\u5b58\u8868\u5355\u5185\u5bb9");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public void saveDesign(String formData) throws Exception {
        JsonNode bpmFormdefNode;
        Form form = new Form();
        FormMeta bpmFormdef = new FormMeta();
        JsonNode paramNode = JsonUtil.toJsonNode((String)formData);
        JsonNode formJson = paramNode.get("form");
        JsonNode expandJson = paramNode.get("expand");
        String expand = JsonUtil.toJson((Object)expandJson);
        String ganged = paramNode.get("ganged").asText();
        String opinion = paramNode.get("opinion").asText();
        String rev = paramNode.get("rev").asText();
        String formId = formJson.get("formId").asText();
        String newType = formJson.get("newType").asText();
        if (StringUtil.isNotEmpty((String)formId)) {
            form = this.get((Serializable)((Object)formId));
            bpmFormdef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
            bpmFormdefNode = paramNode.get("formDef");
            bpmFormdef.setMacroAlias(bpmFormdefNode.get("macroAlias").asText());
            bpmFormdef.setMainAlias(bpmFormdefNode.get("mainAlias").asText());
            bpmFormdef.setSubEntity(bpmFormdefNode.get("subEntity").asText());
        } else {
            bpmFormdefNode = paramNode.get("formDef");
            bpmFormdef.setType(bpmFormdefNode.get("type").asText());
            bpmFormdef.setTypeId(bpmFormdefNode.get("typeId").asText());
            bpmFormdef.setName(bpmFormdefNode.get("name").asText());
            bpmFormdef.setKey(bpmFormdefNode.get("key").asText());
            bpmFormdef.setDesc(bpmFormdefNode.get("desc").asText());
            bpmFormdef.setMacroAlias(bpmFormdefNode.get("macroAlias").asText());
            bpmFormdef.setMainAlias(bpmFormdefNode.get("mainAlias").asText());
            bpmFormdef.setSubEntity(bpmFormdefNode.get("subEntity").asText());
            String formKey = bpmFormdef.getKey();
            if (this.formMetaManager.getByKey(formKey) != null) {
                throw new RuntimeException("\u8868\u5355\u5df2\u7ecf\u5b58\u5728\uff01key:" + formKey);
            }
            form.setName(formJson.get("name").asText());
            form.setFormKey(formJson.get("formKey").asText());
            form.setTypeId(bpmFormdef.getTypeId());
            form.setTypeName(bpmFormdef.getType());
            form.setFormType(formJson.get("formType").asText());
        }
        bpmFormdef.setGanged(ganged);
        bpmFormdef.setExpand(expand);
        if (BeanUtils.isNotEmpty((Object)bpmFormdef.getId())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", bpmFormdef.getId());
            map.put("rev", rev);
            FormMeta bpmFormDef1 = this.formMetaManager.getFormDefByRev(map);
            if (!BeanUtils.isNotEmpty((Object)((Object)bpmFormDef1))) throw new RuntimeException("\u6b64\u8868\u5355\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            this.formMetaManager.update((Model)bpmFormdef);
        } else {
            bpmFormdef.setId(UniqueIdUtil.getSuid());
            this.formMetaManager.create((Model)bpmFormdef);
        }
        this.formMetaManager.updateOpinionConf(bpmFormdef.getId(), opinion);
        String formHtml = "";
        String formI18nName = expandJson.has("designFormName") ? expandJson.get("designFormName").asText() : form.getName();
        formHtml = FormType.MOBILE.value().equals(form.getFormType()) ? this.getMobileDesignHtml(expandJson, formI18nName, ganged) : this.getDesignHtml(expandJson, formI18nName, ganged, JsonUtil.toJsonNode((Object)((Object)bpmFormdef)));
        form.setFormHtml(formHtml);
        if (StringUtil.isEmpty((String)form.getId())) {
            form.setDefId(bpmFormdef.getId());
            List<Form> bpmForm = this.getByFormKey(form.getFormKey());
            if (BeanUtils.isNotEmpty(bpmForm)) {
                throw new RuntimeException("KEY\u3010" + form.getFormKey() + "\u3011\u5bf9\u5e94\u7684\u8868\u5355\u5df2\u5b58\u5728");
            }
            form.setId(UniqueIdUtil.getSuid());
            this.create((Model)form);
        } else if ("new".equals(newType)) {
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(form.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            Form newBpmForm = form;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('N');
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            this.create((Model)newBpmForm);
            this.publish(newFormId);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        } else {
            form.setName(formJson.get("name").asText());
            this.update(form);
        }
        FormHistory bpmFormDefHi = new FormHistory(form);
        this.formHistoryManager.create((Model)bpmFormDefHi);
    }

    private void updatePermissionm(String asText) throws IOException {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("FORM_KEY_", (Object)asText, QueryOP.EQUAL);
        List queryNoPage = this.bpmFormRightManager.queryNoPage(queryFilter);
        BaseContextThreadUtil.putCommonVars((String)"update_permission", (Object)true);
        JsonNode Default = this.bpmFormRightManager.getDefaultByFormDefKey(asText, false);
        JsonNode instaPermissionm = this.bpmFormRightManager.getDefaultByFormDefKey(asText, false);
        for (FormRight formRight : queryNoPage) {
            String json;
            String permission = formRight.getPermission();
            JsonNode oldPermission = JsonUtil.toJsonNode((String)permission);
            JsonNode oldTable = oldPermission.get("table");
            JsonNode newPermission = null;
            newPermission = formRight.getPermissionType() == 1 ? JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)Default)) : JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)instaPermissionm));
            JsonNode newTable = newPermission.get("table");
            Iterator fieldNames = newTable.fieldNames();
            while (fieldNames.hasNext()) {
                ObjectNode newField;
                String FieldsKey;
                Iterator newFieldsKey;
                String key = (String)fieldNames.next();
                if (!BeanUtils.isNotEmpty((Object)oldTable) || !BeanUtils.isNotEmpty((Object)oldTable.get(key))) continue;
                JsonNode oldFields = oldTable.get(key).get("fields");
                JsonNode newFields = newTable.get(key).get("fields");
                if (BeanUtils.isEmpty((Object)newFields)) continue;
                JsonNode oldRights = oldTable.get(key).get("rights");
                JsonNode newRights = newTable.get(key).get("rights");
                if (BeanUtils.isNotEmpty((Object)oldRights) && BeanUtils.isNotEmpty((Object)newRights)) {
                    newFieldsKey = newRights.fieldNames();
                    while (newFieldsKey.hasNext()) {
                        FieldsKey = (String)newFieldsKey.next();
                        if (!BeanUtils.isNotEmpty((Object)oldRights.get(FieldsKey))) continue;
                        newField = (ObjectNode)newRights;
                        newField.set(FieldsKey, oldRights.get(FieldsKey));
                    }
                }
                newFieldsKey = newFields.fieldNames();
                while (newFieldsKey.hasNext()) {
                    FieldsKey = (String)newFieldsKey.next();
                    if (oldFields == null || !BeanUtils.isNotEmpty((Object)oldFields.get(FieldsKey))) continue;
                    newField = (ObjectNode)newFields;
                    newField.set(FieldsKey, oldFields.get(FieldsKey));
                }
                Iterator fields = oldTable.fields();
                while (fields.hasNext()) {
                    Map.Entry node = (Map.Entry)fields.next();
                    JsonNode value = (JsonNode)node.getValue();
                    if (!BeanUtils.isNotEmpty((Object)value) || !value.isObject() || !BeanUtils.isNotEmpty((Object)value.get("ctrlType")) || !"dataView".equals(value.get("ctrlType").asText()) || !newTable.has((String)node.getKey())) continue;
                    ObjectNode newTableNode = (ObjectNode)newTable;
                    newTableNode.set((String)node.getKey(), value);
                }
            }
            if (oldPermission.has("subRowAuth")) {
                ObjectNode newPermissionObj = (ObjectNode)newPermission;
                newPermissionObj.put("subRowAuth", oldPermission.get("subRowAuth"));
            }
            if ((json = JsonUtil.toJson((Object)newPermission)).equals(formRight.getPermission())) continue;
            formRight.setPermission(json);
            this.bpmFormRightManager.update((Model)formRight);
        }
    }

    @Override
    @Transactional
    public void saveFormDef(BpmFormVo bpmFormVo) throws Exception {
        FormMeta bpmFormdef = bpmFormVo.getBpmFormDef();
        Form form = bpmFormVo.getBpmForm();
        form.setExpand(bpmFormdef.getExpand());
        if (StringUtil.isEmpty((String)bpmFormdef.getId())) {
            this.formMetaManager.create((Model)bpmFormdef);
            form.setDefId(bpmFormdef.getId());
        } else {
            if ("pc".equals(bpmFormVo.getBpmForm().getFormType())) {
                CustomUtil.checkEditRight(Form.class, ResourceModelType.PC_FORM, bpmFormVo.getBpmForm().getFormKey());
            } else {
                CustomUtil.checkEditRight(Form.class, ResourceModelType.MOBILE_FORFM, bpmFormVo.getBpmForm().getFormKey());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", bpmFormdef.getId());
            map.put("rev", bpmFormdef.getRev());
            FormMeta bpmFormDef1 = this.formMetaManager.getFormDefByRev(map);
            if (BeanUtils.isEmpty((Object)((Object)bpmFormDef1))) {
                throw new BaseException("\u6b64\u8868\u5355\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
            this.formMetaManager.update((Model)bpmFormdef);
        }
        this.genFromHtml(bpmFormVo);
        Form oldBpmForm = null;
        if (StringUtil.isNotEmpty((String)form.getId())) {
            oldBpmForm = (Form)((Object)((FormDao)this.baseMapper).selectById((Serializable)((Object)form.getId())));
        }
        if (StringUtil.isEmpty((String)form.getId())) {
            form.setStatus("draft");
            form.setUpdateTime(DateUtil.getCurrentDate());
            form.setCreateBy(ContextUtil.getCurrentUserId());
            this.create((Model)form);
        } else if ("newForm".equals(bpmFormVo.getNewForm())) {
            if ("draft".equals(form.getStatus())) {
                this.publish(form.getId());
            }
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(form.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            this.setDefaultVersion(newFormId, form.getFormKey());
            Form newBpmForm = form;
            if (StringUtil.isNotEmpty((String)oldBpmForm.getDiyJs())) {
                newBpmForm.setDiyJs(oldBpmForm.getDiyJs());
            }
            newBpmForm.setCreateBy(oldBpmForm.getCreateBy());
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('Y');
            newBpmForm.setVersion(rtn + 1);
            newBpmForm.setUpdateTime(DateUtil.getCurrentDate());
            newBpmForm.setStatus("deploy");
            this.create((Model)newBpmForm);
        } else {
            if (BeanUtils.isNotEmpty((Object)((Object)oldBpmForm))) {
                form.setDiyJs(oldBpmForm.getDiyJs());
                form.setCreateBy(oldBpmForm.getCreateBy());
            }
            this.update(form);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)oldBpmForm))) {
            FormHistoryRecord formHistoryRecord = new FormHistoryRecord(oldBpmForm);
            this.formHistoryRecordManager.create((Model)formHistoryRecord);
        }
        this.updatePermissionm(bpmFormVo.getBpmForm().getFormKey());
        this.bpmFormRightManager.removeDefaultRightCache(bpmFormVo.getBpmForm().getFormKey(), true);
        this.bpmFormRightManager.removeDefaultRightCache(bpmFormVo.getBpmForm().getFormKey(), false);
    }

    @Override
    @Transactional
    public void generateFrom(BpmFormVo bpmFormVo) throws Exception {
        this.genFromHtml(bpmFormVo);
        this.formMetaManager.update((Model)bpmFormVo.getBpmFormDef());
        this.update(bpmFormVo.getBpmForm());
        FormHistory bpmFormDefHi = new FormHistory(bpmFormVo.getBpmForm());
        this.formHistoryManager.create((Model)bpmFormDefHi);
    }

    private String genFromHtml(BpmFormVo bpmFormVo) throws Exception {
        FormMeta bpmFormDef = bpmFormVo.getBpmFormDef();
        Form bpmForm = bpmFormVo.getBpmForm();
        if (StringUtil.isNotEmpty((String)bpmForm.getFormHtml())) {
            return bpmForm.getFormHtml();
        }
        String formSetting = bpmFormVo.getBpmForm().getFormSetting();
        String expand = bpmFormDef.getExpand();
        String html = this.genFromHtml(formSetting, expand, "mobile".equals(bpmForm.getFormType()));
        bpmFormVo.getBpmForm().setFormHtml(html);
        return html;
    }

    private String genFromHtml(String formSetting, String expand, boolean isMobile) throws Exception {
        JsonNode expandJsonNode = JsonUtil.toJsonNode((String)expand);
        JsonNode field = expandJsonNode.get("list");
        ArrayList layoutList = new ArrayList();
        field.forEach(obj -> {
            try {
                if (!isMobile || !LayoutType.HOT_TABLE.getValue().equals(JsonUtil.getString((JsonNode)obj, (String)"ctrlType"))) {
                    layoutList.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)obj)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        mapObj.put("layoutList", layoutList);
        mapObj.put("expandMap", JsonUtil.toMap((String)expand));
        mapObj.put("util", freeMakerUtil);
        if (BeanUtils.isNotEmpty((Object)formSetting)) {
            mapObj.put("formSetting", JsonUtil.toJsonNode((String)formSetting));
        }
        mapObj.put("isMobile", isMobile);
        FormTemplate fieldControl = this.formTemplateManager.getByTemplateAlias("fieldControl");
        if (BeanUtils.isEmpty((Object)((Object)fieldControl))) {
            throw new BaseException("\uff0c\u672a\u521d\u59cb\u5316\u6a21\u677f\uff0c\u8bf7\u5728PC\u8868\u5355\u4e2d\u6267\u884c\u521d\u59cb\u5316\uff01");
        }
        List<FormTemplate> bpmFormTpls = this.formTemplateManager.getTemplateType("formDesign");
        StringBuffer formDesignFtl = new StringBuffer(fieldControl.getHtml());
        for (FormTemplate bpmFormTemplate : bpmFormTpls) {
            formDesignFtl.append(bpmFormTemplate.getHtml());
        }
        String html = this.freemarkEngine.parseByTemplate(formDesignFtl.toString(), mapObj);
        html = FormHtmlUtil.htmlCompressor(html);
        return html;
    }

    @Override
    @Transactional
    public void pcForm2MobileForm(String formId) throws Exception {
        Form bpmForm = this.get((Serializable)((Object)formId));
        bpmForm.setFormHtml("");
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId()));
        Form mainByFormKey = ((FormDao)this.baseMapper).getMainByFormKey(bpmForm.getFormKey() + "mobile");
        if (BeanUtils.isNotEmpty((Object)((Object)mainByFormKey))) {
            throw new BaseException(String.format("\u5df2\u7ecf\u751f\u6210\u8868\u5355key\u4e3a\u3010%s\u3011\u7684\u8868\u5355", mainByFormKey.getFormKey()));
        }
        BpmFormVo bpmFormVo = new BpmFormVo();
        bpmForm.setId("");
        bpmForm.setFormKey(bpmForm.getFormKey() + "mobile");
        bpmForm.setFormType("mobile");
        this.setFormSettingFullscreen(bpmForm);
        bpmFormDef.setId("");
        bpmFormDef.setKey(bpmFormDef.getKey() + "mobile");
        bpmFormDef.setExpand(FormUtil.transformationMobileExpand(bpmFormDef.getExpand()));
        bpmFormVo.setBpmForm(bpmForm);
        bpmFormVo.setBpmFormDef(bpmFormDef);
        this.saveFormDef(bpmFormVo);
    }

    private void setFormSettingFullscreen(Form bpmForm) throws Exception {
        if (bpmForm == null || StringUtil.isEmpty((String)bpmForm.getFormSetting())) {
            return;
        }
        ObjectNode settingNode = (ObjectNode)JsonUtil.toJsonNode((String)bpmForm.getFormSetting());
        settingNode.put("widthType", "fullscreen");
        bpmForm.setFormSetting(JsonUtil.toJson((Object)settingNode));
    }

    @Override
    public CommonResult<String> checkMobileForm(String formId) throws Exception {
        Form bpmForm = this.get((Serializable)((Object)formId));
        Form mainByFormKey = ((FormDao)this.baseMapper).getMainByFormKey(bpmForm.getFormKey() + "mobile");
        if (BeanUtils.isNotEmpty((Object)((Object)mainByFormKey))) {
            return new CommonResult(true, "", (Object)"update");
        }
        return new CommonResult(true, "", (Object)"create");
    }

    @Override
    @Transactional
    public void pcUpdateMobileForm(String formId) throws Exception {
        Form bpmForm = this.get((Serializable)((Object)formId));
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId()));
        Form mobileForm = ((FormDao)this.baseMapper).getMainByFormKey(bpmForm.getFormKey() + "mobile");
        mobileForm.setName(bpmForm.getName());
        this.setFormSettingFullscreen(mobileForm);
        FormMeta mobileFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)mobileForm.getDefId()));
        BpmFormVo bpmFormVo = new BpmFormVo();
        mobileFormDef.setExpand(FormUtil.transformationMobileExpand(bpmFormDef.getExpand()));
        bpmFormVo.setBpmForm(mobileForm);
        bpmFormVo.setBpmFormDef(mobileFormDef);
        if ("deploy".equals(mobileForm.getStatus())) {
            bpmFormVo.setNewForm("newForm");
        }
        this.saveFormDef(bpmFormVo);
    }

    @Override
    public Map<String, Object> getBindRelation(String defId, String formKey, String formId) throws Exception {
        if (StringUtil.isEmpty((String)defId)) {
            Form form = this.get((Serializable)((Object)formId));
            Assert.notNull((Object)((Object)form), (String)"\u8868\u5355\u4e0d\u5b58\u5728");
            defId = form.getDefId();
        }
        List<Map<String, Object>> boEnt = ((FormDao)this.baseMapper).getBoEnt(defId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty(boEnt)) {
            List bpmData = this.boDefManager.getBpmDefinitionData(boEnt.get(0).get("alias_").toString());
            HashMap<String, BoBpmShipGroup> shipMap = new HashMap<String, BoBpmShipGroup>();
            for (Map bpmDatum : bpmData) {
                JsonNode pcForm;
                String curDefId = (String)bpmDatum.get("def_id_");
                Map definitionData = this.bpmModelFeignService.definitionData(curDefId);
                if (definitionData.size() <= 0) continue;
                if (definitionData.containsKey("pcForm")) {
                    pcForm = JsonUtil.toJsonNode(definitionData.get("pcForm"));
                    if (!pcForm.get("pcAlias").asText().equals(formKey)) continue;
                    this.buildBoBpmShipGroup(definitionData, shipMap, curDefId);
                    continue;
                }
                if (!definitionData.containsKey("mobileForm") || !(pcForm = JsonUtil.toJsonNode(definitionData.get("mobileForm"))).get("mobileAlias").asText().equals(formKey)) continue;
                this.buildBoBpmShipGroup(definitionData, shipMap, curDefId);
            }
            map.put("bpmData", shipMap.values());
            map.put("entData", boEnt);
            map.put("defId", defId);
        }
        return map;
    }

    private void buildBoBpmShipGroup(Map<String, Object> definitionData, Map<String, BoBpmShipGroup> shipMap, String curDefId) {
        String defKey = MapUtil.getString(definitionData, (String)"defKey");
        String mainDefId = MapUtil.getString(definitionData, (String)"mainDefId");
        String flowName = MapUtil.getString(definitionData, (String)"defName");
        String version = MapUtil.getString(definitionData, (String)"version");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)defKey), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230defKey");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)mainDefId), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u4e3b\u7248\u672c");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)flowName), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u540d\u79f0");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)version), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u7248\u672c\u53f7");
        BoBpmShipGroup shipGroup = null;
        if (!shipMap.containsKey(defKey)) {
            shipGroup = BoBpmShipGroup.build((String)defKey, (String)flowName);
            shipMap.put(defKey, shipGroup);
        }
        shipGroup = shipMap.get(defKey);
        shipGroup.addShip(curDefId, version, curDefId.equals(mainDefId));
    }

    @Override
    public Map<String, Object> getFormData(String pcAlias, String mobileAlias) throws Exception {
        List<Map<String, Object>> boEnt;
        QueryWrapper eq;
        QueryWrapper queryWrapper = new QueryWrapper();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)pcAlias)) {
            eq = (QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"form_key_", (Object)pcAlias)).eq((Object)"form_type_", (Object)"pc")).eq((Object)"is_main_", (Object)"Y");
            List pcForms = ((FormDao)this.baseMapper).selectList((Wrapper)eq);
            boEnt = ((FormDao)this.baseMapper).getBoEnt(((Form)((Object)pcForms.get(0))).getDefId());
            map.put("pcEnt", boEnt.get(0));
        }
        if (StringUtil.isNotEmpty((String)mobileAlias)) {
            eq = (QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"form_key_", (Object)mobileAlias)).eq((Object)"form_type_", (Object)"mobile")).eq((Object)"is_main_", (Object)"Y");
            List mobileForms = ((FormDao)this.baseMapper).selectList((Wrapper)eq);
            boEnt = ((FormDao)this.baseMapper).getBoEnt(((Form)((Object)mobileForms.get(0))).getDefId());
            map.put("mobileEnt", boEnt.get(0));
        }
        return map;
    }

    @Override
    public Map<String, Object> getPreviewDesignVueData(String formId, String formKeyRelation) throws Exception {
        Form bpmForm = this.get((Serializable)((Object)formId));
        return this.getPreviewDesignVueData(bpmForm, formKeyRelation);
    }

    @Override
    public Map<String, Object> getPreviewDesignVueDataByFormKey(String formKey) throws Exception {
        Form bpmForm = this.getMainByFormKey(formKey);
        return this.getPreviewDesignVueData(bpmForm, null);
    }

    @Override
    public Map<String, Object> getPreviewDesignVueData(Form bpmForm, String formKeyRelation) throws Exception {
        FormMeta formMeta = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId()));
        JsonNode jsonNodeExpand = JsonUtil.toJsonNode((String)formMeta.getExpand());
        String expand = "";
        if (BeanUtils.isNotEmpty((Object)jsonNodeExpand)) {
            expand = JsonUtil.toJson((Object)jsonNodeExpand.get("boDefList"));
        }
        ArrayList<BoDef> boDefList = new ArrayList<BoDef>();
        ArrayNode bosArray = (ArrayNode)JsonUtil.toBean((String)expand, ArrayNode.class);
        for (int i = 0; i < bosArray.size(); ++i) {
            JsonNode obj = bosArray.get(i);
            BoDef boDef = this.bODefManager.getByAlias(obj.get("alias").asText());
            if (!BeanUtils.isNotEmpty((Object)boDef)) continue;
            boDefList.add(boDef);
        }
        List<BoData> boJson = this.formService.getBoDataByBoDefs(boDefList);
        ObjectNode object = BoUtil.hanlerData(boJson);
        String formKey = StringUtil.isNotEmpty((String)formKeyRelation) ? formKeyRelation : bpmForm.getFormKey();
        JsonNode permissionConf = this.bpmFormRightManager.getByFormKey(formKey, false, formMeta, boDefList);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bpmForm", (Object)bpmForm);
        resultMap.put("permission", permission);
        resultMap.put("data", object);
        return resultMap;
    }

    @Override
    public Map<String, Object> getPreviewDesignData(FormPreviewDataParam param) throws Exception {
        ObjectNode expand = JsonUtil.getMapper().createObjectNode();
        String expandStr = "";
        Form bpmForm = new Form();
        String id = param.getId();
        String design = param.getDesign();
        ArrayNode bosArray = null;
        String formDefId = "";
        if (StringUtil.isNotEmpty((String)id) && StringUtil.isEmpty((String)design)) {
            FormMeta formDef;
            bpmForm = this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)((Object)bpmForm)) && BeanUtils.isNotEmpty((Object)((Object)(formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId())))))) {
                formDefId = formDef.getId();
                expandStr = formDef.getExpand();
                expand = (ObjectNode)JsonUtil.toBean((String)expandStr, ObjectNode.class);
            }
        } else {
            ObjectNode designJson = (ObjectNode)JsonUtil.toBean((String)design, ObjectNode.class);
            expand = (ObjectNode)designJson.get("expand");
            expandStr = JsonUtil.toJson((Object)expand);
            String ganged = JsonUtil.toJson((Object)designJson.get("ganged"));
            String tableNames = "";
            String form = param.getForm();
            JsonNode formDefNode = designJson.get("formDef");
            if (StringUtil.isNotEmpty((String)form)) {
                ObjectNode formNode = (ObjectNode)JsonUtil.toJsonNode((String)form);
                tableNames = formNode.get("name").asText();
            }
            String formHtml = "";
            formHtml = FormType.MOBILE.value().equals(param.getFormType()) ? this.getMobileDesignHtml((JsonNode)expand, tableNames, ganged) : this.getDesignHtml((JsonNode)expand, tableNames, ganged, formDefNode);
            if (StringUtil.isNotEmpty((String)formHtml)) {
                bpmForm.setFormHtml(formHtml);
            }
        }
        bosArray = (ArrayNode)expand.get("boDefList");
        JsonNode permissionConf = this.bpmFormRightManager.getDefaultByDesign(formDefId, expandStr, false);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        ArrayList<String> boCode = new ArrayList<String>();
        for (int i = 0; i < bosArray.size(); ++i) {
            JsonNode obj = bosArray.get(i);
            BoDef boDef = (BoDef)this.bODefManager.get((Serializable)((Object)obj.get("id").asText()));
            if (!BeanUtils.isNotEmpty((Object)boDef)) continue;
            boCode.add(boDef.getAlias());
        }
        List<BoData> boJson = this.formService.getBoDataByBoKeys(boCode);
        ObjectNode object = BoUtil.hanlerData(boJson);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bpmForm", (Object)bpmForm);
        resultMap.put("permission", permission);
        resultMap.put("data", object);
        return resultMap;
    }

    @Override
    public JsonNode getRightData(String id, String defId, String formType) throws Exception {
        Form bpmForm = new Form();
        if (StringUtil.isNotEmpty((String)id)) {
            bpmForm = this.get((Serializable)((Object)id));
            formType = bpmForm.getFormType();
        }
        if (StringUtil.isNotEmpty((String)bpmForm.getDefId())) {
            defId = bpmForm.getDefId();
        }
        FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
        JsonNode permissionConf = null;
        permissionConf = StringUtil.isNotEmpty((String)bpmForm.getFormKey()) ? this.bpmFormRightManager.getByFormKey(bpmForm.getFormKey(), false) : this.bpmFormRightManager.getDefaultByFormDefKey(formDef.getKey(), false);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        return permission;
    }

    @Override
    public Map getChooseDesignTemplate(String subject, String categoryId, String formDesc, Boolean isSimple) throws Exception {
        HashMap<String, Object> mv = new HashMap<String, Object>();
        String templatePath = FormUtil.getDesignTemplatePath();
        String xml = FileUtil.readFile((String)(templatePath + "designtemps.xml"));
        Document document = Dom4jUtil.loadXml((String)xml);
        Element root = document.getRootElement();
        List list = root.elements();
        String reStr = "[";
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String templateDesc = element.attributeValue("templateDesc");
            if (!"[".equals(reStr)) {
                reStr = reStr + ",";
            }
            reStr = reStr + "{name:'" + name + "',alias:'" + alias + "',templateDesc:'" + templateDesc + "'}";
        }
        reStr = reStr + "]";
        mv.put("subject", subject);
        mv.put("categoryId", categoryId);
        mv.put("formDesc", formDesc);
        mv.put("temps", reStr);
        mv.put("isSimple", isSimple);
        return mv;
    }

    @Override
    public void getGenByTemplate(String formId, String tableNames, String templateAlias, String formDefId, String formType, HttpServletResponse response) throws Exception {
        Form form = this.get((Serializable)((Object)formId));
        if (form != null) {
            formDefId = form.getDefId();
        }
        String html = this.getHtml(formDefId, tableNames, templateAlias);
        PrintWriter out = response.getWriter();
        html = JsoupUtil.prettyHtml(html);
        StringBuffer outHtml = new StringBuffer();
        String script = "<script type='text/javascript'>function validForm(scope){ return true;}</script>";
        outHtml.append(script);
        if (StringUtil.isNotEmpty((String)formType) && formType.equals(FormType.MOBILE.value())) {
            outHtml.append("<div style=\"height: 100%;overflow: auto;\">");
            outHtml.append(html);
            outHtml.append("</div>");
        } else {
            outHtml.append(html);
        }
        out.println(outHtml);
    }

    @Override
    public ObjectNode getFormDesign(String formId) throws Exception {
        Form form = null;
        FormMeta formDef = null;
        ObjectNode resultJson = JsonUtil.getMapper().createObjectNode();
        if (StringUtil.isNotEmpty((String)formId)) {
            ObjectNode designJson = JsonUtil.getMapper().createObjectNode();
            form = this.get((Serializable)((Object)formId));
            if (BeanUtils.isNotEmpty((Object)((Object)form)) && BeanUtils.isNotEmpty((Object)((Object)(formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId())))))) {
                resultJson.put("ganged", formDef.getGanged());
                resultJson.put("opinion", formDef.getOpinionConf());
                resultJson.put("defId", formDef.getId());
                resultJson.put("desc", formDef.getDesc());
                resultJson.put("name", formDef.getName());
                resultJson.put("rev", formDef.getRev());
                JsonNode jsonNode = JsonUtil.toJsonNode((String)formDef.getExpand());
                if (BeanUtils.isNotEmpty((Object)jsonNode)) {
                    resultJson.put("bos", JsonUtil.toJson((Object)jsonNode.get("boDefList")));
                    resultJson.put("fields", JsonUtil.toJson((Object)jsonNode.get("fields")));
                    resultJson.put("flowField", jsonNode.has("flowField") ? jsonNode.get("flowField").asText() : "");
                    resultJson.put("includeFiles", jsonNode.has("includeFiles") ? jsonNode.get("includeFiles").asText() : "");
                    resultJson.put("designFormName", jsonNode.has("designFormName") ? jsonNode.get("designFormName").asText() : "");
                    if (jsonNode.has("treeCtrl")) {
                        resultJson.set("treeCtrl", jsonNode.get("treeCtrl"));
                    }
                }
                designJson.put("type", formDef.getType());
            }
            ObjectNode formJson = JsonUtil.getMapper().createObjectNode();
            designJson.set("form", (JsonNode)formJson);
            resultJson.put("formName", form.getName());
            resultJson.put("formKey", form.getFormKey());
            resultJson.put("formType", form.getFormType());
            resultJson.put("version", form.getVersion());
            resultJson.put("status", form.getStatus());
            resultJson.put("typeId", form.getTypeId());
            resultJson.put("typeName", form.getTypeName());
            resultJson.put("desc", form.getDesc());
            resultJson.put("macroAlias", formDef.getMacroAlias());
            resultJson.put("mainAlias", formDef.getMainAlias());
            resultJson.put("subEntity", formDef.getSubEntity());
            resultJson.put("isPrint", form.getIsPrint());
            resultJson.set("design", (JsonNode)designJson);
            resultJson.put("formSetting", form.getFormSetting());
            resultJson.put("diyJs", form.getDiyJs());
            resultJson.put("formCss", form.getFormCss());
            resultJson.put("watermarkId", form.getWatermarkId());
        }
        return resultJson;
    }

    @Override
    public String getDesignHtml(JsonNode expand, String tableNames, String ganged, JsonNode formDefNode) throws Exception {
        ArrayList<Map<String, Object>> jary = new ArrayList<Map<String, Object>>();
        ArrayNode fieldList = (ArrayNode)expand.get("fields");
        for (JsonNode jsonNode : fieldList) {
            if (!"main".equals(jsonNode.get("type").asText())) continue;
            ArrayNode arr = (ArrayNode)jsonNode.get("children");
            for (JsonNode fieldNode : arr) {
                jary.add(JsonUtil.toMap((String)fieldNode.toString()));
            }
        }
        boolean hasStepControl = false;
        Map stepAttr = new HashMap();
        Iterator jaryIt = jary.iterator();
        while (jaryIt.hasNext()) {
            Map map = (Map)jaryIt.next();
            if ("textFixed".equals(map.get("ctrlType"))) {
                String desc = map.get("desc").toString();
                desc = desc.replaceAll("\"", "'");
                map.remove("desc");
                map.put("desc", desc);
            }
            if (!"stepControl".equals(map.get("ctrlType"))) continue;
            hasStepControl = true;
            stepAttr = map;
            jaryIt.remove();
        }
        String mainAlias = "";
        String macroAlias = "";
        String subEntity = "";
        mainAlias = "null".equals(formDefNode.get("mainAlias").asText()) ? "dragColumn" : formDefNode.get("mainAlias").asText();
        macroAlias = "null".equals(formDefNode.get("macroAlias").asText()) ? "fieldControl" : formDefNode.get("macroAlias").asText();
        subEntity = "null".equals(formDefNode.get("subEntity").asText()) ? "subDragColumn" : formDefNode.get("subEntity").asText();
        FormTemplate mainTemplateObj = this.formTemplateManager.getByTemplateAlias(mainAlias);
        String mainTemplate = mainTemplateObj.getHtml();
        String subTemplate = this.formTemplateManager.getByTemplateAlias(subEntity).getHtml();
        String macroTemplate = this.formTemplateManager.getByTemplateAlias(macroAlias).getHtml();
        String divContainer = this.formTemplateManager.getByTemplateAlias("divContainer").getHtml();
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        for (int i = 0; i < jary.size(); ++i) {
            if (!"iframe".equals(((Map)jary.get(i)).get("ctrlType"))) continue;
            String iframeSrc = ((Map)jary.get(i)).get("iframeSrc").toString();
            String baseUrl = this.portalFeignService.getPropertyByAlias("iframeUrl");
            if (iframeSrc.indexOf("iframeUrl") != 1) {
                iframeSrc = iframeSrc.replace("${iframeUrl}", baseUrl);
            }
            ((Map)jary.get(i)).put("iframeSrc", iframeSrc);
        }
        if (this.isContainsTabs(jary)) {
            List<Map<String, Object>> tabs = this.getTabsHtml(jary);
            ArrayList<Map<Object, Object>> newTabs = new ArrayList<Map<Object, Object>>();
            boolean _hasStepControl = hasStepControl;
            for (Map<String, Object> tab : tabs) {
                List fields = (List)tab.get("fields");
                if (this.isContainsCollapse(fields)) {
                    ArrayList<Map<String, Object>> collapse = new ArrayList<Map<String, Object>>();
                    HashMap<String, Object> mapObj = new HashMap<String, Object>();
                    mapObj.put("formDesc", tableNames);
                    mapObj.put("ganged", ganged);
                    mapObj.put("expand", expand);
                    mapObj.put("expandMap", JsonUtil.toMap((String)expand.toString()));
                    mapObj.put("util", freeMakerUtil);
                    mapObj.put("mainTemplate", mainTemplate);
                    mapObj.put("subTemplate", subTemplate);
                    mapObj.put("macroTemplate", macroTemplate);
                    mapObj.put("divContainer", divContainer);
                    List<Map<String, Object>> newCollapse = this.getFields(this.getCollapseHtml(fields), mapObj);
                    for (Map<String, Object> field : newCollapse) {
                        if (!field.containsKey("tabHtml")) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("formDesc", tableNames);
                            map.put("fieldList", field.get("fields"));
                            map.put("ganged", ganged);
                            map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                            map.put("util", freeMakerUtil);
                            map.put("isTabs", true);
                            map.put("hasStepControl", _hasStepControl);
                            map.put("stepAttr", stepAttr);
                            this.handlerTrGroup(map);
                            field.put("isCollapse", field.containsKey("collapseField"));
                            String tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                            field.put("tabHtml", tabHtml);
                        }
                        collapse.add(field);
                    }
                    _hasStepControl = hasStepControl;
                    if (collapse.size() <= 0) continue;
                    String tabsTemplate = this.formTemplateManager.getByTemplateAlias("collapseColumn").getHtml();
                    HashMap<String, Object> tabMap = new HashMap<String, Object>();
                    tabMap.put("util", freeMakerUtil);
                    tabMap.put("tabs", collapse);
                    tabMap.put("formDesc", tableNames);
                    String html = this.freemarkEngine.parseByTemplate(tabsTemplate, tabMap);
                    HashMap<String, Object> table = new HashMap<String, Object>();
                    table.put("tabHtml", html);
                    Map tabField = (Map)tab.get("tabField");
                    table.put("tabField", tabField);
                    newTabs.add(table);
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("formDesc", tableNames);
                map.put("fieldList", tab.get("fields"));
                map.put("ganged", ganged);
                map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map.put("util", freeMakerUtil);
                map.put("isTabs", true);
                map.put("hasStepControl", _hasStepControl);
                map.put("stepAttr", stepAttr);
                this.handlerTrGroup(map);
                tab.put("isCollapse", tab.containsKey("collapseField"));
                String tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                tab.put("tabHtml", tabHtml);
                newTabs.add(tab);
            }
            String tabsTemplate = this.formTemplateManager.getByTemplateAlias("tabsColumn").getHtml();
            HashMap<String, Object> tabMap = new HashMap<String, Object>();
            tabMap.put("formDesc", tableNames);
            tabMap.put("util", freeMakerUtil);
            tabMap.put("tabs", newTabs);
            String html = this.freemarkEngine.parseByTemplate(tabsTemplate, tabMap);
            return html;
        }
        if (this.isContainsCollapse(jary)) {
            List<Map<String, Object>> collapse = this.getCollapseHtml(jary);
            HashMap<String, Object> mapObj = new HashMap<String, Object>();
            mapObj.put("formDesc", tableNames);
            mapObj.put("ganged", ganged);
            mapObj.put("expand", expand);
            mapObj.put("expandMap", JsonUtil.toMap((String)expand.toString()));
            mapObj.put("util", freeMakerUtil);
            mapObj.put("mainTemplate", mainTemplate);
            mapObj.put("subTemplate", subTemplate);
            mapObj.put("macroTemplate", macroTemplate);
            List<Map<String, Object>> newCollapse = this.getFields(collapse, mapObj);
            String tabsTemplate = this.formTemplateManager.getByTemplateAlias("collapseColumn").getHtml();
            HashMap<String, Object> tabMap = new HashMap<String, Object>();
            tabMap.put("formDesc", tableNames);
            tabMap.put("util", freeMakerUtil);
            tabMap.put("tabs", newCollapse);
            String html = this.freemarkEngine.parseByTemplate(tabsTemplate, tabMap);
            return html;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formDesc", tableNames);
        map.put("fieldList", jary);
        map.put("ganged", ganged);
        map.put("expand", expand);
        map.put("expandMap", JsonUtil.toMap((String)expand.toString()));
        map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
        map.put("util", freeMakerUtil);
        map.put("isTabs", false);
        map.put("hasStepControl", hasStepControl);
        map.put("stepAttr", stepAttr);
        this.handlerTrGroup(map);
        String html = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
        return html;
    }

    private List<Map<String, Object>> getFields(List<Map<String, Object>> collapse, Map<String, Object> mapObj) throws Exception {
        ArrayList<Map<String, Object>> newCollapse = new ArrayList<Map<String, Object>>();
        String tableNames = (String)mapObj.get("formDesc");
        String ganged = (String)mapObj.get("ganged");
        JsonNode expand = (JsonNode)mapObj.get("expand");
        FreeMakerUtil freeMakerUtil = (FreeMakerUtil)mapObj.get("util");
        String mainTemplate = (String)mapObj.get("mainTemplate");
        String subTemplate = (String)mapObj.get("subTemplate");
        String divContainer = (String)mapObj.get("divContainer");
        String macroTemplate = (String)mapObj.get("macroTemplate");
        for (Map<String, Object> collaps : collapse) {
            Map tabFieldMap;
            String tabHtml;
            HashMap<String, Object> map;
            List newList = (List)collaps.get("fields");
            if ("collapseEnd".equals(((Map)newList.get(newList.size() - 1)).get("ctrlType"))) {
                newList.remove(newList.size() - 1);
                map = new HashMap();
                map.put("formDesc", tableNames);
                map.put("fieldList", newList);
                map.put("ganged", ganged);
                map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map.put("util", freeMakerUtil);
                map.put("isTabs", true);
                this.handlerTrGroup(map);
                tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                collaps.put("tabHtml", tabHtml);
                collaps.put("isCollaps", true);
                if (collaps.containsKey("tabField")) {
                    Map tabFieldMap2 = (Map)collaps.get("tabField");
                    collaps.put("isShow", tabFieldMap2.get("isShow"));
                }
                newCollapse.add(collaps);
                continue;
            }
            if (!collaps.containsKey("tabField")) {
                map = new HashMap<String, Object>();
                map.put("formDesc", tableNames);
                map.put("fieldList", newList);
                map.put("ganged", ganged);
                map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map.put("util", freeMakerUtil);
                map.put("isTabs", true);
                this.handlerTrGroup(map);
                tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                HashMap<String, Object> table = new HashMap<String, Object>();
                table.put("tabHtml", tabHtml);
                table.put("isCollaps", false);
                newCollapse.add(table);
                continue;
            }
            ArrayList collapsFields = new ArrayList();
            ArrayList tableFields = new ArrayList();
            boolean ref = false;
            for (int i = 0; i < newList.size(); ++i) {
                if (ref) {
                    tableFields.add(newList.get(i));
                } else if (!"collapseEnd".equals(((Map)newList.get(i)).get("ctrlType"))) {
                    collapsFields.add(newList.get(i));
                }
                if (!"collapseEnd".equals(((Map)newList.get(i)).get("ctrlType"))) continue;
                ref = true;
            }
            if (collapsFields.size() > 0) {
                HashMap<String, Object> c = new HashMap<String, Object>();
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("formDesc", tableNames);
                map2.put("fieldList", collapsFields);
                map2.put("ganged", ganged);
                map2.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map2.put("util", freeMakerUtil);
                map2.put("isTabs", true);
                this.handlerTrGroup(map2);
                String tabHtml2 = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate, map2);
                if (collaps.containsKey("tabField")) {
                    tabFieldMap = (Map)collaps.get("tabField");
                    c.put("isShow", tabFieldMap.get("isShow"));
                }
                c.put("tabHtml", tabHtml2);
                c.put("isCollaps", true);
                c.put("tabField", collaps.get("tabField"));
                newCollapse.add(c);
            }
            if (tableFields.size() <= 0) continue;
            HashMap<String, Object> map3 = new HashMap<String, Object>();
            map3.put("formDesc", tableNames);
            map3.put("fieldList", tableFields);
            map3.put("ganged", ganged);
            map3.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
            map3.put("util", freeMakerUtil);
            map3.put("isTabs", true);
            this.handlerTrGroup(map3);
            String tabHtml3 = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate, map3);
            HashMap table = new HashMap();
            if (collaps.containsKey("tabField")) {
                tabFieldMap = (Map)collaps.get("tabField");
                table.put("isShow", tabFieldMap.get("isShow"));
            }
            table.put("tabHtml", tabHtml3);
            table.put("isCollaps", false);
            newCollapse.add(table);
        }
        return newCollapse;
    }

    private List<Map<String, Object>> getTabsHtml(List<Map<String, Object>> fieldList) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> tabs = new ArrayList<Map<String, Object>>();
        int index = 0;
        Map<Object, Object> tabField = new HashMap();
        for (Map<String, Object> field : fieldList) {
            if ("tabs".equals(field.get("ctrlType")) || "tabCheck".equals(field.get("ctrlType"))) {
                if (index > 0) {
                    HashMap<String, Cloneable> tab = new HashMap<String, Cloneable>();
                    tab.put("tabField", (Cloneable)((Object)tabField));
                    tab.put("fields", fields);
                    tabs.add(tab);
                    fields = new ArrayList();
                }
                if ("tabCheck".equals(field.get("ctrlType"))) {
                    field.put("nextCheck", field.containsKey("nextCheck") && (Boolean)field.get("nextCheck") == false ? "n" : "y");
                }
                tabField = field;
            } else {
                if (index == 0) {
                    tabField = new HashMap();
                    String uuid = UniqueIdUtil.getSuid();
                    tabField.put("name", "Tabs\u6807\u7b7e\u9875");
                    tabField.put("desc", "\u9ed8\u8ba4\u4fe1\u606f");
                    tabField.put("ctrlType", "tabs");
                    tabField.put("uuid", uuid);
                    tabField.put("widthClass", "col-md-12");
                }
                fields.add(field);
            }
            ++index;
        }
        if (BeanUtils.isNotEmpty(fields)) {
            HashMap<String, Cloneable> tab = new HashMap<String, Cloneable>();
            tab.put("tabField", (Cloneable)((Object)tabField));
            tab.put("fields", fields);
            tabs.add(tab);
        }
        return tabs;
    }

    private List<Map<String, Object>> getCollapseHtml(List<Map<String, Object>> fieldList) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> collapses = new ArrayList<Map<String, Object>>();
        int index = 0;
        Map<Object, Object> tabField = new HashMap();
        for (Map<String, Object> field : fieldList) {
            if ("collapse".equals(field.get("ctrlType"))) {
                if (index > 0) {
                    HashMap<String, Object> tab = new HashMap<String, Object>();
                    if (tabField.size() > 0) {
                        tab.put("tabField", tabField);
                    }
                    tab.put("fields", fields);
                    tab.put("lableColor", field.get("isShow"));
                    collapses.add(tab);
                    fields = new ArrayList();
                }
                tabField = field;
            } else {
                fields.add(field);
            }
            ++index;
        }
        if (BeanUtils.isNotEmpty(fields)) {
            HashMap<String, Cloneable> tab = new HashMap<String, Cloneable>();
            if (tabField.size() > 0) {
                tab.put("tabField", (Cloneable)((Object)tabField));
            }
            tab.put("fields", fields);
            collapses.add(tab);
        }
        return collapses;
    }

    private boolean isContainsTabs(List<Map<String, Object>> fieldList) {
        if (BeanUtils.isNotEmpty(fieldList)) {
            for (Map<String, Object> map : fieldList) {
                if (!map.containsKey("ctrlType") || !"tabs".equals(map.get("ctrlType")) && !"tabCheck".equals(map.get("ctrlType"))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isContainsCollapse(List<Map<String, Object>> fieldList) {
        if (BeanUtils.isNotEmpty(fieldList)) {
            for (Map<String, Object> map : fieldList) {
                if (!map.containsKey("ctrlType") || !"collapse".equals(map.get("ctrlType"))) continue;
                return true;
            }
        }
        return false;
    }

    private void handlerTrGroup(Map<String, Object> map) {
        ArrayList trGroup = new ArrayList();
        List fieldList = (List)map.get("fieldList");
        Integer maxCount = 1;
        if (BeanUtils.isEmpty((Object)fieldList)) {
            map.put("maxCol", maxCount);
            map.put("trGroup", trGroup);
            return;
        }
        Float currentCol = Float.valueOf(0.0f);
        Integer count = 0;
        HashMap<String, Serializable> currentGroup = new HashMap<String, Serializable>();
        currentGroup.put("fields", new ArrayList());
        trGroup.add(currentGroup);
        for (Map field : fieldList) {
            String widthClass = MapUtil.getString((Map)field, (String)"widthClass");
            Float col = this.getColByWidthClass(widthClass);
            String ctrlType = MapUtil.getString((Map)field, (String)"ctrlType");
            if (BeanUtils.isNotEmpty(currentGroup.get("isSub")) && currentGroup.get("isSub").equals(true)) {
                currentCol = Float.valueOf(0.0f);
            }
            if (currentCol.floatValue() == 0.0f || currentCol.floatValue() + col.floatValue() <= 1.0f) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                if (count > maxCount) {
                    maxCount = count;
                }
                currentCol = Float.valueOf(currentCol.floatValue() + col.floatValue());
                if (BeanUtils.isNotEmpty(currentGroup.get("isSub")) && currentGroup.get("isSub").equals(true)) {
                    currentGroup = new HashMap();
                    currentGroup.put("fields", new ArrayList());
                    trGroup.add(currentGroup);
                    ((List)currentGroup.get("fields")).add(field);
                } else {
                    ((List)currentGroup.get("fields")).add(field);
                }
                currentGroup.put("count", count);
            } else {
                currentGroup = new HashMap();
                currentCol = col;
                count = 1;
                ArrayList<Map> fs = new ArrayList<Map>();
                fs.add(field);
                currentGroup.put("fields", fs);
                currentGroup.put("count", count);
                trGroup.add(currentGroup);
            }
            if (!BeanUtils.isNotEmpty(field.get("children")) || "divContainer".equals(ctrlType)) continue;
            if ("sub".equals(ctrlType)) {
                currentGroup.put("isSub", Boolean.valueOf(true));
            }
            List childrenList = (List)field.get("children");
            ArrayList trGroupSup = new ArrayList();
            HashMap<String, Serializable> filedEntity = new HashMap<String, Serializable>();
            filedEntity.put("childrens", new ArrayList());
            trGroupSup.add(filedEntity);
            for (Map children : childrenList) {
                String widthClassSup = MapUtil.getString((Map)children, (String)"widthClass");
                Float colSup = this.getColByWidthClass(widthClassSup);
                if (colSup.floatValue() == 0.0f || currentCol.floatValue() + colSup.floatValue() <= 1.0f) {
                    Integer n = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                    if (count > maxCount) {
                        maxCount = count;
                    }
                    currentCol = Float.valueOf(currentCol.floatValue() + colSup.floatValue());
                    ((List)filedEntity.get("childrens")).add(children);
                    filedEntity.put("count", count);
                    continue;
                }
                filedEntity = new HashMap();
                currentCol = colSup;
                count = 1;
                ArrayList<Map> fs = new ArrayList<Map>();
                fs.add(children);
                filedEntity.put("childrens", fs);
                filedEntity.put("count", count);
                trGroupSup.add(filedEntity);
            }
            List list = (List)currentGroup.get("fields");
            for (Map obj : list) {
                obj.put("trGroupSup", trGroupSup);
            }
        }
        map.put("maxCol", maxCount);
        map.put("trGroup", trGroup);
    }

    private Float getColByWidthClass(String widthClass) {
        Assert.notNull((Object)widthClass, (String)"widthClass\u4e0d\u80fd\u4e3a\u7a7a");
        Float result = Float.valueOf(0.0f);
        switch (widthClass) {
            case "col-md-12": {
                result = Float.valueOf(1.0f);
                break;
            }
            case "col-md-6": {
                result = Float.valueOf(2.0f);
                break;
            }
            case "col-md-4": {
                result = Float.valueOf(3.0f);
                break;
            }
            case "col-md-3": {
                result = Float.valueOf(4.0f);
                break;
            }
            default: {
                throw new SystemException("widthClass\u7684\u503c\u4e0d\u5728\u5141\u8bb8\u7684\u8303\u56f4\u5185");
            }
        }
        return Float.valueOf(1.0f / result.floatValue());
    }

    @Override
    public String getMobileDesignHtml(JsonNode expand, String tableNames, String ganged) throws Exception {
        ArrayList<Map> jary = new ArrayList<Map>();
        ArrayNode fieldList = (ArrayNode)expand.get("fields");
        for (JsonNode jsonNode : fieldList) {
            if (!"main".equals(jsonNode.get("type").asText())) continue;
            ArrayNode arr = (ArrayNode)jsonNode.get("children");
            for (JsonNode fieldNode : arr) {
                jary.add(JsonUtil.toMap((String)fieldNode.toString()));
            }
        }
        FormTemplate mainTemplateObj = this.formTemplateManager.getByTemplateAlias("mobileMainTemplate");
        String mainTemplate = mainTemplateObj.getHtml();
        String subTemplate = this.formTemplateManager.getByTemplateAlias("blockSubTemplate").getHtml();
        String macroTemplate = this.formTemplateManager.getByTemplateAlias(mainTemplateObj.getMacrotemplateAlias()).getHtml();
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formDesc", tableNames);
        map.put("fieldList", jary);
        map.put("ganged", ganged);
        map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
        map.put("util", freeMakerUtil);
        String html = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate, map);
        return html;
    }

    @Override
    public CommonResult<String> savePrintTemplate(Form form) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        Form newForm = this.get((Serializable)((Object)form.getId()));
        String printFormKey = newForm.getFormKey();
        String formKey = form.getFormKey();
        if (BeanUtils.isNotEmpty(this.getByFormKey(formKey))) {
            throw new RuntimeException("\u8868\u5355\u5df2\u7ecf\u5b58\u5728\uff0ckey:" + formKey);
        }
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)newForm.getDefId()));
        String formNewDefId = UniqueIdUtil.getSuid();
        bpmFormDef.setId(formNewDefId);
        bpmFormDef.setKey(formKey);
        bpmFormDef.setName(form.getName());
        bpmFormDef.setTypeId(form.getTypeId());
        bpmFormDef.setType(form.getTypeName());
        bpmFormDef.setCreateBy(user.getUserId());
        if (BeanUtils.isNotEmpty((Object)org) && StringUtil.isNotEmpty((String)org.getGroupId())) {
            bpmFormDef.setCreateOrgId(org.getGroupId());
        }
        bpmFormDef.setRev(1);
        bpmFormDef.setUpdateBy(null);
        bpmFormDef.setUpdateTime(LocalDateTime.now());
        this.formMetaManager.create((Model)bpmFormDef);
        String newFormId = UniqueIdUtil.getSuid();
        newForm.setId(newFormId);
        newForm.setDefId(formNewDefId);
        newForm.setFormKey(formKey);
        newForm.setName(form.getName());
        newForm.setTypeId(form.getTypeId());
        newForm.setTypeName(form.getTypeName());
        newForm.setStatus("draft");
        newForm.setVersion(1);
        newForm.setCreateBy(user.getUserId());
        if (BeanUtils.isNotEmpty((Object)org) && StringUtil.isNotEmpty((String)org.getGroupId())) {
            newForm.setCreateOrgId(org.getGroupId());
        }
        newForm.setIsPrint("Y");
        newForm.setUpdateTime(LocalDateTime.now());
        newForm.setUpdateBy(null);
        this.create((Model)newForm);
        FormPrintTemplate formPrintTemplate = new FormPrintTemplate();
        String printType = "form";
        formPrintTemplate.setDefId(formNewDefId);
        formPrintTemplate.setFormId(newFormId);
        formPrintTemplate.setFormKey(printFormKey);
        formPrintTemplate.setFileName(form.getName());
        formPrintTemplate.setPrintType(printType);
        List<FormPrintTemplate> formPrintTemplates = this.formPrintTemplateManager.getPrintTemplates(printFormKey, printType);
        if (BeanUtils.isEmpty(formPrintTemplates)) {
            formPrintTemplate.setIsMain("Y");
        } else {
            formPrintTemplate.setIsMain("N");
        }
        this.formPrintTemplateManager.create((Model)formPrintTemplate);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public void updatePermissionByKey(String formKey) throws Exception {
        this.updatePermissionm(formKey);
    }

    @Override
    @CachePut(value={"eip:form:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:form:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:form:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public void removeVersions(String[] aryIds) {
        super.removeByIds(aryIds);
    }

    @Override
    public CommonResult<String> generateExpand(GenerateExpandParam params) throws IOException {
        String boDefIds = params.getBoDefId();
        if (StringUtil.isEmpty((String)boDefIds)) {
            return new CommonResult(false, "BO\u5efa\u6a21id\u5fc5\u586b\uff01");
        }
        ArrayList<BoDef> defList = new ArrayList<BoDef>();
        String[] defIds = boDefIds.split(",");
        ArrayNode boDefListNode = JsonUtil.getMapper().createArrayNode();
        for (String defId : defIds) {
            BoDef bodef = this.boDefManager.getByDefId(defId);
            if (!BeanUtils.isNotEmpty((Object)bodef)) continue;
            defList.add(bodef);
            BoEnt mainEnt = bodef.getBoEnt();
            ObjectNode defNode = (ObjectNode)JsonUtil.toJsonNode((Object)bodef);
            ArrayNode entsNode = JsonUtil.getMapper().createArrayNode();
            List subEnts = mainEnt.getChildEntList();
            ObjectNode mainEntNode = this.getEntNode(mainEnt, 0, false, bodef, "");
            entsNode.add((JsonNode)mainEntNode);
            if (BeanUtils.isNotEmpty((Object)subEnts)) {
                for (BoEnt subEnt : subEnts) {
                    ObjectNode subEntNode = this.getEntNode(subEnt, 1, false, bodef, "");
                    List sunEnts = subEnt.getChildEntList();
                    if (BeanUtils.isNotEmpty((Object)sunEnts)) {
                        ArrayNode childrenNode = JsonUtil.getMapper().createArrayNode();
                        for (BoEnt sunEnt : sunEnts) {
                            childrenNode.add((JsonNode)this.getEntNode(sunEnt, 1, false, bodef, ""));
                        }
                        subEntNode.set("children", (JsonNode)childrenNode);
                    }
                    entsNode.add((JsonNode)subEntNode);
                }
            }
            defNode.set("ents", (JsonNode)entsNode);
            boDefListNode.add((JsonNode)defNode);
        }
        if (BeanUtils.isEmpty(defList)) {
            return new CommonResult(false, "\u83b7\u53d6BO\u5efa\u6a21\u5931\u8d25\uff01");
        }
        try {
            ObjectNode expandNode = JsonUtil.getMapper().createObjectNode();
            ObjectNode configNode = JsonUtil.getMapper().createObjectNode();
            configNode.put("labelWidth", 100);
            configNode.put("labelPosition", "right");
            configNode.put("size", "small");
            expandNode.set("list", (JsonNode)GenerateExpandUtil.getLayoutList(params, defList));
            expandNode.set("config", (JsonNode)configNode);
            expandNode.set("boDefList", (JsonNode)boDefListNode);
            return new CommonResult(true, "\u83b7\u53d6\u8868\u5355\u521d\u59cb\u5316\u6a21\u677f\u6210\u529f\uff01", (Object)JsonUtil.toJsonString((Object)expandNode));
        }
        catch (Exception e) {
            return new CommonResult(false, "\u83b7\u53d6\u8868\u5355\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private ObjectNode getEntNode(BoEnt ent, int index, boolean showDetail, BoDef boDef, String path) {
        ObjectNode entNode = JsonUtil.getMapper().createObjectNode();
        entNode.put("desc", ent.getDesc());
        entNode.put("index", index);
        entNode.put("name", ent.getName());
        entNode.put("packageId", "");
        entNode.put("show", ent.getShow());
        entNode.put("status", "");
        entNode.put("isCheck", true);
        entNode.put("comment", ent.getComment());
        entNode.put("description", ent.getDesc());
        entNode.put("fieldPrefix", ent.getIsExternal() == 0 ? BoEnt.FIELD_PREFIX : "");
        entNode.put("isExternal", ent.isExternal());
        ArrayNode attributeList = JsonUtil.getMapper().createArrayNode();
        for (BoAttribute attribute : ent.getBoAttrList()) {
            if ("hide".equals(attribute.getStatus())) continue;
            ObjectNode attrNode = JsonUtil.getMapper().createObjectNode();
            attrNode = JsonUtil.getMapper().createObjectNode();
            attrNode.put("comment", attribute.getComment());
            attrNode.put("name", attribute.getName());
            attrNode.put("isRequired", String.valueOf(attribute.getIsRequired()));
            attrNode.put("dataType", attribute.getDataType());
            attrNode.put("format", attribute.getFormat());
            attrNode.put("intLen", attribute.getIntLen());
            attrNode.put("attrLength", attribute.getAttrLength());
            attrNode.put("decimalLen", attribute.getDecimalLen());
            attrNode.put("isNew", true);
            attrNode.put("defaultValue", attribute.getDefaultValue());
            attrNode.put("desc", attribute.getDesc());
            attrNode.put("index", attribute.getIndex());
            if (showDetail) {
                attrNode.put("boDefId", boDef.getId());
                attrNode.put("boDefAlias", boDef.getAlias());
                attrNode.put("boAttrId", attribute.getId());
                attrNode.put("entId", ent.getId());
                attrNode.put("tableName", ent.getName());
                attrNode.put("fieldPath", path + "." + attribute.getName());
            }
            if ("number".equals(attribute.getDataType())) {
                attrNode.put("controls", true);
            }
            attributeList.add((JsonNode)attrNode);
        }
        entNode.set("attributeList", (JsonNode)attributeList);
        return entNode;
    }

    @Override
    public CommonResult<String> generateBoTreeData(String boDefIds) throws IOException {
        if (StringUtil.isEmpty((String)boDefIds)) {
            return new CommonResult(false, "BO\u5efa\u6a21id\u5fc5\u586b\uff01");
        }
        ArrayList<BoDef> defList = new ArrayList<BoDef>();
        String[] defIds = boDefIds.split(",");
        ArrayNode boDefListNode = JsonUtil.getMapper().createArrayNode();
        for (String defId : defIds) {
            BoDef bodef = this.boDefManager.getByDefId(defId);
            if (!BeanUtils.isNotEmpty((Object)bodef)) continue;
            defList.add(bodef);
            BoEnt mainEnt = bodef.getBoEnt();
            ObjectNode defNode = (ObjectNode)JsonUtil.toJsonNode((Object)bodef);
            ArrayNode mainEntNodes = JsonUtil.getMapper().createArrayNode();
            List subEnts = mainEnt.getChildEntList();
            ObjectNode mainEntNode = this.getEntNode(mainEnt, 0, true, bodef, bodef.getAlias());
            if (BeanUtils.isNotEmpty((Object)subEnts)) {
                ArrayNode subEntNodes = JsonUtil.getMapper().createArrayNode();
                for (BoEnt subEnt : subEnts) {
                    ObjectNode subEntNode = this.getEntNode(subEnt, 1, true, bodef, "item");
                    List sunEnts = subEnt.getChildEntList();
                    if (BeanUtils.isNotEmpty((Object)sunEnts)) {
                        ArrayNode childrenNode = JsonUtil.getMapper().createArrayNode();
                        for (BoEnt sunEnt : sunEnts) {
                            String path = bodef.getAlias() + ".sub_" + subEnt.getName() + ".sub_" + sunEnt.getName();
                            childrenNode.add((JsonNode)this.getEntNode(sunEnt, 1, true, bodef, path));
                        }
                        subEntNode.set("children", (JsonNode)childrenNode);
                    }
                    subEntNodes.add((JsonNode)subEntNode);
                }
                mainEntNode.set("children", (JsonNode)subEntNodes);
            }
            mainEntNodes.add((JsonNode)mainEntNode);
            defNode.set("children", (JsonNode)mainEntNodes);
            boDefListNode.add((JsonNode)defNode);
        }
        if (BeanUtils.isEmpty(defList)) {
            return new CommonResult(false, "\u83b7\u53d6BO\u5efa\u6a21\u5931\u8d25\uff01");
        }
        return new CommonResult(true, "\u751f\u6210\u8868\u5355bo\u6811\u7ed3\u6784\u6570\u636e\u6210\u529f\uff01", (Object)JsonUtil.toJsonString((Object)boDefListNode));
    }

    @Override
    public Map<String, Object> getPreviewDesignVueData(BpmFormVo bpmFormVo) throws Exception {
        Form bpmForm = bpmFormVo.getBpmForm();
        bpmForm.setExpand(bpmFormVo.getBpmFormDef().getExpand());
        this.genFromHtml(bpmFormVo);
        JsonNode jsonNode = JsonUtil.toJsonNode((String)bpmFormVo.getBpmFormDef().getExpand());
        String bos = "";
        if (BeanUtils.isNotEmpty((Object)jsonNode)) {
            bos = JsonUtil.toJson((Object)jsonNode.get("boDefList"));
        }
        ArrayList<String> boCode = new ArrayList<String>();
        ArrayNode bosArray = (ArrayNode)JsonUtil.toBean((String)bos, ArrayNode.class);
        for (int i = 0; i < bosArray.size(); ++i) {
            JsonNode obj = bosArray.get(i);
            BoDef boDef = (BoDef)this.bODefManager.get((Serializable)((Object)obj.get("id").asText()));
            if (!BeanUtils.isNotEmpty((Object)boDef)) continue;
            boCode.add(boDef.getAlias());
        }
        List<BoData> boJson = this.formService.getBoDataByBoKeys(boCode);
        ObjectNode object = BoUtil.hanlerData(boJson);
        JsonNode permissionConf = this.bpmFormRightManager.getDefaultByExpand(bpmFormVo.getBpmFormDef().getExpand());
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String formHtml = I18nUtil.replaceTemp((String)bpmForm.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        bpmForm.setFormHtml(formHtml);
        resultMap.put("bpmForm", (Object)bpmForm);
        resultMap.put("permission", permission);
        resultMap.put("data", object);
        return resultMap;
    }

    @Override
    @CachePut(value={"eip:form:previewContent"}, key="#cacheId", ignoreException=false, firstCache=@FirstCache(expireTime=1800, expireTimeExp="#expireTime", timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=1800, expireTimeExp="#expireTime", preloadTime=360, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public String saveFormOnCache(String cacheId, String content) {
        return content;
    }

    @Override
    @Cacheable(value={"eip:form:previewContent"}, key="#cacheId", ignoreException=false, firstCache=@FirstCache(expireTime=1800, expireTimeExp="#expireTime", timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=1800, expireTimeExp="#expireTime", preloadTime=360, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public String getFormFromCache(String cacheId) {
        return null;
    }

    @Override
    public void exportFormSub(String subDesc, HttpServletResponse response, List<Map<String, String>> list) throws Exception {
        if (list.size() > 0) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            ArrayList maps = new ArrayList();
            LinkedHashMap<String, String> mapObj = new LinkedHashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                map.put(list.get(i).get("name"), list.get(i).get("desc"));
                mapObj.put(list.get(i).get("name"), "");
            }
            maps.add(mapObj);
            HSSFWorkbook book = ExcelUtil.exportExcel((String)subDesc, (int)24, map, maps);
            ExcelUtil.downloadExcel((Workbook)book, (String)subDesc, (HttpServletResponse)response);
        }
    }

    @Override
    public PageList<Form> listJson(QueryFilter queryFilter, Optional<String> formType, Optional<String> status, Optional<String> pcFormKey) throws Exception {
        if (StringUtil.isNotEmpty((String)formType.orElse(null))) {
            queryFilter.addFilter("formType", (Object)formType.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
            queryFilter.addFilter("status", (Object)status.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
            if ("mobile".equals(formType.get()) && StringUtil.isNotEmpty((String)pcFormKey.orElse(""))) {
                List<Map<String, Object>> forms = this.formMetaManager.getBoBindFormsByFormKey(pcFormKey.get());
                HashSet mbFormIds = new HashSet();
                if (BeanUtils.isNotEmpty(forms)) {
                    HashSet<String> pcFormBindBoIds = new HashSet<String>();
                    HashMap<String, HashSet<String>> formBoMap = new HashMap<String, HashSet<String>>();
                    for (Map<String, Object> form : forms) {
                        if (pcFormKey.get().equals(form.get("formKey"))) {
                            pcFormBindBoIds.add((String)form.get("boDefId"));
                        }
                        if (!"mobile".equals(form.get("formType"))) continue;
                        HashSet<String> formBos = (HashSet<String>)formBoMap.get(form.get("formKey"));
                        if (BeanUtils.isEmpty((Object)formBos)) {
                            formBos = new HashSet<String>();
                        }
                        formBos.add((String)form.get("boDefId"));
                        formBoMap.put((String)form.get("formKey"), formBos);
                    }
                    for (Map.Entry next : formBoMap.entrySet()) {
                        if (!pcFormBindBoIds.containsAll((Collection)next.getValue())) continue;
                        mbFormIds.add(next.getKey());
                    }
                }
                queryFilter.addFilter("form_key_", (Object)StringUtil.join(mbFormIds), QueryOP.IN, FieldRelation.AND, "isMain");
            }
        }
        queryFilter.addFilter("is_print_", (Object)"Y", QueryOP.NOT_EQUAL, FieldRelation.AND, "isMain");
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
        IPage<Form> list = this.getFormQueryList((QueryFilter<Form>)queryFilter);
        PageList pageList = new PageList(list);
        if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
            Set<String> allFormKeys = this.dataTemplateManager.getAllFormKeys();
            for (Form bpmForm : pageList.getRows()) {
                if (!allFormKeys.contains(bpmForm.getFormKey())) continue;
                bpmForm.setBusDataTemplateCount((short)1);
            }
        }
        return pageList;
    }

    @Override
    public Form edit(String defId, String formType, String id, String tableNames, String templateAlias) throws Exception {
        if (StringUtil.isEmpty((String)formType)) {
            formType = FormType.PC.value();
        }
        Form form = null;
        if (StringUtil.isNotEmpty((String)id)) {
            form = this.get((Serializable)((Object)id));
        } else {
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
            form = new Form();
            form.setDefId(defId);
            form.setName(formDef.getName());
            form.setFormType(formType);
            form.setTypeName(formDef.getType());
            form.setTypeId(formDef.getTypeId());
            form.setIsMain('Y');
            form.setVersion(1);
            form.setStatus("draft");
            String html = this.getHtml(defId, tableNames, templateAlias);
            html = JsoupUtil.prettyHtml(html);
            form.setFormHtml(html);
        }
        if (StringUtil.isNotEmpty((String)formType) && formType.equals(FormType.MOBILE.value())) {
            StringBuffer outHtml = new StringBuffer();
            outHtml.append("<div style=\"height: 100%;overflow: auto;\">");
            outHtml.append(form.getFormHtml());
            outHtml.append("</div>");
            form.setFormHtml(outHtml.toString());
        }
        return form;
    }

    @Override
    public CommonResult saveCopy(Form form) {
        Form newForm = this.get((Serializable)((Object)form.getId()));
        String formDefId = newForm.getDefId();
        String formKey = form.getFormKey();
        String formName = form.getName();
        String typeId = form.getTypeId();
        String typeName = form.getTypeName();
        String userId = ContextUtil.getCurrentUserId();
        String groupId = ContextUtil.getCurrentGroupId();
        Date data = new Date();
        if (this.getByFormKey(formKey) == null) {
            throw new RuntimeException("\u8868\u5355\u5df2\u7ecf\u5b58\u5728\uff01key:" + formKey);
        }
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)formDefId));
        String formNewDefId = UniqueIdUtil.getSuid();
        bpmFormDef.setId(formNewDefId);
        bpmFormDef.setKey(formKey);
        bpmFormDef.setName(formName);
        bpmFormDef.setTypeId(typeId);
        bpmFormDef.setType(typeName);
        bpmFormDef.setCreateBy(userId);
        bpmFormDef.setCreateOrgId(groupId);
        bpmFormDef.setRev(1);
        bpmFormDef.setUpdateBy(null);
        bpmFormDef.setUpdateTime(LocalDateTime.now());
        this.formMetaManager.create((Model)bpmFormDef);
        newForm.setId(UniqueIdUtil.getSuid());
        newForm.setDefId(formNewDefId);
        newForm.setFormKey(formKey);
        newForm.setName(formName);
        newForm.setTypeId(typeId);
        newForm.setTypeName(typeName);
        newForm.setStatus("draft");
        newForm.setVersion(1);
        newForm.setCreateBy(userId);
        newForm.setCreateOrgId(groupId);
        newForm.setUpdateTime(LocalDateTime.now());
        newForm.setUpdateBy(null);
        this.create((Model)newForm);
        return new CommonResult(true, "\u590d\u5236\u8868\u5355\u6210\u529f", null);
    }

    @Override
    public Form preView(String id, String formKey, String formType, String formHtml) {
        if (StringUtil.isEmpty((String)formType)) {
            formType = FormType.PC.value();
        }
        if (StringUtil.isEmpty((String)id) && StringUtil.isNotEmpty((String)formKey)) {
            Form mainByFormKey = this.getMainByFormKey(formKey);
            id = mainByFormKey.getId();
        }
        Form bpmForm = new Form();
        if (StringUtil.isNotEmpty((String)id)) {
            bpmForm = this.get((Serializable)((Object)id));
            formType = bpmForm.getFormType();
        }
        if (StringUtil.isNotEmpty((String)formHtml)) {
            bpmForm.setFormHtml(formHtml);
        }
        return bpmForm;
    }

    @Override
    public Object importSave(Optional<Boolean> confirmImport, Optional<String> typeId, Optional<String> cacheFileId) throws Exception {
        CommonResult<String> message = new CommonResult<String>("\u5bfc\u5165\u6210\u529f");
        if (confirmImport.orElse(false).booleanValue()) {
            String byKey = ((FormManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFileId.get());
            if (StringUtil.isEmpty((String)byKey)) {
                return new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
            message = this.importForms(objectNode, typeId.orElse(""));
            if (message.getState().booleanValue()) {
                String msg;
                LinkedHashSet entDefsAdded = ThreadMsgUtil.getMapMsg2((String)"entDefsAdded");
                LinkedHashSet entDefsSkipped = ThreadMsgUtil.getMapMsg2((String)"entDefsSkipped");
                LinkedHashSet entsAdded = ThreadMsgUtil.getMapMsg2((String)"entsAdded");
                LinkedHashSet entsSkipped = ThreadMsgUtil.getMapMsg2((String)"entsSkipped");
                LinkedHashSet formDefsUpdated = ThreadMsgUtil.getMapMsg2((String)"formDefsUpdated");
                LinkedHashSet formDefsAdded = ThreadMsgUtil.getMapMsg2((String)"formDefsAdded");
                LinkedHashSet formsUpdatedReleased = ThreadMsgUtil.getMapMsg2((String)"formsUpdatedReleased");
                LinkedHashSet formsUpdated = ThreadMsgUtil.getMapMsg2((String)"formsUpdated");
                LinkedHashSet formsAddedPublished = ThreadMsgUtil.getMapMsg2((String)"formsAddedPublished");
                LinkedHashSet formHasNoRight = ThreadMsgUtil.getMapMsg2((String)"formHasNoRight");
                StringBuilder sb = new StringBuilder();
                if (BeanUtils.isNotEmpty((Object)entsAdded)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\u5b9a\u4e49\uff0c\u5bfc\u5165\u5e76\u6dfb\u52a0\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entsAdded));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)entDefsSkipped)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\u5b9a\u4e49\uff0c\u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entDefsSkipped));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)entsSkipped)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\uff0c\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff0c\u6570\u636e\u5e93\u5b57\u6bb5\u7ea7\u522b\u5dee\u5f02\u8bf7\u624b\u52a8\u9010\u4e2a\u66f4\u65b0\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entsSkipped));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formDefsUpdated)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\u5b9a\u4e49\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formDefsUpdated));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsUpdatedReleased)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u5e76\u53d1\u5e03\u65b0\u7248\u672c\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsUpdatedReleased));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsUpdated)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u7248\u672c\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsUpdated));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsAddedPublished)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5bfc\u5165\u5e76\u53d1\u5e03\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsAddedPublished));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formHasNoRight)) {
                    msg = "<div style='font-weight:bold;color: red;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u65e0\u6743\u9650\u5bfc\u5165\u5df2\u8df3\u8fc7\uff0c\u8bf7\u68c0\u67e5\u8868\u5355\u548c\u5efa\u6a21\u6743\u9650\uff1a</div>" + String.format("%s", String.join((CharSequence)"", formHasNoRight));
                    if (StringUtil.isEmpty((String)sb.toString())) {
                        message.setState(Boolean.valueOf(false));
                        message.setMessage(msg);
                    }
                    sb.append(msg);
                }
                if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                    message.setValue((Object)msg);
                }
            }
        }
        this.delImportFileFromCache(cacheFileId.orElse(""));
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, Optional<String> typeId) {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String cacheFileId;
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            File folder = new File(rootRealPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String formXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "form.xml"));
            String boXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "bo.xml"));
            String formRightsXml = "";
            if (FileUtil.isExistFile((String)(unZipFilePath + File.separator + "formrights.xml"))) {
                formRightsXml = FileUtil.readFile((String)(unZipFilePath + File.separator + "formrights.xml"));
            }
            if (StringUtils.isEmpty((String)formXmlStr)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formXmlStr", formXmlStr);
            obj.put("boXmlStr", boXmlStr);
            if (StringUtil.isNotEmpty((String)formRightsXml)) {
                obj.put("formRightsXml", formRightsXml);
            }
            for (FormComponentIOService formComponentService : this.formComponentIOServiceFactory.getFormComponentServices()) {
                boolean existFile;
                if (formComponentService instanceof DefaultFormComponentIOService || !(existFile = FileUtil.isExistFile((String)(unZipFilePath + File.separator + formComponentService.getKey())))) continue;
                String json = FileUtil.readFile((String)(unZipFilePath + File.separator + formComponentService.getKey()));
                obj.put(formComponentService.getKey(), json);
            }
            FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
            List<FormXml> formXmlList = formImportXml.getFormXmlList();
            ArrayList<String> names = new ArrayList<String>();
            for (FormXml formXml : formXmlList) {
                Form form = formXml.getBpmForm();
                if (BeanUtils.isEmpty((Object)((Object)form))) {
                    throw new BaseException("\u5bfc\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6");
                }
                Form oldForm = this.getMainByFormKey(form.getFormKey());
                if (oldForm == null) continue;
                names.add(oldForm.getName() + "\uff08" + oldForm.getFormKey() + "\uff09");
            }
            List boDefs = this.boDefManager.parseXml(boXmlStr);
            Set entNames = this.boDefManager.checkBoEnt(boDefs);
            if (BeanUtils.isNotEmpty(names)) {
                cacheFileId = UniqueIdUtil.getSuid();
                ((FormManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u8868\u5355\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u4e3a\u5176\u65b0\u589e\u7248\u672c\uff1f", (Object)cacheFileId);
            } else if (BeanUtils.isNotEmpty((Object)entNames)) {
                cacheFileId = UniqueIdUtil.getSuid();
                ((FormManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u5efa\u6a21\u5b9e\u4f53\u3010" + String.join((CharSequence)"\uff0c", entNames) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\u8ffd\u52a0\u5efa\u6a21\u5b9e\u4f53\u5b57\u6bb5\uff1f", (Object)cacheFileId);
            } else {
                CommonResult<String> commonResult = this.importForms(obj, typeId.orElse(""));
                message = commonResult.getState().booleanValue() ? new CommonResult(true, "\u5bfc\u5165\u6210\u529f") : new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + commonResult.getMessage() + ",\u4e0d\u652f\u6301\u5bfc\u5165");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage() + ",\u4e0d\u652f\u6301\u5bfc\u5165");
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    @Override
    public PageList<CopyFormVo> getRelationList(QueryFilter queryFilter, String boDefIds, Optional<String> id, Optional<String> formType, Optional<String> status) throws Exception {
        if (StringUtil.isNotEmpty((String)formType.orElse(null))) {
            queryFilter.addFilter("form_type_", (Object)formType.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
        }
        queryFilter.addFilter("is_print_", (Object)"Y", QueryOP.NOT_EQUAL, FieldRelation.AND, "isMain");
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
        PageList pageList = new PageList();
        if (StringUtil.isNotEmpty((String)boDefIds)) {
            List<String> defIdList = Arrays.asList(boDefIds.split(","));
            List fDefIdList = this.bODefManager.getFormIdByBoDefIds(defIdList);
            if (StringUtil.isNotEmpty((String)id.orElse(""))) {
                queryFilter.addFilter("id_", (Object)id.get(), QueryOP.NOT_EQUAL, FieldRelation.AND, "isMain");
            }
            if (BeanUtils.isNotEmpty((Object)fDefIdList)) {
                queryFilter.addFilter("def_id_", (Object)fDefIdList, QueryOP.IN, FieldRelation.AND, "isMain");
                PageList formList = this.query(queryFilter);
                if (BeanUtils.isNotEmpty((Object)formList.getRows()) && formList.getRows().size() > 0) {
                    for (Form form : formList.getRows()) {
                        CopyFormVo copyForm = (CopyFormVo)((Object)JsonUtil.toBean((String)JsonUtil.toJson((Object)((Object)form)), CopyFormVo.class));
                        List boDefs = this.bODefManager.getByFormId(form.getDefId());
                        ArrayList<String> boDefList = new ArrayList<String>();
                        for (BoDef boDef : boDefs) {
                            boDefList.add(boDef.getId());
                        }
                        copyForm.setBoDefList(boDefList);
                        if (BeanUtils.isEmpty((Object)pageList.getRows())) {
                            pageList.setRows(new ArrayList());
                        }
                        pageList.getRows().add(copyForm);
                    }
                    pageList.setPage(formList.getPage());
                    pageList.setPageSize(formList.getPageSize());
                    pageList.setTotal(formList.getTotal());
                }
            }
        }
        return pageList;
    }

    @Override
    public CommonResult<String> saveFormJs(Map<String, Object> map) throws UnsupportedEncodingException {
        String diyJs = "";
        String formHtml = "";
        String formExpand = "";
        String formCss = "";
        if (BeanUtils.isNotEmpty((Object)map.get("diyJs"))) {
            diyJs = map.get("diyJs").toString();
        }
        if (BeanUtils.isNotEmpty((Object)map.get("formHtml"))) {
            formHtml = Base64.getFromBase64((String)map.get("formHtml").toString());
        }
        if (BeanUtils.isNotEmpty((Object)map.get("formExpand"))) {
            formExpand = Base64.getFromBase64((String)map.get("formExpand").toString());
        }
        if (BeanUtils.isNotEmpty((Object)map.get("formCss"))) {
            formCss = map.get("formCss").toString();
        }
        CommonResult<String> str = this.saveFormJs(map.get("formId").toString(), diyJs, formHtml, formExpand, formCss);
        return str;
    }

    private Boolean compatibleWithOldData(JsonNode expand, String fromType) {
        boolean isChanged = false;
        ArrayNode arrayNodeFirst = (ArrayNode)expand.findValue("list");
        for (JsonNode nodeFirst : arrayNodeFirst) {
            String ctrlType = JsonUtil.getString((JsonNode)nodeFirst, (String)"ctrlType", (String)"");
            if (nodeFirst.has("options")) {
                String advancedProperty;
                String width;
                ObjectNode nodeOptions = (ObjectNode)nodeFirst.get("options");
                if ("mobile".equals(fromType)) {
                    nodeOptions = GenerateExpandUtil.appendScanConfig(nodeOptions, ctrlType);
                    isChanged = true;
                }
                if (nodeOptions.has("isReadonly") && nodeOptions.get("isReadonly").asBoolean()) {
                    nodeOptions.remove("isReadonly");
                    nodeOptions.put("isInputEdit", true);
                    isChanged = true;
                }
                if (!"pc".equals(fromType) && nodeOptions.has("width") && StringUtil.isNotEmpty((String)(width = nodeOptions.get("width").asText())) && !"100%".equals(width)) {
                    nodeOptions.remove("width");
                    isChanged = true;
                }
                if (nodeFirst.has("ctrlType") && "number".equals(nodeFirst.get("ctrlType").asText()) && nodeOptions.has("advancedProperty") && StringUtil.isNotEmpty((String)(advancedProperty = nodeOptions.get("advancedProperty").asText())) && !advancedProperty.contains("|disabled")) {
                    advancedProperty = advancedProperty + "|disabled";
                    nodeOptions.put("advancedProperty", advancedProperty);
                    isChanged = true;
                }
            }
            if (nodeFirst.has("list") && this.compatibleWithOldData(nodeFirst, fromType).booleanValue()) {
                isChanged = true;
            }
            if (nodeFirst.has("columns")) {
                ArrayNode arrayNodeColumn = (ArrayNode)nodeFirst.findValue("columns");
                for (JsonNode nodeColumn : arrayNodeColumn) {
                    if (!this.compatibleWithOldData(nodeColumn, fromType).booleanValue()) continue;
                    isChanged = true;
                }
            }
            if (!nodeFirst.has("rows")) continue;
            ArrayNode arrayNodeRow = (ArrayNode)nodeFirst.findValue("rows");
            for (JsonNode nodeRow : arrayNodeRow) {
                if (!nodeFirst.has("columns")) continue;
                ArrayNode arrayColumnByRow = (ArrayNode)nodeRow.findValue("columns");
                for (JsonNode nodeColumn : arrayColumnByRow) {
                    if (!this.compatibleWithOldData(nodeColumn, fromType).booleanValue()) continue;
                    isChanged = true;
                }
            }
        }
        return isChanged;
    }

    @Override
    public List<Map<String, String>> batchSave(List<String> ids) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List<Form> allList = this.getMainFormByIds(ids);
        ArrayList<FormMeta> listUpdate = new ArrayList<FormMeta>();
        for (Form form : allList) {
            try {
                FormMeta formMeta = this.formMetaManager.getByKey(form.getFormKey());
                FormMeta formMetaUpdate = new FormMeta();
                BeanUtils.copyNotNullProperties((Object)((Object)formMetaUpdate), (Object)((Object)formMeta));
                formMetaUpdate.setId(formMeta.getId());
                formMetaUpdate.setRev(formMeta.getRev());
                formMetaUpdate.setRevUpdate(1 + formMeta.getRev());
                formMetaUpdate.setUpdateBy(AuthenticationUtil.getCurrentUserId());
                formMetaUpdate.setUpdateTime(LocalDateTime.now());
                if (StringUtil.isNotEmpty((String)formMeta.getExpand())) {
                    JsonNode expand = JsonUtil.toJsonNode((String)formMeta.getExpand());
                    if (this.compatibleWithOldData(expand, form.getFormType()).booleanValue()) {
                        formMeta.setExpand(expand.toString());
                        formMetaUpdate.setExpand(expand.toString());
                    }
                    if (expand.toString().contains("\"inputType|bindPreAndSufFix\"")) {
                        String expandNumber = expand.toString().replace("\"inputType|bindPreAndSufFix\"", "\"inputType|bindPreAndSufFix|disabled\"");
                        formMeta.setExpand(expandNumber);
                        formMetaUpdate.setExpand(expandNumber);
                    }
                }
                listUpdate.add(formMetaUpdate);
                BpmFormVo bpmFormVo = new BpmFormVo();
                bpmFormVo.setBpmFormDef(formMeta);
                bpmFormVo.setBpmForm(form);
                String formHtml = this.genFromHtml(bpmFormVo);
                this.updateFormHtml(form.getId(), formHtml);
                this.bpmFormRightManager.removeDefaultRightCache(form.getFormKey(), true);
                this.bpmFormRightManager.removeDefaultRightCache(form.getFormKey(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", form.getName());
                map.put("formKey", form.getFormKey());
                map.put("error", e instanceof NullPointerException ? "\u7a7a\u6307\u9488\u5f02\u5e38\uff01" : e.getMessage());
                result.add(map);
            }
        }
        if (CollUtil.isNotEmpty(listUpdate)) {
            this.formMetaManager.updateBatchById(listUpdate);
        }
        return result;
    }

    @Override
    public void updateFormHtml(String id, String formHtml) {
        UpdateWrapper uw = new UpdateWrapper();
        uw.set((Object)"form_html_", (Object)formHtml);
        uw.set((Object)"update_by_", (Object)AuthenticationUtil.getCurrentUserId());
        uw.set((Object)"update_time_", (Object)LocalDateTime.now());
        uw.eq((Object)"id_", (Object)id);
        this.update((Wrapper)uw);
    }

    @Override
    public List<Form> getMainFormByIds(List<String> ids) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.in(Form::getId, ids);
        query.eq(Form::getIsMain, (Object)"Y");
        query.ne(Form::getIsPrint, (Object)"Y");
        return this.list((Wrapper)query);
    }

    public ObjectNode getFormDesignByKey(String formKey) throws Exception {
        Form form = null;
        FormMeta formDef = null;
        ObjectNode resultJson = JsonUtil.getMapper().createObjectNode();
        if (StringUtil.isNotEmpty((String)formKey)) {
            ObjectNode designJson = JsonUtil.getMapper().createObjectNode();
            form = this.getMainByFormKey(formKey);
            if (BeanUtils.isEmpty((Object)((Object)form))) {
                return null;
            }
            if (BeanUtils.isNotEmpty((Object)((Object)form)) && BeanUtils.isNotEmpty((Object)((Object)(formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId())))))) {
                resultJson.put("ganged", formDef.getGanged());
                resultJson.put("opinion", formDef.getOpinionConf());
                resultJson.put("defId", formDef.getId());
                resultJson.put("desc", formDef.getDesc());
                resultJson.put("name", formDef.getName());
                resultJson.put("rev", formDef.getRev());
                JsonNode jsonNode = JsonUtil.toJsonNode((String)formDef.getExpand());
                if (BeanUtils.isNotEmpty((Object)jsonNode)) {
                    resultJson.put("bos", JsonUtil.toJson((Object)jsonNode.get("boDefList")));
                    resultJson.put("fields", JsonUtil.toJson((Object)jsonNode.get("fields")));
                    resultJson.put("flowField", jsonNode.has("flowField") ? jsonNode.get("flowField").asText() : "");
                    resultJson.put("includeFiles", jsonNode.has("includeFiles") ? jsonNode.get("includeFiles").asText() : "");
                    resultJson.put("designFormName", jsonNode.has("designFormName") ? jsonNode.get("designFormName").asText() : "");
                    if (jsonNode.has("treeCtrl")) {
                        resultJson.set("treeCtrl", jsonNode.get("treeCtrl"));
                    }
                }
                designJson.put("type", formDef.getType());
            }
            ObjectNode formJson = JsonUtil.getMapper().createObjectNode();
            designJson.set("form", (JsonNode)formJson);
            resultJson.put("formName", form.getName());
            resultJson.put("formKey", form.getFormKey());
            resultJson.put("formType", form.getFormType());
            resultJson.put("version", form.getVersion());
            resultJson.put("status", form.getStatus());
            resultJson.put("typeId", form.getTypeId());
            resultJson.put("typeName", form.getTypeName());
            resultJson.put("desc", form.getDesc());
            resultJson.put("macroAlias", formDef.getMacroAlias());
            resultJson.put("mainAlias", formDef.getMainAlias());
            resultJson.put("subEntity", formDef.getSubEntity());
            resultJson.put("isPrint", form.getIsPrint());
            resultJson.set("design", (JsonNode)designJson);
            resultJson.put("formSetting", form.getFormSetting());
            resultJson.put("diyJs", form.getDiyJs());
            resultJson.put("formId", form.getId());
        }
        return resultJson;
    }

    @Override
    public List<ImportCheckResult> importFormCheck(Map<String, Object> obj) throws Exception {
        Set entNames;
        ArrayList<ImportCheckResult> results;
        block4: {
            String formXmlStr = obj.getOrDefault("form.xml", "").toString();
            String boXmlStr = obj.getOrDefault("bo.xml", "").toString();
            if (StringUtils.isEmpty((String)formXmlStr)) {
                throw new BaseException("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
            List<FormXml> formXmlList = formImportXml.getFormXmlList();
            results = new ArrayList<ImportCheckResult>();
            for (FormXml formXml : formXmlList) {
                Form form = formXml.getBpmForm();
                Form oldForm = this.getMainByFormKey(form.getFormKey());
                if (!BeanUtils.isNotEmpty((Object)((Object)oldForm))) continue;
                results.add(new ImportCheckResult(true, "\u8868\u5355", form.getName()));
            }
            List boDefs = this.boDefManager.parseXml(boXmlStr);
            entNames = new HashSet();
            try {
                entNames = this.bODefManager.checkBoEnt(boDefs);
            }
            catch (BaseException e) {
                if (!BeanUtils.isNotEmpty(formXmlList)) break block4;
                ArrayList<ImportCheckResult> newResult = new ArrayList<ImportCheckResult>();
                String formName = formXmlList.get(0).getBpmForm().getName();
                newResult.add(new ImportCheckResult(true, "\u8868\u5355", String.format("<span style='color: red'>%s\uff08\u51b2\u7a81\u4e0d\u652f\u6301\u5bfc\u5165\uff09</span>", formName)));
                return newResult;
            }
        }
        entNames.forEach(entName -> results.add(new ImportCheckResult(true, "bo\u5b9e\u4f53", entName)));
        return results;
    }

    private int importFormCheck(String formXmlStr, String boXmlStr) throws JAXBException, UnsupportedEncodingException {
        Set entNames;
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("formXmlStr", formXmlStr);
        obj.put("boXmlStr", boXmlStr);
        FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
        List<FormXml> formXmlList = formImportXml.getFormXmlList();
        ArrayList<String> names = new ArrayList<String>();
        for (FormXml formXml : formXmlList) {
            Form form = formXml.getBpmForm();
            Form oldForm = this.getMainByFormKey(form.getFormKey());
            if (oldForm == null) continue;
            names.add(oldForm.getName() + "\uff08" + oldForm.getFormKey() + "\uff09");
        }
        List boDefs = this.boDefManager.parseXml(boXmlStr);
        try {
            entNames = this.boDefManager.checkBoEnt(boDefs);
        }
        catch (BaseException e) {
            return 1;
        }
        if (BeanUtils.isEmpty(names) && BeanUtils.isEmpty((Object)entNames)) {
            return 2;
        }
        return 3;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> importData(Map<String, Object> obj, String status, String typeId) throws Exception {
        Object result;
        String formXmlStr = obj.getOrDefault("form.xml", "").toString();
        String boXmlStr = obj.getOrDefault("bo.xml", "").toString();
        ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode(obj);
        objectNode.put("formXmlStr", formXmlStr);
        objectNode.put("boXmlStr", boXmlStr);
        ThreadMsgUtil.addMapMsg((String)"notNeedTransaction", (String)"true");
        int canImport = this.importFormCheck(formXmlStr, boXmlStr);
        if (1 == canImport) {
            return new HashMap<String, String>();
        }
        if ((2 == canImport || "cover".equals(status)) && !(result = this.importForms(objectNode, status, typeId)).getState().booleanValue()) {
            throw new BaseException(result.getMessage());
        }
        result = new HashMap();
        FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
        List<FormXml> list = formImportXml.getFormXmlList();
        if (BeanUtils.isNotEmpty(list)) {
            List alias = list.stream().map(item -> item.getBpmForm().getFormKey()).collect(Collectors.toList());
            result = this.list((Wrapper)Wrappers.lambdaQuery().in(Form::getFormKey, alias)).stream().collect(Collectors.toMap(Form::getFormKey, Form::getId, (k1, k2) -> k1));
        }
        return result;
    }

    private static interface ImportStatus {
        public static final int NOT = 1;
        public static final int ALL = 2;
        public static final int SOME = 3;
    }
}

