/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.ognl.Ognl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipFileUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.file.model.FileInfo;
import com.hotent.file.service.FileService;
import com.hotent.file.util.AppFileUtil;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormPrintTemplate;
import com.hotent.form.model.FormWordPrintTemplateXml;
import com.hotent.form.model.FormWordPrintTemplateXmlList;
import com.hotent.form.param.FormPrintParam;
import com.hotent.form.param.FormPrintTemplateFileVo;
import com.hotent.form.persistence.dao.FormPrintTemplateDao;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormPrintTemplateManager;
import com.hotent.form.util.CustomUtil;
import com.hotent.table.datasource.DataSourceUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="formPrintTemplateManager")
public class FormPrintTemplateManagerImpl
extends BaseManagerImpl<FormPrintTemplateDao, FormPrintTemplate>
implements FormPrintTemplateManager {
    private Logger logger = LoggerFactory.getLogger(FormPrintTemplateManagerImpl.class);
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    BoDefManager boDefManager;
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    FileService fileService;
    @Resource
    FormDataTemplateManager dataTemplateManager;

    @Override
    public void saveFormPrintTemplate(FormPrintTemplate formPrintTemplate) {
        List list = ((FormPrintTemplateDao)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getFormKey, (Object)formPrintTemplate.getFormKey())).eq(FormPrintTemplate::getPrintType, (Object)formPrintTemplate.getPrintType()));
        if (list.size() > 0) {
            formPrintTemplate.setIsMain("N");
        } else {
            formPrintTemplate.setIsMain("Y");
        }
        super.create((Model)formPrintTemplate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setDefaultVersion(String formKey, String id, String printType) {
        UpdateWrapper updateWrapper = (UpdateWrapper)((UpdateWrapper)((UpdateWrapper)Wrappers.update().set((Object)"is_main", (Object)"N")).eq((Object)"form_key_", (Object)formKey)).eq((Object)"print_type_", (Object)printType);
        ((FormPrintTemplateDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        updateWrapper = (UpdateWrapper)((UpdateWrapper)((UpdateWrapper)Wrappers.update().set((Object)"is_main", (Object)"Y")).eq((Object)"form_key_", (Object)formKey)).eq((Object)"id_", (Object)id);
        ((FormPrintTemplateDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    public FormPrintTemplate getMainFormPrintTemplate(String formKey) {
        return (FormPrintTemplate)((Object)((FormPrintTemplateDao)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getFormKey, (Object)formKey)).eq(FormPrintTemplate::getIsMain, (Object)"Y")).eq(FormPrintTemplate::getPrintType, (Object)"word")));
    }

    @Override
    public List<FormPrintTemplate> getPrintTemplates(String formKey, String printType) {
        return ((FormPrintTemplateDao)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getFormKey, (Object)formKey)).eq(FormPrintTemplate::getPrintType, (Object)printType));
    }

    @CacheEvict(value={"eip:form:bpmForm"}, key="#formKey")
    protected void removeFromCache(String formKey) {
    }

    @Override
    public void removeByIds(String ... ids) {
        FormPrintTemplateManagerImpl bean = (FormPrintTemplateManagerImpl)AppUtil.getBean(this.getClass());
        for (String id : ids) {
            Form bpmForm;
            String formId;
            FormPrintTemplate formPrintTemplate = (FormPrintTemplate)this.get((Serializable)((Object)id));
            if ("form".equals(formPrintTemplate.getPrintType()) && StringUtil.isNotEmpty((String)(formId = formPrintTemplate.getFormId())) && BeanUtils.isNotEmpty((Object)((Object)(bpmForm = (Form)this.bpmFormManager.get((Serializable)((Object)formId)))))) {
                String formKey = bpmForm.getFormKey();
                this.bpmFormManager.remove((Serializable)((Object)bpmForm.getId()));
                String fromDefId = bpmForm.getDefId();
                this.formMetaManager.remove((Serializable)((Object)fromDefId));
                this.formMetaManager.deleteBpmFormBo(fromDefId);
                bean.removeFromCache(formKey);
            }
            this.remove((Serializable)((Object)id));
        }
    }

    @Override
    public FormPrintTemplate getMailPrintTemplates(String formKey, String printType) {
        return (FormPrintTemplate)((Object)((FormPrintTemplateDao)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getIsMain, (Object)"Y")).eq(FormPrintTemplate::getFormKey, (Object)formKey)).eq(FormPrintTemplate::getPrintType, (Object)printType)));
    }

    @Override
    public FormPrintTemplate getByAlias(String alias) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getAlias, (Object)alias);
        return (FormPrintTemplate)((Object)((FormPrintTemplateDao)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    @Override
    public List<FormPrintTemplate> getWordTemplatesByFormKey(String formKeys) throws IOException {
        String[] formKeyArray;
        List boDefIds;
        List<FormPrintTemplate> list = new ArrayList<FormPrintTemplate>();
        if (StringUtil.isNotEmpty((String)formKeys) && BeanUtils.isNotEmpty((Object)(boDefIds = this.boDefManager.getBoDefIdsByFormKey(Arrays.asList(formKeyArray = formKeys.split(",")))))) {
            list = ((FormPrintTemplateDao)this.baseMapper).getByBoDefIds(boDefIds);
        }
        CustomUtil.filterHasNoUseRight(list);
        return list;
    }

    @Override
    public List<FormPrintTemplate> getByBoDefIds(List<String> boDefIds) {
        return ((FormPrintTemplateDao)this.baseMapper).getByBoDefIds(boDefIds);
    }

    @Override
    public Map<String, Object> exportDef(List<String> list) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormWordPrintTemplateXmlList formWordPrintTemplateXmlList = new FormWordPrintTemplateXmlList();
        this.setFormWordPrintTemplateXml(list, formWordPrintTemplateXmlList, map);
        try {
            String xml = JAXBUtil.marshall((Object)formWordPrintTemplateXmlList, FormWordPrintTemplateXmlList.class);
            map.put("formPrintTemplates.form.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    private void setFormWordPrintTemplateXml(List<String> list, FormWordPrintTemplateXmlList formWordPrintTemplateXmlList, Map<String, Object> map) {
        String folderPath = (FileUtil.getIoTmpdir() + "/attachFiles/tempFile/ht_formPrintTemplate_tempFile/").replace("/", File.separator);
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        for (String id : list) {
            FormPrintTemplate formPrintTemplate = (FormPrintTemplate)((Object)((FormPrintTemplateDao)this.baseMapper).selectById((Serializable)((Object)id)));
            String fileJson = formPrintTemplate.getFileJson();
            if (StringUtil.isNotEmpty((String)fileJson)) {
                try {
                    ArrayNode fileInfos = (ArrayNode)JsonUtil.toJsonNode((String)fileJson);
                    ArrayList<FileInfo> files = new ArrayList<FileInfo>();
                    for (JsonNode fileInfo : fileInfos) {
                        ObjectNode objectNode = this.portalFeignService.fileGet(JsonUtil.getString((JsonNode)fileInfo, (String)"id"));
                        FileInfo file = (FileInfo)JsonUtil.toBean((JsonNode)objectNode, FileInfo.class);
                        byte[] bytes = this.portalFeignService.getFileBytesById(JsonUtil.getString((JsonNode)fileInfo, (String)"id"));
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                        map.put(file.getId() + "." + file.getExtensionName(), inputStream);
                        files.add(file);
                    }
                    formPrintTemplate.setFileInfo(files);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            FormWordPrintTemplateXml formWordPrintTemplateXml = new FormWordPrintTemplateXml();
            formWordPrintTemplateXml.setFormPrintTemplate(formPrintTemplate);
            formWordPrintTemplateXmlList.addFormWordPrintTemplateXml(formWordPrintTemplateXml);
        }
    }

    @Override
    @CachePut(value={"eip:form:printtemplateImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:form:printtemplateImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:form:printtemplateImportFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public CommonResult getLabelData(JsonNode jsonNode) {
        String dsName = jsonNode.get("dsName").asText();
        JsonNode mainSqlList = jsonNode.get("mainSqlList");
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)dsName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
        for (int i = 0; i < mainSqlList.size(); ++i) {
            ObjectNode node = (ObjectNode)mainSqlList.get(i);
            String mainSql = node.get("mainSql").asText();
            ArrayNode mainArray = this.getSQl(mainSql, jdbcTemplate);
            JsonNode subSQList = node.get("subSQList");
            if (subSQList.size() > 0) {
                for (int j = 0; j < subSQList.size(); ++j) {
                    ObjectNode item = (ObjectNode)subSQList.get(j);
                    String sql = item.get("sql").asText();
                    ArrayNode map = this.getSQl(sql, jdbcTemplate);
                    item.set("labelConfigs", (JsonNode)map);
                }
            }
            node.set("labelConfigs", (JsonNode)mainArray);
        }
        return new CommonResult(true, "\u4e0a\u4f20\u6a21\u677f\u6210\u529f", (Object)jsonNode);
    }

    private String getBoDataSQL(FormPrintTemplate formPrintTemplate, String instId) throws Exception {
        if (StringUtil.isEmpty((String)formPrintTemplate.getMainSqlList())) {
            throw new BaseException("SQL\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ObjectNode boDataNode = JsonUtil.createObjectNode();
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        CommonManager commonManager = (CommonManager)AppUtil.getBean(CommonManager.class);
        String dsName = formPrintTemplate.getDataSource();
        JsonNode nodeMainSql = JsonUtil.toJsonNode((String)formPrintTemplate.getMainSqlList());
        if (!(nodeMainSql instanceof ArrayNode)) {
            throw new BaseException("SQL\u914d\u7f6e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        ArrayNode arrayMainSql = (ArrayNode)nodeMainSql;
        for (int i = 0; i < arrayMainSql.size(); ++i) {
            ObjectNode nodeSQL = (ObjectNode)arrayMainSql.get(i);
            String mainSql = JsonUtil.getString((JsonNode)nodeSQL, (String)"mainSql");
            String mainInstIdField = JsonUtil.getString((JsonNode)nodeSQL, (String)"mainInstId");
            if (StringUtil.isEmpty((String)mainSql)) {
                throw new BaseException("\u4e3b\u8868SQL\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isNotEmpty((String)mainInstIdField) && StringUtil.isNotEmpty((String)instId)) {
                mainSql = mainSql.contains(" where ") ? mainSql + " AND " + mainInstIdField + " = '" + instId + "'" : mainSql + " WHERE " + mainInstIdField + " = '" + instId + "'";
            }
            String finalMainSql = mainSql;
            List listMain = (List)databaseContext.switchDS(dsName, () -> commonManager.query(finalMainSql), e -> {
                throw new BaseException(e.getMessage(), (Throwable)e);
            });
            HashMap mainData = new HashMap();
            if (CollUtil.isEmpty((Collection)listMain) || listMain.size() > 1) {
                ArrayNode mainArray = null;
                try {
                    JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)dsName);
                    mainArray = this.getSQl(mainSql, jdbcTemplate);
                }
                catch (Exception e2) {
                    throw new BaseException("\u89e3\u6790\u4e3b\u8868\u5b57\u6bb5\u5f02\u5e38\uff01", (Throwable)e2);
                }
                if (mainArray == null || mainArray.size() <= 0) {
                    throw new BaseException("\u89e3\u6790\u4e3b\u8868\u5b57\u6bb5\u9519\u8bef\uff0c\u5b57\u6bb5\u4e3a\u7a7a\uff01");
                }
                mainArray.forEach(field -> {
                    String key = JsonUtil.getString((JsonNode)field, (String)"name");
                    if (StringUtil.isNotEmpty((String)key)) {
                        mainData.put(key, "");
                    }
                });
            } else {
                Map mainDataSrc = (Map)listMain.get(0);
                for (Map.Entry entry : mainDataSrc.entrySet()) {
                    mainData.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
                }
            }
            JsonNode subSqlList = nodeSQL.get("subSQList");
            if (subSqlList != null && subSqlList.size() > 0) {
                for (int j = 0; j < subSqlList.size(); ++j) {
                    ObjectNode item = (ObjectNode)subSqlList.get(j);
                    String subSql = JsonUtil.getString((JsonNode)item, (String)"sql");
                    String subAlias = JsonUtil.getString((JsonNode)item, (String)"alias");
                    ArrayList listSubUpper = new ArrayList();
                    mainData.put(subAlias, listSubUpper);
                    if (StringUtil.isEmpty((String)subSql) || StringUtil.isEmpty((String)subAlias)) {
                        this.logger.error("\u5b50\u8868SQL\u548c\u5b50\u8868\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    String subFieldFk = JsonUtil.getString((JsonNode)item, (String)"subFk_", (String)"REF_ID_");
                    String subFieldFkValue = JsonUtil.getString((JsonNode)item, (String)"subFk_Value", (String)"ID_");
                    String fkValue = MapUtil.getStringIgnoreKey(mainData, (String)subFieldFkValue, (String)"");
                    String finalSubSql = subSql = subSql.contains(" where ") ? subSql + " AND " + subFieldFk + " = '" + fkValue + "'" : subSql + " WHERE " + subFieldFk + " = '" + fkValue + "'";
                    List listSub = (List)databaseContext.switchDS(dsName, () -> commonManager.query(finalSubSql), e -> {
                        throw new BaseException(e.getMessage(), (Throwable)e);
                    });
                    if (!CollUtil.isNotEmpty((Collection)listSub)) continue;
                    listSub.forEach(one -> {
                        HashMap subData = new HashMap();
                        for (Map.Entry entry : one.entrySet()) {
                            subData.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
                        }
                        listSubUpper.add(subData);
                    });
                }
            }
            boDataNode.set(formPrintTemplate.getAlias(), JsonUtil.toJsonNode(mainData));
        }
        return JsonUtil.toJsonString((Object)boDataNode);
    }

    @Override
    public CommonResult<String> wordPrint(FormPrintParam formPrintParam) throws Exception {
        ArrayNode fileArr;
        FormPrintTemplate formPrintTemplate = (FormPrintTemplate)this.get((Serializable)((Object)formPrintParam.getId()));
        if (BeanUtils.isEmpty((Object)((Object)formPrintTemplate))) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6253\u5370\u6a21\u677f");
        }
        String fileId = formPrintParam.getFileId();
        if (StringUtil.isEmpty((String)fileId)) {
            fileId = formPrintTemplate.getFileId();
        }
        if (StringUtil.isEmpty((String)fileId) && !(fileArr = (ArrayNode)JsonUtil.toJsonNode((String)formPrintTemplate.getFileJson())).isEmpty()) {
            fileId = JsonUtil.getString((JsonNode)fileArr.get(0), (String)"id");
        }
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        if ("sql".equals(formPrintTemplate.getDataSourceForm())) {
            ObjectNode node = this.bpmRuntimeFeignService.printBoAndFormKey(formPrintParam.getDefId(), formPrintParam.getNodeId(), formPrintParam.getProcInstId());
            objectNode.put("dataSource", formPrintTemplate.getDataSource());
            objectNode.put("mainSqlList", formPrintTemplate.getMainSqlList());
            objectNode.put("formKey", node.get("formKey").asText());
            objectNode.put("instId", formPrintParam.getProcInstId());
            objectNode.put("subject", node.get("subject").asText());
            objectNode.put("isSQl", true);
            try {
                String boData = this.getBoDataSQL(formPrintTemplate, formPrintParam.getProcInstId());
                objectNode.put("boData", boData);
            }
            catch (Exception e) {
                this.logger.error("\u6267\u884c\u5957\u6253SQL\u5f02\u5e38\uff01", (Throwable)e);
                throw new BaseException("\u6267\u884c\u5957\u6253SQL\u5f02\u5e38\uff01", (Throwable)e);
            }
        } else {
            objectNode = this.bpmRuntimeFeignService.printBoAndFormKey(formPrintParam.getDefId(), formPrintParam.getNodeId(), formPrintParam.getProcInstId());
            objectNode.put("boData", formPrintParam.getBoData());
        }
        objectNode.put("isOld", StringUtil.isEmpty((String)formPrintTemplate.getDataSourceForm()));
        objectNode.put("defId", formPrintParam.getDefId());
        objectNode.put("nodeId", formPrintParam.getNodeId());
        objectNode.put("procInstId", formPrintParam.getProcInstId());
        objectNode.put("preview", formPrintParam.isPreview());
        objectNode.put("fileId", fileId);
        objectNode.put("scriptStr", StringUtil.isNotEmpty((String)formPrintTemplate.getScriptStr()) ? formPrintTemplate.getScriptStr() : "");
        objectNode.put("templateName", formPrintTemplate.getName());
        objectNode.put("subject", formPrintTemplate.getName());
        String printId = this.portalFeignService.wordPrint(objectNode);
        return new CommonResult(true, "", (Object)printId);
    }

    @Override
    public CommonResult<String> formWordPrint(FormPrintParam formPrintParam) throws Exception {
        ArrayNode fileArr;
        FormPrintTemplate formPrintTemplate = (FormPrintTemplate)this.get((Serializable)((Object)formPrintParam.getId()));
        if (BeanUtils.isEmpty((Object)((Object)formPrintTemplate))) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6253\u5370\u6a21\u677f");
        }
        String fileId = formPrintParam.getFileId();
        if (StringUtil.isEmpty((String)fileId)) {
            fileId = formPrintTemplate.getFileId();
        }
        if (StringUtil.isEmpty((String)fileId) && StringUtil.isNotEmpty((String)formPrintTemplate.getFileJson()) && !(fileArr = (ArrayNode)JsonUtil.toJsonNode((String)formPrintTemplate.getFileJson())).isEmpty() && fileArr.get(0) != null && fileArr.get(0).get("response") != null) {
            fileId = JsonUtil.getString((JsonNode)fileArr.get(0).get("response"), (String)"fileId", (String)"");
        }
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        String procInstId = formPrintParam.getProcInstId();
        String defId = formPrintParam.getDefId();
        String nodeId = formPrintParam.getNodeId();
        if ("sql".equals(formPrintTemplate.getDataSourceForm())) {
            objectNode.put("dataSource", formPrintTemplate.getDataSource());
            objectNode.put("mainSqlList", formPrintTemplate.getMainSqlList());
            objectNode.put("instId", procInstId);
            objectNode.put("isSQl", true);
            if (StringUtil.isNotEmpty((String)procInstId) && StringUtil.isNotEmpty((String)defId)) {
                ObjectNode node = this.bpmRuntimeFeignService.printBoAndFormKey(defId, nodeId, procInstId);
                objectNode.put("subject", node.get("subject").asText());
                objectNode.put("formKey", node.get("formKey").asText());
            }
            try {
                String boData = this.getBoDataSQL(formPrintTemplate, procInstId);
                objectNode.put("boData", boData);
            }
            catch (Exception e) {
                this.logger.error("\u6267\u884c\u5957\u6253SQL\u5f02\u5e38\uff01", (Throwable)e);
            }
        } else if (StringUtil.isNotEmpty((String)procInstId)) {
            objectNode = this.bpmRuntimeFeignService.printBoAndFormKey(defId, nodeId, procInstId);
            objectNode.put("boData", formPrintParam.getBoData());
        } else {
            objectNode.put("boData", formPrintParam.getBoData());
        }
        objectNode.put("isOld", StringUtil.isEmpty((String)formPrintTemplate.getDataSourceForm()));
        objectNode.put("defId", defId);
        objectNode.put("nodeId", nodeId);
        objectNode.put("procInstId", procInstId);
        objectNode.put("preview", formPrintParam.isPreview());
        objectNode.put("fileId", fileId);
        objectNode.put("scriptStr", StringUtil.isNotEmpty((String)formPrintTemplate.getScriptStr()) ? formPrintTemplate.getScriptStr() : "");
        objectNode.put("subject", formPrintTemplate.getName());
        objectNode.put("printType", formPrintParam.getPrintType());
        String printId = this.portalFeignService.wordPrint(objectNode);
        return new CommonResult(true, "", (Object)printId);
    }

    @Override
    public List<FormPrintTemplateFileVo> getPrintListByBoDefIds(String boDefIds) throws Exception {
        List<String> boDefIdList;
        List<FormPrintTemplate> list;
        ArrayList<FormPrintTemplateFileVo> templateFiles = new ArrayList<FormPrintTemplateFileVo>();
        if (StringUtil.isNotEmpty((String)boDefIds) && BeanUtils.isNotEmpty(list = this.getByBoDefIds(boDefIdList = Arrays.asList(boDefIds.split(","))))) {
            for (FormPrintTemplate formPrintTemplate : list) {
                if (!StringUtil.isNotEmpty((String)formPrintTemplate.getFileJson()) || !"bo".equals(formPrintTemplate.getDataSourceForm())) continue;
                ArrayNode fileJson = (ArrayNode)JsonUtil.toJsonNode((String)formPrintTemplate.getFileJson());
                for (JsonNode fileNode : fileJson) {
                    if (!"success".equals(fileNode.get("status").asText())) continue;
                    FormPrintTemplateFileVo vo = new FormPrintTemplateFileVo();
                    vo.setTemplateId(formPrintTemplate.getId());
                    vo.setTemplateAlias(formPrintTemplate.getAlias());
                    vo.setTemplateName(formPrintTemplate.getName());
                    vo.setFileType(formPrintTemplate.getPrintType());
                    vo.setFileId(fileNode.get("id").asText());
                    vo.setFileName(fileNode.get("name").asText());
                    templateFiles.add(vo);
                }
            }
        }
        return templateFiles;
    }

    @Override
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, Optional<String> typeId) {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String filePath = unZipFilePath + "/formPrintTemplates.form.xml";
            String formPrintTemplatesXml = FileUtil.readFile((String)filePath);
            if (StringUtils.isEmpty((String)formPrintTemplatesXml)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            FormPrintTemplateManagerImpl.checkXmlFormat(formPrintTemplatesXml);
            FormWordPrintTemplateXmlList formWordPrintTemplateXmlList = (FormWordPrintTemplateXmlList)JAXBUtil.unmarshall((String)formPrintTemplatesXml, FormWordPrintTemplateXmlList.class);
            List<FormWordPrintTemplateXml> list = formWordPrintTemplateXmlList.getFormWordPrintTemplateXmlList();
            ArrayList<String> names = new ArrayList<String>();
            for (FormWordPrintTemplateXml formWordPrintTemplateXml : list) {
                FormPrintTemplate oformPrintTemplate;
                FormPrintTemplate formPrintTemplate = formWordPrintTemplateXml.getFormPrintTemplate();
                if (!BeanUtils.isNotEmpty((Object)((Object)formPrintTemplate)) || (oformPrintTemplate = this.getByAlias(formPrintTemplate.getAlias())) == null) continue;
                names.add(formPrintTemplate.getName() + "\uff08" + formPrintTemplate.getAlias() + "\uff09");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formPrintTemplatesXml", formPrintTemplatesXml);
            obj.put("filePath", unZipFilePath);
            if (BeanUtils.isEmpty(names)) {
                message = this.importDef(obj, typeId.orElse(""));
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                FormPrintTemplateManager formPrintTemplateManager = (FormPrintTemplateManager)AppUtil.getBean(FormPrintTemplateManager.class);
                formPrintTemplateManager.putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u5957\u6253\u6a21\u677f\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f", (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage() + ",\u4e0d\u652f\u6301\u5bfc\u5165");
        }
        return message;
    }

    @Override
    public Object importSave(Optional<Boolean> confirmImport, Optional<String> typeId, Optional<String> cacheFileId) {
        CommonResult<String> message = null;
        try {
            FormPrintTemplateManager formPrintTemplateManager = (FormPrintTemplateManager)AppUtil.getBean(FormPrintTemplateManager.class);
            if (confirmImport.orElse(false).booleanValue()) {
                String byKey = formPrintTemplateManager.getImportFileFromCache(cacheFileId.get());
                if (StringUtil.isEmpty((String)byKey)) {
                    return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:\u4e0a\u4f20\u7684\u6587\u4ef6\u5df2\u4ece\u7f13\u5b58\u4e2d\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
                }
                ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
                message = this.importDef(objectNode, typeId.orElse(""));
            }
            formPrintTemplateManager.delImportFileFromCache(cacheFileId.orElse(""));
        }
        catch (Exception e) {
            message = new CommonResult<String>(false, "\u5bfc\u5165\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return message;
    }

    @Override
    public CommonResult<String> importDef(ObjectNode objectNode, String typeId) {
        String formPrintTemplatesXml = JsonUtil.getString((JsonNode)objectNode, (String)"formPrintTemplatesXml");
        String filePath = JsonUtil.getString((JsonNode)objectNode, (String)"filePath");
        try {
            Map<String, Boolean> rightMap = CustomUtil.getRightMapByModel(FormPrintTemplate.class, ResourceModelType.PRINT_TEMPLATE, ResourcesRightType.EDIT);
            HashSet<String> noRightNames = new HashSet<String>();
            FormWordPrintTemplateXmlList formWordPrintTemplateXmlList = (FormWordPrintTemplateXmlList)JAXBUtil.unmarshall((String)formPrintTemplatesXml, FormWordPrintTemplateXmlList.class);
            List<FormWordPrintTemplateXml> list = formWordPrintTemplateXmlList.getFormWordPrintTemplateXmlList();
            for (FormWordPrintTemplateXml formWordPrintTemplateXml : list) {
                FormPrintTemplate formPrintTemplate = formWordPrintTemplateXml.getFormPrintTemplate();
                if (CustomUtil.checkRight(rightMap, formPrintTemplate.getAlias())) {
                    formWordPrintTemplateXml.setFilePath(filePath);
                    this.importDef(formWordPrintTemplateXml, typeId);
                    continue;
                }
                noRightNames.add(formPrintTemplate.getName());
            }
            if (noRightNames.size() == list.size()) {
                CommonResult commonResult = CommonResult.error((String)String.format("\u5bfc\u5165\u5931\u8d25\uff0c\u4ee5\u4e0b\u6a21\u677f\u65e0\u6743\u9650\uff1a[%s]", StringUtil.join(noRightNames)));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult("\u5bfc\u5165\u6210\u529f");
            if (noRightNames.size() > 0) {
                commonResult.value((Object)String.format("\u4ee5\u4e0b\u6a21\u677f\u65e0\u6743\u9650\u5df2\u8df3\u8fc7\uff1a[%s]", StringUtil.join(noRightNames)));
            }
            CommonResult commonResult2 = commonResult;
            return commonResult2;
        }
        catch (Exception e) {
            throw new RuntimeException("XML\u8f6c\u6362\u4e3aPOJO\u7c7b\u578b\u9519\u8bef" + e.getMessage(), e);
        }
        finally {
            File boDir = new File(filePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
    }

    private void importDef(FormWordPrintTemplateXml formWordPrintTemplateXml, String typeId) {
        this.importDefinition(formWordPrintTemplateXml, typeId);
    }

    private FormPrintTemplate importDefinition(FormWordPrintTemplateXml formWordPrintTemplateXml, String typeId) {
        FormPrintTemplate formPrintTemplate = formWordPrintTemplateXml.getFormPrintTemplate();
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        ObjectNode sysType = portalFeignService.getSysTypeById(typeId);
        ArrayList<String> boDefIds = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formPrintTemplate.getLabelConfigs())) {
            try {
                ArrayNode labelConfigs = (ArrayNode)JsonUtil.toJsonNode((String)formPrintTemplate.getLabelConfigs());
                Iterator iterator = labelConfigs.iterator();
                while (iterator.hasNext()) {
                    JsonNode jsonNode = (JsonNode)iterator.next();
                    ObjectNode labelConfig = (ObjectNode)jsonNode;
                    String boDefAlias = JsonUtil.getString((JsonNode)labelConfig, (String)"boDefAlias");
                    BoDef boDef = this.boDefManager.getByAlias(boDefAlias);
                    if (BeanUtils.isNotEmpty((Object)boDef)) {
                        labelConfig.put("boDefId", boDef.getId());
                        boDefIds.add(boDef.getId());
                        continue;
                    }
                    iterator.remove();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        formPrintTemplate.setBoDefIds(String.join((CharSequence)",", boDefIds));
        List<FileInfo> fileInfos = formPrintTemplate.getFileInfo();
        ArrayList<File> successFiles = new ArrayList<File>();
        if (BeanUtils.isNotEmpty(fileInfos)) {
            ArrayList<ObjectNode> uploadResults = new ArrayList<ObjectNode>();
            for (FileInfo fileInfo : fileInfos) {
                String suid = UniqueIdUtil.getSuid();
                File file = new File(formWordPrintTemplateXml.getFilePath() + File.separator + fileInfo.getId() + "." + fileInfo.getExtensionName());
                if (!file.exists() || !file.isFile()) continue;
                fileInfo.setId(suid);
                try {
                    this.fileService.uploadFile(fileInfo, (InputStream)new FileInputStream(file));
                    ObjectNode result = JsonUtil.createObjectNode();
                    result.put("id", suid);
                    result.put("name", fileInfo.getFileName());
                    result.put("size", fileInfo.getByteCount());
                    result.put("status", "success");
                    uploadResults.add(result);
                    successFiles.add(file);
                }
                catch (Exception exception) {}
            }
            formPrintTemplate.setFileJson(JsonUtil.toJsonString(uploadResults));
        }
        String typeName = "";
        if (BeanUtils.isNotEmpty((Object)sysType)) {
            typeName = sysType.get("name").asText();
        }
        if (StringUtil.isNotEmpty((String)typeId)) {
            formPrintTemplate.setTypeId(typeId);
            formPrintTemplate.setTypeName(typeName);
        }
        IUser user = ContextUtil.getCurrentUser();
        formPrintTemplate.setCreateTime(LocalDateTime.now());
        FormPrintTemplate entity = this.getByAlias(formPrintTemplate.getAlias());
        if (BeanUtils.isNotEmpty((Object)((Object)entity))) {
            if (BeanUtils.isNotEmpty((Object)user)) {
                formPrintTemplate.setUpdateBy(user.getUserId());
                formPrintTemplate.setUpdateTime(LocalDateTime.now());
            }
            ((FormPrintTemplateDao)this.baseMapper).updateById((Object)formPrintTemplate);
        } else {
            formPrintTemplate.setCreateBy(user.getUserId());
            formPrintTemplate.setId(UniqueIdUtil.getSuid());
            ((FormPrintTemplateDao)this.baseMapper).insert((Object)formPrintTemplate);
        }
        if (BeanUtils.isNotEmpty(successFiles)) {
            for (File successFile : successFiles) {
                FileUtil.deleteDir((File)successFile);
            }
        }
        return formPrintTemplate;
    }

    private ArrayNode getSQl(String sql, JdbcTemplate jdbcTemplate) {
        sql = Ognl.containsWhere((Object)(sql = sql.replace(";", "").replace("\uff1b", ""))) ? sql + " and 1!=1" : sql + " where 1!=1";
        ArrayNode node = JsonUtil.getMapper().createArrayNode();
        SqlRowSet srs = jdbcTemplate.queryForRowSet(sql);
        SqlRowSetMetaData srsmd = srs.getMetaData();
        for (int j = 1; j < srsmd.getColumnCount() + 1; ++j) {
            ObjectNode map = JsonUtil.getMapper().createObjectNode();
            String cn = "";
            if (!StringUtil.isNotEmpty((String)srsmd.getColumnName(j))) continue;
            cn = srsmd.getColumnName(j).toUpperCase();
            String lable = srsmd.getColumnLabel(j);
            String type = srsmd.getColumnTypeName(j);
            map.put("comment", StringUtil.isNotEmpty((String)lable) ? lable : cn);
            map.put("name", cn);
            map.put("type", type.toLowerCase());
            map.put("table", srsmd.getTableName(j));
            node.add((JsonNode)map);
        }
        return node;
    }

    public static void checkXmlFormat(String xml) throws Exception {
        String firstName = "formWordPrintTemplateXmlList";
        String nextName = "formWordPrintTemplateXml";
        Document doc = Dom4jUtil.loadXml((String)xml);
        Element root = doc.getRootElement();
        String msg = "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9";
        if (!root.getName().equals(firstName)) {
            throw new Exception(msg);
        }
        List itemLists = root.elements();
        for (Element elm : itemLists) {
            if (elm.getName().equals(nextName)) continue;
            throw new Exception(msg);
        }
    }

    @Override
    public CommonResult<List<FormPrintTemplate>> getListByBoAlias(String boAlias) {
        if (BeanUtils.isEmpty((Object)boAlias)) {
            return CommonResult.success(new ArrayList());
        }
        BoDef boDef = this.boDefManager.getByAlias(boAlias);
        if (BeanUtils.isEmpty((Object)boDef)) {
            return CommonResult.success(new ArrayList());
        }
        String boDefId = boDef.getId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getDataSourceForm, (Object)"sql")).or(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.like(FormPrintTemplate::getBoDefIds, (Object)boDefId)).eq(FormPrintTemplate::getDataSourceForm, (Object)"bo");
        });
        return CommonResult.success((Object)this.list((Wrapper)wrapper));
    }

    @Override
    public List<String> formWordPrintBatch(String formKey, String boAlias, String printTemplateAlias, String action, String printType, String zipName, List<String> ids) throws Exception {
        Assert.notNull(ids, () -> "\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff01");
        Assert.notNull((Object)printTemplateAlias, () -> "\u8bf7\u9009\u62e9\u5957\u6253\u6a21\u677f\uff01");
        FormPrintTemplate template = this.getByAlias(printTemplateAlias);
        ArrayList<FormPrintParam> printParams = new ArrayList<FormPrintParam>();
        for (String id : ids) {
            Map<String, Object> formData = this.dataTemplateManager.getFormData(formKey, boAlias, id, action, null, null, null);
            if (BeanUtils.isEmpty(formData)) continue;
            FormPrintParam formPrintParam = new FormPrintParam();
            formPrintParam.setPrintType(printType);
            formPrintParam.setId(template.getId());
            formPrintParam.setBoData(JsonUtil.toJson((Object)MapUtil.getIgnoreCase(formData, (String)"data")));
            printParams.add(formPrintParam);
        }
        List<String> fileIds = printParams.stream().map(printParam -> (String)this.asyncFormWordPrint((FormPrintParam)printParam).getValue()).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(fileIds) && fileIds.size() > 1 && StringUtil.isNotEmpty((String)zipName)) {
            fileIds = this.uploadZipFile(fileIds, zipName, printType);
        }
        return fileIds;
    }

    private CommonResult<String> asyncFormWordPrint(FormPrintParam formPrintParam) {
        try {
            return this.formWordPrint(formPrintParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> uploadZipFile(List<String> fileIds, String zipName, String printType) throws Exception {
        File zipFile = null;
        try {
            HashMap byteMap = new HashMap();
            fileIds.parallelStream().forEach(item -> {
                ObjectNode fileNode = this.portalFeignService.fileGet(item);
                if (BeanUtils.isEmpty((Object)fileNode)) {
                    return;
                }
                byte[] fileBytes = this.portalFeignService.getFileBytesById(item);
                String ext = StringUtil.equals((String)printType, (String)"pdf") ? "pdf" : "docx";
                byteMap.put(String.format("%s-%s.%s", JsonUtil.getString((JsonNode)fileNode, (String)"fileName", (String)"\u5957\u6253"), item, ext), fileBytes);
            });
            ZipFileUtil.zip((String)zipName, byteMap);
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(zipName);
            fileInfo.setId(UniqueIdUtil.getSuid());
            fileInfo.setExtensionName("zip");
            String filePath = AppFileUtil.createFilePath((String)ContextUtil.getCurrentUser().getAccount(), (String)String.format("%s.%s", fileInfo.getId(), fileInfo.getExtensionName()));
            fileInfo.setFilePath(filePath);
            zipFile = new File(String.format("%s%s.zip", ZipFileUtil.TEMP_FOLDER, zipName));
            this.fileService.uploadFile(fileInfo, Files.newInputStream(zipFile.toPath(), new OpenOption[0]));
            List<String> list = Collections.singletonList(fileInfo.getId());
            return list;
        }
        finally {
            if (zipFile != null) {
                zipFile.delete();
            }
        }
    }
}

