/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BaseContextThreadUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.form.dto.DataTemplateObjDTO;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormDataTemplate;
import com.hotent.form.model.FormField;
import com.hotent.form.model.FormMeta;
import com.hotent.form.model.FormRight;
import com.hotent.form.model.FormRightButton;
import com.hotent.form.model.FormRightXml;
import com.hotent.form.model.QueryView;
import com.hotent.form.persistence.dao.FormRightDao;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.FormFieldManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormRightButtonManager;
import com.hotent.form.persistence.manager.FormRightManager;
import com.hotent.form.persistence.manager.QueryViewManager;
import com.hotent.form.vo.FormRigthParam;
import com.hotent.uc.api.impl.util.PermissionCalc;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="bpmFormRightManager")
public class FormRightManagerImpl
extends BaseManagerImpl<FormRightDao, FormRight>
implements FormRightManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    PermissionCalc permssionCalc;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormRightButtonManager formRightButtonManager;
    @Resource
    FormDataTemplateManager formDataTemplateManager;
    @Resource
    QueryViewManager queryViewManager;

    @Override
    public JsonNode getDefaultByFormDefKey(String formKey, boolean isInstance) throws IOException {
        FormMeta formDef = this.formMetaManager.getByKey(formKey);
        return this.getDefaultByFormMeta(formDef, isInstance, null);
    }

    private JsonNode getDefaultByFormMeta(FormMeta formDef, boolean isInstance, List<BoDef> boDefList) throws IOException {
        if (formDef == null) {
            return null;
        }
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        List<Map<String, String>> lowList = this.convertMapLower(formDef.getExpand(), boDefList);
        List<BoEnt> boEntList = this.getBoEntList(boDefList);
        List<FormField> fieldList = this.getFieldList(formDef.getId(), boEntList);
        Map<String, List<FormField>> fieldMap = this.convertFormGroup(fieldList);
        ObjectNode tableJson = this.buildTableJson(lowList, fieldMap, isInstance, formDef.getId());
        jsonObj.set("table", (JsonNode)tableJson);
        String opinionJson = formDef.getOpinionConf();
        JsonNode opinionJsonObj = this.buildOpinion(opinionJson, isInstance);
        if (opinionJsonObj != null) {
            jsonObj.set("opinion", opinionJsonObj);
        }
        return jsonObj;
    }

    private List<BoEnt> getBoEntList(List<BoDef> boDefList) {
        ArrayList<BoEnt> boEntList = new ArrayList<BoEnt>();
        if (CollUtil.isNotEmpty(boDefList)) {
            for (BoDef boDef : boDefList) {
                BoEnt boEnt = boDef.getBoEnt();
                if (boEnt == null || !StringUtil.isNotEmpty((String)boEnt.getId())) continue;
                boEntList.add(boDef.getBoEnt());
                FormRightManagerImpl.childBoEnt(boEntList, boDef.getBoEnt());
            }
        }
        return boEntList;
    }

    private List<FormField> getFieldList(String formDefId, List<BoEnt> boEntList) {
        ArrayList<FormField> fieldList = new ArrayList();
        List<Object> noAttrFields = new ArrayList();
        if (CollUtil.isEmpty(boEntList)) {
            fieldList = this.formFieldManager.getExtByFormId(formDefId);
            noAttrFields = this.formFieldManager.getNoAttrByFormId(formDefId);
            noAttrFields.removeIf(field -> "formTable".equals(field.getCtrlType()));
            noAttrFields.removeIf(field -> "dataView".equals(field.getCtrlType()));
        } else {
            Map<String, String> mapIdAndName = boEntList.stream().collect(Collectors.toMap(BoEnt::getId, BoEnt::getName, (a, b) -> a));
            List listAll = this.formFieldManager.list((Wrapper)Wrappers.lambdaQuery().in(FormField::getFormId, new Object[]{formDefId}));
            for (FormField field2 : listAll) {
                if (StringUtil.isNotEmpty((String)field2.getBoAttrId())) {
                    field2.setEntName(mapIdAndName.get(field2.getEntId()));
                    fieldList.add(field2);
                    continue;
                }
                noAttrFields.add((Object)field2);
            }
        }
        if (BeanUtils.isNotEmpty(noAttrFields)) {
            this.setNoAttrFieldEntName(fieldList, noAttrFields);
            fieldList.addAll(noAttrFields);
        }
        return fieldList;
    }

    private ObjectNode buildTableJson(List<Map<String, String>> lowList, Map<String, List<FormField>> fieldMap, boolean isInstance, String formDefId) throws IOException {
        ObjectNode tableJson = JsonUtil.getMapper().createObjectNode();
        for (Map<String, String> entMap : lowList) {
            JsonNode json = this.buildTable(entMap, fieldMap, isInstance);
            if (json == null) continue;
            String entName = entMap.get("name_");
            tableJson.set(entName, json);
        }
        this.setFormTable(isInstance, formDefId, tableJson);
        this.setDataView(isInstance, formDefId, tableJson);
        return tableJson;
    }

    private void setFormTable(boolean isInstance, String formDefId, ObjectNode tableJson) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FormField.class).eq(FormField::getCtrlType, (Object)"formTable")).eq(FormField::getFormId, (Object)formDefId);
        List fieldList = this.formFieldManager.list((Wrapper)wrapper);
        for (FormField field : fieldList) {
            String desc;
            if (StringUtil.isEmpty((String)field.getDataKey())) continue;
            FormDataTemplate dataTemplate = this.formDataTemplateManager.getByAlias(field.getDataKey());
            if (dataTemplate != null && StringUtil.isNotEmpty((String)dataTemplate.getName())) {
                desc = dataTemplate.getName();
            } else {
                BoDef byDefId = this.boDefManager.getByDefId(field.getBoDefId());
                desc = Optional.ofNullable(byDefId).map(BoDef::getBoEnt).map(BoEnt::getDesc).filter(StringUtil::isNotEmpty).orElse("\u7f3a\u7701\u8868\u5355\u5217\u8868");
            }
            ObjectNode rightJsonObj = JsonUtil.getMapper().createObjectNode();
            ObjectNode rightJson = JsonUtil.getMapper().createObjectNode();
            rightJson.put("hidden", false);
            rightJson.put("add", !isInstance);
            rightJson.put("del", !isInstance);
            rightJson.put("edit", true);
            rightJson.put("export", true);
            rightJsonObj.put("main", false);
            rightJsonObj.set("rights", (JsonNode)rightJson);
            rightJsonObj.put("description", desc);
            rightJsonObj.put("ctrlType", "formTable");
            tableJson.set(field.getDataKey() + "[formTable]", (JsonNode)rightJsonObj);
        }
    }

    private Map<String, List<DataTemplateObjDTO>> getDataViewMap(String formDefId) {
        HashMap<String, List<DataTemplateObjDTO>> mapDataView = new HashMap<String, List<DataTemplateObjDTO>>();
        List<Form> formList = ((FormManager)AppUtil.getBean(FormManager.class)).getByDefId(formDefId);
        if (CollUtil.isNotEmpty(formList)) {
            try {
                JsonNode expandNode = JsonUtil.toJsonNode((String)formList.get(0).getExpand());
                if (expandNode.get("list") instanceof ArrayNode) {
                    ArrayNode listNode = (ArrayNode)expandNode.get("list");
                    for (JsonNode node : listNode) {
                        List objDTOList;
                        String ctrlType = JsonUtil.getString((JsonNode)node, (String)"ctrlType");
                        String name = JsonUtil.getString((JsonNode)node, (String)"name");
                        if (!"dataView".equals(ctrlType) || !(node.get("dataTemplateObj") instanceof ArrayNode) || !CollUtil.isNotEmpty((Collection)(objDTOList = (List)JsonUtil.toBean((JsonNode)node.get("dataTemplateObj"), (TypeReference)new TypeReference<List<DataTemplateObjDTO>>(){})))) continue;
                        mapDataView.put(name, objDTOList);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mapDataView;
    }

    private void setDataView(boolean isInstance, String formDefId, ObjectNode tableJson) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FormField.class).eq(FormField::getCtrlType, (Object)"dataView")).eq(FormField::getFormId, (Object)formDefId);
        List fieldList = this.formFieldManager.list((Wrapper)wrapper);
        Map<String, List<DataTemplateObjDTO>> mapDataView = this.getDataViewMap(formDefId);
        for (FormField field : fieldList) {
            String desc;
            if (StringUtil.isEmpty((String)field.getDataKey())) continue;
            if (mapDataView.containsKey(field.getName())) {
                List<DataTemplateObjDTO> objDTOList = mapDataView.get(field.getName());
                for (DataTemplateObjDTO objDTO : objDTOList) {
                    String dataKey = objDTO.getDataTemplateKey();
                    String desc2 = objDTO.getName();
                    this.buildDataView(dataKey, desc2, isInstance, tableJson);
                }
                continue;
            }
            String dataKey = field.getDataKey();
            QueryView queryView = this.queryViewManager.getByAlias(dataKey);
            if (queryView != null && StringUtil.isNotEmpty((String)queryView.getName())) {
                desc = queryView.getName();
            } else {
                BoDef byDefId = this.boDefManager.getByDefId(field.getBoDefId());
                desc = Optional.ofNullable(byDefId).map(BoDef::getBoEnt).map(BoEnt::getDesc).filter(StringUtil::isNotEmpty).orElse("\u7f3a\u7701\u6570\u636e\u5217\u8868");
            }
            this.buildDataView(dataKey, desc, isInstance, tableJson);
        }
    }

    private void buildDataView(String dataKey, String desc, boolean isInstance, ObjectNode tableJson) {
        ObjectNode rightJsonObj = JsonUtil.getMapper().createObjectNode();
        ObjectNode rightJson = JsonUtil.getMapper().createObjectNode();
        rightJson.put("hidden", false);
        rightJson.put("add", !isInstance);
        rightJson.put("del", !isInstance);
        rightJson.put("edit", true);
        rightJson.put("export", true);
        rightJsonObj.put("main", false);
        rightJsonObj.set("rights", (JsonNode)rightJson);
        rightJsonObj.put("description", desc);
        rightJsonObj.put("ctrlType", "dataView");
        tableJson.set(dataKey + "[dataView]", (JsonNode)rightJsonObj);
    }

    private static void childBoEnt(List<BoEnt> boEntList, BoEnt boEnt) {
        List childEntList = boEnt.getChildEntList();
        if (BeanUtils.isNotEmpty((Object)childEntList)) {
            for (BoEnt ent : childEntList) {
                boEntList.add(ent);
                FormRightManagerImpl.childBoEnt(boEntList, ent);
            }
        }
    }

    private void setNoAttrFieldEntName(List<FormField> fieldList, List<FormField> noAttrFields) {
        if (BeanUtils.isNotEmpty(fieldList) && BeanUtils.isNotEmpty(noAttrFields)) {
            HashMap<String, String> entNameMap = new HashMap<String, String>();
            for (FormField formField : fieldList) {
                entNameMap.put(formField.getEntId(), formField.getEntName());
            }
            for (FormField formField : noAttrFields) {
                formField.setEntName((String)entNameMap.get(formField.getEntId()));
            }
        }
    }

    private JsonNode buildOpinion(String json, boolean isInstance) throws IOException {
        if (StringUtil.isEmpty((String)json)) {
            return null;
        }
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        JsonNode ary = JsonUtil.toJsonNode((String)json);
        for (Object obj : ary) {
            JsonNode jsonObj = (JsonNode)obj;
            String name = jsonObj.get("name") + "";
            String desc = jsonObj.get("desc") + "";
            ObjectNode permissionJson = this.getPermissionJson(desc);
            permissionJson = isInstance ? this.getInstPermissionJson(desc) : this.getPermissionJson(desc);
            rtnJson.set(name, (JsonNode)permissionJson);
        }
        return rtnJson;
    }

    private JsonNode buildTable(Map<String, String> entMap, Map<String, List<FormField>> fieldMap, boolean isInstance) throws IOException {
        String entName = entMap.get("name_");
        String entDesc = entMap.get("desc_");
        String type = entMap.get("type_");
        List<FormField> list = fieldMap.get(entName);
        if (BeanUtils.isEmpty(list)) {
            return null;
        }
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        jsonObj.put("description", entDesc);
        if ("main".equalsIgnoreCase(type)) {
            jsonObj.put("main", true);
        } else {
            ObjectNode rightJson = JsonUtil.getMapper().createObjectNode();
            rightJson.put("hidden", false);
            rightJson.put("add", !isInstance);
            rightJson.put("del", !isInstance);
            if ("onetoone".equals(type)) {
                rightJson.put("required", true);
            } else {
                rightJson.put("required", false);
            }
            jsonObj.put("main", false);
            jsonObj.set("rights", (JsonNode)rightJson);
        }
        ObjectNode fieldsJson = JsonUtil.getMapper().createObjectNode();
        for (FormField field : list) {
            if (StringUtil.isEmpty((String)field.getName())) continue;
            ObjectNode permissonJson = !isInstance ? this.getPermissionJson(field.getDesc(), field.getSn()) : this.getInstPermissionJson(field.getDesc(), field.getSn());
            permissonJson.put("fieldName", field.getName());
            permissonJson.put("ctrlType", field.getCtrlType());
            fieldsJson.set(field.getName(), (JsonNode)permissonJson);
        }
        jsonObj.set("fields", (JsonNode)fieldsJson);
        return jsonObj;
    }

    private ObjectNode getPermissionJson(String desc) throws IOException {
        if (StringUtil.isNotEmpty((String)desc)) {
            desc = desc.replaceAll("\"", "'");
        }
        String json = "{\"description\": \"" + desc + "\",\"read\": [{\"type\": \"everyone\"}],\"write\": [{\"type\": \"everyone\"}],\"required\": [{\"type\": \"none\"}]}";
        Object flowKey = BaseContextThreadUtil.getCommuVar((String)"form_right_flow", null);
        Object isUpdatePermission = BaseContextThreadUtil.getCommuVar((String)"update_permission", null);
        if (null != flowKey || null != isUpdatePermission) {
            json = "{\"description\": \"" + desc + "\",\"read\": [{\"type\": \"everyone\"}],\"write\": [{\"type\": \"none\"}],\"required\": [{\"type\": \"none\"}]}";
        }
        return (ObjectNode)JsonUtil.toJsonNode((String)json);
    }

    private ObjectNode getPermissionJson(String desc, Integer sn) throws IOException {
        ObjectNode json = this.getPermissionJson(desc);
        json.put("sn", sn);
        return json;
    }

    private ObjectNode getInstPermissionJson(String desc) throws IOException {
        desc = desc.replaceAll("\"", "'");
        String json = "{\"description\": \"" + desc + "\",\"read\": [{\"type\": \"everyone\"}]}";
        return (ObjectNode)JsonUtil.toJsonNode((String)json);
    }

    private ObjectNode getInstPermissionJson(String desc, Integer sn) throws IOException {
        ObjectNode json = this.getInstPermissionJson(desc);
        json.put("sn", sn);
        return json;
    }

    private Map<String, List<FormField>> convertFormGroup(List<FormField> fieldList) {
        HashMap<String, List<FormField>> map = new HashMap<String, List<FormField>>();
        for (FormField field : fieldList) {
            List<FormField> list;
            String entName = field.getEntName();
            if (map.containsKey(entName)) {
                list = (List)map.get(entName);
                list.add(field);
                continue;
            }
            list = new ArrayList();
            list.add(field);
            map.put(entName, list);
        }
        return map;
    }

    private List<Map<String, String>> convertMapLower(String expand, List<BoDef> boDefListMain) throws IOException {
        JsonNode expandJson = JsonUtil.toJsonNode((String)expand);
        ArrayNode boDefList = (ArrayNode)expandJson.findValue("boDefList");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashSet<String> addBos = new HashSet<String>();
        for (JsonNode jsonNode : boDefList) {
            JsonNode aliasNode = jsonNode.get("alias");
            if (BeanUtils.isEmpty((Object)aliasNode) || addBos.contains(aliasNode.asText())) continue;
            addBos.add(aliasNode.asText());
            String defId = jsonNode.get("id").asText();
            BoDef boDefMain = CollUtil.isEmpty(boDefListMain) ? null : (BoDef)boDefListMain.stream().filter(d -> defId.equals(d.getId())).findFirst().orElse(null);
            BoDef boDef = boDefMain == null ? this.boDefManager.getByDefId(defId) : this.boDefManager.getByBoDef(boDefMain, defId);
            BoEnt boEnt = boDef.getBoEnt();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("name_", boEnt.getName());
            map.put("desc_", boEnt.getDesc());
            map.put("type_", boEnt.getType());
            map.put("sn_", "0");
            map.put("grade_", "main");
            list.add(map);
            List childEntList = boEnt.getChildEntList();
            int i = 0;
            while (i < childEntList.size()) {
                BoEnt childEnt = (BoEnt)childEntList.get(i);
                map = new LinkedHashMap();
                map.put("name_", childEnt.getName());
                map.put("desc_", childEnt.getDesc());
                map.put("type_", childEnt.getType());
                map.put("sn_", i++ + "");
                map.put("grade_", "sub");
                list.add(map);
                List sunEntList = childEnt.getChildEntList();
                if (!BeanUtils.isNotEmpty((Object)sunEntList)) continue;
                int j = 0;
                while (j < sunEntList.size()) {
                    map = new LinkedHashMap();
                    map.put("name_", ((BoEnt)sunEntList.get(j)).getName());
                    map.put("desc_", ((BoEnt)sunEntList.get(j)).getDesc());
                    map.put("type_", ((BoEnt)sunEntList.get(j)).getType());
                    map.put("grade_", "sun");
                    map.put("sn_", j++ + "");
                    list.add(map);
                }
            }
        }
        return list;
    }

    private JsonNode getByFlowKey(String flowKey, String parentFlowKey, String formKey) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFlowKey(flowKey, parentFlowKey, 1);
        if (right != null) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
            return rtnJson;
        }
        return null;
    }

    private JsonNode getByFlowNodeId(String flowKey, String nodeId, String parentFlowKey, String formKey) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFlowNodeId(flowKey, nodeId, parentFlowKey, 1);
        if (right != null) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
            return rtnJson;
        }
        return null;
    }

    @Override
    @CacheEvict(value={"eip:form:defaultRight"}, key="#formKey + '-' + #isReadOnly")
    public void removeDefaultRightCache(String formKey, boolean isReadOnly) {
    }

    @Override
    @Cacheable(value={"eip:form:defaultRight"}, key="#formKey + '-' + #isReadOnly")
    public JsonNode getByFormKey(String formKey, boolean isReadOnly) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFormKey(formKey, isReadOnly);
        JsonNode rtnJson = null;
        if (right != null) {
            return this.formRightPerm2Json(right, rtnJson);
        }
        right = ((FormRightDao)this.baseMapper).getByFormKeyAndType(formKey, 0, null);
        if (right != null) {
            return this.formRightPerm2Json(right, rtnJson);
        }
        String formMetaKey = this.formMetaManager.getMetaKeyByFormKey(formKey);
        rtnJson = this.getDefaultByFormDefKey(formMetaKey, isReadOnly);
        return rtnJson;
    }

    @Override
    public JsonNode getByFormKey(String formKey, boolean isReadOnly, FormMeta formMeta, List<BoDef> boDefList) throws IOException {
        List rightList = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormRight::getFormKey, (Object)formKey)).and(f -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)f.isNull(FormRight::getFlowKey)).or()).eq(FormRight::getFlowKey, (Object)"");
        }));
        FormRight right = rightList.stream().filter(r -> isReadOnly ? r.getPermissionType() == 2 : r.getPermissionType() == 1).findFirst().orElse(null);
        JsonNode rtnJson = null;
        if (right != null) {
            return this.formRightPerm2Json(right, rtnJson);
        }
        right = rightList.stream().filter(r -> r.getPermissionType() == 0).findFirst().orElse(null);
        if (right != null) {
            return this.formRightPerm2Json(right, rtnJson);
        }
        if (formMeta == null) {
            String formMetaKey = this.formMetaManager.getMetaKeyByFormKey(formKey);
            rtnJson = this.getDefaultByFormDefKey(formMetaKey, isReadOnly);
        } else {
            rtnJson = this.getDefaultByFormMeta(formMeta, isReadOnly, boDefList);
        }
        return rtnJson;
    }

    private JsonNode formRightPerm2Json(FormRight right, JsonNode rtnJson) {
        try {
            rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    private JsonNode getByInst(String flowKey) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFlowKey(flowKey, "", 2);
        if (right != null) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
            return rtnJson;
        }
        return null;
    }

    @Override
    @Transactional
    public void removeInst(String flowKey) {
        ((FormRightDao)this.baseMapper).removeByFlowKey(flowKey, "", 2);
    }

    @Override
    @Transactional
    public void remove(String formKey, String flowKey, String nodeId, String parentFlowKey) {
        FormRight right = null;
        if (StringUtil.isNotEmpty((String)flowKey)) {
            right = StringUtil.isNotEmpty((String)nodeId) ? ((FormRightDao)this.baseMapper).getByFlowNodeId(flowKey, nodeId, parentFlowKey, 1) : ((FormRightDao)this.baseMapper).getByFlowKey(flowKey, parentFlowKey, 1);
        }
        if (right != null && !formKey.equals(right.getFormKey())) {
            this.remove(flowKey, nodeId, parentFlowKey);
        }
    }

    @Override
    @Transactional
    public void remove(String flowKey, String nodeId, String parentFlowKey) {
        ((FormRightDao)this.baseMapper).removeByFlowNode(flowKey, nodeId, parentFlowKey);
    }

    @Override
    @Transactional
    public void remove(String flowKey, String parentFlowKey) {
        ((FormRightDao)this.baseMapper).removeByFlowKey(flowKey, parentFlowKey, 1);
    }

    @Override
    @Transactional
    public String save(FormRigthParam param) {
        boolean isButtonRight;
        String rightIdExists = "";
        if (StringUtil.isNotEmpty((String)param.getFlowKey())) {
            if (param.getType() == 1) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.eq(FormRight::getFlowKey, (Object)param.getFlowKey());
                if (StringUtil.isEmpty((String)param.getNodeId())) {
                    wrapper.and(w -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(FormRight::getNodeId)).or()).eq(FormRight::getNodeId, (Object)"");
                    });
                } else {
                    wrapper.eq(FormRight::getNodeId, (Object)param.getNodeId());
                }
                if (StringUtil.isEmpty((String)param.getParentflowKey())) {
                    wrapper.and(w -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(FormRight::getParentFlowKey)).or()).eq(FormRight::getParentFlowKey, (Object)"");
                    });
                } else {
                    wrapper.eq(FormRight::getParentFlowKey, (Object)param.getParentflowKey());
                }
                List rightList = this.list((Wrapper)wrapper);
                if (CollUtil.isNotEmpty((Collection)rightList)) {
                    if (rightList.size() > 1) {
                        this.remove(param.getFlowKey(), param.getNodeId(), param.getParentflowKey());
                    } else {
                        rightIdExists = ((FormRight)((Object)rightList.get(0))).getId();
                    }
                }
            } else {
                this.removeInst(param.getFlowKey());
            }
        } else if (StringUtil.isEmpty((String)param.getDataKey())) {
            this.removeByFormKeyType(param.getFormKey(), param.getType());
        }
        if (StringUtil.isNotEmpty((String)param.getDataKey())) {
            this.removeByDataKey(param.getDataKey(), param.getType(), param.getButtonId());
        }
        String id = UniqueIdUtil.getSuid();
        FormRight right = new FormRight();
        right.setId(id);
        right.setFormKey(param.getFormKey());
        right.setFlowKey(param.getFlowKey());
        right.setNodeId(param.getNodeId());
        right.setParentFlowKey(param.getParentflowKey());
        right.setPermission(param.getPermission());
        right.setPermissionType(param.getType());
        right.setIsCheckOpinion(param.getIsCheckOpinion());
        right.setDataKey(param.getDataKey());
        boolean bl = isButtonRight = param.getType() == 4 || param.getType() == 3 || param.getType() == 5;
        if (StringUtil.isNotEmpty((String)param.getDataKey()) && StringUtil.isNotEmpty((String)param.getButtonId()) && isButtonRight) {
            this.formRightButtonManager.addFormRightButton(param.getDataKey(), param.getButtonId(), id);
        }
        if (StringUtil.isNotEmpty((String)rightIdExists)) {
            right.setId(rightIdExists);
            this.update((Model)right);
        } else {
            this.create((Model)right);
        }
        return right.getId();
    }

    @Override
    public JsonNode getPermissionSetting(FormRigthParam param) throws IOException {
        JsonNode json = this.getPermissionNoDefault(param);
        if (json == null) {
            boolean isReadOnly = param.getType() == 2 || param.getType() == 5;
            json = ((FormRightManagerImpl)AppUtil.getBean(this.getClass())).getByFormKey(param.getFormKey(), isReadOnly);
        }
        return json;
    }

    @Override
    public JsonNode getPermissionNoDefault(FormRigthParam param) throws IOException {
        List<Integer> buttonPermissions;
        JsonNode json = null;
        if (StringUtil.isNotEmpty((String)param.getFlowKey())) {
            if (param.getType() == 1) {
                if (StringUtil.isEmpty((String)param.getNodeId())) {
                    json = this.getByFlowKey(param.getFlowKey(), param.getParentflowKey(), param.getFormKey());
                } else {
                    json = this.getByFlowNodeId(param.getFlowKey(), param.getNodeId(), param.getParentflowKey(), param.getFormKey());
                    if (json == null) {
                        json = this.getByFlowKey(param.getFlowKey(), param.getParentflowKey(), param.getFormKey());
                    }
                    if (json == null && StringUtil.isNotEmpty((String)param.getParentflowKey())) {
                        json = this.getByFlowKey(param.getParentflowKey(), "", param.getFormKey());
                    }
                }
            } else {
                json = this.getByInst(param.getFlowKey());
            }
        }
        if ((buttonPermissions = Arrays.asList(4, 3, 5)).contains(param.getType()) && StringUtil.isNotEmpty((String)param.getButtonId())) {
            json = this.getByButtonId(param);
        } else {
            if (StringUtil.isNotEmpty((String)param.getDataKey())) {
                json = this.getByDataKey(param.getDataKey(), param.getType(), param.getFormKey());
            }
            if (json == null) {
                json = this.getByFormKey(param.getFormKey(), param.getType(), param.getDataKey());
            }
        }
        return json;
    }

    private JsonNode getByButtonId(FormRigthParam param) throws IOException {
        FormRightButton formRightButton = this.formRightButtonManager.getByButtonId(param.getButtonId(), param.getDataKey());
        if (formRightButton != null) {
            FormRight formRight = (FormRight)this.get((Serializable)((Object)formRightButton.getFormRightId()));
            if (BeanUtils.isEmpty((Object)((Object)formRight))) {
                QueryWrapper formKeyWrapper = new QueryWrapper();
                ((QueryWrapper)formKeyWrapper.eq((Object)"form_key_", (Object)param.getFormKey())).eq((Object)"permission_type_", (Object)0);
                formRight = (FormRight)((Object)((FormRightDao)this.baseMapper).selectOne((Wrapper)formKeyWrapper));
            }
            if (BeanUtils.isNotEmpty((Object)((Object)formRight))) {
                JsonNode rtnJson = JsonUtil.toJsonNode((String)formRight.getPermission());
                return rtnJson;
            }
        }
        return null;
    }

    @Override
    public JsonNode getPermission(String formKey, String dataKey, Integer type, String buttonId) throws IOException {
        FormRigthParam param = new FormRigthParam();
        param.setFormKey(formKey);
        param.setFlowKey("");
        param.setParentflowKey("");
        param.setNodeId("");
        param.setType(type);
        param.setDataKey(dataKey);
        param.setButtonId(buttonId);
        JsonNode json = this.getPermissionSetting(param);
        return this.calcFormPermission(json);
    }

    @Override
    public JsonNode getPermission(String formKey, String flowKey, String parentFlowKey, String nodeId, int type) throws IOException {
        FormRigthParam param = new FormRigthParam();
        param.setFormKey(formKey);
        param.setFlowKey(flowKey);
        param.setParentflowKey(parentFlowKey);
        param.setNodeId(nodeId);
        param.setType(type);
        JsonNode json = this.getPermissionSetting(param);
        return this.calcFormPermission(json);
    }

    @Override
    public JsonNode calcFormPermission(JsonNode permissionConf) throws IOException {
        ObjectNode tableJsons;
        Map profilesMap = this.permssionCalc.getCurrentProfiles();
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isEmpty((Object)permissionConf)) {
            return rtnJson;
        }
        if (BeanUtils.isNotEmpty((Object)permissionConf.get("subRowAuth"))) {
            rtnJson.set("subRowAuth", permissionConf.get("subRowAuth"));
        }
        if (BeanUtils.isNotEmpty((Object)(tableJsons = (ObjectNode)permissionConf.get("table")))) {
            Object formType;
            ObjectNode rtnTableFieldJson = JsonUtil.getMapper().createObjectNode();
            ObjectNode rtnTableJson = JsonUtil.getMapper().createObjectNode();
            ObjectNode rtnTableDesensiJson = JsonUtil.getMapper().createObjectNode();
            Iterator tableIt = tableJsons.fields();
            while (tableIt.hasNext()) {
                Map.Entry table = (Map.Entry)tableIt.next();
                JsonNode tableJson = tableJsons.get((String)table.getKey());
                JsonNode tableFieldJson = this.buildTablePermission(tableJson, profilesMap);
                JsonNode tableFieldDesensiJson = this.buildTableDesensitization(tableJson, profilesMap);
                rtnTableFieldJson.set((String)table.getKey(), tableFieldJson);
                rtnTableDesensiJson.set((String)table.getKey(), tableFieldDesensiJson);
                boolean isMain = tableJson.get("main").asBoolean();
                if (isMain) continue;
                ObjectNode tableRights = (ObjectNode)tableJson.get("rights");
                if ("dataView".equals(JsonUtil.getString((JsonNode)tableJson, (String)"ctrlType"))) {
                    tableRights.put("isDataView", true);
                }
                rtnTableJson.set((String)table.getKey(), (JsonNode)tableRights);
            }
            rtnJson.set("fields", (JsonNode)rtnTableFieldJson);
            rtnJson.set("desensitization", (JsonNode)rtnTableDesensiJson);
            if (rtnTableJson.size() > 0) {
                rtnJson.set("table", (JsonNode)rtnTableJson);
            }
            if (BeanUtils.isNotEmpty((Object)(formType = BaseContextThreadUtil.getCommuVar((String)"formType", (Object)"")))) {
                rtnJson.put("formType", formType.toString());
            }
            if (permissionConf.get("opinion") != null || StringUtil.isEmpty((String)(permissionConf.get("opinion") + ""))) {
                return rtnJson;
            }
            ObjectNode rtnOpinionJson = JsonUtil.getMapper().createObjectNode();
            JsonNode opinionJson = permissionConf.get("opinion");
            if (BeanUtils.isNotEmpty((Object)opinionJson)) {
                Iterator opinionIt = opinionJson.fields();
                while (opinionIt.hasNext()) {
                    Map.Entry opinion = (Map.Entry)opinionIt.next();
                    JsonNode perJson = opinionJson.get((String)opinion.getKey());
                    String permission = this.calcPermission(perJson, profilesMap);
                    rtnOpinionJson.put((String)opinion.getKey(), permission);
                }
            }
            rtnJson.set("opinion", (JsonNode)rtnOpinionJson);
            return rtnJson;
        }
        return JsonUtil.getMapper().createObjectNode();
    }

    private JsonNode buildTablePermission(JsonNode tableJson, Map<String, Set<String>> profilesMap) throws IOException {
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        JsonNode fieldJsons = tableJson.get("fields");
        if (BeanUtils.isEmpty((Object)fieldJsons)) {
            return rtnJson;
        }
        Iterator fieldIt = fieldJsons.fields();
        while (fieldIt.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIt.next();
            JsonNode perJson = fieldJsons.get((String)field.getKey());
            String permission = this.calcPermission(perJson, profilesMap);
            rtnJson.put((String)field.getKey(), permission);
        }
        return rtnJson;
    }

    private JsonNode buildTableDesensitization(JsonNode tableJson, Map<String, Set<String>> profilesMap) throws IOException {
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        JsonNode fieldJsons = tableJson.get("fields");
        if (BeanUtils.isEmpty((Object)fieldJsons)) {
            return rtnJson;
        }
        Iterator fieldIt = fieldJsons.fields();
        while (fieldIt.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIt.next();
            JsonNode perJson = fieldJsons.get((String)field.getKey());
            if (!perJson.hasNonNull("desensiPcRule") && !perJson.hasNonNull("desensiMobileRule")) continue;
            ObjectNode desensiObj = JsonUtil.getMapper().createObjectNode();
            if (perJson.hasNonNull("desensiPcRule")) {
                desensiObj.put("pc", perJson.get("desensiPcRule").asText());
            }
            if (perJson.hasNonNull("desensiMobileRule")) {
                desensiObj.put("mobile", perJson.get("desensiMobileRule").asText());
            }
            rtnJson.set((String)field.getKey(), (JsonNode)desensiObj);
        }
        return rtnJson;
    }

    private String calcPermission(JsonNode perJson, Map<String, Set<String>> profilesMap) throws IOException {
        boolean hasRead;
        boolean hasWrite;
        boolean hasRequired = this.hasRight(perJson, "required", profilesMap);
        String permission = "r";
        permission = hasRequired ? "b" : ((hasWrite = this.hasRight(perJson, "write", profilesMap)) ? "w" : ((hasRead = this.hasRight(perJson, "read", profilesMap)) ? "r" : "n"));
        return permission;
    }

    private boolean hasRight(JsonNode jsonObj, String type, Map<String, Set<String>> profilesMap) throws IOException {
        if (!jsonObj.has(type)) {
            return false;
        }
        JsonNode jsonArray = jsonObj.get(type);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonNode json = jsonArray.get(i);
            boolean hasRight = this.permssionCalc.hasRight(json.toString(), profilesMap);
            if (!hasRight) continue;
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public void removeByFormKey(String formKey) {
        ((FormRightDao)this.baseMapper).removeByFormKey(formKey);
    }

    @Override
    public JsonNode getStartPermission(String formKey, String flowKey, String nodeId, String nextNodeId) throws IOException {
        JsonNode JsonNode2 = null;
        JsonNode2 = StringUtil.isNotEmpty((String)nodeId) ? this.getByFlowNodeId(flowKey, nodeId, "", formKey) : this.getByFlowKey(flowKey, "", formKey);
        if (BeanUtils.isEmpty((Object)JsonNode2)) {
            JsonNode2 = this.getByFormKey(formKey, false);
        }
        return this.calcFormPermission(JsonNode2);
    }

    @Override
    public List<FormRight> getByFlowKey(String flowKey) {
        return ((FormRightDao)this.baseMapper).getAllByFlowKey(flowKey);
    }

    @Override
    public List<FormRight> getByFormKeys(List<String> listFormKey, int type) {
        if (CollUtil.isEmpty(listFormKey)) {
            return null;
        }
        return ((FormRightDao)this.baseMapper).getByFormKeys(listFormKey, type);
    }

    @Override
    public List<Map<String, String>> getTableOrderBySn(String formKey) throws IOException {
        String formMetaKey = this.formMetaManager.getMetaKeyByFormKey(formKey);
        FormMeta formDef = this.formMetaManager.getByKey(formMetaKey);
        if (formDef != null) {
            List<Map<String, String>> retList = this.convertMapLower(formDef.getExpand(), null);
            return retList;
        }
        return new ArrayList<Map<String, String>>();
    }

    @Override
    @Transactional
    public void importFormRights(String formRightsXml, List<String> hasRightImportForms) {
        try {
            FormRightXml formRightList = (FormRightXml)JAXBUtil.unmarshall((String)formRightsXml, FormRightXml.class);
            List<FormRight> list = formRightList.getRightList();
            for (FormRight bpmFormRight : list) {
                if (hasRightImportForms != null && !hasRightImportForms.contains(bpmFormRight.getFormKey())) continue;
                FormRight right = StringUtil.isNotEmpty((String)bpmFormRight.getFormKey()) && bpmFormRight.getPermissionType() == 0 ? ((FormRightDao)this.baseMapper).getByFormKeyAndType(bpmFormRight.getFormKey(), bpmFormRight.getPermissionType(), null) : ((FormRightDao)this.baseMapper).getByFlowNodeId(bpmFormRight.getFlowKey(), bpmFormRight.getNodeId(), bpmFormRight.getParentFlowKey(), bpmFormRight.getPermissionType());
                if (BeanUtils.isNotEmpty((Object)((Object)right))) {
                    bpmFormRight.setId(right.getId());
                    this.update((Model)bpmFormRight);
                    ThreadMsgUtil.addMsg((String)("\u6d41\u7a0b[" + bpmFormRight.getFlowKey() + "]\u4e2d\u8282\u70b9[ " + (Object)((Object)bpmFormRight) + " ]\u7684\u8868\u5355\u6388\u6743\u5df2\u7ecf\u5b58\u5728,\u66f4\u65b0\u6210\u529f"));
                    continue;
                }
                bpmFormRight.setId(UniqueIdUtil.getSuid());
                this.create((Model)bpmFormRight);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u5165\u8868\u5355\u6743\u9650\u5931\u8d25" + e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void removeByFlowKey(String flowKey, String parentFlowKey, int permissionType) {
        ((FormRightDao)this.baseMapper).removeByFlowKey(flowKey, parentFlowKey, permissionType);
    }

    @Override
    public JsonNode getDefaultByDesign(String formDefId, String expand, boolean isInstance) throws Exception {
        JsonNode expandJson = JsonUtil.toJsonNode((String)expand);
        if (BeanUtils.isEmpty((Object)expandJson)) {
            return JsonUtil.getMapper().createObjectNode();
        }
        List<Map<String, String>> lowList = this.convertMapLower(expand, null);
        List<FormField> fieldList = this.formFieldManager.getExtByFormId(formDefId);
        Map<String, List<FormField>> fieldMap = this.convertFormGroup(fieldList);
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        ObjectNode tableJson = JsonUtil.getMapper().createObjectNode();
        for (Map<String, String> entMap : lowList) {
            JsonNode json = this.buildTable(entMap, fieldMap, isInstance);
            if (json == null) continue;
            String entName = entMap.get("name_");
            tableJson.set(entName, json);
        }
        jsonObj.set("table", (JsonNode)tableJson);
        String opinionJson = JsonUtil.toJson((Object)expandJson.get("opinion"));
        JsonNode opinionJsonObj = this.buildOpinion(opinionJson, isInstance);
        if (opinionJsonObj != null) {
            jsonObj.set("opinion", opinionJsonObj);
        }
        return jsonObj;
    }

    @Override
    public String getByTeam(String flowKey, String nodeId) {
        return ((FormRightDao)this.baseMapper).getByTeam(flowKey, nodeId);
    }

    @Override
    @Transactional
    public void emptyAll(String formKey, String flowKey) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)formKey), (String)"\u6e05\u7a7a\u8868\u5355\u6743\u9650\u65f6\u8868\u5355Key\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        ((FormRightDao)this.baseMapper).emptyAll(formKey, flowKey);
    }

    @Override
    public JsonNode getByDataKey(String dataKey, Integer type, String formKey) throws IOException {
        QueryWrapper wrapper = new QueryWrapper();
        if (type == null) {
            wrapper.eq((Object)"data_key_", (Object)dataKey);
        } else {
            ((QueryWrapper)wrapper.eq((Object)"data_key_", (Object)dataKey)).eq((Object)"permission_type_", (Object)type);
        }
        List formRightList = this.list((Wrapper)wrapper);
        FormRight formRight = null;
        if (CollUtil.isNotEmpty((Collection)formRightList)) {
            formRight = (FormRight)((Object)formRightList.get(0));
            for (FormRight tempFormRight : formRightList) {
                int count = this.formRightButtonManager.count((Wrapper)Wrappers.lambdaQuery().eq(FormRightButton::getFormRightId, (Object)tempFormRight.getId()));
                if (count <= 0) continue;
                formRight = tempFormRight;
                break;
            }
            if (formRightList.size() > 1) {
                this.removeByIds(formRightList.stream().map(FormRight::getId).collect(Collectors.toList()));
                this.create((Model)formRight);
            }
        }
        if (BeanUtils.isEmpty(formRight)) {
            QueryWrapper formKeyWrapper = new QueryWrapper();
            ((QueryWrapper)formKeyWrapper.eq((Object)"form_key_", (Object)formKey)).eq((Object)"permission_type_", (Object)0);
            formRight = (FormRight)((Object)((FormRightDao)this.baseMapper).selectOne((Wrapper)formKeyWrapper));
        }
        if (BeanUtils.isNotEmpty((Object)((Object)formRight))) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)formRight.getPermission());
            return rtnJson;
        }
        return null;
    }

    @Transactional
    public void removeByFormKeyType(String formKey, Integer type) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"form_key_", (Object)formKey)).eq((Object)"permission_type_", (Object)type)).nested(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.eq((Object)"flow_key_", (Object)"")).or()).isNull((Object)"flow_key_");
        });
        ((FormRightDao)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByDataKey(String dataKey, Integer type, String buttonId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"data_key_", (Object)dataKey)).eq((Object)"permission_type_", (Object)type);
        if (StringUtil.isNotEmpty((String)buttonId)) {
            FormRightButton formRightButton = this.formRightButtonManager.getByButtonId(buttonId, dataKey);
            if (BeanUtils.isNotEmpty((Object)((Object)formRightButton))) {
                this.formRightButtonManager.remove((Serializable)((Object)formRightButton.getId()));
                wrapper.eq((Object)"id_", (Object)formRightButton.getFormRightId());
            } else {
                return;
            }
        }
        ((FormRightDao)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public JsonNode getDefaultByExpand(String expand) throws IOException {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        List<Map<String, String>> lowList = this.convertMapLower(expand, null);
        JsonNode expandJson = JsonUtil.toJsonNode((String)expand);
        ArrayNode boDefList = (ArrayNode)expandJson.findValue("boDefList");
        ArrayList<BoDef> defList = new ArrayList<BoDef>();
        for (Object bodefNode : boDefList) {
            BoDef bodef = this.boDefManager.getByDefId(bodefNode.get("id").asText());
            if (!BeanUtils.isNotEmpty((Object)bodef)) continue;
            defList.add(bodef);
        }
        ArrayList<FormField> fieldList = new ArrayList<FormField>();
        if (BeanUtils.isNotEmpty(defList)) {
            for (BoDef boDef : defList) {
                String boDefId = boDef.getId();
                BoEnt mainEnt = boDef.getBoEnt();
                List mainAttr = mainEnt.getBoAttrList();
                if (!BeanUtils.isNotEmpty((Object)mainAttr)) continue;
                for (BoAttribute boAttribute : mainAttr) {
                    fieldList.add(this.createFields(boAttribute, mainEnt.getName(), boDefId));
                }
                List subEnts = mainEnt.getChildEntList();
                for (BoEnt subEnt : subEnts) {
                    List subAttr = subEnt.getBoAttrList();
                    for (BoAttribute subAttribute : subAttr) {
                        fieldList.add(this.createFields(subAttribute, subEnt.getName(), boDefId));
                    }
                    List sunEnts = subEnt.getChildEntList();
                    for (BoEnt sunEnt : sunEnts) {
                        List sunAttr = sunEnt.getBoAttrList();
                        for (BoAttribute sunAttribute : sunAttr) {
                            fieldList.add(this.createFields(sunAttribute, sunEnt.getName(), boDefId));
                        }
                    }
                }
            }
        }
        Map<String, List<FormField>> fieldMap = this.convertFormGroup(fieldList);
        ObjectNode tableJson = JsonUtil.getMapper().createObjectNode();
        for (Map<String, String> entMap : lowList) {
            JsonNode json = this.buildTable(entMap, fieldMap, false);
            if (json == null) continue;
            String entName = entMap.get("name_");
            tableJson.set(entName, json);
        }
        jsonObj.set("table", (JsonNode)tableJson);
        return jsonObj;
    }

    @Override
    public Map<String, Object> getPermission(FormRigthParam param) throws IOException {
        if (param.getType() == 1) {
            this.remove(param.getFormKey(), param.getFlowKey(), param.getNodeId(), param.getParentflowKey());
        }
        JsonNode json = this.getPermissionSetting(param);
        List<Map<String, String>> tableSn = this.getTableOrderBySn(param.getFormKey());
        int maxSn = tableSn.size();
        Iterator iterator = json.get("table").fields();
        while (iterator.hasNext()) {
            HashMap snMap;
            Map.Entry next = (Map.Entry)iterator.next();
            JsonNode tab = (JsonNode)next.getValue();
            if (tab.hasNonNull("ctrlType") && "formTable".equals(tab.get("ctrlType").asText())) {
                snMap = new HashMap();
                snMap.put("desc_", tab.get("description").asText());
                snMap.put("name_", next.getKey());
                snMap.put("type_", "onetoone");
                snMap.put("ctrlType", "formTable");
                snMap.put("sn_", String.valueOf(maxSn));
                ++maxSn;
                tableSn.add(snMap);
            }
            if (!tab.hasNonNull("ctrlType") || !"dataView".equals(tab.get("ctrlType").asText())) continue;
            snMap = new HashMap();
            snMap.put("desc_", tab.get("description").asText());
            snMap.put("name_", next.getKey());
            snMap.put("type_", "onetoone");
            snMap.put("ctrlType", "dataView");
            snMap.put("sn_", String.valueOf(maxSn));
            ++maxSn;
            tableSn.add(snMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("json", json);
        map.put("permissionList", AppUtil.getBean((String)"defaultObjectRightType"));
        map.put("tableSn", tableSn);
        return map;
    }

    @Override
    public Map<String, Object> getPermissionUpdateDesc(FormRigthParam param) throws IOException {
        boolean isReadOnly = param.getType() == 2 || param.getType() == 5;
        String formMetaKey = this.formMetaManager.getMetaKeyByFormKey(param.getFormKey());
        JsonNode defaultRight = this.getDefaultByFormDefKey(formMetaKey, isReadOnly);
        Map<String, Object> permissions = this.getPermission(param);
        if (permissions.get("json") != null && defaultRight != null) {
            JsonNode json = (JsonNode)permissions.get("json");
            this.updateDescriptions(json, defaultRight);
        }
        return permissions;
    }

    private void updateDescriptions(JsonNode jsonNode, JsonNode defaultJsonNode) {
        block4: {
            block3: {
                if (!jsonNode.isObject()) break block3;
                ObjectNode objectNode = (ObjectNode)jsonNode;
                Iterator fields = jsonNode.fields();
                while (fields.hasNext()) {
                    Map.Entry entry = (Map.Entry)fields.next();
                    String fieldName = (String)entry.getKey();
                    JsonNode subNode = (JsonNode)entry.getValue();
                    JsonNode defaultSubNode = defaultJsonNode.get(fieldName);
                    if (defaultSubNode == null || !defaultSubNode.isObject()) continue;
                    if (subNode.has("description") && defaultSubNode.has("description")) {
                        ((ObjectNode)subNode).put("description", defaultSubNode.get("description").asText());
                    }
                    this.updateDescriptions(subNode, defaultSubNode);
                }
                break block4;
            }
            if (!jsonNode.isArray()) break block4;
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode defaultSubNode;
                JsonNode subNode = jsonNode.get(i);
                JsonNode jsonNode2 = defaultSubNode = defaultJsonNode.size() > i ? defaultJsonNode.get(i) : null;
                if (defaultSubNode == null) continue;
                this.updateDescriptions(subNode, defaultSubNode);
            }
        }
    }

    @Override
    public void newSaveBath(List<FormRigthParam> list) {
        ArrayList<FormRight> saveList = new ArrayList<FormRight>();
        for (int i = 0; i < list.size(); ++i) {
            FormRigthParam param = list.get(i);
            if (StringUtil.isNotEmpty((String)param.getFlowKey())) {
                if (param.getType() == 1) {
                    this.remove(param.getFlowKey(), param.getNodeId(), param.getParentflowKey());
                } else {
                    this.removeInst(param.getFlowKey());
                }
            } else if (StringUtil.isEmpty((String)param.getDataKey())) {
                this.removeByFormKeyType(param.getFormKey(), param.getType());
            }
            if (StringUtil.isNotEmpty((String)param.getDataKey())) {
                this.removeByDataKey(param.getDataKey(), param.getType(), param.getButtonId());
            }
            String id = UniqueIdUtil.getSuid();
            FormRight right = new FormRight();
            right.setId(id);
            right.setFormKey(param.getFormKey());
            right.setFlowKey(param.getFlowKey());
            right.setNodeId(param.getNodeId());
            right.setParentFlowKey(param.getParentflowKey());
            right.setPermission(param.getPermission());
            right.setPermissionType(param.getType());
            right.setIsCheckOpinion(param.getIsCheckOpinion());
            right.setDataKey(param.getDataKey());
            saveList.add(right);
        }
        this.saveBatch(saveList);
    }

    private FormField createFields(BoAttribute boAttribute, String formId, String boDefId) throws JsonParseException, JsonMappingException, IOException {
        FormField formField = new FormField();
        formField.setId(UniqueIdUtil.getSuid());
        formField.setBoAttrId(boAttribute.getId());
        formField.setType(boAttribute.getDataType());
        formField.setEntName(formId);
        formField.setBoDefId(boDefId);
        formField.setName(boAttribute.getName());
        formField.setDesc(boAttribute.getDesc());
        formField.setSn(boAttribute.getSn());
        formField.setEntId(boAttribute.getEntId());
        return formField;
    }

    @Override
    public JsonNode getByFormKey(String formKey, int type, String dataKey) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFormKeyAndType(formKey, type, dataKey);
        JsonNode rtnJson = null;
        if (right != null) {
            return this.formRightPerm2Json(right, rtnJson);
        }
        return null;
    }

    @Override
    @Transactional
    public void updateFormRightNodeById(String formRightId, String nodeKey) {
        FormRight formRight = (FormRight)this.get((Serializable)((Object)formRightId));
        formRight.setNodeId(nodeKey);
        this.update((Model)formRight);
    }

    @Override
    public ArrayNode getByDataKey(String dataKey) throws IOException {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"data_key_", (Object)dataKey);
        List formRights = ((FormRightDao)this.baseMapper).selectList((Wrapper)wrapper);
        ArrayNode result = JsonUtil.getMapper().createArrayNode();
        if (CollectionUtils.isEmpty((Collection)formRights)) {
            return result;
        }
        for (FormRight right : formRights) {
            ObjectNode identityObj = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)right));
            result.add((JsonNode)identityObj);
        }
        return result;
    }

    @Override
    public JsonNode getMyApplyPermission(String formKey, String flowKey, String parentFlowKey, String nodeId) throws Exception {
        JsonNode json = null;
        if (StringUtil.isNotEmpty((String)flowKey)) {
            if (StringUtil.isNotEmpty((String)nodeId)) {
                json = this.getByFlowNodeId(flowKey, nodeId, parentFlowKey, formKey);
            }
            if (json == null) {
                json = this.getByInst(flowKey);
            }
            if (json == null) {
                json = this.getByFlowKey(flowKey, parentFlowKey, formKey);
            }
            if (json == null && StringUtil.isNotEmpty((String)parentFlowKey)) {
                json = this.getByFlowKey(parentFlowKey, "", formKey);
            }
        }
        if (json == null) {
            json = this.getByFormKey(formKey, true);
        }
        return this.calcFormPermission(json);
    }

    @Override
    public void removeByFlowKeys(String[] flowKeys) {
        if (BeanUtils.isEmpty((Object)flowKeys)) {
            return;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(FormRight::getFlowKey, Arrays.asList(flowKeys));
        ((FormRightDao)this.baseMapper).delete((Wrapper)wrapper);
    }
}

