/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExpressionUtil;
import com.hotent.base.util.FilterJsonStructUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.form.dto.FormDataVo;
import com.hotent.form.enums.FieldControlType;
import com.hotent.form.model.FormTemplate;
import com.hotent.form.model.QuerySqldef;
import com.hotent.form.model.QueryView;
import com.hotent.form.param.DataTemplateQueryVo;
import com.hotent.form.param.SelectParam;
import com.hotent.form.persistence.dao.QueryViewDao;
import com.hotent.form.persistence.manager.FormTemplateManager;
import com.hotent.form.persistence.manager.QuerySqldefManager;
import com.hotent.form.persistence.manager.QueryViewManager;
import com.hotent.form.util.FreeMakerUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.impl.util.PermissionCalc;
import com.hotent.uc.api.impl.var.IContextVar;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import poi.easypoi.util.ExcelUtils;
import poi.util.ExcelUtil;

@Service(value="queryViewManager")
public class QueryViewManagerImpl
extends BaseManagerImpl<QueryViewDao, QueryView>
implements QueryViewManager {
    private static final String LOGIN_USER = "loginUser";
    private static final String LOGIN_USER_ORGS = "loginUserOrgs";
    private static final String LOGIN_USER_SUB_ORGS = "loginUserSubOrgs";
    private static final String CUSTOM_ORGS = "customOrgs";
    @Resource
    QuerySqldefManager querySqldefManager;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource(name="formPermissionCalc")
    PermissionCalc permssionCalc;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    FormTemplateManager bpmFormTemplateManager;
    @Resource
    CommonManager commomManager;

    @Override
    public List<QueryView> getBySqlAlias(String sqlAlias) {
        return ((QueryViewDao)this.baseMapper).getBySqlAlias(sqlAlias);
    }

    @Override
    @Transactional
    public void removeBySqlAlias(String sqlAlias) {
        ((QueryViewDao)this.baseMapper).removeBySqlAlias(sqlAlias);
    }

    @Override
    public QueryView getBySqlAliasAndAlias(String sqlAlias, String alias) {
        return ((QueryViewDao)this.baseMapper).getBySqlAliasAndAlias(sqlAlias, alias);
    }

    @Override
    public QueryView getByAlias(String alias) {
        return ((QueryViewDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    public boolean listByAlias(String alias) {
        List<QueryView> queryViews = ((QueryViewDao)this.baseMapper).listByAlias(alias);
        return queryViews.size() <= 1;
    }

    @Override
    public String getShowSql(QueryView queryView, Map<String, Object> queryParams) throws Exception {
        if (queryView.getFilterType() == 2) {
            return this.executeScript(queryView.getFilter(), queryParams);
        }
        QuerySqldef querySqldef = this.querySqldefManager.getByAlias(queryView.getSqlAlias());
        return querySqldef.getSql();
    }

    @Override
    public String getFilterSql(String filterRelation, String filterField, String dsName, Map<String, Object> param) throws IOException {
        StringBuffer sb = new StringBuffer();
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        List<Map<String, String>> filters = this.getFilterPermission(filterField, curProfiles);
        ArrayNode jsonArray = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        ObjectNode json = JsonUtil.arrayToObject((ArrayNode)jsonArray, (String)"key");
        if (BeanUtils.isEmpty(filters)) {
            return sb.toString();
        }
        for (Map<String, String> map : filters) {
            String authConditions;
            String appendSql;
            String sqlTemp;
            String sql = "";
            ObjectNode jsonObject = (ObjectNode)json.get(map.get("filterKey"));
            String sqlReplace = JsonUtil.getString((JsonNode)jsonObject, (String)"diySql");
            if (StringUtil.isNotEmpty((String)sqlReplace)) {
                return this.executeScript(sqlReplace, param);
            }
            String condition = JsonUtil.getString((JsonNode)jsonObject, (String)"condition");
            if (StringUtil.isNotEmpty((String)condition)) {
                String dbType = this.databaseContext.getDbTypeByAlias(dsName);
                sqlTemp = FilterJsonStructUtil.getSql((String)condition, (String)dbType);
                sql = this.joinSql(sql, sqlTemp);
            }
            if (StringUtil.isNotEmpty((String)(appendSql = JsonUtil.getString((JsonNode)jsonObject, (String)"appendSql")))) {
                sqlTemp = this.executeScript(appendSql, param);
                sql = this.joinSql(sql, sqlTemp);
            }
            if (StringUtil.isNotEmpty((String)(authConditions = JsonUtil.getString((JsonNode)jsonObject, (String)"authConditions"))) && !"[]".equals(authConditions)) {
                sqlTemp = this.getDataPermissionSql(authConditions);
                sql = this.joinSql(sql, sqlTemp);
            }
            if (!StringUtil.isNotEmpty((String)sql)) continue;
            if (sb.length() > 0) {
                String relation = StringUtil.isEmpty((String)filterRelation) ? "or" : filterRelation;
                sb.append(" ").append(relation).append(" ");
            }
            sb.append(" (");
            sb.append(sql);
            sb.append(") ");
        }
        if (sb.length() > 0) {
            return " AND (" + sb.toString() + ")";
        }
        return sb.toString();
    }

    private String joinSql(String src, String dest) {
        if (StringUtil.isEmpty((String)dest)) {
            return src;
        }
        dest = "(" + dest + ")";
        if (StringUtil.isEmpty((String)src)) {
            return dest;
        }
        return src + " AND " + dest;
    }

    private List<Map<String, String>> getFilterPermission(String filterField, Map<String, Set<String>> curProfiles) throws IOException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (StringUtil.isEmpty((String)filterField)) {
            return list;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        for (Object obj : jsonAry) {
            JsonNode permission;
            ObjectNode json = (ObjectNode)obj;
            ArrayNode rights = json.get("right").isArray() ? (ArrayNode)json.get("right") : (ArrayNode)JsonUtil.toJsonNode((String)json.get("right").asText());
            boolean hasRight = false;
            Iterator iterator = rights.iterator();
            while (iterator.hasNext() && !(hasRight = this.permssionCalc.hasRight((permission = (JsonNode)iterator.next()).toString(), curProfiles))) {
            }
            if (!hasRight) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", JsonUtil.getString((JsonNode)json, (String)"name", (String)""));
            map.put("filterKey", JsonUtil.getString((JsonNode)json, (String)"key", (String)""));
            list.add(map);
        }
        return list;
    }

    @Override
    public String getDataPermissionSql(String dataPermission) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotEmpty((String)dataPermission)) {
            ArrayNode permissionArrayJson = (ArrayNode)JsonUtil.toJsonNode((String)dataPermission);
            HashSet<String> orgIds = new HashSet<String>();
            IUser currentUser = ContextUtil.getCurrentUser();
            for (JsonNode node : permissionArrayJson) {
                String inSql;
                HashSet<String> oidSet;
                Object oids;
                if (!BeanUtils.isNotEmpty((Object)node.get("field"))) continue;
                if (LOGIN_USER.equals(node.get("type").asText())) {
                    sb.append(" AND " + node.get("field").asText() + "='" + currentUser.getUserId() + "'");
                    continue;
                }
                if (LOGIN_USER_ORGS.equals(node.get("type").asText())) {
                    String currentUserOrgIds = currentUser.getAttrbuite("CURRENT_USER_ORGIDS");
                    if (!StringUtil.isNotEmpty((String)currentUserOrgIds)) continue;
                    oids = currentUserOrgIds.split(",");
                    oidSet = new HashSet<String>(Arrays.asList(oids));
                    inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(" AND " + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (LOGIN_USER_SUB_ORGS.equals(node.get("type").asText())) {
                    String currentUserSubOrgIds = AuthenticationUtil.getCurrentUserSubOrgIds();
                    if (!StringUtil.isNotEmpty((String)currentUserSubOrgIds)) continue;
                    oids = currentUserSubOrgIds.split(",");
                    oidSet = new HashSet<String>(Arrays.asList(oids));
                    inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(" AND " + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (!CUSTOM_ORGS.equals(node.get("type").asText())) continue;
                ArrayNode tmpArray = (ArrayNode)node.get("orgs");
                for (JsonNode tmpJsonNode : tmpArray) {
                    orgIds.add(tmpJsonNode.get("id").asText());
                }
                String inSql2 = StringUtil.convertListToSingleQuotesString(orgIds);
                sb.append(" AND " + node.get("field").asText() + " in (" + inSql2 + ")");
            }
        }
        if (sb.toString().startsWith(" AND")) {
            return sb.toString().substring(4);
        }
        return sb.toString();
    }

    @Override
    public void handleTemplate(QueryView queryView) throws Exception {
        FormTemplate template = this.bpmFormTemplateManager.getByTemplateAlias(queryView.getTemplateAlias());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayNode showsJA = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
        ArrayNode buttonsJA = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getButtons());
        ArrayList<ObjectNode> navButtons = new ArrayList<ObjectNode>();
        ArrayList<ObjectNode> rowButtons = new ArrayList<ObjectNode>();
        for (int i = 0; i < buttonsJA.size(); ++i) {
            ObjectNode temp = (ObjectNode)buttonsJA.get(i);
            if (JsonUtil.getString((JsonNode)temp, (String)"hidden", (String)"0").equals("1")) continue;
            if (JsonUtil.getString((JsonNode)temp, (String)"inRow", (String)"0").equals("0")) {
                navButtons.add(temp);
                continue;
            }
            rowButtons.add(temp);
        }
        boolean showSummary = false;
        String defSortField = "";
        String defSortSeq = "";
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        this.findFields(arrayNode, showsJA);
        for (int i = 0; i < arrayNode.size(); ++i) {
            ObjectNode temp = (ObjectNode)arrayNode.get(i);
            if (StringUtil.isEmpty((String)defSortField) && StringUtil.isEmpty((String)defSortSeq) && "1".equals(JsonUtil.getString((JsonNode)temp, (String)"defaultSort", (String)""))) {
                defSortField = JsonUtil.getString((JsonNode)temp, (String)"fieldName");
                defSortSeq = JsonUtil.getString((JsonNode)temp, (String)"sortSeq");
            }
            if (showSummary || !BeanUtils.isNotEmpty((Object)temp.get("summaryType")) || !"sum".equals(JsonUtil.getString((JsonNode)temp, (String)"summaryType", (String)""))) continue;
            showSummary = true;
        }
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        paramMap.put("util", freeMakerUtil);
        paramMap.put("queryView", (Object)queryView);
        paramMap.put("showMap", JsonUtil.arrayToObject((ArrayNode)arrayNode, (String)"fieldName"));
        paramMap.put("navButtons", navButtons);
        paramMap.put("rowButtons", rowButtons);
        paramMap.put("sortField", defSortField);
        paramMap.put("sortSeq", defSortSeq);
        paramMap.put("showSummary", showSummary);
        paramMap.put("isIndistinct", queryView.getIsIndistinct());
        paramMap.put("conditionAllName", queryView.getConditionAllName());
        paramMap.put("conditionAllDesc", "\u8bf7\u8f93\u5165\u5173\u952e\u5b57  " + queryView.getConditionAllDesc());
        paramMap.put("summarySetting", queryView.getSummarySetting());
        paramMap.put("summaryRegionHtml", queryView.getSummaryRegionHtml());
        String html = this.freemarkEngine.parseByStringTemplate(template.getHtml(), paramMap);
        queryView.setTemplate(html);
    }

    private void findFields(ArrayNode arrayNode, ArrayNode showsJA) {
        for (JsonNode jsonNode : showsJA) {
            if (jsonNode.has("children")) {
                if (!BeanUtils.isNotEmpty((Object)jsonNode.get("children"))) continue;
                this.findFields(arrayNode, (ArrayNode)jsonNode.get("children"));
                continue;
            }
            arrayNode.add(jsonNode);
        }
    }

    @Override
    public FormDataVo getShowData(String sqlAlias, String alias, DataTemplateQueryVo dataTemplateQueryVo, boolean getAll, boolean initSearch) throws Exception {
        QueryFilter queryFilter = dataTemplateQueryVo.getQueryFilter();
        FormDataVo resultData = new FormDataVo();
        QueryView queryView = this.getBySqlAliasAndAlias(sqlAlias, alias);
        QuerySqldef querySqldef = this.querySqldefManager.getByAlias(sqlAlias);
        if (BeanUtils.isNotEmpty(dataTemplateQueryVo.getSelectList())) {
            JsonNode jsonNode;
            List<SelectParam> selectList = dataTemplateQueryVo.getSelectList();
            String conditions = queryView.getConditions();
            if (StringUtil.isNotEmpty((String)conditions) && BeanUtils.isNotEmpty((Object)(jsonNode = JsonUtil.toJsonNode((String)conditions)))) {
                HashMap conditionsMap = Maps.newHashMap();
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                arrayNode.forEach(item -> {
                    if (item.get("name") != null) {
                        conditionsMap.put(item.get("name").asText(), item);
                    }
                });
                for (SelectParam param : selectList) {
                    if (StringUtil.isEmpty((String)param.getSelectValue()) || !conditionsMap.containsKey(param.getBindSelectd())) continue;
                    JsonNode conditionNode = (JsonNode)conditionsMap.get(param.getBindSelectd());
                    String fieldName = JsonUtil.getString((JsonNode)conditionNode, (String)"fieldName", (String)"");
                    String operate = JsonUtil.getString((JsonNode)conditionNode, (String)"operate", (String)"");
                    if (!StringUtil.isNotEmpty((String)fieldName) || !StringUtil.isNotEmpty((String)operate)) continue;
                    queryFilter.addFilter(fieldName, (Object)param.getSelectValue(), QueryOP.getByVal((String)operate));
                }
            }
        }
        Map queryParams = queryFilter.getParams();
        String dbType = SQLUtil.getDbType();
        if (!queryFilter.getQuerys().isEmpty()) {
            ArrayList<Date> newVal;
            ArrayList value;
            String dataType;
            JsonNode cdt = JsonUtil.toJsonNode((String)queryView.getConditions());
            if (BeanUtils.isNotEmpty((Object)cdt)) {
                String[] split = cdt.get(0).get("name").asText().split("\\.");
                if (BeanUtils.isNotEmpty((Object)split) && split.length == 2) {
                    String tableName = "";
                    List list = queryFilter.getQuerys();
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        QueryField qd = (QueryField)list.get(i);
                        String queryCriteria = qd.getProperty();
                        for (JsonNode jsonNode : cdt) {
                            String name = jsonNode.get("name").asText().replace(".", "_");
                            if (!name.equals(queryCriteria)) continue;
                            String[] splitName = jsonNode.get("name").asText().split("\\.");
                            tableName = splitName[0];
                            String table = queryCriteria.substring(0, tableName.length());
                            String fieldName = queryCriteria.substring(tableName.length() + 1, queryCriteria.length());
                            qd.setProperty(table + "." + fieldName);
                            break;
                        }
                        if (!QueryOP.NOT_EQUAL.equals((Object)qd.getOperation()) || !BeanUtils.isNotEmpty((Object)qd.getValue())) continue;
                        qd.setGroup(qd.getProperty());
                        QueryField qf = new QueryField();
                        BeanUtils.copyNotNullProperties((Object)qf, (Object)qd);
                        qf.setOperation(QueryOP.IS_NULL);
                        qf.setRelation(FieldRelation.OR);
                        queryFilter.getQuerys().add(qf);
                    }
                }
                this.convertQueryFieldValue(queryFilter.getQuerys(), cdt);
            }
            if ("oracle".equals(dbType)) {
                for (JsonNode jsonNode : cdt) {
                    dataType = jsonNode.get("dataType").asText();
                    if (FieldControlType.DATE.key.equals(dataType)) {
                        String name = JsonUtil.getString((JsonNode)jsonNode, (String)"name", (String)"");
                        for (QueryField query : queryFilter.getQuerys()) {
                            if (!query.getProperty().equals(name)) continue;
                            if (QueryOP.BETWEEN.equals((Object)query.getOperation()) && query.getValue().getClass() == ArrayList.class) {
                                value = (ArrayList)query.getValue();
                                newVal = new ArrayList<Date>();
                                for (int i = 0; i < value.size(); ++i) {
                                    if (StringUtil.isNotEmpty((String)((String)value.get(i)))) {
                                        if (DateUtil.isRqFormat((String)((String)value.get(i)))) {
                                            newVal.add(DateFormatUtil.parseDate((String)((String)value.get(i)), (String)"yyyy-MM-dd"));
                                            continue;
                                        }
                                        if (!DateUtil.isRqSjFormat((String)((String)value.get(i)))) continue;
                                        newVal.add(DateFormatUtil.parseDate((String)((String)value.get(i)), (String)"yyyy-MM-dd HH:mm:ss"));
                                        continue;
                                    }
                                    newVal.add(null);
                                }
                                if (newVal.size() < 2) {
                                    query.setProperty("TO_CHAR(" + query.getProperty() + ") ");
                                    query.setOperation(QueryOP.EQUAL);
                                    query.setValue((Object)"1");
                                    continue;
                                }
                                query.setValue(newVal);
                                continue;
                            }
                            if (!StringUtil.isNotEmpty((String)((String)query.getValue()))) continue;
                            if (DateUtil.isRqFormat((String)((String)query.getValue()))) {
                                query.setValue((Object)DateFormatUtil.parseDate((String)((String)query.getValue()), (String)"yyyy-MM-dd"));
                                continue;
                            }
                            if (DateUtil.isRqSjFormat((String)((String)query.getValue()))) {
                                query.setValue((Object)DateFormatUtil.parseDate((String)((String)query.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                                continue;
                            }
                            query.setProperty("TO_CHAR(" + query.getProperty() + ") ");
                            query.setOperation(QueryOP.EQUAL);
                            query.setValue((Object)"1");
                        }
                    }
                    if (!"clob".equals(dataType)) continue;
                    String name = jsonNode.get("name").asText();
                    for (QueryField query : queryFilter.getQuerys()) {
                        if (!query.getProperty().equals(name)) continue;
                        query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                    }
                }
            } else if ("dm".equals(dbType)) {
                for (JsonNode node : cdt) {
                    dataType = node.get("dataType").asText();
                    if (!"clob".equals(dataType)) continue;
                    for (QueryField query : queryFilter.getQuerys()) {
                        if (!query.getProperty().equals(JsonUtil.getString((JsonNode)node, (String)"name", (String)""))) continue;
                        query.setProperty("TO_CHAR(" + query.getProperty() + ") ");
                    }
                }
            } else if ("postgresql".equals(dbType)) {
                for (JsonNode jsonNode : cdt) {
                    dataType = jsonNode.get("dataType").asText();
                    if (!FieldControlType.DATE.key.equals(dataType)) continue;
                    String name = JsonUtil.getString((JsonNode)jsonNode, (String)"name", (String)"");
                    for (QueryField query : queryFilter.getQuerys()) {
                        if (!query.getProperty().equals(name)) continue;
                        if (QueryOP.BETWEEN.equals((Object)query.getOperation()) && query.getValue().getClass() == ArrayList.class) {
                            value = (ArrayList)query.getValue();
                            newVal = new ArrayList();
                            for (int i = 0; i < value.size(); ++i) {
                                if (StringUtil.isNotEmpty((String)((String)value.get(i)))) {
                                    if (DateUtil.isRqFormat((String)((String)value.get(i)))) {
                                        newVal.add(DateFormatUtil.parseDate((String)((String)value.get(i)), (String)"yyyy-MM-dd"));
                                        continue;
                                    }
                                    if (!DateUtil.isRqSjFormat((String)((String)value.get(i)))) continue;
                                    newVal.add(DateFormatUtil.parseDate((String)((String)value.get(i)), (String)"yyyy-MM-dd HH:mm:ss"));
                                    continue;
                                }
                                newVal.add(null);
                            }
                            continue;
                        }
                        if (!StringUtil.isNotEmpty((String)((String)query.getValue()))) continue;
                        if (DateUtil.isRqFormat((String)((String)query.getValue()))) {
                            query.setValue((Object)DateFormatUtil.parseDate((String)((String)query.getValue()), (String)"yyyy-MM-dd"));
                            continue;
                        }
                        if (!DateUtil.isRqSjFormat((String)((String)query.getValue()))) continue;
                        query.setValue((Object)DateFormatUtil.parseDate((String)((String)query.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                }
            }
        }
        if (initSearch) {
            PageList pageList;
            String showSql = "";
            String sql = this.getShowSql(queryView, queryParams);
            HashMap<String, String> caseStmMap = new HashMap<String, String>();
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)SQLUtils.parseSingleStatement((String)sql, (String)dbType, (SQLParserFeature[])new SQLParserFeature[0]);
            SQLSelectQueryBlock queryBlock = sqlSelectStatement.getSelect().getQueryBlock();
            for (SQLSelectItem sqlSelectItem : queryBlock.getSelectList()) {
                SQLExpr expr = sqlSelectItem.getExpr();
                if (!(expr instanceof SQLCaseExpr) && !(expr instanceof SQLAggregateExpr)) continue;
                String caseAlias = sqlSelectItem.getAlias();
                if (StringUtil.isNotEmpty((String)caseAlias)) {
                    caseStmMap.put(caseAlias.toUpperCase(), sqlSelectItem.toString());
                    continue;
                }
                caseStmMap.put(expr.toString().toUpperCase(), sqlSelectItem.toString());
            }
            if (StringUtil.isNotEmpty((String)queryView.getShows())) {
                ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
                ArrayNode shows = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
                this.findFields(arrayNode, shows);
                for (int i = 0; i < arrayNode.size(); ++i) {
                    String name = arrayNode.get(i).get("name").toString();
                    String nameUpper = arrayNode.get(i).get("name").asText().toUpperCase();
                    String expr = caseStmMap.getOrDefault(nameUpper, name);
                    showSql = name.contains(".") ? showSql + expr + " as " + arrayNode.get(i).get("fieldName") + "," : showSql + expr + ",";
                }
                if (showSql.length() > 0) {
                    showSql = showSql.substring(0, showSql.length() - 1);
                }
            }
            if (StringUtil.isNotEmpty((String)showSql)) {
                if (sql.split("from").length > 1) {
                    int indexOf = sql.indexOf("from");
                    if (indexOf != -1) {
                        sql = "select " + showSql.replaceAll("\"", "") + " " + sql.substring(indexOf);
                    }
                } else {
                    int indexOf = sql.indexOf("FROM");
                    if (indexOf != -1) {
                        sql = "SELECT " + showSql.replaceAll("\"", "") + " " + sql.substring(indexOf);
                    }
                }
            }
            if (StringUtil.isNotEmpty((String)queryView.getShows())) {
                List sorter = queryFilter.getSorter();
                HashSet<String> frontSortAttr = new HashSet<String>();
                for (FieldSort fieldSort : sorter) {
                    frontSortAttr.add(fieldSort.getProperty());
                }
                ArrayNode jsonNode = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
                for (JsonNode obj : jsonNode) {
                    ObjectNode objectNode = (ObjectNode)obj;
                    if (!objectNode.hasNonNull("defaultSort") || 1 != objectNode.get("defaultSort").asInt() || frontSortAttr.contains(objectNode.get("name").asText()) || !objectNode.hasNonNull("sortSeq") || !StringUtil.isNotEmpty((String)objectNode.get("sortSeq").asText())) continue;
                    sorter.add(new FieldSort(objectNode.get("name").asText(), Direction.fromString((String)objectNode.get("sortSeq").asText().toUpperCase())));
                }
            }
            String filterSql = this.getFilterSql(queryView.getFilterRelation(), queryView.getFilter(), querySqldef.getDsName(), queryParams);
            queryFilter.withParam("filterSql", (Object)filterSql);
            try {
                AtomicReference<PageList> pageListTemp = new AtomicReference<PageList>(new PageList());
                String finalSql = this.postHandleSql(sql, queryFilter, queryView);
                pageList = (PageList)this.databaseContext.switchDS(querySqldef.getDsName(), () -> {
                    if (queryView.getNeedPage() == 0 || getAll) {
                        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
                    }
                    pageListTemp.set(this.commomManager.queryByCustomSql(finalSql, queryFilter));
                    if (StringUtil.isNotEmpty((String)queryView.getSummarySetting())) {
                        JsonNode summaryFieldNode = null;
                        try {
                            summaryFieldNode = JsonUtil.toJsonNode((String)queryView.getSummarySetting());
                        }
                        catch (IOException e2) {
                            throw new BaseException(e2.getMessage(), (Throwable)e2);
                        }
                        if (summaryFieldNode.size() > 0) {
                            ArrayList counterList = Lists.newArrayList();
                            ArrayList otherList = Lists.newArrayList();
                            for (JsonNode item : summaryFieldNode) {
                                if (item.get("whetherSummarize") == null || !item.get("whetherSummarize").asBoolean()) continue;
                                String method = item.get("method").asText();
                                if ("count".equals(method)) {
                                    counterList.add(item);
                                    continue;
                                }
                                otherList.add(item);
                            }
                            if (BeanUtils.isNotEmpty((Object)counterList) || BeanUtils.isNotEmpty((Object)otherList)) {
                                HashMap queryResult = Maps.newHashMap();
                                String replace = finalSql.replace("\r\n", " ").replace("\r", " ").replace("\n", " ");
                                int i = replace.toLowerCase().indexOf(String.format(" from ", new Object[0]));
                                JsonNode finalSummaryFieldNode = summaryFieldNode;
                                this.databaseContext.switchDS(querySqldef.getDsName(), dResult -> {
                                    try {
                                        String summaryotherSql;
                                        Map queryMap;
                                        QueryFilter build = QueryFilter.build();
                                        BeanUtils.copyNotNullProperties((Object)build, (Object)queryFilter);
                                        build.setSorter((List)Lists.newArrayList());
                                        if (StringUtil.isNotEmpty((String)filterSql)) {
                                            build.addParams(filterSql, null);
                                        }
                                        build.withParam("filterSql", (Object)filterSql);
                                        for (JsonNode item : counterList) {
                                            Object queryField;
                                            String field = item.get("field").asText();
                                            QueryFilter buildCounter = QueryFilter.build();
                                            BeanUtils.copyNotNullProperties((Object)buildCounter, (Object)queryFilter);
                                            ArrayList<Object> querys = new ArrayList<Object>();
                                            if ("oracle".equals(dResult.getDbType()) || "kingbasees".equals(dResult.getDbType()) || "dm".equals(dResult.getDbType())) {
                                                queryField = new QueryField();
                                                queryField.setProperty("length(" + field + ")");
                                                queryField.setValue((Object)0);
                                                queryField.setOperation(QueryOP.GREAT);
                                                querys.add(queryField);
                                            } else {
                                                queryField = new QueryField();
                                                queryField.setProperty(field);
                                                queryField.setValue((Object)"");
                                                queryField.setOperation(QueryOP.NOT_EQUAL);
                                                querys.add(queryField);
                                            }
                                            for (Object query : queryFilter.getQuerys()) {
                                                querys.add(query);
                                            }
                                            buildCounter.setQuerys(querys);
                                            String summaryCounterSql = this.buildSummarySql(counterList, queryView.getShows()) + replace.substring(i);
                                            try {
                                                Map queryMap2 = (Map)this.commomManager.queryByCustomSqlNoPage(summaryCounterSql, buildCounter).get(0);
                                                if (!BeanUtils.isNotEmpty((Object)queryMap2)) continue;
                                                queryResult.putAll(queryMap2);
                                            }
                                            catch (Exception e) {
                                                Map queryMap3 = (Map)this.commomManager.queryByCustomSqlNoPage(summaryCounterSql, build).get(0);
                                                if (!BeanUtils.isNotEmpty((Object)queryMap3)) continue;
                                                queryResult.putAll(queryMap3);
                                            }
                                        }
                                        if (BeanUtils.isNotEmpty((Object)otherList) && BeanUtils.isNotEmpty((Object)(queryMap = (Map)this.commomManager.queryByCustomSqlNoPage(summaryotherSql = this.buildSummarySql(otherList, queryView.getShows()) + replace.substring(i), build).get(0)))) {
                                            queryResult.putAll(queryMap);
                                        }
                                        ArrayList summary = Lists.newArrayList();
                                        finalSummaryFieldNode.forEach(node -> {
                                            if (node.get("whetherSummarize") == null || !node.get("whetherSummarize").asBoolean()) {
                                                return;
                                            }
                                            HashMap summaryResult = Maps.newHashMap();
                                            String field = node.get("field").asText();
                                            String method = node.get("method").asText();
                                            summaryResult.put("field", field);
                                            summaryResult.put("method", method);
                                            summaryResult.put("val", "-");
                                            if (queryResult != null) {
                                                Object value = MapUtil.getIgnoreCase((Map)queryResult, (String)(method + "_" + field), null);
                                                if (node.get("decimal") != null && node.get("decimal").isInt() && BeanUtils.isNotEmpty((Object)value)) {
                                                    int decimal = node.get("decimal").asInt(0);
                                                    value = new BigDecimal(value.toString()).setScale(decimal, 4).toString();
                                                }
                                                summaryResult.put("val", value);
                                            }
                                            summary.add(summaryResult);
                                        });
                                        if (BeanUtils.isNotEmpty((Object)summary)) {
                                            resultData.setSummary(summary);
                                        }
                                    }
                                    catch (Exception e) {
                                        throw new BaseException(e.getMessage(), (Throwable)e);
                                    }
                                    return null;
                                }, e -> {
                                    throw new BaseException(e.getMessage(), (Throwable)e);
                                });
                            }
                        }
                    }
                    return (PageList)pageListTemp.get();
                });
            }
            catch (Exception e) {
                throw new BaseException("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01", (Throwable)e);
            }
            this.handleShowData(queryView, pageList.getRows(), querySqldef.getDsName());
            resultData.setRows(pageList.getRows());
            resultData.setPageSize(pageList.getPageSize());
            resultData.setPage(pageList.getPage());
            resultData.setTotal(pageList.getTotal());
        }
        return resultData;
    }

    private String postHandleSql(String sql, QueryFilter<?> filter, QueryView queryView) throws IOException {
        HashMap vars = new HashMap(16);
        filter.getQuerys().forEach(queryField -> {
            String property = this.parseProperty(queryField.getProperty());
            vars.put(property, queryField.getValue());
        });
        this.clearQueryFilter(queryView, filter);
        return ExpressionUtil.format((String)sql, vars);
    }

    private void clearQueryFilter(QueryView queryView, QueryFilter<?> filter) throws IOException {
        String conditions = queryView.getConditions();
        ArrayNode conditionFields = (ArrayNode)JsonUtil.toJsonNode((String)conditions);
        for (JsonNode conditionField : conditionFields) {
            int userScope = JsonUtil.getInt((JsonNode)conditionField, (String)"useScope", (int)1);
            if (userScope != 2) continue;
            String field = JsonUtil.getString((JsonNode)conditionField, (String)"fieldName");
            filter.getQuerys().removeIf(queryField -> {
                String property = this.parseProperty(queryField.getProperty());
                return property.equals(field);
            });
        }
    }

    private String parseProperty(String propertyDot) {
        if (StringUtil.isEmpty((String)propertyDot)) {
            return propertyDot;
        }
        return propertyDot.replace(".", "_");
    }

    private void convertQueryFieldValue(List<QueryField> queryFieldList, JsonNode cdt) {
        block0: for (QueryField queryField : queryFieldList) {
            for (JsonNode jsonNode : cdt) {
                String name = jsonNode.get("name").asText().replace(".", "_");
                if (!name.equals(queryField.getProperty())) continue;
                String dataType = jsonNode.get("dataType").asText();
                if (!"number".equals(dataType) || !BeanUtils.isNumber((Object)queryField.getValue())) continue block0;
                queryField.setValue((Object)new BigDecimal(String.valueOf(queryField.getValue())));
                continue block0;
            }
        }
    }

    private String buildSummarySql(List<JsonNode> summaryFieldNode, String displayField) throws IOException {
        StringBuilder sqlBuider = new StringBuilder("select ");
        HashSet selectColumnSet = Sets.newHashSet();
        JsonNode displayFieldNode = JsonUtil.toJsonNode((String)displayField);
        Map<String, String> column = this.getColumn(displayFieldNode, Maps.newHashMap());
        summaryFieldNode.forEach(item -> {
            if (item.get("whetherSummarize") == null || !item.get("whetherSummarize").asBoolean()) {
                return;
            }
            String field = item.get("field").asText();
            String method = item.get("method").asText();
            selectColumnSet.add(method + "(" + (String)column.get(field) + ") as " + method + "_" + field + ",");
        });
        selectColumnSet.forEach(item -> sqlBuider.append(item));
        sqlBuider.deleteCharAt(sqlBuider.length() - 1);
        return sqlBuider.toString();
    }

    private Map<String, String> getColumn(JsonNode displayFieldNode, HashMap<String, String> column) {
        for (JsonNode jsonNode : displayFieldNode) {
            JsonNode children = jsonNode.get("children");
            if (BeanUtils.isNotEmpty((Object)children) && children.isArray()) {
                this.getColumn(children, column);
                continue;
            }
            if (!BeanUtils.isNotEmpty((Object)jsonNode.get("name"))) continue;
            column.put(jsonNode.get("fieldName").asText(), jsonNode.get("name").asText());
        }
        return column;
    }

    @Override
    public QueryView getJson(Optional<String> id, Optional<String> sqlAlias, Optional<String> alias) {
        String id_ = id.orElse("");
        String sqlAlias_ = sqlAlias.orElse("");
        String alias_ = alias.orElse("");
        QueryView queryView = null;
        if (StringUtil.isNotEmpty((String)id_)) {
            queryView = (QueryView)this.get((Serializable)((Object)id_));
        } else if (StringUtil.isNotEmpty((String)sqlAlias_) && StringUtil.isNotEmpty((String)alias_)) {
            queryView = this.getBySqlAliasAndAlias(sqlAlias_, alias_);
        }
        if (queryView != null) {
            try {
                queryView.setFilter(this.parseFilter(queryView.getFilter()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queryView;
    }

    private String parseFilter(String oldFilter) throws Exception {
        JsonNode node = JsonUtil.toJsonNode((String)oldFilter);
        if (!(node instanceof ArrayNode)) {
            return oldFilter;
        }
        ArrayNode arrFilter = (ArrayNode)node;
        arrFilter.forEach(filter -> {
            ObjectNode item = (ObjectNode)filter;
            if (item.has("appendSql")) {
                return;
            }
            if (!item.has("condition")) {
                this.updateOneFilter(item, null, null, null, null);
                return;
            }
            int type = JsonUtil.getInt((JsonNode)item, (String)"type", (int)0);
            JsonNode nodeConditionOld = item.get("condition");
            String conditionOld = JsonUtil.getString((JsonNode)item, (String)"condition");
            switch (type) {
                case 1: {
                    this.updateOneFilter(item, nodeConditionOld, null, null, null);
                    break;
                }
                case 2: {
                    this.updateOneFilter(item, null, conditionOld, null, null);
                    break;
                }
                case 3: {
                    this.updateOneFilter(item, null, null, conditionOld, null);
                    break;
                }
                case 4: {
                    this.updateOneFilter(item, null, null, null, nodeConditionOld);
                }
            }
        });
        return JsonUtil.toJsonString((Object)arrFilter);
    }

    private void updateOneFilter(ObjectNode item, JsonNode nodeCondition, String diySql, String appendSql, JsonNode authConditions) {
        if (StringUtil.isEmpty((String)appendSql)) {
            appendSql = "";
        }
        if (StringUtil.isEmpty((String)diySql)) {
            diySql = "";
        }
        item.set("condition", (JsonNode)(nodeCondition == null ? JsonUtil.createArrayNode() : nodeCondition));
        item.put("diySql", diySql);
        item.put("appendSql", appendSql);
        item.put("authConditions", (JsonNode)(authConditions == null ? JsonUtil.createArrayNode() : authConditions));
    }

    @Override
    public CommonResult<String> saveQueryView(QueryView queryView) throws Exception {
        String resultMsg = null;
        String id = queryView.getId();
        QueryView byAlias = this.getByAlias(queryView.getAlias());
        if (queryView.getRebuildTemp() == 1) {
            this.handleTemplate(queryView);
        }
        if (StringUtil.isEmpty((String)id)) {
            if (byAlias != null) {
                return new CommonResult(false, queryView.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01");
            }
            queryView.setId(UniqueIdUtil.getSuid());
            this.create((Model)queryView);
            resultMsg = "\u6dfb\u52a0\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u6210\u529f";
        } else {
            if (byAlias != null && !byAlias.getId().equals(queryView.getId())) {
                return new CommonResult(false, queryView.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01");
            }
            this.update((Model)queryView);
            resultMsg = "\u66f4\u65b0\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u6210\u529f";
        }
        return new CommonResult(true, resultMsg);
    }

    private String executeScript(String script, Map<String, Object> param) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("param", param);
        vars.putAll(param);
        String str = this.groovyScriptEngine.executeString(this.replaceVar(script), vars);
        return str;
    }

    private String replaceVar(String str) {
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        for (IContextVar c : comVarList) {
            str = str.replace("[" + c.getAlias() + "]", c.getValue());
        }
        return "return \"" + str + "\" ;";
    }

    public void handleShowData(QueryView queryView, List list, String dsName) throws IOException {
        ArrayNode showJA = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        this.findFields(arrayNode, showJA);
        HashMap<String, Map<String, Object>> cacheMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (int j = 0; j < arrayNode.size(); ++j) {
                ObjectNode jo = (ObjectNode)arrayNode.get(j);
                String fieldName = jo.get("fieldName").asText();
                if (BeanUtils.isNotEmpty((Object)MapUtil.getIgnoreCase((Map)map, (String)fieldName, (Object)""))) {
                    tmp.put(fieldName, MapUtil.getIgnoreCase((Map)map, (String)fieldName, (Object)"").toString());
                } else {
                    tmp.put(fieldName, "");
                }
                if (JsonUtil.getString((JsonNode)jo, (String)"isVirtual", (String)"0").equals("0")) continue;
                String con = MapUtil.getIgnoreCase((Map)map, (String)jo.get("virtualFrom").asText()) + "";
                String str = jo.get("resultFrom").asText().replace("#CON#", con);
                Object val = this.getValFromCache(cacheMap, fieldName, con);
                if (BeanUtils.isEmpty((Object)val)) {
                    if (jo.get("resultFromType").asText().equals("script")) {
                        val = this.groovyScriptEngine.executeString(str, new HashMap());
                    } else if (jo.get("resultFromType").asText().equals("sql")) {
                        try {
                            Map m = (Map)this.databaseContext.switchDS(dsName, () -> this.jdbcTemplate.queryForMap(str));
                            Iterator iterator = m.keySet().iterator();
                            if (iterator.hasNext()) {
                                String k = (String)iterator.next();
                                val = m.get(k);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            val = "";
                        }
                    }
                    this.putValToCache(cacheMap, fieldName, con, val);
                }
                tmp.put(fieldName, val.toString());
            }
            list.set(i, tmp);
        }
    }

    private Object getValFromCache(Map<String, Map<String, Object>> cacheMap, String fieldName, String key) {
        Map<String, Object> map = cacheMap.get(fieldName);
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        return map.get(key);
    }

    private void putValToCache(Map<String, Map<String, Object>> cacheMap, String fieldName, String key, Object val) {
        Map<String, Object> map = cacheMap.get(fieldName);
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, Object>();
            cacheMap.put(fieldName, map);
        }
        map.put(key, val);
    }

    @Override
    public PageList<Map<String, Object>> getAuthDetailPage(QueryFilter<QueryView> queryFilter) {
        JsonNode user;
        String account;
        String id = queryFilter.getParams().get("id").toString();
        if (StringUtil.isNotEmpty((String)id) && "admin".equals(account = JsonUtil.getString((JsonNode)(user = (JsonNode)((UCFeignService)AppUtil.getBean(UCFeignService.class)).getUserById(id).getValue()), (String)"account"))) {
            id = JsonUtil.getString((JsonNode)user, (String)"fullname");
        }
        FieldSort fieldSort = new FieldSort("NAME_");
        queryFilter.setSorter(Collections.singletonList(fieldSort));
        PageList pageList = new PageList(((QueryViewDao)this.baseMapper).getAuthDetailPage(id, (IPage<QueryView>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<QueryView>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
        List rows = pageList.getRows();
        if (SQLUtil.getDbType().equals("oracle")) {
            rows.stream().forEach(map -> {
                try {
                    map.put("FILTER_", SQLUtil.ClobToString((Clob)((Clob)map.get("FILTER_"))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return pageList;
    }

    @Override
    public CommonResult<String> copeOrTransferAuth(List<Map<String, String>> list) {
        boolean b;
        ArrayList<QueryView> queryViewUpdateList = new ArrayList<QueryView>();
        List aliasList = list.stream().map(map -> (String)map.get("VIEW_ALIAS_")).collect(Collectors.toList());
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ALIAS_", aliasList, QueryOP.IN);
        List queryViewList = this.queryNoPage(queryFilter);
        for (Map<String, String> map2 : list) {
            String alias = map2.get("VIEW_ALIAS_");
            List queryViews = queryViewList.stream().filter(queryView -> queryView.getAlias().equals(alias)).collect(Collectors.toList());
            if (!BeanUtils.isNotEmpty(queryViews) || !map2.containsKey("FILTER_")) continue;
            QueryView queryView2 = (QueryView)((Object)queryViews.get(0));
            queryView2.setFilter(map2.get("FILTER_"));
            queryViewUpdateList.add(queryView2);
        }
        return new CommonResult(b, (b = this.updateBatchById(queryViewUpdateList)) ? "\u4fee\u6539\u6210\u529f" : "\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public List<QueryView> getByIds(String[] ids) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(QueryView::getId, Arrays.asList(ids));
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void exportAuthDetail(QueryFilter<QueryView> queryFilter, HttpServletResponse httpServletResponse) throws Exception {
        String filename = "";
        long start = System.currentTimeMillis();
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if (BeanUtils.isNotEmpty((Object)queryFilter.getParams())) {
            if (queryFilter.getParams().containsKey("ids") && BeanUtils.isNotEmpty(queryFilter.getParams().get("ids"))) {
                queryFilter.setQuerys(new ArrayList());
                queryFilter.withQuery(new QueryField("id_", queryFilter.getParams().get("ids"), QueryOP.IN));
            }
            if (queryFilter.getParams().containsKey("titlePre") && queryFilter.getParams().get("titlePre") != null) {
                filename = filename + String.valueOf(queryFilter.getParams().get("titlePre"));
            }
        }
        filename = filename + "_\u6570\u636e\u5217\u8868_" + String.valueOf(start);
        PageList<Map<String, Object>> authDetailPage = this.getAuthDetailPage(queryFilter);
        for (Map row : authDetailPage.getRows()) {
            row.put("AUTH_TYPE_DESC_", "\u6570\u636e\u6743\u9650");
            String field = String.valueOf(row.get("FILTER_"));
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)field);
            if (!BeanUtils.isNotEmpty((Object)arrayNode)) continue;
            row.put("AUTH_DETAIL_", JsonUtil.getString((JsonNode)arrayNode.get(arrayNode.size() - 1), (String)"name", (String)""));
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("NAME_", "\u5217\u8868\u540d\u79f0");
        map.put("ALIAS_", "\u5217\u8868\u522b\u540d");
        map.put("VIEW_NAME_", "\u89c6\u56fe\u540d\u79f0");
        map.put("AUTH_TYPE_DESC_", "\u6388\u6743\u7c7b\u578b");
        map.put("AUTH_DETAIL_", "\u6388\u6743\u660e\u7ec6");
        Workbook sheets = ExcelUtils.exportExcel((String)filename, map, (List)authDetailPage.getRows());
        ExcelUtil.downloadExcel((Workbook)sheets, (String)filename, (HttpServletResponse)httpServletResponse);
    }

    @Override
    public PageList<QueryView> queryAll(QueryFilter<QueryView> queryFilter) {
        IPage<QueryView> queryViewIPage = ((QueryViewDao)this.baseMapper).queryAll((IPage<QueryView>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<QueryView>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(queryViewIPage);
    }
}

