/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.form.enums.ComponentType;
import com.hotent.form.model.CustomDialog;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.form.service.FormComponentIOService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DialogIOService
implements FormComponentIOService {
    private static final String GROUP_KEY = "DIALOG_TYPE";
    private static final String TYPE_KEY = "default";
    @Resource
    CustomDialogManager customDialogManager;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public ComponentType getType() {
        return ComponentType.DIALOG;
    }

    @Override
    public String getAlias(ObjectNode options) {
        return JsonUtil.getStrByPath((JsonNode)options, (String)"customDialogjson.custDialog.alias", jsonNode -> {});
    }

    @Override
    public Map<String, String> getExportContent(String ... alias) throws Exception {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(CustomDialog::getAlias, Arrays.asList(alias));
        List customDialogs = this.customDialogManager.list((Wrapper)wrapper);
        return this.handleExportContent(customDialogs);
    }

    @Override
    public List<ImportCheckResult> importCheck(Map<String, String> map) throws IOException {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return results;
        }
        List customDialogs = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomDialog>>(){});
        this.customDialogManager.importCheck(customDialogs, customDialog -> results.add(new ImportCheckResult(true, "\u5bf9\u8bdd\u6846", customDialog.getName())));
        return results;
    }

    @Override
    public void importData(Map<String, String> map, String status) throws IOException {
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return;
        }
        List customDialogs = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomDialog>>(){});
        ObjectNode sysTypeByType = this.portalFeignService.getSysTypeByType(GROUP_KEY, TYPE_KEY);
        if (BeanUtils.isEmpty((Object)sysTypeByType)) {
            throw new BaseException("\u5bf9\u8bdd\u6846\u4e0d\u5b58\u5728\u9ed8\u8ba4\u5206\u7c7b");
        }
        this.customDialogManager.importData(customDialogs, status, JsonUtil.getString((JsonNode)sysTypeByType, (String)"id"), true);
    }
}

