/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.form.enums.ComponentType;
import com.hotent.form.service.FormComponentIOService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TagIOService
implements FormComponentIOService {
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public ComponentType getType() {
        return ComponentType.TAG;
    }

    @Override
    public String getAlias(ObjectNode options) {
        return JsonUtil.getString((JsonNode)options, (String)"tag");
    }

    @Override
    public Map<String, String> getExportContent(String ... typeAlias) throws Exception {
        List tags = this.portalFeignService.getTagsByTypeAlias(typeAlias);
        return this.handleExportContent(tags);
    }

    @Override
    public List<ImportCheckResult> importCheck(Map<String, String> map) throws IOException {
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return new ArrayList<ImportCheckResult>();
        }
        List list = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<ObjectNode>>(){});
        return this.portalFeignService.importCheckTags(list);
    }

    @Override
    public void importData(Map<String, String> map, String status) throws IOException {
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return;
        }
        List list = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<ObjectNode>>(){});
        this.portalFeignService.importTags(list, status);
    }
}

