/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.instance.BoDataImportHandler;
import com.hotent.bo.model.BoData;
import com.hotent.form.enums.LayoutType;
import com.hotent.form.mobile.service.Pc2MobileConvertFactory;
import com.hotent.form.mobile.service.Pc2MobileConverter;
import com.hotent.form.model.FormMeta;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FormUtil {
    private static final List<String> LIST_INVISIBLE_ADVANCE_MOBILE = Arrays.asList("dataView", LayoutType.HOT_TABLE.getValue());

    public static String getDesignTemplatePath() throws Exception {
        return FileUtil.getClassesPath() + "template" + File.separator + "design" + File.separator;
    }

    public static Map<String, String> parseOpinion(String html) {
        HashMap<String, String> map = new HashMap<String, String>();
        Document doc = Jsoup.parseBodyFragment((String)html);
        Elements list = doc.select("[opinion]");
        for (Element el : list) {
            String opinion = el.attr("opinion");
            try {
                if (opinion == null) continue;
                JsonNode jsonObject = JsonUtil.toJsonNode((String)opinion);
                String name = jsonObject.get("name") + "";
                String memo = jsonObject.get("desc") + "";
                map.put(name, memo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            boolean isDir = dir.isDirectory();
            if (!isDir) {
                try {
                    dir.mkdirs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(file = new File(filePath + File.separator + fileName)).exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                file.delete();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static BoDataImportHandler loadImportHandler(String filePath, String processorName) {
        URL url = null;
        BoDataImportHandler boDataImportHandler = null;
        File file = new File(filePath);
        try {
            url = file.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            Class<?> processorClass = loader.loadClass(processorName);
            boDataImportHandler = (BoDataImportHandler)processorClass.newInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return boDataImportHandler;
    }

    public static ArrayNode resolutionFieldsByFormMeta(FormMeta bpmFormDef) throws IOException {
        ArrayNode resolutionFields = JsonUtil.getMapper().createArrayNode();
        if (!StringUtil.isEmpty((String)bpmFormDef.getExpand())) {
            JsonNode expand = JsonUtil.toJsonNode((String)bpmFormDef.getExpand());
            ArrayNode table = (ArrayNode)expand.findValue("list");
            for (JsonNode tableNode : table) {
                ArrayNode Lists2;
                String ctrlType = "";
                if (tableNode.has("ctrlType")) {
                    ctrlType = tableNode.get("ctrlType").asText();
                }
                if (tableNode.has("columns")) {
                    ArrayNode columns = (ArrayNode)tableNode.findValue("columns");
                    for (JsonNode column : columns) {
                        if (!column.has("list")) continue;
                        ArrayNode fields = (ArrayNode)column.findValue("list");
                        for (JsonNode field : fields) {
                            if ("grid".equals(field.get("ctrlType").asText())) {
                                ArrayNode gridColumns = (ArrayNode)field.findValue("columns");
                                for (JsonNode gridColumn : gridColumns) {
                                    if (!gridColumn.has("list")) continue;
                                    ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                                    for (JsonNode gridField : gridFields) {
                                        ObjectNode fieldObj = (ObjectNode)gridField;
                                        fieldObj.put("type", "main");
                                        resolutionFields.add((JsonNode)fieldObj);
                                    }
                                }
                                continue;
                            }
                            if ("subtable".equals(field.get("ctrlType").asText()) || "subDiv".equals(field.get("ctrlType").asText()) || "hottable".equals(field.get("ctrlType").asText())) {
                                ArrayNode subtableLists = (ArrayNode)field.findValue("list");
                                FormUtil.resolutionSub(bpmFormDef.getId(), subtableLists, resolutionFields);
                                continue;
                            }
                            if ("table".equals(field.get("ctrlType").asText())) {
                                ArrayNode Lists3 = (ArrayNode)field.findValue("rows");
                                for (Object rowNode : Lists3) {
                                    ArrayNode cols = (ArrayNode)rowNode.findValue("cols");
                                    for (JsonNode colNode : cols) {
                                        if (!colNode.has("list") || !BeanUtils.isNotEmpty((Object)colNode.get("list"))) continue;
                                        ArrayNode list = (ArrayNode)colNode.findValue("list");
                                        for (JsonNode tfield : list) {
                                            ObjectNode fieldObj = (ObjectNode)tfield;
                                            fieldObj.put("type", "main");
                                            resolutionFields.add((JsonNode)fieldObj);
                                        }
                                    }
                                }
                                continue;
                            }
                            if ("tab".equals(field.get("ctrlType").asText())) {
                                Object rowNode;
                                String tctrlType = "";
                                if (tableNode.has("ctrlType")) {
                                    tctrlType = field.get("ctrlType").asText();
                                }
                                ArrayNode tabColumns = (ArrayNode)field.findValue("columns");
                                rowNode = tabColumns.iterator();
                                while (rowNode.hasNext()) {
                                    JsonNode tabColumn = (JsonNode)rowNode.next();
                                    if (tabColumn.has("list")) {
                                        ArrayNode tabFields = (ArrayNode)tabColumn.findValue("list");
                                        for (JsonNode tabField : tabFields) {
                                            if ("grid".equals(tabField.get("ctrlType").asText())) {
                                                ArrayNode gridColumns = (ArrayNode)tabField.findValue("columns");
                                                for (JsonNode gridColumn : gridColumns) {
                                                    if (!gridColumn.has("list")) continue;
                                                    ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                                                    for (JsonNode tgridField : gridFields) {
                                                        ObjectNode fieldObj = (ObjectNode)tgridField;
                                                        fieldObj.put("type", "main");
                                                        resolutionFields.add((JsonNode)fieldObj);
                                                    }
                                                }
                                                continue;
                                            }
                                            if ("subtable".equals(tabField.get("ctrlType").asText()) || "subDiv".equals(tabField.get("ctrlType").asText()) || "hottable".equals(tabField.get("ctrlType").asText())) {
                                                ArrayNode subtableLists = (ArrayNode)tabField.findValue("list");
                                                FormUtil.resolutionSub(bpmFormDef.getId(), subtableLists, resolutionFields);
                                                continue;
                                            }
                                            if ("table".equals(tabField.get("ctrlType").asText())) {
                                                ArrayNode Lists4 = (ArrayNode)tabField.findValue("rows");
                                                for (JsonNode rowNode2 : Lists4) {
                                                    ArrayNode cols = (ArrayNode)rowNode2.findValue("cols");
                                                    for (JsonNode colNode : cols) {
                                                        if (!colNode.has("list") || !BeanUtils.isNotEmpty((Object)colNode.get("list"))) continue;
                                                        ArrayNode list = (ArrayNode)colNode.findValue("list");
                                                        for (JsonNode tfield : list) {
                                                            ObjectNode fieldObj = (ObjectNode)tfield;
                                                            fieldObj.put("type", "main");
                                                            resolutionFields.add((JsonNode)fieldObj);
                                                        }
                                                    }
                                                }
                                                continue;
                                            }
                                            ObjectNode fieldObj = (ObjectNode)tabField;
                                            fieldObj.put("type", "main");
                                            resolutionFields.add((JsonNode)fieldObj);
                                        }
                                        continue;
                                    }
                                    if ("subtable".equals(tctrlType) || "subDiv".equals(tctrlType) || "hottable".equals(tctrlType)) {
                                        ArrayNode Lists5 = (ArrayNode)field.findValue("list");
                                        FormUtil.resolutionSub(bpmFormDef.getId(), Lists5, resolutionFields);
                                        continue;
                                    }
                                    resolutionFields.add(field);
                                }
                                continue;
                            }
                            ObjectNode fieldObj = (ObjectNode)field;
                            fieldObj.put("type", "main");
                            resolutionFields.add((JsonNode)fieldObj);
                        }
                    }
                    continue;
                }
                if ("subtable".equals(ctrlType) || "subDiv".equals(ctrlType) || "hottable".equals(ctrlType)) {
                    Lists2 = (ArrayNode)tableNode.findValue("list");
                    FormUtil.resolutionSub(bpmFormDef.getId(), Lists2, resolutionFields);
                    continue;
                }
                if ("table".equals(ctrlType)) {
                    Lists2 = (ArrayNode)tableNode.findValue("rows");
                    for (JsonNode rowNode : Lists2) {
                        ArrayNode cols = (ArrayNode)rowNode.findValue("cols");
                        for (JsonNode colNode : cols) {
                            if (!colNode.has("list") || !BeanUtils.isNotEmpty((Object)colNode.get("list"))) continue;
                            ArrayNode list = (ArrayNode)colNode.findValue("list");
                            for (JsonNode field : list) {
                                ObjectNode fieldObj = (ObjectNode)field;
                                fieldObj.put("type", "main");
                                resolutionFields.add((JsonNode)fieldObj);
                            }
                        }
                    }
                    continue;
                }
                resolutionFields.add(tableNode);
            }
        }
        return resolutionFields;
    }

    private static void resolutionSub(String defId, ArrayNode Lists2, ArrayNode resolutionFields) throws IOException {
        if (BeanUtils.isNotEmpty((Object)Lists2)) {
            for (JsonNode field : Lists2) {
                if (field.has("ctrlType") && field.has("list") && ("suntable".equals(field.get("ctrlType").asText()) || "sunDiv".equals(field.get("ctrlType").asText()))) {
                    ArrayNode sunLists = (ArrayNode)field.findValue("list");
                    for (JsonNode sunField : sunLists) {
                        if ("grid".equals(sunField.get("ctrlType").asText())) {
                            ArrayNode gridColumns = (ArrayNode)sunField.findValue("columns");
                            for (JsonNode gridColumn : gridColumns) {
                                if (!gridColumn.has("list")) continue;
                                ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                                for (JsonNode gridField : gridFields) {
                                    ObjectNode fieldObj = (ObjectNode)gridField;
                                    resolutionFields.add((JsonNode)fieldObj);
                                }
                            }
                            continue;
                        }
                        resolutionFields.add(sunField);
                    }
                    continue;
                }
                if (field.has("ctrlType") && "grid".equals(field.get("ctrlType").asText())) {
                    ArrayNode gridColumns = (ArrayNode)field.findValue("columns");
                    for (JsonNode gridColumn : gridColumns) {
                        if (!gridColumn.has("list")) continue;
                        ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                        for (JsonNode gridField : gridFields) {
                            ObjectNode fieldObj = (ObjectNode)gridField;
                            resolutionFields.add((JsonNode)fieldObj);
                        }
                    }
                    continue;
                }
                resolutionFields.add(field);
            }
        }
    }

    public static void handleIdentity(BoData boData, String identityConfigJson) throws Exception {
        ArrayNode identityConfigs = (ArrayNode)JsonUtil.toJsonNode((String)identityConfigJson);
        for (JsonNode identityConfig : identityConfigs) {
            LinkedList<BoData> gatherRows;
            String[] pathArr;
            String type = JsonUtil.getString((JsonNode)identityConfig, (String)"parentType");
            String alias = JsonUtil.getString((JsonNode)identityConfig, (String)"alias");
            String path = JsonUtil.getString((JsonNode)identityConfig, (String)"path");
            if (StringUtil.isEmpty((String)alias)) {
                throw new BaseException(String.format("\u8def\u5f84\u3010%s\u3011\u4e2d\u672a\u914d\u7f6e\u6d41\u6c34\u53f7", path));
            }
            if ("main".equals(type)) {
                pathArr = path.split("\\.");
                Object oldValue = boData.getData().get(pathArr[1]);
                if (!BeanUtils.isEmpty(oldValue)) continue;
                boData.getData().put(pathArr[1], FormUtil.getIdentities(alias, 1).get(0));
                continue;
            }
            if ("sub".equals(type)) {
                pathArr = path.split("\\.");
                String field = pathArr[1];
                String boSubEntityAlias = JsonUtil.getString((JsonNode)identityConfig, (String)"boSubEntity");
                List subBoDatas = (List)boData.getSubMap().get(boSubEntityAlias);
                if (!BeanUtils.isNotEmpty((Object)subBoDatas)) continue;
                gatherRows = new LinkedList<BoData>();
                for (BoData subBoData : subBoDatas) {
                    Object o = subBoData.getData().get(field);
                    if (!BeanUtils.isEmpty(o)) continue;
                    gatherRows.add(subBoData);
                }
                FormUtil.handleBoDataIdentity(alias, gatherRows, field);
                continue;
            }
            if (!"sun".equals(type)) continue;
            pathArr = path.split("\\.");
            String subName = pathArr[1];
            String sunName = pathArr[2];
            if (subName.startsWith("sub_")) {
                subName = subName.substring(4);
            }
            String field = pathArr[3];
            gatherRows = new LinkedList();
            List subDatas = (List)boData.getSubMap().get(subName);
            if (BeanUtils.isNotEmpty((Object)subDatas)) {
                for (BoData subData : subDatas) {
                    List sunDatas = (List)subData.getSubMap().get(sunName);
                    if (!BeanUtils.isNotEmpty((Object)sunDatas)) continue;
                    for (BoData sunData : sunDatas) {
                        Object o = sunData.getData().get(field);
                        if (!BeanUtils.isEmpty(o)) continue;
                        gatherRows.add(sunData);
                    }
                }
            }
            boolean change = !gatherRows.isEmpty();
            FormUtil.handleBoDataIdentity(alias, gatherRows, field);
            if (change) {
                for (BoData subData : subDatas) {
                    List sunDatas = (List)subData.getSubMap().get(sunName);
                    ArrayList<Map> suns = new ArrayList<Map>();
                    for (BoData sunData : sunDatas) {
                        suns.add(sunData.getData());
                    }
                    subData.getData().put(sunName, suns);
                }
            }
            System.out.println(1);
        }
    }

    private static void handleBoDataIdentity(String alias, Queue<BoData> queue, String field) {
        if (null == queue || queue.isEmpty()) {
            return;
        }
        int size = queue.size();
        List<String> identities = FormUtil.getIdentities(alias, size);
        for (int i = 0; i < size; ++i) {
            queue.poll().getData().put(field, identities.get(i));
        }
    }

    private static List<String> getIdentities(String alias, Integer offset) {
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        CommonResult identityBatch = portalFeignService.getIdentityBatch(alias, offset);
        if (!identityBatch.getState().booleanValue() || ((List)identityBatch.getValue()).isEmpty()) {
            throw new BaseException("\u83b7\u53d6\u6d41\u6c34\u53f7\u5931\u8d25");
        }
        return (List)identityBatch.getValue();
    }

    public static List<String> getLayoutTypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (LayoutType value : LayoutType.values()) {
            result.add(value.getValue());
        }
        return result;
    }

    public static String replaceUnderline(String fieldName) {
        if (StringUtil.isEmpty((String)fieldName)) {
            return fieldName;
        }
        return fieldName.replace("_", "");
    }

    public static String convertFormSettingFullscreen(String formSetting) throws Exception {
        if (formSetting == null || StringUtil.isEmpty((String)formSetting)) {
            return formSetting;
        }
        ObjectNode settingNode = (ObjectNode)JsonUtil.toJsonNode((String)formSetting);
        settingNode.put("widthType", "fullscreen");
        return JsonUtil.toJson((Object)settingNode);
    }

    public static String transformationMobileExpand(String expandStr) throws Exception {
        if (!StringUtil.isEmpty((String)expandStr)) {
            Pc2MobileConvertFactory pc2MobileConvertFactory = (Pc2MobileConvertFactory)AppUtil.getBean(Pc2MobileConvertFactory.class);
            JsonNode expand = JsonUtil.toJsonNode((String)expandStr);
            ArrayNode table = (ArrayNode)expand.findValue("list");
            ArrayNode tempArray = JsonUtil.createArrayNode();
            Pc2MobileConverter pageConverter = pc2MobileConvertFactory.getBean(LayoutType.PAGE_STEP_LAYOUT.getValue());
            table = pageConverter.convert((JsonNode)table);
            for (JsonNode tableNode : table) {
                if (tableNode.get("ctrlType") != null && LIST_INVISIBLE_ADVANCE_MOBILE.contains(tableNode.get("ctrlType").asText())) continue;
                Pc2MobileConverter converter = pc2MobileConvertFactory.getBean(JsonUtil.getString((JsonNode)tableNode, (String)"ctrlType", (String)LayoutType.DEFAULT.getValue()));
                ArrayNode temp = converter.convert(tableNode);
                tempArray.addAll(temp);
            }
            ObjectNode objectNode = (ObjectNode)expand;
            objectNode.set("list", (JsonNode)tempArray);
            return JsonUtil.toJson((Object)objectNode);
        }
        return "";
    }
}

