/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.form.model.CustomDialog;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.i18n.util.I18nUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class FreeMakerUtil {
    protected static Logger logger = LoggerFactory.getLogger(FreeMakerUtil.class);
    private static final String NO_BIND_MODEL = "noBindModel";
    private static final String ALLOW_NO_BIND_MODEL = "allowNoBindModel";
    public static final HashSet<String> noAttrFields = new HashSet<String>(){
        {
            this.add("button");
            this.add("text");
            this.add("immediate-single");
            this.add("immediate-textarea");
            this.add("flowChart");
            this.add("approvalHistory");
        }
    };
    public static final HashSet<String> allowNoAttributes = new HashSet<String>(){
        {
            this.add("input");
            this.add("textarea");
            this.add("number");
            this.add("property-text");
        }
    };
    private static final String DEFAULT_LABEL_COLOR = "#000000";

    public String getChildrenFieldName(Object field) throws IOException {
        JsonNode jsonObject = JsonUtil.toJsonNode((Object)field);
        StringJoiner sj = new StringJoiner(",");
        ArrayNode arrayNode = (ArrayNode)jsonObject.get("children");
        this.callbackGetFieldNames(arrayNode, sj);
        return sj.toString();
    }

    private void callbackGetFieldNames(ArrayNode arrayNode, StringJoiner sj) {
        arrayNode.forEach(objectNode -> {
            if (objectNode.hasNonNull("name")) {
                sj.add(objectNode.get("name").asText());
            } else {
                this.callbackGetFieldNames((ArrayNode)objectNode.get("children"), sj);
            }
        });
    }

    public String getAttrs(String attrNames, Object f) throws IOException {
        StringBuffer sb = new StringBuffer();
        JsonNode field = null;
        try {
            field = JsonUtil.toJsonNode((Object)f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JsonNode option = field.get("options");
        if (BeanUtils.isEmpty((Object)option)) {
            return "";
        }
        String[] attrs = attrNames.split(",");
        String refId = "";
        for (String attr : attrs) {
            JsonNode file;
            String attrStr = "";
            if ("htfuncexp".equals(attr) && option.has("statFun")) {
                attrStr = option.get("statFun").asText();
            } else if (":linkage".equals(attr) && option.has("linkage")) {
                ObjectMapper mapper = new ObjectMapper();
                ArrayNode arrayNode2 = mapper.createArrayNode();
                try {
                    JsonNode linkageObj = JsonUtil.toJsonNode((String)option.get("linkage").toString());
                    if (BeanUtils.isNotEmpty((Object)linkageObj)) {
                        for (JsonNode jsonNode : linkageObj) {
                            ObjectNode linkage = (ObjectNode)jsonNode;
                            if (linkage.has("effect")) {
                                ArrayNode arrayNode = mapper.createArrayNode();
                                JsonNode effectNode = linkage.get("effect");
                                for (JsonNode jsonNode2 : effectNode) {
                                    if (jsonNode2.has("rules")) {
                                        ObjectNode validate = (ObjectNode)jsonNode2;
                                        ArrayNode array = (ArrayNode)validate.get("rules");
                                        validate.remove("rules");
                                        ObjectNode _validate = JsonUtil.getMapper().createObjectNode();
                                        this.changeValidate(array, _validate);
                                        Map<Object, String> map = this.getValidateStr(_validate);
                                        String validateStr = map.get("validateStr");
                                        validate.put("validate", validateStr);
                                        arrayNode.add((JsonNode)validate);
                                        continue;
                                    }
                                    arrayNode.add(jsonNode2);
                                }
                                if (BeanUtils.isNotEmpty((Object)arrayNode)) {
                                    linkage.remove("effect");
                                    linkage.set("effect", (JsonNode)arrayNode);
                                }
                            }
                            arrayNode2.add((JsonNode)linkage);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                attrStr = arrayNode2.toString();
            } else if ("selectquery".equals(attr)) {
                attrStr = BeanUtils.isNotEmpty((Object)option.get("jlsz")) ? option.get("jlsz").asText("") : "";
            } else if ("ht-office-plugin".equals(attr)) {
                sb.append(" style='width:" + option.get("width").asText() + "px;height:" + option.get("height").asText() + "px' ");
                if (option.has("doctype")) {
                    sb.append(" doctype='" + option.get("doctype").asText() + "'  ");
                }
                sb.append(" ht-office-plugin ");
            } else if (":multiple".equals(attr)) {
                attrStr = option.has("multiple") && option.get("multiple").asBoolean() ? "true" : (field.has("isMultiple") && field.get("isMultiple").asBoolean() ? "true" : "false");
            } else if (":filterable".equals(attr)) {
                attrStr = option.has("filterable") && option.get("filterable").asBoolean() ? "true" : "false";
            } else if (":allowCreate".equals(attr)) {
                attrStr = option.has("filterable") && option.get("filterable").asBoolean() && option.has("allowCreate") && option.get("allowCreate").asBoolean() ? "true" : "false";
            } else if (":expand".equals(attr)) {
                attrStr = option.has("expand") && option.get("expand").asBoolean() ? "true" : "false";
            } else if (":isRevision".equals(attr)) {
                attrStr = option.has("isRevision") && option.get("isRevision").asBoolean() ? "true" : "false";
            } else if (":related-query".equals(attr)) {
                if (option.has("customQuery")) {
                    attrStr = this.getRelatedQuery(option);
                }
            } else if ("tooltipplacement".equals(attr)) {
                if (field.has("tooltipplacement")) {
                    attrStr = field.get("tooltipplacement").asText();
                }
            } else if ("propConf".equals(attr)) {
                if (option.has("propConf")) {
                    attrStr = JsonUtil.toJson((Object)option.get("propConf"));
                }
            } else if ("accept".equals(attr) && BeanUtils.isNotEmpty((Object)(file = option.get("file")))) {
                String acceptType = "custom";
                if (file.has("acceptType")) {
                    acceptType = file.get("acceptType").asText();
                }
                if ("custom".equals(acceptType)) {
                    if (file.has("accept") && file.get("accept").isArray()) {
                        ArrayNode array = (ArrayNode)file.get("accept");
                        ArrayList<String> files = new ArrayList<String>();
                        for (int i = 0; i < array.size(); ++i) {
                            files.add(array.get(i).asText());
                        }
                        attrStr = StringUtils.join(files, (String)",");
                    }
                    String acceptStr = "";
                    if (file.has("acceptStr")) {
                        acceptStr = file.get("acceptStr").asText();
                    }
                    if (StringUtil.isNotEmpty((String)acceptStr)) {
                        if (StringUtil.isNotEmpty((String)attrStr)) {
                            attrStr = attrStr + ",";
                        }
                        attrStr = attrStr + acceptStr;
                    }
                }
            }
            if (StringUtil.isNotEmpty((String)attrStr)) {
                sb.append(attr).append("='").append(attrStr).append("' ");
            }
            if (!StringUtil.isNotEmpty((String)attrStr) || !":related-query".equals(attr)) continue;
            sb.append(" v-related-query=\"{cache: true}\" ");
        }
        if (StringUtil.isNotEmpty((String)refId)) {
            sb.append("name").append("=\"").append(refId).append("\" ");
        }
        return sb.toString();
    }

    public String handleFilterCondition(Object o, String path, String alias) {
        try {
            JsonNode jsonNode;
            if (BeanUtils.isEmpty((Object)o)) {
                return alias + path;
            }
            Locale locale = LocaleContextHolder.getLocale();
            JsonNode jsonObject = JsonUtil.toJsonNode((Object)o);
            if (jsonObject.has(path) && (jsonNode = jsonObject.get(path)).isArray()) {
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                ArrayList nodes = new ArrayList();
                arrayNode.forEach(node -> {
                    String text = node.get("text").asText();
                    if (StringUtil.isNotEmpty((String)text)) {
                        String key = String.format("formTemplate.%s.filter.%s%s", alias, path, node.get("filterKey").asText());
                        ObjectNode objectNode = (ObjectNode)node;
                        String i18nMessage = I18nUtil.getMessage((String)key, (Locale)locale);
                        objectNode.put("text", Objects.equals(key, i18nMessage) ? text : i18nMessage);
                        nodes.add(objectNode);
                    }
                });
                return JsonUtil.toJsonString((Object)JsonUtil.listToArrayNode(nodes));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BaseException("\u6a21\u677f\u89e3\u6790\u5f02\u5e38\u3002", (Throwable)e);
        }
        return "";
    }

    private String getRelatedQuery(JsonNode option) throws IOException {
        ArrayNode custQuery;
        JsonNode custQueryJson;
        String result = "";
        JsonNode customQuery = JsonUtil.toJsonNode((Object)option.get("customQuery"));
        if (customQuery != null && customQuery.has("custQueryJson") && (custQueryJson = JsonUtil.toJsonNode((Object)customQuery.get("custQueryJson"))) != null && custQueryJson.isArray() && (custQuery = (ArrayNode)custQueryJson) != null && custQuery.size() > 0) {
            ArrayNode ary = JsonUtil.getMapper().createArrayNode();
            custQuery.forEach(q -> {
                if (q != null && q.isObject()) {
                    try {
                        ArrayNode resultAry;
                        JsonNode resultfield;
                        ArrayNode conditionAry;
                        ObjectNode oldObj = (ObjectNode)q;
                        ObjectNode newObj = JsonUtil.getMapper().createObjectNode();
                        newObj.put("alias", JsonUtil.getString((JsonNode)oldObj, (String)"alias"));
                        JsonNode conditionfield = JsonUtil.toJsonNode((Object)oldObj.get("conditionfield"));
                        if (conditionfield != null && conditionfield.isArray() && (conditionAry = (ArrayNode)conditionfield) != null && conditionAry.size() > 0) {
                            ObjectNode newCaObj = JsonUtil.getMapper().createObjectNode();
                            conditionAry.forEach(ca -> {
                                if (ca != null && ca.isObject()) {
                                    ObjectNode caObj = (ObjectNode)ca;
                                    newCaObj.put(JsonUtil.getString((JsonNode)caObj, (String)"field"), JsonUtil.getString((JsonNode)caObj, (String)"fieldPath"));
                                }
                            });
                            newObj.set("condition", (JsonNode)newCaObj);
                        }
                        if ((resultfield = JsonUtil.toJsonNode((Object)oldObj.get("resultfield"))) != null && resultfield.isArray() && (resultAry = (ArrayNode)resultfield) != null && resultAry.size() > 0) {
                            ObjectNode newRtObj = JsonUtil.getMapper().createObjectNode();
                            resultAry.forEach(rt -> {
                                if (rt != null && rt.isObject()) {
                                    ObjectNode rtObj = (ObjectNode)rt;
                                    newRtObj.put(JsonUtil.getString((JsonNode)rtObj, (String)"field"), JsonUtil.getString((JsonNode)rtObj, (String)"fieldPath"));
                                }
                            });
                            newObj.set("result", (JsonNode)newRtObj);
                        }
                        ary.add((JsonNode)newObj);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            result = JsonUtil.toJson((Object)ary);
        }
        return result;
    }

    public String getInputAdvancedAttributes(Object str) throws IOException {
        JsonNode obj = JsonUtil.toJsonNode((Object)str);
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        ArrayList<String> list = new ArrayList<String>();
        if (obj.has("isInputEdit") && obj.get("isInputEdit").asBoolean()) {
            node.put("isInputEdit", true);
            list.add("isInputEdit:true");
        }
        if (obj.has("inputType") && obj.get("inputType").asBoolean()) {
            list.add("isPassword:true");
        }
        if (obj.has("isBindIdentity") && obj.get("isBindIdentity").asBoolean() && obj.get("bindIdentityjson").has("alias")) {
            list.add("bindIdentityAlias:'" + obj.get("bindIdentityjson").get("alias").asText() + "'");
        }
        if (list.size() == 0) {
            return "{}";
        }
        return "{" + StringUtils.join(list, (String)",") + "}";
    }

    public String getLinkage(Object obj) throws IOException {
        JsonNode options = JsonUtil.toJsonNode((Object)obj);
        HashMap<String, List> map = new HashMap<String, List>();
        if (options.has("linkage")) {
            JsonNode linkage = options.get("linkage");
            linkage.forEach(item -> {
                String key = item.get("value").asText();
                JsonNode effect = item.get("effect");
                List<JsonNode> listNode = new ArrayList();
                if (map.containsKey(key)) {
                    listNode = (List)map.get(key);
                }
                for (int i = 0; i < effect.size(); ++i) {
                    listNode.add(effect.get(i));
                }
                map.put(key, listNode);
            });
        }
        ArrayList jsonStr = new ArrayList();
        map.forEach((key, val) -> {
            ArrayList effectList = new ArrayList();
            val.forEach(item -> {
                if (BeanUtils.isNotEmpty((Object)item.get("target"))) {
                    String[] target = item.get("target").asText().split("\\|");
                    String validate = item.get("validateObj").get("options").get("validate").asText();
                    if (StringUtil.isNotEmpty((String)validate)) {
                        if (validate.indexOf("'confirmed:'+") > -1) {
                            validate = "'confirmed:" + validate.substring("'confirmed:'+".length()) + "'";
                        }
                        effectList.add("{ref: 'data." + target[0] + "', type: '+',value: " + validate + "}");
                    }
                    String boTypeStr = "";
                    if (BeanUtils.isNotEmpty((Object)item.get("boType"))) {
                        boTypeStr = ",boType: '" + item.get("boType").asText() + "'";
                    }
                    effectList.add("{target: 'permission.fields." + target[1] + "', type: '=',value: '" + item.get("type").asText() + "'" + boTypeStr + "}");
                }
                if (BeanUtils.isNotEmpty((Object)item.get("targetSub"))) {
                    String[] targetSub = item.get("targetSub").asText().split("\\|");
                    if (item.get("type").asText().equals("n")) {
                        effectList.add("{target: 'permission.table." + targetSub[0] + ".hidden', type: '=',value: true}");
                    } else if (item.get("type").asText().equals("w")) {
                        effectList.add("{target: 'permission.table." + targetSub[0] + ".hidden', type: '=',value: false}");
                    } else if (item.get("type").asText().equals("b")) {
                        effectList.add("{target: 'permission.table." + targetSub[0] + ".required', type: '=',value: true}");
                    }
                }
            });
            jsonStr.add("{value:'" + key + "',effect:[" + StringUtils.join(effectList, (String)",") + "]}");
        });
        if (jsonStr.size() > 0) {
            String linkage = "[" + StringUtils.join(jsonStr, (String)",") + "]";
            return ":linkage=\"" + linkage + "\"";
        }
        return "";
    }

    private Map<Object, String> getValidateStr(ObjectNode validate) {
        HashMap<Object, String> map = new HashMap<Object, String>();
        String validateStr = "";
        StringBuffer validatesb = new StringBuffer();
        validatesb.append("");
        String confirmedKey = "";
        String confirmedVal = "";
        Iterator iterator = validate.fields();
        while (iterator.hasNext()) {
            Map.Entry ent = (Map.Entry)iterator.next();
            JsonNode value = (JsonNode)ent.getValue();
            if ("false".equals(value.asText())) continue;
            if ("confirmed".equals(ent.getKey())) {
                confirmedKey = (String)ent.getKey() + ":";
                confirmedVal = "data." + value.asText();
            } else if ("backendValidate".equals(ent.getKey())) {
                boolean submitFormData = false;
                if (value.has("submitFormData")) {
                    submitFormData = value.get("submitFormData").asBoolean();
                }
                validatesb.append((String)ent.getKey() + ":" + value.get("url").asText() + "," + submitFormData);
            } else {
                validatesb.append((String)ent.getKey() + ":" + value.asText());
            }
            if (!iterator.hasNext()) continue;
            validatesb.append("|");
        }
        validateStr = validatesb.toString() + confirmedKey;
        map.put("validateStr", validateStr);
        map.put("confirmedVal", confirmedVal);
        return map;
    }

    private void changeValidate(ArrayNode array, ObjectNode validate) {
        for (JsonNode rule : array) {
            if (validate.has(rule.get("text").asText())) {
                validate.remove(rule.get("text").asText());
            }
            if (rule.has("value")) {
                String value = rule.get("value").asText();
                if ("backendValidate".equals(rule.get("text").asText())) {
                    ObjectNode createObjectNode = JsonUtil.getMapper().createObjectNode();
                    createObjectNode.put("url", value);
                    createObjectNode.put("submitFormData", rule.has("submitFormData") ? rule.get("submitFormData").asBoolean() : false);
                    validate.set(rule.get("text").asText(), (JsonNode)createObjectNode);
                    continue;
                }
                validate.put(rule.get("text").asText(), value);
                continue;
            }
            validate.put(rule.get("text").asText(), true);
        }
    }

    public String getDatecalc(JsonNode obj) {
        String ref = "{\"start\":" + obj.get("start").asText() + ",\"diffType\":\"" + obj.get("diffType").asText() + "\",\"end\":" + obj.get("end").asText() + "}";
        return ref;
    }

    public String getCtrlDate(Object field) {
        JsonNode tmp = null;
        try {
            tmp = JsonUtil.toJsonNode((Object)field);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonNode option = tmp.get("options");
        String attrStr = option.get("dataFormat").asText();
        if (StringUtil.isEmpty((String)attrStr)) {
            return "mobiscrollDate=date'";
        }
        if ("yyyy-MM-dd HH:mm:ss".equals(attrStr)) {
            return "mobiscrollDate='datetime'";
        }
        if ("HH:mm:ss".equals(attrStr)) {
            return "mobiscrollDate='time'";
        }
        return "mobiscrollDate='date'";
    }

    public String getJsonByPath(Object o, String path) {
        return this.getJsonByPath(o, path, "");
    }

    public String getJsonByPathNew(Object o, String name, Object o1) {
        String json = "";
        StringBuilder stringBuilder = new StringBuilder();
        try {
            ArrayNode arrayNode;
            JsonNode jsonNode;
            if (BeanUtils.isEmpty((Object)o)) {
                return json;
            }
            JsonNode jsonObject = JsonUtil.toJsonNode((Object)o);
            JsonNode defaultMap = JsonUtil.toJsonNode((Object)o1);
            if (jsonObject.has("name") && defaultMap != null && (jsonNode = defaultMap.get(jsonObject.get("name").asText())) != null && jsonNode.isArray() && (arrayNode = (ArrayNode)jsonNode) != null && arrayNode.size() > 0) {
                json = JsonUtil.toJson((Object)jsonNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u6a21\u677f\u89e3\u6790\u5f02\u5e38\u3002", (Throwable)e);
        }
        return json;
    }

    public String getToString(Object o) {
        return o.toString();
    }

    public String getJsonByPath(Object o, String path, String defaultVal) {
        try {
            if (BeanUtils.isEmpty((Object)o)) {
                return defaultVal;
            }
            JsonNode jsonObject = JsonUtil.toJsonNode((Object)o);
            Object[] pathList = path.split("\\.");
            if (pathList.length > 1 && jsonObject.has(pathList[0])) {
                String tempJson = jsonObject.get(pathList[0]).asText();
                if (StringUtil.isEmpty((String)tempJson)) {
                    return this.getJsonByPath(jsonObject.get(pathList[0]), StringUtils.join((Object[])ArrayUtils.remove((Object[])pathList, (int)0), (String)"."));
                }
                return this.getJsonByPath(tempJson, StringUtils.join((Object[])ArrayUtils.remove((Object[])pathList, (int)0), (String)"."));
            }
            if (jsonObject.has(path)) {
                JsonNode jsonNode = jsonObject.get(path);
                if (jsonNode.isValueNode()) {
                    String asText = jsonNode.asText();
                    return asText;
                }
                if (jsonNode.isArray()) {
                    String json = JsonUtil.toJson((Object)jsonNode);
                    return json;
                }
                if (jsonNode.isObject()) {
                    String json = JsonUtil.toJson((Object)jsonNode);
                    return json;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BaseException("\u6a21\u677f\u89e3\u6790\u5f02\u5e38\u3002", (Throwable)e);
        }
        return defaultVal;
    }

    public List getListByPath(Object o, String path) throws IOException {
        ArrayList<Map> list = new ArrayList<Map>();
        String jsonStr = this.getJsonByPath(o, path);
        if (StringUtil.isNotEmpty((String)jsonStr)) {
            if (jsonStr.indexOf("\"") == 0) {
                jsonStr = jsonStr.replaceFirst("\"", "");
                jsonStr = jsonStr.replaceAll("]\"", "]");
                jsonStr = jsonStr.replaceAll("\\\\", "");
            }
            ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)jsonStr);
            for (JsonNode node : array) {
                list.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)node)));
            }
        }
        return list;
    }

    public String getSubList(String jsonList, int begin, int end) {
        String[] array = jsonList.split(",");
        String rtn = "";
        for (int i = 0; i < array.length && i >= begin && i <= end; ++i) {
            rtn = rtn + array[i] + ",";
        }
        return rtn.substring(0, rtn.length() - 1);
    }

    public String getHtSelector(Object option, Boolean tag) {
        if (BeanUtils.isEmpty((Object)option)) {
            return "{}";
        }
        ObjectNode fromObject = null;
        try {
            fromObject = (ObjectNode)JsonUtil.toJsonNode((Object)option);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tag == null) {
            tag = false;
        }
        ObjectNode returnObj = JsonUtil.getMapper().createObjectNode();
        JsonNode selectorObj = fromObject.get("selector");
        if (BeanUtils.isNotEmpty((Object)selectorObj)) {
            returnObj.put("isSingle", selectorObj.has("isSingle") ? selectorObj.get("isSingle").asBoolean() : false);
            returnObj.put("selectCurrent", selectorObj.has("selectCurrent") ? selectorObj.get("selectCurrent").asBoolean() : false);
            JsonNode typeObj = null;
            if (selectorObj.has("type")) {
                typeObj = selectorObj.get("type");
            }
            if (BeanUtils.isNotEmpty(typeObj)) {
                returnObj.put("type", typeObj.has("alias") ? typeObj.get("alias").asText() : "");
            }
        }
        ArrayNode bindAry = null;
        if (fromObject.has("bind")) {
            bindAry = (ArrayNode)fromObject.get("bind");
        }
        ObjectNode bindObj = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isNotEmpty((Object)bindAry)) {
            for (JsonNode jobject : bindAry) {
                String key;
                String string = key = jobject.has("key") ? jobject.get("key").asText() : "";
                if (!jobject.has("jsonPath")) continue;
                String jsonPath = jobject.get("jsonPath").asText();
                String path = "data.";
                if (tag.booleanValue()) {
                    path = "data.";
                }
                path = path + jsonPath;
                bindObj.put(key, path);
            }
        }
        returnObj.set("bind", (JsonNode)bindObj);
        String returnStr = returnObj.toString();
        if (StringUtil.isEmpty((String)returnStr)) {
            returnStr = "";
        }
        return returnStr.replaceAll("\"", "'");
    }

    public String getHtSelectorBind(Object option, Boolean tag) {
        ObjectNode fromObject = null;
        try {
            fromObject = (ObjectNode)JsonUtil.toJsonNode((Object)option);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayNode bindAry = null;
        if (fromObject.has("bind")) {
            bindAry = (ArrayNode)fromObject.get("bind");
        }
        ObjectNode bindObj = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isNotEmpty((Object)bindAry)) {
            for (JsonNode jobject : bindAry) {
                String jsonPath;
                String key;
                String string = key = jobject.has("key") ? jobject.get("key").asText() : "";
                if (!jobject.has("jsonPath") || StringUtil.isEmpty((String)(jsonPath = jobject.get("jsonPath").asText()))) continue;
                String path = "data.";
                if (tag.booleanValue()) {
                    path = "data.";
                }
                path = path + jsonPath;
                bindObj.put(key, path);
            }
        }
        return bindObj.toString().replaceAll("\"", "'");
    }

    public String getHtSelectorType(Object option, Boolean tag) {
        String result;
        if (BeanUtils.isEmpty((Object)option)) {
            return "{}";
        }
        ObjectNode fromObject = null;
        try {
            fromObject = (ObjectNode)JsonUtil.toJsonNode((Object)option);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tag == null) {
            tag = false;
        }
        ObjectNode returnObj = JsonUtil.getMapper().createObjectNode();
        JsonNode selectorObj = fromObject.get("selector");
        if (BeanUtils.isNotEmpty((Object)selectorObj)) {
            JsonNode typeObj = null;
            if (selectorObj.has("type")) {
                typeObj = selectorObj.get("type");
            }
            if (BeanUtils.isNotEmpty(typeObj)) {
                returnObj.put("type", typeObj.has("alias") ? typeObj.get("alias").asText() : "");
            }
        }
        if (BeanUtils.isEmpty((Object)returnObj.get("type"))) {
            return "{}";
        }
        switch (result = returnObj.get("type").asText()) {
            case "eip-user-selector": {
                result = "ht-user-selector-input";
                break;
            }
            case "eip-org-selector": {
                result = "ht-org-selector-input";
                break;
            }
            case "eip-post-selector": {
                result = "ht-post-selector-input";
                break;
            }
            case "eip-role-selector": {
                result = "ht-role-selector-input";
                break;
            }
            case "eip-job-selector": {
                result = "ht-job-selector-input";
            }
        }
        return result;
    }

    public String getSelectQuery(Object option, Boolean isSub) throws IOException {
        if (isSub == null) {
            isSub = false;
        }
        if (BeanUtils.isEmpty((Object)option)) {
            return "{}";
        }
        ObjectNode returnObj = JsonUtil.getMapper().createObjectNode();
        ObjectNode fromObject = null;
        try {
            fromObject = (ObjectNode)JsonUtil.toJsonNode((Object)option);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ObjectNode customQuery = null;
        if (fromObject.has("customQuery")) {
            customQuery = (ObjectNode)fromObject.get("customQuery");
        }
        if (BeanUtils.isNotEmpty(customQuery)) {
            returnObj.put("alias", customQuery.has("alias") ? customQuery.get("alias").asText() : "");
            returnObj.put("valueBind", customQuery.has("valueBind") ? customQuery.get("valueBind").asText() : "");
            returnObj.put("noInit", customQuery.has("noInit") ? customQuery.get("noInit").asText() : "");
            returnObj.put("labelBind", customQuery.has("labelBind") ? customQuery.get("labelBind").asText() : "");
            returnObj.put("PId", customQuery.has("PId") ? customQuery.get("PId").asText() : "");
            if (fromObject.has("gangedBind")) {
                returnObj.put("gangedBind", fromObject.has("gangedBind") ? JsonUtil.toJson((Object)fromObject.get("gangedBind")) : "");
            }
        }
        ArrayNode bindAry = null;
        if (fromObject.has("bind")) {
            bindAry = (ArrayNode)fromObject.get("bind");
        }
        ObjectNode bindObj = JsonUtil.getMapper().createObjectNode();
        if (bindAry != null) {
            for (JsonNode jobject : bindAry) {
                String key;
                ObjectNode target = null;
                if (jobject.has("json")) {
                    target = (ObjectNode)jobject.get("json");
                }
                String string = key = jobject.has("field") ? jobject.get("field").asText() : "";
                if (BeanUtils.isEmpty((Object)target)) {
                    ObjectNode valueObj;
                    String fieldPath;
                    String string2 = fieldPath = jobject.has("fieldPath") ? jobject.get("fieldPath").asText() : "";
                    if (jobject.has("bindType") && "2".equals(jobject.get("bindType").asText())) {
                        valueObj = JsonUtil.getMapper().createObjectNode();
                        valueObj.put("default", fieldPath);
                        bindObj.set(key, (JsonNode)valueObj);
                        continue;
                    }
                    if (jobject.has("bindType") && "3".equals(jobject.get("bindType").asText())) {
                        valueObj = JsonUtil.getMapper().createObjectNode();
                        valueObj.put("groovyScript", fieldPath);
                        bindObj.set(key, (JsonNode)valueObj);
                        continue;
                    }
                    if (jobject.has("default")) {
                        valueObj = JsonUtil.getMapper().createObjectNode();
                        valueObj.put("key", fieldPath);
                        valueObj.set("default", jobject.get("default"));
                        bindObj.set(key, (JsonNode)valueObj);
                        continue;
                    }
                    bindObj.put(key, fieldPath);
                    continue;
                }
                String jsonPath = target.has("path") ? target.get("path").asText() : "";
                String path = "data.";
                if (isSub.booleanValue() && !StringUtil.equals((String)jsonPath, (String)"searchForm")) {
                    path = "item.";
                } else {
                    path = path + (target.has("path") ? target.get("path").asText() : "");
                    path = path + ".";
                }
                path = path + (target.has("name") ? target.get("name").asText() : "");
                bindObj.put(key, path);
            }
        }
        returnObj.set("bind", (JsonNode)bindObj);
        String returnStr = returnObj.toString();
        if (StringUtil.isEmpty((String)returnStr)) {
            returnStr = "";
        }
        return returnStr.replaceAll("\"", "'");
    }

    public String getFieldGanged(String ptName, String gangedStr) {
        String returnStr = "";
        try {
            ArrayNode returnArray = JsonUtil.getMapper().createArrayNode();
            ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)gangedStr);
            if (BeanUtils.isNotEmpty((Object)array)) {
                for (JsonNode obj : array) {
                    ArrayNode chooseFields = (ArrayNode)obj.get("chooseField");
                    for (JsonNode chooseField : chooseFields) {
                        if (!ptName.equals(chooseField.get("pathName").asText())) continue;
                        returnArray.add(obj);
                    }
                }
            }
            if (BeanUtils.isNotEmpty((Object)returnArray)) {
                returnStr = "ht-ganged=\"" + returnArray.toString().replaceAll("\"", "'") + "\"";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnStr;
    }

    public String getSeparator(String separator) {
        String returnStr = "";
        try {
            if (StringUtil.isNotEmpty((String)separator)) {
                returnStr = "group='" + separator + "'";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnStr;
    }

    public String getPermissionNgif(Object field) {
        try {
            JsonNode fieldJson = JsonUtil.toJsonNode((Object)field);
            if (fieldJson.has("boAttrId")) {
                return "ng-if=\"permission.fields." + fieldJson.get("tableName").asText() + "." + fieldJson.get("name").asText() + "!='n'\"";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "ng-if='true'";
    }

    public boolean hasShowCol(List<Map<String, Object>> cols) {
        if (BeanUtils.isEmpty(cols)) {
            return false;
        }
        int hideCount = 0;
        for (Map<String, Object> m : cols) {
            if (!BeanUtils.isNotEmpty(m) || !BeanUtils.isNotEmpty((Object)m.get("list"))) continue;
            List list = (List)m.get("list");
            for (Map l : list) {
                Map o = (Map)l.get("options");
                if (BeanUtils.isNotEmpty(l.get("ctrlType")) && BeanUtils.isNotEmpty(o.get("hideCtrl")) && ((Boolean)o.get("hideCtrl")).booleanValue()) continue;
                return true;
            }
        }
        return hideCount != cols.size();
    }

    public String getTrPermission(List<Map<String, Object>> cols) {
        if (BeanUtils.isEmpty(cols)) {
            return "false";
        }
        ArrayList<String> tdPrs = new ArrayList<String>();
        for (Map<String, Object> m : cols) {
            if (!BeanUtils.isNotEmpty(m) || !BeanUtils.isNotEmpty((Object)m.get("list"))) continue;
            List list = (List)m.get("list");
            for (Map l : list) {
                Map o = (Map)l.get("options");
                if (BeanUtils.isNotEmpty(l.get("ctrlType")) && "htCustomComponent".equals(l.get("ctrlType"))) continue;
                tdPrs.add("permission.fields." + l.get("tableName").toString() + "." + l.get("name").toString() + " != 'n'");
            }
        }
        return StringUtil.join(tdPrs, (String)" || ");
    }

    public String getStringConf(Object o) {
        if (BeanUtils.isEmpty((Object)o)) {
            return "";
        }
        try {
            return JsonUtil.toJson((Object)o);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getIncludeFiles(String files) throws Exception {
        return "";
    }

    public String getCustDialogAttr(String colPrefix, Object f) throws IOException {
        JsonNode field = null;
        try {
            field = JsonUtil.toJsonNode((Object)f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JsonNode controlContent = field.get("controlContent");
        if (controlContent instanceof TextNode) {
            controlContent = JsonUtil.toJsonNode((String)controlContent.asText());
        }
        if (BeanUtils.isNotEmpty((Object)controlContent)) {
            String alias = controlContent.get("alias").asText();
            CustomDialog customDialog = null;
            if (StringUtil.isNotEmpty((String)alias)) {
                try {
                    CustomDialogManager customDialogManager = (CustomDialogManager)AppUtil.getBean(CustomDialogManager.class);
                    customDialog = customDialogManager.getByAlias(alias);
                    if (BeanUtils.isNotEmpty((Object)((Object)customDialog))) {
                        String resultField = "";
                        if (controlContent.hasNonNull("resultField")) {
                            resultField = controlContent.get("resultField").asText();
                        } else if (controlContent.hasNonNull("resultfield")) {
                            resultField = controlContent.get("resultfield").asText();
                        }
                        ObjectNode custDialog = JsonUtil.getMapper().createObjectNode();
                        custDialog.put("custQueryJson", (JsonNode)JsonUtil.getMapper().createArrayNode());
                        custDialog.put("alias", alias);
                        custDialog.put("type", "custDialog");
                        if (field.has("bind") && field.get("bind").isArray()) {
                            custDialog.set("conditions", field.get("bind"));
                        } else {
                            custDialog.set("conditions", (JsonNode)JsonUtil.getMapper().createArrayNode());
                        }
                        custDialog.set("resultField", JsonUtil.toJsonNode((String)customDialog.getResultfield()));
                        ArrayNode mappingConf = JsonUtil.getMapper().createArrayNode();
                        ArrayNode mappingConfs = JsonUtil.getMapper().createArrayNode();
                        ObjectNode dialogConf = JsonUtil.getMapper().createObjectNode();
                        ObjectNode mapping = JsonUtil.getMapper().createObjectNode();
                        mapping.put("from", resultField);
                        if (colPrefix == null) {
                            colPrefix = "";
                        }
                        if (field.hasNonNull("na")) {
                            mapping.set("target", (JsonNode)mappingConfs.add(colPrefix + field.get("na").asText()));
                        }
                        if (field.has("custDialogprop") && field.get("custDialogprop").isObject()) {
                            JsonNode custDialogprop = field.get("custDialogprop");
                            Iterator it = custDialogprop.fields();
                            while (it.hasNext()) {
                                Map.Entry entry = (Map.Entry)it.next();
                                if (!StringUtil.isNotEmpty((String)((JsonNode)entry.getValue()).asText())) continue;
                                ObjectNode mapping1 = JsonUtil.getMapper().createObjectNode();
                                ArrayNode mappingConfs1 = JsonUtil.getMapper().createArrayNode();
                                mapping1.put("from", (String)entry.getKey());
                                mapping1.set("target", (JsonNode)mappingConfs1.add((JsonNode)entry.getValue()));
                                mappingConf.add((JsonNode)mapping1);
                            }
                        }
                        mappingConf.add((JsonNode)mapping);
                        custDialog.set("mappingConf", (JsonNode)mappingConf);
                        dialogConf.set("custDialog", (JsonNode)custDialog);
                        dialogConf.set("resultField", JsonUtil.toJsonNode((String)customDialog.getResultfield()));
                        dialogConf.put("name", "\u9009\u62e9");
                        dialogConf.put("icon", "el-icon-search");
                        dialogConf.put("forSearch", true);
                        return JsonUtil.toJson((Object)dialogConf);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public String getStyleBold(Object field, String attr) {
        String sty = "normal";
        JsonNode fieldJson = null;
        try {
            fieldJson = JsonUtil.toJsonNode((Object)field);
            if (BeanUtils.isNotEmpty((Object)fieldJson.get(attr))) {
                sty = fieldJson.get(attr).asBoolean() ? "bold" : "normal";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sty;
    }

    public String getStyles(Object field, String name, String attr) {
        String sty = "";
        JsonNode fieldJson = null;
        try {
            fieldJson = JsonUtil.toJsonNode((Object)field);
            if (BeanUtils.isNotEmpty((Object)fieldJson.get(attr)) && !fieldJson.get(attr).isNull()) {
                if ("textSize".equals(attr)) {
                    sty = name + ":" + fieldJson.get(attr).asText() + "px;";
                } else if ("lableColor".equals(attr)) {
                    String lableColor = fieldJson.get(attr).asText();
                    if (!"#969799".equals(lableColor)) {
                        sty = name + ":" + lableColor + ";";
                    }
                } else {
                    sty = name + ":" + fieldJson.get(attr).asText() + ";";
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sty;
    }

    public String getAttrText(Object field, String options, String attr) {
        String sty = "";
        JsonNode fieldJson = null;
        try {
            fieldJson = JsonUtil.toJsonNode((Object)field);
            if (BeanUtils.isNotEmpty((Object)fieldJson.get(options).get(attr)) && !fieldJson.get(options).get(attr).isNull()) {
                sty = fieldJson.get(options).get(attr).asText();
            }
            if ("customWidth".equals(attr) || "customHeight".equals(attr)) {
                sty = "100%";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sty;
    }

    public String getTextFixedStyles(Object field, String name, String attr) {
        String sty = "";
        JsonNode fieldJson = null;
        try {
            fieldJson = JsonUtil.toJsonNode((Object)field);
            if (BeanUtils.isNotEmpty((Object)fieldJson.get(attr)) && !fieldJson.get(attr).isNull()) {
                sty = "textFixedSize".equals(attr) ? name + ":" + fieldJson.get(attr).asText() + "px;" : name + ":" + fieldJson.get(attr).asText() + ";";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sty;
    }

    public boolean getRequired(Object field) {
        boolean isRequired = false;
        try {
            ObjectNode validate;
            JsonNode fieldJson = JsonUtil.toJsonNode((Object)field);
            if (BeanUtils.isNotEmpty((Object)fieldJson.get("validRule")) && (validate = (ObjectNode)fieldJson.get("validRule")).has("required")) {
                isRequired = validate.get("required").asBoolean();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isRequired;
    }

    public String getWidth(Integer maxCol, Integer col) {
        if (maxCol == 1) {
            return "80%";
        }
        if (col == 2) {
            return "40%";
        }
        if (col == 3) {
            return "23%";
        }
        if (col == 4) {
            return "15%";
        }
        return "";
    }

    public String getColspan(Integer maxCol, Integer col, Integer index, Boolean isText) {
        String result = "";
        if (maxCol < 1 || col < 1 || index < 1 || maxCol <= col || index > col || maxCol > 4) {
            return result;
        }
        switch (maxCol - col) {
            case 1: {
                if (!col.equals(index)) break;
                result = "colspan=\"3\"";
                if (!isText.booleanValue()) break;
                result = "colspan=\"4\"";
                break;
            }
            case 2: {
                if (maxCol == 3) {
                    result = "colspan=\"7\"";
                    if (!isText.booleanValue()) break;
                    result = "colspan=\"6\"";
                    break;
                }
                if (maxCol != 4) break;
                result = "colspan=\"3\"";
                if (!isText.booleanValue()) break;
                result = "colspan=\"4\"";
                break;
            }
            case 3: {
                result = "colspan=\"7\"";
                if (!isText.booleanValue()) break;
                result = "colspan=\"8\"";
                break;
            }
        }
        return result;
    }

    public String getBase64(String str) throws UnsupportedEncodingException {
        if (StringUtil.isNotEmpty((String)str)) {
            return Base64.getBase64((String)str);
        }
        return str;
    }

    public String decodeBase64(String str) throws UnsupportedEncodingException {
        if (StringUtil.isNotEmpty((String)str)) {
            return Base64.getFromBase64((String)str);
        }
        return str;
    }

    public String getMapString(Object field, String attr) {
        String result = "{}";
        try {
            JsonNode fieldJson = JsonUtil.toJsonNode((Object)field);
            if (BeanUtils.isNotEmpty((Object)fieldJson.has(attr))) {
                JsonNode jsonNode = fieldJson.get(attr);
                if (BeanUtils.isEmpty((Object)jsonNode)) {
                    return result;
                }
                result = jsonNode.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String objectToJsonString(Object obj) throws IOException {
        return JsonUtil.toJson((Object)obj);
    }

    public String getFieldStyle(Object field) throws IOException {
        ObjectNode fieldJson = (ObjectNode)JsonUtil.toJsonNode((Object)field);
        boolean boldLable = JsonUtil.getBoolean((ObjectNode)fieldJson, (String)"boldLable", (boolean)false);
        String lableColor = JsonUtil.getString((JsonNode)fieldJson, (String)"lableColor", (String)"");
        StringBuffer str = new StringBuffer();
        if (boldLable) {
            str.append("font-weight:bolder;");
            str.append("font-size:small;");
        }
        if (StringUtil.isNotEmpty((String)lableColor) && !DEFAULT_LABEL_COLOR.equals(lableColor)) {
            str.append("color:");
            str.append(lableColor + ";");
        }
        return str.toString();
    }

    public String getDiyColorOrNull(Object field) throws IOException {
        ObjectNode fieldJson = (ObjectNode)JsonUtil.toJsonNode((Object)field);
        String lableColor = JsonUtil.getString((JsonNode)fieldJson, (String)"lableColor", (String)"");
        if (!DEFAULT_LABEL_COLOR.equals(lableColor)) {
            return "color:" + lableColor + " !important;";
        }
        return "";
    }

    public String getSunTablePath(String path, String indexStr) throws IOException {
        String[] paths;
        if (StringUtil.isNotEmpty((String)path) && (paths = path.split("\\.")).length == 3) {
            return paths[0] + "." + paths[1] + "[" + indexStr + "]." + paths[2];
        }
        return path;
    }

    public String getSubName(String path, String indexStr) throws IOException {
        String[] paths;
        if (StringUtil.isNotEmpty((String)path) && (paths = path.split("\\.")).length == 3) {
            return paths[0] + "." + paths[1] + "['+" + indexStr + "+']." + paths[2];
        }
        return path;
    }

    public String getSubTableCols(Object cols) throws IOException {
        ArrayNode colsConf = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)cols)) {
            ArrayNode colsNode = (ArrayNode)JsonUtil.toJsonNode((Object)cols);
            for (JsonNode col : colsNode) {
                ObjectNode colConf = JsonUtil.getMapper().createObjectNode();
                colConf.put("name", JsonUtil.getString((JsonNode)col, (String)"name"));
                colConf.put("desc", JsonUtil.getString((JsonNode)col, (String)"desc"));
                colConf.put("ctrlType", JsonUtil.getString((JsonNode)col, (String)"ctrlType"));
                colsConf.add((JsonNode)colConf);
            }
        }
        return this.toJsonStr(colsConf);
    }

    public String toJsonStr(Object object) throws IOException {
        String str = "";
        str = object instanceof String ? (String)object : JsonUtil.toJson((Object)object);
        if (StringUtil.isNotEmpty((String)str)) {
            str = Base64.getBase64((String)str);
        }
        return str;
    }

    public String getSunBos(List<ObjectNode> list) throws IOException {
        String str = "";
        if (BeanUtils.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                String ctrlType = JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)list.get(i))).get("ctrlType").asText();
                if (!"suntable".equals(ctrlType) && !"sunDiv".equals(ctrlType)) continue;
                str = str + JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)list.get(i))).get("name").asText() + ",";
            }
        }
        if (StringUtil.isNotEmpty((String)str)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public int getMergeCellSize(Object options) throws IOException {
        int size = 0;
        try {
            JsonNode optionsNode;
            if (BeanUtils.isNotEmpty((Object)options) && BeanUtils.isNotEmpty((Object)(optionsNode = JsonUtil.toJsonNode((Object)options)).get("colHeadersRelations"))) {
                ArrayNode colHeadersRelations = (ArrayNode)optionsNode.get("colHeadersRelations");
                for (JsonNode jsonNode : colHeadersRelations) {
                    ObjectNode node;
                    if (!BeanUtils.isNotEmpty((Object)jsonNode.get("column")) || !BeanUtils.isNotEmpty((Object)(node = (ObjectNode)jsonNode.get("column")).get("mergeCell")) || !node.get("mergeCell").asBoolean()) continue;
                    ++size;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public int getHasMathExp(Object options) throws IOException {
        int is;
        block6: {
            is = 0;
            try {
                JsonNode cellCalcs;
                if (!BeanUtils.isNotEmpty((Object)options)) break block6;
                JsonNode optionsNode = JsonUtil.toJsonNode((Object)options);
                if (optionsNode.has("cellCalcs") && (cellCalcs = optionsNode.get("cellCalcs")).size() > 0) {
                    is = 1;
                }
                if (is != 0 || !BeanUtils.isNotEmpty((Object)optionsNode.get("colHeadersRelations"))) break block6;
                ArrayNode colHeadersRelations = (ArrayNode)optionsNode.get("colHeadersRelations");
                for (JsonNode jsonNode : colHeadersRelations) {
                    if (!BeanUtils.isNotEmpty((Object)jsonNode.get("column"))) continue;
                    ObjectNode node = (ObjectNode)jsonNode.get("column");
                    if (BeanUtils.isNotEmpty((Object)node.get("mathExp")) && StringUtil.isNotEmpty((String)node.get("mathExp").asText())) {
                        is = 1;
                    } else {
                        ArrayNode array;
                        if (!BeanUtils.isNotEmpty((Object)node.get("rowMathExp")) || !StringUtil.isNotEmpty((String)node.get("rowMathExp").asText()) || (array = (ArrayNode)node.get("rowMathExp")).size() <= 0) continue;
                        is = 1;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return is;
    }

    public int getHasCrossMapping(Object options) throws IOException {
        int is = 0;
        try {
            ArrayNode crossMapping;
            JsonNode optionsNode;
            if (BeanUtils.isNotEmpty((Object)options) && BeanUtils.isNotEmpty((Object)(optionsNode = JsonUtil.toJsonNode((Object)options)).get("crossMapping")) && (crossMapping = (ArrayNode)optionsNode.get("crossMapping")).size() > 0) {
                is = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public String getBoDefAlias(Object field) throws IOException {
        String bDefAlias = "";
        try {
            if (BeanUtils.isNotEmpty((Object)field)) {
                JsonNode fieldNode = JsonUtil.toJsonNode((Object)field);
                if (BeanUtils.isNotEmpty((Object)fieldNode.get("boDefAlias"))) {
                    bDefAlias = fieldNode.get("boDefAlias").asText();
                } else if (BeanUtils.isNotEmpty((Object)fieldNode.get("options")) && BeanUtils.isNotEmpty((Object)fieldNode.get("options").get("boDefAlias"))) {
                    bDefAlias = fieldNode.get("options").get("boDefAlias").asText();
                } else if (BeanUtils.isNotEmpty((Object)fieldNode.get("fieldPath"))) {
                    String[] fieldPaths = fieldNode.get("fieldPath").asText().split("\\.");
                    bDefAlias = fieldPaths[0];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bDefAlias;
    }

    public String getJsonStr(String str) throws IOException {
        if (StringUtil.isNotEmpty((String)str)) {
            return JsonUtil.toJson((Object)str);
        }
        return "";
    }

    public int getMainTableColSum(Object rows) throws IOException {
        int colspanSum = 0;
        if (BeanUtils.isNotEmpty((Object)rows)) {
            ArrayNode rowsNode = (ArrayNode)JsonUtil.toJsonNode((Object)rows);
            ArrayNode colsNode = (ArrayNode)rowsNode.get(0).findValue("cols");
            for (JsonNode col : colsNode) {
                colspanSum += col.get("colspan").asInt();
            }
        }
        return colspanSum;
    }

    public Map<String, Object> getFirstColSum(Object rows) throws IOException {
        if (BeanUtils.isEmpty((Object)rows)) {
            return MapUtil.newHashMap();
        }
        ArrayNode rowsNode = (ArrayNode)JsonUtil.toJsonNode((Object)rows);
        if (BeanUtils.isEmpty((Object)rowsNode)) {
            return MapUtil.newHashMap();
        }
        ObjectNode maxColNode = JsonUtil.createObjectNode();
        int max = 0;
        for (JsonNode row : rowsNode) {
            int cols;
            if (!row.has("cols") || max >= (cols = row.get("cols").size())) continue;
            max = cols;
            maxColNode = row;
        }
        return (Map)JsonUtil.toBean((JsonNode)maxColNode, Map.class);
    }

    public boolean getHasLinkage(Object data) {
        if (BeanUtils.isNotEmpty((Object)data)) {
            try {
                ArrayNode listNodes = (ArrayNode)JsonUtil.toJsonNode((Object)data);
                for (JsonNode jsonNode : listNodes) {
                    ArrayNode linkageArray;
                    ObjectNode options;
                    if (BeanUtils.isNotEmpty((Object)jsonNode.get("ctrlType")) && "grid".equals(jsonNode.get("ctrlType").asText())) {
                        if (!BeanUtils.isNotEmpty((Object)jsonNode.get("columns"))) continue;
                        ArrayNode columnNodes = (ArrayNode)jsonNode.get("columns");
                        for (JsonNode column : columnNodes) {
                            if (!BeanUtils.isNotEmpty((Object)column.get("list"))) continue;
                            ArrayNode list = (ArrayNode)column.get("list");
                            for (JsonNode item : list) {
                                ArrayNode linkageArray2;
                                ObjectNode options2 = (ObjectNode)item.get("options");
                                if (!options2.has("linkage") || !BeanUtils.isNotEmpty((Object)options2.get("linkage")) || (linkageArray2 = (ArrayNode)options2.get("linkage")).size() <= 0) continue;
                                return true;
                            }
                        }
                        continue;
                    }
                    if (!BeanUtils.isNotEmpty((Object)jsonNode.get("options")) || !(options = (ObjectNode)jsonNode.get("options")).has("linkage") || !BeanUtils.isNotEmpty((Object)options.get("linkage")) || (linkageArray = (ArrayNode)options.get("linkage")).size() <= 0) continue;
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getSubRowPermission(Object columns) {
        if (BeanUtils.isNotEmpty((Object)columns)) {
            try {
                ArrayNode colArray = (ArrayNode)JsonUtil.toJsonNode((Object)columns);
                StringBuilder permissions = new StringBuilder();
                int size = 0;
                for (JsonNode jsonNode : colArray) {
                    ArrayNode list = (ArrayNode)jsonNode.get("list");
                    for (JsonNode iNode : list) {
                        if (size > 0) {
                            permissions.append(" && ");
                        }
                        permissions.append(" " + this.getSubPermissionPath(iNode) + " ");
                        ++size;
                    }
                }
                return permissions.toString();
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u6805\u683c\u5e03\u5c40\u5b50\u8868\u6216\u5b59\u8868\u6743\u9650\u8def\u5f84\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return "";
    }

    private String getSubPermissionPath(JsonNode field) {
        String parentNodeType = BeanUtils.isNotEmpty((Object)field.get("parentNodeType")) ? field.get("parentNodeType").asText() : "sun";
        String indexStr = "sub".equals(parentNodeType) ? "$index" : "$index+'_'+sunIndex";
        String path = parentNodeType + "_" + field.get("tableName").asText() + "_" + field.get("name").asText() + "_";
        return "permission.subFields['" + path + "'+" + indexStr + "]=='n'";
    }

    public boolean isNoAttrField(Object o) {
        boolean is = false;
        if (BeanUtils.isNotEmpty((Object)o)) {
            try {
                JsonNode field = JsonUtil.toJsonNode((Object)o);
                if (BeanUtils.isNotEmpty((Object)field.get("ctrlType")) && (noAttrFields.contains(field.get("ctrlType").asText()) || allowNoAttributes.contains(field.get("ctrlType").asText())) && field.hasNonNull("tableName") && field.hasNonNull("boDefAlias") && field.hasNonNull("name")) {
                    is = true;
                }
                if (!is && field.has("options")) {
                    ObjectNode options = (ObjectNode)field.get("options");
                    is = JsonUtil.getBoolean((ObjectNode)options, (String)NO_BIND_MODEL, (boolean)false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("\u5224\u65ad\u662f\u5426\u65e0\u5c5e\u6027\u5b57\u6bb5\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return is;
    }

    public String getTableHiddenCondition(Object rows) throws IOException {
        if (BeanUtils.isNotEmpty((Object)rows)) {
            try {
                StringBuilder conditionStr = new StringBuilder();
                String basePermissionPath = "permission.fields";
                ArrayNode rowsNode = (ArrayNode)JsonUtil.toJsonNode((Object)rows);
                for (JsonNode row : rowsNode) {
                    ArrayNode cols = (ArrayNode)row.get("cols");
                    for (JsonNode col : cols) {
                        ArrayNode list = (ArrayNode)col.get("list");
                        for (JsonNode item : list) {
                            String tableName = item.get("tableName").asText();
                            String name = item.get("name").asText();
                            String fieldCondition = basePermissionPath + "." + tableName + "." + name + " != 'n'";
                            if (conditionStr.length() > 0) {
                                conditionStr.append(" || ");
                            }
                            conditionStr.append(fieldCondition);
                        }
                    }
                }
                return conditionStr.toString();
            }
            catch (Exception e) {
                logger.error("\u5224\u65adtable\u5e03\u5c40\u4e2d\u7684\u5b57\u6bb5\u662f\u5426\u90fd\u4e3a\u9690\u85cf\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return "true";
    }

    public static String getQueryDataViewOperation(String operate) {
        switch (operate) {
            case "EQ": {
                return QueryOP.EQUAL.name();
            }
            case "NE": {
                return QueryOP.NOT_EQUAL.name();
            }
            case "LK": {
                return QueryOP.LIKE.name();
            }
            case "LFK": {
                return QueryOP.LEFT_LIKE.name();
            }
            case "RHK": {
                return QueryOP.RIGHT_LIKE.name();
            }
            case "BETWEEN": {
                return QueryOP.BETWEEN.name();
            }
        }
        return QueryOP.LIKE.name();
    }

    public boolean fieldPermissionValidation(String type, Map<String, Object> managePermission, String desc, String ... params) {
        String key = null;
        try {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList("batchSave", "addData", "addFlow", "searchData", "edit"));
            if (list.contains(type)) {
                key = String.format("%s_%s", type, desc);
                return MapUtil.getBool(managePermission, (Object)key, (Boolean)false);
            }
            switch (type) {
                case "js": {
                    String jsValue = params[0];
                    if (StringUtil.isNotEmpty((String)jsValue)) {
                        String finalStr = String.format("%s_%s", desc, jsValue);
                        String jsValMd5 = EncryptUtil.md5Hex((String)finalStr);
                        key = String.format("js_%s", jsValMd5);
                    }
                    break;
                }
                case "url": {
                    String url = params[0];
                    String urlParams = params[1];
                    String fullUrl = String.format("%s_%s", url, urlParams);
                    if (StringUtil.isNotEmpty((String)fullUrl)) {
                        String finalStr = String.format("%s_%s", desc, fullUrl);
                        String fullMd5 = EncryptUtil.md5Hex((String)finalStr);
                        key = String.format("url_%s", fullMd5);
                    }
                    break;
                }
                case "switch": {
                    String switchOn = params[0];
                    String switchOff = params[1];
                    String switchVal = String.format("%s_%s", switchOn, switchOff);
                    if (StringUtil.isNotEmpty((String)switchVal)) {
                        String finalStr = String.format("%s_%s", desc, switchVal);
                        String fullMd5 = EncryptUtil.md5Hex((String)finalStr);
                        key = String.format("switch_%s", fullMd5);
                    }
                    break;
                }
                case "batchUpdate": {
                    String batchUpdateData = params[0];
                    if (BeanUtils.isEmpty((Object)batchUpdateData)) {
                        batchUpdateData = params[1];
                    }
                    if (StringUtil.isNotEmpty((String)batchUpdateData)) {
                        String finalStr = String.format("%s_%s", desc, batchUpdateData);
                        String jsValMd5 = EncryptUtil.md5Hex((String)finalStr);
                        key = String.format("batchUpdate_%s", jsValMd5);
                    }
                    break;
                }
                default: {
                    key = type;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5224\u65adjs\u6309\u94ae\u3001url\u6309\u94ae\u3001\u5f00\u5173\u6309\u94ae\u3001\u66f4\u65b0\u6570\u636e\u6309\u94ae\u6743\u9650\u65f6\u62a5\u9519\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
        if (StringUtil.isEmpty((String)key)) {
            return false;
        }
        return MapUtil.getBool(managePermission, (Object)key, (Boolean)false);
    }

    public List<Map<String, Object>> getPermissionManageFields(List<Map<String, Object>> manageFields, Map<String, Object> managePermission, String position, boolean hasSub) {
        if (BeanUtils.isEmpty(manageFields)) {
            return new ArrayList<Map<String, Object>>();
        }
        return manageFields.stream().filter(item -> {
            switch (MapUtil.getStr((Map)item, (Object)"name", (String)"")) {
                case "js": {
                    return this.fieldPermissionValidation("js", managePermission, MapUtil.getStr((Map)item, (Object)"desc"), MapUtil.getStr((Map)item, (Object)"jsValue")) && MapUtil.getBool((Map)item, (Object)position, (Boolean)false) != false;
                }
                case "url": {
                    return this.fieldPermissionValidation("url", managePermission, MapUtil.getStr((Map)item, (Object)"desc"), MapUtil.getStr((Map)item, (Object)"url"), MapUtil.getStr((Map)item, (Object)"urlParams")) && MapUtil.getBool((Map)item, (Object)position, (Boolean)false) != false;
                }
                case "switch": {
                    return this.fieldPermissionValidation("switch", managePermission, MapUtil.getStr((Map)item, (Object)"desc"), MapUtil.getStr((Map)item, (Object)"switchOn"), MapUtil.getStr((Map)item, (Object)"switchOff")) && MapUtil.getBool((Map)item, (Object)position, (Boolean)false) != false;
                }
                case "batchUpdate": {
                    return this.fieldPermissionValidation("batchUpdate", managePermission, MapUtil.getStr((Map)item, (Object)"desc"), MapUtil.getStr((Map)item, (Object)"batchUpdateData"), MapUtil.getStr((Map)item, (Object)"relationConfig")) && MapUtil.getBool((Map)item, (Object)position, (Boolean)false) != false;
                }
                case "batchSave": {
                    return this.fieldPermissionValidation(item.get("name").toString(), managePermission, MapUtil.getStr((Map)item, (Object)"buttonId"), "");
                }
                case "addData": 
                case "addFlow": 
                case "searchData": 
                case "edit": {
                    return this.fieldPermissionValidation(item.get("name").toString(), managePermission, MapUtil.getStr((Map)item, (Object)"buttonId"), "") && MapUtil.getBool((Map)item, (Object)position, (Boolean)false) != false;
                }
                case "add": 
                case "import": 
                case "export": {
                    return MapUtil.getBool((Map)managePermission, (Object)MapUtil.getStr((Map)item, (Object)"name"), (Boolean)false);
                }
                case "sub": {
                    return MapUtil.getBool((Map)managePermission, (Object)MapUtil.getStr((Map)item, (Object)"name"), (Boolean)false) != false && hasSub && MapUtil.getBool((Map)item, (Object)position, (Boolean)false) != false;
                }
            }
            return MapUtil.getBool((Map)managePermission, (Object)MapUtil.getStr((Map)item, (Object)"name"), (Boolean)false) != false && MapUtil.getBool((Map)item, (Object)position, (Boolean)false) != false;
        }).collect(Collectors.toList());
    }

    public Integer getNumber(Object src, Integer defaultNum) {
        defaultNum = defaultNum == null ? 0 : defaultNum;
        if (src == null) {
            return defaultNum;
        }
        if (src.toString() == "") {
            return defaultNum;
        }
        try {
            return Integer.valueOf(String.valueOf(src));
        }
        catch (Exception e) {
            return defaultNum;
        }
    }

    public Number parseNumber(Object src, Number defaultNum) {
        if (src == null) {
            return defaultNum;
        }
        if (src instanceof Number) {
            return (Number)src;
        }
        try {
            return NumberUtil.parseNumber((String)src.toString());
        }
        catch (Exception e) {
            return defaultNum;
        }
    }

    public Boolean includes(String str, String item) {
        if (StringUtil.isEmpty((String)str) || StringUtil.isEmpty((String)item)) {
            return false;
        }
        List<String> list = Arrays.asList(str.split(","));
        return list.contains(item);
    }
}

