/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.form.param.GenerateExpandParam;
import com.hotent.form.param.TemplateEntParam;
import com.hotent.form.service.control.IControlType;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerateExpandUtil {
    public static String LAYOUT_GRID = "grid";
    public static String LAYOUT_TABLE = "table";
    public static String LAYOUT_HOT_TABLE = "hottable";
    public static String LAYOUT_DIV = "div";

    public static ArrayNode getLayoutList(GenerateExpandParam params, List<BoDef> defList) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        HashMap<String, TemplateEntParam> templateMap = new HashMap<String, TemplateEntParam>();
        for (TemplateEntParam entParam : params.getEntList()) {
            templateMap.put(entParam.getAlias(), entParam);
        }
        for (BoDef boDef : defList) {
            BoEnt mainEnt = boDef.getBoEnt();
            List<BoAttribute> mainAttr = mainEnt.getBoAttrList();
            TemplateEntParam mainParam = (TemplateEntParam)templateMap.get(mainEnt.getName());
            int mainColumn = mainParam.getColumn();
            int span = 24 / mainColumn;
            String mainTemplate = mainParam.getTemplate();
            if (BeanUtils.isNotEmpty((Object)mainAttr)) {
                mainAttr = GenerateExpandUtil.getActiveAttr(mainAttr);
                ArrayNode columns = null;
                if (LAYOUT_GRID.equals(mainTemplate)) {
                    for (int i = 0; i < mainAttr.size(); ++i) {
                        ObjectNode gradNode;
                        int index = i + 1;
                        if (columns == null) {
                            columns = JsonUtil.getMapper().createArrayNode();
                        }
                        ObjectNode fieldNode = GenerateExpandUtil.getFieldNode(boDef, null, mainEnt, mainAttr.get(i), "main", mainTemplate);
                        ObjectNode colItem = GenerateExpandUtil.getColItem(fieldNode, span);
                        columns.add((JsonNode)colItem);
                        if (index % mainColumn == 0) {
                            gradNode = GenerateExpandUtil.getLayoutNode(columns, LAYOUT_GRID, "", mainEnt);
                            array.add((JsonNode)gradNode);
                            columns = null;
                            continue;
                        }
                        if (i != mainAttr.size() - 1 || columns == null) continue;
                        GenerateExpandUtil.addLackGrad(columns, span, mainColumn - columns.size());
                        gradNode = GenerateExpandUtil.getLayoutNode(columns, LAYOUT_GRID, "", mainEnt);
                        array.add((JsonNode)gradNode);
                        columns = null;
                    }
                } else if (LAYOUT_TABLE.equals(mainTemplate)) {
                    columns = JsonUtil.getMapper().createArrayNode();
                    ArrayNode colsNodes = null;
                    for (int i = 0; i < mainAttr.size(); ++i) {
                        ObjectNode colsNode;
                        int index = i + 1;
                        if (colsNodes == null) {
                            colsNodes = JsonUtil.getMapper().createArrayNode();
                        }
                        ObjectNode fieldNode = GenerateExpandUtil.getFieldNode(boDef, null, mainEnt, mainAttr.get(i), "main", mainTemplate);
                        ArrayNode listNode = JsonUtil.getMapper().createArrayNode();
                        listNode.add((JsonNode)fieldNode);
                        ObjectNode colTd = JsonUtil.getMapper().createObjectNode();
                        colTd.put("colspan", 1);
                        colTd.set("list", (JsonNode)listNode);
                        colsNodes.add((JsonNode)colTd);
                        if (index % mainColumn == 0) {
                            colsNode = JsonUtil.getMapper().createObjectNode();
                            colsNode.set("cols", (JsonNode)colsNodes);
                            columns.add((JsonNode)colsNode);
                            colsNodes = null;
                            continue;
                        }
                        if (i != mainAttr.size() - 1 || columns == null) continue;
                        GenerateExpandUtil.addLackTd(colsNodes, mainColumn - colsNodes.size());
                        colsNode = JsonUtil.getMapper().createObjectNode();
                        colsNode.set("cols", (JsonNode)colsNodes);
                        columns.add((JsonNode)colsNode);
                    }
                    ObjectNode tableNode = GenerateExpandUtil.getLayoutNode(columns, LAYOUT_TABLE, "", mainEnt);
                    array.add((JsonNode)tableNode);
                }
            }
            List subEnts = mainEnt.getChildEntList();
            for (BoEnt subEnt : subEnts) {
                ObjectNode subTableNode;
                TemplateEntParam subParam = (TemplateEntParam)templateMap.get(subEnt.getName());
                List<BoAttribute> subAttr = subEnt.getBoAttrList();
                ArrayNode fieldList = JsonUtil.getMapper().createArrayNode();
                if (!BeanUtils.isNotEmpty((Object)subAttr)) continue;
                subAttr = GenerateExpandUtil.getActiveAttr(subAttr);
                if (LAYOUT_TABLE.equals(subParam.getTemplate())) {
                    for (BoAttribute subAttribute : subAttr) {
                        ObjectNode fieldNode = GenerateExpandUtil.getFieldNode(boDef, mainEnt, subEnt, subAttribute, "sub", subParam.getTemplate());
                        fieldList.add((JsonNode)fieldNode);
                    }
                    subTableNode = GenerateExpandUtil.getSubTableNode(boDef.getAlias(), subEnt.getRelation(), subEnt.getName(), subEnt.getDesc(), fieldList, LAYOUT_TABLE);
                    List sunEnts = subEnt.getChildEntList();
                    if (BeanUtils.isNotEmpty((Object)sunEnts)) {
                        GenerateExpandUtil.addSunLayout(fieldList, boDef, subEnt, sunEnts, templateMap);
                    }
                    array.add((JsonNode)subTableNode);
                    continue;
                }
                if (LAYOUT_DIV.equals(subParam.getTemplate())) {
                    ArrayNode columns = null;
                    int subColumn = subParam.getColumn();
                    int subSpan = 24 / subColumn;
                    for (int i = 0; i < subAttr.size(); ++i) {
                        ObjectNode gradNode;
                        int index = i + 1;
                        if (columns == null) {
                            columns = JsonUtil.getMapper().createArrayNode();
                        }
                        ObjectNode fieldNode = GenerateExpandUtil.getFieldNode(boDef, mainEnt, subEnt, subAttr.get(i), "sub", mainTemplate);
                        ObjectNode colItem = GenerateExpandUtil.getColItem(fieldNode, subSpan);
                        columns.add((JsonNode)colItem);
                        if (index % subColumn == 0) {
                            gradNode = GenerateExpandUtil.getLayoutNode(columns, LAYOUT_GRID, "sub", subEnt);
                            fieldList.add((JsonNode)gradNode);
                            columns = null;
                            continue;
                        }
                        if (i != subAttr.size() - 1 || columns == null) continue;
                        GenerateExpandUtil.addLackGrad(columns, subSpan, subColumn - columns.size());
                        gradNode = GenerateExpandUtil.getLayoutNode(columns, LAYOUT_GRID, "sub", subEnt);
                        fieldList.add((JsonNode)gradNode);
                        columns = null;
                    }
                    List sunEnts = subEnt.getChildEntList();
                    if (BeanUtils.isNotEmpty((Object)sunEnts)) {
                        GenerateExpandUtil.addSunLayout(fieldList, boDef, subEnt, sunEnts, templateMap);
                    }
                    ObjectNode subTableNode2 = GenerateExpandUtil.getSubTableNode(boDef.getAlias(), subEnt.getRelation(), subEnt.getName(), subEnt.getDesc(), fieldList, LAYOUT_DIV);
                    array.add((JsonNode)subTableNode2);
                    continue;
                }
                if (!LAYOUT_HOT_TABLE.equals(subParam.getTemplate())) continue;
                for (BoAttribute subAttribute : subAttr) {
                    ObjectNode fieldNode = GenerateExpandUtil.getFieldNode(boDef, mainEnt, subEnt, subAttribute, "sub", subParam.getTemplate());
                    fieldList.add((JsonNode)fieldNode);
                }
                subTableNode = GenerateExpandUtil.getHotTableNode(boDef.getAlias(), subEnt.getRelation(), subEnt.getName(), subEnt.getDesc(), fieldList, LAYOUT_TABLE);
                array.add((JsonNode)subTableNode);
            }
        }
        return array;
    }

    private static ObjectNode getHotTableNode(String defAlias, String relation, String name, String desc, ArrayNode fieldList, String layoutType) {
        String path = defAlias + ".sub_" + name;
        ObjectNode subtableNode = JsonUtil.getMapper().createObjectNode();
        subtableNode.put("ctrlType", LAYOUT_HOT_TABLE);
        subtableNode.put("name", name);
        subtableNode.put("desc", desc);
        subtableNode.put("icon", "icon-biaogebuju");
        subtableNode.put("isLayout", true);
        subtableNode.put("showTitle", true);
        subtableNode.put("customHeader", "");
        subtableNode.set("list", (JsonNode)fieldList);
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        optionsNode.put("showLabel", true);
        optionsNode.put("boSubEntity", name);
        optionsNode.put("subTablePath", path);
        optionsNode.put("relation", relation);
        optionsNode.put("subDivTablePath", path);
        if ("onetoone".equals(relation)) {
            optionsNode.put("height", 60);
        } else {
            optionsNode.put("height", 250);
        }
        ArrayNode colHeadersRelations = JsonUtil.getMapper().createArrayNode();
        for (JsonNode jsonNode : fieldList) {
            ObjectNode fieldObj = (ObjectNode)jsonNode;
            ObjectNode headerObj = JsonUtil.getMapper().createObjectNode();
            headerObj.put("name", JsonUtil.getString((JsonNode)fieldObj, (String)"name"));
            headerObj.put("desc", JsonUtil.getString((JsonNode)fieldObj, (String)"desc"));
            ObjectNode columnObj = JsonUtil.getMapper().createObjectNode();
            columnObj.put("data", JsonUtil.getString((JsonNode)fieldObj, (String)"name"));
            columnObj.put("readOnly", false);
            columnObj.put("readOnlyRows", "");
            columnObj.put("required", false);
            columnObj.put("requiredRows", "");
            columnObj.put("mergeCell", false);
            columnObj.put("type", "text");
            columnObj.put("dateFormat", "");
            columnObj.put("mathExp", "");
            columnObj.put("width", 90);
            columnObj.set("rowMathExp", (JsonNode)JsonUtil.createArrayNode());
            columnObj.set("source", (JsonNode)JsonUtil.createArrayNode());
            ObjectNode styleObj = JsonUtil.getMapper().createObjectNode();
            styleObj.put("size", 0);
            styleObj.put("color", "");
            styleObj.put("bold", false);
            styleObj.put("background", "");
            styleObj.put("diyStyle", "");
            columnObj.set("style", (JsonNode)styleObj);
            headerObj.set("column", (JsonNode)columnObj);
            colHeadersRelations.add((JsonNode)headerObj);
        }
        optionsNode.set("colHeadersRelations", (JsonNode)colHeadersRelations);
        optionsNode.set("templateContent", (JsonNode)JsonUtil.createArrayNode());
        optionsNode.set("initFillbackData", (JsonNode)JsonUtil.createArrayNode());
        optionsNode.set("crossMapping", (JsonNode)JsonUtil.createArrayNode());
        optionsNode.set("nestedHeaders", (JsonNode)JsonUtil.createArrayNode());
        optionsNode.set("mainTableCalcs", (JsonNode)JsonUtil.createArrayNode());
        optionsNode.set("cellCalcs", (JsonNode)JsonUtil.createArrayNode());
        subtableNode.set("options", (JsonNode)optionsNode);
        ObjectNode customQueryNode = JsonUtil.getMapper().createObjectNode();
        customQueryNode.put("isUse", false);
        customQueryNode.set("resultfield", (JsonNode)JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customQuery", (JsonNode)customQueryNode);
        ObjectNode customDialogNode = JsonUtil.getMapper().createObjectNode();
        customDialogNode.put("name", "\u5b50\u8868\u56de\u586b");
        customDialogNode.put("icon", "");
        ObjectNode custDialogNode = JsonUtil.getMapper().createObjectNode();
        custDialogNode.set("conditions", (JsonNode)JsonUtil.getMapper().createArrayNode());
        custDialogNode.set("mappingConf", (JsonNode)JsonUtil.getMapper().createArrayNode());
        customDialogNode.set("custDialog", (JsonNode)custDialogNode);
        ObjectNode orgConfigNode = JsonUtil.getMapper().createObjectNode();
        orgConfigNode.put("name", "");
        orgConfigNode.put("code", "");
        orgConfigNode.put("id", "");
        customDialogNode.set("orgConfig", (JsonNode)orgConfigNode);
        customDialogNode.set("resultField", (JsonNode)JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customDialogjson", (JsonNode)customDialogNode);
        subtableNode.put("subtableBackfill", false);
        subtableNode.put("initTemplateData", false);
        subtableNode.put("initTemplateDataType", "empty");
        subtableNode.put("key", GenerateExpandUtil.getRandomKey());
        return subtableNode;
    }

    private static List<BoAttribute> getActiveAttr(List<BoAttribute> attrs) {
        ArrayList<BoAttribute> activeAttrs = new ArrayList<BoAttribute>();
        if (BeanUtils.isNotEmpty(attrs)) {
            for (BoAttribute attr : attrs) {
                if ("hide".equals(attr.getStatus())) continue;
                activeAttrs.add(attr);
            }
        }
        return activeAttrs;
    }

    private static void addSunLayout(ArrayNode fieldList, BoDef boDef, BoEnt subEnt, List<BoEnt> sunEnts, Map<String, TemplateEntParam> templateMap) throws Exception {
        for (BoEnt sunEnt : sunEnts) {
            TemplateEntParam sunParam = templateMap.get(sunEnt.getName());
            ArrayNode sunFieldList = JsonUtil.getMapper().createArrayNode();
            List<BoAttribute> sunAttr = sunEnt.getBoAttrList();
            sunAttr = GenerateExpandUtil.getActiveAttr(sunAttr);
            if (LAYOUT_TABLE.equals(sunParam.getTemplate())) {
                for (BoAttribute sunAttribute : sunAttr) {
                    ObjectNode fieldNode = GenerateExpandUtil.getFieldNode(boDef, subEnt, sunEnt, sunAttribute, "sun", sunParam.getTemplate());
                    sunFieldList.add((JsonNode)fieldNode);
                }
            } else {
                ArrayNode columns = null;
                int sunColumn = sunParam.getColumn();
                int sunSpan = 24 / sunColumn;
                for (int i = 0; i < sunAttr.size(); ++i) {
                    ObjectNode gradNode;
                    int index = i + 1;
                    if (columns == null) {
                        columns = JsonUtil.getMapper().createArrayNode();
                    }
                    ObjectNode fieldNode = GenerateExpandUtil.getFieldNode(boDef, subEnt, sunEnt, sunAttr.get(i), "sun", sunParam.getTemplate());
                    ObjectNode colItem = GenerateExpandUtil.getColItem(fieldNode, sunSpan);
                    columns.add((JsonNode)colItem);
                    if (index % sunColumn == 0) {
                        gradNode = GenerateExpandUtil.getLayoutNode(columns, LAYOUT_GRID, "sun", sunEnt);
                        sunFieldList.add((JsonNode)gradNode);
                        columns = null;
                        continue;
                    }
                    if (i != sunAttr.size() - 1 || columns == null) continue;
                    GenerateExpandUtil.addLackGrad(columns, sunSpan, sunColumn - columns.size());
                    gradNode = GenerateExpandUtil.getLayoutNode(columns, LAYOUT_GRID, "sun", sunEnt);
                    sunFieldList.add((JsonNode)gradNode);
                    columns = null;
                }
            }
            ObjectNode sunTableNode = GenerateExpandUtil.getSunTableNode(boDef.getAlias(), sunEnt.getRelation(), subEnt.getName(), sunEnt.getName(), sunEnt.getDesc(), sunFieldList, sunParam.getTemplate());
            fieldList.add((JsonNode)sunTableNode);
        }
    }

    private static void addLackGrad(ArrayNode columns, int span, int size) {
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                ObjectNode field = JsonUtil.getMapper().createObjectNode();
                field.put("span", span);
                field.set("list", (JsonNode)JsonUtil.getMapper().createArrayNode());
                columns.add((JsonNode)field);
            }
        }
    }

    private static void addLackTd(ArrayNode colsNodes, int size) {
        if (size > 0) {
            ObjectNode field = JsonUtil.getMapper().createObjectNode();
            field.put("colspan", size);
            field.set("list", (JsonNode)JsonUtil.getMapper().createArrayNode());
            colsNodes.add((JsonNode)field);
        }
    }

    private static ObjectNode getSubTableNode(String defAlias, String relation, String name, String desc, ArrayNode fieldList, String layoutType) {
        String path = defAlias + ".sub_" + name;
        ObjectNode subtableNode = JsonUtil.getMapper().createObjectNode();
        subtableNode.put("ctrlType", LAYOUT_TABLE.equals(layoutType) ? "subtable" : "subDiv");
        subtableNode.put("name", name);
        subtableNode.put("desc", desc);
        subtableNode.put("icon", "icon-table2");
        subtableNode.put("isLayout", true);
        subtableNode.put("customHeader", "");
        subtableNode.put("boSubEntity", name);
        subtableNode.set("list", (JsonNode)fieldList);
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        optionsNode.put("showLabel", true);
        optionsNode.put("boSubEntity", name);
        optionsNode.put("subTablePath", path);
        optionsNode.put("relation", relation);
        optionsNode.put("subDivTablePath", path);
        if (LAYOUT_DIV.equals(layoutType)) {
            optionsNode.put("dataExpand", "expand");
        }
        subtableNode.set("options", (JsonNode)optionsNode);
        ObjectNode customQueryNode = JsonUtil.getMapper().createObjectNode();
        customQueryNode.put("isUse", false);
        customQueryNode.set("resultfield", (JsonNode)JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customQuery", (JsonNode)customQueryNode);
        ObjectNode customDialogNode = JsonUtil.getMapper().createObjectNode();
        customDialogNode.put("name", "\u5b50\u8868\u56de\u586b");
        customDialogNode.put("icon", "");
        ObjectNode custDialogNode = JsonUtil.getMapper().createObjectNode();
        custDialogNode.set("conditions", (JsonNode)JsonUtil.getMapper().createArrayNode());
        custDialogNode.set("mappingConf", (JsonNode)JsonUtil.getMapper().createArrayNode());
        customDialogNode.set("custDialog", (JsonNode)custDialogNode);
        ObjectNode orgConfigNode = JsonUtil.getMapper().createObjectNode();
        orgConfigNode.put("name", "");
        orgConfigNode.put("code", "");
        orgConfigNode.put("id", "");
        customDialogNode.set("orgConfig", (JsonNode)orgConfigNode);
        customDialogNode.set("resultField", (JsonNode)JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customDialogjson", (JsonNode)customDialogNode);
        subtableNode.put("subtableBackfill", false);
        subtableNode.put("initTemplateData", false);
        subtableNode.put("initTemplateDataType", "empty");
        subtableNode.put("key", GenerateExpandUtil.getRandomKey());
        return subtableNode;
    }

    private static ObjectNode getSunTableNode(String defAlias, String relation, String subName, String sunName, String desc, ArrayNode fieldList, String layoutType) {
        String path = defAlias + ".sub_" + subName + ".sub_" + sunName;
        ObjectNode subtableNode = JsonUtil.getMapper().createObjectNode();
        subtableNode.put("ctrlType", LAYOUT_TABLE.equals(layoutType) ? "suntable" : "sunDiv");
        subtableNode.put("name", sunName);
        subtableNode.put("desc", desc);
        subtableNode.put("icon", "icon-table2");
        subtableNode.put("isLayout", true);
        subtableNode.put("customHeader", "");
        subtableNode.set("list", (JsonNode)fieldList);
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        optionsNode.put("showLabel", true);
        optionsNode.put("boSubEntity", sunName);
        optionsNode.put("subTablePath", path);
        optionsNode.put("relation", relation);
        if (LAYOUT_DIV.equals(layoutType)) {
            optionsNode.put("dataExpand", "expand");
        }
        subtableNode.set("options", (JsonNode)optionsNode);
        ObjectNode customDialogNode = JsonUtil.getMapper().createObjectNode();
        customDialogNode.put("name", "\u5b59\u8868\u56de\u586b");
        customDialogNode.put("icon", "");
        ObjectNode custDialogNode = JsonUtil.getMapper().createObjectNode();
        custDialogNode.set("conditions", (JsonNode)JsonUtil.getMapper().createArrayNode());
        custDialogNode.set("mappingConf", (JsonNode)JsonUtil.getMapper().createArrayNode());
        customDialogNode.set("custDialog", (JsonNode)custDialogNode);
        ObjectNode orgConfigNode = JsonUtil.getMapper().createObjectNode();
        orgConfigNode.put("name", "");
        orgConfigNode.put("code", "");
        orgConfigNode.put("id", "");
        customDialogNode.set("orgConfig", (JsonNode)orgConfigNode);
        customDialogNode.set("resultField", (JsonNode)JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customDialogjson", (JsonNode)customDialogNode);
        subtableNode.put("subtableBackfill", false);
        subtableNode.put("boSubEntity", subName);
        subtableNode.put("parentNodeType", "sun");
        subtableNode.put("key", GenerateExpandUtil.getRandomKey());
        return subtableNode;
    }

    private static ObjectNode getLayoutNode(ArrayNode columns, String layoutType, String entType, BoEnt ent) {
        ObjectNode gridNode = JsonUtil.getMapper().createObjectNode();
        gridNode.put("name", "");
        gridNode.put("isLayout", true);
        gridNode.put("ctrlType", layoutType);
        gridNode.put("icon", "icon-grid");
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        optionsNode.put("gutter", 0);
        optionsNode.put("justify", "start");
        optionsNode.put("align", "top");
        if (LAYOUT_GRID.equals(layoutType)) {
            optionsNode.put("aBorder", "sykx");
            optionsNode.put("gridDescBagColor", "#f9f9f9");
            optionsNode.put("gridDescColor", "#262626");
            optionsNode.put("lableColor", "#DCDEE0");
            optionsNode.put("gridDescJustify", "left");
            optionsNode.put("gridDescBold", "bolder");
            optionsNode.put("hideLabel", false);
            optionsNode.put("lineType", "solid1px");
            optionsNode.put("span", 24);
            gridNode.put("desc", "\u6805\u683c\u5e03\u5c40");
            gridNode.set("columns", (JsonNode)columns);
            if (StringUtil.isNotEmpty((String)entType)) {
                gridNode.put("parentNodeType", entType);
                gridNode.put("parentType", "subDiv");
                gridNode.put("boSubEntity", ent.getName());
            }
        } else if (LAYOUT_TABLE.equals(layoutType)) {
            gridNode.put("desc", "\u8868\u683c\u5e03\u5c40");
            gridNode.set("rows", (JsonNode)columns);
            optionsNode.put("titleBackground", "#f4f4f4");
            optionsNode.put("lineHeight", 40);
            optionsNode.put("borderColor", "#ebeef5");
            optionsNode.put("borderWidth", 1);
            optionsNode.put("fontColor", "#808080");
            optionsNode.put("labelWidthType", "percent");
            optionsNode.put("labelWidth", 30);
        }
        gridNode.set("options", (JsonNode)optionsNode);
        gridNode.put("key", GenerateExpandUtil.getRandomKey());
        return gridNode;
    }

    private static ObjectNode getColItem(ObjectNode fieldNode, int span) {
        ObjectNode colItem = JsonUtil.getMapper().createObjectNode();
        ArrayNode colList = JsonUtil.getMapper().createArrayNode();
        colList.add((JsonNode)fieldNode);
        colItem.put("span", span);
        colItem.set("list", (JsonNode)colList);
        return colItem;
    }

    public static ObjectNode getFieldNode(BoDef boDef, BoEnt pent, BoEnt ent, BoAttribute attr, String entType, String template) throws Exception {
        ObjectNode fieldNode = JsonUtil.getMapper().createObjectNode();
        String ctrlType = "input";
        String dataType = attr.getDataType();
        fieldNode.put("icon", "icon-single");
        switch (dataType) {
            case "number": {
                ctrlType = "number";
                break;
            }
            case "clob": {
                ctrlType = "textarea";
                break;
            }
            case "date": {
                ctrlType = "date";
                fieldNode.put("icon", "icon-date");
            }
        }
        String path = boDef.getAlias() + "." + attr.getName();
        if ("sub".equals(entType)) {
            path = "item." + attr.getName();
            fieldNode.put("parentNodeType", "sub");
            fieldNode.put("boSubEntity", ent.getName());
        } else if ("sun".equals(entType)) {
            path = boDef.getAlias() + ".sub_" + pent.getName() + ".sub_" + ent.getName() + "." + attr.getName();
            fieldNode.put("parentNodeType", "sun");
            fieldNode.put("boSubEntity", ent.getName());
        }
        fieldNode.put("ctrlType", ctrlType);
        fieldNode.put("name", attr.getName());
        fieldNode.put("desc", attr.getDesc());
        fieldNode.put("key", GenerateExpandUtil.getRandomKey());
        fieldNode.put("target", attr.getName());
        fieldNode.put("boDefId", boDef.getId());
        fieldNode.put("boAttrId", attr.getId());
        fieldNode.put("fieldPath", path);
        fieldNode.put("title", attr.getDesc());
        fieldNode.put("entId", attr.getEntId());
        fieldNode.put("boDefAlias", boDef.getAlias());
        fieldNode.put("tableName", ent.getName());
        fieldNode.put("columnType", dataType);
        ObjectNode nodeOptions = GenerateExpandUtil.getOptionsNode(attr, entType, template);
        nodeOptions = GenerateExpandUtil.appendScanConfig(nodeOptions, ctrlType);
        fieldNode.set("options", (JsonNode)nodeOptions);
        return fieldNode;
    }

    public static ObjectNode appendScanConfig(ObjectNode nodeOptions, String ctrlType) {
        if (("input".equals(ctrlType) || "textarea".equals(ctrlType)) && nodeOptions != null && !nodeOptions.has("scanConfig")) {
            String scanConfig = "{\"isScanInput\": false,\"scanQr\": true,\"scanBar\": true,\"fillInput\": true,\"isDiy\": false}";
            try {
                nodeOptions.set("scanConfig", JsonUtil.toJsonNode((String)scanConfig));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nodeOptions;
    }

    private static BigDecimal getMaxNumber(int attrLen) {
        StringBuilder max = new StringBuilder();
        if (attrLen == 0) {
            max = new StringBuilder("9");
        } else {
            for (int i = 0; i < attrLen; ++i) {
                max.append("9");
            }
        }
        BigDecimal decimal = new BigDecimal(Double.parseDouble(max.toString()));
        return decimal.setScale(0, 4);
    }

    private static ObjectNode getOptionsNode(BoAttribute attr, String entType, String template) {
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        String dataType = attr.getDataType();
        if ("main".equals(entType)) {
            optionsNode.put("width", "100%");
            optionsNode.put("isWidth", true);
        }
        if ("number".equals(dataType)) {
            optionsNode.put("defaultValue", 0);
            BigDecimal maxNumber = GenerateExpandUtil.getMaxNumber(attr.getAttrLength());
            BigDecimal minNumber = new BigDecimal(0).subtract(maxNumber);
            optionsNode.put("min", minNumber);
            optionsNode.put("max", maxNumber);
            optionsNode.put("numberMin", minNumber);
            optionsNode.put("numberMax", maxNumber);
            optionsNode.put("step", 1);
            optionsNode.put("decimalDigits", attr.getDecimalLen());
            optionsNode.put("maxDecimalDigits", attr.getDecimalLen());
            optionsNode.put("filtercurrency", "");
            optionsNode.put("filterthousandBit", "");
            optionsNode.put("advancedProperty", "inputType|bindPreAndSufFix|disabled");
            optionsNode.put("basicsProperty", "number|currency|placeholder|dateCount");
            optionsNode.put("controlsPosition", "");
            optionsNode.put("controls", true);
            optionsNode.put("company", "");
            optionsNode.put("filterthousandBit", "");
            optionsNode.put("filterthousandBit", "");
            optionsNode.put("validateType", "min_value|max_value|confirmed|numeric|between|digits|required|row_unique|frontJSValidate|mobile");
            optionsNode.put("validate", "");
            optionsNode.put("dataType", "number");
        } else {
            optionsNode.put("defaultValue", "");
            optionsNode.put("dataType", "string|text");
            optionsNode.put("validateType", "regex|min|max|required|row_unique|frontJSValidate|backendValidate");
            optionsNode.put("advancedProperty", "isEditor|isInputEdit");
            optionsNode.put("placeholder", "");
            optionsNode.put("basicsProperty", "placeholder");
            if (!"clob".equals(dataType)) {
                optionsNode.put("dataType", "date".equals(dataType) ? "date" : "string|number");
                optionsNode.put("validateType", "confirmed|email|regex|id_card|min|max|min_value|max_value|isAfter|isBefore|isStart|isEnd|numeric|between|is|digits|mobile|required|row_unique|alpha_spaces|alpha_dash|alpha_num|alpha|frontJSValidate|backendValidate");
                optionsNode.put("validate", "");
                if ("date".equals(dataType)) {
                    optionsNode.put("readonly", false);
                    optionsNode.put("editable", true);
                    optionsNode.put("clearable", true);
                    optionsNode.put("timestamp", false);
                    optionsNode.put("required", false);
                    optionsNode.put("advancedProperty", "isInputEdit|bindPreAndSufFix");
                    optionsNode.put("validateType", "isAfter|isBefore|isStart|isEnd|required|row_unique|frontJSValidate");
                    optionsNode.put("basicsProperty", "date|placeholder");
                    optionsNode.put("type", "date");
                } else {
                    optionsNode.put("advancedProperty", "isInputEdit|isBindIdentity|inputType|bindPreAndSufFix");
                    optionsNode.put("basicsProperty", "input|dateCount|placeholder");
                    optionsNode.put("isCountDate", false);
                    ObjectNode conditionNode = JsonUtil.getMapper().createObjectNode();
                    conditionNode.put("target", "");
                    conditionNode.put("fieldPath", "");
                    conditionNode.put("value", "");
                    optionsNode.set("showCondition", (JsonNode)conditionNode);
                    optionsNode.put("isStartDate", "");
                    optionsNode.put("isEndDate", "");
                    optionsNode.put("countFormat", "day");
                    optionsNode.set("bindIdentityjson", (JsonNode)JsonUtil.getMapper().createObjectNode());
                    optionsNode.put("isBindPreAndSufFix", false);
                }
            } else {
                optionsNode.put("dataType", "clob");
                optionsNode.put("textareaHeight", 96);
                optionsNode.put("textareaAutoHeight", false);
            }
        }
        ArrayNode validateList = JsonUtil.getMapper().createArrayNode();
        if (1 == attr.getIsRequired()) {
            ObjectNode childValidate = JsonUtil.getMapper().createObjectNode();
            childValidate.put("key", "required");
            childValidate.put("name", "*\u5fc5\u586b");
            validateList.add((JsonNode)childValidate);
            optionsNode.put("validate", "'required'");
        }
        optionsNode.set("validateList", (JsonNode)validateList);
        optionsNode.put("disabled", false);
        optionsNode.put("formulasDiyJs", "");
        optionsNode.put("lableColor", "");
        if (!"clob".equals(dataType)) {
            optionsNode.put("mathExp", "");
            ObjectNode fixjsonNode = JsonUtil.getMapper().createObjectNode();
            fixjsonNode.put("preFix", "");
            fixjsonNode.put("sufSix", "");
            optionsNode.set("bindPreAndSufFixjson", (JsonNode)fixjsonNode);
        }
        if ("date".equals(dataType)) {
            optionsNode.put("format", attr.getFormat());
            optionsNode.put("inputFormat", attr.getFormat());
        }
        return optionsNode;
    }

    private static ObjectNode getOptionNode(BoAttribute attr, String entType) {
        String controlType = attr.getControlType();
        IControlType controlTypeBean = (IControlType)AppUtil.getBean((String)(controlType + "ControlType"));
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isNotEmpty((Object)controlTypeBean)) {
            optionsNode = controlTypeBean.generateConfig(attr);
        }
        if ("main".equals(entType)) {
            optionsNode.put("width", "100%");
            optionsNode.put("isWidth", true);
        }
        return optionsNode;
    }

    private static String getRandomKey() {
        return String.valueOf(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"))) + "_" + (int)Math.ceil(Math.random() * 99999.0);
    }
}

