<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
  <div class="data_view">
     ${cfg.dataTemplateHtml}
  </div>
</template>
<script>
import {codeTemplatePreview} from 'hotent-ui'
export default {
  mixins: [ codeTemplatePreview, ],
  components:{},
  data() {
    return {
      dialogVisible: false,
      rows: [],
      saveMethod: "POST",
      single: "true",
      customQuery: null,
      joinQueryConfig: null,
      currentTableHeight: 800,
      autofocus: false,
      templateInfo:${cfg.dataTemplateInfo}
    };
  },
  mounted() {
    this.$validator = this.$root.$validator;
    if(this.templateInfo){
      this.templateKey = this.templateInfo.alias
    }
    let _me = this
    _me.templateInfo.displayFieldArray = JSON.parse(
            _me.templateInfo.displayField
    )
    if (_me.templateInfo.joinQueryConfig) {
      _me.joinQueryConfig = JSON.parse(
              _me.templateInfo.joinQueryConfig
      )
      if(_me.joinQueryConfig.alias) {
        this.$requestConfig
                .getCustomQuery(_me.joinQueryConfig.alias)
                .then((res) => {
          _me.customQuery = res
        })
      }
    }
  },
  methods: {
  }
};
</script>
<style lang="scss">
  .summary-table {
    margin: 8px 24px;
    .project-column {
      .cell {
        font-size: 16px;
        color: #333;
        font-weight: bold;
      }
    }
    .summary-num {
      .summary-table-field {
        font-size: 18px;
        color: #4ba232;
        font-weight: bold;
      }
    }
  }
  .custom-summary {
    padding: 10px 20px 20px;
  }
  .data_view {
    height: 70vh;
    .table-main {
      flex: unset;
      padding: 20px 20px 16px;
      height: 100%;
      #printData{
        height: 100%;
      }
    }
    .el-footer {
      padding: 0 20px;
    }

    .data-form-list__top-btn {
      height: 34px;
      margin-left: 8px;
      //margin-bottom: 10px;
      &:first-child {
         margin-left: 0;
       }
    }
  }

  .import-log-dialog {
    .ht-table-panel {
      padding: 0 48px 13px 48px;
    }
  }
  .failure-reason-dialog {
    .el-dialog__body {
      padding: 32px 48px 48px 48px;
      .error-info {
        padding: 16px;
        color: #e55555;
        background: rgba(249, 249, 249, 0.39);
      }
    }
  }
  .template-preview {
    .top_btn_col > .el-button {
      &:first-child {
         border: var(--themeColor);
         background-color: var(--themeColor);
         color: #fff;
       }
    }
  }
  @media print {
    body {
      height: auto !important;
    }

    .notprint {
      display: none;
    }
    .el-table__fixed {
      display: none;
    }
    .el-table_1_column_1 {
      display: none;
    }
    .el-table__body-wrapper {
      overflow: hidden;
      position: relative;
      max-height: fit-content !important;
      height: auto;
      width: 100% !important;
    }

    .ht-table-panel {
      width: 100%;
      max-height: fit-content !important;
      height: auto !important;
    }
    .ht-table-panel {
      padding: 0;
      height: auto;
      overflow: hidden;
    }
    .top_btn_col {
      display: flex;
      align-items: center;
      .el-button {
        margin-right: 10px;
      }
    }

    tr {
      page-break-inside: avoid !important;
    }

    .el-table .cell {
      white-space: pre-wrap !important;
      text-overflow: unset !important;
      width: 100% !important;
    }
    .el-table thead.is-group th {
      text-align: center;
    }
    tbody > tr > th,
    tbody > tr > td,
    tfoot > tr > td,
    thead > tr > th {
      border: 1px solid rgb(238, 235, 235) !important;
    }
    .el-table__header {
      border: 1px solid rgb(238, 235, 235) !important;
    }
    .el-table__header > tbody > tr > th,
    .el-table__header > tbody > tr > td,
    .el-table__header > tfoot > tr > td,
    .el-table__header > thead > tr > th {
      border: 1px solid rgb(238, 235, 235) !important;
    }
    .el-table__body > tbody > tr > th,
    .el-table__body > tbody > tr > td,
    .el-table__body > tfoot > tr > td,
    .el-table__body > thead > tr > th {
      border: 1px solid rgb(238, 235, 235) !important;
    }

    /*减小单元格间距*/
    .el-table th,
    .el-table td {
      padding: 0 0;
    }
    /*显示底部边框 估计打印时伪元素把border覆盖了 height设为0隐藏伪元素*/
    .el-table::before {
      height: 0;
    }

    /*显示右边框*/
    .el-table--group::after,
    .el-table--border::after {
      width: 0;
    }
    table,
    tbody,
    thead {
      width: 100% !important;
    }

    colgroup {
      position: absolute;
      width: 100% !important;
    }
    table {
      width: 100% !important;
    }
    .cell > span {
      white-space: pre-wrap !important;
    }
    .el-table {
      height: 100% !important;
      max-height: fit-content !important;
      width: 100% !important;
    }
    .el-table__body-wrapper {
      height: 100% !important;
      max-height: fit-content !important;
      width: 100% !important;
    }
    .table_layout_wrap {
      margin: 0 !important;
    }
    .dropdown-upload__btn {
      .el-button-group {
        .el-button {
          &:first-child {
             height: 28px !important;
             line-height: 28px;
            span {
              display: flex;
              align-items: center;
              margin-top: -8px;
            }
          }
        }
      }
    }
  }
  ::v-deep.el-table th.is-hidden > *,
  ::v-deep.el-table td.is-hidden > * {
    visibility: visible !important;
  }
</style>
