<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
  <div class="data_view">
     ${cfg.dataTemplateHtml}
     <${table.entityName}-manager-edit ref="${table.entityName}ManagerEdit"></${table.entityName}-manager-edit>
     <associated-query-dialog ref="AssociatedQueryDialog"></associated-query-dialog>
  </div>
</template>
<script>
import ${table.entityName}ManagerEdit from "./${table.entityName}ManagerEdit.vue";
import templatePreview from '@/mixins/dataTemplate/templatePreview.js'
import api from "@/api/${table.entityName}.js"
import { Loading } from 'element-ui'
export default {
  mixins: [templatePreview],
  components:{${table.entityName}ManagerEdit},
  data() {
    return {
      dialogVisible: false,
      rows: [],
      saveMethod: "POST",
      single: "true",
      templateInfo:${cfg.dataTemplateInfo}
    };
  },
  mounted() {
    this.$validator = this.$root.$validator;
  },
  methods: {
    showDialog(id) {
      this.$refs.${table.entityName}ManagerEdit.showDialog(id);
    },
    deleteByIds(ids) {
      if (!ids || ids.length === 0) {
        this.$message.warning('请至少选中一条数据!')
        return
      }
	  api.deleteByIds(ids.join(',')).then((resp) => {
	    let response = resp.data || resp
	    if (response.state) {
	      this.$message.success(response.message || '删除成功')
	      this.loadData()
	    }
	  })
    },
    importMain(param) {
      let formData = new FormData()
      formData.append('file', param.file)
      let loadingInstance = Loading.service({ fullscreen: true })
      api.importData(formData)
        .then((response) => {
          if (response.state) {
            this.$message.success(response.message || '导入成功')
            this.loadData()
          }
        })
        .finally(() => {
          loadingInstance.close()
        })
    },
    exportByFilter(filter) {
      return api.exportByFilter(filter, 'id,refId')
    },
    updateData(ids,value) {
      if (!ids || ids.length === 0) {
        this.$message.warning('请至少选中一条数据!')
        return
      }
      debugger
      // 第一个参数为主键，第二个参数为要更新的字段，第三个为更新的值
      api.updateData(ids.join(','),'F_zje',value).then((resp) => {
        let response = resp.data || resp
        if (response.state) {
          this.$message.success(response.message || '删除成功')
          this.loadData()
        }
      })
    },
    copyById(id) {
      if (!id || id.length === 0) {
        this.$message.warning('请至少选中一条数据!')
        return
      }
      // 第二个参数为复制时忽略的字段(传入实体属性)，多个用逗号分隔
      api.copyById(id,"").then((resp) => {
        let response = resp.data || resp
        if (response.state) {
          this.$message.success(response.message || '操作成功')
          this.loadData()
        }
      })
    },
    loadData(param, cb) {
      param = param || {}
      this.handleExtendQuerys(param)
      this.$refs.multipleTemplateTable.clearSelection()
      api.loadData(param)
        .then(resp => {
          let response = resp.data || resp
          this.rows = response.rows
          this.total = response.total
          this.pagination = {
            page: response.page,
            pageSize: response.pageSize,
            total: response.total
          }
          this.$loading().close()
        })
        .finally(() => cb && cb())
    },
    getBpmTemplateByPagination(param, cb1, cb2) {
      this.loadData(param.pagination || {}, () => {
          cb1 && cb1()
          cb2 && cb2()
        })
    },
    initTree(treeField) {},
    getSubDataPagination(tab, name, refId, resolve, final) {},
    formGetSubEntsByFormKey() {},
  }
};
</script>
<style lang="scss" scoped>
  >>> th.todo-header-row {
    background-color: #fafafa;
    font-size: 13px;
  }

  >>> tr.todo-row {
    font-size: 13px;
  }

  .el-container {
    background-color: #fff;
  }

  .el-row {
    margin-bottom: 20px;
  }

  .el-header {
    border-bottom: 1.5px solid #ededed;
  }

  .i {
    margin-right: 4px;
  }

  .todo-subject {
    cursor: pointer;
  }

  >>> .el-dialog__body {
    padding: 15px 10px;
  }

  >>> .el-checkbox {
    margin-left: 15px;
  }

  >>> .el-radio {
    margin-left: 15px;
  }

  >>> .el-button {
    margin-left: 0px;
  }
  .loaded-fail__div {
    text-align: center;
    font-size: 14px;
    font-weight: bold;
    color: #f56c6c;
  }
  .data-preview-wrap
    ::v-deep
    .dropdown-upload__btn
    > .el-button-group
    > button:first-child {
    margin: 0;
    padding: 0;
  }
</style>
