<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
  <div class="data-preview-wrap">
    <el-row class="top-title__row">
      <h3 class="top-title">{{ queryView.name ? queryView.name : '' }}</h3>
    </el-row>
  	${cfg.queryViewTemplate}
  </div>
</template>
<script>
import api from "@/api/${table.entityName}.js";
import dynamic_view_mixin from 'hotent-ui/src/mixins/querySqlPreview.js'
export default {
  mixins: [dynamic_view_mixin],
  data() {
    return {
      rows: [],
      queryView: ${cfg.queryViewInfo}
    };
  },
  methods: {
    getQuerySqlViewByPagination(param, cb) {
      api
        .loadData(param.pagination||{})
        .then(resp => {
          let response = resp.data || resp
          this.rows = response.rows
          this.pagination = {
            page: response.page,
            pageSize: response.pageSize,
            total: response.total
          }
          this.$loading().close()
        })
        .finally(() => cb && cb())
    }
  }
};
</script>

<style lang="scss" scoped>
  >>> th.todo-header-row {
    background-color: #fafafa;
    font-size: 13px;
  }

  >>> tr.todo-row {
    font-size: 13px;
  }

  .el-container {
    background-color: #fff;
  }

  .top-title__row {
    margin-bottom: 10px;
    .top-title {
      font-size: 14px;
      border-bottom: 1px solid #ccc;
      margin: 17px 0 0 0;
      padding: 0 0 12px 20px;
    }
  }

  .el-header {
    border-bottom: 1.5px solid #ededed;
  }

  .i {
    margin-right: 4px;
  }

  .todo-subject {
    cursor: pointer;
  }

  .todo-subject:hover {
  }

  >>> .el-dialog__body {
    padding: 15px 10px;
  }

  >>> .el-checkbox {
    margin-left: 15px;
  }

  >>> .el-radio {
    margin-left: 15px;
  }

  >>> .el-button {
    margin-left: 0px;
  }
  .loaded-fail__div {
    text-align: center;
    font-size: 14px;
    font-weight: bold;
    color: #f56c6c;
  }
</style>