<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
  <div>
    <ht-table
      ref="htTable"
      :data="rows"
      :pageResult="pagination"
      :selection="true"
      quick-search-props="${table.fields[0].propertyName}"
      :show-export="false"
      :show-custom-column="false"
      @loading="loadData"
    >
      <template v-slot:toolbar>
        <el-button-group>
          <el-button size="small" @click="showDialog()" icon="el-icon-plus">添加</el-button>
          <el-button
            v-popconfirm="{ before: removeValid, confirm: handleRemove }"
            type="danger"
            icon="el-icon-delete"
          >删除</el-button>
        </el-button-group>
      </template>
      <template>
        <ht-table-column type="index" width="50" align="center" label="序号" />
        <#list table.fields as field>
        <#assign propertyName>${cfg.cgUtil.getPropertyName(cfg.boEntList,table.name,field.name,field.propertyName)}</#assign>
        <ht-table-column
          prop="${propertyName}"
          label="${field.comment!""}"
          :sortable="true"
          :show-overflow-tooltip="true"
        >
          <#if field_index == 0  >
          <template v-slot="{row}">
            <el-link
              type="primary"
              @click="showDialog(row.id)"
              title="查看详情"
            >{{row.${propertyName}}}</el-link>
          </template>
          </#if>
        </ht-table-column>
        </#list>
        <#if cfg.isFlow>
          <ht-table-column
                  prop="flowStatus"
                  label="实例状态"
                  width="115"
                  :render-header="renderHeaderMethod"
                  :filters="statusArray"
          >
            <template v-slot="{row}">
              <el-tag
                      v-show="row.flowStatus == s.value"
                      :type="s.type"
                      v-for="s in statusArray"
                      :key="s.value"
              >{{ s.text }}</el-tag
              >
            </template>
          </ht-table-column>
          <ht-table-column
                  prop="instId"
                  label="流程编号"
                  :sortable="true"
                  :show-overflow-tooltip="true"
          >
          </ht-table-column>

          <ht-table-column
                  label="操作"
                  width="200"
                  fixed="right"
          >
            <template #default="{ row }">
              <el-button type="text" plain style="border: 0;background-color: transparent !important;"
                         @click="handleInstUpdate(row)" v-if="row.instId"
                         icon="el-icon-refresh" size="small">更新实例状态</el-button>
              <el-button type="text" plain style="border: 0;background-color: transparent !important;"
                         @click="handleStart(row)" v-if="row.flowStatus == undefined"
                         icon="el-icon-s-promotion" size="small">启动</el-button>
              <el-button type="text" plain style="border: 0;background-color: transparent !important;"
                         @click="handleFlowImage(row)" v-if="row.flowStatus"
                         icon="el-icon-s-marketing" size="small">流程图</el-button>
              <el-button type="text" plain style="border: 0;background-color: transparent !important;"
                         @click="handleRecord(row)" v-if="row.flowStatus"
                         icon="el-icon-s-operation" size="small">处理记录</el-button>
              <el-button type="text" plain style="border: 0;background-color: transparent !important;"
                         @click="handleComplete(row)" v-if="row.flowStatus && !uncheckStatus.includes(row.flowStatus)"
                         icon="el-icon-s-check" size="small">同意</el-button>
              <el-button type="text" plain style="border: 0;background-color: transparent !important;"
                         @click="handleBack(row)" v-if="row.flowStatus && !uncheckStatus.includes(row.flowStatus)"
                         icon="el-icon-back" size="small">驳回</el-button>

            </template>
          </ht-table-column>
        </#if>
      </template>
    </ht-table>
    <${table.entityName}-manager-edit ref="${table.entityName}ManagerEdit"></${table.entityName}-manager-edit>

    <#if cfg.isFlow>
      <flow-chart
              ref="flowChart"
      />
      <!-- 处理记录 -->
      <process-record-dialog
              ref="processRecordDialog"
              :inst-id="instId"
      />
    </#if>
  </div>
</template>
<script>
import ${table.entityName}ManagerEdit from "./${table.entityName}ManagerEdit.vue";
import api from "@/api/${table.entityName}.js"
<#if cfg.isFlow>
import {start,completeTask, backToStart, getStatusByInstId} from "@/api/flow";
import FlowChart from './FlowChart.vue'
import ProcessRecordDialog from './processRecordDialog'
</#if>

export default {
  name: '${table.entityName}Manager', 
  components:{${table.entityName}ManagerEdit,
    <#if cfg.isFlow>
    FlowChart, ProcessRecordDialog,
    </#if>
  },
  data() {
    return {
      dialogVisible: false,
      rows: [],
      pagination: {
        page: 1,
        pageSize: 50,
        total: 0
      },
      ${table.entityName}: {},
      saveMethod: "POST",
      instId:'',
      statusArray: [
        {text: '运行中', value: 'running', type: 'success'},
        {text: '结束', value: 'end', type: 'info'},
        {text: '草稿', value: 'draft', type: 'info'},
        {text: '驳回', value: 'back', type: 'danger'},
        {text: '驳回到发起人', value: 'backToStart', type: 'danger'},
        {text: '撤回', value: 'revoke', type: 'warning'},
        {text: '撤回到发起人', value: 'revokeToStart', type: 'warning'},
        {text: '人工终止', value: 'manualend', type: 'info'},
        {text: '管理员结束', value: 'adminmanualend', type: 'info'}
      ],
      uncheckStatus: ['end', 'draft', 'manualend', 'adminmanualend'],
    };
  },
  computed: {
	tableHeight() {
	  return this.$baseTableHeight()
	},
  },
  methods: {
    showDialog(id) {
      this.$refs.${table.entityName}ManagerEdit.showDialog(id);
    },
    loadData(param, cb) {
      api.loadData(param||{}).then(
        (resp) => {
          let response = resp.data || resp
          this.rows = response.rows
          this.total = response.total
          this.pagination = {
            page: response.page,
            pageSize: response.pageSize,
            total: response.total
          }
        }
      )
      .finally(() => cb && cb());
    },
    removeValid() {
        if (this.$refs.htTable.selection.length == 0) {
          this.$message({ message: '请至少选择一条记录', type: 'warning' })
          return false
        }
        return true
      },
      handleRemove() {
        const ids = []
        this.$refs.htTable.selection.forEach((item) => {
          ids.push(item.id)
        })
        api.deleteByIds(ids.join(',')).then(() => {
          this.loadData()
        })
      },
    <#if cfg.isFlow>
    handleInstUpdate(row){
      getStatusByInstId(row.instId, '${table.entityName}').then((resStatus)=>{
        this.loadData()
        this.$message({
          type: "success",
          message: '更新状态成功!'
        });
      })
    },
    batchStart(){
      let selectedList = this.$refs.htTable.selection
      if(selectedList && selectedList.length > 0){
        const loading = this.$loading({
          lock: true,
          text: "正在批量启动流程,请稍等...",
          spinner: "el-icon-loading",
          background: "rgba(0, 0, 0, 0.7)"
        });
        for (var i=0;i<selectedList.length;i++){
          const item = selectedList[i]
          if(item.instId){
            if(i >= selectedList.length - 1){
              loading.close()
            }
            continue
          }
          start(item, '${table.entityName}').then(res => {
            if(i >= selectedList.length - 1){
              this.loadData()
              loading.close()
              this.$message({
                type: "success",
                message: '批量启动流程成功！'
              });
            }
          }).catch((e)=>{
            if(i >= selectedList.length - 1){
              loading.close()
              this.$message({
                type: "error",
                message: '批量启动流程失败！'
              });
            }
          })
        }
      }
    },
    handleStart(row){
      const loading = this.$loading({
        lock: true,
        text: "正在启动流程,请稍等...",
        spinner: "el-icon-loading",
        background: "rgba(0, 0, 0, 0.7)"
      });
      start(row, '${table.entityName}').then(res => {
        this.loadData()
        loading.close()
        this.$message({
          type: "success",
          message: res.value
        });
      }).catch((e)=>{
        loading.close()
      })
    },
    handleFlowImage(row){
      this.instId=row.instId
      this.$refs.flowChart.handleOpen(this.instId)
    },
    handleRecord(row){
      this.instId=row.instId
      this.$refs.processRecordDialog.handleOpen(this.instId)
    },
    handleComplete(row){
      completeTask(row.instId, '${table.entityName}').then((res)=>{
        getStatusByInstId(row.instId, '${table.entityName}').then((resStatus)=>{
          this.loadData()
          this.$message({
            type: "success",
            message: res.value
          });
        })
      })
    },
    handleBack(row){
      backToStart(row.instId, '${table.entityName}').then((res)=>{
        this.loadData()
        this.$message({
          type: "success",
          message: '驳回到发起人成功！'
        });
      })
    },
    </#if>
  }
};
</script>
<style lang="scss" scoped>
  ::v-deep .ht-table {
    max-height: max-content !important;
    height: 100% !important;
  }
  ::v-deep .el-table__body-wrapper {
    max-height: max-content ;
    min-height: 500px;
  }
</style>
