<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
	<div>
		<NavBar :is-custom="true" @go-back="goBack">
	      <template slot="title">${table.comment!}</template>
	    </NavBar>
	    ${cfg.mobileDataTemplateHtml}
	</div>
</template>
<script>


import mobileFormList from '@/mixins/mobileFormList'
import templatePreviewMixin from '@/mixins/templatePreview.js'
import utils from 'hotent-ui/src/utils.js'
const { Base64 } = require('js-base64')
import request from '@/utils/request'
import api from "@/api/${table.entityName}.js"
import { Notify } from 'vant'

export default {
  mixins: [mobileFormList, templatePreviewMixin],
  components:{},
  data() {
    return {
      templateInfo:${cfg.dataTemplateInfo},
      loadedFail: false,
      refreshTime: new Date().getTime(),
      showDateView: true,
      isMobile: utils.isMobile(),
      isShowMore: false,
    };
  },
  mounted() {
    
  },
  methods: {
  	 goBack(){
       this.$router.push({name: 'home' })
     },
     delete(id) {
      api.deleteByIds(id).then((resp) => {
        let response = resp.data || resp
        if (response.state) {
          Notify({ type: 'success', message: response.message || '删除成功' })
          this.search()
        }
      })
    },
    editMmethod(type, id) {
      this.$router.push({
        name: '${table.entityName?uncap_first}MobileManagerEdit',
        query: { type: type, id: id },
      })
    },
    searchMethod(vo){
      return api.loadData(vo.queryFilter)
    },

  },
};
</script>
<style lang="scss" scoped>
 
</style>
