<#-- ----------------------- 生成在线表单的编辑页的模板 ----------------------------->
<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
	<div>
	    <NavBar :is-custom="true" @go-back="toListRouter">
	      <template slot="title">${table.comment!}</template>
	    </NavBar>
		<div class="template-form--detail" style="overflow: auto; height: 100%" data-vv-scope="${table.entityName}Form">
	  ${cfg.mobileForm.formHtml}
	   	<footer class="mobile-template-form__detail-footer">
	      <van-button class="footer-btn" type="info" @click="save()" v-if="type!='get'">
	        保存
	      </van-button>
	    </footer>
	  </div>
  </div>
</template>
<script>
import api from "@/api/${table.entityName}.js";
import onlineSubtable from '@/mixins/onlineSubtable.js'
import { Notify } from 'vant'
export default {
  name: '${table.entityName}MobileManagerEdit',
  mixins: [onlineSubtable],
  data() {
    return {
      id: '',
      type: 'add',
      dialogVisible: false,
      isView: false,
      saveMethod: 'POST',
      data: ${cfg.data},
      permission: ${cfg.mobilePermission}
    };
  },
  created() {
    this.type = this.$route.query.type
    this.id = this.$route.query.id
    this.showDialog(this.id)
    this.$nextTick(() => {
      this.handlerJs()
    })
  },
  methods: {
    handlerJs(){
      ${cfg.form.diyJs!}
    },
     handlerJs() {},
    showDialog(id) {
      if (id) {
      	if (this.type == 'get') {
          for (const bokey in this.permission.fields) {
            for (const fi in this.permission.fields[bokey]) {
              if (
                this.permission.fields[bokey][fi] == 'b' ||
                this.permission.fields[bokey][fi] == 'w'
              ) {
                this.permission.fields[bokey][fi] = 'r'
              }
            }
          }
          for (const tableName in this.permission.table) {
            for (const r in this.permission.table[tableName]) {
              this.permission.table[tableName][r] = false
            }
          }
        }
        this.saveMethod = 'PUT'
        api.getDetail(id).then((resp) => {
          if (resp && resp.state) {
            Object.assign(Object.values(this.data)[0], resp.value)
          }
        })
      } else {
        this.saveMethod = 'POST'
      }
    },
    toListRouter() {
      this.$router.push({ name: '${table.entityName?uncap_first}MobileManager' })
    },
    save() {
      this.$root.$validator
        .validateAll('${table.entityName?uncap_first}Form')
        .then((result) => {
          if (result) {
            api.save(Object.values(this.data)[0]).then(() => {
             this.toListRouter();
            })
          } else {
            Notify({
              type: 'warning',
              message: '未通过表单校验，请正确填写表单。',
            })
          }
        })
    },
  }
};
</script>

<style lang="scss" scoped>
  .template-form--detail {
    background: #fff;
    width: 100vw;
    overflow-x: hidden;
  }
  .el-form {
    height: calc(100vh - 70px);
    overflow-y: auto;
    overflow-x: hidden;
  }
  .mobile-template-form__detail-footer {
    border-top: 1px solid #eee;
    position: fixed;
    bottom: 0;
    height: 60px;
    background: #fff;
    width: calc(100vw - 30px);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 5px 15px;
    .footer-btn {
      width: calc(100vw - 30px);
      border-radius: 8px;
    }
  }
</style>
