package ${cfg.basePackage}.${cfg.moduleName}.entity;


import ${cfg.basePackage}.${cfg.moduleName}.enums.NodeType;

/**
 * 节点布局类，定义流程节点的坐标及类型。
 * <pre> 
 * 构建组：eip平台-bpmx-api
 * 作者：ray
 * 邮箱:zhangyg@jee-soft.cn
 * 日期:2014-6-4-下午2:05:13
 * 版权：广州宏天软件有限公司版权所有
 * </pre>
 */
public class BpmNodeLayout {

	/**
	 * 节点ID
	 */
	private String nodeId="";

	/**
	 * 节点名称
	 */
	private String name="";

	/**
	 * 节点类型
	 */
	private NodeType nodeType;

	/**
	 * x坐标
	 */
	private double x=0;

	/**
	 * y坐标
	 */
	private double y=0;

	/**
	 * 宽度
	 */
	private double width=0;

	/**
	 * 高度
	 */
	private double height=0;

	/**
	 * 节点类型。并行会签和串行会签会做区分。方便前端根据此类型，显示不同的图标
	 */
	private String uniqueNodeType;

	public BpmNodeLayout() {
	}

	public BpmNodeLayout(String nodeId, String name, NodeType nodeType,
						 double x, double y, double width, double height, String uniqueNodeType){
		this.nodeId = nodeId;
		this.name = name;
		this.nodeType = nodeType;
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.uniqueNodeType = uniqueNodeType;
	}

	public String getNodeId() {
		return nodeId;
	}

	public void setNodeId(String nodeId) {
		this.nodeId = nodeId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public NodeType getNodeType() {
		return nodeType;
	}

	public void setNodeType(NodeType nodeType) {
		this.nodeType = nodeType;
	}

	public double getX() {
		return x;
	}

	public void setX(double x) {
		this.x = x;
	}

	public double getY() {
		return y;
	}

	public void setY(float y) {
		this.y = y;
	}

	public double getWidth() {
		return width;
	}

	public void setWidth(double width) {
		this.width = width;
	}

	public double getHeight() {
		return height;
	}

	public void setHeight(double height) {
		this.height = height;
	}

	public String getUniqueNodeType() {
		return uniqueNodeType;
	}

	public void setUniqueNodeType(String uniqueNodeType) {
		this.uniqueNodeType = uniqueNodeType;
	}
}
