<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">
<mapper namespace="${package.Mapper}.${table.mapperName}">

<#if enableCache>
    <!-- 开启二级缓存 -->
    <cache type="org.mybatis.caches.ehcache.LoggingEhcache"/>

</#if>
<#if baseResultMap>
    <!-- 通用查询映射结果 -->
    <resultMap id="BaseResultMap" type="${package.Entity}.${entity}">
<#list table.fields as field>
<#if field.keyFlag><#--生成主键排在第一位-->
        <id column="${field.name}" property="${field.propertyName}" />
</#if>
</#list>
<#list table.commonFields as field><#--生成公共字段 -->
	<#assign propertyName>${cfg.cgUtil.getPropertyName(cfg.boEntList,table.name,field.name,field.propertyName)}</#assign>
    <result column="${field.name}" property="${propertyName}" />
</#list>
<#list table.fields as field>
<#if !field.keyFlag && field.propertyName != 'tenantId' ><#--生成普通字段 -->
	<#assign propertyName>${cfg.cgUtil.getPropertyName(cfg.boEntList,table.name,field.name,field.propertyName)}</#assign>
    <result column="${field.name}" property="${propertyName}" />
</#if>
</#list>
    </resultMap>

</#if>
<#if baseColumnList>
    <!-- 通用查询结果列 -->
    <sql id="Base_Column_List">
<#list table.commonFields as field>
        ${field.name},
</#list>
        ${cfg.cgUtil.repalceStr(table.fieldNames,"tenant_id_,","")}
    </sql>

</#if>
	<select id="selectPage" resultMap="BaseResultMap">
		select 
			<include refid="Base_Column_List"/> 
		from
			${table.name}
		<#noparse>${</#noparse>ew.customSqlSegment<#noparse>}</#noparse>
	</select>
	
	<select id="selectList" resultMap="BaseResultMap">
		select 
			<include refid="Base_Column_List"/> 
		from
			${table.name}
		<#noparse>${</#noparse>ew.customSqlSegment<#noparse>}</#noparse>
	</select>
	
	<select id="selectById" resultMap="BaseResultMap">
		select 
			<include refid="Base_Column_List"/> 
		from
			${table.name}
		where 
		<#list table.fields as field>
		<#if field.keyFlag>
		    ${field.name} = <#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse>
		</#if>
		</#list>
	</select>
</mapper>
