<#--
Name: 数据列表模板222
Desc:数据列表模板

本模板需要通过2次解析才能得到最终的Html
第一次解析：
*************************************************************
*************************************************************
*数据模型:****************************************************
*************************************************************
*************************************************************

tbarTitle：Tool Bar 的标题

********************************************
conditionFields:条件字段
--joinType：	条件联合类型
--name：	列名
--name：完全指定名
--operate：条件类型: =|>=|<=|….
--comment：注释
--type：	类型
--value：值
--valueFrom：值来源

************************************************************
displayFields：显示字段
--name：列名
--name：完全指定名
--label：别名
--index：索引
--comment：注释
--type：类型

******************************************************
tableIdCode:Table ID Code

**************************************************
displayId: 自定义显示的ID

**************************************************
pageHtml：分页的Html 详见pageAjax.xml

*************************************************
pageURL：当前页面的URL

searchFormURL：搜索表单的Action


sortField：当前排序字段

orderSeq：当前的排序类型

***********************************************
pkcols:主键列

deleteBaseURL：删除一行数据的BaseURL
editBaseURL：编辑一行数据的BaseURL
 -->


<#setting number_format="#">
<#assign displayFields=bpmDataTemplate.displayField?eval>
<#assign conditionFields=bpmDataTemplate.conditionField?eval>
<#assign filterFields=bpmDataTemplate.filterField?eval>
<#assign manageFields=bpmDataTemplate.manageField?eval>
<#assign sortFields=bpmDataTemplate.sortField?eval>
<#assign tableConfigure=bpmDataTemplate.tableConfigure?eval>
<#assign treeFields=bpmDataTemplate.treeField?eval>
<#assign summaryFields=bpmDataTemplate.summaryField?eval>
<#assign summaryRegionHtml=bpmDataTemplate.summaryRegionHtml>
<#assign mobileDisplayField=bpmDataTemplate.mobileDisplayField?eval>
<#assign mobileManageField=bpmDataTemplate.mobileManageField?eval>
<#assign mobileOtherJson=bpmDataTemplate.mobileOtherJson?eval>

<#noparse>
	<#setting number_format="#">
	<#assign displayFields=bpmDataTemplate.displayField?eval>
	<#assign conditionFields=bpmDataTemplate.conditionField?eval>
	<#assign filterFields=bpmDataTemplate.filterField?eval>
	<#assign manageFields=bpmDataTemplate.manageField?eval>
	<#assign sortFields=bpmDataTemplate.sortField?eval>
	<#assign tableConfigure=bpmDataTemplate.tableConfigure?eval>
	<#assign boAlias=bpmDataTemplate.boDefAlias>
	<#assign templateId=bpmDataTemplate.id>
	<#assign templateAlias=bpmDataTemplate.alias>
	<#assign pageSize=bpmDataTemplate.pageSize>
	<#assign urlPre="$">
  <#assign mobileManageField=bpmDataTemplate.mobileManageField?eval>
  <#assign mobileOtherJson=bpmDataTemplate.mobileOtherJson?eval>
</#noparse>

<#--日期选择器 日期范围 日期时分秒 普通日期-->
<#macro genQueryDate field>
	<#switch field.qt>
		<#case "between">
			<ht-date-picker
        size="mini"
        v-model="searchForm.${field.colPrefix!}${field.na}"  
         <#if field.ctrlType!="">type="${field.ctrlType}"<#else>type="daterange"</#if>
        class="search-item"
        range-separator="至"
        start-placeholder="开始日期"
        end-placeholder="结束日期"
        operation="${field.qt}"
        placeholder="${field.cm}"
        ht-query="${field.colPrefix!}${field.na}"
        name="Q^${field.colPrefix!}${field.na}^${field.qt}"
        <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
        <#if field.format>
          value-format="${field.format}"
          format="${field.format}"
        <#else>
          value-format="yyyy-MM-dd HH:mm:ss"
          format="yyyy-MM-dd HH:mm:ss"
        </#if>
        <#if field.option?if_exists>
          format="${field.option.dateFormat}"
          <#if field.option.dateFormat = 'yyyy-MM-dd'></#if>
          :default-time="['00:00:00','23:59:59']"
        </#if>
			></ht-date-picker>
			<#break>
		<#default>
			<ht-date
        size="mini"
        v-model="searchForm.${field.colPrefix!}${field.na}"
       <#if field.ctrlType!="">type="${field.ctrlType}"<#else>type="date"</#if>
        class="search-item"
        placeholder="${field.cm}"
        ht-query="${field.colPrefix!}${field.na}"
        name="Q^${field.colPrefix!}${field.na}^${field.qt}"
        <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
        <#if field.option?if_exists>
          format="${field.option.dateFormat}"
          value-format="${field.option.dateFormat}"
          <#if field.option.dateFormat == 'yyyy-MM-dd' && field.qt == 'EQUAL' >
            operation="RIGHT_LIKE"
          <#else>
            operation="${field.qt}"
          </#if>
        <#else>
          <#if field.format>
          value-format="${field.format}"
          format="${field.format}"
        <#else>
          value-format="yyyy-MM-dd"
          format="yyyy-MM-dd"
        </#if>
          operation="${field.qt}"
        </#if>
			></ht-date>
			<#break>
	</#switch>
</#macro>

<#--单选按钮或复选框 -->
<#function getCheckboxOrRadio field>
	<#assign rtn>
		<#if field.controlContent?if_exists>
			<#if field.controlContent?if_exists>
				<#if field.ct=='radio'>
           <ht-radio size="mini" isBtnRadio v-model="searchForm.${field.colPrefix!}${field.na}" class="search-item" operation="${field.qt}" ht-query="${field.colPrefix!}${field.na}" name="Q^${field.colPrefix!}${field.na}^${field.qt}"
                   <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
                   :props="{key:'key',value:'value'}"
                    rdlist='${util.getJsonByPath(field,'controlContent')}'
        >
        </ht-radio>
				<#else>
					<el-checkbox-group size="mini" v-model="searchForm.${field.colPrefix!}${field.na}" class="search-item" operation="${field.qt}" ht-query="${field.colPrefix!}${field.na}" name="Q^${field.colPrefix!}${field.na}^${field.qt}">
						<#list field.controlContent as opt>
							<el-checkbox label="${opt.key}">${opt.value}</el-checkbox>
						</#list>
					</el-checkbox-group>
				</#if>
			</#if>
		</#if>
	</#assign>
	<#return rtn>
</#function>

<#-- 获取按钮的主题，没有的话默认为primary -->
<#function getBtnTheme manage>
	<#return 1>
</#function>

<#--获取条件-->
<#function getCondition condition field>
	<#assign rtn="">
	<#list condition as con>
	<#--处理运算符-->
		<#assign operate=con.op >
	<#--处理值-->
		<#assign val=con.val >
		<#if (field.dataType=="varchar") >
			<#assign val="'"+val+"'" >
		</#if>

		<#if con_index==0>
			<#assign rtn="value" + operate + val >
		<#else>
			<#assign rtn=rtn + " && value" + operate + val >
		</#if>
	</#list>
	<#return rtn>
</#function>

<div class="form-list">
<HtTemplateBatchUpdateDialog ref="templateBatchUpdateDialog" @onConfirm="onConfirm"></HtTemplateBatchUpdateDialog>
<div class="form-list--header" >
  <#--  合并查询  -->
  <van-search
    v-if="isMergeSearchConditions"
    class="form-list--search"
    v-model="searchKeywords"
    @input="handleSearch"
    placeholder="搜索"
  />
  <div class="filter-config">
    <van-dropdown-menu class="config-item" :class="{'has-sort':sortCondition.length}" active-color="#409EFF">
        <van-dropdown-item title="排序" ref="sortItem">
        <ht-mobile-sort 
        ref="mobileSort"
        :mobileDisplayField='mobileDisplayFieldStr'
       <#noparse> mobilePermission='${mobilePermission.mobile_sort}'</#noparse>
       @handleAscOrDesc="handleAscOrDesc"
        ></ht-mobile-sort>
        </van-dropdown-item>
      </van-dropdown-menu>
      <#--  <van-dropdown-menu class="config-item" active-color="#409EFF">
        <van-dropdown-item title="过滤树" ref="item"></van-dropdown-item>
      </van-dropdown-menu>  -->
      <template v-for="item in topSearchConfig">
      <div
        class="config-item"
        :class="{ 'active-item': (activeKey === 'filter' && item.key === 'filter') || (isBatch &&item.key === 'batch')}"
        :key="item.key"
        @click="handleClickTopSearch(item)"
      >
        <span>{{ item.value }}</span>
        <i class="btn-icon" :class="item.className"></i>
      </div>
      </template>
  </div>
</div>
<div class="form-list--content" 
:class="{
  'has-bottom--btn':topButtons&&topButtons.length,
  'has-merge-search':isMergeSearchConditions,
  'has-search-bottomBtn':topButtons&&topButtons.length&&isMergeSearchConditions
  }"
>
<#--汇总设置-->
		<#if summaryFields?if_exists>
				<@genSummaryField/>
		</#if>
  <van-pull-refresh v-model="refreshing" @refresh="onRefresh">
    <van-list
      v-model="mobileLoading"
      :finished="finished"
      finished-text="没有更多了"
      @load="search"
    >
    <template v-if="rows.length&&(mobileDisplayField.length || titleMap.isTitle || mobileStatusMap.isStatus)">
      <van-cell v-for="item in rows" :key="item.id">
        <div class="field-wrap" :class="{'hide-checkbox':!isBatch}">
          <div class="field-item--title" v-if="titleMap.isTitle || mobileStatusMap.isStatus">
          <#list mobileOtherJson as field>
            <#if field.isTitle>
              <div class="top-box">
                <van-checkbox
                  v-model="item.checked"
                  v-show="isBatch"
                  shape="square"
                  style="marginRight:12px"
                ></van-checkbox>
                <@genFormaterTitleAndStatus field=field item=item/>
                <#--  <span class="title" v-if="titleMap.isTitle">{{item[titleMap.isTitle]}}</span>  -->
              </div>
              </#if>
              <#if field.isStatus>
                <#noparse><#if isShowMobileStatus == true></#noparse>
                <@genFormaterTitleAndStatus field=field item=item/>
                <#--  <span class="status">{{getStatusValue(item)}}</span>  -->
                <#noparse></#if> </#noparse>
              </#if>
            </#list>
          
          </div>
          <div class="field-content">
          <#list mobileDisplayField as field>
            <#noparse><#if mobilePermission.</#noparse>${field.name}<#noparse>></#noparse>
              <div
                class="field-items"
                key="${field.name}"
                <#if (field.formatterType=="2" || field.formatterType=="3") && (field.urlType == 'noUrl' || field.urlType == '')>
                :class="['field-items-wrap']"
                </#if>
              >
                <span class="field-item--label">${ field.desc }：</span>
                
                  <#if field.proSetting>
                  <#--进度条-->
                    <van-progress :percentage="getProValue(item.${field.name},${field.ruleSetting})"
                          :color="getProColor('${util.toJsonStr(field.ruleSettings)}',item)"></van-progress>
                  <#elseif field.urlType=='edit'>
                    <span
                        class="follow-theme-color field-item-value__wrap"
                      @click='operating("${templateId}",item.${pkField},"select","","","${field.openType}","${field.quitAfterSaving}","",false,false,item);'
                        :title="$td('eip.common.showDetails', '查看详情')"
                        <#if field.ruleSettings?if_exists>
                          :style="getColor('${util.toJsonStr(field.ruleSettings)}',item)"
                        </#if>
                    >
                      <#if field.formatterData?if_exists>
                        <span>{{queryFormatterData(item.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
                      <#else>
                        <#if field.isDesensitization>
                      <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
                        <span>
                          {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
                        </span>
                      </el-tooltip>
                          <#else>
                          <span>{{ item['${field.name}'] }}</span>
                          </#if>
                      </#if>
                    </span>
                  <#elseif field.urlType=='url'>
                    <span
                       style="color:'#409eff'"
                        @click='openUrl("${field.mobileUrl}","${field.openType}",item,"${field.name}");'
                        class="follow-theme-color field-item-value__wrap"
                        :title="$td('eip.common.jumpToOtherURL', '跳转到其他URL地址')"
                        <#if field.ruleSettings?if_exists>
                          :style="getColor('${util.toJsonStr(field.ruleSettings)}',item)"
                        </#if>
                    >
                      <#if field.formatterData?if_exists>
                        <span>{{queryFormatterData(item.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
                      <#else>
                        <#if field.isDesensitization>
                      <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
                        <span>
                          {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
                        </span>
                      </el-tooltip>
                          <#else>
                          <span>{{ item['${field.name}'] }}</span>
                          </#if>
                      </#if>
                    </span>
                  <#else>
                    <span
                      class="field-item-value__wrap"
                      <#if field.ruleSettings?if_exists>
                        :style="getColor('${util.toJsonStr(field.ruleSettings)}',item)"
                      </#if>
                    >
                      <#if field.formatterType=="1" || field.formatterType=="4"> <#--格式化设置-->

                        <#if field.formatterData?if_exists>
                          <span>{{queryFormatterData(item.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
                        <#else>
                          <span v-if="display('0') && switchMap.${field.name}">
                          <span v-if="item.${field.name} == switchMap.${field.name}.on">
                            {{switchMap.${field.name}.onLabel}}
                          </span>
                          <span v-else-if="item.${field.name} == switchMap.${field.name}.off">
                            {{switchMap.${field.name}.offLabel}}
                          </span>
                          <span v-else>
                          <#if field.isDesensitization>
                      <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
                        <span>
                          {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
                        </span>
                      </el-tooltip>
                          <#else>
                          <span class="field-item--value">{{ item['${field.name}'] }}</span>
                          </#if>
                          </span>
                        </span>
                        <span v-else>
                        <#if field.isDesensitization>
                      <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
                        <span>
                          {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
                        </span>
                      </el-tooltip>
                          <#else>
                         <span class="field-item--value">{{ item['${field.name}'] }}</span>
                          </#if>
                        </span>
                        </#if>

                      <#elseif field.formatterType=="2"><#--附件-->
                      <template v-if="item.${field.name}">
                        <ht-file v-model="item.${field.name}" :key="item.${pkField} + '_' + item.${field.name}" name="${field.name}"
                          permission="r"
                          :allow-preview="true"
                          :allow-download="true"
                          :multiple="true"
                          :simplicity="true"
                          >
                        </ht-file>
                      </template>
                      <#elseif field.formatterType=="3"><#--图片-->
                        <template v-if="item.${field.name}">
                          <ht-picture v-model="item.${field.name}" :key="item.${pkField} + '_' + item.${field.name}" name="${field.name}"
                          permission="r"
                          :allow-preview="true"
                          :allow-download="true"
                          :multiple="true">
                        </ht-picture>
                        </template>
                      <#else>
                        <#if field.isDesensitization>
                        <el-tooltip class="item" effect="dark" :content="formatCascade(item.${field.name})+''" placement="top">
                          <span>
                            {{desensitization(formatCascade(item.${field.name}),${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
                          </span>
                        </el-tooltip>
                        <#else>
                        <span>
                          {{formatCascade(item,'${field.oldTableField}')}}
                          </span>
                        </#if>
                      </#if>
                    </span>
                  </#if>
                
              </div>
             <#noparse></#if></#noparse>
            </#list> 
          </div>
          <footer class="footer-wrap" v-if="filedList&&filedList.length">
           <#noparse>
             <ht-mobile-popover btnType="text" ref="htMobilePopover">
               <template slot="genFirstBtn">
	             <#list manageFields as manage>
	               <@genEditAndDelBtn manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	             </#list>
               </template>
               <template slot="genManage">
                <#list manageFields as manage>
                  <@genManage manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
                 </#list>
               </template>
             </ht-mobile-popover>
            </#noparse>
          </footer>
        </div>
      </van-cell>
    </template>
      <van-empty
        v-else
        class="no-data-image"
        :image="noDataImage"
        description="暂无数据"
      />
    </van-list>
  </van-pull-refresh>
</div>
<footer class="form-list--footer">
    <van-checkbox
      v-model="checkedAll"
      class="checked-all"
      v-show="isBatch"
      shape="square"
      @click="handleCheckedAll"
    >全选</van-checkbox>
   <#noparse>
    <ht-mobile-popover ref="htMobilePopover">
      <template slot="genFirstBtn">
	    <#list mobileManageField as manage>
	      <@genAddAndDelBtn manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	    </#list>
      </template>
      <template slot="genManage">
       <#list mobileManageField as manage>
        <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
       </#list>
      </template>
    </ht-mobile-popover>
   </#noparse>
</footer>
<#--  过滤弹窗  -->
<van-action-sheet
    v-model="showFilterAction"
    class="filter-action"
    get-container="body"
    :close-on-click-overlay="false"
  >
    <van-nav-bar
      title="筛选"
      left-text="关闭"
      @click-left="handleClickLeft"
    />
    <div class="content">
      <ht-table-search-panel v-if="hasFilterQuery" v-model="searchForm" :divide="1" :label-width="0" ref="searchPanel">
          <#list conditionFields as field>
            <@genCondition field=field/>
          </#list>
        </ht-table-search-panel>
        
      <van-empty
        v-else
        class="no-search-image"
        :image="noSearchData"
        description="暂未配置查询条件"
      />
      
    </div>
  </van-action-sheet>
  <#--  表单列表弹窗模式  -->
  <ht-template-form-dialog ref="templateFormDialog" ></ht-template-form-dialog>
</div>
<#--  汇总  -->
<#macro genSummaryField>
      <div 
      v-if="isShowSummary"
      class="summary-box" 
      :style="{'--summaryHeight':calcMobileSummaryHeight()}" 
      :class="{'set-summary-height':isSetSummaryHeight}">
      <template v-for="item in summaryFields">
        <div
          class="summary-item"
          :key="item.field"
        >
          <div class="summary-item--title" v-if="item.name&&item.name.length > 8" v-html="mobileSummaryTitle(item.name)">{{ item.name }}</div>
          <div v-else class="summary-item--title">{{item.name}}</div>
          <ul class="summary-item--content" >
            <template v-for="it in summaryTableData">
              <li
                class="summary-content-box"
                :key="it.key"
                v-if="it.key !== 'currentPage'"
              >
                <span class="summary-content__label">{{ it.project }}</span>
                <span class="summary-content-value">{{ it[item.field]?it[item.field]: it[item.field] == 0 ? 0 :'-'}}</span>
              </li>
            </template>
          </ul>
        </div>
      </template>
    </div>
</#macro>
<#--生成格式化函数-->
<#macro genFormaterFunction>
	<#if displayFields?if_exists>
		<#list displayFields as field>
			<#assign alarmSetting=field.alarmSetting >
			<#assign formater=field.formater>
			<#if formater?if_exists>
				function ${field.name}_Formater(value, row, index){
				${formater};
				}
			<#elseif alarmSetting?if_exists>
				<#assign alarm=alarmSetting >
				function ${field.name}_AlarmFormater(value, row, index){
				<#list alarm as item>
					if(${getCondition(item.condition,field)}){
					return "<span style='color:${item.color};font-weight:bold;'>" + value +"</span>";
					}
				</#list>
				return value;
				}

			</#if>
		</#list>
	</#if>
</#macro>

<#--生成查询条件宏 -->
<#macro genCondition field>
	<#assign content=field.controlContent>
	<ht-table-search-field :label="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${field.name}'}', '${field.cm}')" prop="${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" v-if="display('${field.mpDisplay}')" v-show="${!field.isShow}">
		<#if field.vf=="static" >
		<#-- colPrefix如果是外部表，值是返回"",非外部表的话就会有一个前缀，所以这里直接用这个拼接就行 -->
			<#switch field.ct>
				<#case "onetext">
					<#if field.ty == 'number'>
						<ht-input isMobileSearchNum :precision="999" type="number" size="mini" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '请输入数字')"  name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable></ht-input>
					<#else>
						<ht-input type="text" size="mini" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')"  name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable @keyup.enter.native="searchEnterFun"></ht-input>
					</#if>
					<#break>
          <#-- 自定义对话框 -->
				<#case "customDialog">
					<#assign dg=content>
						<ht-custom-dialog
								v-model="searchForm.${field.colPrefix!}${field.na}"
								model-name="searchForm.${field.na}"
								class="search-item search-custom-dialog mobile-search-custom"
								isFromList="true"
								ht-query="${field.colPrefix!}${field.na}"
								special-query="${field.colPrefix!}${field.na}"
								operation="${field.qt}"
                isSearchSelect
								:custdialog='${util.getCustDialogAttr(field.colPrefix,field)}'
								permission="w"
               <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
								atter="searchForm.${field.colPrefix!}${field.na}">
						</ht-custom-dialog>
					<#break>
				<#case "date"><#--日期选择器 -->
					<@genQueryDate field=field/>
					<#break>
				<#case "select"><#--下拉选项-->
					<#assign options=content>
						<#if util.getJsonByPath(field.option,'choiceType')=="dynamic">
							<ht-select v-model="searchForm.${field.colPrefix!}${field.na}" 
              model-name="searchForm.${field.colPrefix!}${field.na}"
              class="search-item mobile-search--select" 
              ht-query="${field.colPrefix!}${field.na}" 
              operation="${field.qt}"
              isSearchSelect
             <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> 
             :validate="${field.validate}"</#if> 
                <#if field.cm?if_exists>:placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')" </#if>
                :ganged="${util.getSelectQuery(field.option,type!=1)}"
              >
							</ht-select>
						<#else>
            <ht-select v-model="searchForm.${field.colPrefix!}${field.na}" 
              model-name="searchForm.${field.colPrefix!}${field.na}"
              class="search-item mobile-search--select" 
              ht-query="${field.colPrefix!}${field.na}" 
              operation="${field.qt}"
              isSearchSelect
              isAddAll
              :clearable="false"
              name="Q^${field.colPrefix!}${field.na}^${field.qt}"
             <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> 
             :validate="${field.validate}"</#if> 
               placeholder="请选择" 
              :options="mobileSearchMap['${field.na}'].controlContent"
              >
							</ht-select>
						</#if>
					<#break>
				<#case "dic"><#--数据字典-->
					<#assign dickey=util.getJsonByPath(field.controlContent,'alias')>
					<#assign resultField=util.getJsonByPath(field.controlContent,'resultField')>
					<div style="display:inline-block;" class="col-md-12">
						<div ht-dic='${field.colPrefix!}${field.na}' dickey="${dickey}" resultfield="${resultField}" ht-query="${field.colPrefix!}${field.na}" bind="${field.colPrefix!}${field.na}" :desc="$td('${'formTemplate.${bpmDataTemplate.alias}.search.dic'}', '数据字典')" type="text"  ng-model="${field.colPrefix!}${field.na}" class="form-control"  <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> ></div>
					</div>
					<#break>
				<#case "radio"><#--单选按钮 -->
				<#case "checkbox"><#--复选框 -->
					${getCheckboxOrRadio(field)}
					<#break>
				<#default>
					<ht-input type="text" size="mini" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')" name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable @keyup.enter.native="searchEnterFun"></ht-input>
					<#break>
			</#switch>
		</#if>
	</ht-table-search-field>
</#macro>
<#noparse>
	<#--管理列-->
	<#macro genEditAndDelBtn manage managePermission actionUrl data>
	<#--编辑-->
	<#if manage.name == 'edit' && manage.linePosition>
	<#if managePermission.edit >
  <div class="footer-item" 
  v-if="permission.edit && display('${manage.mpDisplay}') && scriptBeforeHandler('${manage.beforeScriptValue}',item)"
  @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:item.${pkField} || item.id,action:'edit',defId:'${bpmDataTemplate.defId}',
				isStartFlow:item.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})"
  >
    <i class="icon-bianji11 footer-btn--icon"></i>
    <#if manage.desc?length gt 4>
    <span class="footer-item--text">
    {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
    </span>
    <#else>
    <span class="footer-item--text">
    {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}
    </span>
    </#if>
  </div>
  </#if>
	<#--删除-->
	<#elseif manage.name == 'del'  && manage.linePosition>
	<#if managePermission.del>
	<div class="footer-item" 
  v-if="permission.del && display('${manage.mpDisplay}') && scriptBeforeHandler('${manage.beforeScriptValue}',item)" 
  @click="scriptClick('del','${manage.afterScriptValue}',{pkField:item.${pkField} || item.id})">
  <i class="icon-shanchu footer-btn--icon"></i>
 <#if manage.desc?length gt 4>
  <span class="footer-item--text">
   {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </span>
  <#else>
  <span class="footer-item--text">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
  </#if>
  </div>
	</#if>
	<#else>
	</#if>
	</#macro>

	<#--管理列更多按钮-->
	<#macro genManage manage managePermission actionUrl data>
  <#--明细-->
	<#if manage.name == 'detail' && manage.linePosition >
	<#if managePermission.detail >
  <div 
  class="footer-item" 
    v-if="display('${manage.mpDisplay}')&& scriptBeforeHandler('${manage.beforeScriptValue}',item)"
    @click='editMmethod("get",item.${pkField}|| item.id);'
  >
  <#if manage.desc?length gt 4>
  <span class="footer-item--text">
   {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </span>
  <#else>
  <span class="footer-item--text">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
  </#if>
  </div>
	</#if>
   <#--发起流程-->
  <#elseif manage.name == 'startFlow' && manage.linePosition >
	<#if managePermission.startFlow >
  <div 
  class="footer-item" 
    v-if="!item.isStartFlow&& '${bpmDataTemplate.defId}' && display('${manage.mpDisplay}')&& scriptBeforeHandler('${manage.beforeScriptValue}',item)"
    @click='startFlow(item.${pkField}||item.id,"${manage.afterScriptValue}",{row:item,id:item.${pkField} || item.id});'
  >
  <#if manage.desc?length gt 4>
  <span class="footer-item--text">
   {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </span>
  <#else>
  <span class="footer-item--text">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
  </#if>
  </div>
	</#if>
  <#--更新数据-->
  <#elseif manage.name == 'batchUpdate' && manage.linePosition >
	<#if manage.linePosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig) >
  <div 
  class="footer-item" 
    v-if="display('${manage.mpDisplay}') && scriptBeforeHandler('${manage.beforeScriptValue}',item)"
  @click="scriptClick('batchUpdate','${manage.afterScriptValue}',{row:item,position:'${manage.linePosition}',desc:'${manage.desc}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})"
  >
  <#if manage.desc?length gt 4>
  <span class="footer-item--text">
   {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </span>
  <#else>
  <span class="footer-item--text">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
  </#if>
  </div>
	</#if>
  <#--js按钮-->
  <#elseif manage.name == 'js' && manage.linePosition >
	<#if manage.linePosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue) >
  <div 
  class="footer-item" 
     v-if="display('${manage.mpDisplay}')&& scriptBeforeHandler('${manage.beforeScriptValue}',item)"
    @click='customEvilJS(item,"${manage.jsValue}",{},"${manage.afterScriptValue}")'
  >
  <#if manage.desc?length gt 4>
  <span class="footer-item--text">
   {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </span>
  <#else>
  <span class="footer-item--text">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
  </#if>
  </div>
	</#if>
	<#else>
	</#if>
	</#macro>

  	<#--新增按钮顶部-->
	<#macro genAddAndDelBtn manage managePermission actionUrl data>
	  <#-- 新增 -->
	<#if manage.name == 'add'>
	<#if managePermission.add>
  <#if manage.desc?length gt 4>
	<van-button  
	class="form-list__footer--btn"
  v-if="showScriptButton&&showScriptButton.add&&permission.add && display('${manage.mpDisplay}')" 
  @click="scriptClick('add','${manage.afterScriptValue}',{templateId:'${templateId}',id:'',action:'add',defId:'${bpmDataTemplate.defId}',isStartFlow:'',
  openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',initSubData: '${manage.initSubData}'})">
  {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </van-button>
 <#else>
  <van-button  
	class="form-list__footer--btn"
  v-if="showScriptButton&&showScriptButton.add&&permission.add && display('${manage.mpDisplay}')" 
  @click="scriptClick('add','${manage.afterScriptValue}',{templateId:'${templateId}',id:'',action:'add',defId:'${bpmDataTemplate.defId}',isStartFlow:'',
   openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',initSubData: '${manage.initSubData}'})">
   {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}
   </van-button>
  </#if>
	</#if>
	</#if>
  	<#-- 删除 -->
	<#if manage.name == 'del'>
	<#if managePermission.del && manage.topPosition>
  <#if manage.desc?length gt 4>
	<van-button 
  class="form-list__footer--btn" 
  :class="{'footer-btn--del':isAddBtn}"
  :disabled="!(isBatch&&currentSelected.length)"
  v-show="showScriptButton&&showScriptButton.del" 
  v-if="permission.del && display('${manage.mpDisplay}')" 
  @click="scriptClick('deleted','${manage.afterScriptValue}')"  
  >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </van-button>
  <#else>
  <van-button 
  class="form-list__footer--btn" 
  :class="{'footer-btn--del':isAddBtn}"
  :disabled="!(isBatch&&currentSelected.length)"
  v-show="showScriptButton&&showScriptButton.del" 
  v-if="permission.del && display('${manage.mpDisplay}')" 
  @click="scriptClick('deleted','${manage.afterScriptValue}')"  
  >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}
  </van-button>
  </#if>
	</#if>
	</#if>
	</#macro>
	<#--顶部按钮-->
	<#macro genToolBar manage managePermission actionUrl btnIndex>
  <#-- 批量更新数据 -->
  <#if manage.name == 'batchUpdate'>
	<#if manage.topPosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
  <#if manage.desc?length gt 4>
	<div 
  class="footer-btn--update" 
  v-show="getButtonShowByJs('${manage.buttonId}', 'batchUpdate')"
  @click="scriptClick('batchUpdate','${manage.afterScriptValue}',{buttonId:'${manage.buttonId}',desc:'${manage.desc}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})"
  >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}'.substring(0,4))}}...
  </div>
  <#else>
  <div
  class="footer-btn--update" 
  v-show="getButtonShowByJs('${manage.buttonId}', 'batchUpdate')"
  @click="scriptClick('batchUpdate','${manage.afterScriptValue}',{buttonId:'${manage.buttonId}',desc:'${manage.desc}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})"
  >132{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}
  </div>
  </#if>
	</#if>
	</#if>
	</#macro>
</#noparse>
<#--  标题和状态格式化内容  -->
<#macro genFormaterTitleAndStatus field item>
        <#if field.urlType=='edit'>
          <span
              class="follow-theme-color field-item-value__wrap"
              @click='operating("${templateId}",item.${pkField},"select","","","${field.openType}","${field.quitAfterSaving}","",false,false,item);'
              :title="$td('eip.common.showDetails', '查看详情')"
              <#if field.ruleSettings?if_exists>
                :style="getColor('${util.toJsonStr(field.ruleSettings)}',item)"
              </#if>
          >
            <#if field.formatterData?if_exists>
              <span class="field-item__value">{{queryFormatterData(item.${field.name},'${util.toJsonStr(field.formatterData)}') || '-'}}</span>
            <#else>
              <#if field.isDesensitization>
            <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
              <span class="field-item__value">
                {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`) || '-'}}
              </span>
            </el-tooltip>
                <#else>
                <span class="field-item__value">{{ item['${field.name}'] || '-' }}</span>
                </#if>
            </#if>
          </span>
        <#elseif field.urlType=='url'>
          <span
              style="color:'#409eff'"
              @click='openUrl("${field.mobileUrl}","${field.openType}",item,"${field.name}");'
              class="follow-theme-color field-item-value__wrap"
              :title="$td('eip.common.jumpToOtherURL', '跳转到其他URL地址')"
              <#if field.ruleSettings?if_exists>
                :style="getColor('${util.toJsonStr(field.ruleSettings)}',item)"
              </#if>
          >
            <#if field.formatterData?if_exists>
              <span class="field-item__value">{{queryFormatterData(item.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
            <#else>
              <#if field.isDesensitization>
            <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
              <span class="field-item__value">
                {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
              </span>
            </el-tooltip>
                <#else>
                <span class="field-item__value">{{ item['${field.name}'] }}</span>
                </#if>
            </#if>
          </span>
        <#else>
          <span
            class="field-item-value__wrap"
            <#if field.isTitle>
             :class="['title-item__wrap']"
             <#elseif field.isStatus>
             :class="['status-item__wrap']"
            </#if>
            
            <#if field.ruleSettings?if_exists>
              :style="getColor('${util.toJsonStr(field.ruleSettings)}',item,'${field.isStatus}' ? 'isStatus' : '')"
            </#if>
          >
            <#if field.formatterType=="1" || field.formatterType=="4"> <#--格式化设置-->

              <#if field.formatterData?if_exists>
                <span class="field-item__value">{{queryFormatterData(item.${field.name},'${util.toJsonStr(field.formatterData)}') || '-'}}</span>
              <#else>
                <span v-if="display('0') && switchMap.${field.name}">
                <span v-if="item.${field.name} == switchMap.${field.name}.on">
                  {{switchMap.${field.name}.onLabel}}
                </span>
                <span v-else-if="item.${field.name} == switchMap.${field.name}.off">
                  {{switchMap.${field.name}.offLabel}}
                </span>
                <span v-else>
                <#if field.isDesensitization>
            <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
              <span class="field-item__value">
                {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`) || '-'}}
              </span>
            </el-tooltip>
                <#else>
                <span class="field-item__value">{{ item['${field.name}'] || '-' }}</span>
                </#if>
                </span>
              </span>
              <span v-else>
              <#if field.isDesensitization>
            <el-tooltip class="item" effect="dark" :content="item.${field.name}+''" placement="top">
              <span class="field-item__value">
                {{desensitization(item.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`) || '-'}}
              </span>
            </el-tooltip>
                <#else>
                <span class="field-item__value">{{ item['${field.name}'] || '-' }}</span>
                </#if>
              </span>
              </#if>
            <#else>
              <#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="formatCascade(item.${field.name})+''" placement="top">
                <span class="field-item__value">
                  {{desensitization(formatCascade(item.${field.name}),${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`) || '-'}}
                </span>
              </el-tooltip>
              <#else>
              <span class="field-item__value">
                {{formatCascade(item,'${field.oldTableField}') || '-'}}
                </span>
              </#if>
            </#if>
          </span>
        </#if>
</#macro>