<#macro subDiv layout>
  <#assign subTablePath=layout.options.subTablePath>
    <#assign subDivTablePath=layout.options.subDivTablePath>
      <#assign subListPath=layout.options.subTablePath>
        <#assign sunBos=util.getSunBos(layout.list)>
          <#assign hasLinkage=util.getHasLinkage(layout.list)>
            <el-container sunBos="${sunBos}" v-if="!permission.table.${layout.options.boSubEntity}.hidden" 
           :style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}',0.1)"
            <#if !isMobile> class="sub-div-pc"</#if>
             <#if isMobile>style="flex-direction:column;" class="sub-div-mobile"</#if>>
              <#if !isMobile>
                <el-header
                   :style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}',0.1)"
                 style="height:30px;line-height:30px;background:var(--headerBgColor) !important; font-weight: bold;font-size: 14px;<#if layout.tableTitleColor>color:${layout.tableTitleColor};
                <#elseif formSetting && formSetting.fontColor> color:${formSetting.fontColor?replace('\"','')};</#if>">
                  ${layout.desc}
                  <div v-if="!isView && permission.table.${layout.options.boSubEntity}.del && '${layout.options.relation}'!='onetoone'" :style="{display:'inline-block',float:'right'}">
                    <el-button type="text" icon="el-icon-delete" size="small" :style="{padding:'0px 5px'}" @click="clearAllMessageBox('${subTablePath}')">
                      {{$t('ht.common.clear')}}
                    </el-button>
                  </div>
                  <#if layout.subtableBackfill>
                    ${getSubDialog(layout)}
                  </#if>
                  <#if layout.options.relation!='onetoone'>
                    <div v-if="!isView && permission.table.${layout.options.boSubEntity}.add" :style="{display:'inline-block',float:'right'}">
                      <el-button
                        size="small"
                        type="text"
                        icon="el-icon-circle-plus-outline"
                        @click="addSubTab('data.${subTablePath}')"
                        :disabled="isShowAddButton('data.${subDivTablePath}',${layout.options.maxRow})">添加子表</el-button>
                    </div>
                  </#if>
                  <#if layout.options.relation=='onetoone'>
                    <div
                      v-show="'${layout.options.relation}'=='onetoone' && data.${subTablePath} && data.${subTablePath}.length<1"
                      v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                      :style="{display:'inline-block',float:'right'}">
                      <el-button
                        size="small"
                        type="text"
                        icon="el-icon-circle-plus-outline"
                        @click="addSubTab('data.${subTablePath}')"
                        :style="{display:'inline-block',float:'right'}"></el-button>
                    </div>
                  </#if>
                  <#if layout.initTemplateData && layout.customQuery && layout.customQuery.alias??>
                    ${getSubtableCustomQueryBackfill(layout)}
                  </#if>
                </el-header>
              </#if>
              <#if isMobile>
                <div class="sub-div-header" style="display: flex;justify-content: space-between;background: rgb(244, 244, 244);padding: 0 16px;align-items: center;height: 48px;">
                  <span style="color:#222222;font-size:16px;font-weight:bold;">
                    ${layout.desc}
                  </span>
                  <div style="display:flex;align-items:center;">
                    <#if layout.initTemplateData && layout.customQuery && layout.customQuery.alias??>
                      ${getSubtableCustomQueryBackfill(layout)}
                    </#if>
                    <#if layout.subtableBackfill>
                      ${getSubDialog(layout)}
                    </#if>
                    <el-button v-if="!isView && permission.table.${layout.options.boSubEntity}.del && '${layout.options.relation}'!='onetoone'"
                      type="text" icon="el-input__icon el-icon-delete" size="small" @click="clearAll('${subTablePath}')">
                    </el-button>
                  </div>
                </div>
              </#if>
              <el-main>
                <div 
                   :style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}',0.05)"
                class="formT_box">
                  <div class="xh_table" id="xh_tablegd_${subListPath}" v-tableDrag
                    <#if layout.subSort && layout.sortField && layout.sortDirection>
                    v-subSort="{field: '${layout.sortField}', direction: '${layout.sortDirection}'}"
                    </#if>
                    >
                    <div class="xh_hdleft" :style="left_image" id="lefthk_${subListPath}" @click="xhleft('${subListPath}')"></div>
                    <ht-collapse class="sub-collapse" :openDefault="getExpandArr(data.${subTablePath},'${layout.options.dataExpand}')">
                      <ht-collapse-item v-for="(item, $index) in data.${subTablePath}" :name="item.sub_guid" :key="$index" class="sub-collapse-item">
                        <div slot="title" class="sub-collapse-item-title">
                          <#if isMobile>
                            ${getFieldTitle(layout.fieldTitle, '${layout.desc}{{$index + 1}}', 'sub-div-title-mobile', true)}
                            <#else>
                              ${getFieldTitle(layout.fieldTitle, '${layout.desc}{{$index + 1}}', 'sub-div-title', false)}
                          </#if>
                          <div>
                            <span v-if="!isView && !(!permission.table.${layout.options.boSubEntity}.del &&
                        !permission.table.${layout.options.boSubEntity}.add) && '${layout.options.relation}'!='onetoone'" @click="transitionIndex = -1">
                              <#-- <#if !isMobile>
                                <el-button
                                  v-if="permission.table.${layout.options.boSubEntity}.add"
                                  size="small"
                                  type="text"
                                  icon="el-icon-plus"
                                  @click.stop="addSubTab('data.${subDivTablePath}', item.sub_guid)"
                                  :disabled="isShowAddButton('data.${subDivTablePath}',${layout.options.maxRow})"></el-button>
                                </#if> -->
                                <el-button size="small" type="text" icon="el-icon-copy-document" v-if="permission.table.${layout.options.boSubEntity}.add
                              && '${layout.options.relation}'!='onetoone' && !item.sub_row_readonly"
                                  <#if layout.options.maxRow>
                                  :disabled="isShowAddButton('data.${subListPath}',${layout.options.maxRow})"
                                  </#if>
                                  @click.stop="copy(data.${subDivTablePath},item,'data.${subDivTablePath}')"
                                  ><#if !isMobile> 复制 </#if>
                                </el-button>
                                <el-button size="small" type="text" icon="el-icon-delete" v-if="permission.table.${layout.options.boSubEntity}.del && '${layout.options.relation}'!='onetoone' && !item.sub_row_readonly" @click.stop="deleteRow('${subDivTablePath}',item)">
                                  <#if !isMobile>删除</#if>
                                </el-button>
                            </span>
                            <#if isMobile>
                              <el-button size="small" type="text" icon="el-icon-caret-bottom"></el-button>
                            </#if>
                          </div>
                        </div>
                        <table class="form-table" cellspacing="0" cellpadding="0" border="0" :key="item.sub_guid || $index" :sub-index="$index" :data-index="$index" data-subname="data.${subTablePath}" :row_readonly="item.sub_row_readonly">
                          <tbody>
                            <tr :class="'data-index__' + $index">
                              <td colspan="30">
                                <#list layout.list as field>
                                  <#if (field.ctrlType !='suntable' && field.ctrlType !='sunDiv' )>
                                    <#if field.ctrlType=='grid'>
                                     <template 
                                     <#if field.permissionPath?if_exists>
                                      v-if="permission.fields.${field.permissionPath}!='n'"
                                      :isShow="permission.fields.${field.permissionPath}!='n'"
                                     </#if>
                                     >
                                      <el-row
                                       :style="handleTableStyle('${field.options.lableColor}','${field.options.gridDescBagColor}','${field.options.borderStyle}')"
                                       class="   ${field.options.aBorder}${field.options.lineType} gridMargin  "    
													   lineStyle="${field.options.aBorder}${field.options.lineType}"
													:class="{'is-columns-span-all':isColumnsSpanAll('${field.options.span}','${field.options.justify}'),'is-hasGridBorderission':hasGridBorderission('${field.options.aBorder}${field.options.lineType}'), 'is-noGridBorderission':noGridBorderission('${field.options.aBorder}${field.options.lineType}')}"
													style='border-color:var(--borderColor);background-color:${field.options.gridBackgroundColor}'  type="flex" <#if hasLinkage==true> v-if="(!permission || !permission.subFields) ||(permission.subFields && !(${util.getSubRowPermission(field.columns)}) )"
                                    </#if> :gutter="${field.options.gutter?number+24}" justify="${field.options.justify}" >
                                    <#list field.columns as gridGroup>
                                      <el-col class="ht-el-col-${field.options.align}" :span="${gridGroup.span}" style="${gridGroup.style}"    >
                                        <#list gridGroup.list as gridField>
                                          ${getFormItem(gridField,2,hasLinkage)}
                                        </#list>
                                      </el-col>
                                    </#list>
                                    </el-row>
                                    </template>
                                    <#else>
                                      <el-row <#if !field.options.noBindModel || util.isNoAttrField(field)> v-if="${getPermission(field,true)}!='n' && !(permission.sub_${field.tableName} && permission.sub_${field.tableName}.${field.name}$index !='n')"
                                  </#if>>
                                  ${getFormItem(field,2,hasLinkage)}
                                  </el-row>
                                  </#if>
                                  <#else>
                                    <el-row v-if="!permission.table.${field.name}.hidden">
                                      <#if field.ctrlType=='suntable'>
                                        <@sunTable layout=field />
                                        <#else>
                                          <@sunDiv layout=field />
                                      </#if>
                                    </el-row>
                                    </#if>
                                </#list>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </ht-collapse-item>
                    </ht-collapse>
                    <#-- 移动端底部添加子表按钮 -->
                      <#if isMobile>
                        <#if layout.options.relation!='onetoone'>
                          <el-button
                            class="add-sub-btn"
                            v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                            size="small"
                            type="text"
                            icon="el-icon-circle-plus-outline"
                            @click="addSubTab('data.${subTablePath}')"
                            :disabled="isShowAddButton('data.${subDivTablePath}',${layout.options.maxRow})">添加子表</el-button>
                        </#if>
                        <#if layout.options.relation=='onetoone'>
                          <el-button
                            class="add-sub-btn"
                            v-show="'${layout.options.relation}'=='onetoone' && data.${subTablePath} && data.${subTablePath}.length<1"
                            v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                            size="small"
                            type="text"
                            icon="el-icon-circle-plus-outline"
                            @click="addSubTab('data.${subTablePath}')">添加子表</el-button>
                        </#if>
                        <#else>
                        <#if layout.options.relation!='onetoone'>
                          <el-button
                            class="add-sub-btn"
                            v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                            plain
                             style="margin:8px 0;width: calc(100% - 0px); borderColor:var(--borderColor)!important;color: var(--themeColor);"
                            icon="el-icon-circle-plus-outline"
                            @click="addSubTab('data.${subTablePath}')"
                            :disabled="isShowAddButton('data.${subDivTablePath}',${layout.options.maxRow})">添加子表</el-button>
                        </#if>
                        <#if layout.options.relation=='onetoone'>
                          <el-button
                            class="add-sub-btn"
                            v-show="'${layout.options.relation}'=='onetoone' && data.${subTablePath} && data.${subTablePath}.length<1"
                            v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                            size="small"
                            style="margin:8px 0;width: calc(100% - 0px);
                            borderColor:var(--borderColor)!important;color: var(--themeColor);
                            "
                            plain
                            icon="el-icon-circle-plus-outline"
                            @click="addSubTab('data.${subTablePath}')">添加子表</el-button>
                        </#if>
                      </#if>
                      <div class="xh_hd" :style="right_image" id="righthk_${subListPath}" @click="xhright('${subListPath}')"></div>
                  </div>
                </div>
              </el-main>
            </el-container>
</#macro>
<#function getSubDialog layout>
  <#assign custdialogConf=util.getStringConf(layout.customDialogjson)>
    <#assign rtn>
      <ht-sub-dialog
        v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
        relation="${layout.options.relation}"
        :custdialog='${custdialogConf}'
        init-fill-data="${layout.initTemplateData}"
        init-fill-data-type="${layout.initTemplateDataType}"
        :max-row="${util.getNumber(layout.options.maxRow, 0)}"
        :list-length="data.${subTablePath}.length"
        newInitVersion="true" />
    </#assign>
    <#return rtn>
</#function>
<#function getFieldTitle fieldTitle defaultTitle cssClass isMobile>
  <#assign title>
    <#if fieldTitle?if_exists && fieldTitle?length gt 0>
      <span v-if="item.${fieldTitle} && item.${fieldTitle} != ''" class="${cssClass}">
        <#if !isMobile><i class="el-icon-caret-right" style="margin-right: 6px;"></i></#if>
        {{item['${fieldTitle}']}}
      </span>
      <span v-else class="${cssClass}">
        <#if !isMobile><i class="el-icon-caret-right" style="margin-right: 6px;"></i></#if>
        ${defaultTitle}
      </span>
      <#else>
        <span class="${cssClass}">
          <#if !isMobile><i class="el-icon-caret-right" style="margin-right: 6px;"></i></#if>
          ${defaultTitle}
        </span>
    </#if>
  </#assign>
  <#return title>
</#function>