<#macro sunTable layout>
<#assign subTablePath=layout.options.subTablePath>
<#assign sunTablePath=util.getSunTablePath(layout.options.subTablePath,"$index")>
<#assign sunTableNewPath=util.getSunTablePath(layout.options.subTablePath,"getPageOffset('data.${layout.list[0].boDefAlias}.sub_${layout.boSubEntity}') + $index")>
<#assign subName=util.getSubName(layout.options.subTablePath,"$index")>
<#assign hasLinkage=util.getHasLinkage(layout.list)>
<el-container v-if="!permission.table.${layout.options.boSubEntity}.hidden" class="ht-sun-table-container"
:style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}')"
>
  <el-header 
   class="printHide sun-table__title"
    <#if layout.tableTitleColor>style="color:${layout.tableTitleColor}"
      <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
    >
  	${layout.desc}
  	 <div class="table-header-btn__wrap" v-if="!isView && permission.table.${layout.options.boSubEntity}.del && '${layout.options.relation}'!='onetoone'"  :style="{display:'inline-block',float:'right'}">
	    <el-button type="text" icon="icon-qingkong" class="clear-all-btn" size="small" :style="{padding:'0px 5px'}" @click="clearAllMessageBox({subTablePath: '${subTablePath}',index: $index})">
            {{$t('ht.common.clear')}}
    	</el-button>
      </div>
  	 <#if layout.subtableBackfill>
  	 	${getSunDialog(layout)}
  	 </#if>
  </el-header>
  <el-main class="sun-table_main">
      <el-scrollbar>
      <div class="grandson_table_wrap" >
        <table class="form-table" cellspacing="0" cellpadding="0" border="0">
          <thead>
              <#if layout.customHeader gt 1 >
                ${util.decodeBase64(layout.customHeader)}
              <#else>
                <tr class="sub-table-header" @click="transitionIndex = -1">
                  <#if layout.options.relation!='onetoone'><th class="sub-table_index" <#if formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>>{{$t('ht.common.seq')}}</th></#if>
                  <#list layout.list as field>
                    <#assign tip = util.getJsonByPath(field.options,"tip")>
                    <#assign labelstyleWidth = util.getJsonByPath(field.options,"labelstyleWidth")>
                    <th <#if field.options.hideCtrl> v-show="false"</#if>
                        <#if !field.options.noBindModel || util.isNoAttrField(field)> v-if="${getPermission(field,true)}!='n'"</#if>
                            style="<#if !field.options.labelstyleWidth></#if>
                                    font-weight:${util.getStyleBold(field.options,'boldLable')};
                                    ${util.getStyles(field.options,'color','lableColor')};
                                    ${util.getStyles(field.options,'min-width','labelstyleWidth')};
                                    <#if !field.options.lableColor && formSetting && formSetting.fontColor>color:${formSetting.fontColor?replace('\"','')}</#if>
                                    "
                                    class="<#if !field.options.labelstyleWidth>sub-table__header-th</#if>"
                                    >
                        <div class="table-header__cell">
                        <#if !field.options.noBindModel || util.isNoAttrField(field)><span  v-if="${getPermission(field,true)}=='b'">*</span></#if>
                        <#if tip?length gt 0>
                            <el-tooltip placement="top">
                                <div slot="content" >${field.options.tip}</div>
                                <i class="el-icon-question" />
                            </el-tooltip>
                        </#if>
                        <span style="${util.getFieldStyle(field.options)}">${field.desc}</span>
                        </div>
                    </th>
                  </#list>
                   <#if layout.options.relation!='onetoone'> 
                   <th class="printHide sub-table_operate" 
                   v-if="permission.table.${layout.options.boSubEntity}.del"
                   <#if formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                   >{{$t('ht.common.operation')}}</th>
                   </#if>
                </tr>
              </#if>
          </thead>
          <tbody>
              <tr v-for="(item, sunIndex) in data.${sunTableNewPath}" :key="item.sub_guid || sunIndex" :data-index="sunIndex" :class="{'transition':sunIndex==transitionIndex}" :data-subname="'data.${layout.list[0].boDefAlias}.sub_${layout.boSubEntity}[' + (getPageOffset('data.${layout.list[0].boDefAlias}.sub_${layout.boSubEntity}') + $index) + '].sub_${layout.name}'">
                <#if layout.options.relation!='onetoone'><td @click="transitionIndex = -1" align="center" >{{sunIndex + 1}}</td></#if>
                <#list layout.list as field>
                    <td <#if field.options.hideCtrl> v-show="false"</#if> @click="transitionIndex = -1" <#if !field.options.noBindModel || util.isNoAttrField(field)> v-if="${getPermission(field,3)}!='n' " </#if> style="font-weight:${util.getStyleBold(field,'boldValue')};${util.getStyles(field,'color','valueColor')};${util.getStyles(field,'width','width')};">
                    <div class="table-body__cell" 
                              <#if field.options.labelstyleWidth> style="width:${field.options.labelstyleWidth}px;"</#if>
                               >
                       <@input field=field type=3 hasLinkage=hasLinkage/>
                    </div>
                    </td>
                </#list>
                <#if layout.options.relation!='onetoone'>
                  <td <#if field.options.hideCtrl> v-show="false"</#if> class="trash printHide" v-if="permission.table.${layout.options.boSubEntity}.del">
                      <el-button size="small" type="text" icon="icon-application-delete" class="copy-btn" v-if="!isView && permission.table.${layout.options.boSubEntity}.del" @click="deleteSunRow('${subTablePath}',item,getPageOffset('data.${layout.list[0].boDefAlias}.sub_${layout.boSubEntity}') + $index)">{{$t('ht.common.delete')}}</el-button>
                      <el-button size="small" type="text"
                      class="delete-btn"
                      icon="icon-copy"
                       v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                                 <#if layout.options.maxRow>
                                    :disabled="isShowAddButton('data.${subTablePath}',${layout.options.maxRow}, $index)"
                                 </#if>
                                 @click="copy(data.${sunTableNewPath},item)">{{$t('ht.common.copy')}}</el-button>
                  </td>
                </#if>
              </tr>
          </tbody>
          <#if layout.options.relation!='onetoone'>
              <tfoot class="printHide table-footer" @click="transitionIndex = -1">
                <tr v-if="!isView && permission.table.${layout.options.boSubEntity}.add">
                  <td colspan="30" style="textAlign:left">
                    <el-button
                      size="small"
                      type="text"
                      class="add-btn"
                      icon="el-icon-circle-plus-outline"
                      @click="addSunTab('data.${subTablePath}', $index)"
                      <#if layout.options.maxRow>
                          :disabled="isShowAddButton('data.${subTablePath}',${layout.options.maxRow}, $index)"
                      </#if>
                    >{{$t('ht.common.add')}}</el-button>
                  </td>
                </tr>
              </tfoot>
           </#if>
           <#if layout.options.relation=='onetoone'>
              <tfoot @click="transitionIndex = -1" v-show="'${layout.options.relation}'=='onetoone' && data.${sunTablePath}.length<1">
                <tr v-if="!isView && permission.table.${layout.options.boSubEntity}.add" class="table-footer__add">
                  <td colspan="30" style="textAlign:left">
                    <el-button
                      size="small"
                      type="text"
                      class="add-btn"
                      icon="el-icon-circle-plus-outline"
                      @click="addSunTab('data.${subTablePath}',getPageOffset('data.${layout.list[0].boDefAlias}.sub_${layout.boSubEntity}') + $index)"
                    >{{$t('ht.common.add')}}</el-button>
                  </td>
                </tr>
              </tfoot>
           </#if>
        </table>
        </div>
      </el-scrollbar>
  </el-main>
</el-container>
</#macro>

<#function getSunDialog layout >
    <#assign custdialogConf  = util.getStringConf(layout.customDialogjson)>
    <#assign rtn>
      <template v-if="!isView">
        <ht-sub-dialog
          relation="${layout.options.relation}"
    	  :custdialog='${custdialogConf}'
    	  init-fill-data="${layout.initTemplateData}"
    	  init-fill-data-type="${layout.initTemplateDataType}"
          :max-row="${util.getNumber(layout.options.maxRow, 0)}"
          :sub-index="$index"
        />
      </template>
    </#assign>
    <#return rtn>
</#function>
