<#macro subTable layout>
<#assign subListPath=layout.options.subTablePath>
<#assign sunBos=util.getSunBos(layout.list)>
<#assign subTablePath=layout.options.subTablePath>
<#assign hasLinkage=util.getHasLinkage(layout.list)>
<div v-if="!permission.table.${layout.options.boSubEntity}.hidden" class="form-table__container"  
:style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}')">
  <div sunBos="${sunBos}"
  class="form-table-header"
  >
  	<div class="flex" style="justify-content: space-between;">
  		<span class="sub-table__title"
      <#if layout.tableTitleColor>style="color:${layout.tableTitleColor}"
      <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
      >${layout.desc}</span>
	  	<div class="printHide table-header-btn__wrap" style="display:flex">
            <#if layout.customSearchQuery>
                <el-input placeholder="输入${layout.customSearchQueryText}查询" v-model="searchVal" clearable style="margin:0px 10px;width:300px !important"  suffix-icon="el-icon-search" class="searchInput" ></el-input>
            </#if>
          <#if layout.subtableBackfill>
            ${getSubTableDialog(layout)}
          </#if>
          <#if layout.subtableImportExport>
              <div class="import-export__wrap" style="display:flex" v-if="permission.table.${layout.options.boSubEntity}.add">${getSubImportDialog(layout)}</div>
          </#if>
          <template v-if="!isView && permission.table.${layout.options.boSubEntity}.del && '${layout.options.relation}'!='onetoone'">
            <el-button type="text" icon="icon-qingkong" size="mini" class="clear-all-btn" @click="clearAllMessageBox({subTablePath: '${subTablePath}'})">
                {{$t('ht.common.clear')}}
            </el-button>
        </template>
	  	 </div>
  	 </div>
  	 <#if layout.initTemplateData && layout.customQuery && layout.customQuery.alias?? >
  	 	${getSubtableCustomQueryBackfill(layout)}
  	 </#if>
  </div>
  <div class="form-table_box">
  	<#assign orgConfigStr = util.getJsonByPath(layout,'customDialogjson.orgConfig')>
    <#assign orgConfigJson = util.getJsonStr(orgConfigStr)>
        <div class="xh_table" id="xh_tablegd_${subListPath}"  
       
            <#if layout.subSort && layout.sortField && layout.sortDirection>
                v-subSort="{field: '${layout.sortField}', direction: '${layout.sortDirection}'}"
            </#if>
        >
            <div class="xh_hdleft" :style="left_image" id="lefthk_${subListPath}" @click="xhleft('${subListPath}')"></div>
            <#if layout.vxeTable>
                <vxe-table
                        ref="xh_tablegd_${subListPath}"
                        name="xh_tablegd_${subListPath}"
                        :scroll-y="{enabled: true, gt: 0, mode: 'wheel'}"
                        :scroll-x="{enabled: true, gt: 0, mode: 'wheel'}"
                        :column-config="{resizable: true}"
                        <#if layout.rowHeight?if_exists>
                            :row-config="{height: ${layout.rowHeight}}"
                        </#if>
                        show-overflow

                        height="<#if layout.fixedHeight?if_exists>${layout.fixedHeight}<#else>300</#if>"
                        :data="<#if layout.subtablePagination>pagingSubData('data.${subListPath}','${layout.customSearchQuery}')<#else>setSubData(data.${subListPath},'${layout.customSearchQuery}')</#if>"
                        :onload='initFill("${subListPath}",${orgConfigJson})'
                        :show-summary="handleSummary('${layout.showSummary}','${layout.CombinedColumnListJson}')"
                        :summary-method="data=>getSummaries(data,'${layout.CombinedColumnListJson}')"
                        key="${subListPath}"
                        stripe
                        :header-cell-style="handleCellStyle"
                        :header-row-style="handleRowStyle('${layout.tableHeaderBgColor}')"
                        <#if layout.freezeTableHeader >max-height="${layout.tableHeight}"</#if>
                        border
                        :row-class-name="({row, rowIndex}) => {return 'data-subname__data.${subListPath} ' + 'row_readonly__' + row.sub_row_readonly + ' data-index__' + (getPageOffset('data.${subListPath}') + rowIndex)}"
                        style="width: 100%">
                    <#--<vxe-table-column title="Index" width="60">-->
                        <#--<template #default="{row,row:item,rowIndex:$index}">-->
                            <#--{{ $index }}-->
                        <#--</template>-->
                    <#--</vxe-table-column>-->
                    <#if layout.customHeader gt 1 >
                        ${util.decodeBase64(layout.customHeader)}
                    <#else>
                        <#if layout.options.relation!='onetoone'>
                            <vxe-column
                                    field="seq" type="seq"
                                    align="center" key="tableIndex" width="60" :title="$t('ht.common.seq')"
                                    <#if layout.freezeTableCol && layout.freezeCol >fixed</#if>
                            >
                                <template slot="header" slot-scope="{row,row:item,rowIndex:$index}">
                  <span
                          <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                  >序号</span>
                                </template>
                            </vxe-column>
                        </#if>
                        <#list layout.list as field>
                            <#assign tip = util.getJsonByPath(field.options,"tip")>
                            <#assign boldLable = util.getJsonByPath(field.options,"boldLable")>
                            <#if (field.ctrlType != 'suntable' && field.ctrlType != 'sunDiv')>
                                <vxe-column
                                        align="center"
                                        field="${field.name}"
                                        key="${field.name}_${field_index}"
                                        title="${field.desc}"
                                        <#if field.options.labelBgColor && !field.options.hideCtrl>class-name="header-bg-color__${field.options.labelBgColor}"</#if>
                                        <#if layout.freezeTableCol && field_index lte layout.freezeCol >fixed</#if>
                                        <#if !field.options.hideCtrl && field.options.labelstyleWidth>width="${field.options.labelstyleWidth}"<#else>min-width="120"</#if>

                                        <#if field.options.hideCtrl> :visible="false" width="1"</#if>
                                        <#if !field.options.hideCtrl && (!field.options.noBindModel || util.isNoAttrField(field))> v-if="${getPermission(field,true)}!='n'"</#if>
                                >
                                    <#if !field.options.hideCtrl>
                                        <template slot="header" slot-scope="{row,row:item,rowIndex:$index}">
                                            <#if !field.options.noBindModel || util.isNoAttrField(field)>
                                                <span style="color:#e55555" v-if="${getPermission(field,true)}=='b'">*</span>
                                            </#if>
                                            <#if tip?length gt 0>
                                                <el-tooltip placement="top">
                                                    <div slot="content" >
                                                        <#if field.ctrlType != 'text'>
                                                            <#if field.tipI18nKey?if_exists>
                                                                <span v-html="$td('${field.tipI18nKey}','${field.options.tip}')"></span>
                                                            <#else>
                                                                ${field.options.tip}
                                                            </#if>
                                                        </#if>
                                                    </div>
                                                    <i class="el-icon-question" />
                                                </el-tooltip>
                                            </#if>
                                            <span
                                                    <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                               ><#if field.i18nKey?if_exists>
                                                    {{$td("${field.i18nKey}","${field.desc}")}}
                                                <#else>
                                                    ${field.desc}
                                                </#if>
                              </span>
                                        </template>
                                    </#if>
                                    <template slot-scope="{row,row:item,rowIndex:$index}">
                                        <@input field=field type=2 hasLinkage=hasLinkage layout=layout/>
                                    </template>
                                </vxe-column>
                            <#else>
                                <vxe-column
                                        key="${field.name}"
                                        align="center"
                                        v-if="!permission.table.${field.name}.hidden"
                                        title="${field.desc}"
                                        <#if !field.options.hideCtrl && field.options.labelstyleWidth>width='${field.options.labelstyleWidth}'
                                        <#else>
                                            min-width="300"
                                        </#if>
                                        <#if field.options.hideCtrl> class-name="hidden" width="1"</#if>
                                >
                                    <#if !field.options.hideCtrl>
                                        <template slot="header" slot-scope="{row,row:item,rowIndex:$index}">
	                          <span
                                      <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
	                          >${field.desc}</span>
                                        </template>
                                    </#if>
                                    <template slot-scope="{row,row:item,rowIndex:$index}">
                                        <#if field.ctrlType == 'suntable'>
                                            <@sunTable layout=field />
                                        <#else>
                                            <@sunDiv layout=field />
                                        </#if>
                                    </template>
                                </vxe-column>
                            </#if>
                        </#list>
                        <#if layout.options.relation!='onetoone'>
                            <vxe-column
                                    title="操作"
                                    key="tableOperate"

                                    <#if layout.freezeTableOperate>fixed="right"</#if>
                                    align="center"
                                    <#if field.options.labelstyleWidth>width=${field.options.labelstyleWidth}<#else> width="200"</#if>
                                    <#if field.options.hideCtrl> v-show="false"</#if> class="trash printHide" v-if="permission.table.${layout.options.boSubEntity}.del">
                                <template slot="header" slot-scope="{row,row:item,rowIndex:$index}">
                      <span
                              <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                      >操作</span>
                                </template>
                                <template slot-scope="{row,row:item,rowIndex:$index}">
                                    <el-button size="small" type="text" class="copy-btn" icon="icon-copy"
                                               v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                                            <#if layout.options.maxRow>
                                                :disabled="isShowAddButton('data.${subListPath}',${layout.options.maxRow})"
                                            </#if>
                                               @click="copy(data.${subListPath},row,'data.${subListPath}')">{{$t('ht.common.copy')}}</el-button>
                                    <el-button size="small" class="delete-btn" type="text" icon="icon-application-delete"
                                               v-if="!isView && permission.table.${layout.options.boSubEntity}.del && !row.sub_row_readonly" @click="deleteRow('${subListPath}',row)">{{$t('ht.common.delete')}}</el-button>

                                    <#list layout.list as field>
                                        <#if (field.ctrlType == 'signature' )>
                                            <el-button size="small" v-if="isShowSignature('${field.fieldPath}','${field.options.hideCtrl}')"  type="text" icon="icon-shenpiyijian"   :disabled="isDisabledSignature(row,'${field.fieldPath}')"  @click="signatureRow('${subListPath}',row,data.${subListPath},'${field.fieldPath}')">
                                                签章</el-button>

                                        </#if>
                                    </#list>
                                </template>
                            </vxe-column>
                            <#list layout.list as field>
                                <vxe-column
                                        v-if="!permission.table.${layout.options.boSubEntity}.del  && isShowSignature('${field.fieldPath}','${field.options.hideCtrl}')"
                                        title="操作"
                                        key="tableOperate"

                                        <#if layout.freezeTableOperate>fixed="right"</#if>
                                        align="center"
                                        <#if field.options.labelstyleWidth>width=${field.options.labelstyleWidth}<#else> width="200"</#if>
                                        <#if field.options.hideCtrl> v-show="false"</#if> class="trash printHide" >
                                    <template slot="header" slot-scope="{row,row:item,rowIndex:$index}">
                      <span
                              <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                      >操作</span>
                                    </template>
                                    <template slot-scope="{row,row:item,rowIndex:$index}">



                                        <#if (field.ctrlType == 'signature' )>
                                            <el-button size="small" v-if="isShowSignature('${field.fieldPath}','${field.options.hideCtrl}')"  type="text" icon="icon-shenpiyijian"   :disabled="isDisabledSignature(row,'${field.fieldPath}')"  @click="signatureRow('${subListPath}',row,data.${subListPath},'${field.fieldPath}')">
                                                签章</el-button>

                                        </#if>

                                    </template>
                                </vxe-column>
                            </#list>
                        </#if>
                    </#if>
                </vxe-table>
            <#else >
                <el-table
                        <#if layout.freezeTableCol && field_index lte layout.freezeCol && layout.omitLoad?if_exists >v-resize-omit-load</#if>
                        :key="forceUpdate"
                        name="xh_tablegd_${subListPath}"
                        :data="<#if layout.subtablePagination>pagingSubData('data.${subListPath}','${layout.customSearchQuery}')<#else>setSubData(data.${subListPath},'${layout.customSearchQuery}')</#if>"
                        :onload='initFill("${subListPath}",${orgConfigJson})'
                        :show-summary="handleSummary('${layout.showSummary}','${layout.CombinedColumnListJson}')"
                        :summary-method="data=>getSummaries(data,'${layout.CombinedColumnListJson}')"
                        key="${subListPath}"
                        :stripe=false
                        :header-cell-style="handleCellStyle"
                   
                      
                        <#if layout.options.headerStyle?if_exists > header-style='${layout.options.headerStyle}' </#if>
                        
                        <#if layout.freezeTableHeader >max-height="${layout.tableHeight}"</#if>
                        border
                        :row-class-name="({row, rowIndex}) => {return 'data-subname__data.${subListPath} ' + 'row_readonly__' + row.sub_row_readonly + ' data-index__' + (getPageOffset('data.${subListPath}') + rowIndex)}"
                        style="width: 100%">
                    <#if layout.customHeader gt 1 >
                        ${util.decodeBase64(layout.customHeader)}
                    <#else>
                        <#if layout.options.relation!='onetoone'>
                            <el-table-column
                                    type="index" align="center" key="tableIndex" width="60" :label="$t('ht.common.seq')"
                                    <#if layout.freezeTableCol && layout.freezeCol >fixed</#if>
                            >
                                <template slot="header" slot-scope="{row,row:item,$index}">
                  <span
                          <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                  >序号</span>
                                </template>
                            </el-table-column>
                        </#if>
                        <#list layout.list as field>
                            <#assign tip = util.getJsonByPath(field.options,"tip")>
                            <#assign boldLable = util.getJsonByPath(field.options,"boldLable")>
                            <#if (field.ctrlType != 'suntable' && field.ctrlType != 'sunDiv')>
                                <el-table-column
                                        align="center"
                                        prop="${field.name}"
                                        key="${field.name}_${field_index}"
                                        label="${field.desc}"
                                        <#if field.options.labelBgColor && !field.options.hideCtrl>class-name="header-bg-color__${field.options.labelBgColor}"</#if>
                                        <#if layout.freezeTableCol && field_index lte layout.freezeCol >fixed</#if>
                                        <#if !field.options.hideCtrl && field.options.labelstyleWidth>width="${field.options.labelstyleWidth}"<#else>min-width="120"</#if>

                                        <#if field.options.hideCtrl> class-name="hidden" width="1"</#if>
                                        <#if !field.options.hideCtrl && (!field.options.noBindModel || util.isNoAttrField(field))> v-if="${getPermission(field,true)}!='n'"</#if>
                                >
                                    <#if !field.options.hideCtrl>
                                        <template slot="header" slot-scope="{row,row:item,$index}">
                                            <#if !field.options.noBindModel || util.isNoAttrField(field)>
                                                <span style="color:#e55555" v-if="${getPermission(field,true)}=='b'">*</span>
                                            </#if>
                                            <#if tip?length gt 0>
                                                <el-tooltip placement="top">
                                                    <div slot="content" >
                                                        <#if field.ctrlType != 'text'>
                                                            <#if field.tipI18nKey?if_exists>
                                                                <span v-html="$td('${field.tipI18nKey}','${field.options.tip}')"></span>
                                                            <#else>
                                                                ${field.options.tip}
                                                            </#if>
                                                        </#if>
                                                    </div>
                                                    <i class="el-icon-question" />
                                                </el-tooltip>
                                            </#if>
                                            <span
                                                    <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                               ><#if field.i18nKey?if_exists>
                                                    {{$td("${field.i18nKey}","${field.desc}")}}
                                                <#else>
                                                    ${field.desc}
                                                </#if>
                              </span>
                                        </template>
                                    </#if>
                                    <template slot-scope="{row,row:item,$index}">
                                        <@input field=field type=2 hasLinkage=hasLinkage layout=layout/>
                                    </template>
                                </el-table-column>
                            <#else>
                                <el-table-column
                                        key="${field.name}"
                                        align="center"
                                        v-if="!permission.table.${field.name}.hidden"
                                        label="${field.desc}"
                                        <#if !field.options.hideCtrl && field.options.labelstyleWidth>width='${field.options.labelstyleWidth}'
                                        <#else>
                                            min-width="300"
                                        </#if>
                                        <#if field.options.hideCtrl> class-name="hidden" width="1"</#if>
                                >
                                    <#if !field.options.hideCtrl>
                                        <template slot="header" slot-scope="{row,row:item,$index}">
	                          <span
                                      <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
	                          >${field.desc}</span>
                                        </template>
                                    </#if>
                                    <template slot-scope="{row,row:item,$index}">
                                        <#if field.ctrlType == 'suntable'>
                                            <@sunTable layout=field />
                                        <#else>
                                            <@sunDiv layout=field />
                                        </#if>
                                    </template>
                                </el-table-column>
                            </#if>
                        </#list>
                        <#if layout.options.relation!='onetoone'>
                            <el-table-column
                                    label="操作"
                                    key="tableOperate"

                                    <#if layout.freezeTableOperate>fixed="right"</#if>
                                    align="center"
                                    <#if field.options.labelstyleWidth>width=${field.options.labelstyleWidth}<#else> width="200"</#if>
                                    <#if field.options.hideCtrl> v-show="false"</#if> class="trash printHide" v-if="permission.table.${layout.options.boSubEntity}.del">
                                <template slot="header" slot-scope="{row,row:item,$index}">
                      <span
                              <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                      >操作</span>
                                </template>
                                <template slot-scope="{row,row:item,$index}">
                                    <el-button size="small" type="text" class="copy-btn" icon="icon-copy"
                                               v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                                            <#if layout.options.maxRow>
                                                :disabled="isShowAddButton('data.${subListPath}',${layout.options.maxRow})"
                                            </#if>
                                               @click="copy(data.${subListPath},row,'data.${subListPath}')">{{$t('ht.common.copy')}}</el-button>
                                    <el-button size="small" class="delete-btn" type="text" icon="icon-application-delete"
                                               v-if="!isView && permission.table.${layout.options.boSubEntity}.del && !row.sub_row_readonly" @click="deleteRow('${subListPath}',row)">{{$t('ht.common.delete')}}</el-button>

                                    <#list layout.list as field>
                                        <#if (field.ctrlType == 'signature' )>
                                            <el-button size="small" v-if="isShowSignature('${field.fieldPath}','${field.options.hideCtrl}')"  type="text" icon="icon-shenpiyijian"   :disabled="isDisabledSignature(row,'${field.fieldPath}')"  @click="signatureRow('${subListPath}',row,data.${subListPath},'${field.fieldPath}')">
                                                签章</el-button>

                                        </#if>
                                    </#list>
                                </template>
                            </el-table-column>
                            <#list layout.list as field>
                                <el-table-column
                                        v-if="!permission.table.${layout.options.boSubEntity}.del  && isShowSignature('${field.fieldPath}','${field.options.hideCtrl}')"
                                        label="操作"
                                        key="tableOperate"

                                        <#if layout.freezeTableOperate>fixed="right"</#if>
                                        align="center"
                                        <#if field.options.labelstyleWidth>width=${field.options.labelstyleWidth}<#else> width="200"</#if>
                                        <#if field.options.hideCtrl> v-show="false"</#if> class="trash printHide" >
                                    <template slot="header" slot-scope="{row,row:item,$index}">
                      <span
                              <#if field.options.lableColor>style="color:${field.options.lableColor}" <#elseif formSetting && formSetting.fontColor> style="color:${formSetting.fontColor?replace('\"','')}"</#if>
                      >操作</span>
                                    </template>
                                    <template slot-scope="{row,row:item,$index}">



                                        <#if (field.ctrlType == 'signature' )>
                                            <el-button size="small" v-if="isShowSignature('${field.fieldPath}','${field.options.hideCtrl}')"  type="text" icon="icon-shenpiyijian"   :disabled="isDisabledSignature(row,'${field.fieldPath}')"  @click="signatureRow('${subListPath}',row,data.${subListPath},'${field.fieldPath}')">
                                                签章</el-button>

                                        </#if>

                                    </template>
                                </el-table-column>
                            </#list>
                        </#if>
                    </#if>
                </el-table>
            </#if>

            <#if layout.options.relation!='onetoone' && layout.options.relation!=''>
              <div class="table-footer printHide" @click="transitionIndex = -1">
                <el-button
                  v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                  size="small"
                  type="text"
                  class="add-btn"
                  icon="el-icon-circle-plus-outline"
                  @click="addSubTab('data.${subListPath}')"
                  <#if layout.options.maxRow>
                    :disabled="isShowAddButton('data.${subListPath}',${layout.options.maxRow})||searchVal!==''"
                  <#else>
                    :disabled="searchVal!==''"
                  </#if>
                >{{$t('ht.common.add')}}</el-button>

              </div>
              <#if layout.subtablePagination>
                <div class="pagination-wrap">
                  <ht-sub-pagination
                    :rows="data.${subListPath}"
                    data-subname="data.${subListPath}"
                    @validate-sub-table="validateSubTable">
                  </ht-sub-pagination>
                </div>
                </#if>
               </#if>
            <#if layout.options.relation=='onetoone'>
                <div
                  v-if="!isView && permission.table.${layout.options.boSubEntity}.add && data.${subListPath}.length<1"
                  class="table-footer__add"
                  @click="transitionIndex = -1"
                >
                    <el-button
                      size="small"
                      type="text"
                      class="add-btn"
                      :disabled="searchVal!==''"
                      icon="el-icon-circle-plus-outline"
                      @click="addSubTab('data.${subListPath}')"
                    >{{$t('ht.common.add')}}</el-button>
                </div>
              </#if>
            <div class="xh_hd" :style="right_image" id="righthk_${subListPath}" @click="xhright('${subListPath}')"></div>
        </div>
  </div>
</div>
</#macro>

<#function getSubTableDialog layout >
    <#assign custdialogConf  = util.getStringConf(layout.customDialogjson)>
    <#assign rtn>
    	 <ht-sub-dialog
    	  v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
          relation="${layout.options.relation}"
    	  :custdialog='${custdialogConf}'
    	  init-fill-data="${layout.initTemplateData}"
    	  init-fill-data-type="${layout.initTemplateDataType}"
          :max-row="${util.getNumber(layout.options.maxRow, 0)}"
           :list-length="data.${subListPath}.length"
          newInitVersion="true"
        />
    </#assign>
    <#return rtn>
</#function>

<#function getSubImportDialog layout >
	<#assign columnsConfig  = util.getSubTableCols(layout.list)>
    <#assign rtn>
    	<ht-sub-export-dialog  <#if layout.subtablePagination> :subtablePagination="${layout.subtablePagination}" </#if> v-if="!isView" data-columns="${columnsConfig}" data-subname="data.${subListPath}" data-subdesc="${layout.desc}"></ht-sub-export-dialog>
    	<ht-sub-import-dialog
            :rows="data.${subListPath}"
            subDesc="${layout.desc}"
            <#if layout.options.maxRow>
                maxRow="${layout.options.maxRow}"
            </#if>
                v-if="!isView" data-columns="${columnsConfig}"
            <#if layout.subtableImportMergeExp>merge-expression="${layout.subtableImportMergeExp}"</#if>
            data-subname="data.${subListPath}">
        </ht-sub-import-dialog>
    </#assign>
    <#return rtn>
</#function>
