/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.aop;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ReflectUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.bo.model.ResourceBaseModel;
import com.hotent.form.dto.ResourceAuthActDTO;
import com.hotent.form.dto.ResourceAuthDTO;
import com.hotent.form.manager.FormAuthorizeManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResourcePermissionChecktAspect {
    @Resource
    CommonManager commonManager;
    @Resource
    FormAuthorizeManager formAuthorizeManager;
    @Resource
    UCFeignService ucFeignService;
    public static final String DATA_SCOPE = "dataScope";

    @Around(value="execution(* *..*Controller.*(..))  && @annotation(com.hotent.base.annotation.ResourcePermissionCheck)")
    public Object workflow(ProceedingJoinPoint joinPoint) throws Throwable {
        IUser currentUser;
        ResourcePermissionCheck checkExit;
        Class<?> targetClass = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Method[] methods = targetClass.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        if ((checkExit = method.getAnnotation(ResourcePermissionCheck.class)) == null) {
            return joinPoint.proceed();
        }
        Class superClassGenericType = ReflectionKit.getSuperClassGenericType(targetClass, (int)1);
        Object newInstance = superClassGenericType.newInstance();
        ResourceBaseModel model = null;
        if (!(newInstance instanceof ResourceBaseModel)) {
            return joinPoint.proceed();
        }
        model = (ResourceBaseModel)newInstance;
        Object[] params = joinPoint.getArgs();
        String rightType = ResourcesRightType.USE.getType();
        QueryFilter filter = null;
        for (Object object : params) {
            Optional opt;
            Object object2;
            if (object instanceof QueryFilter) {
                filter = (QueryFilter)object;
                if (!filter.getParams().containsKey("manage")) continue;
                rightType = ResourcesRightType.LIST.getType();
                continue;
            }
            if (!(object instanceof Optional) || !((object2 = (opt = (Optional)object).orElse(null)) instanceof QueryFilter) || !(filter = (QueryFilter)object2).getParams().containsKey("manage")) continue;
            rightType = ResourcesRightType.LIST.getType();
        }
        ResourceModelType authModelType = model.getAuthModelType();
        if (authModelType.getType().equals(ResourceModelType.PC_FORM.getType())) {
            Object object;
            if (filter != null && BeanUtils.isNotEmpty((Object)filter.getQuerys())) {
                for (Object object2 : filter.getQuerys()) {
                    QueryField qf = (QueryField)object2;
                    if (!"formType".equalsIgnoreCase(qf.getProperty()) && !"form_Type_".equalsIgnoreCase(qf.getProperty()) || !"mobile".equals(qf.getValue())) continue;
                    authModelType = ResourceModelType.MOBILE_FORFM;
                    break;
                }
            }
            if (authModelType.getType().equals(ResourceModelType.PC_FORM.getType()) && params.length == 4 && (object = params[1]) instanceof Optional && "mobile".equals(((Optional)object).orElse(null))) {
                authModelType = ResourceModelType.MOBILE_FORFM;
            }
        }
        if ((currentUser = ContextUtil.getCurrentUser()) != null && currentUser.isAdmin()) {
            Object returnVal = joinPoint.proceed();
            if (ResourcesRightType.USE.getType().equals(rightType)) {
                return returnVal;
            }
            this.handleReturnVal(returnVal, authModelType, null);
            return returnVal;
        }
        if (rightType.equals(ResourcesRightType.USE.getType())) {
            Class cls = superClassGenericType;
            Set<String> noRightKeys = this.formAuthorizeManager.getCurUserCanNotUseKeys(authModelType, cls);
            if (BeanUtils.isNotEmpty(noRightKeys)) {
                filter.addFilter(authModelType.getAliasProp(), new ArrayList<String>(noRightKeys), QueryOP.NOT_IN, FieldRelation.AND, "resouceAuthGroup");
            }
            return joinPoint.proceed();
        }
        ResourceAuthDTO resourceAuthDTO = this.formAuthorizeManager.getResourceRightByUserId(currentUser.getUserId(), authModelType.getType(), rightType);
        if (filter != null && CollUtil.isEmpty(resourceAuthDTO.getRightMapAll())) {
            String createIdFiled;
            if (CollUtil.isNotEmpty(resourceAuthDTO.getRightMapModel())) {
                Set modelRight = resourceAuthDTO.getRightMapModel().stream().map(ResourceAuthActDTO::getModelKey).collect(Collectors.toSet());
                filter.addFilter(authModelType.getAliasProp(), new ArrayList(modelRight), QueryOP.IN, FieldRelation.OR, "resouceAuthGroup");
            }
            if (CollUtil.isNotEmpty(resourceAuthDTO.getRightMapType())) {
                Set typeRight = resourceAuthDTO.getRightMapType().stream().map(ResourceAuthActDTO::getModelKey).collect(Collectors.toSet());
                filter.addFilter(authModelType.getTypeIdProp(), new ArrayList(typeRight), QueryOP.IN, FieldRelation.OR, "resouceAuthGroup");
            }
            if (StringUtil.isNotEmpty((String)(createIdFiled = authModelType.getCreateIdProp()))) {
                filter.addFilter(createIdFiled, (Object)currentUser.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "resouceAuthGroup");
            }
        }
        Object returnVal = joinPoint.proceed();
        this.handleReturnVal(returnVal, authModelType, resourceAuthDTO);
        return returnVal;
    }

    private void handleReturnVal(Object returnVal, ResourceModelType authModelType, ResourceAuthDTO resourceAuthDTO) throws IllegalAccessException, NoSuchFieldException {
        if (returnVal instanceof PageList) {
            PageList list = (PageList)returnVal;
            this.handleRight(list.getRows(), authModelType, resourceAuthDTO);
        } else if (returnVal instanceof List) {
            List list = (List)returnVal;
            this.handleRight(list, authModelType, resourceAuthDTO);
        }
    }

    private void handleRight(List list, ResourceModelType authModelType, ResourceAuthDTO resourceAuthDTO) throws IllegalAccessException, NoSuchFieldException {
        if (BeanUtils.isEmpty((Object)list)) {
            return;
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        HashSet<String> fullRight = new HashSet<String>(Arrays.asList(ResourcesRightType.LIST.getType(), ResourcesRightType.EDIT.getType(), ResourcesRightType.DEL.getType()));
        for (Object l : list) {
            if (!(l instanceof ResourceBaseModel)) continue;
            ResourceBaseModel bModel = (ResourceBaseModel)l;
            if (currentUser.isAdmin()) {
                bModel.setResourceRight(fullRight);
                continue;
            }
            Object cteateObj = this.getValue(l, authModelType.getCreateIdProp());
            HashSet<Object> rightSet = new HashSet();
            if (cteateObj != null && ContextUtil.getCurrentUserId().equals(cteateObj)) {
                rightSet = fullRight;
            } else if (resourceAuthDTO != null) {
                ResourceAuthActDTO actDTO;
                Object aliasObj;
                ResourceAuthActDTO actDTO2;
                Object typeIdObj;
                if (CollUtil.isNotEmpty(resourceAuthDTO.getRightMapAll())) {
                    for (ResourceAuthActDTO act2 : resourceAuthDTO.getRightMapAll()) {
                        if (act2.getRightContent() == null) continue;
                        rightSet.addAll(act2.getRightContent());
                    }
                }
                if ((typeIdObj = this.getValue(l, authModelType.getTypeIdProp())) != null && CollUtil.isNotEmpty(resourceAuthDTO.getRightMapType()) && (actDTO2 = (ResourceAuthActDTO)resourceAuthDTO.getRightMapType().stream().filter(act -> act.getModelKey().equals(typeIdObj)).findFirst().orElse(null)) != null && actDTO2.getRightContent() != null) {
                    rightSet.addAll(actDTO2.getRightContent());
                }
                if ((aliasObj = this.getValue(l, authModelType.getAliasProp())) != null && CollUtil.isNotEmpty(resourceAuthDTO.getRightMapModel()) && (actDTO = (ResourceAuthActDTO)resourceAuthDTO.getRightMapModel().stream().filter(act -> act.getModelKey().equals(aliasObj)).findFirst().orElse(null)) != null && actDTO.getRightContent() != null) {
                    rightSet.addAll(actDTO.getRightContent());
                }
            }
            bModel.setResourceRight(rightSet);
        }
    }

    private Object getValue(Object instance, String fieldName) throws IllegalArgumentException, IllegalAccessException {
        if (StringUtil.isEmpty((String)fieldName)) {
            return null;
        }
        List allField = ReflectUtil.getAllField(instance.getClass());
        for (Field field : allField) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            Object object = field.get(instance);
            if (object == null) continue;
            return object;
        }
        return null;
    }
}

