/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.instance.BoDataHandler;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoCopyVo;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.form.manager.FormAuthorizeManager;
import com.hotent.form.service.BoDefIService;
import com.hotent.form.util.CustomUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bo/def/v1/"})
@Api(tags={"\u4e1a\u52a1\u5bf9\u8c61\u5b9a\u4e49"})
@ApiGroup(group={"group_form"})
public class BoDefController
extends BaseController<BoDefManager, BoDef> {
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoDataHandler boDataHandler;
    @Resource
    BoAttributeManager boAttributeManager;
    @Autowired
    BoDefIService boDefService;
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;
    @Resource
    FormAuthorizeManager formAuthorizeManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6bo\u5b9a\u4e49\u5217\u8868")
    @ResourcePermissionCheck
    public PageList<BoDef> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BoDef> queryFilter) throws Exception {
        return ((BoDefManager)this.baseService).queryByPage(queryFilter);
    }

    @RequestMapping(value={"selector/list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6bo\u5b9a\u4e49\u5217\u8868")
    @ResourcePermissionCheck
    public PageList<BoDef> selectorList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BoDef> queryFilter) throws Exception {
        return ((BoDefManager)this.baseService).querySelectorsByPage(queryFilter);
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5df2\u53d1\u5e03bo\u5b9a\u4e49\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u5df2\u53d1\u5e03bo\u5b9a\u4e49\u5217\u8868")
    public List<BoDef> getAll() throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("deployed_", (Object)1, QueryOP.EQUAL);
        List queryNoPage = ((BoDefManager)this.baseService).queryNoPage(queryFilter);
        Set<String> curUserCanNotUseKeys = this.formAuthorizeManager.getCurUserCanNotUseKeys(ResourceModelType.BO, BoDef.class);
        if (BeanUtils.isNotEmpty((Object)queryNoPage)) {
            queryNoPage = queryNoPage.stream().filter(b -> !curUserCanNotUseKeys.contains(b.getAlias())).collect(Collectors.toList());
        }
        return queryNoPage;
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5")
    public BoDef detail(@ApiParam(name="alias", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return ((BoDefManager)this.baseService).getPureByAlias(alias);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5")
    public ObjectNode getJson(@ApiParam(name="id", value="id", required=true) @RequestParam String id) throws Exception {
        return ((BoDefManager)this.baseService).getBoDefDetails(id);
    }

    @RequestMapping(value={"getJsonByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5")
    public ObjectNode getJsonByAlias(@ApiParam(name="alias", value="alias", required=true) @RequestParam String alias) throws Exception {
        return ((BoDefManager)this.baseService).getBoDefDetailsByAlias(alias);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0bo\u5b9a\u4e49", httpMethod="POST", notes="\u6dfb\u52a0bo\u5b9a\u4e49")
    public CommonResult<String> save(@ApiParam(name="json", value="bo\u5b9a\u4e49\u7684json\u6570\u636e", required=true) @RequestBody String json) throws Exception {
        ((BoDefManager)this.baseService).save(json);
        return new CommonResult("\u6dfb\u52a0\u6210\u529f");
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<Integer> remove(@ApiParam(name="alias", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        int removeItems = ((BoDefManager)this.baseService).removeByAlias(alias);
        if (removeItems > 0) {
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)removeItems);
        }
        return new CommonResult(false, "\u5220\u9664\u5931\u8d25", (Object)removeItems);
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        CommonResult<String> res = this.boDefService.batchRemove(ids);
        return res;
    }

    @RequestMapping(value={"getBoJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ebo\u522b\u540d\u8fd4\u56debo\u5bf9\u5e94\u7684JSON\u6570\u636e\u7ed3\u6784", httpMethod="GET", notes="\u6839\u636ebo\u5b9a\u4e49\u8fd4\u56debo\u5bf9\u5e94\u7684JSON\u6570\u636e\u7ed3\u6784")
    public JsonNode getBoJson(@ApiParam(name="alias", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        BoData boData = this.boDataHandler.getByBoDefCode(alias, Boolean.valueOf(true));
        return JsonUtil.toJsonNode((String)boData.toString());
    }

    @RequestMapping(value={"deploy"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03", httpMethod="GET", notes="\u53d1\u5e03")
    public CommonResult deploy(@ApiParam(name="id", value="id", required=true) @RequestParam String id) throws Exception {
        BoDef boDef = ((BoDefManager)this.baseService).getByDefId(id);
        boDef.setDeployed(true);
        ((BoDefManager)this.baseService).update(boDef);
        return new CommonResult(boDef.getDescription() + "\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"setStatus"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u72b6\u6001", httpMethod="GET", notes="\u4fee\u6539\u72b6\u6001")
    public CommonResult setStatus(@ApiParam(name="id", value="id", required=true) @RequestParam String id, @ApiParam(name="status", value="\u72b6\u6001") @RequestParam String status) throws Exception {
        if (status == null || "".equals(status)) {
            status = "normal";
        }
        BoDef boDef = ((BoDefManager)this.baseService).getByDefId(id);
        boDef.setStatus(status);
        ((BoDefManager)this.baseService).update(boDef);
        return new CommonResult(boDef.getDescription() + "\u66f4\u6539\u72b6\u6001\u6210\u529f");
    }

    @RequestMapping(value={"getBOTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6BO\u6811\u5f62\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6BO\u6811\u5f62\u6570\u636e")
    public ObjectNode getBOTree(@ApiParam(name="ids", value="ids", required=true) @RequestBody String ids) throws Exception {
        return ((BoDefManager)this.baseService).getBoTreeData(ids);
    }

    @RequestMapping(value={"getAllBos"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868")
    public List<BoEnt> getAllBos() throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("is_create_table_", (Object)1, QueryOP.EQUAL);
        PageList pageList = this.boEntManager.query(queryFilter);
        return pageList.getRows();
    }

    @RequestMapping(value={"getBoEntById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868")
    public BoEnt getBoEntById(@ApiParam(name="id", value="id", required=true) @RequestParam String id) throws Exception {
        return this.boEntManager.getById(id);
    }

    @RequestMapping(value={"getSupportDb"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868")
    public boolean getSupportDb(@ApiParam(name="alias", value="bo\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return ((BoDefManager)this.baseService).getPureByAlias(alias).isSupportDb();
    }

    @RequestMapping(value={"getObject"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bodef", httpMethod="GET", notes="\u83b7\u53d6bodef")
    public BoDef getObject(@ApiParam(name="id", value="bodef\u4e3b\u952e", required=false) @RequestParam(required=false) String id, @ApiParam(name="key", value="bodef key", required=false) @RequestParam(required=false) String key) throws Exception {
        if (StringUtil.isNotEmpty((String)id)) {
            BoDef boDef = (BoDef)((BoDefManager)this.baseService).get((Serializable)((Object)id));
            return boDef;
        }
        if (StringUtil.isNotEmpty((String)key)) {
            BoDef boDef = ((BoDefManager)this.baseService).getByAlias(key);
            return boDef;
        }
        return null;
    }

    @RequestMapping(value={"updateCategory"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539bodef\u5206\u7c7b", httpMethod="GET", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public CommonResult<String> updateCategory(@ApiParam(name="ids", value="ids", required=true) @RequestParam(required=true) String[] ids, @ApiParam(name="categoryId", value="categoryId", required=true) @RequestParam(required=true) String categoryId, @ApiParam(value="categoryName", name="categoryName", required=true) @RequestParam(required=true) String categoryName) throws IOException {
        for (int i = 0; i < ids.length; ++i) {
            BoDef boDef = (BoDef)((BoDefManager)this.baseService).get((Serializable)((Object)ids[i]));
            boDef.setCategoryId(categoryId);
            boDef.setCategoryName(categoryName);
            ((BoDefManager)this.baseService).updateCategory(boDef);
        }
        return new CommonResult(true, "\u8bbe\u7f6e\u5206\u7c7b\u6210\u529f");
    }

    @RequestMapping(value={"removeAttr"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539boAttribute\u5206\u7c7b", httpMethod="POST", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public CommonResult<String> removeAttr(@ApiParam(name="alias", value="alias", required=true) @RequestParam(required=true) String alias, @ApiParam(name="json", value="json", required=true) @RequestBody(required=true) String json) throws Exception {
        this.boAttributeManager.updateAttrStatus(json, alias);
        return new CommonResult(true, "\u5b57\u6bb5\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"createTableForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u521b\u5efa\u8868\u5355", httpMethod="POST", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public CommonResult<String> createTableForm(@ApiParam(name="json", value="json", required=true) @RequestBody(required=true) String json, @ApiParam(name="ignoreRight", value="\u662f\u5426\u5ffd\u7565\u6743\u9650\u6821\u9a8c\uff0c\u8868\u5355\u53cd\u5411\u751f\u6210\u5efa\u6a21\u7684\u65f6\u5019\u5ffd\u7565\uff0c\u5176\u4ed6\u6682\u4e0d\u5ffd\u7565", required=true) Optional<Boolean> ignoreRight, @ApiParam(name="action", value="\u4fdd\u5b58\u7c7b\u578b", required=true) @RequestParam(required=false) Optional<String> action) throws Exception {
        BoDef boDef = (BoDef)JsonUtil.toBean((String)json, BoDef.class);
        if (StringUtil.isNotEmpty((String)boDef.getId()) && !ignoreRight.orElse(false).booleanValue()) {
            CustomUtil.checkEditRight(BoDef.class, ResourceModelType.BO, boDef.getAlias());
        }
        CommonResult<String> res = this.boDefService.createTableForm(json, action.orElse("\u65b0\u589e"));
        return res;
    }

    @RequestMapping(value={"phyDeleteAttr"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f7b\u5e95\u5220\u9664\u5217", httpMethod="POST", notes="\u5f7b\u5e95\u5220\u9664\u5217")
    public CommonResult<String> phyDeleteAttr(@ApiParam(name="attrId", value="\u5217ID", required=true) @RequestBody String attrId, @ApiParam(name="defAlias", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String defAlias) throws Exception {
        ((BoDefManager)this.baseService).phyRemoveAttrById(attrId, defAlias);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f, \u5982\u8be5\u5b57\u6bb5\u5df2\u7ed1\u5b9a\u8868\u5355\u63a7\u4ef6\uff0c\u8bf7\u624b\u52a8\u4fee\u6539\u5bf9\u5e94\u63a7\u4ef6");
    }

    @RequestMapping(value={"getBindData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ed1\u5b9a\u6570\u636e", httpMethod="GET", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public String getBindData(@ApiParam(name="id", value="id", required=true) @RequestParam(required=true) String id, @ApiParam(name="alias", value="alias", required=true) @RequestParam(required=true) String alias) throws IOException {
        Map result = ((BoDefManager)this.baseService).getBindData(id, alias);
        String json = JsonUtil.toJson((Object)result);
        return json;
    }

    @RequestMapping(value={"deleteAttr"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664attr\u6570\u636e", httpMethod="POST", notes="\u5220\u9664attr\u6570\u636e")
    public CommonResult<String> deleteAttr(@ApiParam(name="id", value="id", required=true) @RequestParam(required=true) String id, @ApiParam(name="alias", value="alias") @RequestParam(required=false) String alias) throws IOException {
        this.boAttributeManager.deleteAttr(id, alias);
        return new CommonResult(true, "\u5b57\u6bb5\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"recovery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd8\u539f\u5220\u9664\u6570\u636e", httpMethod="POST", notes="\u8fd8\u539f\u5220\u9664\u6570\u636e")
    public CommonResult<String> recovery(@ApiParam(name="alias", value="alias", required=true) @RequestParam(required=true) String alias, @ApiParam(name="json", value="json", required=true) @RequestBody String json) throws Exception {
        this.boAttributeManager.recovery(json, alias);
        return new CommonResult(true, "\u5b57\u6bb5\u8fd8\u539f\u6210\u529f");
    }

    @RequestMapping(value={"getHideAttr"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9690\u85cf\u5b57\u6bb5", httpMethod="GET", notes="\u83b7\u53d6\u9690\u85cf\u5b57\u6bb5")
    public List getHideAttr(@ApiParam(name="tableName", value="\u8868\u540d") @RequestParam String tableName) throws Exception {
        return ((BoDefManager)this.baseService).getHideAttr(tableName);
    }

    @RequestMapping(value={"getSubEntInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6BO\u5efa\u6a21\u4e2d\u662f\u5426\u5b58\u5728\u5b50\u8868\u3001\u5b59\u8868", httpMethod="GET", notes="\u83b7\u53d6BO\u5efa\u6a21\u4e2d\u662f\u5426\u5b58\u5728\u5b50\u8868\u3001\u5b59\u8868")
    public ObjectNode getSubEntInfo(@ApiParam(name="ids", value="bo\u5b9a\u4e49id\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u5272", required=true) @RequestParam String ids, @ApiParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=false) @RequestParam Optional<Boolean> isMobile) throws Exception {
        ObjectNode res = this.boDefService.getSubEntInfo(ids, isMobile);
        return res;
    }

    @GetMapping(value={"reloadByEntId"})
    @ResponseBody
    public ObjectNode reloadByEntId(@RequestParam(value="entId", required=true) String entId, @RequestParam(value="alias", required=true) String alias) throws Exception {
        return this.boEntManager.reloadByEntId(entId, alias);
    }

    @RequestMapping(value={"reload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5237\u65b0\u5143\u6570\u636e", httpMethod="POST", notes="\u5237\u65b0\u5143\u6570\u636e")
    public CommonResult<Object> reload(@ApiParam(name="id", value="id", required=true) @RequestParam(required=true) String id, @ApiParam(name="json", value="bo\u5b9a\u4e49\u7684json\u6570\u636e", required=true) @RequestBody String json) throws IOException {
        try {
            return new CommonResult(true, "\u5237\u65b0\u5143\u6570\u636e\u6210\u529f", (Object)this.boEntManager.reloadByEntId(id, json));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5237\u65b0\u5143\u6570\u636e\u5931\u8d25");
        }
    }

    @RequestMapping(value={"reset"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cd\u7f6e\u5143\u6570\u636e", httpMethod="POST", notes="\u5237\u65b0\u5143\u6570\u636e")
    public CommonResult<Object> reset(@ApiParam(name="id", value="id", required=true) @RequestParam(required=true) String id, @ApiParam(name="json", value="bo\u5b9a\u4e49\u7684json\u6570\u636e", required=true) @RequestBody String json) throws Exception {
        try {
            return new CommonResult(true, "\u91cd\u7f6e\u5143\u6570\u636e\u6210\u529f", (Object)this.boEntManager.resetByEntId(id, json));
        }
        catch (BaseException e) {
            return new CommonResult(false, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u91cd\u7f6e\u5143\u6570\u636e\u5931\u8d25");
        }
    }

    @RequestMapping(value={"deleteExternalEnt"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5916\u90e8\u8868\u7684\u5b50\u5b9e\u4f53\u4ee5\u53ca\u5b59\u5b9e\u4f53", httpMethod="POST", notes="\u5220\u9664\u5916\u90e8\u8868\u7684\u5b50\u5b9e\u4f53\u4ee5\u53ca\u5b59\u5b9e\u4f53")
    public CommonResult<String> deleteExternalEnt(@ApiParam(name="\u8981\u88ab\u5220\u9664ent\u6570\u636e", value="ent", required=true) @RequestBody Map<String, String> ent) throws Exception {
        try {
            String entjson = ent.get("entjson");
            ((BoDefManager)this.baseService).deleteExternalEnt(entjson);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f!");
    }

    @RequestMapping(value={"getEntListByDefId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ebo\u5b9a\u4e49ID\u83b7\u53d6ent\u5217\u8868", httpMethod="GET", notes="\u6839\u636ebo\u5b9a\u4e49ID\u83b7\u53d6ent\u5217\u8868")
    public List<BoEnt> getEntListByDefId(@ApiParam(value="BO\u5b9a\u4e49ID", name="boDefId") @RequestParam String boDefId) throws Exception {
        return this.boEntManager.getByDefId(boDefId);
    }

    @RequestMapping(value={"getBoAttrByEntId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eBo\u5b9e\u4f53\u83b7\u53d6\u5c5e\u6027\u5217\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eBo\u5b9e\u4f53\u83b7\u53d6\u5c5e\u6027\u5217\u4fe1\u606f")
    public List<BoAttribute> getBoAttrByEntId(@ApiParam(value="bo\u5b9e\u4f53ID", name="boEntId") @RequestParam String boEntId) throws Exception {
        return this.boAttributeManager.getByEntId(boEntId);
    }

    @RequestMapping(value={"getBoAttrByEntName"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eBo\u5b9e\u4f53\u83b7\u53d6\u5c5e\u6027\u5217\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eBo\u5b9e\u4f53\u83b7\u53d6\u5c5e\u6027\u5217\u4fe1\u606f")
    public List<BoAttribute> getBoAttrByEntName(@ApiParam(value="entName", name="entName") @RequestParam String entName) {
        return this.boAttributeManager.getByEntName(entName);
    }

    @RequestMapping(value={"saveBoCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58bo\u590d\u5236", httpMethod="POST", notes="\u4fdd\u5b58bo\u590d\u5236")
    public CommonResult<String> saveBoCopy(@ApiParam(name="boCopyVo", value="boCopyVo", required=true) @RequestBody(required=true) BoCopyVo boCopyVo) throws Exception {
        ((BoDefManager)this.baseService).saveBoCopy(boCopyVo);
        return new CommonResult("\u590d\u5236\u6210\u529f");
    }

    @RequestMapping(value={"getBOTreeByFlowKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6BO\u6811\u5f62\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6BO\u6811\u5f62\u6570\u636e")
    public ObjectNode getBOTreeByFlowKey(@ApiParam(name="flowKey", value="flowKey", required=true) @RequestParam String flowKey) throws Exception {
        CommonResult formResult = this.bpmRuntimeFeignService.getStartFormKeyByFlowKey(flowKey);
        if (!formResult.getState().booleanValue()) {
            throw new BaseException(formResult.getMessage());
        }
        String formKey = (String)formResult.getValue();
        List boDefs = ((BoDefManager)this.baseService).getByFormKey(formKey);
        String ids = "";
        if (BeanUtils.isNotEmpty((Object)boDefs)) {
            for (BoDef boDef : boDefs) {
                if (StringUtil.isNotEmpty((String)ids)) {
                    ids = ids + ",";
                }
                ids = ids + boDef.getId();
            }
        }
        return ((BoDefManager)this.baseService).getBoTreeData(ids);
    }

    @RequestMapping(value={"saveBo/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> saveBo(@ApiParam(name="boAlias", value="\u5efa\u6a21\u522b\u540d", required=true) @PathVariable(value="boAlias") String boAlias, @ApiParam(name="boData", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody String boData) throws Exception {
        return ((BoDefManager)this.baseService).saveBo(boData, boAlias);
    }

    @RequestMapping(value={"deleteBo/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u4e1a\u52a1\u4fe1\u606f\u3002", httpMethod="POST", notes="\u6839\u636eid\u5220\u9664\u4e1a\u52a1\u4fe1\u606f")
    public CommonResult<String> deleteBo(@ApiParam(name="ids", value="\u4e3b\u952eid", required=true) @RequestParam String ids, @ApiParam(name="boAlias", value="\u5efa\u6a21\u522b\u540d", required=true) @PathVariable(value="boAlias") String boAlias) throws Exception {
        return ((BoDefManager)this.baseService).deleteBo(ids, boAlias);
    }

    @RequestMapping(value={"editBo/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u7f16\u8f91\u4e1a\u52a1\u4fe1\u606f\u3002", httpMethod="POST", notes="\u6839\u636eid\u7f16\u8f91\u4e1a\u52a1\u4fe1\u606f")
    public CommonResult<String> editBo(@ApiParam(name="boData", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody String boData, @ApiParam(name="boAlias", value="\u5efa\u6a21\u522b\u540d", required=true) @PathVariable(value="boAlias") String boAlias) throws Exception {
        return ((BoDefManager)this.baseService).saveBo(boData, boAlias);
    }

    @RequestMapping(value={"list/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9e\u4f53\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6bo\u5b9e\u4f53\u5217\u8868")
    public PageList<Map<String, Object>> listJsonByAlias(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BoDef> queryFilter, @ApiParam(name="boAlias", value="\u5efa\u6a21\u522b\u540d", required=true) @PathVariable(value="boAlias") String boAlias, @ApiParam(name="boEntName", value="\u5b9e\u4f53\u540d\u79f0", required=true) @RequestParam String boEntName) throws Exception {
        return ((BoDefManager)this.baseService).listJsonByAlias(boAlias, boEntName, queryFilter);
    }

    @RequestMapping(value={"queryTableExist"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7269\u7406\u8868\u662f\u5426\u5b58\u5728", httpMethod="POST", notes="\u67e5\u8be2\u7269\u7406\u8868\u662f\u5426\u5b58\u5728")
    public CommonResult<Object> queryTableExist(@ApiParam(name="querys", value="\u8981\u67e5\u8be2\u7684\u7269\u7406\u8868", required=true) @RequestBody String querys) throws Exception {
        return ((BoDefManager)this.baseService).queryTableExist(querys);
    }

    @RequestMapping(value={"createTableByEntId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5b9e\u4f53ID\u521b\u5efa\u7269\u7406\u8868", httpMethod="POST", notes="\u901a\u8fc7\u5b9e\u4f53ID\u521b\u5efa\u7269\u7406\u8868")
    public CommonResult<Boolean> createTableByEntId(@ApiParam(name="entId", value="\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53ID", required=true) @RequestBody String entId) throws Exception {
        return ((BoDefManager)this.baseService).createTableByEntId(entId);
    }

    @GetMapping(value={"/ent/isExist"})
    @ApiOperation(value="\u5efa\u6a21\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u5efa\u6a21\u662f\u5426\u5df2\u5b58\u5728")
    public List<String> isExistBoDef(String ... alias) {
        return ((BoDefManager)this.baseService).checkExistBoEnt(Arrays.asList(alias));
    }

    @RequestMapping(value={"subDataTemp/save/{key}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5b50\u8868\u6570\u636e\u4e34\u65f6\u7f13\u5b58\uff0c\u7528\u4e8e\u8868\u5355\u5217\u8868\u65b0\u589e\u6d41\u7a0b\u6216\u8005\u65b0\u589e\u6570\u636e", httpMethod="POST", notes="\u5b50\u8868\u6570\u636e\u4e34\u65f6\u7f13\u5b58\uff0c\u7528\u4e8e\u8868\u5355\u5217\u8868\u65b0\u589e\u6d41\u7a0b\u6216\u8005\u65b0\u589e\u6570\u636e")
    public CommonResult<String> saveSubDataTemp(@ApiParam(name="subData", value="\u5b50\u8868\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody String subData, @ApiParam(name="key", value="\u7f13\u5b58\u4e3b\u952e", required=true) @PathVariable(value="key") String key) {
        ((BoDefManager)this.baseService).saveSubDataTemp(key, subData);
        return new CommonResult("\u4e34\u65f6\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"subDataTemp/{key}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5b50\u8868\u6570\u636e\u4e34\u65f6\u7f13\u5b58\uff0c\u7528\u4e8e\u8868\u5355\u5217\u8868\u65b0\u589e\u6d41\u7a0b\u6216\u8005\u65b0\u589e\u6570\u636e", httpMethod="POST", notes="\u5b50\u8868\u6570\u636e\u4e34\u65f6\u7f13\u5b58\uff0c\u7528\u4e8e\u8868\u5355\u5217\u8868\u65b0\u589e\u6d41\u7a0b\u6216\u8005\u65b0\u589e\u6570\u636e")
    public CommonResult<String> getSubDataTemp(@ApiParam(name="key", value="\u7f13\u5b58\u4e3b\u952e", required=true) @PathVariable(value="key") String key) {
        return new CommonResult().value((Object)((BoDefManager)this.baseService).getSubDataTemp(key));
    }
}

