/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.enums.SmartChartCountType;
import com.hotent.form.model.CustomChart;
import com.hotent.form.model.CustomChartList;
import com.hotent.form.persistence.manager.CustomChartManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import poi.util.ExcelUtil;

@RestController
@RequestMapping(value={"/form/customChart/v1"})
@Api(tags={"\u81ea\u5b9a\u4e49\u56fe\u8868"})
@ApiGroup(group={"group_form"})
public class CustomChartController
extends BaseController<CustomChartManager, CustomChart> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    DatabaseContext databaseContext;
    @Autowired
    CustomChartManager customChartManager;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u5217\u8868")
    public PageList<CustomChart> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<CustomChart> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        if (BeanUtils.isEmpty((Object)sorter)) {
            sorter.add(new FieldSort("CREATE_TIME_", Direction.DESC));
        }
        queryFilter.setSorter(sorter);
        return super.query(queryFilter);
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e\u8be6\u60c5")
    public CustomChart get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        CustomChart byId = (CustomChart)super.getById(id);
        if (BeanUtils.isEmpty((Object)((Object)byId))) {
            byId = ((CustomChartManager)this.baseService).getChartByAlias(id);
        }
        return byId;
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="customChart", value="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody CustomChart customChart) throws Exception {
        return this.customChartManager.saveCustomChart(customChart);
    }

    @DeleteMapping(value={"remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return super.deleteById(id);
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((CustomChartManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getListData"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868\u6570\u636e")
    public Object getListData(@ApiParam(name="alias", value="\u56fe\u8868\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<?> filter, @ApiParam(name="countField", value="\u7edf\u8ba1\u5217", required=false) @RequestParam(required=false) String countField, @ApiParam(name="countType", value="\u7edf\u8ba1\u7c7b\u578b", required=false) @RequestParam(required=false) String countType, @ApiParam(name="calcField", value="\u8ba1\u7b97\u5217", required=false) @RequestParam(required=false) String calcField) throws Exception {
        if ((SmartChartCountType.SUM.value().equals(countType) || SmartChartCountType.AVG.value().equals(countType)) && StringUtil.isEmpty((String)calcField)) {
            throw new BaseException("\u8ba1\u7b97\u5217\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        CustomChart customDialog = (CustomChart)((CustomChartManager)this.baseService).get((Serializable)((Object)alias));
        Object result = this.databaseContext.switchDS(customDialog.getDsalias(), dsResult -> {
            try {
                return ((CustomChartManager)this.baseService).getListData(customDialog, filter, dsResult.getDbType(), countField, countType, calcField);
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868\u6570\u636e\u5f02\u5e38", (Throwable)e);
                throw new BaseException(e.getMessage());
            }
        });
        return result;
    }

    @PostMapping(value={"/exportSmartData"})
    @ApiOperation(value="\u5bfc\u51fa\u667a\u80fd\u7edf\u8ba1\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u667a\u80fd\u7edf\u8ba1\u6570\u636e")
    public void exportSmartData(@ApiParam(name="alias", value="\u56fe\u8868\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<?> filter, HttpServletResponse response) throws Exception {
        CustomChart customDialog = (CustomChart)((CustomChartManager)this.baseService).get((Serializable)((Object)alias));
        filter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(3000)));
        PageList page = (PageList)this.databaseContext.switchDS(customDialog.getDsalias(), dsResult -> {
            try {
                HashMap<String, Object> vars = new HashMap<String, Object>();
                filter.getQuerys().forEach(queryField -> vars.put(queryField.getProperty(), queryField.getValue()));
                return ((CustomChartManager)this.baseService).getSmartListData(customDialog, filter, dsResult.getDbType(), vars);
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51fa\u667a\u80fd\u7edf\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)e);
                throw new BaseException(e.getMessage());
            }
        });
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        List listFields = JSONUtil.toList((String)customDialog.getListField(), Map.class);
        for (Map listField : listFields) {
            exportMap.put(listField.get("field").toString().toUpperCase(), listField.get("comment").toString());
        }
        List list = page.getRows();
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u5bfc\u51fa\u6570\u636e", (int)22, exportMap, (List)list);
        ExcelUtil.downloadExcel((Workbook)exportFile, (String)"\u5bfc\u51fa\u6570\u636e", (HttpServletResponse)response);
    }

    @PostMapping(value={"getTable"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u7f6e\u5217\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u8bbe\u7f6e\u5217\u6570\u636e")
    public ObjectNode getTable(@ApiParam(name="param", value="\u8bbe\u7f6e\u5217\u53c2\u6570", required=true) @RequestBody ObjectNode object) throws Exception {
        ObjectNode res = this.customChartManager.getTable(object);
        return res;
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u56fe\u8868xml", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e\u56fe\u8868xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u6570\u636e\u56fe\u8868id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_customChart_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = ((CustomChartManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"exportData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u56fe\u8868xml", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e\u56fe\u8868xml")
    public Map<String, String> exportData(String ... ids) throws Exception {
        return ((CustomChartManager)this.baseService).exportData(Arrays.asList(ids));
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165", httpMethod="POST", notes="\u5bfc\u5165")
    public CommonResult<Map<String, String>> importData(@ApiParam(name="ids", value="\u6570\u636e\u56fe\u8868id", required=true) @RequestBody String xml, @RequestParam(value="isCover") boolean isCover) throws Exception {
        CustomChartList list = (CustomChartList)JAXBUtil.unmarshall((String)xml, CustomChartList.class);
        return ((CustomChartManager)this.baseService).importData(list, isCover);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u56fe\u8868\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u56fe\u8868\u5bfc\u5165")
    public CommonResult<String> importData(Optional<String> cacheFileId) throws Exception {
        return this.customChartManager.importData(cacheFileId);
    }

    @RequestMapping(value={"importCheck1"}, method={RequestMethod.POST})
    List<ImportCheckResult> importCheckChart(@RequestBody String xml) throws JAXBException, UnsupportedEncodingException {
        CustomChartList list = (CustomChartList)JAXBUtil.unmarshall((String)xml, CustomChartList.class);
        return ((CustomChartManager)this.baseService).importCheck(list);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u6570\u636e\u56fe\u8868\u5bfc\u5165\u662f\u5426\u91cd\u590d", httpMethod="POST", notes="\u68c0\u67e5\u6570\u636e\u56fe\u8868\u5bfc\u5165\u662f\u5426\u91cd\u590d")
    public CommonResult<String> importDataCheck(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.customChartManager.importDataCheck(request, response);
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868", httpMethod="GET", notes="\u901a\u8fc7id\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868")
    public CustomChart getCustomChartById(@ApiParam(name="id", value="\u81ea\u5b9a\u4e49\u89c6\u56feid", required=true) @RequestParam String id) throws Exception {
        return (CustomChart)((CustomChartManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7alias\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868", httpMethod="GET", notes="\u901a\u8fc7alias\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868")
    public CustomChart getCustomChartByAlias(@ApiParam(name="alias", value="\u81ea\u5b9a\u4e49\u56fe\u8868\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"alias_", (Object)alias);
        return (CustomChart)((Object)((CustomChartManager)this.baseService).getOne((Wrapper)queryWrapper, false));
    }
}

