/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.controller.BaseController;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.model.FormPrintTemplate;
import com.hotent.form.param.FormPrintParam;
import com.hotent.form.param.FormPrintTemplateFileVo;
import com.hotent.form.persistence.manager.FormPrintTemplateManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/printTemplate/v1/"})
@Api(tags={"\u5957\u6253\u6a21\u677f"})
@ApiGroup(group={"group_form"})
public class FormPrintTemplateController
extends BaseController<FormPrintTemplateManager, FormPrintTemplate> {
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;
    @Resource
    FormPrintTemplateManager formPrintTemplateManager;
    @Resource
    PortalFeignService portalFeignService;

    @RequestMapping(value={"getPrintList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6253\u5370\u6a21\u677f\u5217\u8868", httpMethod="POST", notes="\u6253\u5370\u6a21\u677f\u5217\u8868")
    @ResponseBody
    @ResourcePermissionCheck
    public PageList<FormPrintTemplate> getPrintList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FormPrintTemplate> queryFilter, @ApiParam(name="type", value="\u67e5\u8be2\u5217\u8868\u7c7b\u578b\uff08form:\u8868\u5355\u5957\u6253\uff0cword\uff1aword\u5957\u6253\uff0c\u5305\u542bexcel\uff09", required=false) @RequestParam(required=false) Optional<String> type) throws Exception {
        String printType = type.orElse("form");
        if (!"form".equals(printType)) {
            queryFilter.addFilter("DATASOURCE_FORM_", (Object)"bo", QueryOP.EQUAL, FieldRelation.OR, "type");
            queryFilter.addFilter("DATASOURCE_FORM_", (Object)"sql", QueryOP.EQUAL, FieldRelation.OR, "type");
        }
        return ((FormPrintTemplateManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> save(@ApiParam(name="model", value="\u6253\u5370\u6a21\u677f") @RequestBody FormPrintTemplate formPrintTemplate) {
        FormPrintTemplate template;
        if (StringUtil.isEmpty((String)formPrintTemplate.getId()) && BeanUtils.isNotEmpty((Object)((Object)(template = ((FormPrintTemplateManager)this.baseService).getByAlias(formPrintTemplate.getAlias()))))) {
            return new CommonResult(false, "\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff1a\u522b\u540d\u3010" + formPrintTemplate.getAlias() + "\u3011\u5df2\u5b58\u5728\u3002");
        }
        ((FormPrintTemplateManager)this.baseService).saveFormPrintTemplate(formPrintTemplate);
        return new CommonResult("\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u6210\u529f");
    }

    @RequestMapping(value={"/saveFormPrintTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> saveFormPrintTemplate(@ApiParam(name="model", value="\u6253\u5370\u6a21\u677f") @RequestBody FormPrintTemplate formPrintTemplate) {
        String msg = "\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u6210\u529f\u3002";
        if (StringUtil.isEmpty((String)formPrintTemplate.getId())) {
            FormPrintTemplate template = ((FormPrintTemplateManager)this.baseService).getByAlias(formPrintTemplate.getAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)template))) {
                return new CommonResult(false, "\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff1a\u522b\u540d\u3010" + formPrintTemplate.getAlias() + "\u3011\u5df2\u5b58\u5728\u3002");
            }
            ((FormPrintTemplateManager)this.baseService).save((Object)formPrintTemplate);
        } else {
            ((FormPrintTemplateManager)this.baseService).update((Model)formPrintTemplate);
            msg = "\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u6210\u529f\u3002";
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"/getLabelData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6SQL\u7684\u5b57\u6bb5\u540d")
    public CommonResult getLabelData(@ApiParam(name="jsonNode", value="\u53c2\u6570\u5185\u5bb9") @RequestBody JsonNode jsonNode) {
        CommonResult res = this.formPrintTemplateManager.getLabelData(jsonNode);
        return res;
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        this.formPrintTemplateManager.removeByIds(ids);
        return new CommonResult("\u5220\u9664\u6a21\u677f\u6210\u529f");
    }

    @RequestMapping(value={"setDefaultVersion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4e3a\u4e3b\u7248\u672c", httpMethod="GET", notes="\u8bbe\u7f6e\u4e3a\u4e3b\u7248\u672c")
    public CommonResult<String> setDefaultVersion(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="printType", value="\u6253\u5370\u7c7b\u578b", required=true) @RequestParam String printType) throws Exception {
        ((FormPrintTemplateManager)this.baseService).setDefaultVersion(formKey, id, printType);
        return new CommonResult("\u8bbe\u7f6e\u4e3b\u7248\u672c\u6210\u529f");
    }

    @RequestMapping(value={"print"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6253\u5370\u6a21\u677f", httpMethod="GET", notes="\u6253\u5370\u6a21\u677f")
    public CommonResult<String> print(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9ID", required=true) @RequestParam Optional<String> nodeId, @ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String procInstId) throws Exception {
        ObjectNode objectNode = this.bpmRuntimeFeignService.printBoAndFormKey(defId, nodeId.orElse(""), procInstId);
        String formKey = objectNode.get("formKey").asText();
        String formName = objectNode.get("formName").asText();
        FormPrintTemplate formPrintTemplate = ((FormPrintTemplateManager)this.baseService).getMainFormPrintTemplate(formKey);
        if (BeanUtils.isEmpty((Object)((Object)formPrintTemplate))) {
            return new CommonResult(true, formName + "\u8868\u5355\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (Object)"");
        }
        String fileId = formPrintTemplate.getFileId();
        objectNode.put("fileId", fileId);
        String id = this.portalFeignService.wordPrint(objectNode);
        return new CommonResult(true, "", (Object)id);
    }

    @RequestMapping(value={"wordPrint"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6253\u5370word\u6a21\u677f", httpMethod="POST", notes="\u6253\u5370word\u6a21\u677f")
    public CommonResult<String> wordPrint(@ApiParam(name="formPrintParam", value="\u6253\u5370\u53c2\u6570") @RequestBody FormPrintParam formPrintParam) throws Exception {
        CommonResult<String> res = this.formPrintTemplateManager.wordPrint(formPrintParam);
        return res;
    }

    @RequestMapping(value={"formWordPrint"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u6309\u94ae\u6253\u5370word\u6a21\u677f", httpMethod="POST", notes="\u8868\u5355\u6309\u94ae\u6253\u5370word\u6a21\u677f")
    public CommonResult<String> formWordPrint(@ApiParam(name="formPrintParam", value="\u6253\u5370\u53c2\u6570") @RequestBody FormPrintParam formPrintParam) throws Exception {
        CommonResult<String> res = this.formPrintTemplateManager.formWordPrint(formPrintParam);
        return res;
    }

    @RequestMapping(value={"getFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355Key", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355Key")
    public ObjectNode getFormKey(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9ID", required=true) @RequestParam Optional<String> nodeId, @ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String procInstId) throws Exception {
        return this.bpmRuntimeFeignService.printBoAndFormKey(defId, nodeId.orElse(""), procInstId);
    }

    @RequestMapping(value={"getMainTemlate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u5217\u8868")
    public FormPrintTemplate getMainTemlate(@ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="printType", value="\u6253\u5370\u7c7b\u578b", required=true) @RequestParam String printType) throws Exception {
        return ((FormPrintTemplateManager)this.baseService).getMailPrintTemplates(formKey, printType);
    }

    @RequestMapping(value={"getWordTemplatesByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u5217\u8868\uff08key\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694\uff09")
    public List<FormPrintTemplate> getWordTemplatesByFormKey(@ApiParam(name="formKeys", value="\u8868\u5355key\u5217\u8868", required=true) @RequestParam String formKeys) throws Exception {
        return ((FormPrintTemplateManager)this.baseService).getWordTemplatesByFormKey(formKeys);
    }

    @RequestMapping(value={"getPrintListByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868")
    @ResponseBody
    public List<FormPrintTemplate> getPrintListByFormKey(@ApiParam(name="formKey", required=true) @RequestParam String formKey) throws Exception {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormPrintTemplate::getFormKey, (Object)formKey);
        return ((FormPrintTemplateManager)this.baseService).list((Wrapper)wrapper);
    }

    @RequestMapping(value={"getPrintListByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u522b\u540d\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868\uff08\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694\uff09", httpMethod="GET", notes="\u6839\u636e\u6a21\u677f\u522b\u540d\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868")
    @ResponseBody
    public List<FormPrintTemplate> getPrintListByAlias(@ApiParam(name="alias", required=true) @RequestParam String alias) throws Exception {
        String[] arrays = alias.split(",");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(FormPrintTemplate::getAlias, Arrays.asList(arrays));
        return ((FormPrintTemplateManager)this.baseService).list((Wrapper)wrapper);
    }

    @RequestMapping(value={"getPrintListByBoDefIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868")
    @ResponseBody
    public List<FormPrintTemplateFileVo> getPrintListByBoDefIds(@ApiParam(name="boDefIds", value="bo\u5b9a\u4e49id\uff0c\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String boDefIds) throws Exception {
        List<FormPrintTemplateFileVo> res = this.formPrintTemplateManager.getPrintListByBoDefIds(boDefIds);
        return res;
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5957\u6253\u6a21\u677fxml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml")
    public void exportXml(HttpServletResponse response, @ApiParam(name="ids", value="\u5957\u6253\u6a21\u677fid", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_formPrintTemplate_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, Object> strXml = ((FormPrintTemplateManager)this.baseService).exportDef(list);
            HttpUtil.downLoadFile((HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5957\u6253\u6a21\u677f\u5bfc\u5165\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165", required=false) @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u5957\u6253\u6a21\u677f\u6587\u4ef6id", required=false) @RequestParam Optional<String> cacheFileId) throws Exception {
        return this.formPrintTemplateManager.importSave(confirmImport, typeId, cacheFileId);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c,\u901a\u8fc7\u6821\u9a8c\u5219\u76f4\u63a5\u5bfc\u5165\uff0c\u5982\u6709\u91cd\u590d\u6d41\u7a0b\uff0c\u5219\u8fd4\u56de\u6d41\u7a0bxml\u7684\u7f13\u5b58key\uff0c\u5f85\u7528\u6237\u786e\u8ba4\u8986\u76d6\u540e\u518d\u6b21\u5bfc\u5165", httpMethod="POST", notes="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c")
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId) throws Exception {
        Object res = this.formPrintTemplateManager.importCheck(request, response, typeId);
        return res;
    }

    @RequestMapping(value={"getListByBoAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ebo\u522b\u540d\u83b7\u53d6\u6a21\u677f\u6570\u636e", httpMethod="GET", notes="\u6839\u636ebo\u522b\u540d\u83b7\u53d6\u6a21\u677f\u6570\u636e")
    public CommonResult<List<FormPrintTemplate>> getListByBoAlias(@ApiParam(name="boAlias", value="\u5efa\u6a21\u522b\u540d", required=true) @RequestParam String boAlias) {
        return this.formPrintTemplateManager.getListByBoAlias(boAlias);
    }

    @RequestMapping(value={"formWordPrintBatch/{formKey}/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355Key, boAlias \u83b7\u53d6 bo\u6570\u636e\u7ed3\u6784\u540e\uff0c\u518d\u8fdb\u884c\u5957\u6253\u64cd\u4f5c", httpMethod="POST", notes="\u83b7\u53d6bo\u6570\u636e\u7ed3\u6784")
    public CommonResult<List<String>> formWordPrintBatch(@PathVariable(value="formKey") String formKey, @PathVariable(value="boAlias") String boAlias, @ApiParam(name="id", value="id", required=true) @RequestBody List<String> ids, @ApiParam(name="printTemplateAlias", value="\u5957\u6253\u6a21\u677f\u522b\u540d", required=true) @RequestParam String printTemplateAlias, @ApiParam(name="action", value="\u64cd\u4f5c\u7c7b\u578b") @RequestParam Optional<String> action, @ApiParam(name="printType", value="\u6253\u5370\u7c7b\u578b\uff1aword/pdf") @RequestParam Optional<String> printType, @ApiParam(name="printType", value="\u6253\u5370\u7c7b\u578b\uff1aword/pdf") @RequestParam Optional<String> zipName) throws Exception {
        List<String> fileIds = ((FormPrintTemplateManager)this.baseService).formWordPrintBatch(formKey, boAlias, printTemplateAlias, action.orElse("get"), printType.orElse("word"), zipName.orElse(""), ids);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", fileIds);
    }
}

