/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.generator.util;

import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoEnt;
import com.hotent.form.generator.GeneratorModel;
import com.hotent.form.generator.ModelInfo;
import com.hotent.form.generator.enums.GeneratorEnum;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CodeGeneratorUtil {
    private static List<String> unCreateFile = Arrays.asList("Manager.vue", "ManagerEdit.vue", "Controller.java", ".js");

    public static boolean createFile(ConfigBuilder configBuilder, String filePath) {
        File file;
        boolean exist;
        InjectionConfig injCfg = configBuilder.getInjectionConfig();
        Map map = injCfg.getMap();
        Object boEntListObj = map.get("boEntList");
        boolean isCreateFile = true;
        if (BeanUtils.isNotEmpty(boEntListObj)) {
            List boEntList = (List)boEntListObj;
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            block0: for (BoEnt boEnt : boEntList) {
                List childEntList = boEnt.getChildEntList();
                if (!isCreateFile) break;
                block1: for (BoEnt subEnt : childEntList) {
                    if (!isCreateFile) continue block0;
                    String entityName = NamingStrategy.capitalFirst((String)NamingStrategy.underlineToCamel((String)subEnt.getTableName()));
                    for (String suffix : unCreateFile) {
                        if (!(entityName + suffix).equalsIgnoreCase(fileName)) continue;
                        isCreateFile = false;
                        break;
                    }
                    if (!BeanUtils.isNotEmpty((Object)subEnt.getChildEntList())) continue;
                    block3: for (BoEnt sunEnt : subEnt.getChildEntList()) {
                        if (!isCreateFile) continue block1;
                        String sunEntityName = NamingStrategy.capitalFirst((String)NamingStrategy.underlineToCamel((String)sunEnt.getTableName()));
                        for (String suffix : unCreateFile) {
                            if (!(sunEntityName + suffix).equalsIgnoreCase(fileName)) continue;
                            isCreateFile = false;
                            continue block3;
                        }
                    }
                }
            }
        }
        if (isCreateFile && !(exist = (file = new File(filePath)).exists())) {
            file.getParentFile().mkdirs();
        }
        return isCreateFile;
    }

    public static Map<String, String> convertLowerKey(Map<String, String> fieldsMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : fieldsMap.keySet()) {
            String string = fieldsMap.get(key);
            String capitalize = StringUtil.underlineToHump((String)string);
            result.put(key.toLowerCase(), capitalize);
        }
        return result;
    }

    public static String getPropertyName(List<BoEnt> boEntList, String tableName, String fieldName, String propertyName) {
        if (BeanUtils.isEmpty(boEntList)) {
            return propertyName;
        }
        HashMap<String, Map<String, String>> tableFiledMap = new HashMap<String, Map<String, String>>();
        for (BoEnt boEnt : boEntList) {
            Map<String, String> fieldsMap = boEnt.getBoAttrList().stream().collect(Collectors.toMap(BoAttribute::getFieldName, BoAttribute::getName));
            tableFiledMap.put(boEnt.getTableName().toLowerCase(), CodeGeneratorUtil.convertLowerKey(fieldsMap));
            List subEntList = boEnt.getChildEntList();
            if (BeanUtils.isEmpty((Object)subEntList)) continue;
            subEntList.forEach(sub -> {
                Map<String, String> subFieldsMap = sub.getBoAttrList().stream().collect(Collectors.toMap(BoAttribute::getFieldName, BoAttribute::getName));
                tableFiledMap.put(sub.getTableName().toLowerCase(), CodeGeneratorUtil.convertLowerKey(subFieldsMap));
                List sunEntList = sub.getChildEntList();
                if (BeanUtils.isNotEmpty((Object)sunEntList)) {
                    sunEntList.forEach(sun -> {
                        Map<String, String> sunFieldsMap = sun.getBoAttrList().stream().collect(Collectors.toMap(BoAttribute::getFieldName, BoAttribute::getName));
                        tableFiledMap.put(sun.getTableName().toLowerCase(), CodeGeneratorUtil.convertLowerKey(sunFieldsMap));
                    });
                }
            });
        }
        if (tableFiledMap.containsKey(tableName.toLowerCase())) {
            String boFieldName = (String)((Map)tableFiledMap.get(tableName.toLowerCase())).get(fieldName.toLowerCase());
            return StringUtil.isNotEmpty((String)boFieldName) ? boFieldName : propertyName;
        }
        return propertyName;
    }

    public static String repalceStr(String st1, String st2, String st3) {
        return st1.replaceAll(st2, st3);
    }

    public static List<ModelInfo> getSubModelInfo(List<BoEnt> boEntList, String parentTableName) {
        List subEntList;
        ArrayList<ModelInfo> list = new ArrayList<ModelInfo>();
        if (BeanUtils.isEmpty(boEntList)) {
            return list;
        }
        HashMap<String, List> subBoEntMap = new HashMap<String, List>();
        for (BoEnt boEnt : boEntList) {
            List childEntList = boEnt.getChildEntList();
            subBoEntMap.put(boEnt.getTableName().toLowerCase(), childEntList);
            if (!BeanUtils.isNotEmpty((Object)childEntList)) continue;
            for (BoEnt sub : childEntList) {
                subBoEntMap.put(sub.getTableName().toLowerCase(), sub.getChildEntList());
            }
        }
        if (subBoEntMap.containsKey(parentTableName.toLowerCase()) && BeanUtils.isNotEmpty((Object)(subEntList = (List)subBoEntMap.get(parentTableName.toLowerCase())))) {
            subEntList.forEach(e -> list.add(new ModelInfo(NamingStrategy.capitalFirst((String)NamingStrategy.underlineToCamel((String)e.getTableName())), e.getDesc(), NamingStrategy.underlineToCamel((String)("sub_" + e.getName())), e.getTableName())));
        }
        return list;
    }

    public static String getBackendProjectPath(String baseProjectPath, GeneratorModel generatorModel) {
        if (GeneratorEnum.GenType.FAST.getValue().equals(generatorModel.getGenType())) {
            return baseProjectPath + "/" + generatorModel.getArtifactId();
        }
        return baseProjectPath;
    }

    public static String getFrontendProjectPath(String baseProjectPath, GeneratorModel generatorModel) {
        if (GeneratorEnum.GenType.FAST.getValue().equals(generatorModel.getGenType())) {
            return baseProjectPath + "/front-template";
        }
        return baseProjectPath + "/web";
    }
}

