/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.mobile.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.form.enums.LayoutType;
import com.hotent.form.mobile.service.Pc2MobileConvertFactory;
import com.hotent.form.mobile.service.Pc2MobileConverter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PageStepConverter
implements Pc2MobileConverter {
    @Resource
    Pc2MobileConvertFactory factory;
    public List<String> pageStepComponents = Arrays.asList("pageSteps", "page", "pageButton");

    @Override
    public LayoutType type() {
        return LayoutType.PAGE_STEP_LAYOUT;
    }

    @Override
    public ArrayNode convert(JsonNode tableNode) {
        ArrayNode tempArray = JsonUtil.createArrayNode();
        ArrayNode array = (ArrayNode)tableNode;
        for (JsonNode node : array) {
            if (!node.has("ctrlType")) {
                tempArray.add(node);
                continue;
            }
            String ctrlType = JsonUtil.getString((JsonNode)node, (String)"ctrlType");
            if (this.pageStepComponents.contains(ctrlType)) continue;
            tempArray.add(node);
        }
        return tempArray;
    }
}

