/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.mobile.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.form.enums.LayoutType;
import com.hotent.form.mobile.service.Pc2MobileConvertFactory;
import com.hotent.form.mobile.service.Pc2MobileConverter;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SubDivConverter
implements Pc2MobileConverter {
    @Resource
    Pc2MobileConvertFactory pc2MobileConvertFactory;

    @Override
    public LayoutType type() {
        return LayoutType.SUB_DIV_LAYOUT;
    }

    @Override
    public ArrayNode convert(JsonNode tableNode) {
        ArrayNode tempArray = JsonUtil.createArrayNode();
        ObjectNode objectNode = (ObjectNode)tableNode;
        objectNode.set("list", (JsonNode)this.handleLayoutMobile(objectNode));
        this.tempArrayAddItem(tempArray, tableNode);
        return tempArray;
    }

    private ArrayNode handleLayoutMobile(ObjectNode layoutNode) {
        ArrayNode subNodeArray = JsonUtil.getMapper().createArrayNode();
        if (!layoutNode.has("list")) {
            return subNodeArray;
        }
        ArrayNode list = (ArrayNode)layoutNode.findValue("list");
        for (JsonNode col : list) {
            if (!col.has("ctrlType")) {
                subNodeArray.add(col);
                continue;
            }
            if ("suntable".equals(col.get("ctrlType").asText())) {
                ObjectNode sun = (ObjectNode)col;
                sun.put("ctrlType", "sunDiv");
            }
            if ("grid".equals(col.get("ctrlType").asText())) {
                Pc2MobileConverter converter = this.pc2MobileConvertFactory.getBean(LayoutType.GRID_LAYOUT.getValue());
                ArrayNode nodes = converter.convert(col);
                subNodeArray.addAll(nodes);
                continue;
            }
            if ("sunDiv".equals(col.get("ctrlType").asText())) {
                ObjectNode objectNode = (ObjectNode)col;
                objectNode.set("list", (JsonNode)this.handleLayoutMobile(objectNode));
                this.tempArrayAddItem(subNodeArray, col);
                continue;
            }
            subNodeArray.add(col);
        }
        return subNodeArray;
    }
}

