/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExpressionUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.form.enums.SmartChartCountType;
import com.hotent.form.model.CustomChart;
import com.hotent.form.model.CustomChartList;
import com.hotent.form.model.CustomQuery;
import com.hotent.form.persistence.dao.CustomChartDao;
import com.hotent.form.persistence.manager.CustomChartManager;
import com.hotent.form.persistence.manager.CustomQueryManager;
import com.hotent.table.datasource.DataSourceUtil;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultColumn;
import com.hotent.table.model.impl.DefaultTable;
import com.hotent.table.util.MetaDataUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="customChartManager")
public class CustomChartManagerImpl
extends BaseManagerImpl<CustomChartDao, CustomChart>
implements CustomChartManager {
    private static Pattern pattern = Pattern.compile("(\\$\\{[^\\}]+})");
    @Resource
    CommonManager commonManager;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    CustomQueryManager customQueryManager;

    public CustomChart get(Serializable id) {
        CustomChart customChart = (CustomChart)super.get(id);
        if (BeanUtils.isEmpty((Object)((Object)customChart))) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("ALIAS_", (Object)id, QueryOP.EQUAL);
            PageList query = this.query(queryFilter);
            if (query.getRows().size() > 0) {
                customChart = (CustomChart)((Object)query.getRows().get(0));
            }
        }
        return customChart;
    }

    @Override
    public Object getListData(CustomChart customDialog, QueryFilter<?> filter, String dbType, String countField, String countType, String calcField) throws Exception {
        if (2 == customDialog.getType()) {
            String customQueryAlias = customDialog.getCustomQueryAlias();
            CustomQuery customQuery = this.customQueryManager.getByAlias(customQueryAlias);
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)customQuery)), (String)"\u5f53\u524d\u914d\u7f6e\u6709\u95ee\u9898,\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\uff01", (Object[])new Object[0]);
            Object o = null;
            ArrayNode arrayNode = JsonUtil.createArrayNode();
            if (BeanUtils.isNotEmpty(filter) && BeanUtils.isNotEmpty((Object)filter.getQuerys())) {
                List querys = filter.getQuerys();
                for (QueryField query : querys) {
                    ObjectNode node = JsonUtil.createObjectNode();
                    node.put("value", query.getValue().toString());
                    node.put("key", query.getProperty());
                    node.put("relation", "or");
                    node.put("condition", query.getOperation().value());
                    arrayNode.add((JsonNode)node);
                }
            }
            if ("selectedApi".equals(customQuery.getDsType())) {
                o = this.portalFeignService.executeIntefaceJob(customQuery.getApiAlias(), null, null, JsonUtil.toJson((Object)arrayNode));
            }
            if ("dataSource".equals(customQuery.getDsType())) {
                o = this.customQueryManager.doQuery(Optional.of(customQueryAlias), Optional.of(JsonUtil.toJson((Object)arrayNode)), Optional.of(1));
            }
            if ("restful".equals(customQuery.getDsType())) {
                o = this.customQueryManager.getCustomQueryRestful(customQuery, filter);
            }
            if (o == null) {
                return new PageList();
            }
            return o;
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        filter.getQuerys().forEach(queryField -> vars.put(queryField.getProperty(), queryField.getValue()));
        this.clearQueryFilter(customDialog, filter);
        if ("mysql".equals(dbType)) {
            filter.getSorter().forEach(fieldSort -> fieldSort.setProperty("`" + fieldSort.getProperty() + "`"));
        }
        if (customDialog.getChartCountType() == null || customDialog.getChartCountType() == 0) {
            String sql = customDialog.getIsTable() == 2 ? String.format("select * from ( %s ) t", ExpressionUtil.format((String)customDialog.getDiySql(), vars)) : "select * from " + customDialog.getObjName();
            PageList query = this.commonManager.query(sql, filter);
            return this.pageListAttributeToUpperCase(query);
        }
        String sql = customDialog.getIsTable() == 2 ? ExpressionUtil.format((String)customDialog.getDiySql(), vars) : "select * from " + customDialog.getObjName();
        sql = "(" + sql + ")";
        Class currentModelClass = this.currentModelClass();
        IPage<Map<String, Object>> result = SmartChartCountType.COUNT.value().equals(countType) ? ((CustomChartDao)this.baseMapper).getSmartCountData(this.convert2IPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1))), sql, countField, countType, (Wrapper<CustomChart>)this.convert2Wrapper(filter, currentModelClass)) : ((CustomChartDao)this.baseMapper).calcSmartCountData(this.convert2IPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1))), sql, countField, calcField, countType, (Wrapper<CustomChart>)this.convert2Wrapper(filter, currentModelClass));
        PageList listData = this.getSmartListData(customDialog, filter, dbType, vars);
        PageList countData = this.pageListAttributeToUpperCase(new PageList(result));
        HashMap<String, PageList> resultMap = new HashMap<String, PageList>();
        resultMap.put("listData", listData);
        resultMap.put("countData", countData);
        return resultMap;
    }

    private void clearQueryFilter(CustomChart customDialog, QueryFilter<?> filter) throws IOException {
        String conditionfield = customDialog.getConditionfield();
        ArrayNode conditionFields = (ArrayNode)JsonUtil.toJsonNode((String)conditionfield);
        for (JsonNode conditionField : conditionFields) {
            int userScope = JsonUtil.getInt((JsonNode)conditionField, (String)"useScope", (int)1);
            if (userScope != 2) continue;
            String field = JsonUtil.getString((JsonNode)conditionField, (String)"field");
            filter.getQuerys().removeIf(queryField -> queryField.getProperty().equals(field));
        }
    }

    @Override
    public PageList getSmartListData(CustomChart customDialog, QueryFilter<?> filter, String dbType, Map<String, Object> vars) throws Exception {
        if ("mysql".equals(dbType)) {
            filter.getSorter().forEach(fieldSort -> fieldSort.setProperty("`" + fieldSort.getProperty() + "`"));
        }
        if (1 == customDialog.getType() && customDialog.getChartCountType() == 1) {
            String sql = customDialog.getIsTable() == 2 ? ExpressionUtil.format((String)customDialog.getDiySql(), vars) : "select * from " + customDialog.getObjName();
            sql = "(" + sql + ")";
            Class currentModelClass = this.currentModelClass();
            IPage<Map<String, Object>> result = ((CustomChartDao)this.baseMapper).getSmartListData(this.convert2IPage(filter.getPageBean()), sql, (Wrapper<CustomChart>)this.convert2Wrapper(filter, currentModelClass));
            return this.pageListAttributeToUpperCase(new PageList(result));
        }
        return new PageList();
    }

    private PageList pageListAttributeToUpperCase(PageList pageList) {
        for (int i = 0; i < pageList.getRows().size(); ++i) {
            Map m = (Map)pageList.getRows().get(i);
            if (m == null) continue;
            HashMap tm = new HashMap();
            for (String k : m.keySet()) {
                tm.put(k.toUpperCase(), m.get(k));
            }
            pageList.getRows().set(i, tm);
        }
        return pageList;
    }

    @Override
    public CustomChart getChartByAlias(String alias) {
        return ((CustomChartDao)this.baseMapper).getChartByAlias(alias);
    }

    @Override
    public boolean listChartByAlias(String alias) {
        List<CustomChart> customCharts = ((CustomChartDao)this.baseMapper).listChartByAlias(alias);
        return customCharts.size() <= 1;
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        CustomChartList customChartList = new CustomChartList();
        for (String id : ids) {
            CustomChart customChart = this.get((Serializable)((Object)id));
            if (BeanUtils.isEmpty((Object)((Object)customChart))) {
                throw new BaseException("\u4e0d\u5b58\u5728id\u4e3a[" + id + "]\u7684\u56fe\u8868");
            }
            customChartList.addCustomChart(customChart);
        }
        try {
            String xml = JAXBUtil.marshall((Object)customChartList, CustomChartList.class);
            map.put("customCharts.form.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Transactional(rollbackFor={Exception.class})
    public void importData(String xml) throws Exception {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)xml), (String)"\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9", (Object[])new Object[0]);
        CustomChartList list = (CustomChartList)JAXBUtil.unmarshall((String)xml, CustomChartList.class);
        this.importData(list, true);
    }

    public void importDataCheck(String xml) throws Exception {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)xml), (String)"\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9", (Object[])new Object[0]);
        CustomChartList list = (CustomChartList)JAXBUtil.unmarshall((String)xml, CustomChartList.class);
        List<CustomChart> customChartList = list.getCustomChartList();
        Assert.isTrue((customChartList.size() != 0 ? 1 : 0) != 0, (String)"\u5bfc\u5165\u6570\u636e\u56fe\u8868\u5185\u5bb9\u65e0\u6548", (Object[])new Object[0]);
        for (CustomChart customChart : customChartList) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CustomChart::getAlias, (Object)customChart.getAlias());
            List existCustomChartList = ((CustomChartDao)this.baseMapper).selectList((Wrapper)wrapper);
            if (existCustomChartList == null || existCustomChartList.isEmpty()) continue;
            ThreadMsgUtil.addMapMsg2((String)"customChartsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", customChart.getName() + "", customChart.getAlias() + ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importDataCheck(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        File formDir;
        String xml;
        String unZipFilePath;
        block7: {
            File formDir2;
            CommonResult commonResult;
            unZipFilePath = null;
            MultipartFile file = request.getFile("file");
            if (file == null || file.isEmpty()) {
                return new CommonResult(false, "\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            }
            try {
                String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "/attachFiles/unZip").toString();
                FileUtil.createFolder((String)rootRealPath, (boolean)true);
                ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
                String name = file.getOriginalFilename();
                String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
                unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
                xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "customCharts.form.xml").toString());
                this.importDataCheck(xml);
                LinkedHashSet customChartsSkipped = ThreadMsgUtil.getMapMsg2((String)"customChartsSkipped");
                if (!BeanUtils.isNotEmpty((Object)customChartsSkipped)) break block7;
                StringBuilder sb = new StringBuilder();
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u6570\u636e\u56fe\u8868\u91cd\u590d\uff0c\u662f\u5426\u8986\u76d6\u66f4\u65b0\uff1a</div>");
                String msg = String.format("%s", String.join((CharSequence)"", customChartsSkipped));
                sb.append(msg);
                String cacheFileId = UniqueIdUtil.getSuid();
                ((CustomChartManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, xml);
                commonResult = new CommonResult(false, sb.toString(), (Object)cacheFileId);
            }
            catch (Throwable throwable) {
                File formDir3;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir3 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir3);
                }
                throw throwable;
            }
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                FileUtil.deleteDir((File)formDir2);
            }
            return commonResult;
        }
        ((CustomChartManagerImpl)AppUtil.getBean(this.getClass())).importData(xml);
        CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f!");
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
        return commonResult;
    }

    @Override
    public List<ImportCheckResult> importCheck(CustomChartList list) {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        for (CustomChart customChart : list.getCustomChartList()) {
            CustomChart chartByAlias = this.getChartByAlias(customChart.getAlias());
            if (!BeanUtils.isNotEmpty((Object)((Object)chartByAlias))) continue;
            results.add(new ImportCheckResult(true, "\u56fe\u8868", customChart.getName()));
        }
        return results;
    }

    @Override
    @CachePut(value={"eip:custom_chart:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:custom_chart:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:custom_chart:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public ObjectNode getTable(ObjectNode object) {
        String dsalias = object.get("dsalias").asText();
        String isTable = object.get("isTable").asText();
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        this.databaseContext.switchDS(dsalias, () -> {
            Table table = null;
            if ("1".equals(isTable)) {
                String objName = object.get("objName").asText();
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)this.databaseContext.getDbTypeByAlias(dsalias));
                try {
                    table = baseTableMeta.getTableByName(objName);
                }
                catch (Exception e) {
                    throw new BaseException("\u627e\u4e0d\u5230\u540d\u4e3a" + objName + "\u7684\u7269\u7406\u8868\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
                }
            } else {
                String diySql = object.get("diySql").asText();
                table = this.initMetafield(dsalias, diySql);
            }
            try {
                return result.set("table", JsonUtil.toJsonNode((Object)table));
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }, e -> {
            throw new BaseException(e.getMessage(), (Throwable)e);
        });
        return result;
    }

    @Override
    public CommonResult<String> saveCustomChart(CustomChart customChart) throws Exception {
        CustomChart chartByAlias = this.getChartByAlias(customChart.getAlias());
        String msg = "\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6210\u529f";
        if (StringUtil.isEmpty((String)customChart.getId())) {
            if (chartByAlias != null) {
                return new CommonResult(false, customChart.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6539\uff01");
            }
            this.create((Model)customChart);
        } else {
            if (chartByAlias != null && !chartByAlias.getId().equals(customChart.getId())) {
                return new CommonResult(false, customChart.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6539\uff01");
            }
            String customChartId = customChart.getId();
            Boolean state = this.portalFeignService.updateSysModuleByCustomId(customChartId, (ObjectNode)JsonUtil.toJsonNode((Object)((Object)customChart))).getState();
            if (!state.booleanValue()) {
                return new CommonResult(false, "\u4fee\u6539\u5931\u8d25\u8bf7\u91cd\u8bd5\uff01");
            }
            this.update((Model)customChart);
            msg = "\u66f4\u65b0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importData(Optional<String> cacheFileId) throws Exception {
        CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
        String cacheFile = cacheFileId.orElse("");
        String fileStr = ((CustomChartManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFile);
        if (StringUtil.isEmpty((String)fileStr)) {
            return new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
        }
        this.importData(fileStr);
        this.delImportFileFromCache(cacheFileId.orElse(""));
        return message;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<Map<String, String>> importData(CustomChartList list, boolean isCover) {
        List<CustomChart> customChartList = list.getCustomChartList();
        Assert.isTrue((customChartList.size() != 0 ? 1 : 0) != 0, (String)"\u5bfc\u5165\u6570\u636e\u56fe\u8868\u5185\u5bb9\u65e0\u6548", (Object[])new Object[0]);
        for (CustomChart customChart : customChartList) {
            this.importData(customChart, isCover);
        }
        List alias = customChartList.stream().map(CustomChart::getAlias).collect(Collectors.toList());
        Map<String, String> map = this.list((Wrapper)Wrappers.lambdaQuery().in(CustomChart::getAlias, alias)).stream().collect(Collectors.toMap(CustomChart::getAlias, CustomChart::getId, (k1, k2) -> k1));
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f", map);
    }

    private void importData(CustomChart customChart) {
        this.importData(customChart, true);
    }

    private void importData(CustomChart customChart, boolean isCover) {
        boolean existOldChart = false;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CustomChart::getAlias, (Object)customChart.getAlias());
        CustomChart oldCustomChart = (CustomChart)((Object)((CustomChartDao)this.baseMapper).selectOne((Wrapper)wrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)oldCustomChart))) {
            existOldChart = true;
        }
        if (1 == customChart.getType()) {
            this.databaseContext.switchDS(customChart.getDsalias(), dResult -> {
                short isTable;
                short s = isTable = customChart.getIsTable() != null ? customChart.getIsTable() : (short)1;
                if (isTable == 1) {
                    try {
                        BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                        baseTableMeta.getTableByName(customChart.getObjName());
                    }
                    catch (Exception e) {
                        throw new BaseException(String.format("\u6570\u636e\u6e90: %s \u4e2d\u7684\u6570\u636e\u8868: %s \u4e0d\u5b58\u5728!", customChart.getDsalias() + "", customChart.getObjName() + ""));
                    }
                } else {
                    this.checkSql(customChart.getDiySql());
                }
                return null;
            }, e -> {
                throw new BaseException(ResponseErrorEnums.DATABASE_ERROR, e.getMessage(), (Throwable)e);
            });
        }
        if (existOldChart) {
            if (isCover) {
                this.update((Object)customChart, (Wrapper)wrapper);
            }
        } else {
            String id = UniqueIdUtil.getSuid();
            customChart.setId(id);
            this.create((Model)customChart);
        }
        ThreadMsgUtil.addMapMsg2((String)"customChartsSaved", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", customChart.getName() + "", customChart.getAlias() + ""));
    }

    private void checkSql(String sql) {
        if (SQLUtil.containsSqlInjection((String)sql)) {
            throw new BaseException("SQL\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
        }
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
            jdbcTemplate.execute(sql);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("bad SQL grammar")) {
                throw new BaseException(ResponseErrorEnums.DATABASE_ERROR, "SQL\u8bed\u53e5\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01", (Throwable)e);
            }
            throw new BaseException("SQL\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
    }

    private Table initMetafield(String DsName, String sql) {
        ArrayList<DefaultColumn> list = new ArrayList<DefaultColumn>();
        DefaultTable table = new DefaultTable();
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)DsName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
        SqlRowSet srs = jdbcTemplate.queryForRowSet(sql);
        SqlRowSetMetaData srsmd = srs.getMetaData();
        for (int i = 1; i < srsmd.getColumnCount() + 1; ++i) {
            String cn = srsmd.getColumnName(i).toUpperCase();
            String ctn = srsmd.getColumnTypeName(i);
            DefaultColumn field = new DefaultColumn();
            field.setFieldName(cn);
            field.setComment(cn);
            field.setColumnType(this.simplifyDataType(ctn));
            list.add(field);
        }
        table.setColumnList(list);
        return table;
    }

    private String simplifyDataType(String type) {
        type = type.toLowerCase();
        String number = "int";
        String date = "date";
        String text = "text";
        String varchar = "varchar";
        if (varchar.contains(type)) {
            return "varchar";
        }
        if (text.contains(type)) {
            return "varchar";
        }
        if (date.contains(type)) {
            return "date";
        }
        if (number.contains(type)) {
            return "number";
        }
        return type;
    }
}

