/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hotent.base.entity.AutoFillModel;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.form.model.FormHistoryRecord;
import com.hotent.form.persistence.dao.FormHistoryRecordDao;
import com.hotent.form.persistence.manager.FormHistoryRecordManager;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formHistoryRecordManager")
public class FormHistoryRecordManagerImpl
extends BaseManagerImpl<FormHistoryRecordDao, FormHistoryRecord>
implements FormHistoryRecordManager {
    @Resource
    private IUserService userService;

    @Override
    public List<FormHistoryRecord> getFormHtmlByFormId(String formId) {
        return ((FormHistoryRecordDao)this.baseMapper).getFormHtmlByFormId(formId);
    }

    @Transactional(readOnly=true)
    public PageList<FormHistoryRecord> query(QueryFilter<FormHistoryRecord> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage result = ((FormHistoryRecordDao)this.baseMapper).selectPage(this.convert2IPage(pageBean), this.convert2Wrapper(queryFilter, FormHistoryRecord.class));
        Set userIds = result.getRecords().stream().filter(r -> StringUtils.isNotEmpty((String)r.getCreateBy())).map(AutoFillModel::getCreateBy).collect(Collectors.toSet());
        if (BeanUtils.isNotEmpty(userIds)) {
            List users = this.userService.getUserByIds(StringUtil.join(userIds));
            Map<String, IUser> userMap = users.stream().filter(u -> StringUtil.isNotEmpty((String)u.getUserId())).collect(Collectors.toMap(IUser::getUserId, u -> u, (u1, u2) -> u1));
            result.getRecords().stream().filter(r -> StringUtils.isNotEmpty((String)r.getCreateBy())).forEach(item -> item.setCreatorName(String.format("%s\uff08%s\uff09", ((IUser)userMap.get(item.getCreateBy())).getFullname(), ((IUser)userMap.get(item.getCreateBy())).getAccount())));
        }
        return new PageList(result);
    }
}

