/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.form.enums.FormType;
import com.hotent.form.model.FormMeta;
import com.hotent.form.model.FormTemplate;
import com.hotent.form.persistence.dao.FormTemplateDao;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormTemplateManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="bpmFormTemplateManager")
public class FormTemplateManagerImpl
extends BaseManagerImpl<FormTemplateDao, FormTemplate>
implements FormTemplateManager {
    @Resource
    FormMetaManager formMetaManager;

    public static String getFormTemplatePath() throws Exception {
        return FileUtil.getClassesPath() + File.separator + "template" + File.separator + "form" + File.separator;
    }

    @Override
    public FormTemplate getByTemplateAlias(String alias) {
        return ((FormTemplateDao)this.baseMapper).getByTemplateAlias(alias);
    }

    @Override
    @Transactional
    public void initAllTemplate() throws Exception {
        ((FormTemplateDao)this.baseMapper).delSystem();
        this.addTemplate();
    }

    @Override
    @Transactional
    public void init() throws Exception {
        Integer amount = ((FormTemplateDao)this.baseMapper).getHasData();
        if (amount == 0) {
            this.addTemplate();
        }
    }

    @Transactional
    public static void initTemplate() {
        FormTemplateManager service = (FormTemplateManager)AppUtil.getBean(FormTemplateManager.class);
        try {
            service.init();
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    private void addTemplate() throws Exception {
        String templateFilePath = "template/form/templates.xml";
        String xml = this.getTemplateFile(templateFilePath);
        Document document = Dom4jUtil.loadXml((String)xml);
        Element root = document.getRootElement();
        List list = root.elements();
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String type = element.attributeValue("type");
            String templateDesc = element.attributeValue("templateDesc");
            String macroAlias = element.attributeValue("macroAlias");
            String dir = element.attributeValue("dir");
            String filePath = String.format("template/form/%s/%s.ftl", dir, alias);
            String html = this.getTemplateFile(filePath);
            FormTemplate bpmFormTemplate = new FormTemplate();
            bpmFormTemplate.setTemplateId(UniqueIdUtil.getSuid());
            bpmFormTemplate.setMacrotemplateAlias(macroAlias);
            bpmFormTemplate.setHtml(html);
            bpmFormTemplate.setTemplateName(name);
            bpmFormTemplate.setAlias(alias);
            bpmFormTemplate.setCanedit(0);
            bpmFormTemplate.setTemplateType(type);
            bpmFormTemplate.setTemplateDesc(templateDesc);
            bpmFormTemplate.setSource("system");
            this.create((Model)bpmFormTemplate);
        }
    }

    private String getTemplateFile(String path) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        byte[] readByte = FileUtil.readByte((InputStream)stream);
        String word = new String(readByte, "UTF-8");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)word), (String)String.format("\u8bfb\u53d6\u8def\u5f84\u4e3a\uff1a%s \u7684\u6587\u4ef6\u65f6\uff0c\u83b7\u53d6\u5230\u7684\u5185\u5bb9\u4e3a\u7a7a.", path));
        return word;
    }

    @Override
    public boolean isExistAlias(String alias) {
        FormTemplate b = ((FormTemplateDao)this.baseMapper).getByTemplateAlias(alias);
        return b != null;
    }

    @Override
    @Transactional
    public void backUpTemplate(String id) {
        FormTemplate bpmFormTemplate = (FormTemplate)this.get((Serializable)((Object)id));
        String alias = bpmFormTemplate.getAlias();
        String name = bpmFormTemplate.getTemplateName();
        String desc = bpmFormTemplate.getTemplateDesc();
        String html = bpmFormTemplate.getHtml();
        String type = bpmFormTemplate.getTemplateType();
        String macroAlias = bpmFormTemplate.getMacrotemplateAlias();
        String templatePath = null;
        try {
            templatePath = FormTemplateManagerImpl.getFormTemplatePath();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String xmlPath = templatePath + "templates.xml";
        String xml = FileUtil.readFile((String)xmlPath);
        Document document = Dom4jUtil.loadXml((String)xml);
        Element root = document.getRootElement();
        Element e = root.addElement("template");
        e.addAttribute("alias", alias);
        e.addAttribute("name", name);
        e.addAttribute("type", type);
        e.addAttribute("templateDesc", desc);
        e.addAttribute("macroAlias", macroAlias);
        String content = document.asXML();
        FileUtil.writeFile((String)xmlPath, (String)content);
        FileUtil.writeFile((String)(templatePath + alias + ".ftl"), (String)html);
        bpmFormTemplate.setCanedit(0);
        this.update((Model)bpmFormTemplate);
    }

    @Override
    public List<FormTemplate> getTemplateType(String type) {
        if ("macro".equals(type)) {
            ArrayList<FormTemplate> templates = new ArrayList<FormTemplate>();
            templates.addAll(((FormTemplateDao)this.baseMapper).getTemplateType(type));
            templates.addAll(((FormTemplateDao)this.baseMapper).getTemplateType("mobileMacro"));
            return templates;
        }
        return ((FormTemplateDao)this.baseMapper).getTemplateType(type);
    }

    @Override
    public Map<String, Object> getTemplateTypeMap(String ... types) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String type : types) {
            map.put(type, this.getTemplateType(type));
        }
        return map;
    }

    @Override
    public List<FormTemplate> getAllMainTableTemplate(boolean isPC) {
        return this.getTemplateType(isPC ? "main" : "mobileMain");
    }

    @Override
    public List<FormTemplate> getAllSubTableTemplate(boolean isPC) {
        return this.getTemplateType(isPC ? "subTable" : "mobileSub");
    }

    @Override
    public Map<String, Object> selectTemplate(String defId, int isSimple, String templatesId, String formType) throws Exception {
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
        formType = StringUtil.isEmpty((String)formType) ? FormType.PC.value() : formType.replace("'", "\"").trim();
        JsonNode fieldList = bpmFormDef.getFieldList();
        List<FormTemplate> mainTableTemplates = this.getAllMainTableTemplate(formType.equals(FormType.PC.value()));
        List<FormTemplate> subTableTemplates = this.getAllSubTableTemplate(formType.equals(FormType.PC.value()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mainTableTemplates", mainTableTemplates);
        map.put("subTableTemplates", subTableTemplates);
        map.put("bpmForm", (Object)bpmFormDef);
        map.put("isSimple", isSimple);
        map.put("formType", formType);
        map.put("tableList", fieldList);
        return map;
    }

    @Override
    public List<FormTemplate> getAllMacroTemplate() {
        return this.getTemplateType("macro");
    }

    @Override
    public List<FormTemplate> getAllTableManageTemplate() {
        return this.getTemplateType("tableManage");
    }

    @Override
    public List<FormTemplate> getListTemplate() {
        return this.getTemplateType("list");
    }

    @Override
    public List<FormTemplate> getDetailTemplate() {
        return this.getTemplateType("detail");
    }

    @Override
    public List<FormTemplate> getDataTemplate() {
        return this.getTemplateType("dataTemplate");
    }

    @Override
    public List<FormTemplate> getQueryDataTemplate() {
        return this.getTemplateType("queryDataTemplate");
    }

    @Override
    public FormTemplate getTemplateByRev(Map<String, Object> map) {
        return ((FormTemplateDao)this.baseMapper).getTemplateByRev(map);
    }

    @Override
    @Transactional
    public void setDefault(String templateId, String templateType) {
        ((FormTemplateDao)this.baseMapper).setDefault(templateId);
    }

    @Override
    public CommonResult saveTemplate(FormTemplate bpmFormTemplate) {
        FormTemplate template;
        String templateId = bpmFormTemplate.getTemplateId();
        bpmFormTemplate.setIsDefault(0);
        if (StringUtil.isEmpty((String)templateId)) {
            bpmFormTemplate.setId(UniqueIdUtil.getSuid());
            bpmFormTemplate.setCanedit(1);
        }
        if (BeanUtils.isEmpty((Object)((Object)(template = (FormTemplate)this.get((Serializable)((Object)templateId)))))) {
            this.create((Model)bpmFormTemplate);
            return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", templateId);
        map.put("rev", bpmFormTemplate.getRev());
        FormTemplate bpmFormTemplate1 = this.getTemplateByRev(map);
        if (BeanUtils.isNotEmpty((Object)((Object)bpmFormTemplate1))) {
            this.update((Model)bpmFormTemplate);
            return new CommonResult(true, "\u66f4\u65b0\u6210\u529f", null);
        }
        return new CommonResult(false, "\u6b64\u6a21\u677f\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539", null);
    }

    @Override
    public CommonResult copyTemplate(String templateId, String newTemplateName, String newAlias) {
        FormTemplate bpmFormTemplate = (FormTemplate)this.get((Serializable)((Object)templateId));
        boolean isExist = this.isExistAlias(newAlias);
        if (isExist) {
            return new CommonResult(false, "\u8be5\u522b\u540d\u5df2\u88ab\u4f7f\u7528", null);
        }
        FormTemplate template = new FormTemplate();
        String newId = UniqueIdUtil.getSuid();
        template.setTemplateId(newId);
        template.setTemplateName(newTemplateName);
        template.setAlias(newAlias);
        template.setCanedit(1);
        template.setHtml(bpmFormTemplate.getHtml());
        template.setMacrotemplateAlias(bpmFormTemplate.getMacrotemplateAlias());
        template.setTemplateDesc(bpmFormTemplate.getTemplateDesc());
        template.setTemplateType(bpmFormTemplate.getTemplateType());
        template.setSource("custom");
        this.create((Model)template);
        return new CommonResult(true, "\u590d\u5236\u6a21\u677f\u6210\u529f", null);
    }
}

