/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.form.model.FormRight;
import com.hotent.form.model.FormRightXml;
import com.hotent.form.persistence.manager.FormRightManager;
import com.hotent.form.service.BpmFormRightsService;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmFormRightsService
implements BpmFormRightsService {
    @Resource
    FormRightManager bpmFormRightManager;

    @Override
    public String getPermission(String formKey, String userId, String flowKey, String parentFlowKey, String nodeId) {
        try {
            JsonNode permission = this.bpmFormRightManager.getPermission(formKey, flowKey, parentFlowKey, nodeId, 1);
            return permission.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getInstPermission(String formKey, String userId, String flowKey, String nodeId) {
        try {
            JsonNode permission = this.bpmFormRightManager.getPermission(formKey, flowKey, "", "", 2);
            return permission.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getStartPermission(String formKey, String flowKey, String nodeId, String nextNodeId) {
        try {
            JsonNode permission = this.bpmFormRightManager.getStartPermission(formKey, flowKey, nodeId, nextNodeId);
            if (BeanUtils.isNotEmpty((Object)permission)) {
                ObjectNode permissionNode = (ObjectNode)permission;
                if (permissionNode.has("desensitization")) {
                    permissionNode.remove("desensitization");
                }
                return permissionNode.toString();
            }
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getFormRightExportXml(ObjectNode formRight) throws JAXBException, JsonParseException, JsonMappingException, IOException {
        FormRightXml formRightList = new FormRightXml();
        ArrayNode arr = (ArrayNode)formRight.get("bpmFormRight");
        List rightList = (List)JsonUtil.toBean((String)JsonUtil.toJson((Object)arr), (TypeReference)new TypeReference<List<FormRight>>(){});
        formRightList.setRightList(rightList);
        String xml = JAXBUtil.marshall((Object)formRightList, FormRightXml.class);
        return xml;
    }

    @Override
    public void importFormRights(String formRightsXml) {
        this.bpmFormRightManager.importFormRights(formRightsXml, null);
    }

    @Override
    public void removeFormRights(String flowKey, String parentFlowKey) {
        this.bpmFormRightManager.removeInst(flowKey);
        this.bpmFormRightManager.remove(flowKey, parentFlowKey);
    }

    @Override
    public List<FormRight> getFormRigthListByFlowKey(String flowKey) {
        return this.bpmFormRightManager.getByFlowKey(flowKey);
    }

    @Override
    public void removeFormRightByFlowKey(String flowKey, String parentFlowKey, int permissionType) {
        this.bpmFormRightManager.removeByFlowKey(flowKey, parentFlowKey, permissionType);
    }

    @Override
    public void createFormRight(FormRight bpmFormRight) {
        this.bpmFormRightManager.create((Model)bpmFormRight);
    }

    @Override
    public List<FormRight> queryFormRight(QueryFilter queryFilter) {
        return this.bpmFormRightManager.query(queryFilter).getRows();
    }

    @Override
    public String getMyApplyPermission(String formKey, String flowKey, String parentFlowKey, String nodeId) {
        try {
            JsonNode permission = this.bpmFormRightManager.getMyApplyPermission(formKey, flowKey, parentFlowKey, nodeId);
            return permission.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

