/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.NotFoundException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bo.bodef.BoDefService;
import com.hotent.bo.context.FormContextThreadUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.bo.instance.BoDataHandler;
import com.hotent.bo.instance.BoInstanceFactory;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoDefXml;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.model.BoEntRel;
import com.hotent.bo.model.BoResult;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.bo.persistence.manager.BoEntRelManager;
import com.hotent.bo.util.BoUtil;
import com.hotent.form.manager.FormRemindDataManager;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormDefinitionTemplate;
import com.hotent.form.model.FormImportData;
import com.hotent.form.model.FormImportXml;
import com.hotent.form.model.FormMeta;
import com.hotent.form.model.FormRight;
import com.hotent.form.model.FormRightXml;
import com.hotent.form.model.FormXml;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormRightManager;
import com.hotent.form.service.BpmFormRightsService;
import com.hotent.form.service.FormComponentIOService;
import com.hotent.form.service.FormService;
import com.hotent.form.service.factory.FormComponentIOServiceFactory;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.util.FormUtil;
import com.hotent.form.vo.FormRestfulModel;
import com.hotent.table.datasource.DataSourceUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultFormService
implements FormService {
    @Resource
    private FormManager bpmFormManager;
    @Resource
    BoDefManager boDefManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoInstanceFactory boInstanceFactory;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    BoDefService boDefService;
    @Resource
    BoEntRelManager boEntRelManager;
    @Resource
    BpmFormRightsService bpmFormRightsService;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormRemindDataManager formRemindDataManager;
    @Resource
    FormComponentIOServiceFactory formComponentServiceFactory;
    @Resource
    BoAttributeManager boAttributeManager;

    @Override
    public Form getByFormKey(String formKey) {
        Form form = this.bpmFormManager.getMainByFormKey(formKey);
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            return form;
        }
        return this.getByFormId(formKey);
    }

    @Override
    public Form getByFormId(String formId) {
        return (Form)this.bpmFormManager.get((Serializable)((Object)formId));
    }

    @Override
    public String getFormExportXml(String formKeyStr) {
        String[] formKeys;
        ArrayList<String> id = new ArrayList<String>();
        for (String formKey : formKeys = formKeyStr.split(",")) {
            Form form = this.bpmFormManager.getMainByFormKey(formKey);
            id.add(form.getId());
        }
        Map<String, String> map = this.bpmFormManager.exportForms(id, false, false);
        return map.get("form.xml");
    }

    @Override
    public void importForm(String formXmlStr) {
        try {
            this.bpmFormManager.importByFormXml(formXmlStr, null, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u5165\u8868\u5355\u5931\u8d25" + e.getMessage(), e);
        }
    }

    @Override
    public BoDef getBoDefByAlias(String alias) throws IOException {
        if (StringUtil.isEmpty((String)alias)) {
            throw new RuntimeException("Bo\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.boDefManager.getByAlias(alias);
    }

    @Override
    @Transactional
    public List<BoResult> handlerBoData(String id, String defId, ObjectNode boData, String saveType) throws Exception {
        Object formKey;
        String permission;
        ObjectNode permissionObj;
        BoDataHandler handler = this.boInstanceFactory.getBySaveType(saveType);
        BoData curData = (BoData)JsonUtil.toBean((JsonNode)boData, BoData.class);
        if (BeanUtils.isNotEmpty((Object)boData.get("subMap"))) {
            this.handlerSubMap(curData, boData);
        }
        curData.setBoDefAlias(boData.get("boDef").get("alias").asText());
        HashMap<String, Map> boMap = new HashMap<String, Map>();
        boMap.put(boData.get("boDef").get("alias").asText(), curData.getData());
        String data = JsonUtil.toJson(boMap);
        if (StringUtil.isNotEmpty((String)id) && BeanUtils.isNotEmpty((Object)curData.getBoEnt()) && (BeanUtils.isNotEmpty((Object)curData.getBoEnt().getChildMap()) || BeanUtils.isNotEmpty((Object)curData.getSubMap())) && (permissionObj = (ObjectNode)JsonUtil.toJsonNode((String)(permission = this.bpmFormRightsService.getPermission((String)FormContextThreadUtil.getCommuVar((String)"formKey", (Object)""), AuthenticationUtil.getCurrentUserId(), (String)FormContextThreadUtil.getCommuVar((String)"flowKey", (Object)""), (String)FormContextThreadUtil.getCommuVar((String)"parentDefKey", (Object)""), (String)FormContextThreadUtil.getCommuVar((String)"nodeId", (Object)""))))).hasNonNull("subRowAuth")) {
            FormContextThreadUtil.putCommonVars((String)"subRowAuthJosn", (Object)JsonUtil.toJson((Object)permissionObj.get("subRowAuth")));
        }
        if (BeanUtils.isNotEmpty((Object)(formKey = FormContextThreadUtil.getCommuVar((String)"formKey", null)))) {
            this.handlerFormSetting(formKey.toString(), curData);
        }
        List list = handler.save(id, defId, curData);
        Object commuVar = FormContextThreadUtil.getCommuVar((String)"updateSubTableJson", (Object)"");
        ArrayNode updateArr = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)commuVar)) {
            updateArr = (ArrayNode)JsonUtil.toJsonNode((String)((String)commuVar));
        }
        for (BoResult result : list) {
            if (JsonUtil.getString((JsonNode)((ObjectNode)updateArr.get(0)), (String)"boAlias", (String)"").equals(result.getBoAlias()) && "add".equals(result.getAction())) {
                FormDataTemplateManager dataTemplateManager = (FormDataTemplateManager)AppUtil.getBean(FormDataTemplateManager.class);
                for (JsonNode jsonNode : updateArr) {
                    ObjectNode updateObj = (ObjectNode)jsonNode;
                    updateObj.put("newValue", result.getPk());
                    dataTemplateManager.updateTempRefId(updateObj);
                }
            }
            if (!StringUtil.isNotEmpty((String)result.getModifyDetail())) continue;
            result.setData(data);
            break;
        }
        return list;
    }

    private void handlerFormSetting(String formKey, BoData boData) throws Exception {
        FormMeta meta = this.formMetaManager.getByKey(formKey);
        if (BeanUtils.isNotEmpty((Object)meta.getIdentityConfig())) {
            FormUtil.handleIdentity(boData, meta.getIdentityConfig());
        }
    }

    private void handlerSubMap(BoData curData, ObjectNode boData) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode subMapNode = (ObjectNode)boData.get("subMap");
        Iterator fields = subMapNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (!jNode.isArray()) continue;
            ArrayList<BoData> datas = new ArrayList<BoData>();
            for (JsonNode jsonNode : jNode) {
                Iterator subFields = jsonNode.fields();
                BoData data = new BoData();
                HashMap sunBoDataMap = new HashMap();
                while (subFields.hasNext()) {
                    Map.Entry subNext = (Map.Entry)subFields.next();
                    String subkey = (String)subNext.getKey();
                    data.set(subkey, subNext.getValue());
                    if (!subkey.startsWith("sub_") || !BeanUtils.isNotEmpty(subNext.getValue())) continue;
                    JsonNode sunNode = (JsonNode)subNext.getValue();
                    ArrayList<BoData> sunBoDatas = new ArrayList<BoData>();
                    for (JsonNode itemNode : sunNode) {
                        BoData sunData = new BoData();
                        Iterator sunFields = itemNode.fields();
                        while (sunFields.hasNext()) {
                            Map.Entry sunNext = (Map.Entry)sunFields.next();
                            String sunkey = (String)sunNext.getKey();
                            sunData.set(sunkey, sunNext.getValue());
                        }
                        BoData bb = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)sunData), BoData.class);
                        sunBoDatas.add(bb);
                    }
                    sunBoDataMap.put(subkey, sunBoDatas);
                }
                BoData aa = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)data), BoData.class);
                if (!sunBoDataMap.isEmpty()) {
                    for (String sunKey : sunBoDataMap.keySet()) {
                        aa.setSubList(sunKey, (List)sunBoDataMap.get(sunKey));
                    }
                }
                datas.add(aa);
            }
            curData.setSubList(key, datas);
        }
    }

    @Override
    public BoData getBodataByDefCode(String saveMode, String code) {
        if (!this.boDefManager.getByAlias(code).isSupportDb()) {
            saveMode = "boObject";
        }
        BoDataHandler handler = this.boInstanceFactory.getBySaveType(saveMode);
        return handler.getByBoDefCode(code, Boolean.valueOf(false));
    }

    private BoData getBodataByDef(String saveMode, BoDef boDef) {
        if (!boDef.isSupportDb()) {
            saveMode = "boObject";
        }
        BoDataHandler handler = this.boInstanceFactory.getBySaveType(saveMode);
        return handler.getByBoDef(boDef, Boolean.valueOf(false));
    }

    @Override
    public BoData getBodataById(String saveModeDefault, String id, String code) throws IOException {
        BoDef boDef = this.boDefManager.getByAlias(code);
        String saveType = saveModeDefault;
        if (boDef != null && !boDef.isSupportDb()) {
            saveType = "boObject";
        }
        BoDataHandler handler = this.boInstanceFactory.getBySaveType(saveType);
        return handler.getByIdAndBoDef((Object)id, boDef);
    }

    @Override
    public String getBoDefExportXml(ObjectNode bodef) throws JAXBException, JsonParseException, JsonMappingException, IOException {
        ArrayNode arr = (ArrayNode)bodef.get("defList");
        BoDefXml bodefXml = new BoDefXml();
        List boList = (List)JsonUtil.toBean((String)JsonUtil.toJson((Object)arr), (TypeReference)new TypeReference<List<BoDef>>(){});
        bodefXml.setDefList(boList);
        String xml = JAXBUtil.marshall((Object)bodefXml, BoDefXml.class);
        return xml;
    }

    @Override
    public List<BoDef> importBo(String bodefXml) {
        List boDefs = this.boDefManager.parseXml(bodefXml);
        return this.boDefManager.importBoDef(boDefs);
    }

    @Override
    public List<BoDef> importBoDef(List<BoDef> bos) {
        return this.boDefManager.importBoDef(bos);
    }

    @Override
    public ObjectNode getBoJosn(String id) throws IOException {
        return this.boDefManager.getBOJson(id);
    }

    @Override
    public BoEnt getBoEntByName(String name) {
        return this.boDefService.getEntByName(name);
    }

    @Override
    public ObjectNode getMainBOEntByDefAliasOrId(String alias, String defId) throws IOException {
        List list = new ArrayList();
        if (BeanUtils.isNotEmpty((Object)defId)) {
            list = this.boEntManager.getByDefId(defId);
        } else {
            BoDef def = this.getBoDefByAlias(alias);
            if (BeanUtils.isNotEmpty((Object)def)) {
                defId = def.getId();
                list = this.boEntManager.getByDefId(def.getId());
            }
        }
        ObjectNode mainBoent = JsonUtil.getMapper().createObjectNode();
        ArrayNode childEntList = JsonUtil.getMapper().createArrayNode();
        for (BoEnt boEnt : list) {
            BoEntRel rel = this.boEntRelManager.getByDefIdAndEntId(defId, boEnt.getId());
            if (BeanUtils.isNotEmpty((Object)rel) && "main".equals(rel.getType())) {
                mainBoent = (ObjectNode)JsonUtil.toJsonNode((Object)boEnt);
                continue;
            }
            childEntList.add((JsonNode)((ObjectNode)JsonUtil.toJsonNode((Object)boEnt)));
        }
        if (BeanUtils.isNotEmpty((Object)mainBoent) && BeanUtils.isNotEmpty((Object)childEntList)) {
            mainBoent.set("childEnts", (JsonNode)childEntList);
        }
        return mainBoent;
    }

    @Override
    public List<BoData> getBoDataByBoKeys(List<String> boCode) {
        ArrayList<BoData> list = new ArrayList<BoData>();
        for (String code : boCode) {
            BoData bodataByDefCode = this.getBodataByDefCode("database", code);
            list.add(bodataByDefCode);
        }
        return list;
    }

    @Override
    public List<BoData> getBoDataByBoDefs(List<BoDef> boDefList) {
        ArrayList<BoData> list = new ArrayList<BoData>();
        for (BoDef boDef : boDefList) {
            BoData bodataByDefCode = this.getBodataByDef("database", boDef);
            list.add(bodataByDefCode);
        }
        return list;
    }

    @Override
    public void removeDataByBusLink(JsonNode links) throws Exception {
        if (BeanUtils.isNotEmpty((Object)links)) {
            for (JsonNode jsonNode : links) {
                BoEnt ent;
                String idVal;
                ObjectNode link = (ObjectNode)jsonNode;
                String saveModel = link.get("saveMode").asText();
                String string = idVal = BeanUtils.isEmpty((Object)link.get("businesskeyStr")) ? link.get("businesskey").asText() : link.get("businesskeyStr").asText();
                if ("boObject".equals(link.get("saveMode").asText())) {
                    String sql = "delete from form_bo_int where id_ = '" + idVal + "'";
                    this.jdbcTemplate.execute(sql);
                } else if ("database".equals(saveModel) && BeanUtils.isNotEmpty((Object)(ent = this.boDefService.getEntByName(link.get("formIdentify").asText())))) {
                    String sql = "delete from " + ent.getTableName() + " where " + ent.getPkKey() + " = '" + idVal + "'";
                    if (ent.getIsExternal() == 1) {
                        try {
                            DataSourceUtil.getJdbcTempByDsAlias((String)ent.getDsName()).execute(sql);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            this.jdbcTemplate.execute(sql);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.formRemindDataManager.deleteFormRemindDataByBoDataId((QueryWrapper)new QueryWrapper().eq((Object)"OPEM_ID", (Object)idVal));
            }
        }
    }

    @Override
    public Map<String, String> getFormAndBoExportXml(ObjectNode obj) throws JAXBException {
        String[] formKeys;
        String formKeyStr = obj.get("formKeys").asText();
        String defKeys = obj.get("defKeys").asText();
        ArrayList<String> id = new ArrayList<String>();
        for (String string : formKeys = formKeyStr.split(",")) {
            Form form = this.bpmFormManager.getMainByFormKey(string);
            if (!BeanUtils.isNotEmpty((Object)((Object)form))) continue;
            id.add(form.getId());
        }
        Map<String, String> map = this.bpmFormManager.exportForms(id, true, false);
        String[] defKeyArr = defKeys.split(",");
        FormRightXml formRightList = new FormRightXml();
        for (String defKey : defKeyArr) {
            List<FormRight> bpmFormRight = this.bpmFormRightsService.getFormRigthListByFlowKey(defKey);
            formRightList.addBpmFormRight(bpmFormRight);
        }
        String string = JAXBUtil.marshall((Object)formRightList, FormRightXml.class);
        map.put("formrights.xml", string);
        return map;
    }

    @Override
    public CommonResult<String> importFormAndBo(ObjectNode obj, String typeId) throws Exception {
        return this.importFormAndBo(obj, "jump", typeId);
    }

    @Override
    public CommonResult<String> importFormAndBo(ObjectNode obj, String status, String typeId) throws Exception {
        return this.importFormAndBo(obj, status, typeId, data -> {
            try {
                this.bpmFormManager.importByFormXml((FormImportData)data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CommonResult<String> importFormAndBo(ObjectNode obj, String status, String typeId, Consumer<FormImportData> consumer) throws Exception {
        List importBoDef;
        String formXmlStr = obj.get("formXmlStr").asText();
        String boXmlStr = obj.get("boXmlStr").asText();
        List boDefs = this.boDefManager.parseXml(boXmlStr);
        ArrayList<String> hasRightImportForms = new ArrayList<String>();
        ArrayList<String> hasRightImportBos = new ArrayList<String>();
        this.checkRight(formXmlStr, hasRightImportForms, hasRightImportBos);
        List<BoDef> hasRightBoDefs = this.removeDuplicate(boDefs, hasRightImportBos);
        Map<String, String> nameMap = this.getEntIdMap(hasRightBoDefs, null);
        try {
            importBoDef = this.boDefManager.importBoDef(hasRightBoDefs);
        }
        catch (Exception e) {
            return CommonResult.error((String)e.getMessage());
        }
        FormImportData formImportData = new FormImportData(formXmlStr, typeId, importBoDef, nameMap, hasRightImportForms);
        consumer.accept(formImportData);
        if (obj.has("formRightsXml")) {
            String formRightsXml = obj.get("formRightsXml").asText();
            this.bpmFormRightManager.importFormRights(formRightsXml, hasRightImportForms);
        }
        for (FormComponentIOService formComponentService : this.formComponentServiceFactory.getFormComponentServices()) {
            Map param = (Map)JsonUtil.toBean((JsonNode)obj, Map.class);
            formComponentService.importData(param, status);
        }
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public CommonResult<String> importFormAndBo(ObjectNode obj, String status, Consumer<FormImportData> consumer) throws Exception {
        List importBoDef;
        String formXmlStr = obj.get("formXmlStr").asText();
        String boXmlStr = obj.get("boXmlStr").asText();
        List boDefs = this.boDefManager.parseXml(boXmlStr);
        ArrayList<String> hasRightImportForms = new ArrayList<String>();
        ArrayList<String> hasRightImportBos = new ArrayList<String>();
        this.checkRight(formXmlStr, hasRightImportForms, hasRightImportBos, ResourceModelType.FORM_DEFINITION_TEMPLATE);
        List<BoDef> hasRightBoDefs = this.removeDuplicate(boDefs, hasRightImportBos);
        Map<String, String> nameMap = this.getEntIdMap(hasRightBoDefs, null);
        try {
            importBoDef = this.boDefManager.importBoDef(hasRightBoDefs);
        }
        catch (Exception e) {
            return CommonResult.error((String)e.getMessage());
        }
        FormImportData formImportData = new FormImportData(formXmlStr, null, importBoDef, nameMap, hasRightImportForms);
        consumer.accept(formImportData);
        if (obj.has("formRightsXml")) {
            String formRightsXml = obj.get("formRightsXml").asText();
            this.bpmFormRightManager.importFormRights(formRightsXml, hasRightImportForms);
        }
        for (FormComponentIOService formComponentService : this.formComponentServiceFactory.getFormComponentServices()) {
            Map param = (Map)JsonUtil.toBean((JsonNode)obj, Map.class);
            formComponentService.importData(param, status);
        }
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    private void checkRight(String formXmlStr, List<String> canImportForms, List<String> canImportBos) throws IOException, JAXBException {
        FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
        List<FormXml> formXmlList = formImportXml.getFormXmlList();
        Map<String, Boolean> boRightMap = CustomUtil.getRightMapByModel(BoDef.class, ResourceModelType.BO, ResourcesRightType.EDIT);
        Map<String, Boolean> formRightMap = new HashMap<String, Boolean>();
        for (int i = 0; i < formXmlList.size(); ++i) {
            FormXml formXml = formXmlList.get(i);
            Form bpmForm = formXml.getBpmForm();
            if (i == 0) {
                formRightMap = "pc".equals(bpmForm.getFormType()) ? CustomUtil.getRightMapByModel(Form.class, ResourceModelType.PC_FORM, ResourcesRightType.EDIT) : CustomUtil.getRightMapByModel(Form.class, ResourceModelType.MOBILE_FORFM, ResourcesRightType.EDIT);
            }
            if (!CustomUtil.checkRight(formRightMap, bpmForm.getFormKey()) || BeanUtils.isEmpty(formXml.getBoCodes())) continue;
            boolean hasRight = true;
            for (String boCode : formXml.getBoCodes()) {
                if (CustomUtil.checkRight(boRightMap, boCode)) continue;
                hasRight = false;
            }
            if (!hasRight) continue;
            canImportForms.add(bpmForm.getFormKey());
            canImportBos.addAll(formXml.getBoCodes());
        }
    }

    private void checkRight(String formXmlStr, List<String> canImportForms, List<String> canImportBos, ResourceModelType resourceModelType) throws IOException, JAXBException {
        FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
        List<FormXml> formXmlList = formImportXml.getFormXmlList();
        Map<String, Boolean> boRightMap = CustomUtil.getRightMapByModel(BoDef.class, ResourceModelType.BO, ResourcesRightType.EDIT);
        Map<String, Boolean> formRightMap = new HashMap<String, Boolean>();
        for (int i = 0; i < formXmlList.size(); ++i) {
            FormXml formXml = formXmlList.get(i);
            FormDefinitionTemplate bpmForm = formXml.getBpmFormTemplate();
            if (i == 0) {
                formRightMap = "pc".equals(bpmForm.getFormType()) ? CustomUtil.getRightMapByModel(FormDefinitionTemplate.class, resourceModelType, ResourcesRightType.EDIT) : CustomUtil.getRightMapByModel(Form.class, ResourceModelType.MOBILE_FORFM, ResourcesRightType.EDIT);
            }
            if (!CustomUtil.checkRight(formRightMap, bpmForm.getFormKey()) || BeanUtils.isEmpty(formXml.getBoCodes())) continue;
            boolean hasRight = true;
            for (String boCode : formXml.getBoCodes()) {
                if (CustomUtil.checkRight(boRightMap, boCode)) continue;
                hasRight = false;
            }
            if (!hasRight) continue;
            canImportForms.add(bpmForm.getFormKey());
            canImportBos.addAll(formXml.getBoCodes());
        }
    }

    private List<BoDef> removeDuplicate(List<BoDef> boDefs, List<String> canImportBos) {
        ArrayList<BoDef> defList = new ArrayList<BoDef>();
        if (BeanUtils.isNotEmpty(boDefs)) {
            HashSet<String> defCodes = new HashSet<String>();
            for (BoDef boDef : boDefs) {
                if (defCodes.contains(boDef.getAlias()) || !canImportBos.contains(boDef.getAlias())) continue;
                defCodes.add(boDef.getAlias());
                defList.add(boDef);
            }
            boDefs = defList;
        }
        return defList;
    }

    @Override
    public BoData getByFormRestfulModel(FormRestfulModel model) throws IOException {
        FormContextThreadUtil.putCommonVars((String)"defId", (Object)model.getFlowDefId());
        FormContextThreadUtil.putCommonVars((String)"nodeId", (Object)model.getNodeId());
        FormContextThreadUtil.putCommonVars((String)"parentDefKey", (Object)model.getParentFlowKey());
        FormContextThreadUtil.putCommonVars((String)"subRowAuthJosn", (Object)model.getSubRowAuthJosn());
        FormContextThreadUtil.putCommonVars((String)"flowCreaterID", (Object)model.getFlowCreaterID());
        FormContextThreadUtil.putCommonVars((String)"flowCreaterAccount", (Object)model.getFlowCreaterAccount());
        FormContextThreadUtil.putCommonVars((String)"flowCreaterName", (Object)model.getFlowCreaterName());
        FormContextThreadUtil.putCommonVars((String)"subCreaterID", (Object)model.getSubCreaterID());
        FormContextThreadUtil.putCommonVars((String)"subCreaterAccount", (Object)model.getSubCreaterAccount());
        FormContextThreadUtil.putCommonVars((String)"subCreaterName", (Object)model.getSubCreaterName());
        FormContextThreadUtil.putCommonVars((String)"formType", (Object)model.getFormType());
        FormContextThreadUtil.putCommonVars((String)"desensitization", (Object)model.getDesensitization());
        BoUtil.handlerDesensitizeSettings((String)model.getDesensitization(), (String)model.getFormType());
        BoData boData = this.getBodataById(model.getSaveType(), model.getBoid(), model.getCode());
        boData.setBoDefAlias(boData.getBoDef().getAlias());
        return boData;
    }

    private Map<String, String> getEntIdMap(List<BoDef> importBoDef, Map<String, String> nameMap) {
        HashMap<String, String> entIdMap = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty(importBoDef)) {
            for (BoDef def : importBoDef) {
                if (!BeanUtils.isNotEmpty((Object)def.getBoEnt())) continue;
                BoEnt ent = def.getBoEnt();
                if (BeanUtils.isNotEmpty((Object)ent.getBoAttrList())) {
                    if (BeanUtils.isNotEmpty(nameMap)) {
                        entIdMap.put(nameMap.get(ent.getName()), ent.getId());
                    } else {
                        entIdMap.put(ent.getName(), ((BoAttribute)ent.getBoAttrList().get(0)).getEntId());
                    }
                }
                if (!BeanUtils.isNotEmpty((Object)ent.getChildEntList())) continue;
                List subEnts = ent.getChildEntList();
                for (BoEnt subEnt : subEnts) {
                    if (BeanUtils.isNotEmpty((Object)subEnt.getBoAttrList())) {
                        if (BeanUtils.isNotEmpty(nameMap)) {
                            entIdMap.put(nameMap.get(subEnt.getName()), subEnt.getId());
                        } else {
                            entIdMap.put(subEnt.getName(), ((BoAttribute)subEnt.getBoAttrList().get(0)).getEntId());
                        }
                    }
                    if (!BeanUtils.isNotEmpty((Object)subEnt.getChildEntList())) continue;
                    List sunEnts = subEnt.getChildEntList();
                    for (BoEnt sunEnt : sunEnts) {
                        if (!BeanUtils.isNotEmpty((Object)sunEnt.getBoAttrList()) || !BeanUtils.isNotEmpty((Object)subEnt.getBoAttrList())) continue;
                        if (BeanUtils.isNotEmpty(nameMap)) {
                            entIdMap.put(nameMap.get(sunEnt.getName()), sunEnt.getId());
                            continue;
                        }
                        entIdMap.put(sunEnt.getName(), ((BoAttribute)sunEnt.getBoAttrList().get(0)).getEntId());
                    }
                }
            }
        }
        return entIdMap;
    }

    @Override
    @Transactional
    public List<List<BoResult>> batchHandlerBoData(List<FormRestfulModel> models) throws Exception {
        ArrayList<List<BoResult>> list = new ArrayList<List<BoResult>>();
        for (FormRestfulModel model : models) {
            FormContextThreadUtil.putCommonVars((String)"defId", (Object)model.getFlowDefId());
            FormContextThreadUtil.putCommonVars((String)"nodeId", (Object)model.getNodeId());
            FormContextThreadUtil.putCommonVars((String)"flowKey", (Object)model.getFlowKey());
            FormContextThreadUtil.putCommonVars((String)"formKey", (Object)model.getFormkey());
            FormContextThreadUtil.putCommonVars((String)"parentDefKey", (Object)(StringUtil.isEmpty((String)model.getParentFlowKey()) ? "" : model.getParentFlowKey()));
            if (StringUtil.isNotEmpty((String)model.getUpdateSubTableJson())) {
                FormContextThreadUtil.putCommonVars((String)"updateSubTableJson", (Object)model.getUpdateSubTableJson());
            }
            if (StringUtil.isNotEmpty((String)model.getHasCheckFormDataRev())) {
                FormContextThreadUtil.putCommonVars((String)"hasCheckFormDataRev", (Object)model.getHasCheckFormDataRev());
                if ("false".equals(model.getHasCheckFormDataRev())) {
                    ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
                }
            }
            if (StringUtil.isNotEmpty((String)model.getDesensitization())) {
                BoUtil.handlerDesensitizeSettings((String)model.getDesensitization(), (String)model.getFormType());
            }
            List<BoResult> result = this.handlerBoData(model.getBoid(), model.getDefId(), model.getBoData(), model.getSaveType());
            list.add(result);
        }
        return list;
    }

    @Override
    public List<BoDef> getBodefWithMainEntByAlias(String alias) throws NotFoundException {
        if (StringUtil.isEmpty((String)alias)) {
            throw new RuntimeException("Bo\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<BoDef> list = new ArrayList<BoDef>();
        for (String boDef : alias.split(",")) {
            if (!StringUtil.isNotEmpty((String)boDef)) continue;
            BoDef byAlias = this.boDefManager.getByAlias(boDef);
            if (BeanUtils.isEmpty((Object)byAlias)) {
                throw new NotFoundException(String.format("\u6839\u636e\u6570\u636e\u5efa\u6a21\u522b\u540d\u3010%s\u3011\u672a\u627e\u5230\u6570\u636e\u5efa\u6a21", boDef));
            }
            list.add(byAlias);
        }
        return list;
    }
}

