/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service.control.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.model.BoAttribute;
import com.hotent.form.service.control.IControlType;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

@Component
public class NumberControlType
implements IControlType {
    @Override
    public ObjectNode generateConfig(BoAttribute attribute) {
        ObjectNode optionsNode = JsonUtil.createObjectNode();
        this.initOptionsNode(optionsNode, attribute);
        if (StringUtil.isEmpty((String)attribute.getDefaultValue())) {
            optionsNode.put("defaultValue", 0);
        }
        optionsNode.put("validateType", "min_value|max_value|confirmed|numeric|between|digits|required|row_unique|frontJSValidate|mobile");
        optionsNode.put("dataType", "number");
        optionsNode.put("filtercurrency", "");
        optionsNode.put("filterthousandBit", "");
        BigDecimal maxNumber = this.getMaxNumber(attribute.getAttrLength());
        BigDecimal minNumber = new BigDecimal(0).subtract(maxNumber);
        optionsNode.put("min", minNumber);
        optionsNode.put("max", maxNumber);
        optionsNode.put("numberMin", minNumber);
        optionsNode.put("numberMax", maxNumber);
        optionsNode.put("step", 1);
        optionsNode.put("decimalDigits", attribute.getDecimalLen());
        optionsNode.put("maxDecimalDigits", attribute.getDecimalLen());
        optionsNode.put("mathExp", "");
        optionsNode.put("disabled", false);
        optionsNode.put("controlsPosition", "");
        optionsNode.put("advancedProperty", "inputType|bindPreAndSufFix|disabled");
        optionsNode.put("basicsProperty", "number|currency|placeholder|dateCount");
        optionsNode.put("company", "");
        optionsNode.put("formulasDiyJs", "");
        ObjectNode fixjsonNode = JsonUtil.getMapper().createObjectNode();
        fixjsonNode.put("preFix", "");
        fixjsonNode.put("sufSix", "");
        optionsNode.set("bindPreAndSufFixjson", (JsonNode)fixjsonNode);
        optionsNode.put("noBindModel", false);
        optionsNode.put("labelAlign", "");
        optionsNode.put("controls", true);
        optionsNode.put("isValidate", true);
        return optionsNode;
    }

    private BigDecimal getMaxNumber(int attrLen) {
        StringBuilder max = new StringBuilder();
        if (attrLen == 0) {
            max = new StringBuilder("9");
        } else {
            for (int i = 0; i < attrLen; ++i) {
                max.append("9");
            }
        }
        BigDecimal decimal = new BigDecimal(Double.parseDouble(max.toString()));
        return decimal.setScale(0, 4);
    }
}

