/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.form.enums.ComponentType;
import com.hotent.form.manager.FormCustomComponentManager;
import com.hotent.form.model.FormCustomComponent;
import com.hotent.form.service.FormComponentIOService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomComponentIOService
implements FormComponentIOService {
    @Resource
    FormCustomComponentManager formCustomComponentManager;

    @Override
    public ComponentType getType() {
        return ComponentType.CUSTOM_COMPONENT;
    }

    @Override
    public String getAlias(ObjectNode options) {
        return JsonUtil.getString((JsonNode)options, (String)"alias");
    }

    @Override
    public Map<String, String> getExportContent(String ... alias) throws Exception {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(FormCustomComponent::getAlias, Arrays.asList(alias));
        List components = this.formCustomComponentManager.list((Wrapper)wrapper);
        return this.handleExportContent(components);
    }

    @Override
    public List<ImportCheckResult> importCheck(Map<String, String> map) throws IOException {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return results;
        }
        List customComponents = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<FormCustomComponent>>(){});
        this.formCustomComponentManager.importCheck(customComponents, component -> results.add(new ImportCheckResult(true, "\u81ea\u5b9a\u4e49\u7ec4\u4ef6", component.getName())));
        return results;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importData(Map<String, String> map, String status) throws IOException {
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return;
        }
        List customComponents = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<FormCustomComponent>>(){});
        this.formCustomComponentManager.importData(customComponents, status);
    }
}

