/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.form.enums.ComponentType;
import com.hotent.form.model.CustomQuery;
import com.hotent.form.persistence.manager.CustomQueryManager;
import com.hotent.form.service.FormComponentIOService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomQueryIOService
implements FormComponentIOService {
    @Resource
    CustomQueryManager customQueryManager;
    @Resource
    PortalFeignService portalFeignService;
    private static final String GROUP_KEY = "Query_TYPE";
    private static final String TYPE_KEY = "default";

    @Override
    public ComponentType getType() {
        return ComponentType.CUSTOM_QUERY;
    }

    @Override
    public String getAlias(ObjectNode options) {
        return JsonUtil.getStrByPath((JsonNode)options, (String)"customQuery.alias", jsonNode -> {});
    }

    @Override
    public Map<String, String> getExportContent(String ... alias) throws Exception {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(CustomQuery::getAlias, Arrays.asList(alias));
        List list = this.customQueryManager.list((Wrapper)wrapper);
        return this.handleExportContent(list);
    }

    @Override
    public List<ImportCheckResult> importCheck(Map<String, String> map) throws IOException {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return results;
        }
        List customQueries = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomQuery>>(){});
        this.customQueryManager.importCheck(customQueries, customQuery -> results.add(new ImportCheckResult(true, "\u5173\u8054\u67e5\u8be2", customQuery.getName())));
        return results;
    }

    @Override
    public void importData(Map<String, String> map, String status) throws IOException {
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return;
        }
        List customQueries = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomQuery>>(){});
        ObjectNode sysTypeByType = this.portalFeignService.getSysTypeByType(GROUP_KEY, TYPE_KEY);
        if (BeanUtils.isEmpty((Object)sysTypeByType)) {
            throw new BaseException("\u5173\u8054\u67e5\u8be2\u4e0d\u5b58\u5728\u9ed8\u8ba4\u5206\u7c7b");
        }
        this.customQueryManager.importData(customQueries, status, JsonUtil.getString((JsonNode)sysTypeByType, (String)"id"), true);
    }
}

