/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.form.param.RelationParam;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTemplateUtil {
    private DataTemplateUtil() {
    }

    public static List<RelationParam> getRelationParams(JsonNode button) throws IOException {
        JsonNode relationConfig;
        if (BeanUtils.isNotEmpty((Object)button) && BeanUtils.isNotEmpty((Object)(relationConfig = button.get("relationConfig")))) {
            String data = relationConfig.asText();
            byte[] bytes = Base64.decodeBase64((String)data);
            JsonNode node = JsonUtil.toJsonNode((String)new String(bytes, StandardCharsets.UTF_8));
            return (List)JsonUtil.toBean((String)node.get("globalQueryJson").toString(), (TypeReference)new TypeReference<List<RelationParam>>(){});
        }
        return new ArrayList<RelationParam>();
    }

    public static ArrayNode getBatchUpdateData(JsonNode button) throws IOException {
        JsonNode batchUpdateData;
        if (BeanUtils.isNotEmpty((Object)button) && BeanUtils.isNotEmpty((Object)(batchUpdateData = button.get("batchUpdateData")))) {
            String fromBase64 = Base64.getFromBase64((String)batchUpdateData.asText());
            return (ArrayNode)JsonUtil.toJsonNode((String)fromBase64);
        }
        return JsonUtil.createArrayNode();
    }

    public static Map<String, String> getFilterMap(ArrayNode batchUpdateData) throws IOException {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        for (JsonNode jsonNode : batchUpdateData) {
            String outConfigString = JsonUtil.getString((JsonNode)jsonNode, (String)"outConfig");
            if (!BeanUtils.isNotEmpty((Object)outConfigString)) continue;
            JsonNode outConfig = JsonUtil.toJsonNode((String)outConfigString);
            JsonNode parameter = JsonUtil.getIgnoreCase((JsonNode)outConfig, (String)"parameter");
            JsonNode resultFieldNode = JsonUtil.getByPath((JsonNode)outConfig, (String)"dialogConfig.resultField");
            if (!BeanUtils.isNotEmpty((Object)resultFieldNode) || !(resultFieldNode instanceof ArrayNode)) continue;
            ArrayNode resultFields = (ArrayNode)resultFieldNode;
            for (JsonNode resultField : resultFields) {
                String field = JsonUtil.getString((JsonNode)resultField, (String)"field");
                String fillBackType = JsonUtil.getString((JsonNode)resultField, (String)"fillBackType");
                if (!BeanUtils.isNotEmpty((Object)parameter) || !parameter.has(field) || !StringUtil.isNotEmpty((String)parameter.get(field).asText())) continue;
                filterMap.put(parameter.get(field).asText(), fillBackType);
            }
        }
        return filterMap;
    }
}

