package ${package.Controller};


import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import poi.util.ExcelUtil;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
<#if restControllerStyle>
import org.springframework.web.bind.annotation.RestController;
<#else>
import org.springframework.stereotype.Controller;
</#if>
import org.springframework.web.multipart.MultipartFile;
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>
import ${package.Entity}.${entity};
import ${package.Service}.${table.serviceName};

/**
 * ${table.comment!} 前端控制器
 *
 <#if cfg.companyName??>
 * @company ${cfg.companyName}
 </#if>
 * @author ${author}
 <#if cfg.authorEmail??>
 * @email ${cfg.authorEmail}
 </#if>
 * @since ${date}
 */
<#if restControllerStyle>
@RestController
<#else>
@Controller
</#if>
@RequestMapping("<#if package.ModuleName?? && package.ModuleName != "">/${package.ModuleName}</#if>/<#if controllerMappingHyphenStyle??>${controllerMappingHyphen}<#else>${table.entityPath}</#if>/v1/")
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public class ${table.controllerName} extends ${superControllerClass}<${table.serviceName}, ${entity}> {
<#else>
public class ${table.controllerName} {
</#if>

<#if cfg.type != "querySqldef">
	/**
	 * 根据id获取${table.comment!}数据详情
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getDetail")
	@ApiOperation(value="根据id获取${table.comment!}数据详情",httpMethod = "GET",notes = "根据id获取${table.comment!}数据详情")
	public CommonResult<${entity}> getDetail(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam(required=true) String id) throws Exception{
		return CommonResult.<${entity}>ok().value(baseService.getDetail(id));
	}
    /**
	 * 新增,更新${table.comment!}
	 * @param ${entity?uncap_first}
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="/save")
	@ApiOperation(value = "新增,更新${table.comment!}数据", httpMethod = "POST", notes = "新增,更新${table.comment!}数据")
	public CommonResult<String> save(@ApiParam(name="${entity}",value="${table.comment!}对象", required = true)@RequestBody ${entity} ${entity?uncap_first}) throws Exception{
		String msg = StringUtil.isEmpty(${entity?uncap_first}.getId()) ? "添加${table.comment!}成功" : "更新${table.comment!}成功";
		baseService.createOrUpdate(${entity?uncap_first});
		return CommonResult.<String>ok().message(msg);
	}

	/**
	 * 复制${table.comment!}
	 * 
	 * @param id           主键
	 * @param ignoreFields 忽略的字段
	 * @return
	 * @throws Exception
	 */
	@GetMapping(value="/copy")
	@ApiOperation(value = "复制一条数据", httpMethod = "GET", notes = "复制一条数据")
	public CommonResult<String> save(@ApiParam(name="id",value="${table.comment!}对象主键", required = true) @RequestParam String id,
			@ApiParam(name="ignoreFields",value="忽略的字段", required = true)@RequestParam Optional<String> ignoreFields) throws Exception{
		
		${entity} ${entity?uncap_first} = baseService.get(id);
		if (BeanUtils.isEmpty(${entity?uncap_first})) {
			return CommonResult.<String>error().message("复制成功失败:根据传入的id未找到对象");
		}
		${entity?uncap_first}.setId(null);
		if (StringUtil.isNotEmpty(ignoreFields.orElse(""))) {
			for (String field : ignoreFields.orElse("").split(",")) {
				BeanUtils.setProperty(${entity?uncap_first}, field, null);
			}
		}
		baseService.save(${entity?uncap_first});
		return CommonResult.<String>ok().message("复制成功");
	}
	
	/**
	 * 更新数据
	 * @param ids
	 * @param field
	 * @param value
	 * @return
	 * @throws Exception
	 */
	@GetMapping(value="/updateData")
	@ApiOperation(value = "更新数据", httpMethod = "GET", notes = "更新数据")
	public CommonResult<String> updateData(@ApiParam(name="ids",value="主表信息对象主键", required = true) @RequestParam String ids,
			@ApiParam(name="field",value="要更新的字段", required = true)@RequestParam String field,
			@ApiParam(name="value",value="更新的值", required = true)@RequestParam Object value) throws Exception{
		UpdateWrapper<${entity}> update = new UpdateWrapper<>();
		update.set(field, value);
		update.in("id_", Arrays.asList(ids.split(",")));
		baseService.update(update);
		return CommonResult.<String>ok().message("操作成功");
	}
	
		
	/**
	 * 根据QueryFilter导出数据
	 * 
	 * @param response
	 * @param ignoreFields
	 * @param filter
	 * @throws Exception
	 */
	@PostMapping(value = "exportByFilter", produces = {"application/json; charset=utf-8" })
	@ApiOperation(value = "根据QueryFilter导出数据", httpMethod = "POST", notes = "根据QueryFilter导出数据")
	public void exportByFilter(HttpServletResponse response,
			@ApiParam(name = "ignoreFields", value = "忽略导出的字段", required = true) @RequestParam Optional<String> ignoreFields,
			@ApiParam(name = "filter", value = "通用查询参数对象") @RequestBody QueryFilter<${entity}> filter) throws Exception {
		List<${entity}> queryData = baseService.queryNoPage(filter);
		ExcelUtil.exportData(response, ignoreFields.orElse(""), queryData, ${entity}.class);
	}
	
	/**
	 * 导入数据
	 * @param file
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value = "importData", produces = {"application/json; charset=utf-8"})
	@ApiOperation(value = "导入数据", httpMethod = "POST", notes = "导入数据")
	public CommonResult<String> importData(@ApiParam(name = "files", value = "上传的文件流") @RequestBody List<MultipartFile> file) throws Exception {
		List<${entity}> data = ExcelUtil.resolveData(file.get(0),${entity}.class);
		baseService.saveOrUpdateBatch(data);
		return new CommonResult<>(true, "导入成功");
	}
	
</#if>
}
</#if>
