package ${package.Entity};

<#list table.importPackages as pkg>
import ${pkg};
</#list>
<#if swagger2>
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
</#if>
<#if entityLombokModel>
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
</#if>
import com.fasterxml.jackson.annotation.JsonProperty;
<#if cfg.boEntList?exists>
	<#if cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name)?? && (cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name)?size>0) >
import java.util.List;
	</#if>
</#if>
/**
 * ${table.comment!}
 *
 <#if cfg.companyName??>
 * @company ${cfg.companyName}
 </#if>
 * @author ${author}
 <#if cfg.authorEmail??>
 * @email ${cfg.authorEmail}
 </#if>
 * @since ${date}
 */
<#if entityLombokModel>
@Data
    <#if superEntityClass??>
@EqualsAndHashCode(callSuper = true)
    <#else>
@EqualsAndHashCode(callSuper = false)
    </#if>
@Accessors(chain = true)
</#if>
<#if table.convert>
@TableName("${table.name}")
</#if>
<#if swagger2>
@ApiModel(value="${entity}对象", description="${table.comment!}")
</#if>
<#if superEntityClass??>
public class ${entity} extends ${superEntityClass}<#if activeRecord><${entity}></#if> {
<#elseif activeRecord>
public class ${entity} extends Model<${entity}> {
<#else>
public class ${entity} implements Serializable {
</#if>

<#if entitySerialVersionUID>
    private static final long serialVersionUID = 1L;
</#if>
<#-- ----------  BEGIN 字段循环遍历  ---------->
<#list table.fields as field>
    <#if field.keyFlag>
        <#assign keyPropertyName="${field.propertyName}"/>
    </#if>
	<#assign propertyName>${cfg.cgUtil.getPropertyName(cfg.boEntList,table.name,field.name,field.propertyName)}</#assign>
    <#if propertyName == "tenantId">
        <#continue>
    </#if>
    <#if field.comment!?length gt 0>
        <#if swagger2>
    @ApiModelProperty(value = "${field.comment}")
        <#else>
    /**
     * ${field.comment}
     */
        </#if>
    </#if>
    <#if field.keyFlag>
        <#-- 主键 -->
        <#if field.keyIdentityFlag>
    @TableId(value = "${field.name}", type = IdType.AUTO)
        <#elseif idType??>
    @TableId(value = "${field.name}", type = IdType.${idType})
        <#elseif field.convert>
    @TableId("${field.name}")
        </#if>
        <#-- 普通字段 -->
    <#elseif field.fill??>
    <#-- -----   存在字段填充设置   ----->
        <#if field.convert>
    @TableField(value = "${field.name}", fill = FieldFill.${field.fill})
        <#else>
    @TableField(fill = FieldFill.${field.fill})
        </#if>
    <#else>
    @TableField("${field.name}")
    </#if>
    <#-- 乐观锁注解 -->
    <#if (versionFieldName!"") == field.name>
    @Version
    </#if>
    <#-- 逻辑删除注解 -->
    <#if (logicDeleteFieldName!"") == field.name>
    @TableLogic
    </#if>
    @JsonProperty("${propertyName}")
    private ${field.propertyType} ${propertyName};
    
</#list>
<#------------  END 字段循环遍历  ---------->

<#------------  子表属性  ---------->
<#if cfg.boEntList?exists>
	<#list cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name) as subModel>
	@ApiModelProperty(value = "${subModel.comment}")
	@TableField(exist = false)
    private List<${subModel.className}> ${subModel.propertyName};
    
	</#list>
</#if>
<#------------ END 子表属性  ---------->

<#if !entityLombokModel>
    <#list table.fields as field>
        <#if field.propertyType == "boolean">
            <#assign getprefix="is"/>
        <#else>
            <#assign getprefix="get"/>
        </#if>
        <#assign propertyName>${cfg.cgUtil.getPropertyName(cfg.boEntList,table.name,field.name,field.propertyName)}</#assign>
        <#if propertyName == "tenantId">
            <#continue>
        </#if>
    public ${field.propertyType} ${getprefix}${propertyName?cap_first}() {
        return ${propertyName};
    }

    <#if entityBuilderModel>
    public ${entity} set${propertyName?cap_first}(${field.propertyType} ${propertyName}) {
    <#else>
    public void set${propertyName?cap_first}(${field.propertyType} ${propertyName}) {
    </#if>
        this.${propertyName} = ${propertyName};
        <#if entityBuilderModel>
        return this;
        </#if>
    }
    </#list>
</#if>

<#------------  子表get/set方法  ---------->
<#if cfg.boEntList?exists>
	<#list cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name) as subModel>
  	/**
     * get ${subModel.comment}数据
     * @return
     */
    public List<${subModel.className}> get${subModel.propertyName?cap_first}(){
        return this.${subModel.propertyName};
    }
    /**
     * set ${subModel.comment}数据
     * @param ${subModel.propertyName}
     */
    public void set${subModel.propertyName?cap_first}(List<${subModel.className}> ${subModel.propertyName}){
       this.${subModel.propertyName} = ${subModel.propertyName};
    }
	</#list>
</#if>
<#------------  END 子表get/set方法  ---------->

<#if entityColumnConstant>
    <#list table.fields as field>
    public static final String ${field.name?upper_case} = "${field.name}";

    </#list>
</#if>
<#if activeRecord>
    @Override
    protected Serializable pkVal() {
    <#if keyPropertyName??>
        return this.${keyPropertyName};
    <#else>
        return null;
    </#if>
    }

</#if>
<#if !entityLombokModel>
    @Override
    public String toString() {
        return "${entity}{" +
    <#list table.fields as field>
    <#assign propertyName>${cfg.cgUtil.getPropertyName(cfg.boEntList,table.name,field.name,field.propertyName)}</#assign>
        <#if propertyName == "tenantId">
            <#continue>
        </#if>
        <#if field_index==0>
            "${propertyName}=" + ${propertyName} +
        <#else>
            ", ${propertyName}=" + ${propertyName} +
        </#if>
    </#list>
        "}";
    }
</#if>
}
